/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { inject, InjectionToken } from '@angular/core';
import { BREAKPOINT } from '../tokens/breakpoint-token';
import { DEFAULT_BREAKPOINTS } from '../breakpoints/data/break-points';
import { ORIENTATION_BREAKPOINTS } from '../breakpoints/data/orientation-break-points';
import { mergeByAlias } from '../breakpoints/breakpoint-tools';
import { LAYOUT_CONFIG } from '../tokens/library-config';
/**
 *  Injection token unique to the flex-layout library.
 *  Use this token when build a custom provider (see below).
 */
export const BREAKPOINTS = new InjectionToken('Token (@angular/flex-layout) Breakpoints', {
    providedIn: 'root',
    factory: () => {
        const breakpoints = inject(BREAKPOINT);
        const layoutConfig = inject(LAYOUT_CONFIG);
        const bpFlattenArray = [].concat.apply([], (breakpoints || [])
            .map((v) => Array.isArray(v) ? v : [v]));
        const builtIns = (layoutConfig.disableDefaultBps ? [] : DEFAULT_BREAKPOINTS)
            .concat(layoutConfig.addOrientationBps ? ORIENTATION_BREAKPOINTS : []);
        return mergeByAlias(builtIns, bpFlattenArray);
    }
});
//# sourceMappingURL=data:application/json;base64,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