import { TestBed } from '@angular/core/testing';
import { By } from '@angular/platform-browser';
import { extendObject } from '@angular/flex-layout/_private-utils';
/**
 * Function generator that captures a Component Type accessor and enables
 * `createTestComponent()` to be reusable for *any* captured Component class.
 */
export function makeCreateTestComponent(getClass) {
    let componentAny;
    // Return actual `createTestComponent()` function
    return function createTestComponent(template, styles) {
        if (!componentAny) {
            // Defer access to Component class to enable metadata to be configured properly...
            componentAny = getClass();
        }
        return TestBed
            .overrideComponent(componentAny, {
            set: {
                template: template,
                styles: styles || [],
            }
        })
            .createComponent(componentAny);
    };
}
/**
 *
 */
export function expectNativeEl(fixture, instanceOptions) {
    extendObject(fixture.componentInstance, instanceOptions || {});
    fixture.detectChanges();
    return expect(fixture.debugElement.children[0].nativeElement);
}
/**
 *
 */
export function expectEl(debugEl) {
    return expect(debugEl.nativeElement);
}
export function queryFor(fixture, selector) {
    return fixture.debugElement.queryAll(By.css(selector));
}
//# sourceMappingURL=data:application/json;base64,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