/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { getLView } from '../render3/state';
import { removeLViewOnDestroy, storeLViewOnDestroy } from '../render3/util/view_utils';
/**
 * `DestroyRef` lets you set callbacks to run for any cleanup or destruction behavior.
 * The scope of this destruction depends on where `DestroyRef` is injected. If `DestroyRef`
 * is injected in a component or directive, the callbacks run when that component or
 * directive is destroyed. Otherwise the callbacks run when a corresponding injector is destroyed.
 *
 * @publicApi
 */
class DestroyRef {
    /**
     * @internal
     * @nocollapse
     */
    static { this.__NG_ELEMENT_ID__ = injectDestroyRef; }
    /**
     * @internal
     * @nocollapse
     */
    static { this.__NG_ENV_ID__ = (injector) => injector; }
}
export { DestroyRef };
class NodeInjectorDestroyRef extends DestroyRef {
    constructor(_lView) {
        super();
        this._lView = _lView;
    }
    onDestroy(callback) {
        storeLViewOnDestroy(this._lView, callback);
        return () => removeLViewOnDestroy(this._lView, callback);
    }
}
function injectDestroyRef() {
    return new NodeInjectorDestroyRef(getLView());
}
//# sourceMappingURL=data:application/json;base64,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