/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
export { ALLOW_MULTIPLE_PLATFORMS as ɵALLOW_MULTIPLE_PLATFORMS, internalCreateApplication as ɵinternalCreateApplication } from './application_ref';
export { ENABLED_SSR_FEATURES as ɵENABLED_SSR_FEATURES } from './application_tokens';
export { defaultIterableDiffers as ɵdefaultIterableDiffers, defaultKeyValueDiffers as ɵdefaultKeyValueDiffers } from './change_detection/change_detection';
export { Console as ɵConsole } from './console';
export { convertToBitFlags as ɵconvertToBitFlags, setCurrentInjector as ɵsetCurrentInjector } from './di/injector_compatibility';
export { getInjectableDef as ɵgetInjectableDef } from './di/interface/defs';
export { isEnvironmentProviders as ɵisEnvironmentProviders } from './di/interface/provider';
export { INJECTOR_SCOPE as ɵINJECTOR_SCOPE } from './di/scope';
export { XSS_SECURITY_URL as ɵXSS_SECURITY_URL } from './error_details_base_url';
export { formatRuntimeError as ɵformatRuntimeError, RuntimeError as ɵRuntimeError } from './errors';
export { annotateForHydration as ɵannotateForHydration } from './hydration/annotate';
export { withDomHydration as ɵwithDomHydration } from './hydration/api';
export { IS_HYDRATION_DOM_REUSE_ENABLED as ɵIS_HYDRATION_DOM_REUSE_ENABLED } from './hydration/tokens';
export { findLocaleData as ɵfindLocaleData, getLocaleCurrencyCode as ɵgetLocaleCurrencyCode, getLocalePluralCase as ɵgetLocalePluralCase, LocaleDataIndex as ɵLocaleDataIndex, registerLocaleData as ɵregisterLocaleData, unregisterAllLocaleData as ɵunregisterLocaleData } from './i18n/locale_data_api';
export { DEFAULT_LOCALE_ID as ɵDEFAULT_LOCALE_ID } from './i18n/localization';
export { InitialRenderPendingTasks as ɵInitialRenderPendingTasks } from './initial_render_pending_tasks';
export { ComponentFactory as ɵComponentFactory } from './linker/component_factory';
export { clearResolutionOfComponentResourcesQueue as ɵclearResolutionOfComponentResourcesQueue, resolveComponentResources as ɵresolveComponentResources } from './metadata/resource_loading';
export { ReflectionCapabilities as ɵReflectionCapabilities } from './reflection/reflection_capabilities';
export { allowSanitizationBypassAndThrow as ɵallowSanitizationBypassAndThrow, getSanitizationBypassType as ɵgetSanitizationBypassType, unwrapSafeValue as ɵunwrapSafeValue } from './sanitization/bypass';
export { _sanitizeHtml as ɵ_sanitizeHtml } from './sanitization/html_sanitizer';
export { _sanitizeUrl as ɵ_sanitizeUrl } from './sanitization/url_sanitizer';
export { setAlternateWeakRefImpl as ɵsetAlternateWeakRefImpl } from './signals';
export { TESTABILITY as ɵTESTABILITY, TESTABILITY_GETTER as ɵTESTABILITY_GETTER } from './testability/testability';
export { coerceToBoolean as ɵcoerceToBoolean } from './util/coercion';
export { devModeEqual as ɵdevModeEqual } from './util/comparison';
export { global as ɵglobal } from './util/global';
export { isPromise as ɵisPromise, isSubscribable as ɵisSubscribable } from './util/lang';
export { stringify as ɵstringify } from './util/stringify';
export { NOT_FOUND_CHECK_ONLY_ELEMENT_INJECTOR as ɵNOT_FOUND_CHECK_ONLY_ELEMENT_INJECTOR } from './view/provider_flags';
//# sourceMappingURL=data:application/json;base64,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