/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
/**
 * @module
 * @description
 * Entry point from which you should import all public core APIs.
 */
export * from './metadata';
export * from './version';
export * from './di';
export { createPlatform, assertPlatform, destroyPlatform, getPlatform, PlatformRef, ApplicationRef, provideZoneChangeDetection, createPlatformFactory, NgProbeToken, APP_BOOTSTRAP_LISTENER } from './application_ref';
export { enableProdMode, isDevMode } from './util/is_dev_mode';
export { APP_ID, PACKAGE_ROOT_URL, PLATFORM_INITIALIZER, PLATFORM_ID, ANIMATION_MODULE_TYPE, CSP_NONCE } from './application_tokens';
export { APP_INITIALIZER, ApplicationInitStatus } from './application_init';
export * from './zone';
export * from './render';
export * from './linker';
export * from './linker/ng_module_factory_loader_impl';
export { DebugElement, DebugEventListener, DebugNode, asNativeElements, getDebugNode } from './debug/debug_node';
export { Testability, TestabilityRegistry, setTestabilityGetter } from './testability/testability';
export * from './change_detection';
export * from './platform_core_providers';
export { TRANSLATIONS, TRANSLATIONS_FORMAT, LOCALE_ID, DEFAULT_CURRENCY_CODE, MissingTranslationStrategy } from './i18n/tokens';
export { ApplicationModule } from './application_module';
export { Type } from './interface/type';
export { EventEmitter } from './event_emitter';
export { ErrorHandler } from './error_handler';
export * from './core_private_export';
export * from './core_render3_private_export';
export * from './core_reactivity_export';
export { SecurityContext } from './sanitization/security';
export { Sanitizer } from './sanitization/sanitizer';
export { createNgModule, createNgModuleRef, createEnvironmentInjector } from './render3/ng_module_ref';
export { createComponent, reflectComponentType } from './render3/component';
export { isStandalone } from './render3/definition';
export { mergeApplicationConfig } from './application_config';
export { makeStateKey, TransferState } from './transfer_state';
import { global } from './util/global';
if (typeof ngDevMode !== 'undefined' && ngDevMode) {
    // This helper is to give a reasonable error message to people upgrading to v9 that have not yet
    // installed `@angular/localize` in their app.
    // tslint:disable-next-line: no-toplevel-property-access
    global.$localize = global.$localize || function () {
        throw new Error('It looks like your application or one of its dependencies is using i18n.\n' +
            'Angular 9 introduced a global `$localize()` function that needs to be loaded.\n' +
            'Please run `ng add @angular/localize` from the Angular CLI.\n' +
            '(For non-CLI projects, add `import \'@angular/localize/init\';` to your `polyfills.ts` file.\n' +
            'For server-side rendering applications add the import to your `main.server.ts` file.)');
    };
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY29yZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uLy4uLy4uL3BhY2thZ2VzL2NvcmUvc3JjL2NvcmUudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7Ozs7OztHQU1HO0FBRUg7Ozs7R0FJRztBQUNILGNBQWMsWUFBWSxDQUFDO0FBQzNCLGNBQWMsV0FBVyxDQUFDO0FBRTFCLGNBQWMsTUFBTSxDQUFDO0FBQ3JCLE9BQU8sRUFBQyxjQUFjLEVBQUUsY0FBYyxFQUFFLGVBQWUsRUFBRSxXQUFXLEVBQW1DLFdBQVcsRUFBRSxjQUFjLEVBQUUsMEJBQTBCLEVBQUUscUJBQXFCLEVBQUUsWUFBWSxFQUFFLHNCQUFzQixFQUFDLE1BQU0sbUJBQW1CLENBQUM7QUFDdFAsT0FBTyxFQUFDLGNBQWMsRUFBRSxTQUFTLEVBQUMsTUFBTSxvQkFBb0IsQ0FBQztBQUM3RCxPQUFPLEVBQUMsTUFBTSxFQUFFLGdCQUFnQixFQUFFLG9CQUFvQixFQUFFLFdBQVcsRUFBRSxxQkFBcUIsRUFBRSxTQUFTLEVBQUMsTUFBTSxzQkFBc0IsQ0FBQztBQUNuSSxPQUFPLEVBQUMsZUFBZSxFQUFFLHFCQUFxQixFQUFDLE1BQU0sb0JBQW9CLENBQUM7QUFDMUUsY0FBYyxRQUFRLENBQUM7QUFDdkIsY0FBYyxVQUFVLENBQUM7QUFDekIsY0FBYyxVQUFVLENBQUM7QUFDekIsY0FBYyx3Q0FBd0MsQ0FBQztBQUN2RCxPQUFPLEVBQUMsWUFBWSxFQUFFLGtCQUFrQixFQUFFLFNBQVMsRUFBRSxnQkFBZ0IsRUFBRSxZQUFZLEVBQVksTUFBTSxvQkFBb0IsQ0FBQztBQUMxSCxPQUFPLEVBQWlCLFdBQVcsRUFBRSxtQkFBbUIsRUFBRSxvQkFBb0IsRUFBQyxNQUFNLDJCQUEyQixDQUFDO0FBQ2pILGNBQWMsb0JBQW9CLENBQUM7QUFDbkMsY0FBYywyQkFBMkIsQ0FBQztBQUMxQyxPQUFPLEVBQUMsWUFBWSxFQUFFLG1CQUFtQixFQUFFLFNBQVMsRUFBRSxxQkFBcUIsRUFBRSwwQkFBMEIsRUFBQyxNQUFNLGVBQWUsQ0FBQztBQUM5SCxPQUFPLEVBQUMsaUJBQWlCLEVBQUMsTUFBTSxzQkFBc0IsQ0FBQztBQUN2RCxPQUFPLEVBQWUsSUFBSSxFQUFDLE1BQU0sa0JBQWtCLENBQUM7QUFDcEQsT0FBTyxFQUFDLFlBQVksRUFBQyxNQUFNLGlCQUFpQixDQUFDO0FBQzdDLE9BQU8sRUFBQyxZQUFZLEVBQUMsTUFBTSxpQkFBaUIsQ0FBQztBQUM3QyxjQUFjLHVCQUF1QixDQUFDO0FBQ3RDLGNBQWMsK0JBQStCLENBQUM7QUFDOUMsY0FBYywwQkFBMEIsQ0FBQztBQUN6QyxPQUFPLEVBQUMsZUFBZSxFQUFDLE1BQU0seUJBQXlCLENBQUM7QUFDeEQsT0FBTyxFQUFDLFNBQVMsRUFBQyxNQUFNLDBCQUEwQixDQUFDO0FBQ25ELE9BQU8sRUFBQyxjQUFjLEVBQUUsaUJBQWlCLEVBQUUseUJBQXlCLEVBQUMsTUFBTSx5QkFBeUIsQ0FBQztBQUNyRyxPQUFPLEVBQUMsZUFBZSxFQUFFLG9CQUFvQixFQUFrQixNQUFNLHFCQUFxQixDQUFDO0FBQzNGLE9BQU8sRUFBQyxZQUFZLEVBQUMsTUFBTSxzQkFBc0IsQ0FBQztBQUNsRCxPQUFPLEVBQW9CLHNCQUFzQixFQUFDLE1BQU0sc0JBQXNCLENBQUM7QUFDL0UsT0FBTyxFQUFDLFlBQVksRUFBWSxhQUFhLEVBQUMsTUFBTSxrQkFBa0IsQ0FBQztBQUV2RSxPQUFPLEVBQUMsTUFBTSxFQUFDLE1BQU0sZUFBZSxDQUFDO0FBQ3JDLElBQUksT0FBTyxTQUFTLEtBQUssV0FBVyxJQUFJLFNBQVMsRUFBRTtJQUNqRCxnR0FBZ0c7SUFDaEcsOENBQThDO0lBQzlDLHdEQUF3RDtJQUN4RCxNQUFNLENBQUMsU0FBUyxHQUFHLE1BQU0sQ0FBQyxTQUFTLElBQUk7UUFDckMsTUFBTSxJQUFJLEtBQUssQ0FDWCw0RUFBNEU7WUFDNUUsaUZBQWlGO1lBQ2pGLCtEQUErRDtZQUMvRCxnR0FBZ0c7WUFDaEcsdUZBQXVGLENBQUMsQ0FBQztJQUMvRixDQUFDLENBQUM7Q0FDSCIsInNvdXJjZXNDb250ZW50IjpbIi8qKlxuICogQGxpY2Vuc2VcbiAqIENvcHlyaWdodCBHb29nbGUgTExDIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG4gKlxuICogVXNlIG9mIHRoaXMgc291cmNlIGNvZGUgaXMgZ292ZXJuZWQgYnkgYW4gTUlULXN0eWxlIGxpY2Vuc2UgdGhhdCBjYW4gYmVcbiAqIGZvdW5kIGluIHRoZSBMSUNFTlNFIGZpbGUgYXQgaHR0cHM6Ly9hbmd1bGFyLmlvL2xpY2Vuc2VcbiAqL1xuXG4vKipcbiAqIEBtb2R1bGVcbiAqIEBkZXNjcmlwdGlvblxuICogRW50cnkgcG9pbnQgZnJvbSB3aGljaCB5b3Ugc2hvdWxkIGltcG9ydCBhbGwgcHVibGljIGNvcmUgQVBJcy5cbiAqL1xuZXhwb3J0ICogZnJvbSAnLi9tZXRhZGF0YSc7XG5leHBvcnQgKiBmcm9tICcuL3ZlcnNpb24nO1xuZXhwb3J0IHtUeXBlRGVjb3JhdG9yfSBmcm9tICcuL3V0aWwvZGVjb3JhdG9ycyc7XG5leHBvcnQgKiBmcm9tICcuL2RpJztcbmV4cG9ydCB7Y3JlYXRlUGxhdGZvcm0sIGFzc2VydFBsYXRmb3JtLCBkZXN0cm95UGxhdGZvcm0sIGdldFBsYXRmb3JtLCBCb290c3RyYXBPcHRpb25zLCBOZ1pvbmVPcHRpb25zLCBQbGF0Zm9ybVJlZiwgQXBwbGljYXRpb25SZWYsIHByb3ZpZGVab25lQ2hhbmdlRGV0ZWN0aW9uLCBjcmVhdGVQbGF0Zm9ybUZhY3RvcnksIE5nUHJvYmVUb2tlbiwgQVBQX0JPT1RTVFJBUF9MSVNURU5FUn0gZnJvbSAnLi9hcHBsaWNhdGlvbl9yZWYnO1xuZXhwb3J0IHtlbmFibGVQcm9kTW9kZSwgaXNEZXZNb2RlfSBmcm9tICcuL3V0aWwvaXNfZGV2X21vZGUnO1xuZXhwb3J0IHtBUFBfSUQsIFBBQ0tBR0VfUk9PVF9VUkwsIFBMQVRGT1JNX0lOSVRJQUxJWkVSLCBQTEFURk9STV9JRCwgQU5JTUFUSU9OX01PRFVMRV9UWVBFLCBDU1BfTk9OQ0V9IGZyb20gJy4vYXBwbGljYXRpb25fdG9rZW5zJztcbmV4cG9ydCB7QVBQX0lOSVRJQUxJWkVSLCBBcHBsaWNhdGlvbkluaXRTdGF0dXN9IGZyb20gJy4vYXBwbGljYXRpb25faW5pdCc7XG5leHBvcnQgKiBmcm9tICcuL3pvbmUnO1xuZXhwb3J0ICogZnJvbSAnLi9yZW5kZXInO1xuZXhwb3J0ICogZnJvbSAnLi9saW5rZXInO1xuZXhwb3J0ICogZnJvbSAnLi9saW5rZXIvbmdfbW9kdWxlX2ZhY3RvcnlfbG9hZGVyX2ltcGwnO1xuZXhwb3J0IHtEZWJ1Z0VsZW1lbnQsIERlYnVnRXZlbnRMaXN0ZW5lciwgRGVidWdOb2RlLCBhc05hdGl2ZUVsZW1lbnRzLCBnZXREZWJ1Z05vZGUsIFByZWRpY2F0ZX0gZnJvbSAnLi9kZWJ1Zy9kZWJ1Z19ub2RlJztcbmV4cG9ydCB7R2V0VGVzdGFiaWxpdHksIFRlc3RhYmlsaXR5LCBUZXN0YWJpbGl0eVJlZ2lzdHJ5LCBzZXRUZXN0YWJpbGl0eUdldHRlcn0gZnJvbSAnLi90ZXN0YWJpbGl0eS90ZXN0YWJpbGl0eSc7XG5leHBvcnQgKiBmcm9tICcuL2NoYW5nZV9kZXRlY3Rpb24nO1xuZXhwb3J0ICogZnJvbSAnLi9wbGF0Zm9ybV9jb3JlX3Byb3ZpZGVycyc7XG5leHBvcnQge1RSQU5TTEFUSU9OUywgVFJBTlNMQVRJT05TX0ZPUk1BVCwgTE9DQUxFX0lELCBERUZBVUxUX0NVUlJFTkNZX0NPREUsIE1pc3NpbmdUcmFuc2xhdGlvblN0cmF0ZWd5fSBmcm9tICcuL2kxOG4vdG9rZW5zJztcbmV4cG9ydCB7QXBwbGljYXRpb25Nb2R1bGV9IGZyb20gJy4vYXBwbGljYXRpb25fbW9kdWxlJztcbmV4cG9ydCB7QWJzdHJhY3RUeXBlLCBUeXBlfSBmcm9tICcuL2ludGVyZmFjZS90eXBlJztcbmV4cG9ydCB7RXZlbnRFbWl0dGVyfSBmcm9tICcuL2V2ZW50X2VtaXR0ZXInO1xuZXhwb3J0IHtFcnJvckhhbmRsZXJ9IGZyb20gJy4vZXJyb3JfaGFuZGxlcic7XG5leHBvcnQgKiBmcm9tICcuL2NvcmVfcHJpdmF0ZV9leHBvcnQnO1xuZXhwb3J0ICogZnJvbSAnLi9jb3JlX3JlbmRlcjNfcHJpdmF0ZV9leHBvcnQnO1xuZXhwb3J0ICogZnJvbSAnLi9jb3JlX3JlYWN0aXZpdHlfZXhwb3J0JztcbmV4cG9ydCB7U2VjdXJpdHlDb250ZXh0fSBmcm9tICcuL3Nhbml0aXphdGlvbi9zZWN1cml0eSc7XG5leHBvcnQge1Nhbml0aXplcn0gZnJvbSAnLi9zYW5pdGl6YXRpb24vc2FuaXRpemVyJztcbmV4cG9ydCB7Y3JlYXRlTmdNb2R1bGUsIGNyZWF0ZU5nTW9kdWxlUmVmLCBjcmVhdGVFbnZpcm9ubWVudEluamVjdG9yfSBmcm9tICcuL3JlbmRlcjMvbmdfbW9kdWxlX3JlZic7XG5leHBvcnQge2NyZWF0ZUNvbXBvbmVudCwgcmVmbGVjdENvbXBvbmVudFR5cGUsIENvbXBvbmVudE1pcnJvcn0gZnJvbSAnLi9yZW5kZXIzL2NvbXBvbmVudCc7XG5leHBvcnQge2lzU3RhbmRhbG9uZX0gZnJvbSAnLi9yZW5kZXIzL2RlZmluaXRpb24nO1xuZXhwb3J0IHtBcHBsaWNhdGlvbkNvbmZpZywgbWVyZ2VBcHBsaWNhdGlvbkNvbmZpZ30gZnJvbSAnLi9hcHBsaWNhdGlvbl9jb25maWcnO1xuZXhwb3J0IHttYWtlU3RhdGVLZXksIFN0YXRlS2V5LCBUcmFuc2ZlclN0YXRlfSBmcm9tICcuL3RyYW5zZmVyX3N0YXRlJztcblxuaW1wb3J0IHtnbG9iYWx9IGZyb20gJy4vdXRpbC9nbG9iYWwnO1xuaWYgKHR5cGVvZiBuZ0Rldk1vZGUgIT09ICd1bmRlZmluZWQnICYmIG5nRGV2TW9kZSkge1xuICAvLyBUaGlzIGhlbHBlciBpcyB0byBnaXZlIGEgcmVhc29uYWJsZSBlcnJvciBtZXNzYWdlIHRvIHBlb3BsZSB1cGdyYWRpbmcgdG8gdjkgdGhhdCBoYXZlIG5vdCB5ZXRcbiAgLy8gaW5zdGFsbGVkIGBAYW5ndWxhci9sb2NhbGl6ZWAgaW4gdGhlaXIgYXBwLlxuICAvLyB0c2xpbnQ6ZGlzYWJsZS1uZXh0LWxpbmU6IG5vLXRvcGxldmVsLXByb3BlcnR5LWFjY2Vzc1xuICBnbG9iYWwuJGxvY2FsaXplID0gZ2xvYmFsLiRsb2NhbGl6ZSB8fCBmdW5jdGlvbigpIHtcbiAgICB0aHJvdyBuZXcgRXJyb3IoXG4gICAgICAgICdJdCBsb29rcyBsaWtlIHlvdXIgYXBwbGljYXRpb24gb3Igb25lIG9mIGl0cyBkZXBlbmRlbmNpZXMgaXMgdXNpbmcgaTE4bi5cXG4nICtcbiAgICAgICAgJ0FuZ3VsYXIgOSBpbnRyb2R1Y2VkIGEgZ2xvYmFsIGAkbG9jYWxpemUoKWAgZnVuY3Rpb24gdGhhdCBuZWVkcyB0byBiZSBsb2FkZWQuXFxuJyArXG4gICAgICAgICdQbGVhc2UgcnVuIGBuZyBhZGQgQGFuZ3VsYXIvbG9jYWxpemVgIGZyb20gdGhlIEFuZ3VsYXIgQ0xJLlxcbicgK1xuICAgICAgICAnKEZvciBub24tQ0xJIHByb2plY3RzLCBhZGQgYGltcG9ydCBcXCdAYW5ndWxhci9sb2NhbGl6ZS9pbml0XFwnO2AgdG8geW91ciBgcG9seWZpbGxzLnRzYCBmaWxlLlxcbicgK1xuICAgICAgICAnRm9yIHNlcnZlci1zaWRlIHJlbmRlcmluZyBhcHBsaWNhdGlvbnMgYWRkIHRoZSBpbXBvcnQgdG8geW91ciBgbWFpbi5zZXJ2ZXIudHNgIGZpbGUuKScpO1xuICB9O1xufVxuIl19