/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
/**
 * Marker symbol for `ConsumesSlotOpTrait`.
 */
export const ConsumesSlot = Symbol('ConsumesSlot');
/**
 * Marker symbol for `DependsOnSlotContextOpTrait`.
 */
export const DependsOnSlotContext = Symbol('DependsOnSlotContext');
/**
 * Marker symbol for `UsesSlotIndex` trait.
 */
export const UsesSlotIndex = Symbol('UsesSlotIndex');
/**
 * Marker symbol for `ConsumesVars` trait.
 */
export const ConsumesVarsTrait = Symbol('UsesVars');
/**
 * Default values for most `ConsumesSlotOpTrait` fields (used with the spread operator to initialize
 * implementors of the trait).
 */
export const TRAIT_CONSUMES_SLOT = {
    [ConsumesSlot]: true,
    slot: null,
    numSlotsUsed: 1,
};
/**
 * Default values for most `UsesSlotIndexTrait` fields (used with the spread operator to initialize
 * implementors of the trait).
 */
export const TRAIT_USES_SLOT_INDEX = {
    [UsesSlotIndex]: true,
    slot: null,
};
/**
 * Default values for most `DependsOnSlotContextOpTrait` fields (used with the spread operator to
 * initialize implementors of the trait).
 */
export const TRAIT_DEPENDS_ON_SLOT_CONTEXT = {
    [DependsOnSlotContext]: true,
};
/**
 * Default values for `UsesVars` fields (used with the spread operator to initialize
 * implementors of the trait).
 */
export const TRAIT_CONSUMES_VARS = {
    [ConsumesVarsTrait]: true,
};
/**
 * Test whether an operation implements `ConsumesSlotOpTrait`.
 */
export function hasConsumesSlotTrait(op) {
    return op[ConsumesSlot] === true;
}
/**
 * Test whether an operation implements `DependsOnSlotContextOpTrait`.
 */
export function hasDependsOnSlotContextTrait(op) {
    return op[DependsOnSlotContext] === true;
}
export function hasConsumesVarsTrait(value) {
    return value[ConsumesVarsTrait] === true;
}
export function hasUsesSlotIndexTrait(value) {
    return value[UsesSlotIndex] === true;
}
//# sourceMappingURL=data:application/json;base64,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