/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { OpKind } from '../enums';
import { TRAIT_CONSUMES_VARS, TRAIT_DEPENDS_ON_SLOT_CONTEXT } from '../traits';
import { NEW_OP } from './shared';
/**
 * Create an `InterpolationTextOp`.
 */
export function createInterpolateTextOp(xref, strings, expressions) {
    return {
        kind: OpKind.InterpolateText,
        target: xref,
        strings,
        expressions,
        ...TRAIT_DEPENDS_ON_SLOT_CONTEXT,
        ...TRAIT_CONSUMES_VARS,
        ...NEW_OP,
    };
}
/**
 * Create a `PropertyOp`.
 */
export function createPropertyOp(xref, name, expression) {
    return {
        kind: OpKind.Property,
        target: xref,
        name,
        expression,
        ...TRAIT_DEPENDS_ON_SLOT_CONTEXT,
        ...TRAIT_CONSUMES_VARS,
        ...NEW_OP,
    };
}
/**
 * Create an `AdvanceOp`.
 */
export function createAdvanceOp(delta) {
    return {
        kind: OpKind.Advance,
        delta,
        ...NEW_OP,
    };
}
//# sourceMappingURL=data:application/json;base64,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