/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { ElementAttributes } from '../element';
import { OpKind } from '../enums';
import { OpList } from '../operations';
import { TRAIT_CONSUMES_SLOT, TRAIT_USES_SLOT_INDEX } from '../traits';
import { NEW_OP } from './shared';
/**
 * Create an `ElementStartOp`.
 */
export function createElementStartOp(tag, xref) {
    return {
        kind: OpKind.ElementStart,
        xref,
        tag,
        attributes: new ElementAttributes(),
        localRefs: [],
        ...TRAIT_CONSUMES_SLOT,
        ...NEW_OP,
    };
}
/**
 * Create a `TemplateOp`.
 */
export function createTemplateOp(xref, tag) {
    return {
        kind: OpKind.Template,
        xref,
        attributes: new ElementAttributes(),
        tag,
        decls: null,
        vars: null,
        localRefs: [],
        ...TRAIT_CONSUMES_SLOT,
        ...NEW_OP,
    };
}
/**
 * Create an `ElementEndOp`.
 */
export function createElementEndOp(xref) {
    return {
        kind: OpKind.ElementEnd,
        xref,
        ...NEW_OP,
    };
}
/**
 * Create a `TextOp`.
 */
export function createTextOp(xref, initialValue) {
    return {
        kind: OpKind.Text,
        xref,
        initialValue,
        ...TRAIT_CONSUMES_SLOT,
        ...NEW_OP,
    };
}
/**
 * Create a `ListenerOp`.
 */
export function createListenerOp(target, name, tag) {
    return {
        kind: OpKind.Listener,
        target,
        tag,
        name,
        handlerOps: new OpList(),
        handlerFnName: null,
        ...NEW_OP,
        ...TRAIT_USES_SLOT_INDEX,
    };
}
//# sourceMappingURL=data:application/json;base64,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