export const LIMIT_TIMES = {
    minHour: 0,
    maxHour: 24,
    minMinute: 0,
    maxMinute: 60,
    minSecond: 0,
    maxSecond: 60,
    meridian: 12
};
export const MERIDIANS = {
    AM: 'AM',
    PM: 'PM'
};
export const DEFAULT_STEP = 1;
export const NUMERIC_REGEX = /[^0-9]/g;
export const PATTERN_INPUT_HOUR = /^(2[0-3]|[0-1][0-9]|[0-9])$/;
export const PATTERN_INPUT_MINUTE = /^([0-5][0-9]|[0-9])$/;
export const PATTERN_INPUT_SECOND = /^([0-5][0-9]|[0-9])$/;
export function formatTwoDigitTimeValue(val) {
    const txt = val.toString();
    return txt.length > 1 ? txt : `0${txt}`;
}
export function createMissingDateImplError(provider) {
    return Error(`NgxMatDatetimePicker: No provider found for ${provider}. You must import one of the following ` +
        `modules at your application root: NgxMatNativeDateModule, NgxMatMomentModule, or provide a ` +
        `custom implementation.`);
}
/** Formats a range of years. */
export function formatYearRange(start, end) {
    return `${start} \u2013 ${end}`;
}
//# sourceMappingURL=data:application/json;base64,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