import { Injectable, InjectionToken, Optional, SkipSelf } from '@angular/core';
import { NgxMatDateAdapter } from './core/date-adapter';
import { NgxDateRange } from './date-selection-model';
import * as i0 from "@angular/core";
import * as i1 from "./core/date-adapter";
/** Injection token used to customize the date range selection behavior. */
export const NGX_MAT_DATE_RANGE_SELECTION_STRATEGY = new InjectionToken('NGX_MAT_DATE_RANGE_SELECTION_STRATEGY');
/** Provides the default date range selection behavior. */
export class DefaultNgxMatCalendarRangeStrategy {
    constructor(_dateAdapter) {
        this._dateAdapter = _dateAdapter;
    }
    selectionFinished(date, currentRange) {
        let { start, end } = currentRange;
        if (start == null) {
            start = date;
        }
        else if (end == null && date && this._dateAdapter.compareDate(date, start) >= 0) {
            end = date;
        }
        else {
            start = date;
            end = null;
        }
        return new NgxDateRange(start, end);
    }
    createPreview(activeDate, currentRange) {
        let start = null;
        let end = null;
        if (currentRange.start && !currentRange.end && activeDate) {
            start = currentRange.start;
            end = activeDate;
        }
        return new NgxDateRange(start, end);
    }
    createDrag(dragOrigin, originalRange, newDate) {
        let start = originalRange.start;
        let end = originalRange.end;
        if (!start || !end) {
            // Can't drag from an incomplete range.
            return null;
        }
        const adapter = this._dateAdapter;
        const isRange = adapter.compareDate(start, end) !== 0;
        const diffYears = adapter.getYear(newDate) - adapter.getYear(dragOrigin);
        const diffMonths = adapter.getMonth(newDate) - adapter.getMonth(dragOrigin);
        const diffDays = adapter.getDate(newDate) - adapter.getDate(dragOrigin);
        if (isRange && adapter.sameDate(dragOrigin, originalRange.start)) {
            start = newDate;
            if (adapter.compareDate(newDate, end) > 0) {
                end = adapter.addCalendarYears(end, diffYears);
                end = adapter.addCalendarMonths(end, diffMonths);
                end = adapter.addCalendarDays(end, diffDays);
            }
        }
        else if (isRange && adapter.sameDate(dragOrigin, originalRange.end)) {
            end = newDate;
            if (adapter.compareDate(newDate, start) < 0) {
                start = adapter.addCalendarYears(start, diffYears);
                start = adapter.addCalendarMonths(start, diffMonths);
                start = adapter.addCalendarDays(start, diffDays);
            }
        }
        else {
            start = adapter.addCalendarYears(start, diffYears);
            start = adapter.addCalendarMonths(start, diffMonths);
            start = adapter.addCalendarDays(start, diffDays);
            end = adapter.addCalendarYears(end, diffYears);
            end = adapter.addCalendarMonths(end, diffMonths);
            end = adapter.addCalendarDays(end, diffDays);
        }
        return new NgxDateRange(start, end);
    }
}
/** @nocollapse */ DefaultNgxMatCalendarRangeStrategy.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "15.0.2", ngImport: i0, type: DefaultNgxMatCalendarRangeStrategy, deps: [{ token: i1.NgxMatDateAdapter }], target: i0.ɵɵFactoryTarget.Injectable });
/** @nocollapse */ DefaultNgxMatCalendarRangeStrategy.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "15.0.2", ngImport: i0, type: DefaultNgxMatCalendarRangeStrategy });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "15.0.2", ngImport: i0, type: DefaultNgxMatCalendarRangeStrategy, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return [{ type: i1.NgxMatDateAdapter }]; } });
/** @docs-private */
export function NGX_MAT_CALENDAR_RANGE_STRATEGY_PROVIDER_FACTORY(parent, adapter) {
    return parent || new DefaultNgxMatCalendarRangeStrategy(adapter);
}
export const NGX_MAT_CALENDAR_RANGE_STRATEGY_PROVIDER = {
    provide: NGX_MAT_DATE_RANGE_SELECTION_STRATEGY,
    deps: [[new Optional(), new SkipSelf(), NGX_MAT_DATE_RANGE_SELECTION_STRATEGY], NgxMatDateAdapter],
    useFactory: NGX_MAT_CALENDAR_RANGE_STRATEGY_PROVIDER_FACTORY,
};
//# sourceMappingURL=data:application/json;base64,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