import { ChangeDetectionStrategy, Component, ViewEncapsulation } from '@angular/core';
import { NgxMatDatepickerBase } from './datepicker-base';
import { NGX_MAT_RANGE_DATE_SELECTION_MODEL_PROVIDER } from './date-selection-model';
import { NGX_MAT_CALENDAR_RANGE_STRATEGY_PROVIDER } from './date-range-selection-strategy';
import * as i0 from "@angular/core";
// TODO(mmalerba): We use a component instead of a directive here so the user can use implicit
// template reference variables (e.g. #d vs #d="matDateRangePicker"). We can change this to a
// directive if angular adds support for `exportAs: '$implicit'` on directives.
/** Component responsible for managing the date range picker popup/dialog. */
export class NgxMatDateRangePicker extends NgxMatDatepickerBase {
    _forwardContentValues(instance) {
        super._forwardContentValues(instance);
        const input = this.datepickerInput;
        if (input) {
            instance.comparisonStart = input.comparisonStart;
            instance.comparisonEnd = input.comparisonEnd;
            instance.startDateAccessibleName = input._getStartDateAccessibleName();
            instance.endDateAccessibleName = input._getEndDateAccessibleName();
        }
    }
}
/** @nocollapse */ NgxMatDateRangePicker.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "15.0.2", ngImport: i0, type: NgxMatDateRangePicker, deps: null, target: i0.ɵɵFactoryTarget.Component });
/** @nocollapse */ NgxMatDateRangePicker.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "15.0.2", type: NgxMatDateRangePicker, selector: "ngx-mat-date-range-picker", providers: [
        NGX_MAT_RANGE_DATE_SELECTION_MODEL_PROVIDER,
        NGX_MAT_CALENDAR_RANGE_STRATEGY_PROVIDER,
        { provide: NgxMatDatepickerBase, useExisting: NgxMatDateRangePicker },
    ], exportAs: ["ngxMatDateRangePicker"], usesInheritance: true, ngImport: i0, template: '', isInline: true, changeDetection: i0.ChangeDetectionStrategy.OnPush, encapsulation: i0.ViewEncapsulation.None });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "15.0.2", ngImport: i0, type: NgxMatDateRangePicker, decorators: [{
            type: Component,
            args: [{
                    selector: 'ngx-mat-date-range-picker',
                    template: '',
                    exportAs: 'ngxMatDateRangePicker',
                    changeDetection: ChangeDetectionStrategy.OnPush,
                    encapsulation: ViewEncapsulation.None,
                    providers: [
                        NGX_MAT_RANGE_DATE_SELECTION_MODEL_PROVIDER,
                        NGX_MAT_CALENDAR_RANGE_STRATEGY_PROVIDER,
                        { provide: NgxMatDatepickerBase, useExisting: NgxMatDateRangePicker },
                    ],
                }]
        }] });
//# sourceMappingURL=data:application/json;base64,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