"use strict";
/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createAngularCompilerHost = exports.ensureSourceFileVersions = void 0;
const typescript_1 = __importDefault(require("typescript"));
// Temporary deep import for host augmentation support.
// TODO: Move these to a private exports location or move the implementation into this package.
const { augmentHostWithCaching, augmentHostWithReplacements, augmentProgramWithVersioning, } = require('@ngtools/webpack/src/ivy/host');
/**
 * Patches in-place the `getSourceFiles` function on an instance of a TypeScript
 * `Program` to ensure that all returned SourceFile instances have a `version`
 * field. The `version` field is required when used with a TypeScript BuilderProgram.
 * @param program The TypeScript Program instance to patch.
 */
function ensureSourceFileVersions(program) {
    augmentProgramWithVersioning(program);
}
exports.ensureSourceFileVersions = ensureSourceFileVersions;
function createAngularCompilerHost(compilerOptions, hostOptions) {
    // Create TypeScript compiler host
    const host = typescript_1.default.createIncrementalCompilerHost(compilerOptions);
    // The AOT compiler currently requires this hook to allow for a transformResource hook.
    // Once the AOT compiler allows only a transformResource hook, this can be reevaluated.
    host.readResource = async function (filename) {
        return this.readFile(filename) ?? '';
    };
    // Add an AOT compiler resource transform hook
    host.transformResource = async function (data, context) {
        // Only style resources are transformed currently
        if (context.type !== 'style') {
            return null;
        }
        const result = await hostOptions.transformStylesheet(data, context.containingFile, context.resourceFile ?? undefined);
        return result ? { content: result } : null;
    };
    // Allow the AOT compiler to request the set of changed templates and styles
    host.getModifiedResourceFiles = function () {
        return hostOptions.modifiedFiles;
    };
    // Augment TypeScript Host for file replacements option
    if (hostOptions.fileReplacements) {
        augmentHostWithReplacements(host, hostOptions.fileReplacements);
    }
    // Augment TypeScript Host with source file caching if provided
    if (hostOptions.sourceFileCache) {
        augmentHostWithCaching(host, hostOptions.sourceFileCache);
    }
    return host;
}
exports.createAngularCompilerHost = createAngularCompilerHost;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYW5ndWxhci1ob3N0LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vLi4vLi4vLi4vLi4vLi4vLi4vcGFja2FnZXMvYW5ndWxhcl9kZXZraXQvYnVpbGRfYW5ndWxhci9zcmMvYnVpbGRlcnMvYnJvd3Nlci1lc2J1aWxkL2FuZ3VsYXIvYW5ndWxhci1ob3N0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7QUFBQTs7Ozs7O0dBTUc7Ozs7OztBQUdILDREQUE0QjtBQWdCNUIsdURBQXVEO0FBQ3ZELCtGQUErRjtBQUMvRixNQUFNLEVBQ0osc0JBQXNCLEVBQ3RCLDJCQUEyQixFQUMzQiw0QkFBNEIsR0FDN0IsR0FBRyxPQUFPLENBQUMsK0JBQStCLENBQUMsQ0FBQztBQUU3Qzs7Ozs7R0FLRztBQUNILFNBQWdCLHdCQUF3QixDQUFDLE9BQW1CO0lBQzFELDRCQUE0QixDQUFDLE9BQU8sQ0FBQyxDQUFDO0FBQ3hDLENBQUM7QUFGRCw0REFFQztBQUVELFNBQWdCLHlCQUF5QixDQUN2QyxlQUF1QyxFQUN2QyxXQUErQjtJQUUvQixrQ0FBa0M7SUFDbEMsTUFBTSxJQUFJLEdBQXdCLG9CQUFFLENBQUMsNkJBQTZCLENBQUMsZUFBZSxDQUFDLENBQUM7SUFFcEYsdUZBQXVGO0lBQ3ZGLHVGQUF1RjtJQUN2RixJQUFJLENBQUMsWUFBWSxHQUFHLEtBQUssV0FBVyxRQUFRO1FBQzFDLE9BQU8sSUFBSSxDQUFDLFFBQVEsQ0FBQyxRQUFRLENBQUMsSUFBSSxFQUFFLENBQUM7SUFDdkMsQ0FBQyxDQUFDO0lBRUYsOENBQThDO0lBQzlDLElBQUksQ0FBQyxpQkFBaUIsR0FBRyxLQUFLLFdBQVcsSUFBSSxFQUFFLE9BQU87UUFDcEQsaURBQWlEO1FBQ2pELElBQUksT0FBTyxDQUFDLElBQUksS0FBSyxPQUFPLEVBQUU7WUFDNUIsT0FBTyxJQUFJLENBQUM7U0FDYjtRQUVELE1BQU0sTUFBTSxHQUFHLE1BQU0sV0FBVyxDQUFDLG1CQUFtQixDQUNsRCxJQUFJLEVBQ0osT0FBTyxDQUFDLGNBQWMsRUFDdEIsT0FBTyxDQUFDLFlBQVksSUFBSSxTQUFTLENBQ2xDLENBQUM7UUFFRixPQUFPLE1BQU0sQ0FBQyxDQUFDLENBQUMsRUFBRSxPQUFPLEVBQUUsTUFBTSxFQUFFLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQztJQUM3QyxDQUFDLENBQUM7SUFFRiw0RUFBNEU7SUFDNUUsSUFBSSxDQUFDLHdCQUF3QixHQUFHO1FBQzlCLE9BQU8sV0FBVyxDQUFDLGFBQWEsQ0FBQztJQUNuQyxDQUFDLENBQUM7SUFFRix1REFBdUQ7SUFDdkQsSUFBSSxXQUFXLENBQUMsZ0JBQWdCLEVBQUU7UUFDaEMsMkJBQTJCLENBQUMsSUFBSSxFQUFFLFdBQVcsQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDO0tBQ2pFO0lBRUQsK0RBQStEO0lBQy9ELElBQUksV0FBVyxDQUFDLGVBQWUsRUFBRTtRQUMvQixzQkFBc0IsQ0FBQyxJQUFJLEVBQUUsV0FBVyxDQUFDLGVBQWUsQ0FBQyxDQUFDO0tBQzNEO0lBRUQsT0FBTyxJQUFJLENBQUM7QUFDZCxDQUFDO0FBN0NELDhEQTZDQyIsInNvdXJjZXNDb250ZW50IjpbIi8qKlxuICogQGxpY2Vuc2VcbiAqIENvcHlyaWdodCBHb29nbGUgTExDIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG4gKlxuICogVXNlIG9mIHRoaXMgc291cmNlIGNvZGUgaXMgZ292ZXJuZWQgYnkgYW4gTUlULXN0eWxlIGxpY2Vuc2UgdGhhdCBjYW4gYmVcbiAqIGZvdW5kIGluIHRoZSBMSUNFTlNFIGZpbGUgYXQgaHR0cHM6Ly9hbmd1bGFyLmlvL2xpY2Vuc2VcbiAqL1xuXG5pbXBvcnQgdHlwZSBuZyBmcm9tICdAYW5ndWxhci9jb21waWxlci1jbGknO1xuaW1wb3J0IHRzIGZyb20gJ3R5cGVzY3JpcHQnO1xuXG5leHBvcnQgdHlwZSBBbmd1bGFyQ29tcGlsZXJPcHRpb25zID0gbmcuQ29tcGlsZXJPcHRpb25zO1xuZXhwb3J0IHR5cGUgQW5ndWxhckNvbXBpbGVySG9zdCA9IG5nLkNvbXBpbGVySG9zdDtcblxuZXhwb3J0IGludGVyZmFjZSBBbmd1bGFySG9zdE9wdGlvbnMge1xuICBmaWxlUmVwbGFjZW1lbnRzPzogUmVjb3JkPHN0cmluZywgc3RyaW5nPjtcbiAgc291cmNlRmlsZUNhY2hlPzogTWFwPHN0cmluZywgdHMuU291cmNlRmlsZT47XG4gIG1vZGlmaWVkRmlsZXM/OiBTZXQ8c3RyaW5nPjtcbiAgdHJhbnNmb3JtU3R5bGVzaGVldChcbiAgICBkYXRhOiBzdHJpbmcsXG4gICAgY29udGFpbmluZ0ZpbGU6IHN0cmluZyxcbiAgICBzdHlsZXNoZWV0RmlsZT86IHN0cmluZyxcbiAgKTogUHJvbWlzZTxzdHJpbmcgfCBudWxsPjtcbn1cblxuLy8gVGVtcG9yYXJ5IGRlZXAgaW1wb3J0IGZvciBob3N0IGF1Z21lbnRhdGlvbiBzdXBwb3J0LlxuLy8gVE9ETzogTW92ZSB0aGVzZSB0byBhIHByaXZhdGUgZXhwb3J0cyBsb2NhdGlvbiBvciBtb3ZlIHRoZSBpbXBsZW1lbnRhdGlvbiBpbnRvIHRoaXMgcGFja2FnZS5cbmNvbnN0IHtcbiAgYXVnbWVudEhvc3RXaXRoQ2FjaGluZyxcbiAgYXVnbWVudEhvc3RXaXRoUmVwbGFjZW1lbnRzLFxuICBhdWdtZW50UHJvZ3JhbVdpdGhWZXJzaW9uaW5nLFxufSA9IHJlcXVpcmUoJ0BuZ3Rvb2xzL3dlYnBhY2svc3JjL2l2eS9ob3N0Jyk7XG5cbi8qKlxuICogUGF0Y2hlcyBpbi1wbGFjZSB0aGUgYGdldFNvdXJjZUZpbGVzYCBmdW5jdGlvbiBvbiBhbiBpbnN0YW5jZSBvZiBhIFR5cGVTY3JpcHRcbiAqIGBQcm9ncmFtYCB0byBlbnN1cmUgdGhhdCBhbGwgcmV0dXJuZWQgU291cmNlRmlsZSBpbnN0YW5jZXMgaGF2ZSBhIGB2ZXJzaW9uYFxuICogZmllbGQuIFRoZSBgdmVyc2lvbmAgZmllbGQgaXMgcmVxdWlyZWQgd2hlbiB1c2VkIHdpdGggYSBUeXBlU2NyaXB0IEJ1aWxkZXJQcm9ncmFtLlxuICogQHBhcmFtIHByb2dyYW0gVGhlIFR5cGVTY3JpcHQgUHJvZ3JhbSBpbnN0YW5jZSB0byBwYXRjaC5cbiAqL1xuZXhwb3J0IGZ1bmN0aW9uIGVuc3VyZVNvdXJjZUZpbGVWZXJzaW9ucyhwcm9ncmFtOiB0cy5Qcm9ncmFtKTogdm9pZCB7XG4gIGF1Z21lbnRQcm9ncmFtV2l0aFZlcnNpb25pbmcocHJvZ3JhbSk7XG59XG5cbmV4cG9ydCBmdW5jdGlvbiBjcmVhdGVBbmd1bGFyQ29tcGlsZXJIb3N0KFxuICBjb21waWxlck9wdGlvbnM6IEFuZ3VsYXJDb21waWxlck9wdGlvbnMsXG4gIGhvc3RPcHRpb25zOiBBbmd1bGFySG9zdE9wdGlvbnMsXG4pOiBBbmd1bGFyQ29tcGlsZXJIb3N0IHtcbiAgLy8gQ3JlYXRlIFR5cGVTY3JpcHQgY29tcGlsZXIgaG9zdFxuICBjb25zdCBob3N0OiBBbmd1bGFyQ29tcGlsZXJIb3N0ID0gdHMuY3JlYXRlSW5jcmVtZW50YWxDb21waWxlckhvc3QoY29tcGlsZXJPcHRpb25zKTtcblxuICAvLyBUaGUgQU9UIGNvbXBpbGVyIGN1cnJlbnRseSByZXF1aXJlcyB0aGlzIGhvb2sgdG8gYWxsb3cgZm9yIGEgdHJhbnNmb3JtUmVzb3VyY2UgaG9vay5cbiAgLy8gT25jZSB0aGUgQU9UIGNvbXBpbGVyIGFsbG93cyBvbmx5IGEgdHJhbnNmb3JtUmVzb3VyY2UgaG9vaywgdGhpcyBjYW4gYmUgcmVldmFsdWF0ZWQuXG4gIGhvc3QucmVhZFJlc291cmNlID0gYXN5bmMgZnVuY3Rpb24gKGZpbGVuYW1lKSB7XG4gICAgcmV0dXJuIHRoaXMucmVhZEZpbGUoZmlsZW5hbWUpID8/ICcnO1xuICB9O1xuXG4gIC8vIEFkZCBhbiBBT1QgY29tcGlsZXIgcmVzb3VyY2UgdHJhbnNmb3JtIGhvb2tcbiAgaG9zdC50cmFuc2Zvcm1SZXNvdXJjZSA9IGFzeW5jIGZ1bmN0aW9uIChkYXRhLCBjb250ZXh0KSB7XG4gICAgLy8gT25seSBzdHlsZSByZXNvdXJjZXMgYXJlIHRyYW5zZm9ybWVkIGN1cnJlbnRseVxuICAgIGlmIChjb250ZXh0LnR5cGUgIT09ICdzdHlsZScpIHtcbiAgICAgIHJldHVybiBudWxsO1xuICAgIH1cblxuICAgIGNvbnN0IHJlc3VsdCA9IGF3YWl0IGhvc3RPcHRpb25zLnRyYW5zZm9ybVN0eWxlc2hlZXQoXG4gICAgICBkYXRhLFxuICAgICAgY29udGV4dC5jb250YWluaW5nRmlsZSxcbiAgICAgIGNvbnRleHQucmVzb3VyY2VGaWxlID8/IHVuZGVmaW5lZCxcbiAgICApO1xuXG4gICAgcmV0dXJuIHJlc3VsdCA/IHsgY29udGVudDogcmVzdWx0IH0gOiBudWxsO1xuICB9O1xuXG4gIC8vIEFsbG93IHRoZSBBT1QgY29tcGlsZXIgdG8gcmVxdWVzdCB0aGUgc2V0IG9mIGNoYW5nZWQgdGVtcGxhdGVzIGFuZCBzdHlsZXNcbiAgaG9zdC5nZXRNb2RpZmllZFJlc291cmNlRmlsZXMgPSBmdW5jdGlvbiAoKSB7XG4gICAgcmV0dXJuIGhvc3RPcHRpb25zLm1vZGlmaWVkRmlsZXM7XG4gIH07XG5cbiAgLy8gQXVnbWVudCBUeXBlU2NyaXB0IEhvc3QgZm9yIGZpbGUgcmVwbGFjZW1lbnRzIG9wdGlvblxuICBpZiAoaG9zdE9wdGlvbnMuZmlsZVJlcGxhY2VtZW50cykge1xuICAgIGF1Z21lbnRIb3N0V2l0aFJlcGxhY2VtZW50cyhob3N0LCBob3N0T3B0aW9ucy5maWxlUmVwbGFjZW1lbnRzKTtcbiAgfVxuXG4gIC8vIEF1Z21lbnQgVHlwZVNjcmlwdCBIb3N0IHdpdGggc291cmNlIGZpbGUgY2FjaGluZyBpZiBwcm92aWRlZFxuICBpZiAoaG9zdE9wdGlvbnMuc291cmNlRmlsZUNhY2hlKSB7XG4gICAgYXVnbWVudEhvc3RXaXRoQ2FjaGluZyhob3N0LCBob3N0T3B0aW9ucy5zb3VyY2VGaWxlQ2FjaGUpO1xuICB9XG5cbiAgcmV0dXJuIGhvc3Q7XG59XG4iXX0=