"use strict";
/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.TestProjectHost = void 0;
const core_1 = require("@angular-devkit/core");
const node_1 = require("@angular-devkit/core/node");
const rxjs_1 = require("rxjs");
/**
 * @deprecated
 */
class TestProjectHost extends node_1.NodeJsSyncHost {
    constructor(_templateRoot) {
        super();
        this._templateRoot = _templateRoot;
        this._currentRoot = null;
        this._scopedSyncHost = null;
    }
    root() {
        if (this._currentRoot === null) {
            throw new Error('TestProjectHost must be initialized before being used.');
        }
        return this._currentRoot;
    }
    scopedSync() {
        if (this._currentRoot === null || this._scopedSyncHost === null) {
            throw new Error('TestProjectHost must be initialized before being used.');
        }
        return this._scopedSyncHost;
    }
    initialize() {
        const recursiveList = (path) => this.list(path).pipe(
        // Emit each fragment individually.
        (0, rxjs_1.concatMap)((fragments) => (0, rxjs_1.from)(fragments)), 
        // Join the path with fragment.
        (0, rxjs_1.map)((fragment) => (0, core_1.join)(path, fragment)), 
        // Emit directory content paths instead of the directory path.
        (0, rxjs_1.mergeMap)((path) => this.isDirectory(path).pipe((0, rxjs_1.concatMap)((isDir) => (isDir ? recursiveList(path) : (0, rxjs_1.of)(path))))));
        // Find a unique folder that we can write to to use as current root.
        return this.findUniqueFolderPath().pipe(
        // Save the path and create a scoped host for it.
        (0, rxjs_1.tap)((newFolderPath) => {
            this._currentRoot = newFolderPath;
            this._scopedSyncHost = new core_1.virtualFs.SyncDelegateHost(new core_1.virtualFs.ScopedHost(this, this.root()));
        }), 
        // List all files in root.
        (0, rxjs_1.concatMap)(() => recursiveList(this._templateRoot)), 
        // Copy them over to the current root.
        (0, rxjs_1.concatMap)((from) => {
            const to = (0, core_1.join)(this.root(), (0, core_1.relative)(this._templateRoot, from));
            return this.read(from).pipe((0, rxjs_1.concatMap)((buffer) => this.write(to, buffer)));
        }), (0, rxjs_1.map)(() => { }));
    }
    restore() {
        if (this._currentRoot === null) {
            return rxjs_1.EMPTY;
        }
        // Delete the current root and clear the variables.
        // Wait 50ms and retry up to 10 times, to give time for file locks to clear.
        return this.exists(this.root()).pipe((0, rxjs_1.delay)(50), (0, rxjs_1.concatMap)((exists) => (exists ? this.delete(this.root()) : rxjs_1.EMPTY)), (0, rxjs_1.retry)(10), (0, rxjs_1.finalize)(() => {
            this._currentRoot = null;
            this._scopedSyncHost = null;
        }));
    }
    writeMultipleFiles(files) {
        Object.keys(files).forEach((fileName) => {
            let content = files[fileName];
            if (typeof content == 'string') {
                content = core_1.virtualFs.stringToFileBuffer(content);
            }
            else if (content instanceof Buffer) {
                content = content.buffer.slice(content.byteOffset, content.byteOffset + content.byteLength);
            }
            this.scopedSync().write((0, core_1.normalize)(fileName), content);
        });
    }
    replaceInFile(path, match, replacement) {
        const content = core_1.virtualFs.fileBufferToString(this.scopedSync().read((0, core_1.normalize)(path)));
        this.scopedSync().write((0, core_1.normalize)(path), core_1.virtualFs.stringToFileBuffer(content.replace(match, replacement)));
    }
    appendToFile(path, str) {
        const content = core_1.virtualFs.fileBufferToString(this.scopedSync().read((0, core_1.normalize)(path)));
        this.scopedSync().write((0, core_1.normalize)(path), core_1.virtualFs.stringToFileBuffer(content.concat(str)));
    }
    fileMatchExists(dir, regex) {
        const [fileName] = this.scopedSync()
            .list((0, core_1.normalize)(dir))
            .filter((name) => name.match(regex));
        return fileName || undefined;
    }
    copyFile(from, to) {
        const content = this.scopedSync().read((0, core_1.normalize)(from));
        this.scopedSync().write((0, core_1.normalize)(to), content);
    }
    findUniqueFolderPath() {
        // 11 character alphanumeric string.
        const randomString = Math.random().toString(36).slice(2);
        const newFolderName = `test-project-host-${(0, core_1.basename)(this._templateRoot)}-${randomString}`;
        const newFolderPath = (0, core_1.join)((0, core_1.dirname)(this._templateRoot), newFolderName);
        return this.exists(newFolderPath).pipe((0, rxjs_1.concatMap)((exists) => (exists ? this.findUniqueFolderPath() : (0, rxjs_1.of)(newFolderPath))));
    }
}
exports.TestProjectHost = TestProjectHost;
//# sourceMappingURL=data:application/json;base64,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