"use strict";
/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.FallbackRegistry = void 0;
const rxjs_1 = require("rxjs");
/**
 * A simple job registry that keep a map of JobName => JobHandler internally.
 */
class FallbackRegistry {
    constructor(_fallbacks = []) {
        this._fallbacks = _fallbacks;
    }
    addFallback(registry) {
        this._fallbacks.push(registry);
    }
    get(name) {
        return (0, rxjs_1.from)(this._fallbacks).pipe((0, rxjs_1.concatMap)((fb) => fb.get(name)), (0, rxjs_1.first)((x) => x !== null, null));
    }
}
exports.FallbackRegistry = FallbackRegistry;
//# sourceMappingURL=data:application/json;base64,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