"use strict";
(self["webpackChunkadmin_panel"] = self["webpackChunkadmin_panel"] || []).push([["src_app_modules_user-manaement_user-manaement_module_ts"],{

/***/ 7998:
/*!***************************************************************************************************!*\
  !*** ./src/app/modules/user-manaement/add-address-pet-parent/add-address-pet-parent.component.ts ***!
  \***************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AddAddressPetParentComponent": () => (/* binding */ AddAddressPetParentComponent)
/* harmony export */ });
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/forms */ 69542);
/* harmony import */ var _angular_material_dialog__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/material/dialog */ 67486);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/core */ 86839);
/* harmony import */ var app_services_user_management_service__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! app/services/user-management.service */ 32555);
/* harmony import */ var _components_controllers_input_input_component__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../components/controllers/input/input.component */ 30867);
/* harmony import */ var _components_controllers_radio_btn_radio_btn_component__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../components/controllers/radio-btn/radio-btn.component */ 49068);
/* harmony import */ var _angular_material_button__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/material/button */ 83677);









class AddAddressPetParentComponent {
  constructor(fb, dialogRef, userManagementService, data) {
    this.fb = fb;
    this.dialogRef = dialogRef;
    this.userManagementService = userManagementService;
    this.data = data;
    this.createControllers();
    this.addressForm = this.fb.group({
      type: [''],
      flatNo: [''],
      address: ['', _angular_forms__WEBPACK_IMPORTED_MODULE_3__.Validators.required],
      city: ['', _angular_forms__WEBPACK_IMPORTED_MODULE_3__.Validators.required],
      pincode: ['', _angular_forms__WEBPACK_IMPORTED_MODULE_3__.Validators.required],
      location: ['', _angular_forms__WEBPACK_IMPORTED_MODULE_3__.Validators.required],
      state: ['', _angular_forms__WEBPACK_IMPORTED_MODULE_3__.Validators.required]
    });
  }
  ngOnInit() {
    if (this.data['id']) {
      this.addressForm = this.data['formGroup'];
    }
  }
  onSubmit() {
    let json = this.addressForm.value;
    let body = {
      "userId": this.data['petParentId'],
      "type": json['type'],
      "flatNo": json['flatNo'],
      "latitude": "11.110",
      "longitude": "22.333",
      "address": json['address'],
      "pincode": json['pincode'],
      "city": json['city'],
      "state": json['state'],
      "default": false
    };
    if (this.data['id']) {
      body['id'] = this.data['id'];
      this.userManagementService.updateAddress(this.data['petParentId'], this.data['id'], body).subscribe(res => {
        console.log(res);
        this.dialogRef.close(this.addressForm.value);
      });
    } else {
      this.userManagementService.addAddress(this.data['petParentId'], body).subscribe(res => {
        this.dialogRef.close(this.addressForm.value);
      });
    }
  }
  onCancel() {
    this.dialogRef.close();
  }
  createControllers() {
    this.controllers = {
      type: {
        id: "type",
        name: 'type',
        label: "Type",
        required: true,
        placeholder: "",
        type: "radio",
        options: [{
          name: 'Home',
          value: 'Home'
        }, {
          name: 'Work',
          value: 'Work'
        }, {
          name: 'Hotel',
          value: 'Hotel'
        }, {
          name: 'Other',
          value: 'Other'
        }]
      },
      flatNo: {
        id: "flatNo",
        name: 'flatNo',
        label: "Flat No",
        required: true,
        placeholder: "Enter Flat No",
        type: "text"
      },
      address: {
        id: "address",
        name: 'address',
        label: "Address",
        required: true,
        placeholder: "Enter Address",
        type: "text"
      },
      pincode: {
        id: "pincode",
        name: 'pincode',
        label: "Pincode",
        required: true,
        placeholder: "Enter Pincode",
        type: "text"
      },
      city: {
        id: "city",
        name: 'city',
        label: "City",
        required: true,
        placeholder: "Enter city",
        type: "text"
      },
      location: {
        id: "location",
        name: 'location',
        label: "location",
        required: true,
        placeholder: "Enter Location",
        type: "text"
      },
      state: {
        id: "state",
        name: 'state',
        label: "State",
        required: true,
        placeholder: "Enter State",
        type: "text"
      }
    };
  }
  static #_ = this.ɵfac = function AddAddressPetParentComponent_Factory(t) {
    return new (t || AddAddressPetParentComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](_angular_forms__WEBPACK_IMPORTED_MODULE_3__.FormBuilder), _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](_angular_material_dialog__WEBPACK_IMPORTED_MODULE_5__.MatDialogRef), _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](app_services_user_management_service__WEBPACK_IMPORTED_MODULE_0__.UserManagementService), _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](_angular_material_dialog__WEBPACK_IMPORTED_MODULE_5__.MAT_DIALOG_DATA));
  };
  static #_2 = this.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdefineComponent"]({
    type: AddAddressPetParentComponent,
    selectors: [["app-add-address-pet-parent"]],
    decls: 20,
    vars: 15,
    consts: [[3, "formGroup", "ngSubmit"], [1, "row", 2, "padding-left", "1%"], [2, "width", "60%", 3, "form", "controller"], [1, "row"], [2, "width", "80%", 3, "form", "controller"], [2, "width", "45%", 3, "form", "controller"], [1, "dialog-actions"], ["mat-button", "", "type", "button", "color", "warn", 3, "click"], ["mat-button", "", "type", "submit", "color", "primary"]],
    template: function AddAddressPetParentComponent_Template(rf, ctx) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "h2");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](1, "Add New Address");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](2, "form", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵlistener"]("ngSubmit", function AddAddressPetParentComponent_Template_form_ngSubmit_2_listener() {
          return ctx.onSubmit();
        });
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](3, "div", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelement"](4, "app-radio-btn", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](5, "div", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelement"](6, "app-input", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](7, "div", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelement"](8, "app-input", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](9, "div", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelement"](10, "app-input", 5)(11, "app-input", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](12, "div", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelement"](13, "app-input", 5)(14, "app-input", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](15, "div", 6)(16, "button", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵlistener"]("click", function AddAddressPetParentComponent_Template_button_click_16_listener() {
          return ctx.onCancel();
        });
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](17, "Cancel");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](18, "button", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](19, "Save");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]()()();
      }
      if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("formGroup", ctx.addressForm);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("form", ctx.addressForm)("controller", ctx.controllers["type"]);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("form", ctx.addressForm)("controller", ctx.controllers["flatNo"]);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("form", ctx.addressForm)("controller", ctx.controllers["address"]);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("form", ctx.addressForm)("controller", ctx.controllers["city"]);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("form", ctx.addressForm)("controller", ctx.controllers["pincode"]);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("form", ctx.addressForm)("controller", ctx.controllers["state"]);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("form", ctx.addressForm)("controller", ctx.controllers["location"]);
      }
    },
    dependencies: [_components_controllers_input_input_component__WEBPACK_IMPORTED_MODULE_1__.InputComponent, _components_controllers_radio_btn_radio_btn_component__WEBPACK_IMPORTED_MODULE_2__.RadioBtnComponent, _angular_material_button__WEBPACK_IMPORTED_MODULE_6__.MatButton, _angular_forms__WEBPACK_IMPORTED_MODULE_3__["ɵNgNoValidate"], _angular_forms__WEBPACK_IMPORTED_MODULE_3__.NgControlStatusGroup, _angular_forms__WEBPACK_IMPORTED_MODULE_3__.FormGroupDirective],
    styles: ["form[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: column;\n  justify-content: space-between;\n  width: 100%;\n  height: 100%;\n}\nform[_ngcontent-%COMP%]   .row[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: row;\n  justify-content: space-between;\n  padding: 1%;\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImFkZC1hZGRyZXNzLXBldC1wYXJlbnQuY29tcG9uZW50LnNjc3MiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7RUFDSSxhQUFBO0VBQ0Esc0JBQUE7RUFDQSw4QkFBQTtFQUNBLFdBQUE7RUFDQSxZQUFBO0FBQ0o7QUFBSTtFQUNJLGFBQUE7RUFDQSxtQkFBQTtFQUNBLDhCQUFBO0VBQ0EsV0FBQTtBQUVSIiwiZmlsZSI6ImFkZC1hZGRyZXNzLXBldC1wYXJlbnQuY29tcG9uZW50LnNjc3MiLCJzb3VyY2VzQ29udGVudCI6WyJmb3Jte1xuICAgIGRpc3BsYXk6IGZsZXg7XG4gICAgZmxleC1kaXJlY3Rpb246IGNvbHVtbjtcbiAgICBqdXN0aWZ5LWNvbnRlbnQ6IHNwYWNlLWJldHdlZW47XG4gICAgd2lkdGg6IDEwMCU7XG4gICAgaGVpZ2h0OiAxMDAlO1xuICAgIC5yb3d7XG4gICAgICAgIGRpc3BsYXk6IGZsZXg7XG4gICAgICAgIGZsZXgtZGlyZWN0aW9uOiByb3c7XG4gICAgICAgIGp1c3RpZnktY29udGVudDogc3BhY2UtYmV0d2VlbjtcbiAgICAgICAgcGFkZGluZzogMSU7XG5cbiAgICB9XG59Il19 */\n/*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8uL3NyYy9hcHAvbW9kdWxlcy91c2VyLW1hbmFlbWVudC9hZGQtYWRkcmVzcy1wZXQtcGFyZW50L2FkZC1hZGRyZXNzLXBldC1wYXJlbnQuY29tcG9uZW50LnNjc3MiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7RUFDSSxhQUFBO0VBQ0Esc0JBQUE7RUFDQSw4QkFBQTtFQUNBLFdBQUE7RUFDQSxZQUFBO0FBQ0o7QUFBSTtFQUNJLGFBQUE7RUFDQSxtQkFBQTtFQUNBLDhCQUFBO0VBQ0EsV0FBQTtBQUVSO0FBQ0Esb3dCQUFvd0IiLCJzb3VyY2VzQ29udGVudCI6WyJmb3Jte1xuICAgIGRpc3BsYXk6IGZsZXg7XG4gICAgZmxleC1kaXJlY3Rpb246IGNvbHVtbjtcbiAgICBqdXN0aWZ5LWNvbnRlbnQ6IHNwYWNlLWJldHdlZW47XG4gICAgd2lkdGg6IDEwMCU7XG4gICAgaGVpZ2h0OiAxMDAlO1xuICAgIC5yb3d7XG4gICAgICAgIGRpc3BsYXk6IGZsZXg7XG4gICAgICAgIGZsZXgtZGlyZWN0aW9uOiByb3c7XG4gICAgICAgIGp1c3RpZnktY29udGVudDogc3BhY2UtYmV0d2VlbjtcbiAgICAgICAgcGFkZGluZzogMSU7XG5cbiAgICB9XG59Il0sInNvdXJjZVJvb3QiOiIifQ== */"]
  });
}


/***/ }),

/***/ 24682:
/*!***************************************************************************************!*\
  !*** ./src/app/modules/user-manaement/add-collaborator/add-collaborator.component.ts ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AddCollaboratorComponent": () => (/* binding */ AddCollaboratorComponent)
/* harmony export */ });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/core */ 86839);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @angular/forms */ 69542);
/* harmony import */ var app_components_controllers_success_dialog_success_dialog_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! app/components/controllers/success-dialog/success-dialog.component */ 92814);
/* harmony import */ var app_services_user_management_service__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! app/services/user-management.service */ 32555);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @angular/router */ 86679);
/* harmony import */ var app_services_validations_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! app/services/validations.service */ 27681);
/* harmony import */ var _angular_material_snack_bar__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @angular/material/snack-bar */ 88511);
/* harmony import */ var app_services_loader_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! app/services/loader.service */ 38555);
/* harmony import */ var _angular_material_dialog__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @angular/material/dialog */ 67486);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @angular/common */ 86477);
/* harmony import */ var _components_controllers_input_input_component__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../components/controllers/input/input.component */ 30867);
/* harmony import */ var _components_controllers_file_upload_file_upload_component__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../components/controllers/file-upload/file-upload.component */ 76956);
/* harmony import */ var _components_controllers_rich_text_editor_rich_text_editor_component__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../components/controllers/rich-text-editor/rich-text-editor.component */ 60534);
/* harmony import */ var _angular_material_button__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @angular/material/button */ 83677);
/* harmony import */ var _angular_material_icon__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @angular/material/icon */ 69941);

















function AddCollaboratorComponent_p_4_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementStart"](0, "p", 14);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵtext"](1, "Add Partner");
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementEnd"]();
  }
}
function AddCollaboratorComponent_p_5_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementStart"](0, "p", 14);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵtext"](1, "Edit Partner");
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementEnd"]();
  }
}
function AddCollaboratorComponent_div_22_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementStart"](0, "div", 5);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelement"](1, "app-rich-text-editor", 7);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵproperty"]("form", ctx_r2.form)("controller", ctx_r2.controllers["internalNotes"]);
  }
}
class AddCollaboratorComponent {
  constructor(fb, userManagementService, router, validationsService, snackBar, loader, dialog) {
    this.fb = fb;
    this.userManagementService = userManagementService;
    this.router = router;
    this.validationsService = validationsService;
    this.snackBar = snackBar;
    this.loader = loader;
    this.dialog = dialog;
    this.cancelEvent = new _angular_core__WEBPACK_IMPORTED_MODULE_7__.EventEmitter();
    this.form = this.fb.group({
      name: ['', [_angular_forms__WEBPACK_IMPORTED_MODULE_8__.Validators.required, this.validationsService.isOnlyStringValidator()]],
      email: ['', [_angular_forms__WEBPACK_IMPORTED_MODULE_8__.Validators.required, this.validationsService.emailValidator()]],
      phone: ['', [_angular_forms__WEBPACK_IMPORTED_MODULE_8__.Validators.required, this.validationsService.mobileNumberValidator()]],
      city: ['', [_angular_forms__WEBPACK_IMPORTED_MODULE_8__.Validators.required, this.validationsService.cityValidation()]],
      profileImage: ['', _angular_forms__WEBPACK_IMPORTED_MODULE_8__.Validators.required]
    });
    this.craeteFormControllers();
  }
  ngOnInit() {}
  ngOnChanges() {
    console.log(this.editData);
    if (this.editData) {
      let ele = document.getElementById("add-update");
      ele.innerHTML = "Save";
      this.edit();
    }
  }
  edit() {
    this.form = this.fb.group({
      name: [this.editData['collaboratorName'], [_angular_forms__WEBPACK_IMPORTED_MODULE_8__.Validators.required, this.validationsService.isOnlyStringValidator()]],
      email: [this.editData['email'], [_angular_forms__WEBPACK_IMPORTED_MODULE_8__.Validators.required, this.validationsService.emailValidator()]],
      phone: [this.editData['mobile'], [_angular_forms__WEBPACK_IMPORTED_MODULE_8__.Validators.required, this.validationsService.mobileNumberValidator()]],
      city: [this.editData['city'], [_angular_forms__WEBPACK_IMPORTED_MODULE_8__.Validators.required, this.validationsService.isOnlyStringValidator()]],
      profileImage: [this.editData['imageUrl'], _angular_forms__WEBPACK_IMPORTED_MODULE_8__.Validators.required],
      internalNotes: []
    });
  }
  craeteFormControllers() {
    this.controllers = {
      name: {
        id: "userName",
        name: 'name',
        label: "Name",
        required: true,
        placeholder: "Enter Name",
        type: "text"
      },
      email: {
        id: "userName",
        name: 'email',
        label: "Email",
        required: true,
        placeholder: "Enter Email",
        type: "email"
      },
      phone: {
        id: "phone",
        name: 'phone',
        label: "Phone",
        required: true,
        placeholder: "Enter Mobile No.",
        type: "text"
      },
      city: {
        id: "city",
        name: 'city',
        label: "City",
        required: true,
        placeholder: "Enter City",
        type: "text"
      },
      gender: {
        id: "gender",
        name: 'gender',
        label: "Gender",
        required: true,
        placeholder: "Enter Gender",
        type: "text"
      },
      profileImage: {
        id: "profileImage",
        name: 'profileImage',
        label: "Partner Image*",
        required: true,
        placeholder: "Enter Name",
        type: "file"
      },
      internalNotes: {
        id: "internalNotes",
        name: "internalNotes",
        label: "Internal Notes",
        placeholder: "Enter Internal Notes",
        required: true
      }
    };
  }
  updateProfile() {
    if (this.editData) {
      this.loader.showLoader();
      this.userManagementService.addCollaboratorProfile(this.editData['id'], this.form.get('profileImage').value).subscribe(res => {
        this.loader.hideLoader();
        this.showSuccessToast("Profile Image updated Successfully");
      });
    }
  }
  addCollaborator() {
    let data = {
      "email": this.form.value['email'],
      "countryCode": "23456",
      "mobile": this.form.value['phone'],
      "collaboratorName": this.form.value['name'],
      "isVerified": true,
      "isEmailVerified": true,
      "city": this.form.value['city'],
      "status": "Created"
    };
    if (this.editData) {
      data["id"] = this.editData['id'];
      this.loader.showLoader();
      this.userManagementService.updateCollaboratorById('1', data).subscribe(res => {
        // this.userManagementService.addCollaboratorProfile(res['id'], this.form.get('coverImage').value).subscribe((res) => {
        this.userManagementService.getCollaboratorsByType('All').subscribe(res => {
          this.loader.hideLoader();
          this.cancel();
          this.router.navigate(['/user/collaborator']);
          const dialogRef = this.dialog.open(app_components_controllers_success_dialog_success_dialog_component__WEBPACK_IMPORTED_MODULE_0__.SuccessDialogComponent, {
            width: '300px',
            data: {
              message: 'Collaborator updated successfully!',
              success: true
            },
            panelClass: 'success-dialog-container'
          });
        });
        // })
      }, error => {
        console.log("🚀 ~ AddCollaboratorComponent ~ this.userManagementService.updateCollaboratorById ~ error:", error);
        this.loader.hideLoader();
        const dialogRef = this.dialog.open(app_components_controllers_success_dialog_success_dialog_component__WEBPACK_IMPORTED_MODULE_0__.SuccessDialogComponent, {
          width: '300px',
          data: {
            message: error.error.message === "could not execute statement; SQL [n/a]; constraint [admin_user.email_UNIQUE]; nested exception is org.hibernate.exception.ConstraintViolationException: could not execute statement" ? "Email should be unique" : 'Something Went Wrong!',
            success: false
          }
        });
      });
    } else {
      this.loader.showLoader();
      this.userManagementService.registerCollaborators(data, '1').subscribe(res => {
        this.userManagementService.addCollaboratorProfile(res['id'], this.form.get('profileImage').value).subscribe(res => {
          this.userManagementService.getCollaboratorsByType('All').subscribe(res => {
            this.loader.hideLoader();
            this.router.navigate(['/user/collaborator']);
          });
          const dialogRef = this.dialog.open(app_components_controllers_success_dialog_success_dialog_component__WEBPACK_IMPORTED_MODULE_0__.SuccessDialogComponent, {
            width: '300px',
            data: {
              message: 'Collaborator created successfully!',
              success: true
            },
            panelClass: 'success-dialog-container'
          });
        });
      }, error => {
        console.log("🚀 ~ AddCollaboratorComponent ~ this.userManagementService.registerCollaborators ~ error:", error);
        this.loader.hideLoader();
        const dialogRef = this.dialog.open(app_components_controllers_success_dialog_success_dialog_component__WEBPACK_IMPORTED_MODULE_0__.SuccessDialogComponent, {
          width: '300px',
          data: {
            message: error.error.message,
            success: false
          }
        });
      });
    }
  }
  cancel() {
    this.cancelEvent.emit();
    this.router.navigate(['/user/collaborator']);
  }
  showSuccessToast(message) {
    this.snackBar.open(message, 'Close', {
      duration: 3000,
      panelClass: ['success-toast']
    });
  }
  showErrorToast(message) {
    this.snackBar.open(message, 'Close', {
      duration: 3000,
      panelClass: ['error-toast']
    });
  }
  static #_ = this.ɵfac = function AddCollaboratorComponent_Factory(t) {
    return new (t || AddCollaboratorComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵdirectiveInject"](_angular_forms__WEBPACK_IMPORTED_MODULE_8__.FormBuilder), _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵdirectiveInject"](app_services_user_management_service__WEBPACK_IMPORTED_MODULE_1__.UserManagementService), _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵdirectiveInject"](_angular_router__WEBPACK_IMPORTED_MODULE_9__.Router), _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵdirectiveInject"](app_services_validations_service__WEBPACK_IMPORTED_MODULE_2__.ValidationsService), _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵdirectiveInject"](_angular_material_snack_bar__WEBPACK_IMPORTED_MODULE_10__.MatSnackBar), _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵdirectiveInject"](app_services_loader_service__WEBPACK_IMPORTED_MODULE_3__.LoaderService), _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵdirectiveInject"](_angular_material_dialog__WEBPACK_IMPORTED_MODULE_11__.MatDialog));
  };
  static #_2 = this.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵdefineComponent"]({
    type: AddCollaboratorComponent,
    selectors: [["app-add-collaborator"]],
    inputs: {
      editData: "editData"
    },
    outputs: {
      cancelEvent: "cancelEvent"
    },
    features: [_angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵNgOnChangesFeature"]],
    decls: 28,
    vars: 14,
    consts: [[1, "flex", "flex-col", "flex-auto", "min-w-0", 2, "width", "100%", "overflow-y", "auto", "height", "calc(100vh - 70px)"], [1, "flex-auto", "p-6", "sm:p-10"], [1, "header"], ["style", "font-weight: 500;color: black;", 4, "ngIf"], ["type", "button", "mat-mini-fab", "", "color", "warn", 3, "click"], [1, "row"], [1, "col"], [3, "form", "controller"], ["type", "number", 3, "form", "controller"], ["accept", "image/*", 3, "form", "controller", "onFileSelect"], ["class", "row", 4, "ngIf"], [1, "btn-wrapper"], ["type", "button", "mat-stroked-button", "", "color", "primary", 3, "click"], ["mat-stroked-button", "", "color", "primary", "id", "add-update", 3, "disabled", "click"], [2, "font-weight", "500", "color", "black"]],
    template: function AddCollaboratorComponent_Template(rf, ctx) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementStart"](0, "div", 0)(1, "div", 1)(2, "form")(3, "div", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵtemplate"](4, AddCollaboratorComponent_p_4_Template, 2, 0, "p", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵtemplate"](5, AddCollaboratorComponent_p_5_Template, 2, 0, "p", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementStart"](6, "button", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵlistener"]("click", function AddCollaboratorComponent_Template_button_click_6_listener() {
          return ctx.cancel();
        });
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementStart"](7, "mat-icon");
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵtext"](8, "close");
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementEnd"]()()();
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementStart"](9, "div", 5)(10, "div", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelement"](11, "app-input", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementStart"](12, "div", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelement"](13, "app-input", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementEnd"]()();
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementStart"](14, "div", 5)(15, "div", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelement"](16, "app-input", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementStart"](17, "div", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelement"](18, "app-input", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementEnd"]()();
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementStart"](19, "div", 5)(20, "div", 6)(21, "app-file-upload", 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵlistener"]("onFileSelect", function AddCollaboratorComponent_Template_app_file_upload_onFileSelect_21_listener() {
          return ctx.updateProfile();
        });
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementEnd"]()()();
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵtemplate"](22, AddCollaboratorComponent_div_22_Template, 2, 2, "div", 10);
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementStart"](23, "div", 11)(24, "button", 12);
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵlistener"]("click", function AddCollaboratorComponent_Template_button_click_24_listener() {
          return ctx.cancel();
        });
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵtext"](25, "Cancel");
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementStart"](26, "button", 13);
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵlistener"]("click", function AddCollaboratorComponent_Template_button_click_26_listener() {
          return ctx.addCollaborator();
        });
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵtext"](27, "Submit");
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementEnd"]()()()()();
      }
      if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵproperty"]("ngIf", !ctx.editData);
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵproperty"]("ngIf", ctx.editData);
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵadvance"](6);
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵproperty"]("form", ctx.form)("controller", ctx.controllers["name"]);
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵproperty"]("form", ctx.form)("controller", ctx.controllers["email"]);
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵproperty"]("form", ctx.form)("controller", ctx.controllers["phone"]);
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵproperty"]("form", ctx.form)("controller", ctx.controllers["city"]);
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵproperty"]("form", ctx.form)("controller", ctx.controllers["profileImage"]);
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵproperty"]("ngIf", ctx.editData);
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵproperty"]("disabled", ctx.form.invalid);
      }
    },
    dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_12__.NgIf, _components_controllers_input_input_component__WEBPACK_IMPORTED_MODULE_4__.InputComponent, _components_controllers_file_upload_file_upload_component__WEBPACK_IMPORTED_MODULE_5__.FileUploadComponent, _components_controllers_rich_text_editor_rich_text_editor_component__WEBPACK_IMPORTED_MODULE_6__.RichTextEditorComponent, _angular_material_button__WEBPACK_IMPORTED_MODULE_13__.MatButton, _angular_material_button__WEBPACK_IMPORTED_MODULE_13__.MatMiniFabButton, _angular_forms__WEBPACK_IMPORTED_MODULE_8__["ɵNgNoValidate"], _angular_forms__WEBPACK_IMPORTED_MODULE_8__.NgControlStatusGroup, _angular_forms__WEBPACK_IMPORTED_MODULE_8__.NgForm, _angular_material_icon__WEBPACK_IMPORTED_MODULE_14__.MatIcon],
    styles: ["form[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: column;\n  width: 100%;\n  height: 100%;\n}\nform[_ngcontent-%COMP%]   .row[_ngcontent-%COMP%] {\n  width: 60%;\n  justify-content: space-between;\n  display: flex;\n  flex-direction: row;\n  padding: 2%;\n  gap: 10%;\n}\nform[_ngcontent-%COMP%]   .row[_ngcontent-%COMP%]   .col[_ngcontent-%COMP%] {\n  width: 100%;\n  display: flex;\n  flex-direction: column;\n  height: 100%;\n}\nform[_ngcontent-%COMP%]   .btn-wrapper[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: row;\n  justify-content: right;\n}\nform[_ngcontent-%COMP%]   .btn-wrapper[_ngcontent-%COMP%]   button[_ngcontent-%COMP%] {\n  margin: 10px;\n}\n\n.header[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: row;\n  justify-content: space-between;\n  width: 100%;\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImFkZC1jb2xsYWJvcmF0b3IuY29tcG9uZW50LnNjc3MiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7RUFDSSxhQUFBO0VBQ0Esc0JBQUE7RUFDQSxXQUFBO0VBQ0EsWUFBQTtBQUNKO0FBQ0k7RUFDSSxVQUFBO0VBQ0EsOEJBQUE7RUFDQSxhQUFBO0VBQ0EsbUJBQUE7RUFDQSxXQUFBO0VBQ0EsUUFBQTtBQUNSO0FBQ1E7RUFDSSxXQUFBO0VBQ0EsYUFBQTtFQUNBLHNCQUFBO0VBQ0EsWUFBQTtBQUNaO0FBR0k7RUFDSSxhQUFBO0VBQ0EsbUJBQUE7RUFDQSxzQkFBQTtBQURSO0FBR1E7RUFDSSxZQUFBO0FBRFo7O0FBTUE7RUFDSSxhQUFBO0VBQ0EsbUJBQUE7RUFDQSw4QkFBQTtFQUNBLFdBQUE7QUFISiIsImZpbGUiOiJhZGQtY29sbGFib3JhdG9yLmNvbXBvbmVudC5zY3NzIiwic291cmNlc0NvbnRlbnQiOlsiZm9ybSB7XG4gICAgZGlzcGxheTogZmxleDtcbiAgICBmbGV4LWRpcmVjdGlvbjogY29sdW1uO1xuICAgIHdpZHRoOiAxMDAlO1xuICAgIGhlaWdodDogMTAwJTtcblxuICAgIC5yb3cge1xuICAgICAgICB3aWR0aDogNjAlO1xuICAgICAgICBqdXN0aWZ5LWNvbnRlbnQ6IHNwYWNlLWJldHdlZW47XG4gICAgICAgIGRpc3BsYXk6IGZsZXg7XG4gICAgICAgIGZsZXgtZGlyZWN0aW9uOiByb3c7XG4gICAgICAgIHBhZGRpbmc6IDIlO1xuICAgICAgICBnYXA6IDEwJTtcblxuICAgICAgICAuY29sIHtcbiAgICAgICAgICAgIHdpZHRoOiAxMDAlO1xuICAgICAgICAgICAgZGlzcGxheTogZmxleDtcbiAgICAgICAgICAgIGZsZXgtZGlyZWN0aW9uOiBjb2x1bW47XG4gICAgICAgICAgICBoZWlnaHQ6IDEwMCU7XG4gICAgICAgIH1cbiAgICB9XG5cbiAgICAuYnRuLXdyYXBwZXIge1xuICAgICAgICBkaXNwbGF5OiBmbGV4O1xuICAgICAgICBmbGV4LWRpcmVjdGlvbjogcm93O1xuICAgICAgICBqdXN0aWZ5LWNvbnRlbnQ6IHJpZ2h0O1xuXG4gICAgICAgIGJ1dHRvbiB7XG4gICAgICAgICAgICBtYXJnaW46IDEwcHg7XG4gICAgICAgIH1cbiAgICB9XG59XG5cbi5oZWFkZXIge1xuICAgIGRpc3BsYXk6IGZsZXg7XG4gICAgZmxleC1kaXJlY3Rpb246IHJvdztcbiAgICBqdXN0aWZ5LWNvbnRlbnQ6IHNwYWNlLWJldHdlZW47XG4gICAgd2lkdGg6IDEwMCU7XG59Il19 */\n/*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8uL3NyYy9hcHAvbW9kdWxlcy91c2VyLW1hbmFlbWVudC9hZGQtY29sbGFib3JhdG9yL2FkZC1jb2xsYWJvcmF0b3IuY29tcG9uZW50LnNjc3MiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7RUFDSSxhQUFBO0VBQ0Esc0JBQUE7RUFDQSxXQUFBO0VBQ0EsWUFBQTtBQUNKO0FBQ0k7RUFDSSxVQUFBO0VBQ0EsOEJBQUE7RUFDQSxhQUFBO0VBQ0EsbUJBQUE7RUFDQSxXQUFBO0VBQ0EsUUFBQTtBQUNSO0FBQ1E7RUFDSSxXQUFBO0VBQ0EsYUFBQTtFQUNBLHNCQUFBO0VBQ0EsWUFBQTtBQUNaO0FBR0k7RUFDSSxhQUFBO0VBQ0EsbUJBQUE7RUFDQSxzQkFBQTtBQURSO0FBR1E7RUFDSSxZQUFBO0FBRFo7O0FBTUE7RUFDSSxhQUFBO0VBQ0EsbUJBQUE7RUFDQSw4QkFBQTtFQUNBLFdBQUE7QUFISjtBQUNBLDRpREFBNGlEIiwic291cmNlc0NvbnRlbnQiOlsiZm9ybSB7XG4gICAgZGlzcGxheTogZmxleDtcbiAgICBmbGV4LWRpcmVjdGlvbjogY29sdW1uO1xuICAgIHdpZHRoOiAxMDAlO1xuICAgIGhlaWdodDogMTAwJTtcblxuICAgIC5yb3cge1xuICAgICAgICB3aWR0aDogNjAlO1xuICAgICAgICBqdXN0aWZ5LWNvbnRlbnQ6IHNwYWNlLWJldHdlZW47XG4gICAgICAgIGRpc3BsYXk6IGZsZXg7XG4gICAgICAgIGZsZXgtZGlyZWN0aW9uOiByb3c7XG4gICAgICAgIHBhZGRpbmc6IDIlO1xuICAgICAgICBnYXA6IDEwJTtcblxuICAgICAgICAuY29sIHtcbiAgICAgICAgICAgIHdpZHRoOiAxMDAlO1xuICAgICAgICAgICAgZGlzcGxheTogZmxleDtcbiAgICAgICAgICAgIGZsZXgtZGlyZWN0aW9uOiBjb2x1bW47XG4gICAgICAgICAgICBoZWlnaHQ6IDEwMCU7XG4gICAgICAgIH1cbiAgICB9XG5cbiAgICAuYnRuLXdyYXBwZXIge1xuICAgICAgICBkaXNwbGF5OiBmbGV4O1xuICAgICAgICBmbGV4LWRpcmVjdGlvbjogcm93O1xuICAgICAgICBqdXN0aWZ5LWNvbnRlbnQ6IHJpZ2h0O1xuXG4gICAgICAgIGJ1dHRvbiB7XG4gICAgICAgICAgICBtYXJnaW46IDEwcHg7XG4gICAgICAgIH1cbiAgICB9XG59XG5cbi5oZWFkZXIge1xuICAgIGRpc3BsYXk6IGZsZXg7XG4gICAgZmxleC1kaXJlY3Rpb246IHJvdztcbiAgICBqdXN0aWZ5LWNvbnRlbnQ6IHNwYWNlLWJldHdlZW47XG4gICAgd2lkdGg6IDEwMCU7XG59Il0sInNvdXJjZVJvb3QiOiIifQ== */"]
  });
}


/***/ }),

/***/ 59932:
/*!*********************************************************************!*\
  !*** ./src/app/modules/user-manaement/add-pet/add-pet.component.ts ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AddPetComponent": () => (/* binding */ AddPetComponent)
/* harmony export */ });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @angular/core */ 86839);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @angular/forms */ 69542);
/* harmony import */ var app_components_controllers_success_dialog_success_dialog_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! app/components/controllers/success-dialog/success-dialog.component */ 92814);
/* harmony import */ var app_services_user_management_service__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! app/services/user-management.service */ 32555);
/* harmony import */ var app_services_adoption_management_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! app/services/adoption-management.service */ 54384);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @angular/router */ 86679);
/* harmony import */ var _angular_material_snack_bar__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @angular/material/snack-bar */ 88511);
/* harmony import */ var app_services_validations_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! app/services/validations.service */ 27681);
/* harmony import */ var _angular_material_dialog__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @angular/material/dialog */ 67486);
/* harmony import */ var app_services_loader_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! app/services/loader.service */ 38555);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @angular/common */ 86477);
/* harmony import */ var _components_controllers_input_input_component__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../components/controllers/input/input.component */ 30867);
/* harmony import */ var _components_controllers_file_upload_file_upload_component__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../components/controllers/file-upload/file-upload.component */ 76956);
/* harmony import */ var _components_controllers_radio_btn_radio_btn_component__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../../components/controllers/radio-btn/radio-btn.component */ 49068);
/* harmony import */ var _components_controllers_dropdown_dropdown_component__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../../components/controllers/dropdown/dropdown.component */ 29069);
/* harmony import */ var _angular_material_button__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! @angular/material/button */ 83677);
/* harmony import */ var _angular_material_icon__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! @angular/material/icon */ 69941);



















function AddPetComponent_div_18_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementStart"](0, "div", 6);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelement"](1, "app-dropdown", 8);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵproperty"]("form", ctx_r0.form)("controller", ctx_r0.controllers["breed"]);
  }
}
function AddPetComponent_div_27_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementStart"](0, "div", 5)(1, "div", 6);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelement"](2, "app-dropdown", 8);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementStart"](3, "div", 6);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelement"](4, "app-dropdown", 8);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementStart"](5, "div", 6);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelement"](6, "app-dropdown", 8);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementEnd"]()();
  }
  if (rf & 2) {
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵproperty"]("form", ctx_r1.form)("controller", ctx_r1.controllers["color"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵproperty"]("form", ctx_r1.form)("controller", ctx_r1.controllers["coatLength"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵproperty"]("form", ctx_r1.form)("controller", ctx_r1.controllers["neutered"]);
  }
}
function AddPetComponent_div_28_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementStart"](0, "div", 5)(1, "div", 6);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelement"](2, "app-dropdown", 8);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementStart"](3, "div", 6);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelement"](4, "app-dropdown", 8);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementStart"](5, "div", 6);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelement"](6, "app-dropdown", 8);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementEnd"]()();
  }
  if (rf & 2) {
    const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵproperty"]("form", ctx_r2.form)("controller", ctx_r2.controllers["bloodType"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵproperty"]("form", ctx_r2.form)("controller", ctx_r2.controllers["temperament"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵproperty"]("form", ctx_r2.form)("controller", ctx_r2.controllers["trainingLevel"]);
  }
}
function AddPetComponent_div_29_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementStart"](0, "div", 5)(1, "div", 6);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelement"](2, "app-input", 7);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementStart"](3, "div", 6);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelement"](4, "app-input", 7);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelement"](5, "div", 6);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const ctx_r3 = _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵproperty"]("form", ctx_r3.form)("controller", ctx_r3.controllers["allergies"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵproperty"]("form", ctx_r3.form)("controller", ctx_r3.controllers["marks"]);
  }
}
class AddPetComponent {
  constructor(fb, userManagementService, adoptionManagementService, router, snackBar, validationsService, dialog, loader) {
    this.fb = fb;
    this.userManagementService = userManagementService;
    this.adoptionManagementService = adoptionManagementService;
    this.router = router;
    this.snackBar = snackBar;
    this.validationsService = validationsService;
    this.dialog = dialog;
    this.loader = loader;
    this.cancelEvent = new _angular_core__WEBPACK_IMPORTED_MODULE_9__.EventEmitter();
    this.form = this.fb.group({
      name: ['', [_angular_forms__WEBPACK_IMPORTED_MODULE_10__.Validators.required, this.validationsService.isOnlyStringValidator()]],
      species: ['', _angular_forms__WEBPACK_IMPORTED_MODULE_10__.Validators.required],
      breed: ['', _angular_forms__WEBPACK_IMPORTED_MODULE_10__.Validators.required],
      month: [0, [_angular_forms__WEBPACK_IMPORTED_MODULE_10__.Validators.required, _angular_forms__WEBPACK_IMPORTED_MODULE_10__.Validators.min(0), _angular_forms__WEBPACK_IMPORTED_MODULE_10__.Validators.max(12)]],
      year: [0, [_angular_forms__WEBPACK_IMPORTED_MODULE_10__.Validators.required, _angular_forms__WEBPACK_IMPORTED_MODULE_10__.Validators.min(0)]],
      age: [''],
      gender: ['', _angular_forms__WEBPACK_IMPORTED_MODULE_10__.Validators.required],
      image: [null, _angular_forms__WEBPACK_IMPORTED_MODULE_10__.Validators.required],
      weight: [null],
      color: [null],
      coatLength: [null],
      neutered: [null],
      bloodType: [null],
      temperament: [null],
      trainingLevel: [null],
      allergies: [null],
      marks: [null]
    });
    this.craeteFormControllers();
  }
  ngOnInit() {
    console.log(this.editData);
    if (this.editData) {
      let ele = document.getElementById("add-update");
      ele.innerHTML = "Save";
      this.edit();
    }
    this.onSpeciesChange();
  }
  ngOnChanges() {}
  onSpeciesChange() {
    this.form.get('species').valueChanges.subscribe(change => {
      console.log("chnage", change);
      this.controllers['bloodType']['options'] = new Array();
      this.controllers['color']['options'] = new Array();
      this.controllers['temperament']['options'] = new Array();
      this.controllers['breed']['options'] = new Array();
      this.adoptionManagementService.getBreeds(change).subscribe(res => {
        console.log(res);
        res.forEach(el => {
          this.controllers['breed']['options'].push({
            name: el,
            value: el
          });
        });
        // this.form.get('breed').setValue(this.controllers['breed']['options'][0].value)
      });
      if (change == 'dog') {
        this.controllers['bloodType']['options'] = [{
          name: 'DEA 1.1 (positive or negative)',
          value: 'DEA 1.1 (positive or negative)'
        }, {
          name: 'DEA 3',
          value: 'DEA 3'
        }, {
          name: 'DEA 4',
          value: 'DEA 4'
        }, {
          name: 'DEA 5',
          value: 'DEA 5'
        }, {
          name: 'DEA 6',
          value: 'DEA 6'
        }, {
          name: 'DEA 7',
          value: 'DEA 7'
        }, {
          name: 'DEA 8',
          value: 'DEA 8'
        }];
        this.controllers['color']['options'] = [{
          name: 'Black',
          value: 'Black'
        }, {
          name: 'Brown',
          value: 'Brown'
        }, {
          name: 'White',
          value: 'White'
        }, {
          name: 'Golden',
          value: 'Golden'
        }, {
          name: 'Grey',
          value: 'Grey'
        }, {
          name: 'White and black',
          value: 'White and black'
        }, {
          name: 'White and brown',
          value: 'White and brown'
        }, {
          name: 'Black and brown',
          value: 'Black and brown'
        }, {
          name: 'Black, white and brown',
          value: 'Black, white and brown'
        }];
        this.controllers['temperament']['options'] = [{
          name: 'Friendly',
          value: 'Friendly'
        }, {
          name: 'Not friendly',
          value: 'Not friendly'
        }, {
          name: 'Reserved',
          value: 'Reserved'
        }, {
          name: 'Anxious',
          value: 'Anxious'
        }, {
          name: 'Fearful',
          value: 'Fearful'
        }, {
          name: 'Reactive',
          value: 'Reactive'
        }, {
          name: 'Aggressive',
          value: 'Aggressive'
        }];
      } else if (change == 'cat') {
        this.controllers['bloodType']['options'] = [{
          name: 'Type A',
          value: 'Type A'
        }, {
          name: 'Type B',
          value: 'Type B'
        }, {
          name: 'Type AB',
          value: 'Type AB'
        }];
        this.controllers['color']['options'] = [{
          name: 'Black',
          value: 'Black'
        }, {
          name: 'Brown',
          value: 'Brown'
        }, {
          name: 'White',
          value: 'White'
        }, {
          name: 'Orange',
          value: 'Orange'
        }, {
          name: 'Grey',
          value: 'Grey'
        }, {
          name: 'White and black',
          value: 'White and black'
        }, {
          name: 'White and orange',
          value: 'White and orange'
        }, {
          name: 'Black and grey',
          value: 'Black and grey'
        }];
        this.controllers['temperament']['options'] = [{
          name: 'Friendly',
          value: 'Friendly'
        }, {
          name: 'Social',
          value: 'Social'
        }, {
          name: 'Aloof',
          value: 'Aloof'
        }, {
          name: 'Timid',
          value: 'Timid'
        }, {
          name: 'Not friendly',
          value: 'Not friendly'
        }, {
          name: 'Aggressive',
          value: 'Aggressive'
        }];
      }
      this.controllers['breed'] = JSON.parse(JSON.stringify(this.controllers['breed']));
      this.controllers['color'] = JSON.parse(JSON.stringify(this.controllers['color']));
      this.controllers['bloodType'] = JSON.parse(JSON.stringify(this.controllers['bloodType']));
      this.controllers['temperament'] = JSON.parse(JSON.stringify(this.controllers['temperament']));
    });
  }
  edit() {
    this.form = this.fb.group({
      name: [this.editData['petName'], [_angular_forms__WEBPACK_IMPORTED_MODULE_10__.Validators.required, this.validationsService.isOnlyStringValidator()]],
      species: [this.editData['type'], _angular_forms__WEBPACK_IMPORTED_MODULE_10__.Validators.required],
      month: [this.editData['month'], [_angular_forms__WEBPACK_IMPORTED_MODULE_10__.Validators.required, _angular_forms__WEBPACK_IMPORTED_MODULE_10__.Validators.min(0), _angular_forms__WEBPACK_IMPORTED_MODULE_10__.Validators.max(12)]],
      year: [this.editData['year'], [_angular_forms__WEBPACK_IMPORTED_MODULE_10__.Validators.required, _angular_forms__WEBPACK_IMPORTED_MODULE_10__.Validators.min(0)]],
      breed: [this.editData['breed'], _angular_forms__WEBPACK_IMPORTED_MODULE_10__.Validators.required],
      age: [null],
      gender: [this.editData['gender'], _angular_forms__WEBPACK_IMPORTED_MODULE_10__.Validators.required],
      image: [this.editData['profileImage']],
      weight: [this.editData['weight'] ? this.editData['weight'] : '', _angular_forms__WEBPACK_IMPORTED_MODULE_10__.Validators.min(0)],
      color: [null],
      coatLength: [null],
      neutered: [null],
      bloodType: [null],
      temperament: [null],
      trainingLevel: [null],
      allergies: [null],
      marks: [null]
    });
    let type;
    if (this.editData['gender'] == 'female') {
      this.form.get('gender').setValue('Female');
    } else if (this.editData['gender'] == 'male') {
      this.form.get('gender').setValue('Male');
    }
    if (this.editData['type'] == 'Cat') {
      this.form.get('species').setValue('cat');
    }
    if (this.editData['type'] == 'Dog') {
      this.form.get('species').setValue('dog');
    }
    if (this.form.get('species').value == "cat") {
      type = "Cat";
    } else if (this.form.get('species').value == "dog") {
      type = "Dog";
    }
    // else if (this.form.get('species').value == "bird") {
    //   type = "Bird"
    // } else if (this.form.get('species').value == "exotic") {
    //   type = "Exotic"
    // }
    if (this.editData['metadata']) {
      this.editData['metadata'].forEach(el => {
        if (el['key'] == 'petColor') {
          this.form.get('color').setValue(el['value']);
        }
        if (el['key'] == 'trainingLevel') {
          this.form.get('trainingLevel').setValue(el['value']);
        }
        if (el['key'] == 'allergy') {
          this.form.get('allergies').setValue(el['value']);
        }
        if (el['key'] == 'neutered') {
          this.form.get('neutered').setValue(el['value']);
        }
        if (el['key'] == 'bloodType') {
          this.form.get('bloodType').setValue(el['value']);
        }
        if (el['key'] == 'temperament') {
          this.form.get('temperament').setValue(el['value']);
        }
        if (el['key'] == 'coatLength') {
          this.form.get('coatLength').setValue(el['value']);
        }
        if (el['key'] == 'distintive') {
          this.form.get('marks').setValue(el['value']);
        }
      });
    }
    console.log(type);
    this.adoptionManagementService.getBreeds(type).subscribe(res => {
      res.forEach(el => {
        this.controllers['breed']['options'].push({
          name: el,
          value: el
        });
      });
      this.form.get('breed').setValue(this.editData['breed']);
    });
    console.log('form', this.form);
  }
  craeteFormControllers() {
    this.controllers = {
      name: {
        id: "name",
        name: 'name',
        label: "Pet Name",
        required: true,
        placeholder: "Enter Pet Name",
        type: "text"
      },
      species: {
        id: "species",
        name: 'species',
        label: "Pet Species*",
        required: true,
        placeholder: "Enter Pet Species",
        options: [{
          name: "Dog",
          value: "dog"
        }, {
          name: "Cat",
          value: "cat"
        }, {
          name: "Bird",
          value: "bird"
        }, {
          name: "Exotic",
          value: "exotic"
        }],
        type: "text"
      },
      breed: {
        id: "breed",
        name: 'breed',
        label: "Pet Breed*",
        required: true,
        placeholder: "Enter Pet Breed",
        options: [],
        type: "text"
      },
      age: {
        id: "age",
        name: 'age',
        label: "Pet Age",
        required: true,
        placeholder: "Enter Age In Months",
        type: "text"
      },
      year: {
        id: "year",
        name: "year",
        label: "Year",
        placeholder: "Enter Year",
        required: true
      },
      month: {
        id: "month",
        name: "month",
        label: "Month",
        placeholder: "Enter Month",
        required: true
      },
      gender: {
        id: "gender",
        name: 'gender',
        label: "Gender",
        required: true,
        placeholder: "Enter Gender",
        options: [{
          name: "Male",
          value: "Male"
        }, {
          name: "Female",
          value: "Female"
        }],
        type: "radio"
      },
      image: {
        id: "image",
        name: 'image',
        label: "Upload Pet Image*",
        required: true,
        placeholder: "",
        type: "image"
      },
      internalNotes: {
        id: "internalNotes",
        name: "internalNotes",
        label: "Internal Notes",
        placeholder: "Enter Internal Notes",
        required: true
      },
      weight: {
        id: "weight",
        name: "weight",
        label: "Weight (in kg)",
        placeholder: "Enter Weight",
        required: true
      },
      color: {
        id: "color",
        name: "color",
        label: "Color",
        placeholder: "Enter Color",
        required: true,
        options: [{
          name: 'Black',
          value: 'Black'
        }, {
          name: 'Brown',
          value: 'Brown'
        }, {
          name: 'White',
          value: 'White'
        }, {
          name: 'Golden',
          value: 'Golden'
        }, {
          name: 'Grey',
          value: 'Grey'
        }, {
          name: 'White and black ',
          value: 'White and black '
        }, {
          name: 'White and brown',
          value: 'White and brown '
        }, {
          name: 'Black and brown',
          value: 'Black and brown'
        }, {
          name: 'Black, white and brown',
          value: 'Black, white and brown'
        }]
      },
      coatLength: {
        id: "coatLength",
        name: "coatLength",
        label: "Coat Length",
        placeholder: "Enter Color",
        required: true,
        options: [{
          name: 'Small',
          value: 'Small'
        }, {
          name: 'Medium',
          value: 'Medium'
        }, {
          name: 'Large',
          value: 'Large'
        }]
      },
      neutered: {
        id: "neutered",
        name: "neutered",
        label: "Neutered/Spayed",
        placeholder: "Enter Color",
        required: true,
        options: [{
          name: 'Yes',
          value: 'Yes'
        }, {
          name: 'No',
          value: 'No'
        }]
      },
      bloodType: {
        id: "bloodType",
        name: "bloodType",
        label: "Blood Type",
        placeholder: "Enter bloodType",
        required: true,
        options: [{
          name: 'DEA 1.1',
          value: 'DEA 1.1'
        }, {
          name: 'DEA 1.2',
          value: 'DEA 1.2'
        }, {
          name: 'DEA 3',
          value: 'DEA 3'
        }, {
          name: 'DEA 4',
          value: 'DEA 4'
        }, {
          name: 'DEA 5',
          value: 'DEA 5'
        }, {
          name: 'DEA 6',
          value: 'DEA 6'
        }, {
          name: 'DEA 7',
          value: 'DEA 7'
        }, {
          name: 'DEA 8',
          value: 'DEA 8'
        }]
      },
      temperament: {
        id: "temperament",
        name: "temperament",
        label: "Temperament",
        placeholder: "Enter Temperament",
        required: true,
        options: [{
          name: 'Friendly ',
          value: 'Friendly '
        }, {
          name: 'Not friendly',
          value: 'Not friendly'
        }, {
          name: 'Reserved',
          value: 'Reserved'
        }, {
          name: 'Anxious',
          value: 'Anxious'
        }, {
          name: 'Fearful',
          value: 'Fearful'
        }, {
          name: 'Reactive',
          value: 'Reactive'
        }, {
          name: 'Aggressive',
          value: 'Aggressive'
        }]
      },
      trainingLevel: {
        id: "trainingLevel",
        name: "trainingLevel",
        label: "Training Level",
        placeholder: "Enter Training Level",
        required: true,
        options: [{
          name: 'House Training',
          value: 'House Training'
        }, {
          name: 'Basic Obedience',
          value: 'Basic Obedience'
        }, {
          name: 'Socialization',
          value: 'Socialization'
        }, {
          name: 'Advanced obedience',
          value: 'Advanced obedience'
        }, {
          name: 'Impulse control',
          value: 'Impulse control'
        }, {
          name: 'Leash Training',
          value: 'Leash Training'
        }, {
          name: 'Off-leash training',
          value: 'Off-leash training'
        }, {
          name: 'Trick training',
          value: 'Trick training'
        }, {
          name: 'Agility training',
          value: 'Agility training'
        }, {
          name: 'Therapy Dog Training',
          value: 'Therapy Dog Training'
        }, {
          name: 'Service Dog Training',
          value: 'Service Dog Training'
        }, {
          name: 'Search and Rescue Training',
          value: 'Search and Rescue Training'
        }, {
          name: 'Scent Detection Training',
          value: 'Scent Detection Training'
        }, {
          name: 'Protection Training',
          value: 'Protection Training'
        }]
      },
      allergies: {
        id: "allergies",
        name: "allergies",
        label: "Allergies",
        placeholder: "Enter Allergies",
        required: true
      },
      marks: {
        id: "marks",
        name: "marks",
        label: "Distinctive Marks",
        placeholder: "Enter Allergies",
        required: true
      }
    };
  }
  uploadProfile(event) {
    if (this.editData) {
      this.loader.showLoader();
      this.userManagementService.addPetProfileImage(this.petParentId, this.editData['id'], this.form.get('image').value).subscribe(res => {
        console.log(res);
        this.loader.hideLoader();
      });
    }
  }
  addPet() {
    if (!this.petParentId) {
      this.petParentId = sessionStorage.getItem('petParentId');
    }
    console.log(this.form);
    let json = this.form.value;
    let body = {
      "petName": json['name'],
      "type": json['species'],
      "breed": json['breed'],
      "weight": json['weight'],
      "gender": json['gender'],
      "year": json['year'],
      "month": json['month'],
      "userId": this.petParentId,
      "active": true,
      "metadata": []
    };
    if (this.editData) {
      if (this.editData['metadata']) {
        body['metadata'] = this.editData['metadata'];
        body['metadata'].forEach(el => {
          if (el['key'] == "petColor") {
            el['value'] = json['color'];
            // else{
            //   body['metadata'].filter(el => el[])
            // }
          }
          if (el['key'] == 'trainingLevel') {
            el['value'] = json['trainingLevel'];
          }
          if (el['key'] == 'allergy') {
            el['value'] = json['allergies'];
          }
          if (el['key'] == 'neutered') {
            el['value'] = json['neutered'];
          }
          if (el['key'] == 'bloodType') {
            el['value'] = json['bloodType'];
          }
          if (el['key'] == 'temperament') {
            el['value'] = json['temperament'];
          }
          if (el['key'] == 'coatLength') {
            el['value'] = json['coatLength'];
          }
          if (el['key'] == 'distintive') {
            el['value'] = json['marks'];
          }
        });
        // { key: "distintive", value: distintiveMarks }
        if (body['metadata'].some(obj => obj.key === 'distintive') == false && json['marks']) {
          body['metadata'].push({
            "key": "distintive",
            "value": json['marks']
          });
        }
        if (body['metadata'].some(obj => obj.key === 'bloodType') == false && json['bloodType']) {
          body['metadata'].push({
            "key": "bloodType",
            "value": json['bloodType']
          });
        }
        if (body['metadata'].some(obj => obj.key === 'temperament') == false && json['temperament']) {
          if (json['temperament']) {
            body['metadata'].push({
              "key": "temperament",
              "value": json['temperament']
            });
          }
        }
        if (body['metadata'].some(obj => obj.key === 'neutered') == false && json['neutered']) {
          body['metadata'].push({
            "key": "neutered",
            "value": json['neutered']
          });
        }
        if (body['metadata'].some(obj => obj.key === 'allergies') == false && json['allergies']) {
          body['metadata'].push({
            "key": "allergy",
            "value": json['allergies']
          });
        }
        if (body['metadata'].some(obj => obj.key === 'trainingLevel') == false && json['trainingLevel']) {
          body['metadata'].push({
            "key": "trainingLevel",
            "value": json['trainingLevel']
          });
        }
        if (body['metadata'].some(obj => obj.key === 'petColor') == false && json['color']) {
          body['metadata'].push({
            "key": "petColor",
            "value": json['color']
          });
        }
        // if(json['color'] == '' && json['trainingLevel'] == '' && json['allergies'] == '' &&  json['neutered'] == '' && json['bloodType'] == '' && json['temperament'] == '' && json['coatLength'] == '' && json['marks']==''){
        //   body['metadata'] = []
        // }
        body.metadata = body.metadata.filter(item => item.value);
      } else {
        if (json['coatLength']) {
          body['metadata'].push({
            "id": '',
            "key": "coatLength",
            "value": json['coatLength']
          });
        }
        if (json['bloodType']) {
          body['metadata'].push({
            "id": '',
            "key": "bloodType",
            "value": json['bloodType']
          });
        }
        if (json['temperament']) {
          body['metadata'].push({
            "id": '',
            "key": "temperament",
            "value": json['temperament']
          });
        }
        if (json['neutered']) {
          body['metadata'].push({
            "id": '',
            "key": "neutered",
            "value": json['neutered']
          });
        }
        if (json['allergies']) {
          body['metadata'].push({
            "id": '',
            "key": "allergy",
            "value": json['allergies']
          });
        }
        if (json['trainingLevel']) {
          body['metadata'].push({
            "id": '',
            "key": "trainingLevel",
            "value": json['trainingLevel']
          });
        }
        if (json['marks']) {
          body['metadata'].push({
            "id": '',
            "key": "distintive",
            "value": json['marks']
          });
        }
        if (json['color']) {
          body['metadata'].push({
            "id": '',
            "key": "petColor",
            "value": json['color']
          });
        }
        body.metadata = body.metadata.filter(item => item.value);
      }
      body["id"] = this.editData["id"];
      this.loader.showLoader();
      this.userManagementService.updatePet(this.petParentId, body).subscribe(res => {
        this.userManagementService.getAllPetsByPetParent(this.petParentId).subscribe(res => {
          console.log(res);
          this.loader.hideLoader();
          this.cancelEvent.emit();
          const dialogRef = this.dialog.open(app_components_controllers_success_dialog_success_dialog_component__WEBPACK_IMPORTED_MODULE_0__.SuccessDialogComponent, {
            width: '300px',
            data: {
              message: 'Pet updated successfully!',
              success: true
            },
            panelClass: 'success-dialog-container'
          });
        });
        console.log(res);
      }, error => {
        this.loader.hideLoader();
        const dialogRef = this.dialog.open(app_components_controllers_success_dialog_success_dialog_component__WEBPACK_IMPORTED_MODULE_0__.SuccessDialogComponent, {
          width: '300px',
          data: {
            message: 'Something Went Wrong!',
            success: false
          }
        });
      });
    } else {
      if (json['coatLength']) {
        body['metadata'].push({
          "key": "coatLength",
          "value": json['coatLength']
        });
      }
      if (json['bloodType']) {
        body['metadata'].push({
          "key": "bloodType",
          "value": json['bloodType']
        });
      }
      if (json['temperament']) {
        body['metadata'].push({
          "key": "temperament",
          "value": json['temperament']
        });
      }
      if (json['neutered']) {
        body['metadata'].push({
          "key": "neutered",
          "value": json['neutered']
        });
      }
      if (json['allergies']) {
        body['metadata'].push({
          "key": "allergy",
          "value": json['allergies']
        });
      }
      if (json['trainingLevel']) {
        body['metadata'].push({
          "key": "trainingLevel",
          "value": json['trainingLevel']
        });
      }
      if (json['color']) {
        body['metadata'].push({
          "key": "petColor",
          "value": json['color']
        });
      }
      if (json['marks']) {
        body['metadata'].push({
          "key": "distintive",
          "value": json['marks']
        });
      }
      this.loader.showLoader();
      this.userManagementService.addPet(this.petParentId, body).subscribe(res => {
        this.userManagementService.addPetProfileImage(this.petParentId, res['id'], json['image']).subscribe(res => {
          this.userManagementService.getAllPetsByPetParent(this.petParentId).subscribe(res => {
            this.loader.hideLoader();
            console.log(res);
            this.cancelEvent.emit();
            const dialogRef = this.dialog.open(app_components_controllers_success_dialog_success_dialog_component__WEBPACK_IMPORTED_MODULE_0__.SuccessDialogComponent, {
              width: '300px',
              data: {
                message: 'Pet created successfully!',
                success: true
              },
              panelClass: 'success-dialog-container'
            });
            console.log(res);
          });
        });
        console.log(res);
      }, error => {
        this.loader.hideLoader();
        const dialogRef = this.dialog.open(app_components_controllers_success_dialog_success_dialog_component__WEBPACK_IMPORTED_MODULE_0__.SuccessDialogComponent, {
          width: '300px',
          data: {
            message: 'Something Went Wrong!',
            success: false
          }
        });
      });
    }
  }
  getPets() {
    // if (this.editData) {
    this.loader.showLoader();
    this.userManagementService.getAllPetsByPetParent(this.petParentId).subscribe(res => {
      console.log(res);
      this.loader.hideLoader();
    });
    // }
  }
  cancel() {
    this.form.reset();
    this.getPets();
    this.cancelEvent.emit();
    this.router.navigate(['/user/pet']);
  }
  showSuccessToast(message) {
    this.snackBar.open(message, 'Close', {
      duration: 3000,
      panelClass: ['success-toast']
    });
  }
  showErrorToast(message) {
    this.snackBar.open(message, 'Close', {
      duration: 3000,
      panelClass: ['error-toast']
    });
  }
  ngOnDestroy() {
    this.form.reset();
  }
  static #_ = this.ɵfac = function AddPetComponent_Factory(t) {
    return new (t || AddPetComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵdirectiveInject"](_angular_forms__WEBPACK_IMPORTED_MODULE_10__.FormBuilder), _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵdirectiveInject"](app_services_user_management_service__WEBPACK_IMPORTED_MODULE_1__.UserManagementService), _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵdirectiveInject"](app_services_adoption_management_service__WEBPACK_IMPORTED_MODULE_2__.AdoptionManagementService), _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵdirectiveInject"](_angular_router__WEBPACK_IMPORTED_MODULE_11__.Router), _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵdirectiveInject"](_angular_material_snack_bar__WEBPACK_IMPORTED_MODULE_12__.MatSnackBar), _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵdirectiveInject"](app_services_validations_service__WEBPACK_IMPORTED_MODULE_3__.ValidationsService), _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵdirectiveInject"](_angular_material_dialog__WEBPACK_IMPORTED_MODULE_13__.MatDialog), _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵdirectiveInject"](app_services_loader_service__WEBPACK_IMPORTED_MODULE_4__.LoaderService));
  };
  static #_2 = this.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵdefineComponent"]({
    type: AddPetComponent,
    selectors: [["app-add-pet"]],
    inputs: {
      petParentId: "petParentId",
      editData: "editData"
    },
    outputs: {
      cancelEvent: "cancelEvent"
    },
    features: [_angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵNgOnChangesFeature"]],
    decls: 38,
    vars: 21,
    consts: [[1, "flex", "flex-col", "flex-auto", "min-w-0", 2, "width", "100%", "overflow-y", "auto", "height", "calc(100vh - 70px)"], [1, "flex-auto", "p-6", "sm:p-10"], [1, "header"], [2, "font-weight", "500", "padding-left", "10px", "color", "black"], ["mat-icon-button", "", "color", "primary", 3, "click"], [1, "row"], [1, "col"], [2, "width", "100%", 3, "form", "controller"], [3, "form", "controller"], ["class", "col", 4, "ngIf"], ["type", "number", "maxlength", "12", 2, "width", "100%", 3, "form", "controller"], ["class", "row", 4, "ngIf"], ["accept", "image/*", 3, "form", "controller", "onFileSelect"], [1, "btn-wrapper"], ["mat-stroked-button", "", "color", "primary", 3, "click"], ["mat-stroked-button", "", "color", "primary", "id", "add-update", 3, "disabled", "click"]],
    template: function AddPetComponent_Template(rf, ctx) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementStart"](0, "div", 0)(1, "div", 1)(2, "form")(3, "div", 2)(4, "p", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵtext"](5);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementStart"](6, "button", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵlistener"]("click", function AddPetComponent_Template_button_click_6_listener() {
          return ctx.cancel();
        });
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementStart"](7, "mat-icon");
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵtext"](8, "close");
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementEnd"]()()();
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementStart"](9, "div", 5)(10, "div", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelement"](11, "app-input", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementStart"](12, "div", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelement"](13, "app-radio-btn", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelement"](14, "div", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementStart"](15, "div", 5)(16, "div", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelement"](17, "app-dropdown", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵtemplate"](18, AddPetComponent_div_18_Template, 2, 2, "div", 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelement"](19, "div", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementStart"](20, "div", 5)(21, "div", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelement"](22, "app-input", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementStart"](23, "div", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelement"](24, "app-input", 10);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementStart"](25, "div", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelement"](26, "app-input", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementEnd"]()();
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵtemplate"](27, AddPetComponent_div_27_Template, 7, 6, "div", 11);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵtemplate"](28, AddPetComponent_div_28_Template, 7, 6, "div", 11);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵtemplate"](29, AddPetComponent_div_29_Template, 6, 4, "div", 11);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementStart"](30, "div", 5)(31, "div", 6)(32, "app-file-upload", 12);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵlistener"]("onFileSelect", function AddPetComponent_Template_app_file_upload_onFileSelect_32_listener($event) {
          return ctx.uploadProfile($event);
        });
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementEnd"]()()();
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementStart"](33, "div", 13)(34, "button", 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵlistener"]("click", function AddPetComponent_Template_button_click_34_listener() {
          return ctx.cancel();
        });
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵtext"](35, "Cancel");
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementStart"](36, "button", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵlistener"]("click", function AddPetComponent_Template_button_click_36_listener() {
          return ctx.addPet();
        });
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵtext"](37);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementEnd"]()()()()();
      }
      if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵadvance"](5);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵtextInterpolate"](ctx.editData ? "Edit Pet" : "Add Pet");
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵadvance"](6);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵproperty"]("form", ctx.form)("controller", ctx.controllers["name"]);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵproperty"]("form", ctx.form)("controller", ctx.controllers["gender"]);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵproperty"]("form", ctx.form)("controller", ctx.controllers["species"]);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵproperty"]("ngIf", ctx.form.get("species").value && ctx.controllers["breed"]["options"].length);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵproperty"]("form", ctx.form)("controller", ctx.controllers["year"]);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵproperty"]("form", ctx.form)("controller", ctx.controllers["month"]);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵproperty"]("form", ctx.form)("controller", ctx.controllers["weight"]);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵproperty"]("ngIf", ctx.form.get("species").value == "dog" || ctx.form.get("species").value == "cat");
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵproperty"]("ngIf", ctx.form.get("species").value == "dog" || ctx.form.get("species").value == "cat");
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵproperty"]("ngIf", ctx.form.get("species").value == "dog" || ctx.form.get("species").value == "cat");
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵproperty"]("form", ctx.form)("controller", ctx.controllers["image"]);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵproperty"]("disabled", ctx.form.invalid);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵtextInterpolate"](ctx.editData ? "Save" : "Create");
      }
    },
    dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_14__.NgIf, _components_controllers_input_input_component__WEBPACK_IMPORTED_MODULE_5__.InputComponent, _components_controllers_file_upload_file_upload_component__WEBPACK_IMPORTED_MODULE_6__.FileUploadComponent, _components_controllers_radio_btn_radio_btn_component__WEBPACK_IMPORTED_MODULE_7__.RadioBtnComponent, _components_controllers_dropdown_dropdown_component__WEBPACK_IMPORTED_MODULE_8__.DropdownComponent, _angular_material_button__WEBPACK_IMPORTED_MODULE_15__.MatButton, _angular_material_button__WEBPACK_IMPORTED_MODULE_15__.MatIconButton, _angular_forms__WEBPACK_IMPORTED_MODULE_10__["ɵNgNoValidate"], _angular_forms__WEBPACK_IMPORTED_MODULE_10__.NgControlStatusGroup, _angular_forms__WEBPACK_IMPORTED_MODULE_10__.NgForm, _angular_material_icon__WEBPACK_IMPORTED_MODULE_16__.MatIcon],
    styles: ["form[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: column;\n  width: 100%;\n  height: 100%;\n}\nform[_ngcontent-%COMP%]   .row[_ngcontent-%COMP%] {\n  width: 90%;\n  justify-content: space-between;\n  display: flex;\n  flex-direction: row;\n  height: 25%;\n  padding: 1%;\n}\nform[_ngcontent-%COMP%]   .row[_ngcontent-%COMP%]   .col[_ngcontent-%COMP%] {\n  width: 30%;\n  padding: auto;\n  display: flex;\n  flex-direction: column;\n  height: 100%;\n}\nform[_ngcontent-%COMP%]   .btn-wrapper[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: row;\n  justify-content: right;\n}\nform[_ngcontent-%COMP%]   .btn-wrapper[_ngcontent-%COMP%]   button[_ngcontent-%COMP%] {\n  margin: 10px;\n}\n\n.header[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: row;\n  justify-content: space-between;\n  width: 100%;\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImFkZC1wZXQuY29tcG9uZW50LnNjc3MiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7RUFDSSxhQUFBO0VBQ0Esc0JBQUE7RUFDQSxXQUFBO0VBQ0EsWUFBQTtBQUNKO0FBQUk7RUFDSSxVQUFBO0VBQ0EsOEJBQUE7RUFDQSxhQUFBO0VBQ0EsbUJBQUE7RUFDQSxXQUFBO0VBQ0EsV0FBQTtBQUVSO0FBQVE7RUFDSSxVQUFBO0VBQ0EsYUFBQTtFQUNBLGFBQUE7RUFDQSxzQkFBQTtFQUNBLFlBQUE7QUFFWjtBQUNJO0VBQ0ksYUFBQTtFQUNBLG1CQUFBO0VBQ0Esc0JBQUE7QUFDUjtBQUFRO0VBQ0ksWUFBQTtBQUVaOztBQUVBO0VBQ0ksYUFBQTtFQUNBLG1CQUFBO0VBQ0EsOEJBQUE7RUFDQSxXQUFBO0FBQ0oiLCJmaWxlIjoiYWRkLXBldC5jb21wb25lbnQuc2NzcyIsInNvdXJjZXNDb250ZW50IjpbImZvcm17XG4gICAgZGlzcGxheTogZmxleDtcbiAgICBmbGV4LWRpcmVjdGlvbjogY29sdW1uO1xuICAgIHdpZHRoOiAxMDAlO1xuICAgIGhlaWdodDogMTAwJTtcbiAgICAucm93e1xuICAgICAgICB3aWR0aDogOTAlO1xuICAgICAgICBqdXN0aWZ5LWNvbnRlbnQ6c3BhY2UtYmV0d2VlbjtcbiAgICAgICAgZGlzcGxheTogZmxleDtcbiAgICAgICAgZmxleC1kaXJlY3Rpb246IHJvdztcbiAgICAgICAgaGVpZ2h0OiAyNSU7XG4gICAgICAgIHBhZGRpbmc6IDElO1xuXG4gICAgICAgIC5jb2x7XG4gICAgICAgICAgICB3aWR0aDogMzAlO1xuICAgICAgICAgICAgcGFkZGluZzogYXV0bztcbiAgICAgICAgICAgIGRpc3BsYXk6IGZsZXg7XG4gICAgICAgICAgICBmbGV4LWRpcmVjdGlvbjogY29sdW1uO1xuICAgICAgICAgICAgaGVpZ2h0OiAxMDAlO1xuICAgICAgICB9XG4gICAgfVxuICAgIC5idG4td3JhcHBlcntcbiAgICAgICAgZGlzcGxheTogZmxleDtcbiAgICAgICAgZmxleC1kaXJlY3Rpb246IHJvdztcbiAgICAgICAganVzdGlmeS1jb250ZW50OiByaWdodDtcbiAgICAgICAgYnV0dG9ue1xuICAgICAgICAgICAgbWFyZ2luOiAxMHB4O1xuICAgICAgICB9XG4gICAgfVxufVxuLmhlYWRlcntcbiAgICBkaXNwbGF5OiBmbGV4O1xuICAgIGZsZXgtZGlyZWN0aW9uOiByb3c7XG4gICAganVzdGlmeS1jb250ZW50OiBzcGFjZS1iZXR3ZWVuO1xuICAgIHdpZHRoOiAxMDAlO1xufVxuIl19 */\n/*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8uL3NyYy9hcHAvbW9kdWxlcy91c2VyLW1hbmFlbWVudC9hZGQtcGV0L2FkZC1wZXQuY29tcG9uZW50LnNjc3MiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7RUFDSSxhQUFBO0VBQ0Esc0JBQUE7RUFDQSxXQUFBO0VBQ0EsWUFBQTtBQUNKO0FBQUk7RUFDSSxVQUFBO0VBQ0EsOEJBQUE7RUFDQSxhQUFBO0VBQ0EsbUJBQUE7RUFDQSxXQUFBO0VBQ0EsV0FBQTtBQUVSO0FBQVE7RUFDSSxVQUFBO0VBQ0EsYUFBQTtFQUNBLGFBQUE7RUFDQSxzQkFBQTtFQUNBLFlBQUE7QUFFWjtBQUNJO0VBQ0ksYUFBQTtFQUNBLG1CQUFBO0VBQ0Esc0JBQUE7QUFDUjtBQUFRO0VBQ0ksWUFBQTtBQUVaOztBQUVBO0VBQ0ksYUFBQTtFQUNBLG1CQUFBO0VBQ0EsOEJBQUE7RUFDQSxXQUFBO0FBQ0o7QUFDQSx3akRBQXdqRCIsInNvdXJjZXNDb250ZW50IjpbImZvcm17XG4gICAgZGlzcGxheTogZmxleDtcbiAgICBmbGV4LWRpcmVjdGlvbjogY29sdW1uO1xuICAgIHdpZHRoOiAxMDAlO1xuICAgIGhlaWdodDogMTAwJTtcbiAgICAucm93e1xuICAgICAgICB3aWR0aDogOTAlO1xuICAgICAgICBqdXN0aWZ5LWNvbnRlbnQ6c3BhY2UtYmV0d2VlbjtcbiAgICAgICAgZGlzcGxheTogZmxleDtcbiAgICAgICAgZmxleC1kaXJlY3Rpb246IHJvdztcbiAgICAgICAgaGVpZ2h0OiAyNSU7XG4gICAgICAgIHBhZGRpbmc6IDElO1xuXG4gICAgICAgIC5jb2x7XG4gICAgICAgICAgICB3aWR0aDogMzAlO1xuICAgICAgICAgICAgcGFkZGluZzogYXV0bztcbiAgICAgICAgICAgIGRpc3BsYXk6IGZsZXg7XG4gICAgICAgICAgICBmbGV4LWRpcmVjdGlvbjogY29sdW1uO1xuICAgICAgICAgICAgaGVpZ2h0OiAxMDAlO1xuICAgICAgICB9XG4gICAgfVxuICAgIC5idG4td3JhcHBlcntcbiAgICAgICAgZGlzcGxheTogZmxleDtcbiAgICAgICAgZmxleC1kaXJlY3Rpb246IHJvdztcbiAgICAgICAganVzdGlmeS1jb250ZW50OiByaWdodDtcbiAgICAgICAgYnV0dG9ue1xuICAgICAgICAgICAgbWFyZ2luOiAxMHB4O1xuICAgICAgICB9XG4gICAgfVxufVxuLmhlYWRlcntcbiAgICBkaXNwbGF5OiBmbGV4O1xuICAgIGZsZXgtZGlyZWN0aW9uOiByb3c7XG4gICAganVzdGlmeS1jb250ZW50OiBzcGFjZS1iZXR3ZWVuO1xuICAgIHdpZHRoOiAxMDAlO1xufVxuIl0sInNvdXJjZVJvb3QiOiIifQ== */"]
  });
}


/***/ }),

/***/ 19061:
/*!*******************************************************************************!*\
  !*** ./src/app/modules/user-manaement/add-reminder/add-reminder.component.ts ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AddReminderComponent": () => (/* binding */ AddReminderComponent)
/* harmony export */ });
/* harmony import */ var _var_www_html_Ag_admin_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js */ 71670);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @angular/forms */ 69542);
/* harmony import */ var _angular_material_dialog__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @angular/material/dialog */ 67486);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @angular/core */ 86839);
/* harmony import */ var app_services_validations_service__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! app/services/validations.service */ 27681);
/* harmony import */ var app_services_loader_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! app/services/loader.service */ 38555);
/* harmony import */ var app_services_pet_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! app/services/pet.service */ 59976);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @angular/common */ 86477);
/* harmony import */ var _components_controllers_input_input_component__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../components/controllers/input/input.component */ 30867);
/* harmony import */ var _components_controllers_checkbox_checkbox_component__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../components/controllers/checkbox/checkbox.component */ 51008);
/* harmony import */ var _components_controllers_time_picker_time_picker_component__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../components/controllers/time-picker/time-picker.component */ 59858);
/* harmony import */ var _components_controllers_date_picker_date_picker_component__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../../components/controllers/date-picker/date-picker.component */ 49582);
/* harmony import */ var _components_controllers_text_area_text_area_component__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../../components/controllers/text-area/text-area.component */ 17311);
/* harmony import */ var _components_controllers_toggle_btn_toggle_btn_component__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../../components/controllers/toggle-btn/toggle-btn.component */ 67212);
/* harmony import */ var _angular_material_button__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @angular/material/button */ 83677);
/* harmony import */ var _angular_material_icon__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! @angular/material/icon */ 69941);


















function AddReminderComponent_div_0_div_18_div_1_Template(rf, ctx) {
  if (rf & 1) {
    const _r5 = _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](0, "div", 17)(1, "app-checkbox", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵlistener"]("click", function AddReminderComponent_div_0_div_18_div_1_Template_app_checkbox_click_1_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵrestoreView"](_r5);
      const ctx_r4 = _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵnextContext"](3);
      return _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵresetView"](ctx_r4.changeVal($event));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]()();
  }
  if (rf & 2) {
    const day_r3 = ctx.$implicit;
    const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵnextContext"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("form", ctx_r2.form.get("workSpaceTimings"))("controller", ctx_r2.controlls["workSpaceTimings"][day_r3]);
  }
}
function AddReminderComponent_div_0_div_18_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](0, "div", 4);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtemplate"](1, AddReminderComponent_div_0_div_18_div_1_Template, 2, 2, "div", 16);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("ngForOf", ctx_r1.weekdays);
  }
}
function AddReminderComponent_div_0_Template(rf, ctx) {
  if (rf & 1) {
    const _r7 = _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](0, "div", 1)(1, "div", 2)(2, "h1");
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtext"](3, "Add Reminder");
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](4, "button", 3);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵlistener"]("click", function AddReminderComponent_div_0_Template_button_click_4_listener() {
      _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵrestoreView"](_r7);
      const ctx_r6 = _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵresetView"](ctx_r6.onNoClick());
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](5, "mat-icon");
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtext"](6, "close");
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]()()();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](7, "div", 4);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelement"](8, "app-input", 5);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](9, "div", 4);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelement"](10, "app-text-area", 5);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](11, "div", 6);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelement"](12, "app-date-picker", 7)(13, "app-date-picker", 8);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](14, "div", 4);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelement"](15, "app-time-picker", 9);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](16, "div", 10);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelement"](17, "app-toggle-btn", 11);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtemplate"](18, AddReminderComponent_div_0_div_18_Template, 2, 1, "div", 12);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](19, "div", 13)(20, "button", 14);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵlistener"]("click", function AddReminderComponent_div_0_Template_button_click_20_listener() {
      _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵrestoreView"](_r7);
      const ctx_r8 = _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵresetView"](ctx_r8.onNoClick());
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtext"](21, "Cancel");
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](22, "button", 15);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵlistener"]("click", function AddReminderComponent_div_0_Template_button_click_22_listener() {
      _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵrestoreView"](_r7);
      const ctx_r9 = _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵresetView"](ctx_r9.add());
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtext"](23, "Save");
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]()()();
  }
  if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](8);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("form", ctx_r0.form)("controller", ctx_r0.controlls["reminderTitle"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("form", ctx_r0.form)("controller", ctx_r0.controlls["description"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("form", ctx_r0.form)("controller", ctx_r0.controlls["date"])("max", ctx_r0.form.get("endDate").value);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("form", ctx_r0.form)("controller", ctx_r0.controlls["endDate"])("min", ctx_r0.form.get("date").value);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("form", ctx_r0.form)("controller", ctx_r0.controlls["time"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("form", ctx_r0.form)("controller", ctx_r0.controlls["repeate"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("ngIf", ctx_r0.form.get("repeate").value !== "Never");
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("disabled", ctx_r0.form.invalid);
  }
}
class AddReminderComponent {
  constructor(dialogRef, data, validationsService, fb, loader, petService) {
    this.dialogRef = dialogRef;
    this.data = data;
    this.validationsService = validationsService;
    this.fb = fb;
    this.loader = loader;
    this.petService = petService;
    this.weekdays = ['Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat', 'Sun'];
    this.createControlls();
    this.createForm();
  }
  ngOnInit() {
    if (this.data['record']) {
      this.edit();
    }
    if (this.form.get('repeate').value == 'Never') {
      this.form.get('workSpaceTimings').clearValidators();
      this.form.get('workSpaceTimings').updateValueAndValidity();
    }
    this.form.get('repeate').valueChanges.subscribe(chnage => {
      if (chnage == 'Never') {
        this.form.get('workSpaceTimings').clearValidators();
        this.form.get('workSpaceTimings').updateValueAndValidity();
      } else {
        this.form.get('workSpaceTimings').setValidators(this.validationsService.atLeastOneSelectedValidator());
        this.form.get('workSpaceTimings').updateValueAndValidity();
      }
      this.allDaysValuechanges(chnage);
    });
    const daysGroup = this.form.get('workSpaceTimings');
    Object.keys(daysGroup.controls).forEach(key => {
      daysGroup.get(key).valueChanges.subscribe(() => {
        const allDaysSelected = this.weekdays.filter(day => daysGroup.get(day).value === false);
        if (allDaysSelected.length > 0 && this.form.get('repeate').value == 'Daily' && key === 'Sun') {
          this.form.get('repeate').setValue('Custom');
        }
      });
    });
  }
  edit() {
    let el = this.data['record'];
    this.form = this.fb.group({
      id: [el['id']],
      reminderTitle: [el['title'], _angular_forms__WEBPACK_IMPORTED_MODULE_11__.Validators.required],
      description: [el['description']],
      date: [new Date(el['reminderTime']), _angular_forms__WEBPACK_IMPORTED_MODULE_11__.Validators.required],
      endDate: [new Date(el['endDate']), _angular_forms__WEBPACK_IMPORTED_MODULE_11__.Validators.required],
      time: [this.formatTime(el['reminderTime']), _angular_forms__WEBPACK_IMPORTED_MODULE_11__.Validators.required],
      repeate: [!el['repeat'] ? 'Never' : el['data']['repeatTime'], _angular_forms__WEBPACK_IMPORTED_MODULE_11__.Validators.required],
      workSpaceTimings: this.fb.group({
        Mon: [''],
        Tue: [''],
        Wed: [''],
        Thu: [''],
        Fri: [''],
        Sat: [''],
        Sun: ['']
        // all : ['']
      }, {
        validator: this.validationsService.atLeastOneSelectedValidator()
      })
    });
    if (this.form.get('repeate').value == 'Never') {
      this.form.get('workSpaceTimings').clearValidators();
      this.form.get('workSpaceTimings').updateValueAndValidity();
    }
    el['data']['days'].forEach(day => {
      if (day == "Mon") {
        this.form.get('workSpaceTimings').get('Mon').setValue(true);
      }
      if (day == "Tue") {
        this.form.get('workSpaceTimings').get('Tue').setValue(true);
      }
      if (day == "Wed") {
        this.form.get('workSpaceTimings').get('Wed').setValue(true);
      }
      if (day == "Thu") {
        this.form.get('workSpaceTimings').get('Thu').setValue(true);
      }
      if (day == "Fri" || day == "fri") {
        this.form.get('workSpaceTimings').get('Fri').setValue(true);
      }
      if (day == "Sat") {
        this.form.get('workSpaceTimings').get('Sat').setValue(true);
      }
      if (day == "Sun") {
        this.form.get('workSpaceTimings').get('Sun').setValue(true);
      }
    });
  }
  changeVal(e) {
    this.form.get('repeate').setValue('Custom');
  }
  createForm() {
    this.form = this.fb.group({
      reminderTitle: ['', _angular_forms__WEBPACK_IMPORTED_MODULE_11__.Validators.required],
      description: [''],
      date: ['', _angular_forms__WEBPACK_IMPORTED_MODULE_11__.Validators.required],
      endDate: ['', _angular_forms__WEBPACK_IMPORTED_MODULE_11__.Validators.required],
      time: ['', _angular_forms__WEBPACK_IMPORTED_MODULE_11__.Validators.required],
      repeate: ['', _angular_forms__WEBPACK_IMPORTED_MODULE_11__.Validators.required],
      workSpaceTimings: this.fb.group({
        Mon: [false],
        Tue: [false],
        Wed: [false],
        Thu: [false],
        Fri: [false],
        Sat: [false],
        Sun: [false]
        // all : ['']
      }, {
        validator: this.validationsService.atLeastOneSelectedValidator()
      })
    });
  }
  allDaysValuechanges(chnage) {
    // this.formGroup.get('addDays').valueChanges.subscribe((chnage)=>{
    if (chnage == 'Daily') {
      this.weekdays.forEach(day => {
        this.form.get('workSpaceTimings').get(day).setValue(true);
      });
    } else if (chnage == 'Never') {
      this.weekdays.forEach(day => {
        this.form.get('workSpaceTimings').get(day).setValue(false);
      });
    }
    // })
  }
  createControlls() {
    this.controlls = {
      reminderTitle: {
        id: "reminderTitle",
        name: 'reminderTitle',
        label: "Reminder Title",
        placeholder: "Enter Reminder Title",
        required: true,
        type: "toggle"
      },
      description: {
        id: "description",
        name: 'description',
        label: "Description",
        placeholder: "Enter Description",
        required: true,
        type: "toggle"
      },
      date: {
        id: "date",
        name: 'date',
        label: "Start Date",
        placeholder: "Select Date",
        required: true,
        type: "text"
      },
      endDate: {
        id: "endDate",
        name: 'endDate',
        label: "End Date",
        placeholder: "Select Date",
        required: true,
        type: "text"
      },
      time: {
        id: "time",
        name: 'time',
        label: "Time*",
        placeholder: "Select Time",
        required: true,
        type: "Date"
      },
      repeate: {
        id: "repeate",
        name: 'repeate',
        label: "Repeat",
        placeholder: "",
        required: true,
        type: "Date",
        options: [{
          name: 'Never',
          value: 'Never'
        }, {
          name: 'Daily',
          value: 'Daily'
        }, {
          name: 'Custom',
          value: 'Custom'
        }]
      },
      addDays: {
        id: "addDays",
        name: "addDays",
        label: "All Days"
      },
      workSpaceTimings: {
        Mon: {
          id: "Mon",
          name: 'Mon',
          label: "Mon",
          required: true,
          type: "checkbox"
        },
        Tue: {
          id: "Tue",
          name: 'Tue',
          label: "Tue",
          required: true,
          type: "checkbox"
        },
        Wed: {
          id: "Wed",
          name: 'Wed',
          label: "Wed",
          required: true,
          type: "checkbox"
        },
        Thu: {
          id: "Thu",
          name: 'Thu',
          label: "Thu",
          required: true,
          type: "checkbox"
        },
        Fri: {
          id: "Fri",
          name: 'Fri',
          label: "Fri",
          required: true,
          type: "checkbox"
        },
        Sat: {
          id: "Sat",
          name: 'Sat',
          label: "Sat",
          required: true,
          type: "checkbox"
        },
        Sun: {
          id: "Sun",
          name: 'Sun',
          label: "Sun",
          required: true,
          type: "checkbox"
        }
        // all: {
        //   id: "all",
        //   name: 'all',
        //   label: "All Days",
        //   required: true,
        //   type: "checkbox"
        // }
      }
    };
  }
  onNoClick() {
    this.dialogRef.close();
  }
  add() {
    var _this = this;
    return (0,_var_www_html_Ag_admin_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      // (this.data['remindersArray'] as FormArray).push(this.form);
      let json = _this.form.value;
      console.log(_this.convertTimeToMilliseconds());
      let data = {
        title: json['reminderTitle'],
        description: json['description'],
        reminderTime: _this.convertTimeToMilliseconds(),
        endDate: new Date(json['endDate']).getTime(),
        userId: sessionStorage.getItem('petParentId'),
        repeat: json['repeate'] == 'Never' ? false : true,
        data: json['repeate'] !== 'Never' ? {
          repeatTime: json['repeate'],
          days: []
        } : {},
        petId: sessionStorage.getItem('petId')
      };
      Object.keys(json['workSpaceTimings']).forEach(key => {
        if (json['workSpaceTimings'][key] == true) {
          data['data']['days'].push(key);
        }
      });
      // this.dialogRef.close();
      // this.petService.getReminders(sessionStorage.getItem('petParentId')).subscribe((res) => {
      //   debugger
      //   console.log(res);
      //   this.loader.hideLoader();
      //   this.dialogRef.close()
      // }, (error => {
      //   this.loader.hideLoader();
      // }))
      if (_this.data['record']) {
        _this.loader.showLoader();
        data['id'] = _this.data['record']['id'];
        _this.petService.editReminder(data).subscribe(res => {
          console.log("res", res);
          _this.loader.hideLoader();
          _this.dialogRef.close();
        }, error => {
          _this.loader.hideLoader();
          _this.dialogRef.close();
        });
      } else {
        _this.loader.showLoader();
        _this.petService.addReminders(data).subscribe(res => {
          _this.dialogRef.close();
          // this.petService.getReminders(sessionStorage.getItem('petParentId')).subscribe((res) => {
          //   console.log(res);
          //   this.loader.hideLoader();
          //   this.dialogRef.close()
          // }, (error => {
          //   this.loader.hideLoader();
          // }))
          _this.loader.hideLoader();
          _this.dialogRef.close();
        }, error => {
          _this.loader.hideLoader();
          _this.dialogRef.close();
        });
      }
    })();
  }
  convertTimeToMilliseconds() {
    const reminderTime = new Date(this.form.get('date').value);
    const time = this.form.get('time').value.toString();
    const [timePart, period] = time.split(" "); // Split time into time and period (AM/PM)
    const [hours, minutes] = timePart.split(":").map(Number); // Split hours and minutes
    let adjustedHours = hours;
    // Adjust hours based on AM/PM
    if (period === 'PM' && hours < 12) {
      adjustedHours += 12; // Convert PM hours to 24-hour format
    } else if (period === 'AM' && hours === 12) {
      adjustedHours = 0; // Handle 12 AM (midnight)
    }
    // Set the hours and minutes
    reminderTime.setHours(adjustedHours);
    reminderTime.setMinutes(minutes);
    return reminderTime.getTime();
  }
  formatTime(date) {
    date = new Date(date);
    let hours = date.getHours();
    let minutes = date.getMinutes();
    const ampm = hours >= 12 ? 'PM' : 'AM';
    hours = hours % 12;
    hours = hours ? hours : 12; // the hour '0' should be '12'
    minutes = minutes < 10 ? '0' + minutes : minutes;
    const timeString = `${hours}:${minutes} ${ampm}`;
    return timeString;
  }
  onUpload(event) {
    this.form.get('document').setValue(event);
  }
  static #_ = this.ɵfac = function AddReminderComponent_Factory(t) {
    return new (t || AddReminderComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵdirectiveInject"](_angular_material_dialog__WEBPACK_IMPORTED_MODULE_12__.MatDialogRef), _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵdirectiveInject"](_angular_material_dialog__WEBPACK_IMPORTED_MODULE_12__.MAT_DIALOG_DATA), _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵdirectiveInject"](app_services_validations_service__WEBPACK_IMPORTED_MODULE_1__.ValidationsService), _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵdirectiveInject"](_angular_forms__WEBPACK_IMPORTED_MODULE_11__.FormBuilder), _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵdirectiveInject"](app_services_loader_service__WEBPACK_IMPORTED_MODULE_2__.LoaderService), _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵdirectiveInject"](app_services_pet_service__WEBPACK_IMPORTED_MODULE_3__.PetService));
  };
  static #_2 = this.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵdefineComponent"]({
    type: AddReminderComponent,
    selectors: [["app-add-reminder"]],
    decls: 1,
    vars: 1,
    consts: [["mat-dialog-content", "", "class", "wrapper", 4, "ngIf"], ["mat-dialog-content", "", 1, "wrapper"], [1, "header"], ["mat-icon-button", "", "color", "primary", 3, "click"], [1, "row"], [2, "width", "100%", 3, "form", "controller"], [1, "row", 2, "height", "20%"], [2, "width", "45%", 3, "form", "controller", "max"], [2, "width", "45%", 3, "form", "controller", "min"], [3, "form", "controller"], [1, "row", 2, "padding-left", "1%"], ["multiple", "false", 3, "form", "controller"], ["class", "row", 4, "ngIf"], [1, "btn-wrapper"], ["mat-stroked-button", "", "color", "primary", 3, "click"], ["mat-stroked-button", "", "color", "primary", 3, "disabled", "click"], ["weekdays", "", 4, "ngFor", "ngForOf"], ["weekdays", ""], [3, "form", "controller", "click"]],
    template: function AddReminderComponent_Template(rf, ctx) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtemplate"](0, AddReminderComponent_div_0_Template, 24, 16, "div", 0);
      }
      if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("ngIf", ctx.data);
      }
    },
    dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_13__.NgForOf, _angular_common__WEBPACK_IMPORTED_MODULE_13__.NgIf, _components_controllers_input_input_component__WEBPACK_IMPORTED_MODULE_4__.InputComponent, _components_controllers_checkbox_checkbox_component__WEBPACK_IMPORTED_MODULE_5__.CheckboxComponent, _components_controllers_time_picker_time_picker_component__WEBPACK_IMPORTED_MODULE_6__.TimePickerComponent, _components_controllers_date_picker_date_picker_component__WEBPACK_IMPORTED_MODULE_7__.DatePickerComponent, _components_controllers_text_area_text_area_component__WEBPACK_IMPORTED_MODULE_8__.TextAreaComponent, _components_controllers_toggle_btn_toggle_btn_component__WEBPACK_IMPORTED_MODULE_9__.ToggleBtnComponent, _angular_material_button__WEBPACK_IMPORTED_MODULE_14__.MatButton, _angular_material_button__WEBPACK_IMPORTED_MODULE_14__.MatIconButton, _angular_material_icon__WEBPACK_IMPORTED_MODULE_15__.MatIcon],
    styles: [".header[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: row;\n  justify-content: space-between;\n}\n\n.row[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: row;\n  justify-content: space-between;\n  align-items: center;\n  width: 90%;\n  height: 20%;\n  margin: 1%;\n}\n\n.btn-wrapper[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: row;\n  justify-content: right;\n}\n.btn-wrapper[_ngcontent-%COMP%]   button[_ngcontent-%COMP%] {\n  margin: 10px;\n}\n\n.wrapper[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: column;\n}\n\n.header[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: row;\n  justify-content: space-between;\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImFkZC1yZW1pbmRlci5jb21wb25lbnQuc2NzcyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTtFQUNJLGFBQUE7RUFDQSxtQkFBQTtFQUNBLDhCQUFBO0FBQ0o7O0FBRUE7RUFDSSxhQUFBO0VBQ0EsbUJBQUE7RUFDQSw4QkFBQTtFQUNBLG1CQUFBO0VBQ0EsVUFBQTtFQUNBLFdBQUE7RUFDQSxVQUFBO0FBQ0o7O0FBQ0E7RUFDSSxhQUFBO0VBQ0EsbUJBQUE7RUFDQSxzQkFBQTtBQUVKO0FBREk7RUFDSSxZQUFBO0FBR1I7O0FBQUE7RUFDSSxhQUFBO0VBQ0Esc0JBQUE7QUFHSjs7QUFBQTtFQUNJLGFBQUE7RUFDQSxtQkFBQTtFQUNBLDhCQUFBO0FBR0oiLCJmaWxlIjoiYWRkLXJlbWluZGVyLmNvbXBvbmVudC5zY3NzIiwic291cmNlc0NvbnRlbnQiOlsiLmhlYWRlcntcbiAgICBkaXNwbGF5OiBmbGV4O1xuICAgIGZsZXgtZGlyZWN0aW9uOiByb3c7XG4gICAganVzdGlmeS1jb250ZW50OiBzcGFjZS1iZXR3ZWVuO1xufVxuXG4ucm93e1xuICAgIGRpc3BsYXk6IGZsZXg7XG4gICAgZmxleC1kaXJlY3Rpb246IHJvdztcbiAgICBqdXN0aWZ5LWNvbnRlbnQ6IHNwYWNlLWJldHdlZW47XG4gICAgYWxpZ24taXRlbXM6IGNlbnRlcjtcbiAgICB3aWR0aDogOTAlO1xuICAgIGhlaWdodDogMjAlO1xuICAgIG1hcmdpbjogMSU7XG59XG4uYnRuLXdyYXBwZXJ7XG4gICAgZGlzcGxheTogZmxleDtcbiAgICBmbGV4LWRpcmVjdGlvbjogcm93O1xuICAgIGp1c3RpZnktY29udGVudDogcmlnaHQ7XG4gICAgYnV0dG9ue1xuICAgICAgICBtYXJnaW46IDEwcHg7XG4gICAgfVxufSBcbi53cmFwcGVye1xuICAgIGRpc3BsYXk6IGZsZXg7XG4gICAgZmxleC1kaXJlY3Rpb246IGNvbHVtbjtcblxufVxuLmhlYWRlcntcbiAgICBkaXNwbGF5OiBmbGV4O1xuICAgIGZsZXgtZGlyZWN0aW9uOiByb3c7XG4gICAganVzdGlmeS1jb250ZW50OiBzcGFjZS1iZXR3ZWVuO1xufVxuIl19 */\n/*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8uL3NyYy9hcHAvbW9kdWxlcy91c2VyLW1hbmFlbWVudC9hZGQtcmVtaW5kZXIvYWRkLXJlbWluZGVyLmNvbXBvbmVudC5zY3NzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBO0VBQ0ksYUFBQTtFQUNBLG1CQUFBO0VBQ0EsOEJBQUE7QUFDSjs7QUFFQTtFQUNJLGFBQUE7RUFDQSxtQkFBQTtFQUNBLDhCQUFBO0VBQ0EsbUJBQUE7RUFDQSxVQUFBO0VBQ0EsV0FBQTtFQUNBLFVBQUE7QUFDSjs7QUFDQTtFQUNJLGFBQUE7RUFDQSxtQkFBQTtFQUNBLHNCQUFBO0FBRUo7QUFESTtFQUNJLFlBQUE7QUFHUjs7QUFBQTtFQUNJLGFBQUE7RUFDQSxzQkFBQTtBQUdKOztBQUFBO0VBQ0ksYUFBQTtFQUNBLG1CQUFBO0VBQ0EsOEJBQUE7QUFHSjtBQUNBLGcwQ0FBZzBDIiwic291cmNlc0NvbnRlbnQiOlsiLmhlYWRlcntcbiAgICBkaXNwbGF5OiBmbGV4O1xuICAgIGZsZXgtZGlyZWN0aW9uOiByb3c7XG4gICAganVzdGlmeS1jb250ZW50OiBzcGFjZS1iZXR3ZWVuO1xufVxuXG4ucm93e1xuICAgIGRpc3BsYXk6IGZsZXg7XG4gICAgZmxleC1kaXJlY3Rpb246IHJvdztcbiAgICBqdXN0aWZ5LWNvbnRlbnQ6IHNwYWNlLWJldHdlZW47XG4gICAgYWxpZ24taXRlbXM6IGNlbnRlcjtcbiAgICB3aWR0aDogOTAlO1xuICAgIGhlaWdodDogMjAlO1xuICAgIG1hcmdpbjogMSU7XG59XG4uYnRuLXdyYXBwZXJ7XG4gICAgZGlzcGxheTogZmxleDtcbiAgICBmbGV4LWRpcmVjdGlvbjogcm93O1xuICAgIGp1c3RpZnktY29udGVudDogcmlnaHQ7XG4gICAgYnV0dG9ue1xuICAgICAgICBtYXJnaW46IDEwcHg7XG4gICAgfVxufSBcbi53cmFwcGVye1xuICAgIGRpc3BsYXk6IGZsZXg7XG4gICAgZmxleC1kaXJlY3Rpb246IGNvbHVtbjtcblxufVxuLmhlYWRlcntcbiAgICBkaXNwbGF5OiBmbGV4O1xuICAgIGZsZXgtZGlyZWN0aW9uOiByb3c7XG4gICAganVzdGlmeS1jb250ZW50OiBzcGFjZS1iZXR3ZWVuO1xufVxuIl0sInNvdXJjZVJvb3QiOiIifQ== */"]
  });
}


/***/ }),

/***/ 69870:
/*!*******************************************************************************************!*\
  !*** ./src/app/modules/user-manaement/add-user-view-mode/add-user-view-mode.component.ts ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AddUserViewModeComponent": () => (/* binding */ AddUserViewModeComponent)
/* harmony export */ });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ 86839);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/forms */ 69542);
/* harmony import */ var app_services_user_management_service__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! app/services/user-management.service */ 32555);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/router */ 86679);
/* harmony import */ var _angular_material_dialog__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/material/dialog */ 67486);
/* harmony import */ var _angular_material_snack_bar__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/material/snack-bar */ 88511);
/* harmony import */ var app_services_validations_service__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! app/services/validations.service */ 27681);
/* harmony import */ var app_services_loader_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! app/services/loader.service */ 38555);
/* harmony import */ var _angular_material_button__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @angular/material/button */ 83677);
/* harmony import */ var _angular_material_icon__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @angular/material/icon */ 69941);











class AddUserViewModeComponent {
  constructor(fb, userManagementService, router, dialog, snackBar, validationsService, loader) {
    this.fb = fb;
    this.userManagementService = userManagementService;
    this.router = router;
    this.dialog = dialog;
    this.snackBar = snackBar;
    this.validationsService = validationsService;
    this.loader = loader;
    this.cancelEvent = new _angular_core__WEBPACK_IMPORTED_MODULE_3__.EventEmitter();
    this.displayedColumns = ['id', 'petName', 'type', 'breed', 'gender', 'action'];
  }
  ngOnInit() {
    this.form = this.fb.group({
      id: [{
        value: '',
        disabled: true
      }],
      name: [{
        value: '',
        disabled: true
      }],
      joinedDate: [{
        value: '',
        disabled: true
      }],
      city: [{
        value: '',
        disabled: true
      }],
      mobile: [{
        value: '',
        disabled: true
      }],
      countryCode: [{
        value: '',
        disabled: true
      }],
      email: [{
        value: '',
        disabled: true
      }],
      gender: [{
        value: '',
        disabled: true
      }],
      sos: [{
        value: false,
        disabled: true
      }],
      latitude: [{
        value: '',
        disabled: true
      }],
      longitude: [{
        value: '',
        disabled: true
      }],
      status: [{
        value: '',
        disabled: true
      }],
      profileImage: [{
        value: '',
        disabled: true
      }],
      test: [{
        value: false,
        disabled: true
      }],
      verified: [{
        value: false,
        disabled: true
      }],
      emailVerified: [{
        value: false,
        disabled: true
      }]
    });
    const userData = this.viewData;
    this.form.patchValue(userData);
  }
  edit() {}
  close() {
    this.cancelEvent.emit();
  }
  static #_ = this.ɵfac = function AddUserViewModeComponent_Factory(t) {
    return new (t || AddUserViewModeComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵdirectiveInject"](_angular_forms__WEBPACK_IMPORTED_MODULE_4__.FormBuilder), _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵdirectiveInject"](app_services_user_management_service__WEBPACK_IMPORTED_MODULE_0__.UserManagementService), _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵdirectiveInject"](_angular_router__WEBPACK_IMPORTED_MODULE_5__.Router), _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵdirectiveInject"](_angular_material_dialog__WEBPACK_IMPORTED_MODULE_6__.MatDialog), _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵdirectiveInject"](_angular_material_snack_bar__WEBPACK_IMPORTED_MODULE_7__.MatSnackBar), _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵdirectiveInject"](app_services_validations_service__WEBPACK_IMPORTED_MODULE_1__.ValidationsService), _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵdirectiveInject"](app_services_loader_service__WEBPACK_IMPORTED_MODULE_2__.LoaderService));
  };
  static #_2 = this.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵdefineComponent"]({
    type: AddUserViewModeComponent,
    selectors: [["app-add-user-view-mode"]],
    inputs: {
      viewData: "viewData"
    },
    outputs: {
      cancelEvent: "cancelEvent"
    },
    decls: 76,
    vars: 2,
    consts: [[1, "form-container"], [1, "form-header"], [1, "header-left"], ["mat-icon-button", "", 3, "click"], [1, "header-right"], [3, "formGroup"], [1, "form-field"], [2, "display", "flex", "justify-content", "center"], ["alt", "Profile Image", 2, "width", "200px", "height", "150px", 3, "src"], ["formControlName", "id", "readonly", ""], ["formControlName", "name", "readonly", ""], ["formControlName", "joinedDate", "readonly", ""], ["formControlName", "city", "readonly", ""], ["formControlName", "mobile", "readonly", ""], ["formControlName", "countryCode", "readonly", ""], ["formControlName", "email", "readonly", ""], ["formControlName", "gender", "readonly", ""], ["type", "checkbox", "formControlName", "sos", "disabled", ""], ["formControlName", "latitude", "readonly", ""], ["formControlName", "longitude", "readonly", ""], ["formControlName", "status", "readonly", ""], ["type", "checkbox", "formControlName", "test", "disabled", ""], ["type", "checkbox", "formControlName", "verified", "disabled", ""], ["type", "checkbox", "formControlName", "emailVerified", "disabled", ""]],
    template: function AddUserViewModeComponent_Template(rf, ctx) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](0, "div", 0)(1, "div", 1)(2, "div", 2)(3, "h2");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](4, "User Information");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](5, "button", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵlistener"]("click", function AddUserViewModeComponent_Template_button_click_5_listener() {
          return ctx.edit();
        });
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](6, "mat-icon");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](7, "edit");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]()()();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](8, "div", 4)(9, "button", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵlistener"]("click", function AddUserViewModeComponent_Template_button_click_9_listener() {
          return ctx.close();
        });
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](10, "mat-icon");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](11, "close");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]()()()();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](12, "form", 5)(13, "div", 6)(14, "div", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelement"](15, "img", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]()();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](16, "div", 6)(17, "label");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](18, "Id");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelement"](19, "input", 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](20, "div", 6)(21, "label");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](22, "Name");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelement"](23, "input", 10);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](24, "div", 6)(25, "label");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](26, "Joined Date");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelement"](27, "input", 11);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](28, "div", 6)(29, "label");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](30, "City");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelement"](31, "input", 12);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](32, "div", 6)(33, "label");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](34, "Mobile");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelement"](35, "input", 13);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](36, "div", 6)(37, "label");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](38, "Country Code");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelement"](39, "input", 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](40, "div", 6)(41, "label");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](42, "Email");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelement"](43, "input", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](44, "div", 6)(45, "label");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](46, "Gender");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelement"](47, "input", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](48, "div", 6)(49, "label");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](50, "SOS");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelement"](51, "input", 17);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](52, "div", 6)(53, "label");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](54, "Latitude");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelement"](55, "input", 18);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](56, "div", 6)(57, "label");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](58, "Longitude");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelement"](59, "input", 19);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](60, "div", 6)(61, "label");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](62, "Status");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelement"](63, "input", 20);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](64, "div", 6)(65, "label");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](66, "Test");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelement"](67, "input", 21);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](68, "div", 6)(69, "label");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](70, "Verified");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelement"](71, "input", 22);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementStart"](72, "div", 6)(73, "label");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵtext"](74, "Email Verified");
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelement"](75, "input", 23);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵelementEnd"]()()();
      }
      if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](12);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("formGroup", ctx.form);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵproperty"]("src", ctx.form.get("profileImage").value, _angular_core__WEBPACK_IMPORTED_MODULE_3__["ɵɵsanitizeUrl"]);
      }
    },
    dependencies: [_angular_material_button__WEBPACK_IMPORTED_MODULE_8__.MatIconButton, _angular_forms__WEBPACK_IMPORTED_MODULE_4__["ɵNgNoValidate"], _angular_forms__WEBPACK_IMPORTED_MODULE_4__.DefaultValueAccessor, _angular_forms__WEBPACK_IMPORTED_MODULE_4__.CheckboxControlValueAccessor, _angular_forms__WEBPACK_IMPORTED_MODULE_4__.NgControlStatus, _angular_forms__WEBPACK_IMPORTED_MODULE_4__.NgControlStatusGroup, _angular_forms__WEBPACK_IMPORTED_MODULE_4__.FormGroupDirective, _angular_forms__WEBPACK_IMPORTED_MODULE_4__.FormControlName, _angular_material_icon__WEBPACK_IMPORTED_MODULE_9__.MatIcon],
    styles: [".form-container[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: row;\n  justify-content: space-between;\n  margin: 2px auto;\n  padding: 20px;\n  border: 1px solid #ccc;\n  border-radius: 5px;\n  box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);\n  background-color: #f9f9f9;\n}\n\n.form-header[_ngcontent-%COMP%] {\n  display: flex;\n  justify-content: space-between;\n  align-items: center;\n  margin-bottom: 20px;\n}\n\n.header-left[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: center;\n}\n\n.header-left[_ngcontent-%COMP%]   h2[_ngcontent-%COMP%] {\n  margin: 0;\n  margin-right: 20px;\n  font-size: 18px;\n  font-weight: 400;\n}\n\n.header-left[_ngcontent-%COMP%]   button[_ngcontent-%COMP%] {\n  padding: 10px 20px;\n  font-size: 16px;\n  color: #fff;\n  border: none;\n  border-radius: 5px;\n  cursor: pointer;\n}\n\n.header-right[_ngcontent-%COMP%]   button[_ngcontent-%COMP%] {\n  font-size: 24px;\n  background: none;\n  border: none;\n  cursor: pointer;\n}\n\n.header-right[_ngcontent-%COMP%]   button[_ngcontent-%COMP%]:hover {\n  color: red;\n}\n\n.form-field[_ngcontent-%COMP%]   img[_ngcontent-%COMP%] {\n  max-width: 150px;\n  \n  height: auto;\n  \n  border: 1px solid #ccc;\n  border-radius: 4px;\n}\n\n.form-field[_ngcontent-%COMP%] {\n  margin-bottom: 15px;\n}\n\n.form-field[_ngcontent-%COMP%]   label[_ngcontent-%COMP%] {\n  display: block;\n  font-weight: bold;\n  margin-bottom: 5px;\n}\n\n.form-field[_ngcontent-%COMP%]   input[_ngcontent-%COMP%] {\n  width: 100%;\n  padding: 8px;\n  border: 1px solid #ccc;\n  border-radius: 4px;\n  background-color: #e9e9e9;\n}\n\n.form-field[_ngcontent-%COMP%]   img[_ngcontent-%COMP%] {\n  max-width: 100%;\n  height: auto;\n  border: 1px solid #ccc;\n  border-radius: 4px;\n}\n\n.form-field[_ngcontent-%COMP%]   input[readonly][_ngcontent-%COMP%] {\n  background-color: #e9e9e9;\n}\n\n.form-field[_ngcontent-%COMP%]   input[type=checkbox][_ngcontent-%COMP%] {\n  width: auto;\n}\n/*# sourceMappingURL=data:application/json;base64,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 */\n/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */"]
  });
}


/***/ }),

/***/ 47820:
/*!***********************************************************************!*\
  !*** ./src/app/modules/user-manaement/add-user/add-user.component.ts ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AddUserComponent": () => (/* binding */ AddUserComponent)
/* harmony export */ });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @angular/core */ 86839);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @angular/forms */ 69542);
/* harmony import */ var _angular_material_table__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @angular/material/table */ 83348);
/* harmony import */ var _user_activity_history_user_activity_history_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../user-activity-history/user-activity-history.component */ 17496);
/* harmony import */ var app_components_controllers_success_dialog_success_dialog_component__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! app/components/controllers/success-dialog/success-dialog.component */ 92814);
/* harmony import */ var _angular_material_menu__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! @angular/material/menu */ 89314);
/* harmony import */ var app_components_controllers_confirmation_dialog_confirmation_dialog_component__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! app/components/controllers/confirmation-dialog/confirmation-dialog.component */ 81500);
/* harmony import */ var _add_address_pet_parent_add_address_pet_parent_component__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../add-address-pet-parent/add-address-pet-parent.component */ 7998);
/* harmony import */ var app_services_user_management_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! app/services/user-management.service */ 32555);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @angular/router */ 86679);
/* harmony import */ var _angular_material_dialog__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @angular/material/dialog */ 67486);
/* harmony import */ var _angular_material_snack_bar__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! @angular/material/snack-bar */ 88511);
/* harmony import */ var app_services_validations_service__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! app/services/validations.service */ 27681);
/* harmony import */ var app_services_loader_service__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! app/services/loader.service */ 38555);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! @angular/common */ 86477);
/* harmony import */ var _components_controllers_input_input_component__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../../components/controllers/input/input.component */ 30867);
/* harmony import */ var _components_controllers_file_upload_file_upload_component__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../../components/controllers/file-upload/file-upload.component */ 76956);
/* harmony import */ var _components_controllers_radio_btn_radio_btn_component__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../../components/controllers/radio-btn/radio-btn.component */ 49068);
/* harmony import */ var _angular_material_button__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! @angular/material/button */ 83677);
/* harmony import */ var _angular_material_icon__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! @angular/material/icon */ 69941);
























function AddUserComponent_h1_4_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](0, "h1", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtext"](1, "Add Pet Parent");
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
  }
}
function AddUserComponent_h1_5_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](0, "h1", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtext"](1, "Edit Pet Parent");
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
  }
}
function AddUserComponent_div_27_div_4_Template(rf, ctx) {
  if (rf & 1) {
    const _r11 = _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](0, "div", 28)(1, "div", 29)(2, "div", 30)(3, "p")(4, "strong");
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtext"](5, "Type:");
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtext"](6);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](7, "p")(8, "strong");
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtext"](9, "Flat No:");
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtext"](10);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](11, "p")(12, "strong");
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtext"](13, "Address:");
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtext"](14);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](15, "p")(16, "strong");
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtext"](17, "City:");
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtext"](18);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](19, "p")(20, "strong");
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtext"](21, "Pincode:");
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtext"](22);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](23, "p")(24, "strong");
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtext"](25, "Location:");
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtext"](26);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](27, "p")(28, "strong");
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtext"](29, "State:");
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtext"](30);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](31, "button", 31);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵlistener"]("click", function AddUserComponent_div_27_div_4_Template_button_click_31_listener() {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵrestoreView"](_r11);
      const i_r9 = restoredCtx.index;
      const address_r8 = restoredCtx.$implicit;
      const ctx_r10 = _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵnextContext"](2);
      return _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵresetView"](ctx_r10.removeAddress(i_r9, address_r8));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtext"](32, "Delete");
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](33, "button", 32);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵlistener"]("click", function AddUserComponent_div_27_div_4_Template_button_click_33_listener() {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵrestoreView"](_r11);
      const i_r9 = restoredCtx.index;
      const address_r8 = restoredCtx.$implicit;
      const ctx_r12 = _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵnextContext"](2);
      return _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵresetView"](ctx_r12.updateAddress(i_r9, address_r8));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtext"](34, "Update");
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]()()()();
  }
  if (rf & 2) {
    const address_r8 = ctx.$implicit;
    const i_r9 = ctx.index;
    let tmp_1_0;
    let tmp_2_0;
    let tmp_3_0;
    let tmp_4_0;
    let tmp_5_0;
    let tmp_6_0;
    let tmp_7_0;
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("formGroupName", i_r9);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](6);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtextInterpolate1"](" ", (tmp_1_0 = address_r8.get("type")) == null ? null : tmp_1_0.value, "");
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtextInterpolate1"](" ", (tmp_2_0 = address_r8.get("flatNo")) == null ? null : tmp_2_0.value, "");
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtextInterpolate1"](" ", (tmp_3_0 = address_r8.get("address")) == null ? null : tmp_3_0.value, "");
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtextInterpolate1"](" ", (tmp_4_0 = address_r8.get("city")) == null ? null : tmp_4_0.value, "");
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtextInterpolate1"](" ", (tmp_5_0 = address_r8.get("pincode")) == null ? null : tmp_5_0.value, "");
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtextInterpolate1"](" ", (tmp_6_0 = address_r8.get("location")) == null ? null : tmp_6_0.value, "");
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtextInterpolate1"](" ", (tmp_7_0 = address_r8.get("state")) == null ? null : tmp_7_0.value, "");
  }
}
function AddUserComponent_div_27_Template(rf, ctx) {
  if (rf & 1) {
    const _r14 = _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](0, "div", 24)(1, "button", 25);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵlistener"]("click", function AddUserComponent_div_27_Template_button_click_1_listener() {
      _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵrestoreView"](_r14);
      const ctx_r13 = _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵresetView"](ctx_r13.addAddress());
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtext"](2, "Add Address");
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](3, "div", 26);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtemplate"](4, AddUserComponent_div_27_div_4_Template, 35, 8, "div", 27);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]()();
  }
  if (rf & 2) {
    const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("formGroup", ctx_r2.addressForm);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("ngForOf", ctx_r2.addresses.controls);
  }
}
function AddUserComponent_div_28_Template(rf, ctx) {
  if (rf & 1) {
    const _r16 = _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](0, "div", 33)(1, "h1", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtext"](2, "Pets List");
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](3, "button", 34);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵlistener"]("click", function AddUserComponent_div_28_Template_button_click_3_listener() {
      _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵrestoreView"](_r16);
      const ctx_r15 = _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵresetView"](ctx_r15.addPet());
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](4, "span", 19);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtext"](5, "Add Pet");
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](6, "mat-icon", 20);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtext"](7, "add");
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]()()();
  }
}
function AddUserComponent_table_29_th_2_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](0, "th", 46);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtext"](1, " ID. ");
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
  }
}
function AddUserComponent_table_29_td_3_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](0, "td", 47);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const element_r31 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtextInterpolate1"](" ", element_r31.id.substring(0, 6), " ");
  }
}
function AddUserComponent_table_29_th_5_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](0, "th", 46);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtext"](1, " Pet Name ");
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
  }
}
function AddUserComponent_table_29_td_6_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](0, "td", 47);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const element_r32 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtextInterpolate1"](" ", element_r32.petName, " ");
  }
}
function AddUserComponent_table_29_th_8_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](0, "th", 46);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtext"](1, " Species ");
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
  }
}
function AddUserComponent_table_29_td_9_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](0, "td", 47);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const element_r33 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtextInterpolate1"](" ", element_r33.type, " ");
  }
}
function AddUserComponent_table_29_th_11_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](0, "th", 46);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtext"](1, " Breed ");
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
  }
}
function AddUserComponent_table_29_td_12_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](0, "td", 47);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const element_r34 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtextInterpolate1"](" ", element_r34.breed, " ");
  }
}
function AddUserComponent_table_29_th_14_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](0, "th", 46);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtext"](1, " Gender ");
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
  }
}
function AddUserComponent_table_29_td_15_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](0, "td", 47);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const element_r35 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtextInterpolate1"](" ", element_r35.gender, " ");
  }
}
function AddUserComponent_table_29_th_17_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](0, "th", 46);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtext"](1, " Action ");
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
  }
}
function AddUserComponent_table_29_td_18_Template(rf, ctx) {
  if (rf & 1) {
    const _r39 = _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](0, "td", 47)(1, "button", 48);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵlistener"]("click", function AddUserComponent_table_29_td_18_Template_button_click_1_listener() {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵrestoreView"](_r39);
      const i_r37 = restoredCtx.index;
      const element_r36 = restoredCtx.$implicit;
      const ctx_r38 = _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵnextContext"](2);
      return _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵresetView"](ctx_r38.toggle(i_r37, element_r36));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](2, "mat-icon");
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtext"](3, "more_vert");
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]()()();
  }
  if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵnextContext"](2);
    const _r5 = _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵreference"](36);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("matMenuTriggerFor", _r5);
  }
}
function AddUserComponent_table_29_tr_19_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelement"](0, "tr", 49);
  }
}
function AddUserComponent_table_29_tr_20_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelement"](0, "tr", 50);
  }
}
function AddUserComponent_table_29_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](0, "table", 35);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementContainerStart"](1, 36);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtemplate"](2, AddUserComponent_table_29_th_2_Template, 2, 0, "th", 37);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtemplate"](3, AddUserComponent_table_29_td_3_Template, 2, 1, "td", 38);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementContainerEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementContainerStart"](4, 39);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtemplate"](5, AddUserComponent_table_29_th_5_Template, 2, 0, "th", 37);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtemplate"](6, AddUserComponent_table_29_td_6_Template, 2, 1, "td", 38);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementContainerEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementContainerStart"](7, 40);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtemplate"](8, AddUserComponent_table_29_th_8_Template, 2, 0, "th", 37);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtemplate"](9, AddUserComponent_table_29_td_9_Template, 2, 1, "td", 38);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementContainerEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementContainerStart"](10, 41);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtemplate"](11, AddUserComponent_table_29_th_11_Template, 2, 0, "th", 37);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtemplate"](12, AddUserComponent_table_29_td_12_Template, 2, 1, "td", 38);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementContainerEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementContainerStart"](13, 42);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtemplate"](14, AddUserComponent_table_29_th_14_Template, 2, 0, "th", 37);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtemplate"](15, AddUserComponent_table_29_td_15_Template, 2, 1, "td", 38);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementContainerEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementContainerStart"](16, 43);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtemplate"](17, AddUserComponent_table_29_th_17_Template, 2, 0, "th", 37);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtemplate"](18, AddUserComponent_table_29_td_18_Template, 4, 1, "td", 38);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementContainerEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtemplate"](19, AddUserComponent_table_29_tr_19_Template, 1, 0, "tr", 44);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtemplate"](20, AddUserComponent_table_29_tr_20_Template, 1, 0, "tr", 45);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const ctx_r4 = _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("dataSource", ctx_r4.pets);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](19);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("matHeaderRowDef", ctx_r4.displayedColumns);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("matRowDefColumns", ctx_r4.displayedColumns);
  }
}
function AddUserComponent_button_37_Template(rf, ctx) {
  if (rf & 1) {
    const _r43 = _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](0, "button", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵlistener"]("click", function AddUserComponent_button_37_Template_button_click_0_listener() {
      _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵrestoreView"](_r43);
      const ctx_r42 = _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵresetView"](ctx_r42.activityHistory());
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](1, "span", 19);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtext"](2, "User Activity History");
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](3, "mat-icon", 20);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtext"](4, "remove_red_eye");
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]()();
  }
}
class AddUserComponent {
  constructor(fb, userManagementService, router, dialog, snackBar, validationsService, loader) {
    this.fb = fb;
    this.userManagementService = userManagementService;
    this.router = router;
    this.dialog = dialog;
    this.snackBar = snackBar;
    this.validationsService = validationsService;
    this.loader = loader;
    this.isThereActivities = false;
    this.cancelEvent = new _angular_core__WEBPACK_IMPORTED_MODULE_10__.EventEmitter();
    this.displayedColumns = ['id', 'petName', 'type', 'breed', 'gender', 'action'];
    this.addressForm = this.fb.group({
      addresses: this.fb.array([])
    });
    this.createForm();
    this.craeteFormControllers();
  }
  ngOnInit() {}
  ngOnChanges() {
    if (this.editData) {
      this.getPets();
      this.getAddresses();
      console.log("a");
      let ele = document.getElementById("add-update");
      ele.innerHTML = "Save";
      this.edit();
    }
  }
  createForm() {
    this.userForm = this.fb.group({
      name: ['', [_angular_forms__WEBPACK_IMPORTED_MODULE_11__.Validators.required, this.validationsService.isOnlyStringValidator()]],
      email: ['', [_angular_forms__WEBPACK_IMPORTED_MODULE_11__.Validators.required, this.validationsService.emailValidator()]],
      phone: ['', [_angular_forms__WEBPACK_IMPORTED_MODULE_11__.Validators.required, this.validationsService.mobileNumberValidator()]],
      gender: ['', _angular_forms__WEBPACK_IMPORTED_MODULE_11__.Validators.required],
      city: ['', [_angular_forms__WEBPACK_IMPORTED_MODULE_11__.Validators.required, this.validationsService.cityValidation()]],
      location: ['', [_angular_forms__WEBPACK_IMPORTED_MODULE_11__.Validators.required, this.validationsService.locationValidator()]],
      profileImage: [null, _angular_forms__WEBPACK_IMPORTED_MODULE_11__.Validators.required],
      internalNotes: [null]
    });
  }
  get addresses() {
    return this.addressForm.get('addresses');
  }
  createAddress() {
    return this.fb.group({
      type: [''],
      flatNo: [''],
      address: ['', _angular_forms__WEBPACK_IMPORTED_MODULE_11__.Validators.required],
      city: ['', _angular_forms__WEBPACK_IMPORTED_MODULE_11__.Validators.required],
      pincode: ['', _angular_forms__WEBPACK_IMPORTED_MODULE_11__.Validators.required],
      location: ['', _angular_forms__WEBPACK_IMPORTED_MODULE_11__.Validators.required],
      state: ['', _angular_forms__WEBPACK_IMPORTED_MODULE_11__.Validators.required]
    });
  }
  addAddress() {
    const dialogRef = this.dialog.open(_add_address_pet_parent_add_address_pet_parent_component__WEBPACK_IMPORTED_MODULE_3__.AddAddressPetParentComponent, {
      // width: '300px'
      data: {
        petParentId: this.editData['id']
      }
    });
    dialogRef.afterClosed().subscribe(result => {
      if (result) {
        this.addresses.push(this.fb.group(result));
        this.getAddresses();
      }
    });
  }
  removeAddress(index, address) {
    this.userManagementService.deleteAddress(this.editData['id'], address.get('id').value).subscribe(res => {
      this.addresses.removeAt(index);
      this.getAddresses();
    });
  }
  updateAddress(index, address) {
    const dialogRef = this.dialog.open(_add_address_pet_parent_add_address_pet_parent_component__WEBPACK_IMPORTED_MODULE_3__.AddAddressPetParentComponent, {
      // width: '300px'
      data: {
        petParentId: this.editData['id'],
        formGroup: address,
        id: address.get('id').value
      }
    });
    dialogRef.afterClosed().subscribe(result => {
      this.getAddresses();
      if (result) {}
    });
  }
  onSubmit() {
    console.log(this.addressForm.value);
  }
  getPets() {
    if (this.editData) {
      this.loader.showLoader();
      this.userManagementService.getAllPetsByPetParent(this.editData['id']).subscribe(res => {
        console.log(res);
        this.loader.hideLoader();
        const petsArray = Object.values(res);
        this.pets = new _angular_material_table__WEBPACK_IMPORTED_MODULE_12__.MatTableDataSource(petsArray.map(item => ({
          ...item
        })));
      });
    }
  }
  getAddresses() {
    this.addresses.clear();
    this.userManagementService.getAddressesOfPet(this.editData['id']).subscribe(res => {
      res.forEach(el => {
        this.addresses.push(this.fb.group({
          id: [el.id],
          type: [el.type],
          flatNo: [el.flatNo],
          address: [el.address, _angular_forms__WEBPACK_IMPORTED_MODULE_11__.Validators.required],
          city: [el.city, _angular_forms__WEBPACK_IMPORTED_MODULE_11__.Validators.required],
          pincode: [el.pincode, _angular_forms__WEBPACK_IMPORTED_MODULE_11__.Validators.required],
          location: [el.latitude + ',' + el.longitude, _angular_forms__WEBPACK_IMPORTED_MODULE_11__.Validators.required],
          state: [el.state, _angular_forms__WEBPACK_IMPORTED_MODULE_11__.Validators.required]
        }));
      });
      console.log(res);
    });
  }
  activityHistory() {
    this.loader.showLoader();
    this.userManagementService.getAppointmentsHistoryByPetParentId(this.pet['id']).subscribe(res => {
      this.loader.hideLoader();
      if (res.length > 0) {
        this.isThereActivities = false;
      } else {
        this.isThereActivities = true;
      }
      let dialogRef = this.dialog.open(_user_activity_history_user_activity_history_component__WEBPACK_IMPORTED_MODULE_0__.UserActivityHistoryComponent, {
        data: {
          editData: res
        },
        width: '500px'
      });
      dialogRef.afterClosed().subscribe(result => {
        console.log('The dialog was closed');
      });
    });
  }
  toggle(i, element) {
    // this.getPets();
    console.log(i);
    this.pet = element;
    this.userManagementService.getAppointmentsHistoryByPetParentId(this.pet['id']).subscribe(res => {
      if (res.length > 0) {
        this.isThereActivities = true;
      } else {
        this.isThereActivities = false;
      }
    });
  }
  addPet() {
    sessionStorage.setItem('petParentId', this.editData['id']);
    this.router.navigate(['/user/pet/addPet']);
  }
  view() {
    sessionStorage.setItem('petId', this.pet['id']);
    sessionStorage.setItem('petParentId', this.editData['id']);
    this.router.navigate(['/user/pet/editPet']);
    // this.router.navigateByUrl('/user/pet/editPet',{state : {data : { editData: this.pet, petParentId: this.editData['id'] }}})
  }
  editPet() {
    console.log("hurry");
    // let dialogRef = this.dialog.open(EditPetComponent, {
    //   data: { editData: this.pet, petParentId: this.editData['id'] },
    //   width: '700px'
    // });
    // dialogRef.afterClosed().subscribe(result => {
    //   this.getPets();
    //   console.log('The dialog was closed');
    // });
  }
  deletePet() {
    const dialogRef = this.dialog.open(app_components_controllers_confirmation_dialog_confirmation_dialog_component__WEBPACK_IMPORTED_MODULE_2__.ConfirmationDialogComponent, {
      width: '400px',
      data: {
        message: 'Are you sure you want to Delete?'
      }
    });
    dialogRef.afterClosed().subscribe(result => {
      if (result) {
        // User confirmed action
        this.loader.showLoader();
        this.userManagementService.deletePet(this.pet['id']).subscribe(res => {
          this.loader.hideLoader();
          console.log(res);
          this.getPets();
        }, error => {
          this.loader.hideLoader();
          console.error(error);
        });
      } else {
        // User cancelled action
        console.log('Cancelled');
        dialogRef.close();
      }
    });
  }
  showSuccessToast(message) {
    this.snackBar.open(message, 'Close', {
      duration: 3000,
      panelClass: ['success-toast']
    });
  }
  showErrorToast(message) {
    this.snackBar.open(message, 'Close', {
      duration: 3000,
      panelClass: ['error-toast']
    });
  }
  edit() {
    console.log(this.editData);
    this.userForm = this.fb.group({
      name: [this.editData['name'], [_angular_forms__WEBPACK_IMPORTED_MODULE_11__.Validators.required, this.validationsService.isOnlyStringValidator()]],
      email: [this.editData['email'], [_angular_forms__WEBPACK_IMPORTED_MODULE_11__.Validators.required, this.validationsService.emailValidator()]],
      phone: [this.editData['mobile'], [_angular_forms__WEBPACK_IMPORTED_MODULE_11__.Validators.required, this.validationsService.mobileNumberValidator()]],
      gender: [this.editData['gender'], _angular_forms__WEBPACK_IMPORTED_MODULE_11__.Validators.required],
      city: [this.editData['city'], _angular_forms__WEBPACK_IMPORTED_MODULE_11__.Validators.required],
      profileImage: [this.editData['profileImage'], _angular_forms__WEBPACK_IMPORTED_MODULE_11__.Validators.required],
      location: [this.editData['latitude'] + ',' + this.editData['longitude'], [_angular_forms__WEBPACK_IMPORTED_MODULE_11__.Validators.required, this.validationsService.locationValidator()]],
      internalNotes: [null]
    });
    this.userForm.get('profileImage').setValue(this.editData['profileImage']);
  }
  craeteFormControllers() {
    this.controllers = {
      name: {
        id: "userName",
        name: 'name',
        label: "Name",
        required: true,
        placeholder: "Enter Name",
        type: "text"
      },
      email: {
        id: "userName",
        name: 'email',
        label: "Email",
        required: true,
        placeholder: "Enter Email",
        type: "email"
      },
      phone: {
        id: "phone",
        name: 'phone',
        label: "Phone",
        required: true,
        placeholder: "Enter Mobile No.",
        type: "text"
      },
      location: {
        id: "location",
        name: 'location',
        label: "Location",
        required: true,
        placeholder: "0.0,0.0",
        type: "text"
      },
      gender: {
        id: "gender",
        name: 'gender',
        label: "Gender",
        required: true,
        placeholder: "Enter Gender",
        options: [{
          name: "Male",
          value: "Male"
        }, {
          name: "Female",
          value: "Female"
        }],
        type: "radio"
      },
      city: {
        id: "city",
        name: 'city',
        label: "City",
        required: true,
        placeholder: "Enter city",
        type: "text"
      },
      profileImage: {
        id: "profileImage",
        name: 'profileImage',
        label: "Upload Image*",
        required: true,
        placeholder: "Enter Name",
        type: "text"
      },
      internalNotes: {
        id: "internalNotes",
        name: "internalNotes",
        label: "Internal Notes",
        placeholder: "Enter Internal Notes",
        required: true
      },
      address: {
        type: {
          id: "type",
          name: 'type',
          label: "Type",
          required: true,
          placeholder: "",
          type: "radio",
          options: [{
            name: 'Home',
            value: 'Home'
          }, {
            name: 'Work',
            value: 'Work'
          }, {
            name: 'Hotel',
            value: 'Hotel'
          }, {
            name: 'Other',
            value: 'Other'
          }]
        },
        flatNo: {
          id: "flatNo",
          name: 'flatNo',
          label: "Flat No",
          required: true,
          placeholder: "Enter Flat No",
          type: "text"
        },
        address: {
          id: "address",
          name: 'address',
          label: "Address",
          required: true,
          placeholder: "Enter Address",
          type: "text"
        },
        pincode: {
          id: "Pincode",
          name: 'Pincode',
          label: "Pincode",
          required: true,
          placeholder: "Enter Pincode",
          type: "text"
        },
        city: {
          id: "city",
          name: 'city',
          label: "City",
          required: true,
          placeholder: "Enter city",
          type: "text"
        },
        location: {
          id: "location",
          name: 'location',
          label: "location",
          required: true,
          placeholder: "Enter Location",
          type: "text"
        }
      }
    };
  }
  uploadProfile(event) {
    if (this.editData) {
      this.loader.showLoader();
      this.userManagementService.addPetParentProfileImage(this.editData['id'], this.userForm.get('profileImage').value).subscribe(res => {
        console.log(res);
        this.loader.hideLoader();
      });
    }
  }
  addUser() {
    let json = this.userForm.value;
    //   {
    //     "countryCode": "+91",
    //     "mobile": "8290444559",
    //     "name": "Angular",
    //     "email": "angular@gmail.co",
    //     "verified": false,
    //     "emailVerified": false,
    //     "city": "pune",
    //     "gender": "Male",
    //     "sos": false,
    //     "sosTill": "",
    //     "latitude": "01.110",
    //     "longitude": "10.0111",
    //     "status": "Created"
    // }
    let body = {
      "countryCode": "+91",
      "mobile": json['phone'],
      "name": json['name'],
      "email": json['email'],
      "verified": false,
      "emailVerified": false,
      "city": json['city'],
      "gender": json['gender'],
      "sos": false,
      "sosTill": "",
      "latitude": json['location'].split(",")[0].trim(),
      "longitude": json['location'].split(",")[1].trim(),
      "status": "Created"
    };
    if (this.editData) {
      body['id'] = this.editData['id'];
      this.loader.showLoader();
      this.userManagementService.updatePetParent(body).subscribe(res => {
        this.loader.hideLoader();
        // this.userManagementService.addPetParentProfileImage(res['id'], json['coverImage']).subscribe((res) => {
        console.log(res);
        this.userManagementService.getPetParents(1).subscribe(res => {
          this.cancel();
          this.router.navigate(['/user/pet']);
          const dialogRef = this.dialog.open(app_components_controllers_success_dialog_success_dialog_component__WEBPACK_IMPORTED_MODULE_1__.SuccessDialogComponent, {
            width: '300px',
            data: {
              message: 'User updated successfully!',
              success: true
            },
            panelClass: 'success-dialog-container'
          });
        });
      }, error => {
        this.loader.hideLoader();
        console.error(error);
        const dialogRef = this.dialog.open(app_components_controllers_success_dialog_success_dialog_component__WEBPACK_IMPORTED_MODULE_1__.SuccessDialogComponent, {
          width: '300px',
          data: {
            message: error.error.message,
            success: false
          }
        });
        // })
      });
    } else {
      this.loader.showLoader();
      this.userManagementService.addPetParent(body).subscribe(res => {
        // this.userManagementService.addPetParentProfileImage(res['id'], this.userForm.get('profileImage').value).subscribe((res) => {
        console.log(res);
        this.userManagementService.getPetParents(1).subscribe(res => {
          this.loader.hideLoader();
          this.router.navigate(['/user/pet']);
          const dialogRef = this.dialog.open(app_components_controllers_success_dialog_success_dialog_component__WEBPACK_IMPORTED_MODULE_1__.SuccessDialogComponent, {
            width: '300px',
            data: {
              message: 'User created successfully!',
              success: true
            },
            panelClass: 'success-dialog-container'
          });
        });
        // })
      }, error => {
        this.loader.hideLoader();
        console.error(error);
        const dialogRef = this.dialog.open(app_components_controllers_success_dialog_success_dialog_component__WEBPACK_IMPORTED_MODULE_1__.SuccessDialogComponent, {
          width: '300px',
          data: {
            message: error.error.message,
            success: false
          }
        });
      });
    }
  }
  cancel() {
    this.getPets();
    this.cancelEvent.emit();
    this.router.navigate(['/user/pet']);
  }
  static #_ = this.ɵfac = function AddUserComponent_Factory(t) {
    return new (t || AddUserComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵdirectiveInject"](_angular_forms__WEBPACK_IMPORTED_MODULE_11__.FormBuilder), _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵdirectiveInject"](app_services_user_management_service__WEBPACK_IMPORTED_MODULE_4__.UserManagementService), _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵdirectiveInject"](_angular_router__WEBPACK_IMPORTED_MODULE_13__.Router), _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵdirectiveInject"](_angular_material_dialog__WEBPACK_IMPORTED_MODULE_14__.MatDialog), _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵdirectiveInject"](_angular_material_snack_bar__WEBPACK_IMPORTED_MODULE_15__.MatSnackBar), _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵdirectiveInject"](app_services_validations_service__WEBPACK_IMPORTED_MODULE_5__.ValidationsService), _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵdirectiveInject"](app_services_loader_service__WEBPACK_IMPORTED_MODULE_6__.LoaderService));
  };
  static #_2 = this.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵdefineComponent"]({
    type: AddUserComponent,
    selectors: [["app-add-user"]],
    viewQuery: function AddUserComponent_Query(rf, ctx) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵviewQuery"](_angular_material_menu__WEBPACK_IMPORTED_MODULE_16__.MatMenuTrigger, 5);
      }
      if (rf & 2) {
        let _t;
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵloadQuery"]()) && (ctx.menuTrigger = _t.first);
      }
    },
    inputs: {
      editData: "editData"
    },
    outputs: {
      cancelEvent: "cancelEvent"
    },
    features: [_angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵNgOnChangesFeature"]],
    decls: 48,
    vars: 21,
    consts: [[1, "flex", "flex-col", "flex-auto", "min-w-0", 2, "width", "100%", "overflow-y", "auto", "height", "calc(100vh - 70px)"], [1, "flex-auto", "p-6", "sm:p-10"], [1, "header"], ["style", "font-size: 15px; font-weight: 500;", 4, "ngIf"], ["mat-mini-fab", "", "color", "warn", 3, "click"], [1, "row"], [1, "col"], [3, "form", "controller"], ["type", "number", 3, "form", "controller"], ["accept", "image/*", 3, "form", "controller", "onFileSelect"], [3, "formGroup", 4, "ngIf"], ["style", "display: flex;flex-direction: row;justify-content:space-between;width: 100%;align-items: center;", 4, "ngIf"], ["mat-table", "", "class", "mat-elevation-z8 mt-5", 3, "dataSource", 4, "ngIf"], [1, "btn-wrapper"], ["mat-stroked-button", "", "color", "primary", 3, "click"], ["mat-stroked-button", "", "color", "primary", "id", "add-update", 3, "disabled", "click"], ["actionMenu", "matMenu"], ["mat-menu-item", "", 3, "click", 4, "ngIf"], ["mat-menu-item", "", 3, "click"], [2, "color", "blue !important"], ["color", "primary"], [2, "color", "hsl(0, 94%, 42%) !important"], ["color", "warn"], [2, "font-size", "15px", "font-weight", "500"], [3, "formGroup"], ["mat-raised-button", "", "color", "primary", 3, "click"], ["formArrayName", "addresses"], ["class", "address-card", 3, "formGroupName", 4, "ngFor", "ngForOf"], [1, "address-card", 3, "formGroupName"], [1, "card"], [1, "card-body"], ["mat-button", "", "color", "warn", 3, "click"], ["mat-button", "", "color", "primary", 3, "click"], [2, "display", "flex", "flex-direction", "row", "justify-content", "space-between", "width", "100%", "align-items", "center"], ["mat-menu-item", "", 2, "width", "35%", 3, "click"], ["mat-table", "", 1, "mat-elevation-z8", "mt-5", 3, "dataSource"], ["matColumnDef", "id"], ["mat-header-cell", "", 4, "matHeaderCellDef"], ["mat-cell", "", 4, "matCellDef"], ["matColumnDef", "petName"], ["matColumnDef", "type"], ["matColumnDef", "breed"], ["matColumnDef", "gender"], ["matColumnDef", "action"], ["mat-header-row", "", 4, "matHeaderRowDef"], ["mat-row", "", 4, "matRowDef", "matRowDefColumns"], ["mat-header-cell", ""], ["mat-cell", ""], ["mat-icon-button", "", 3, "matMenuTriggerFor", "click"], ["mat-header-row", ""], ["mat-row", ""]],
    template: function AddUserComponent_Template(rf, ctx) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](0, "div", 0)(1, "div", 1)(2, "form")(3, "div", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtemplate"](4, AddUserComponent_h1_4_Template, 2, 0, "h1", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtemplate"](5, AddUserComponent_h1_5_Template, 2, 0, "h1", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](6, "button", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵlistener"]("click", function AddUserComponent_Template_button_click_6_listener() {
          return ctx.cancel();
        });
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](7, "mat-icon");
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtext"](8, "close");
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]()()();
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](9, "div", 5)(10, "div", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelement"](11, "app-input", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](12, "div", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelement"](13, "app-input", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]()();
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](14, "div", 5)(15, "div", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelement"](16, "app-input", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](17, "div", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelement"](18, "app-radio-btn", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]()();
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](19, "div", 5)(20, "div", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelement"](21, "app-input", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](22, "div", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelement"](23, "app-input", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]()();
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](24, "div", 5)(25, "div", 6)(26, "app-file-upload", 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵlistener"]("onFileSelect", function AddUserComponent_Template_app_file_upload_onFileSelect_26_listener($event) {
          return ctx.uploadProfile($event);
        });
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]()()();
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtemplate"](27, AddUserComponent_div_27_Template, 5, 2, "div", 10);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtemplate"](28, AddUserComponent_div_28_Template, 8, 0, "div", 11);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtemplate"](29, AddUserComponent_table_29_Template, 21, 3, "table", 12);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](30, "div", 13)(31, "button", 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵlistener"]("click", function AddUserComponent_Template_button_click_31_listener() {
          return ctx.cancel();
        });
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtext"](32, "Cancel");
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](33, "button", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵlistener"]("click", function AddUserComponent_Template_button_click_33_listener() {
          return ctx.addUser();
        });
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtext"](34, "submit");
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]()()()()();
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](35, "mat-menu", null, 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtemplate"](37, AddUserComponent_button_37_Template, 5, 0, "button", 17);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](38, "button", 18);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵlistener"]("click", function AddUserComponent_Template_button_click_38_listener() {
          return ctx.view();
        });
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](39, "span", 19);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtext"](40, "View");
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](41, "mat-icon", 20);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtext"](42, "keyboard_arrow_right");
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]()();
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](43, "button", 18);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵlistener"]("click", function AddUserComponent_Template_button_click_43_listener() {
          return ctx.deletePet();
        });
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](44, "span", 21);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtext"](45, "Delete");
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](46, "mat-icon", 22);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtext"](47, "delete");
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]()()();
      }
      if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("ngIf", !ctx.editData);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("ngIf", ctx.editData);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](6);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("form", ctx.userForm)("controller", ctx.controllers["name"]);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("form", ctx.userForm)("controller", ctx.controllers["email"]);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("form", ctx.userForm)("controller", ctx.controllers["phone"]);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("form", ctx.userForm)("controller", ctx.controllers["gender"]);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("form", ctx.userForm)("controller", ctx.controllers["city"]);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("form", ctx.userForm)("controller", ctx.controllers["location"]);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("form", ctx.userForm)("controller", ctx.controllers["profileImage"]);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("ngIf", ctx.editData);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("ngIf", ctx.editData);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("ngIf", ctx.pets);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("disabled", ctx.userForm.invalid);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("ngIf", ctx.isThereActivities);
      }
    },
    dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_17__.NgForOf, _angular_common__WEBPACK_IMPORTED_MODULE_17__.NgIf, _angular_material_table__WEBPACK_IMPORTED_MODULE_12__.MatTable, _angular_material_table__WEBPACK_IMPORTED_MODULE_12__.MatHeaderCellDef, _angular_material_table__WEBPACK_IMPORTED_MODULE_12__.MatHeaderRowDef, _angular_material_table__WEBPACK_IMPORTED_MODULE_12__.MatColumnDef, _angular_material_table__WEBPACK_IMPORTED_MODULE_12__.MatCellDef, _angular_material_table__WEBPACK_IMPORTED_MODULE_12__.MatRowDef, _angular_material_table__WEBPACK_IMPORTED_MODULE_12__.MatHeaderCell, _angular_material_table__WEBPACK_IMPORTED_MODULE_12__.MatCell, _angular_material_table__WEBPACK_IMPORTED_MODULE_12__.MatHeaderRow, _angular_material_table__WEBPACK_IMPORTED_MODULE_12__.MatRow, _components_controllers_input_input_component__WEBPACK_IMPORTED_MODULE_7__.InputComponent, _components_controllers_file_upload_file_upload_component__WEBPACK_IMPORTED_MODULE_8__.FileUploadComponent, _components_controllers_radio_btn_radio_btn_component__WEBPACK_IMPORTED_MODULE_9__.RadioBtnComponent, _angular_material_button__WEBPACK_IMPORTED_MODULE_18__.MatButton, _angular_material_button__WEBPACK_IMPORTED_MODULE_18__.MatIconButton, _angular_material_button__WEBPACK_IMPORTED_MODULE_18__.MatMiniFabButton, _angular_forms__WEBPACK_IMPORTED_MODULE_11__["ɵNgNoValidate"], _angular_forms__WEBPACK_IMPORTED_MODULE_11__.NgControlStatusGroup, _angular_forms__WEBPACK_IMPORTED_MODULE_11__.NgForm, _angular_forms__WEBPACK_IMPORTED_MODULE_11__.FormGroupDirective, _angular_forms__WEBPACK_IMPORTED_MODULE_11__.FormGroupName, _angular_forms__WEBPACK_IMPORTED_MODULE_11__.FormArrayName, _angular_material_menu__WEBPACK_IMPORTED_MODULE_16__.MatMenu, _angular_material_menu__WEBPACK_IMPORTED_MODULE_16__.MatMenuItem, _angular_material_menu__WEBPACK_IMPORTED_MODULE_16__.MatMenuTrigger, _angular_material_icon__WEBPACK_IMPORTED_MODULE_19__.MatIcon],
    styles: ["form[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: column;\n  width: 80%;\n  height: auto;\n}\nform[_ngcontent-%COMP%]   .row[_ngcontent-%COMP%] {\n  width: 100%;\n  justify-content: space-between;\n  display: flex;\n  flex-direction: row;\n  height: -moz-fit-content;\n  height: fit-content;\n  padding-bottom: 1%;\n}\nform[_ngcontent-%COMP%]   .row[_ngcontent-%COMP%]   .col[_ngcontent-%COMP%] {\n  width: 48%;\n  display: flex;\n  flex-direction: column;\n  height: 100%;\n}\nform[_ngcontent-%COMP%]   .btn-wrapper[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: row;\n  justify-content: right;\n}\nform[_ngcontent-%COMP%]   .btn-wrapper[_ngcontent-%COMP%]   button[_ngcontent-%COMP%] {\n  margin: 10px;\n}\n\n.header[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: row;\n  justify-content: space-between;\n  width: 100%;\n}\n\n\n.address-card[_ngcontent-%COMP%] {\n  display: inline-block;\n  width: 30%;\n  margin: 10px;\n}\n\n.card[_ngcontent-%COMP%] {\n  border: 1px solid #ccc;\n  border-radius: 8px;\n  padding: 16px;\n  background-color: #f9f9f9;\n}\n\n.card-body[_ngcontent-%COMP%] {\n  text-align: left;\n}\n\n.btn[_ngcontent-%COMP%] {\n  margin-right: 10px;\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImFkZC11c2VyLmNvbXBvbmVudC5zY3NzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBO0VBQ0ksYUFBQTtFQUNBLHNCQUFBO0VBQ0EsVUFBQTtFQUNBLFlBQUE7QUFDSjtBQUFJO0VBQ0ksV0FBQTtFQUNBLDhCQUFBO0VBQ0EsYUFBQTtFQUNBLG1CQUFBO0VBQ0Esd0JBQUE7RUFBQSxtQkFBQTtFQUNBLGtCQUFBO0FBRVI7QUFBUTtFQUNJLFVBQUE7RUFDQSxhQUFBO0VBQ0Esc0JBQUE7RUFDQSxZQUFBO0FBRVo7QUFDSTtFQUNJLGFBQUE7RUFDQSxtQkFBQTtFQUNBLHNCQUFBO0FBQ1I7QUFBUTtFQUNJLFlBQUE7QUFFWjs7QUFFQTtFQUNJLGFBQUE7RUFDQSxtQkFBQTtFQUNBLDhCQUFBO0VBQ0EsV0FBQTtBQUNKOztBQUVBLCtCQUFBO0FBQ0E7RUFDSSxxQkFBQTtFQUNBLFVBQUE7RUFDQSxZQUFBO0FBQ0o7O0FBRUU7RUFDRSxzQkFBQTtFQUNBLGtCQUFBO0VBQ0EsYUFBQTtFQUNBLHlCQUFBO0FBQ0o7O0FBRUU7RUFDRSxnQkFBQTtBQUNKOztBQUVFO0VBQ0Usa0JBQUE7QUFDSiIsImZpbGUiOiJhZGQtdXNlci5jb21wb25lbnQuc2NzcyIsInNvdXJjZXNDb250ZW50IjpbImZvcm17XG4gICAgZGlzcGxheTogZmxleDtcbiAgICBmbGV4LWRpcmVjdGlvbjogY29sdW1uO1xuICAgIHdpZHRoOiA4MCU7XG4gICAgaGVpZ2h0OiBhdXRvO1xuICAgIC5yb3d7XG4gICAgICAgIHdpZHRoOiAxMDAlO1xuICAgICAgICBqdXN0aWZ5LWNvbnRlbnQ6c3BhY2UtYmV0d2VlbjtcbiAgICAgICAgZGlzcGxheTogZmxleDtcbiAgICAgICAgZmxleC1kaXJlY3Rpb246IHJvdztcbiAgICAgICAgaGVpZ2h0OiBmaXQtY29udGVudDtcbiAgICAgICAgcGFkZGluZy1ib3R0b206IDElO1xuXG4gICAgICAgIC5jb2x7XG4gICAgICAgICAgICB3aWR0aDogNDglO1xuICAgICAgICAgICAgZGlzcGxheTogZmxleDtcbiAgICAgICAgICAgIGZsZXgtZGlyZWN0aW9uOiBjb2x1bW47XG4gICAgICAgICAgICBoZWlnaHQ6IDEwMCU7XG4gICAgICAgIH1cbiAgICB9XG4gICAgLmJ0bi13cmFwcGVye1xuICAgICAgICBkaXNwbGF5OiBmbGV4O1xuICAgICAgICBmbGV4LWRpcmVjdGlvbjogcm93O1xuICAgICAgICBqdXN0aWZ5LWNvbnRlbnQ6IHJpZ2h0O1xuICAgICAgICBidXR0b257XG4gICAgICAgICAgICBtYXJnaW46IDEwcHg7XG4gICAgICAgIH1cbiAgICB9XG59XG4uaGVhZGVye1xuICAgIGRpc3BsYXk6IGZsZXg7XG4gICAgZmxleC1kaXJlY3Rpb246IHJvdztcbiAgICBqdXN0aWZ5LWNvbnRlbnQ6IHNwYWNlLWJldHdlZW47XG4gICAgd2lkdGg6IDEwMCU7XG59XG5cbi8qIGFkZHJlc3MtZm9ybS5jb21wb25lbnQuY3NzICovXG4uYWRkcmVzcy1jYXJkIHtcbiAgICBkaXNwbGF5OiBpbmxpbmUtYmxvY2s7XG4gICAgd2lkdGg6IDMwJTtcbiAgICBtYXJnaW46IDEwcHg7XG4gIH1cbiAgXG4gIC5jYXJkIHtcbiAgICBib3JkZXI6IDFweCBzb2xpZCAjY2NjO1xuICAgIGJvcmRlci1yYWRpdXM6IDhweDtcbiAgICBwYWRkaW5nOiAxNnB4O1xuICAgIGJhY2tncm91bmQtY29sb3I6ICNmOWY5Zjk7XG4gIH1cbiAgXG4gIC5jYXJkLWJvZHkge1xuICAgIHRleHQtYWxpZ246IGxlZnQ7XG4gIH1cbiAgXG4gIC5idG4ge1xuICAgIG1hcmdpbi1yaWdodDogMTBweDtcbiAgfVxuICAiXX0= */\n/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */"]
  });
}


/***/ }),

/***/ 23705:
/*!*******************************************************************************!*\
  !*** ./src/app/modules/user-manaement/appointments/appointments.component.ts ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AppointmentsComponent": () => (/* binding */ AppointmentsComponent)
/* harmony export */ });
/* harmony import */ var _angular_material_paginator__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/material/paginator */ 86907);
/* harmony import */ var _angular_material_sort__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/material/sort */ 95096);
/* harmony import */ var _angular_material_table__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/material/table */ 83348);
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! moment */ 56908);
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(moment__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 86839);
/* harmony import */ var app_services_appointment_management_service__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! app/services/appointment-management.service */ 75129);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/router */ 86679);
/* harmony import */ var _angular_material_button__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/material/button */ 83677);
/* harmony import */ var _angular_material_icon__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @angular/material/icon */ 69941);











function AppointmentsComponent_th_3_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](0, "th", 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](1, "ID.");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
  }
}
function AppointmentsComponent_td_4_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](0, "td", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const element_r21 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate1"](" ", element_r21.id.substring(0, 6), " ");
  }
}
function AppointmentsComponent_th_6_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](0, "th", 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](1, " DesignationName Name ");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
  }
}
function AppointmentsComponent_td_7_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](0, "td", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const element_r22 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate1"](" ", element_r22.designationName, " ");
  }
}
function AppointmentsComponent_th_9_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](0, "th", 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](1, "Service Name");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
  }
}
function AppointmentsComponent_td_10_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](0, "td", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const element_r23 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate1"](" ", element_r23.serviceName, " ");
  }
}
function AppointmentsComponent_th_12_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](0, "th", 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](1, "City");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
  }
}
function AppointmentsComponent_td_13_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](0, "td", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const element_r24 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate1"](" ", element_r24.city, " ");
  }
}
function AppointmentsComponent_th_15_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](0, "th", 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](1, "Type");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
  }
}
function AppointmentsComponent_td_16_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](0, "td", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const element_r25 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate1"](" ", element_r25.type, " ");
  }
}
function AppointmentsComponent_th_18_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](0, "th", 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](1, " Workspace Name ");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
  }
}
function AppointmentsComponent_td_19_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](0, "td", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const element_r26 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate1"](" ", element_r26.workspaceName, " ");
  }
}
function AppointmentsComponent_th_21_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](0, "th", 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](1, " Appointment Date ");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
  }
}
function AppointmentsComponent_td_22_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](0, "td", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const element_r27 = ctx.$implicit;
    const ctx_r13 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate1"](" ", ctx_r13.currentUTCDate(element_r27.appointmentDate), " ");
  }
}
function AppointmentsComponent_th_24_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](0, "th", 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](1, "Status");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
  }
}
function AppointmentsComponent_td_25_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](0, "td", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const element_r28 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate1"](" ", element_r28.status, " ");
  }
}
function AppointmentsComponent_th_27_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](0, "th", 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](1, " Action ");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
  }
}
function AppointmentsComponent_td_28_Template(rf, ctx) {
  if (rf & 1) {
    const _r32 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](0, "td", 18)(1, "button", 19);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("click", function AppointmentsComponent_td_28_Template_button_click_1_listener() {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵrestoreView"](_r32);
      const i_r30 = restoredCtx.index;
      const element_r29 = restoredCtx.$implicit;
      const ctx_r31 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵresetView"](ctx_r31.view(i_r30, element_r29));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](2, "mat-icon");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](3, "keyboard_arrow_right");
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]()()();
  }
}
function AppointmentsComponent_tr_29_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelement"](0, "tr", 20);
  }
}
function AppointmentsComponent_tr_30_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelement"](0, "tr", 21);
  }
}
const _c0 = function () {
  return [5, 10, 25, 100];
};
class AppointmentsComponent {
  constructor(appointmentManagementService, router) {
    this.appointmentManagementService = appointmentManagementService;
    this.router = router;
    this.petId = '';
    this.displayedColumns = ['id', 'collaboratorName', 'serviceName', 'city', 'type', 'workspaceName', 'appointmentDate', 'status', 'action'];
  }
  ngOnInit() {
    this.getAppointments(this.petId);
  }
  ngAfterViewInit() {
    this.appointments.paginator = this.paginator;
  }
  currentUTCDate(date) {
    return moment__WEBPACK_IMPORTED_MODULE_0___default().utc(date).local().format("DD-MMM-YYYY hh:mm A");
  }
  getAppointments(petId) {
    this.appointmentManagementService.getAppointmentByPetId(petId).subscribe(res => {
      console.log(res);
      const appointmentArray = Object.values(res);
      this.appointments = new _angular_material_table__WEBPACK_IMPORTED_MODULE_3__.MatTableDataSource(appointmentArray.map(item => ({
        ...item
      })));
      this.appointments.paginator = this.paginator;
      this.appointments.sort = this.sort;
    });
  }
  view(i, element) {
    this.router.navigate(['/appointment'], {
      queryParams: {
        appointMentId: element['id']
      }
    });
  }
  static #_ = this.ɵfac = function AppointmentsComponent_Factory(t) {
    return new (t || AppointmentsComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdirectiveInject"](app_services_appointment_management_service__WEBPACK_IMPORTED_MODULE_1__.AppointmentManagementService), _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdirectiveInject"](_angular_router__WEBPACK_IMPORTED_MODULE_4__.Router));
  };
  static #_2 = this.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdefineComponent"]({
    type: AppointmentsComponent,
    selectors: [["app-appointments"]],
    viewQuery: function AppointmentsComponent_Query(rf, ctx) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵviewQuery"](_angular_material_paginator__WEBPACK_IMPORTED_MODULE_5__.MatPaginator, 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵviewQuery"](_angular_material_sort__WEBPACK_IMPORTED_MODULE_6__.MatSort, 5);
      }
      if (rf & 2) {
        let _t;
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵloadQuery"]()) && (ctx.paginator = _t.first);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵloadQuery"]()) && (ctx.sort = _t.first);
      }
    },
    inputs: {
      petId: "petId"
    },
    decls: 33,
    vars: 6,
    consts: [[2, "width", "100%"], ["mat-table", "", 1, "mat-elevation-z8", 3, "dataSource"], ["matColumnDef", "id"], ["mat-header-cell", "", 4, "matHeaderCellDef"], ["mat-cell", "", 4, "matCellDef"], ["matColumnDef", "collaboratorName"], ["matColumnDef", "serviceName"], ["matColumnDef", "city"], ["matColumnDef", "type"], ["matColumnDef", "workspaceName"], ["matColumnDef", "appointmentDate"], ["matColumnDef", "status"], ["matColumnDef", "action"], ["mat-header-row", "", 4, "matHeaderRowDef"], ["mat-row", "", 4, "matRowDef", "matRowDefColumns"], [3, "pageSize", "pageSizeOptions"], ["paginator", ""], ["mat-header-cell", ""], ["mat-cell", ""], ["mat-icon-button", "", 3, "click"], ["mat-header-row", ""], ["mat-row", ""]],
    template: function AppointmentsComponent_Template(rf, ctx) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](0, "div", 0)(1, "table", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementContainerStart"](2, 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](3, AppointmentsComponent_th_3_Template, 2, 0, "th", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](4, AppointmentsComponent_td_4_Template, 2, 1, "td", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementContainerStart"](5, 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](6, AppointmentsComponent_th_6_Template, 2, 0, "th", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](7, AppointmentsComponent_td_7_Template, 2, 1, "td", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementContainerStart"](8, 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](9, AppointmentsComponent_th_9_Template, 2, 0, "th", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](10, AppointmentsComponent_td_10_Template, 2, 1, "td", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementContainerStart"](11, 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](12, AppointmentsComponent_th_12_Template, 2, 0, "th", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](13, AppointmentsComponent_td_13_Template, 2, 1, "td", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementContainerStart"](14, 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](15, AppointmentsComponent_th_15_Template, 2, 0, "th", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](16, AppointmentsComponent_td_16_Template, 2, 1, "td", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementContainerStart"](17, 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](18, AppointmentsComponent_th_18_Template, 2, 0, "th", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](19, AppointmentsComponent_td_19_Template, 2, 1, "td", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementContainerStart"](20, 10);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](21, AppointmentsComponent_th_21_Template, 2, 0, "th", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](22, AppointmentsComponent_td_22_Template, 2, 1, "td", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementContainerStart"](23, 11);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](24, AppointmentsComponent_th_24_Template, 2, 0, "th", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](25, AppointmentsComponent_td_25_Template, 2, 1, "td", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementContainerStart"](26, 12);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](27, AppointmentsComponent_th_27_Template, 2, 0, "th", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](28, AppointmentsComponent_td_28_Template, 4, 0, "td", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](29, AppointmentsComponent_tr_29_Template, 1, 0, "tr", 13);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](30, AppointmentsComponent_tr_30_Template, 1, 0, "tr", 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelement"](31, "mat-paginator", 15, 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
      }
      if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("dataSource", ctx.appointments);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](28);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("matHeaderRowDef", ctx.displayedColumns);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("matRowDefColumns", ctx.displayedColumns);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("pageSize", 10)("pageSizeOptions", _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵpureFunction0"](5, _c0));
      }
    },
    dependencies: [_angular_material_table__WEBPACK_IMPORTED_MODULE_3__.MatTable, _angular_material_table__WEBPACK_IMPORTED_MODULE_3__.MatHeaderCellDef, _angular_material_table__WEBPACK_IMPORTED_MODULE_3__.MatHeaderRowDef, _angular_material_table__WEBPACK_IMPORTED_MODULE_3__.MatColumnDef, _angular_material_table__WEBPACK_IMPORTED_MODULE_3__.MatCellDef, _angular_material_table__WEBPACK_IMPORTED_MODULE_3__.MatRowDef, _angular_material_table__WEBPACK_IMPORTED_MODULE_3__.MatHeaderCell, _angular_material_table__WEBPACK_IMPORTED_MODULE_3__.MatCell, _angular_material_table__WEBPACK_IMPORTED_MODULE_3__.MatHeaderRow, _angular_material_table__WEBPACK_IMPORTED_MODULE_3__.MatRow, _angular_material_button__WEBPACK_IMPORTED_MODULE_7__.MatIconButton, _angular_material_icon__WEBPACK_IMPORTED_MODULE_8__.MatIcon, _angular_material_paginator__WEBPACK_IMPORTED_MODULE_5__.MatPaginator],
    styles: ["table[_ngcontent-%COMP%] {\n  width: 100%;\n}\n\n.table-wrapper[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: column;\n  width: 100%;\n  height: 90%;\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImFwcG9pbnRtZW50cy5jb21wb25lbnQuc2NzcyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTtFQUNJLFdBQUE7QUFDSjs7QUFFRTtFQUNFLGFBQUE7RUFDQSxzQkFBQTtFQUNBLFdBQUE7RUFDQSxXQUFBO0FBQ0oiLCJmaWxlIjoiYXBwb2ludG1lbnRzLmNvbXBvbmVudC5zY3NzIiwic291cmNlc0NvbnRlbnQiOlsidGFibGUge1xuICAgIHdpZHRoOiAxMDAlO1xuICB9XG4gIFxuICAudGFibGUtd3JhcHBlcntcbiAgICBkaXNwbGF5OiBmbGV4O1xuICAgIGZsZXgtZGlyZWN0aW9uOiBjb2x1bW47XG4gICAgd2lkdGg6IDEwMCU7XG4gICAgaGVpZ2h0OiA5MCU7XG4gIH1cbiAgIl19 */\n/*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8uL3NyYy9hcHAvbW9kdWxlcy91c2VyLW1hbmFlbWVudC9hcHBvaW50bWVudHMvYXBwb2ludG1lbnRzLmNvbXBvbmVudC5zY3NzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBO0VBQ0ksV0FBQTtBQUNKOztBQUVFO0VBQ0UsYUFBQTtFQUNBLHNCQUFBO0VBQ0EsV0FBQTtFQUNBLFdBQUE7QUFDSjtBQUNBLGdoQkFBZ2hCIiwic291cmNlc0NvbnRlbnQiOlsidGFibGUge1xuICAgIHdpZHRoOiAxMDAlO1xuICB9XG4gIFxuICAudGFibGUtd3JhcHBlcntcbiAgICBkaXNwbGF5OiBmbGV4O1xuICAgIGZsZXgtZGlyZWN0aW9uOiBjb2x1bW47XG4gICAgd2lkdGg6IDEwMCU7XG4gICAgaGVpZ2h0OiA5MCU7XG4gIH1cbiAgIl0sInNvdXJjZVJvb3QiOiIifQ== */"]
  });
}


/***/ }),

/***/ 57742:
/*!*******************************************************************************!*\
  !*** ./src/app/modules/user-manaement/collaborator/collaborator.component.ts ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "CollaboratorComponent": () => (/* binding */ CollaboratorComponent)
/* harmony export */ });
/* harmony import */ var _angular_material_menu__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @angular/material/menu */ 89314);
/* harmony import */ var _angular_material_table__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @angular/material/table */ 83348);
/* harmony import */ var file_saver__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! file-saver */ 65226);
/* harmony import */ var file_saver__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(file_saver__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _angular_material_sort__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @angular/material/sort */ 95096);
/* harmony import */ var app_components_controllers_confirmation_dialog_confirmation_dialog_component__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! app/components/controllers/confirmation-dialog/confirmation-dialog.component */ 81500);
/* harmony import */ var app_components_controllers_success_dialog_success_dialog_component__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! app/components/controllers/success-dialog/success-dialog.component */ 92814);
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! moment */ 56908);
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(moment__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @angular/core */ 86839);
/* harmony import */ var app_services_user_management_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! app/services/user-management.service */ 32555);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @angular/router */ 86679);
/* harmony import */ var _angular_material_snack_bar__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @angular/material/snack-bar */ 88511);
/* harmony import */ var _angular_material_dialog__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @angular/material/dialog */ 67486);
/* harmony import */ var app_services_loader_service__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! app/services/loader.service */ 38555);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! @angular/common */ 86477);
/* harmony import */ var _angular_material_tabs__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! @angular/material/tabs */ 12128);
/* harmony import */ var _components_common_components_generic_actions_generic_actions_component__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../components/common-components/generic-actions/generic-actions.component */ 90823);
/* harmony import */ var _angular_material_button__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! @angular/material/button */ 83677);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! @angular/forms */ 69542);
/* harmony import */ var _angular_material_icon__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! @angular/material/icon */ 69941);
/* harmony import */ var _angular_material_sidenav__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! @angular/material/sidenav */ 79101);
/* harmony import */ var _angular_material_slide_toggle__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! @angular/material/slide-toggle */ 4291);
/* harmony import */ var _angular_material_paginator__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! @angular/material/paginator */ 86907);
/* harmony import */ var _angular_material_checkbox__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! @angular/material/checkbox */ 7672);
/* harmony import */ var _add_collaborator_add_collaborator_component__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../add-collaborator/add-collaborator.component */ 24682);


























const _c0 = ["sidenav"];
const _c1 = ["paginator1"];
const _c2 = ["paginator2"];
const _c3 = ["paginator3"];
function CollaboratorComponent_th_22_Template(rf, ctx) {
  if (rf & 1) {
    const _r73 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](0, "th", 39)(1, "mat-checkbox", 40);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵlistener"]("change", function CollaboratorComponent_th_22_Template_mat_checkbox_change_1_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵrestoreView"](_r73);
      const ctx_r72 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵresetView"](ctx_r72.selectAll($event));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]()();
  }
}
function CollaboratorComponent_td_23_Template(rf, ctx) {
  if (rf & 1) {
    const _r76 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](0, "td", 41)(1, "mat-checkbox", 42);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵlistener"]("ngModelChange", function CollaboratorComponent_td_23_Template_mat_checkbox_ngModelChange_1_listener($event) {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵrestoreView"](_r76);
      const element_r74 = restoredCtx.$implicit;
      return _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵresetView"](element_r74.selected = $event);
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]()();
  }
  if (rf & 2) {
    const element_r74 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵproperty"]("ngModel", element_r74.selected);
  }
}
function CollaboratorComponent_th_25_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](0, "th", 39);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](1, " ID. ");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
  }
}
function CollaboratorComponent_td_26_Template(rf, ctx) {
  if (rf & 1) {
    const _r79 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](0, "td", 43);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵlistener"]("click", function CollaboratorComponent_td_26_Template_td_click_0_listener() {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵrestoreView"](_r79);
      const element_r77 = restoredCtx.$implicit;
      const ctx_r78 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵresetView"](ctx_r78.copyToClipboard(element_r77.id));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const element_r77 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtextInterpolate1"](" ", element_r77.id.substring(0, 6), " ");
  }
}
function CollaboratorComponent_th_28_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](0, "th", 39);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](1, " Name ");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
  }
}
function CollaboratorComponent_td_29_Template(rf, ctx) {
  if (rf & 1) {
    const _r82 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](0, "td", 43);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵlistener"]("click", function CollaboratorComponent_td_29_Template_td_click_0_listener() {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵrestoreView"](_r82);
      const element_r80 = restoredCtx.$implicit;
      const ctx_r81 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵresetView"](ctx_r81.clickName(element_r80));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const element_r80 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtextInterpolate1"](" ", element_r80.collaboratorName, " ");
  }
}
function CollaboratorComponent_th_31_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](0, "th", 39);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](1, " Mobile ");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
  }
}
function CollaboratorComponent_td_32_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](0, "td", 41);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const element_r83 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtextInterpolate1"](" ", element_r83.mobile, " ");
  }
}
function CollaboratorComponent_th_34_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](0, "th", 39);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](1, " City ");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
  }
}
function CollaboratorComponent_td_35_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](0, "td", 41);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const element_r84 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtextInterpolate1"](" ", element_r84.city, " ");
  }
}
function CollaboratorComponent_th_37_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](0, "th", 39);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](1, " Email ");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
  }
}
function CollaboratorComponent_td_38_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](0, "td", 41);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const element_r85 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtextInterpolate1"](" ", element_r85.email, " ");
  }
}
function CollaboratorComponent_th_40_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](0, "th", 39);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](1, " Status ");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
  }
}
function CollaboratorComponent_td_41_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](0, "td", 41);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const element_r86 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtextInterpolate1"](" ", element_r86.status, " ");
  }
}
function CollaboratorComponent_th_43_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](0, "th", 39);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](1, " Created At ");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
  }
}
function CollaboratorComponent_td_44_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](0, "td", 41);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const element_r87 = ctx.$implicit;
    const ctx_r16 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtextInterpolate1"](" ", ctx_r16.currentUTCDate(element_r87.createdAt), " ");
  }
}
function CollaboratorComponent_th_46_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](0, "th", 39);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](1, "Test");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
  }
}
function CollaboratorComponent_td_47_Template(rf, ctx) {
  if (rf & 1) {
    const _r90 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](0, "td", 41)(1, "mat-slide-toggle", 44);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵlistener"]("change", function CollaboratorComponent_td_47_Template_mat_slide_toggle_change_1_listener($event) {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵrestoreView"](_r90);
      const element_r88 = restoredCtx.$implicit;
      const ctx_r89 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵresetView"](ctx_r89.testChange($event, element_r88));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]()();
  }
  if (rf & 2) {
    const element_r88 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵproperty"]("checked", element_r88.test === true);
  }
}
function CollaboratorComponent_th_49_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](0, "th", 39);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](1, " Action ");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
  }
}
function CollaboratorComponent_td_50_Template(rf, ctx) {
  if (rf & 1) {
    const _r94 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](0, "td", 41)(1, "button", 45);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵlistener"]("click", function CollaboratorComponent_td_50_Template_button_click_1_listener() {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵrestoreView"](_r94);
      const element_r91 = restoredCtx.$implicit;
      const ctx_r93 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵresetView"](ctx_r93.toggle(element_r91));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](2, "mat-icon");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](3, "more_vert");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]()()();
  }
  if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵnextContext"]();
    const _r0 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵreference"](6);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵproperty"]("matMenuTriggerFor", _r0);
  }
}
function CollaboratorComponent_tr_51_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelement"](0, "tr", 46);
  }
}
function CollaboratorComponent_tr_52_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelement"](0, "tr", 47);
  }
}
function CollaboratorComponent_th_58_Template(rf, ctx) {
  if (rf & 1) {
    const _r98 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](0, "th", 39)(1, "mat-checkbox", 40);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵlistener"]("change", function CollaboratorComponent_th_58_Template_mat_checkbox_change_1_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵrestoreView"](_r98);
      const ctx_r97 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵresetView"](ctx_r97.selectAll($event));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]()();
  }
}
function CollaboratorComponent_td_59_Template(rf, ctx) {
  if (rf & 1) {
    const _r101 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](0, "td", 41)(1, "mat-checkbox", 42);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵlistener"]("ngModelChange", function CollaboratorComponent_td_59_Template_mat_checkbox_ngModelChange_1_listener($event) {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵrestoreView"](_r101);
      const element_r99 = restoredCtx.$implicit;
      return _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵresetView"](element_r99.selected = $event);
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]()();
  }
  if (rf & 2) {
    const element_r99 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵproperty"]("ngModel", element_r99.selected);
  }
}
function CollaboratorComponent_th_61_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](0, "th", 39);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](1, " Id. ");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
  }
}
function CollaboratorComponent_td_62_Template(rf, ctx) {
  if (rf & 1) {
    const _r104 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](0, "td", 43);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵlistener"]("click", function CollaboratorComponent_td_62_Template_td_click_0_listener() {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵrestoreView"](_r104);
      const element_r102 = restoredCtx.$implicit;
      const ctx_r103 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵresetView"](ctx_r103.copyToClipboard(element_r102.id));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const element_r102 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtextInterpolate1"](" ", element_r102.id.substring(0, 6), " ");
  }
}
function CollaboratorComponent_th_64_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](0, "th", 39);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](1, " Name ");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
  }
}
function CollaboratorComponent_td_65_Template(rf, ctx) {
  if (rf & 1) {
    const _r107 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](0, "td", 43);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵlistener"]("click", function CollaboratorComponent_td_65_Template_td_click_0_listener() {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵrestoreView"](_r107);
      const element_r105 = restoredCtx.$implicit;
      const ctx_r106 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵresetView"](ctx_r106.clickName(element_r105));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const element_r105 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtextInterpolate1"](" ", element_r105.collaboratorName, " ");
  }
}
function CollaboratorComponent_th_67_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](0, "th", 39);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](1, " Mobile ");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
  }
}
function CollaboratorComponent_td_68_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](0, "td", 41);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const element_r108 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtextInterpolate1"](" ", element_r108.mobile, " ");
  }
}
function CollaboratorComponent_th_70_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](0, "th", 39);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](1, " City ");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
  }
}
function CollaboratorComponent_td_71_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](0, "td", 41);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const element_r109 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtextInterpolate1"](" ", element_r109.city, " ");
  }
}
function CollaboratorComponent_th_73_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](0, "th", 39);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](1, " Status ");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
  }
}
function CollaboratorComponent_td_74_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](0, "td", 41);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const element_r110 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtextInterpolate1"](" ", element_r110.status, " ");
  }
}
function CollaboratorComponent_th_76_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](0, "th", 39);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](1, " Email ");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
  }
}
function CollaboratorComponent_td_77_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](0, "td", 41);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const element_r111 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtextInterpolate1"](" ", element_r111.email, " ");
  }
}
function CollaboratorComponent_th_79_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](0, "th", 39);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](1, " Created At ");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
  }
}
function CollaboratorComponent_td_80_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](0, "td", 41);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const element_r112 = ctx.$implicit;
    const ctx_r39 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtextInterpolate1"](" ", ctx_r39.currentUTCDate(element_r112.createdAt), " ");
  }
}
function CollaboratorComponent_th_82_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](0, "th", 39);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](1, "Test");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
  }
}
function CollaboratorComponent_td_83_Template(rf, ctx) {
  if (rf & 1) {
    const _r115 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](0, "td", 41)(1, "mat-slide-toggle", 44);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵlistener"]("change", function CollaboratorComponent_td_83_Template_mat_slide_toggle_change_1_listener($event) {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵrestoreView"](_r115);
      const element_r113 = restoredCtx.$implicit;
      const ctx_r114 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵresetView"](ctx_r114.testChange($event, element_r113));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]()();
  }
  if (rf & 2) {
    const element_r113 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵproperty"]("checked", element_r113.test === true);
  }
}
function CollaboratorComponent_th_85_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](0, "th", 39);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](1, " Action ");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
  }
}
function CollaboratorComponent_td_86_Template(rf, ctx) {
  if (rf & 1) {
    const _r119 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](0, "td", 41)(1, "button", 45);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵlistener"]("click", function CollaboratorComponent_td_86_Template_button_click_1_listener() {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵrestoreView"](_r119);
      const element_r116 = restoredCtx.$implicit;
      const ctx_r118 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵresetView"](ctx_r118.toggle(element_r116));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](2, "mat-icon");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](3, "more_vert");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]()()();
  }
  if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵnextContext"]();
    const _r0 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵreference"](6);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵproperty"]("matMenuTriggerFor", _r0);
  }
}
function CollaboratorComponent_tr_87_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelement"](0, "tr", 46);
  }
}
function CollaboratorComponent_tr_88_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelement"](0, "tr", 47);
  }
}
function CollaboratorComponent_th_94_Template(rf, ctx) {
  if (rf & 1) {
    const _r122 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](0, "th", 39)(1, "mat-checkbox", 40);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵlistener"]("change", function CollaboratorComponent_th_94_Template_mat_checkbox_change_1_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵrestoreView"](_r122);
      const ctx_r121 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵresetView"](ctx_r121.selectAll($event));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]()();
  }
}
function CollaboratorComponent_td_95_Template(rf, ctx) {
  if (rf & 1) {
    const _r125 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](0, "td", 41)(1, "mat-checkbox", 42);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵlistener"]("ngModelChange", function CollaboratorComponent_td_95_Template_mat_checkbox_ngModelChange_1_listener($event) {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵrestoreView"](_r125);
      const element_r123 = restoredCtx.$implicit;
      return _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵresetView"](element_r123.selected = $event);
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]()();
  }
  if (rf & 2) {
    const element_r123 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵproperty"]("ngModel", element_r123.selected);
  }
}
function CollaboratorComponent_th_97_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](0, "th", 39);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](1, " Id. ");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
  }
}
function CollaboratorComponent_td_98_Template(rf, ctx) {
  if (rf & 1) {
    const _r128 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](0, "td", 43);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵlistener"]("click", function CollaboratorComponent_td_98_Template_td_click_0_listener() {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵrestoreView"](_r128);
      const element_r126 = restoredCtx.$implicit;
      const ctx_r127 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵresetView"](ctx_r127.copyToClipboard(element_r126.id));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const element_r126 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtextInterpolate1"](" ", element_r126.id.substring(0, 6), " ");
  }
}
function CollaboratorComponent_th_100_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](0, "th", 39);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](1, " Name ");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
  }
}
function CollaboratorComponent_td_101_Template(rf, ctx) {
  if (rf & 1) {
    const _r131 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](0, "td", 43);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵlistener"]("click", function CollaboratorComponent_td_101_Template_td_click_0_listener() {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵrestoreView"](_r131);
      const element_r129 = restoredCtx.$implicit;
      const ctx_r130 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵresetView"](ctx_r130.clickName(element_r129));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const element_r129 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtextInterpolate1"](" ", element_r129.collaboratorName, " ");
  }
}
function CollaboratorComponent_th_103_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](0, "th", 39);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](1, " Mobile ");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
  }
}
function CollaboratorComponent_td_104_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](0, "td", 41);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const element_r132 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtextInterpolate1"](" ", element_r132.mobile, " ");
  }
}
function CollaboratorComponent_th_106_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](0, "th", 39);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](1, " City ");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
  }
}
function CollaboratorComponent_td_107_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](0, "td", 41);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const element_r133 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtextInterpolate1"](" ", element_r133.city, " ");
  }
}
function CollaboratorComponent_th_109_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](0, "th", 39);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](1, " Email ");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
  }
}
function CollaboratorComponent_td_110_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](0, "td", 41);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const element_r134 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtextInterpolate1"](" ", element_r134.email, " ");
  }
}
function CollaboratorComponent_th_112_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](0, "th", 39);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](1, " Created At ");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
  }
}
function CollaboratorComponent_td_113_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](0, "td", 41);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const element_r135 = ctx.$implicit;
    const ctx_r60 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtextInterpolate1"](" ", ctx_r60.currentUTCDate(element_r135.createdAt), " ");
  }
}
function CollaboratorComponent_th_115_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](0, "th", 39);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](1, "Test");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
  }
}
function CollaboratorComponent_td_116_Template(rf, ctx) {
  if (rf & 1) {
    const _r138 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](0, "td", 41)(1, "mat-slide-toggle", 44);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵlistener"]("change", function CollaboratorComponent_td_116_Template_mat_slide_toggle_change_1_listener($event) {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵrestoreView"](_r138);
      const element_r136 = restoredCtx.$implicit;
      const ctx_r137 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵresetView"](ctx_r137.testChange($event, element_r136));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]()();
  }
  if (rf & 2) {
    const element_r136 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵproperty"]("checked", element_r136.test === true);
  }
}
function CollaboratorComponent_th_118_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](0, "th", 39);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](1, " Status ");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
  }
}
function CollaboratorComponent_td_119_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](0, "td", 41);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const element_r139 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtextInterpolate1"](" ", element_r139.status, " ");
  }
}
function CollaboratorComponent_th_121_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](0, "th", 39);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](1, " Action ");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
  }
}
function CollaboratorComponent_td_122_Template(rf, ctx) {
  if (rf & 1) {
    const _r143 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](0, "td", 41)(1, "button", 45);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵlistener"]("click", function CollaboratorComponent_td_122_Template_button_click_1_listener() {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵrestoreView"](_r143);
      const element_r140 = restoredCtx.$implicit;
      const ctx_r142 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵresetView"](ctx_r142.toggle(element_r140));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](2, "mat-icon");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](3, "more_vert");
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]()()();
  }
  if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵnextContext"]();
    const _r0 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵreference"](6);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵproperty"]("matMenuTriggerFor", _r0);
  }
}
function CollaboratorComponent_tr_123_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelement"](0, "tr", 46);
  }
}
function CollaboratorComponent_tr_124_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelement"](0, "tr", 47);
  }
}
function CollaboratorComponent_app_add_collaborator_129_Template(rf, ctx) {
  if (rf & 1) {
    const _r146 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](0, "app-add-collaborator", 48);
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵlistener"]("cancelEvent", function CollaboratorComponent_app_add_collaborator_129_Template_app_add_collaborator_cancelEvent_0_listener() {
      _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵrestoreView"](_r146);
      const ctx_r145 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵresetView"](ctx_r145.cancel());
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const ctx_r71 = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵproperty"]("editData", ctx_r71.row);
  }
}
const _c4 = function () {
  return [5, 10, 25, 100];
};
class CollaboratorComponent {
  constructor(userManagementService, router, snackBar, dialog, loader, _snackBar) {
    this.userManagementService = userManagementService;
    this.router = router;
    this.snackBar = snackBar;
    this.dialog = dialog;
    this.loader = loader;
    this._snackBar = _snackBar;
    this.searchTerm = '';
    this.dataSource1 = new _angular_material_table__WEBPACK_IMPORTED_MODULE_9__.MatTableDataSource([]);
    this.dataSource2 = new _angular_material_table__WEBPACK_IMPORTED_MODULE_9__.MatTableDataSource([]);
    this.dataSource3 = new _angular_material_table__WEBPACK_IMPORTED_MODULE_9__.MatTableDataSource([]);
    this.type = 'All';
    // ... existing code ...
    this.selectedRows = [];
    this.showFiller = false;
    this.displayedColumns = ['selector', 'id', 'name', 'mobile', 'city', 'email', 'status', 'test', 'createdAt', 'action'];
    this.getCollaborators('All');
  }
  exportCollaboratorsToCSV() {
    let selectedData;
    if (this.type === 'All') {
      selectedData = this.dataSource1.data.filter(item => item.selected);
    } else if (this.type === 'Veterinary') {
      selectedData = this.dataSource2.data.filter(item => item.selected);
    } else if (this.type === 'Groomers') {
      selectedData = this.dataSource3.data.filter(item => item.selected);
    }
    if (selectedData.length === 0) {
      this.showSnackbar('No rows selected!');
      return;
    }
    const csvData = selectedData.map(item => ({
      id: item.id,
      name: item.collaboratorName,
      mobile: item.mobile,
      city: item.city,
      joinedDate: this.currentUTCDate(item.createdAt),
      email: item.email
    }));
    const csvContent = this.convertToCSV(csvData);
    const blob = new Blob([csvContent], {
      type: 'text/csv;charset=utf-8'
    });
    (0,file_saver__WEBPACK_IMPORTED_MODULE_0__.saveAs)(blob, 'collaborators.csv');
  }
  convertToCSV(data) {
    const header = Object.keys(data[0]).join(',');
    const rows = data.map(item => Object.values(item).join(','));
    return `${header}\n${rows.join('\n')}`;
  }
  showSnackbar(message) {
    // Implement your Snackbar logic here
    alert(message);
  }
  openSnackBar(message) {
    this._snackBar.open(message, 'Close', {
      duration: 2000
    });
  }
  copyToClipboard(text) {
    navigator.clipboard.writeText(text).then(() => {
      this.openSnackBar('Copied!');
    }).catch(err => {
      console.error('Failed to copy text: ', err);
    });
  }
  ngAfterViewInit() {
    this.dataSource1.paginator = this.paginator1;
    this.dataSource2.paginator = this.paginator2;
    this.dataSource3.paginator = this.paginator3;
    // this.dataSource3.paginator = this.paginator1;
    // this.collaboratorsTable.paginator = this.paginator;
    // this.collaboratorsTable.sort = this.sort; // Add this line to enable sorting
  }
  currentUTCDate(date) {
    return moment__WEBPACK_IMPORTED_MODULE_3___default().utc(date).local().format("DD-MMM-YYYY hh:mm A");
  }
  getCollaborators(type) {
    console.log(type);
    this.loader.showLoader();
    this.userManagementService.getCollaboratorsByType(type).subscribe(res => {
      this.loader.hideLoader();
      res.forEach(el => {
        // console.log(el['name']);
        el['collaboratorName'] = el['collaboratorName'] ? el['collaboratorName'].split(' ').map(word => word.charAt(0).toUpperCase() + word.slice(1).toLowerCase()).join(' ') : '';
        el['city'] = el['city'] ? el['city'][0].toUpperCase() + el['city'].slice(1).toLowerCase() : '';
        // .capitalize()
      });
      this.data = res;
      if (type == 'All') {
        this.dataSource1 = new _angular_material_table__WEBPACK_IMPORTED_MODULE_9__.MatTableDataSource(res);
        this.dataSource1.paginator = this.paginator1;
        this.dataSource1.sort = this.sort;
      } else if (type == 'Veterinary') {
        this.dataSource2 = new _angular_material_table__WEBPACK_IMPORTED_MODULE_9__.MatTableDataSource(res);
        this.dataSource2.paginator = this.paginator2;
        this.dataSource2.sort = this.sort;
      } else if (type == 'Groomers') {
        this.dataSource3 = new _angular_material_table__WEBPACK_IMPORTED_MODULE_9__.MatTableDataSource(res);
        this.dataSource3.paginator = this.paginator3;
        this.dataSource3.sort = this.sort;
      }
      // this.collaboratorsTable.filterPredicate = this.createFilter(); // Add this line to enable custom filtering
    });
  }
  selectAll(event) {
    const checked = event.checked;
    let dataSource;
    if (this.type === 'All') {
      dataSource = this.dataSource1.data;
    } else if (this.type === 'Veterinary') {
      dataSource = this.dataSource2.data;
    } else if (this.type === 'Groomers') {
      dataSource = this.dataSource3.data;
    }
    dataSource.forEach(item => {
      item.selected = checked;
    });
  }
  createFilter() {
    let filterFunction = function (data, filter) {
      const searchTerms = filter.split(' ').map(term => term.toLowerCase());
      for (const searchTerm of searchTerms) {
        if (data.collaboratorName.toLowerCase().indexOf(searchTerm) !== -1 || data.id.toLowerCase().indexOf(searchTerm) !== -1 || data.mobile.toLowerCase().indexOf(searchTerm) !== -1) {
          return true;
        }
      }
      return false;
    };
    return filterFunction;
  }
  tabClick(tab) {
    console.log(tab['tab']['textLabel']);
    this.type = tab['tab']['textLabel'];
    this.getCollaborators(this.type);
    this.userManagementService.getCollaboratorsByType(tab['tab']['textLabel']).subscribe(res => {
      res.forEach(el => {
        // console.log(el['name']);
        el['collaboratorName'] = el['collaboratorName'] ? el['collaboratorName'].split(' ').map(word => word.charAt(0).toUpperCase() + word.slice(1).toLowerCase()).join(' ') : '';
        el['city'] = el['city'] ? el['city'][0].toUpperCase() + el['city'].slice(1).toLowerCase() : '';
        // .capitalize()
      });
      console.log(res);
      this.data = res;
      if (tab['tab']['textLabel'] == 'All') {
        const dataSource1 = Object.values(res);
        this.dataSource1 = new _angular_material_table__WEBPACK_IMPORTED_MODULE_9__.MatTableDataSource(dataSource1.map(item => ({
          ...item
        })));
        this.dataSource1.paginator = this.paginator1;
        this.dataSource1.sort = this.sort; // Add this line to enable sorting
      } else if (tab['tab']['textLabel'] == 'Veterinary') {
        const dataSource2 = Object.values(res);
        this.dataSource2 = new _angular_material_table__WEBPACK_IMPORTED_MODULE_9__.MatTableDataSource(dataSource2.map(item => ({
          ...item
        })));
        this.dataSource2.paginator = this.paginator2;
        this.dataSource2.sort = this.sort;
      } else if (tab['tab']['textLabel'] == 'Groomers') {
        const dataSource1 = Object.values(res);
        this.dataSource3 = new _angular_material_table__WEBPACK_IMPORTED_MODULE_9__.MatTableDataSource(dataSource1.map(item => ({
          ...item
        })));
        this.dataSource3.paginator = this.paginator3;
        this.dataSource3.sort = this.sort;
      }
    });
  }
  addCollaborator() {
    // 'petParent/addUser'
    this.router.navigate(['/user/collaborator/addCollaborator']);
  }
  editUser() {
    this.row = this.selectedData;
    this.showFiller = true;
    this.sidenav.toggle();
  }
  clickName(element) {
    console.log(element);
    // return this.selectedData
    this.row = element;
    this.showFiller = true;
    this.sidenav.toggle();
  }
  deleteUser() {
    // this.menuTrigger.closeMenu();
    const dialogRef = this.dialog.open(app_components_controllers_confirmation_dialog_confirmation_dialog_component__WEBPACK_IMPORTED_MODULE_1__.ConfirmationDialogComponent, {
      width: '400px',
      data: {
        message: 'Are you sure you want to Delete?'
      }
    });
    dialogRef.afterClosed().subscribe(result => {
      if (result) {
        // User confirmed action
        this.loader.showLoader();
        this.userManagementService.deleteCollaborator(this.selectedData['id']).subscribe(res => {
          this.loader.hideLoader();
          this.getCollaborators('All');
          const dialogRef = this.dialog.open(app_components_controllers_success_dialog_success_dialog_component__WEBPACK_IMPORTED_MODULE_2__.SuccessDialogComponent, {
            width: '300px',
            data: {
              message: 'Collaborator deleted successfully! ',
              success: true
            },
            panelClass: 'success-dialog-container'
          });
        }, error => {
          this.loader.hideLoader();
          const dialogRef = this.dialog.open(app_components_controllers_success_dialog_success_dialog_component__WEBPACK_IMPORTED_MODULE_2__.SuccessDialogComponent, {
            width: '300px',
            data: {
              message: 'Something Went Wrong!',
              success: false
            }
          });
        });
      } else {
        // User cancelled action
        console.log('Cancelled');
        dialogRef.close();
      }
    });
  }
  cancel() {
    this.getCollaborators(this.type);
    this.sidenav.toggle();
  }
  toggle(element) {
    // drawer.toggle()
    this.row = element;
    this.showFiller = !this.showFiller;
  }
  filter(searchTerm) {
    this.searchTerm = searchTerm;
    this.applyFilter();
  }
  applyFilter() {
    // if(this.type == 'All'){
    //   this.dataSource1.filter = this.searchTerm.trim().toLowerCase();
    // }else if(this.type == 'Veterinary'){
    //   this.dataSource2.filter = this.searchTerm.trim().toLowerCase();
    // }else if(this.type == 'Groomers'){
    //   this.dataSource3.filter = this.searchTerm.trim().toLowerCase();
    // }
    const filterValue = this.searchTerm.trim().toLowerCase();
    this.dataSource1.filter = filterValue;
    this.dataSource2.filter = filterValue;
    this.dataSource3.filter = filterValue;
  }
  showSuccessToast(message) {
    this.snackBar.open(message, 'Close', {
      duration: 3000,
      panelClass: ['success-toast']
    });
  }
  showErrorToast(message) {
    this.snackBar.open(message, 'Close', {
      duration: 3000,
      panelClass: ['error-toast']
    });
  }
  testChange(event, element) {
    this.loader.showLoader();
    this.userManagementService.testChange(event['checked'] ? 'Active' : 'InActive', event['checked'], element['id']).subscribe(res => {
      this.loader.hideLoader();
      this.showSuccessToast('Successfully Done');
    }, error => {
      this.loader.hideLoader();
      this.showErrorToast('Failed ...');
    });
  }
  static #_ = this.ɵfac = function CollaboratorComponent_Factory(t) {
    return new (t || CollaboratorComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵdirectiveInject"](app_services_user_management_service__WEBPACK_IMPORTED_MODULE_4__.UserManagementService), _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵdirectiveInject"](_angular_router__WEBPACK_IMPORTED_MODULE_10__.Router), _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵdirectiveInject"](_angular_material_snack_bar__WEBPACK_IMPORTED_MODULE_11__.MatSnackBar), _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵdirectiveInject"](_angular_material_dialog__WEBPACK_IMPORTED_MODULE_12__.MatDialog), _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵdirectiveInject"](app_services_loader_service__WEBPACK_IMPORTED_MODULE_5__.LoaderService), _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵdirectiveInject"](_angular_material_snack_bar__WEBPACK_IMPORTED_MODULE_11__.MatSnackBar));
  };
  static #_2 = this.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵdefineComponent"]({
    type: CollaboratorComponent,
    selectors: [["app-collaborator"]],
    viewQuery: function CollaboratorComponent_Query(rf, ctx) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵviewQuery"](_c0, 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵviewQuery"](_c1, 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵviewQuery"](_c2, 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵviewQuery"](_c3, 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵviewQuery"](_angular_material_sort__WEBPACK_IMPORTED_MODULE_13__.MatSort, 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵviewQuery"](_angular_material_menu__WEBPACK_IMPORTED_MODULE_14__.MatMenuTrigger, 5);
      }
      if (rf & 2) {
        let _t;
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵloadQuery"]()) && (ctx.sidenav = _t.first);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵloadQuery"]()) && (ctx.paginator1 = _t.first);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵloadQuery"]()) && (ctx.paginator2 = _t.first);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵloadQuery"]()) && (ctx.paginator3 = _t.first);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵloadQuery"]()) && (ctx.sort = _t.first);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵloadQuery"]()) && (ctx.menuTrigger = _t.first);
      }
    },
    decls: 130,
    vars: 19,
    consts: [[1, "flex", "flex-col", "flex-auto", "min-w-0", 2, "width", "100%", "overflow-y", "auto", "height", "calc(100vh - 70px)"], [1, "flex-auto"], ["autosize", "", 2, "width", "100%", "height", "100%"], ["actionName", "Add Partner", 3, "filterEvent", "addEvent", "exportEvent"], ["actionMenu", "matMenu"], ["mat-menu-item", "", 3, "click"], [2, "color", "blue !important"], ["color", "primary"], [2, "color", "hsl(0, 94%, 42%) !important"], ["color", "warn"], [2, "width", "100%"], ["mat-stretch-tabs", "false", "mat-align-tabs", "start", 1, "mat-elevation-z8", "mt-2", 3, "selectedTabChange"], ["label", "All"], ["mat-table", "", 1, "mat-elevation-z8", "mt-2", 3, "dataSource"], ["matColumnDef", "selector"], ["mat-header-cell", "", 4, "matHeaderCellDef"], ["mat-cell", "", 4, "matCellDef"], ["matColumnDef", "id"], ["mat-cell", "", "style", "cursor: pointer;", 3, "click", 4, "matCellDef"], ["matColumnDef", "name"], ["matColumnDef", "mobile"], ["matColumnDef", "city"], ["matColumnDef", "email"], ["matColumnDef", "status"], ["matColumnDef", "createdAt"], ["matColumnDef", "test"], ["matColumnDef", "action"], ["mat-header-row", "", 4, "matHeaderRowDef"], ["mat-row", "", 4, "matRowDef", "matRowDefColumns"], [3, "pageSize", "pageSizeOptions"], ["paginator1", ""], ["label", "Veterinary"], ["mat-table", "", 1, "mat-elevation-z8", 3, "dataSource"], ["paginator2", ""], ["label", "Groomers"], ["paginator3", ""], ["mode", "over", "position", "end", 2, "width", "80%"], ["sidenav", ""], [3, "editData", "cancelEvent", 4, "ngIf"], ["mat-header-cell", ""], [3, "change"], ["mat-cell", ""], [3, "ngModel", "ngModelChange"], ["mat-cell", "", 2, "cursor", "pointer", 3, "click"], [3, "checked", "change"], ["mat-icon-button", "", 3, "matMenuTriggerFor", "click"], ["mat-header-row", ""], ["mat-row", ""], [3, "editData", "cancelEvent"]],
    template: function CollaboratorComponent_Template(rf, ctx) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](0, "div", 0)(1, "div", 1)(2, "mat-drawer-container", 2)(3, "div")(4, "app-generic-actions", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵlistener"]("filterEvent", function CollaboratorComponent_Template_app_generic_actions_filterEvent_4_listener($event) {
          return ctx.filter($event);
        })("addEvent", function CollaboratorComponent_Template_app_generic_actions_addEvent_4_listener() {
          return ctx.addCollaborator();
        })("exportEvent", function CollaboratorComponent_Template_app_generic_actions_exportEvent_4_listener() {
          return ctx.exportCollaboratorsToCSV();
        });
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]()();
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](5, "mat-menu", null, 4)(7, "button", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵlistener"]("click", function CollaboratorComponent_Template_button_click_7_listener() {
          return ctx.editUser();
        });
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](8, "span", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](9, "Edit");
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](10, "mat-icon", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](11, "edit");
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]()();
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](12, "button", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵlistener"]("click", function CollaboratorComponent_Template_button_click_12_listener() {
          return ctx.deleteUser();
        });
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](13, "span", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](14, "Delete");
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](15, "mat-icon", 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtext"](16, "delete");
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]()()();
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](17, "div", 10)(18, "mat-tab-group", 11);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵlistener"]("selectedTabChange", function CollaboratorComponent_Template_mat_tab_group_selectedTabChange_18_listener($event) {
          return ctx.tabClick($event);
        });
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](19, "mat-tab", 12)(20, "table", 13);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementContainerStart"](21, 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](22, CollaboratorComponent_th_22_Template, 2, 0, "th", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](23, CollaboratorComponent_td_23_Template, 2, 1, "td", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementContainerStart"](24, 17);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](25, CollaboratorComponent_th_25_Template, 2, 0, "th", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](26, CollaboratorComponent_td_26_Template, 2, 1, "td", 18);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementContainerStart"](27, 19);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](28, CollaboratorComponent_th_28_Template, 2, 0, "th", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](29, CollaboratorComponent_td_29_Template, 2, 1, "td", 18);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementContainerStart"](30, 20);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](31, CollaboratorComponent_th_31_Template, 2, 0, "th", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](32, CollaboratorComponent_td_32_Template, 2, 1, "td", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementContainerStart"](33, 21);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](34, CollaboratorComponent_th_34_Template, 2, 0, "th", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](35, CollaboratorComponent_td_35_Template, 2, 1, "td", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementContainerStart"](36, 22);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](37, CollaboratorComponent_th_37_Template, 2, 0, "th", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](38, CollaboratorComponent_td_38_Template, 2, 1, "td", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementContainerStart"](39, 23);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](40, CollaboratorComponent_th_40_Template, 2, 0, "th", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](41, CollaboratorComponent_td_41_Template, 2, 1, "td", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementContainerStart"](42, 24);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](43, CollaboratorComponent_th_43_Template, 2, 0, "th", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](44, CollaboratorComponent_td_44_Template, 2, 1, "td", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementContainerStart"](45, 25);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](46, CollaboratorComponent_th_46_Template, 2, 0, "th", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](47, CollaboratorComponent_td_47_Template, 2, 1, "td", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementContainerStart"](48, 26);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](49, CollaboratorComponent_th_49_Template, 2, 0, "th", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](50, CollaboratorComponent_td_50_Template, 4, 1, "td", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](51, CollaboratorComponent_tr_51_Template, 1, 0, "tr", 27);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](52, CollaboratorComponent_tr_52_Template, 1, 0, "tr", 28);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelement"](53, "mat-paginator", 29, 30);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](55, "mat-tab", 31)(56, "table", 32);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementContainerStart"](57, 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](58, CollaboratorComponent_th_58_Template, 2, 0, "th", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](59, CollaboratorComponent_td_59_Template, 2, 1, "td", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementContainerStart"](60, 17);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](61, CollaboratorComponent_th_61_Template, 2, 0, "th", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](62, CollaboratorComponent_td_62_Template, 2, 1, "td", 18);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementContainerStart"](63, 19);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](64, CollaboratorComponent_th_64_Template, 2, 0, "th", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](65, CollaboratorComponent_td_65_Template, 2, 1, "td", 18);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementContainerStart"](66, 20);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](67, CollaboratorComponent_th_67_Template, 2, 0, "th", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](68, CollaboratorComponent_td_68_Template, 2, 1, "td", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementContainerStart"](69, 21);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](70, CollaboratorComponent_th_70_Template, 2, 0, "th", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](71, CollaboratorComponent_td_71_Template, 2, 1, "td", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementContainerStart"](72, 23);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](73, CollaboratorComponent_th_73_Template, 2, 0, "th", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](74, CollaboratorComponent_td_74_Template, 2, 1, "td", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementContainerStart"](75, 22);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](76, CollaboratorComponent_th_76_Template, 2, 0, "th", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](77, CollaboratorComponent_td_77_Template, 2, 1, "td", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementContainerStart"](78, 24);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](79, CollaboratorComponent_th_79_Template, 2, 0, "th", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](80, CollaboratorComponent_td_80_Template, 2, 1, "td", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementContainerStart"](81, 25);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](82, CollaboratorComponent_th_82_Template, 2, 0, "th", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](83, CollaboratorComponent_td_83_Template, 2, 1, "td", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementContainerStart"](84, 26);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](85, CollaboratorComponent_th_85_Template, 2, 0, "th", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](86, CollaboratorComponent_td_86_Template, 4, 1, "td", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](87, CollaboratorComponent_tr_87_Template, 1, 0, "tr", 27);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](88, CollaboratorComponent_tr_88_Template, 1, 0, "tr", 28);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelement"](89, "mat-paginator", 29, 33);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](91, "mat-tab", 34)(92, "table", 32);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementContainerStart"](93, 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](94, CollaboratorComponent_th_94_Template, 2, 0, "th", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](95, CollaboratorComponent_td_95_Template, 2, 1, "td", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementContainerStart"](96, 17);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](97, CollaboratorComponent_th_97_Template, 2, 0, "th", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](98, CollaboratorComponent_td_98_Template, 2, 1, "td", 18);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementContainerStart"](99, 19);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](100, CollaboratorComponent_th_100_Template, 2, 0, "th", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](101, CollaboratorComponent_td_101_Template, 2, 1, "td", 18);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementContainerStart"](102, 20);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](103, CollaboratorComponent_th_103_Template, 2, 0, "th", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](104, CollaboratorComponent_td_104_Template, 2, 1, "td", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementContainerStart"](105, 21);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](106, CollaboratorComponent_th_106_Template, 2, 0, "th", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](107, CollaboratorComponent_td_107_Template, 2, 1, "td", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementContainerStart"](108, 22);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](109, CollaboratorComponent_th_109_Template, 2, 0, "th", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](110, CollaboratorComponent_td_110_Template, 2, 1, "td", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementContainerStart"](111, 24);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](112, CollaboratorComponent_th_112_Template, 2, 0, "th", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](113, CollaboratorComponent_td_113_Template, 2, 1, "td", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementContainerStart"](114, 25);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](115, CollaboratorComponent_th_115_Template, 2, 0, "th", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](116, CollaboratorComponent_td_116_Template, 2, 1, "td", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementContainerStart"](117, 23);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](118, CollaboratorComponent_th_118_Template, 2, 0, "th", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](119, CollaboratorComponent_td_119_Template, 2, 1, "td", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementContainerStart"](120, 26);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](121, CollaboratorComponent_th_121_Template, 2, 0, "th", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](122, CollaboratorComponent_td_122_Template, 4, 1, "td", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](123, CollaboratorComponent_tr_123_Template, 1, 0, "tr", 27);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](124, CollaboratorComponent_tr_124_Template, 1, 0, "tr", 28);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelement"](125, "mat-paginator", 29, 35);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]()()()()()();
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementStart"](127, "mat-drawer", 36, 37);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵtemplate"](129, CollaboratorComponent_app_add_collaborator_129_Template, 1, 1, "app-add-collaborator", 38);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵelementEnd"]();
      }
      if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](20);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵproperty"]("dataSource", ctx.dataSource1);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](31);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵproperty"]("matHeaderRowDef", ctx.displayedColumns);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵproperty"]("matRowDefColumns", ctx.displayedColumns);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵproperty"]("pageSize", 10)("pageSizeOptions", _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵpureFunction0"](16, _c4));
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵproperty"]("dataSource", ctx.dataSource2);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](31);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵproperty"]("matHeaderRowDef", ctx.displayedColumns);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵproperty"]("matRowDefColumns", ctx.displayedColumns);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵproperty"]("pageSize", 10)("pageSizeOptions", _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵpureFunction0"](17, _c4));
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵproperty"]("dataSource", ctx.dataSource3);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](31);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵproperty"]("matHeaderRowDef", ctx.displayedColumns);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵproperty"]("matRowDefColumns", ctx.displayedColumns);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵproperty"]("pageSize", 10)("pageSizeOptions", _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵpureFunction0"](18, _c4));
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_8__["ɵɵproperty"]("ngIf", ctx.showFiller);
      }
    },
    dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_15__.NgIf, _angular_material_tabs__WEBPACK_IMPORTED_MODULE_16__.MatTab, _angular_material_tabs__WEBPACK_IMPORTED_MODULE_16__.MatTabGroup, _angular_material_table__WEBPACK_IMPORTED_MODULE_9__.MatTable, _angular_material_table__WEBPACK_IMPORTED_MODULE_9__.MatHeaderCellDef, _angular_material_table__WEBPACK_IMPORTED_MODULE_9__.MatHeaderRowDef, _angular_material_table__WEBPACK_IMPORTED_MODULE_9__.MatColumnDef, _angular_material_table__WEBPACK_IMPORTED_MODULE_9__.MatCellDef, _angular_material_table__WEBPACK_IMPORTED_MODULE_9__.MatRowDef, _angular_material_table__WEBPACK_IMPORTED_MODULE_9__.MatHeaderCell, _angular_material_table__WEBPACK_IMPORTED_MODULE_9__.MatCell, _angular_material_table__WEBPACK_IMPORTED_MODULE_9__.MatHeaderRow, _angular_material_table__WEBPACK_IMPORTED_MODULE_9__.MatRow, _components_common_components_generic_actions_generic_actions_component__WEBPACK_IMPORTED_MODULE_6__.GenericActionsComponent, _angular_material_button__WEBPACK_IMPORTED_MODULE_17__.MatIconButton, _angular_forms__WEBPACK_IMPORTED_MODULE_18__.NgControlStatus, _angular_forms__WEBPACK_IMPORTED_MODULE_18__.NgModel, _angular_material_menu__WEBPACK_IMPORTED_MODULE_14__.MatMenu, _angular_material_menu__WEBPACK_IMPORTED_MODULE_14__.MatMenuItem, _angular_material_menu__WEBPACK_IMPORTED_MODULE_14__.MatMenuTrigger, _angular_material_icon__WEBPACK_IMPORTED_MODULE_19__.MatIcon, _angular_material_sidenav__WEBPACK_IMPORTED_MODULE_20__.MatDrawer, _angular_material_sidenav__WEBPACK_IMPORTED_MODULE_20__.MatDrawerContainer, _angular_material_slide_toggle__WEBPACK_IMPORTED_MODULE_21__.MatSlideToggle, _angular_material_paginator__WEBPACK_IMPORTED_MODULE_22__.MatPaginator, _angular_material_checkbox__WEBPACK_IMPORTED_MODULE_23__.MatCheckbox, _add_collaborator_add_collaborator_component__WEBPACK_IMPORTED_MODULE_7__.AddCollaboratorComponent],
    styles: [".btn-wrapper[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: row;\n  justify-content: right;\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImNvbGxhYm9yYXRvci5jb21wb25lbnQuc2NzcyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFJQTtFQUNFLGFBQUE7RUFDQSxtQkFBQTtFQUNBLHNCQUFBO0FBSEYiLCJmaWxlIjoiY29sbGFib3JhdG9yLmNvbXBvbmVudC5zY3NzIiwic291cmNlc0NvbnRlbnQiOlsiLy8gLm1hdC10YWItZ3JvdXAge1xuLy8gICBtYXJnaW4tYm90dG9tOiA0OHB4O1xuLy8gfVxuXG4uYnRuLXdyYXBwZXIge1xuICBkaXNwbGF5OiBmbGV4O1xuICBmbGV4LWRpcmVjdGlvbjogcm93O1xuICBqdXN0aWZ5LWNvbnRlbnQ6IHJpZ2h0O1xuXG4gIC8vIGJ1dHRvbiB7XG4gIC8vICAgbWFyZ2luOiAxMHB4O1xuICAvLyB9XG59XG5cbiJdfQ== */\n/*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8uL3NyYy9hcHAvbW9kdWxlcy91c2VyLW1hbmFlbWVudC9jb2xsYWJvcmF0b3IvY29sbGFib3JhdG9yLmNvbXBvbmVudC5zY3NzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUlBO0VBQ0UsYUFBQTtFQUNBLG1CQUFBO0VBQ0Esc0JBQUE7QUFIRjtBQUNBLHdpQkFBd2lCIiwic291cmNlc0NvbnRlbnQiOlsiLy8gLm1hdC10YWItZ3JvdXAge1xuLy8gICBtYXJnaW4tYm90dG9tOiA0OHB4O1xuLy8gfVxuXG4uYnRuLXdyYXBwZXIge1xuICBkaXNwbGF5OiBmbGV4O1xuICBmbGV4LWRpcmVjdGlvbjogcm93O1xuICBqdXN0aWZ5LWNvbnRlbnQ6IHJpZ2h0O1xuXG4gIC8vIGJ1dHRvbiB7XG4gIC8vICAgbWFyZ2luOiAxMHB4O1xuICAvLyB9XG59XG5cbiJdLCJzb3VyY2VSb290IjoiIn0= */"]
  });
}


/***/ }),

/***/ 13285:
/*!****************************************************************************************************!*\
  !*** ./src/app/modules/user-manaement/docs/adoption-certificate/adoption-certificate.component.ts ***!
  \****************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AdoptionCertificateComponent": () => (/* binding */ AdoptionCertificateComponent)
/* harmony export */ });
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/forms */ 69542);
/* harmony import */ var app_components_controllers_confirmation_dialog_confirmation_dialog_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! app/components/controllers/confirmation-dialog/confirmation-dialog.component */ 81500);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/core */ 86839);
/* harmony import */ var app_services_pet_service__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! app/services/pet.service */ 59976);
/* harmony import */ var _angular_material_dialog__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/material/dialog */ 67486);
/* harmony import */ var app_services_loader_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! app/services/loader.service */ 38555);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @angular/common */ 86477);
/* harmony import */ var _components_controllers_input_input_component__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../../components/controllers/input/input.component */ 30867);
/* harmony import */ var _components_controllers_upload_document_upload_document_component__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../../components/controllers/upload-document/upload-document.component */ 15698);
/* harmony import */ var _angular_material_button__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @angular/material/button */ 83677);
/* harmony import */ var _angular_material_icon__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @angular/material/icon */ 69941);












function AdoptionCertificateComponent_button_3_Template(rf, ctx) {
  if (rf & 1) {
    const _r2 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "button", 10);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵlistener"]("click", function AdoptionCertificateComponent_button_3_Template_button_click_0_listener() {
      _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵrestoreView"](_r2);
      const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵresetView"](ctx_r1.delete());
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](1, "mat-icon");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](2, "delete");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]()();
  }
}
class AdoptionCertificateComponent {
  constructor(fb, petService, dialogRef, dialog, loader) {
    this.fb = fb;
    this.petService = petService;
    this.dialogRef = dialogRef;
    this.dialog = dialog;
    this.loader = loader;
    this.createForm();
    this.createControlls();
    this.get();
  }
  get() {
    let data = {
      petId: sessionStorage.getItem('petId'),
      type: 'AdoptionCertificate',
      userId: sessionStorage.getItem('petParentId')
    };
    this.petService.getPetDoc(data).subscribe(res => {
      if (res.length > 0) {
        this.adoptionData = res[0];
        // let formDta = new FormData();
        // formDta.append('files', this.microChipData['docPath']);
        this.form.get('documentName').setValue(this.adoptionData['docName']);
        if (this.adoptionData['docPath']) {
          this.form.get('document').setValue(this.adoptionData['docPath']);
        }
      }
    });
  }
  add() {
    // this.petParentId = sessionStorage.getItem('petParentId');
    // this.petId = sessionStorage.getItem('petId')
    let json = this.form.value;
    console.log(json);
    // sessionStorage.getItem('petParentId');
    // sessionStorage.getItem('petId')
    let data = {
      petId: sessionStorage.getItem('petId'),
      type: 'AdoptionCertificate',
      docNumber: 0,
      userId: sessionStorage.getItem('petParentId'),
      docName: json['documentName'],
      validTill: 0,
      document: json['document']
    };
    // PetService
    if (this.adoptionData) {
      data['docId'] = this.adoptionData['id'];
      if (json['document']) {
        data['fileDelete'] = false;
      } else {
        data['fileDelete'] = true;
      }
      this.loader.showLoader();
      this.petService.editPetDoc(data).subscribe(res => {
        this.loader.hideLoader();
        this.dialogRef.close();
        console.log(res);
      });
    } else {
      this.loader.showLoader();
      this.petService.addPetDoc(data).subscribe(res => {
        this.petService.petDocsTemplateData[6]['icon'] = './assets/icons/pet-history/adoption.svg';
        this.loader.hideLoader();
        this.dialogRef.close();
        console.log(res);
      });
    }
  }
  onUpload(event) {
    this.form.get('document').setValue(event);
  }
  createForm() {
    this.form = this.fb.group({
      documentName: ['', [_angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.required]],
      // idNumber : ['',[Validators.required]],
      document: ['']
    });
  }
  createControlls() {
    this.controlls = {
      documentName: {
        id: "documentName",
        name: 'documentName',
        label: "Document Name",
        required: true,
        type: "text"
      },
      document: {
        id: "document",
        name: 'document',
        label: "Document",
        placeholder: "Document",
        required: true,
        type: "text"
      }
    };
  }
  onNoClick() {
    this.dialogRef.close();
  }
  delete() {
    const dialogRef = this.dialog.open(app_components_controllers_confirmation_dialog_confirmation_dialog_component__WEBPACK_IMPORTED_MODULE_0__.ConfirmationDialogComponent, {
      width: '400px',
      data: {
        message: 'Are you sure you want to Delete?'
      }
    });
    dialogRef.afterClosed().subscribe(result => {
      if (result) {
        this.loader.showLoader();
        this.petService.deletePetDoc(sessionStorage.getItem('petParentId'), this.adoptionData['id']).subscribe(res => {
          this.petService.petDocsTemplateData[6]['icon'] = './assets/icons/grey-pet-history/adoption.svg';
          console.log(res);
          this.createForm();
          this.loader.hideLoader();
          this.dialogRef.close();
        }, error => {
          this.loader.hideLoader();
          this.dialogRef.close();
        });
      } else {
        console.log("");
      }
    });
  }
  static #_ = this.ɵfac = function AdoptionCertificateComponent_Factory(t) {
    return new (t || AdoptionCertificateComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](_angular_forms__WEBPACK_IMPORTED_MODULE_6__.FormBuilder), _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](app_services_pet_service__WEBPACK_IMPORTED_MODULE_1__.PetService), _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](_angular_material_dialog__WEBPACK_IMPORTED_MODULE_7__.MatDialogRef), _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](_angular_material_dialog__WEBPACK_IMPORTED_MODULE_7__.MatDialog), _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](app_services_loader_service__WEBPACK_IMPORTED_MODULE_2__.LoaderService));
  };
  static #_2 = this.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdefineComponent"]({
    type: AdoptionCertificateComponent,
    selectors: [["app-adoption-certificate"]],
    inputs: {
      petId: "petId",
      petParentId: "petParentId"
    },
    decls: 13,
    vars: 5,
    consts: [[1, "header"], ["mat-dialog-title", "", 2, "align-items", "center"], ["mat-mini-fab", "", "color", "warn", 3, "click", 4, "ngIf"], ["mat-dialog-content", ""], [1, "row"], [2, "width", "100%", 3, "form", "controller"], [3, "form", "onSelect"], [1, "btn-wrapper"], ["mat-stroked-button", "", "color", "primary", 3, "click"], ["mat-stroked-button", "", "color", "primary", 3, "disabled", "click"], ["mat-mini-fab", "", "color", "warn", 3, "click"]],
    template: function AdoptionCertificateComponent_Template(rf, ctx) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "div", 0)(1, "h1", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](2, "Adoption Certificate");
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](3, AdoptionCertificateComponent_button_3_Template, 3, 0, "button", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](4, "div", 3)(5, "div", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelement"](6, "app-input", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](7, "app-upload-document", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵlistener"]("onSelect", function AdoptionCertificateComponent_Template_app_upload_document_onSelect_7_listener($event) {
          return ctx.onUpload($event);
        });
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](8, "div", 7)(9, "button", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵlistener"]("click", function AdoptionCertificateComponent_Template_button_click_9_listener() {
          return ctx.onNoClick();
        });
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](10, "Cancel");
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](11, "button", 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵlistener"]("click", function AdoptionCertificateComponent_Template_button_click_11_listener() {
          return ctx.add();
        });
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](12, "Save");
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]()()();
      }
      if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("ngIf", ctx.adoptionData);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("form", ctx.form)("controller", ctx.controlls["documentName"]);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("form", ctx.form);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("disabled", ctx.form.invalid);
      }
    },
    dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_8__.NgIf, _components_controllers_input_input_component__WEBPACK_IMPORTED_MODULE_3__.InputComponent, _components_controllers_upload_document_upload_document_component__WEBPACK_IMPORTED_MODULE_4__.UploadDocumentComponent, _angular_material_button__WEBPACK_IMPORTED_MODULE_9__.MatButton, _angular_material_button__WEBPACK_IMPORTED_MODULE_9__.MatMiniFabButton, _angular_material_icon__WEBPACK_IMPORTED_MODULE_10__.MatIcon],
    styles: [".btn-wrapper[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: row;\n  justify-content: right;\n}\n.btn-wrapper[_ngcontent-%COMP%]   button[_ngcontent-%COMP%] {\n  margin: 10px;\n}\n\n.container[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: column;\n  justify-content: space-between;\n  width: 100%;\n  height: 100%;\n}\n.container[_ngcontent-%COMP%]   .row[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: row;\n  width: 100%;\n  height: 25%;\n  padding: 1% 0;\n}\n\n.header[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: row;\n  justify-content: space-between;\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImFkb3B0aW9uLWNlcnRpZmljYXRlLmNvbXBvbmVudC5zY3NzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBO0VBQ0ksYUFBQTtFQUNBLG1CQUFBO0VBQ0Esc0JBQUE7QUFDSjtBQUFJO0VBQ0ksWUFBQTtBQUVSOztBQUNBO0VBQ0ksYUFBQTtFQUNBLHNCQUFBO0VBQ0EsOEJBQUE7RUFDQSxXQUFBO0VBQ0EsWUFBQTtBQUVKO0FBREk7RUFDSSxhQUFBO0VBQ0EsbUJBQUE7RUFDQSxXQUFBO0VBQ0EsV0FBQTtFQUNBLGFBQUE7QUFHUjs7QUFDQTtFQUNJLGFBQUE7RUFDQSxtQkFBQTtFQUNBLDhCQUFBO0FBRUoiLCJmaWxlIjoiYWRvcHRpb24tY2VydGlmaWNhdGUuY29tcG9uZW50LnNjc3MiLCJzb3VyY2VzQ29udGVudCI6WyIuYnRuLXdyYXBwZXJ7XG4gICAgZGlzcGxheTogZmxleDtcbiAgICBmbGV4LWRpcmVjdGlvbjogcm93O1xuICAgIGp1c3RpZnktY29udGVudDogcmlnaHQ7XG4gICAgYnV0dG9ue1xuICAgICAgICBtYXJnaW46IDEwcHg7XG4gICAgfVxufSBcbi5jb250YWluZXJ7XG4gICAgZGlzcGxheTogZmxleDtcbiAgICBmbGV4LWRpcmVjdGlvbjogY29sdW1uO1xuICAgIGp1c3RpZnktY29udGVudDogc3BhY2UtYmV0d2VlbjtcbiAgICB3aWR0aDogMTAwJTtcbiAgICBoZWlnaHQ6IDEwMCU7XG4gICAgLnJvd3tcbiAgICAgICAgZGlzcGxheTogZmxleDtcbiAgICAgICAgZmxleC1kaXJlY3Rpb246IHJvdztcbiAgICAgICAgd2lkdGg6IDEwMCU7XG4gICAgICAgIGhlaWdodDogMjUlO1xuICAgICAgICBwYWRkaW5nOiAxJSAwO1xuICAgIH1cbn1cblxuLmhlYWRlcntcbiAgICBkaXNwbGF5OiBmbGV4O1xuICAgIGZsZXgtZGlyZWN0aW9uOiByb3c7XG4gICAganVzdGlmeS1jb250ZW50OiBzcGFjZS1iZXR3ZWVuO1xufSJdfQ== */\n/*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8uL3NyYy9hcHAvbW9kdWxlcy91c2VyLW1hbmFlbWVudC9kb2NzL2Fkb3B0aW9uLWNlcnRpZmljYXRlL2Fkb3B0aW9uLWNlcnRpZmljYXRlLmNvbXBvbmVudC5zY3NzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBO0VBQ0ksYUFBQTtFQUNBLG1CQUFBO0VBQ0Esc0JBQUE7QUFDSjtBQUFJO0VBQ0ksWUFBQTtBQUVSOztBQUNBO0VBQ0ksYUFBQTtFQUNBLHNCQUFBO0VBQ0EsOEJBQUE7RUFDQSxXQUFBO0VBQ0EsWUFBQTtBQUVKO0FBREk7RUFDSSxhQUFBO0VBQ0EsbUJBQUE7RUFDQSxXQUFBO0VBQ0EsV0FBQTtFQUNBLGFBQUE7QUFHUjs7QUFDQTtFQUNJLGFBQUE7RUFDQSxtQkFBQTtFQUNBLDhCQUFBO0FBRUo7QUFDQSxndUNBQWd1QyIsInNvdXJjZXNDb250ZW50IjpbIi5idG4td3JhcHBlcntcbiAgICBkaXNwbGF5OiBmbGV4O1xuICAgIGZsZXgtZGlyZWN0aW9uOiByb3c7XG4gICAganVzdGlmeS1jb250ZW50OiByaWdodDtcbiAgICBidXR0b257XG4gICAgICAgIG1hcmdpbjogMTBweDtcbiAgICB9XG59IFxuLmNvbnRhaW5lcntcbiAgICBkaXNwbGF5OiBmbGV4O1xuICAgIGZsZXgtZGlyZWN0aW9uOiBjb2x1bW47XG4gICAganVzdGlmeS1jb250ZW50OiBzcGFjZS1iZXR3ZWVuO1xuICAgIHdpZHRoOiAxMDAlO1xuICAgIGhlaWdodDogMTAwJTtcbiAgICAucm93e1xuICAgICAgICBkaXNwbGF5OiBmbGV4O1xuICAgICAgICBmbGV4LWRpcmVjdGlvbjogcm93O1xuICAgICAgICB3aWR0aDogMTAwJTtcbiAgICAgICAgaGVpZ2h0OiAyNSU7XG4gICAgICAgIHBhZGRpbmc6IDElIDA7XG4gICAgfVxufVxuXG4uaGVhZGVye1xuICAgIGRpc3BsYXk6IGZsZXg7XG4gICAgZmxleC1kaXJlY3Rpb246IHJvdztcbiAgICBqdXN0aWZ5LWNvbnRlbnQ6IHNwYWNlLWJldHdlZW47XG59Il0sInNvdXJjZVJvb3QiOiIifQ== */"]
  });
}


/***/ }),

/***/ 65921:
/*!**********************************************************************************************!*\
  !*** ./src/app/modules/user-manaement/docs/birth-certificate/birth-certificate.component.ts ***!
  \**********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BirthCertificateComponent": () => (/* binding */ BirthCertificateComponent)
/* harmony export */ });
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/forms */ 69542);
/* harmony import */ var app_components_controllers_confirmation_dialog_confirmation_dialog_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! app/components/controllers/confirmation-dialog/confirmation-dialog.component */ 81500);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/core */ 86839);
/* harmony import */ var app_services_pet_service__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! app/services/pet.service */ 59976);
/* harmony import */ var _angular_material_dialog__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/material/dialog */ 67486);
/* harmony import */ var app_services_loader_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! app/services/loader.service */ 38555);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @angular/common */ 86477);
/* harmony import */ var _components_controllers_input_input_component__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../../components/controllers/input/input.component */ 30867);
/* harmony import */ var _components_controllers_upload_document_upload_document_component__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../../components/controllers/upload-document/upload-document.component */ 15698);
/* harmony import */ var _angular_material_button__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @angular/material/button */ 83677);
/* harmony import */ var _angular_material_icon__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @angular/material/icon */ 69941);












function BirthCertificateComponent_button_3_Template(rf, ctx) {
  if (rf & 1) {
    const _r2 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "button", 10);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵlistener"]("click", function BirthCertificateComponent_button_3_Template_button_click_0_listener() {
      _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵrestoreView"](_r2);
      const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵresetView"](ctx_r1.delete());
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](1, "mat-icon");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](2, "delete");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]()();
  }
}
class BirthCertificateComponent {
  constructor(fb, petService, dialogRef, dialog, loader) {
    this.fb = fb;
    this.petService = petService;
    this.dialogRef = dialogRef;
    this.dialog = dialog;
    this.loader = loader;
    this.createForm();
    this.createControlls();
    this.get();
  }
  onUpload(event) {
    this.form.get('document').setValue(event);
  }
  get() {
    let data = {
      petId: sessionStorage.getItem('petId'),
      type: 'BirthCertificate',
      userId: sessionStorage.getItem('petParentId')
    };
    this.petService.getPetDoc(data).subscribe(res => {
      if (res.length > 0) {
        this.certificateData = res[0];
        // let formDta = new FormData();
        // formDta.append('files', this.microChipData['docPath']);
        this.form.get('documentName').setValue(this.certificateData['docName']);
        if (this.certificateData['docPath']) {
          this.form.get('document').setValue(this.certificateData['docPath']);
        }
      }
    });
  }
  createForm() {
    this.form = this.fb.group({
      documentName: ['', [_angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.required]],
      // idNumber : ['',[Validators.required]],
      document: ['']
    });
  }
  createControlls() {
    this.controlls = {
      documentName: {
        id: "documentName",
        name: 'documentName',
        label: "Document Name",
        required: true,
        type: "text"
      },
      document: {
        id: "document",
        name: 'document',
        label: "Document",
        placeholder: "Document",
        required: true,
        type: "text"
      }
    };
  }
  add() {
    // this.petParentId = sessionStorage.getItem('petParentId');
    // this.petId = sessionStorage.getItem('petId')
    let json = this.form.value;
    console.log(json);
    // sessionStorage.getItem('petParentId');
    // sessionStorage.getItem('petId')
    let data = {
      petId: sessionStorage.getItem('petId'),
      type: 'BirthCertificate',
      docNumber: 0,
      userId: sessionStorage.getItem('petParentId'),
      docName: json['documentName'],
      validTill: 0,
      document: json['document']
    };
    // PetService
    if (this.certificateData) {
      data['docId'] = this.certificateData['id'];
      if (json['document']) {
        data['fileDelete'] = false;
      } else {
        data['fileDelete'] = true;
      }
      this.loader.showLoader();
      this.petService.editPetDoc(data).subscribe(res => {
        this.loader.hideLoader();
        this.dialogRef.close();
        console.log(res);
      });
    } else {
      this.loader.showLoader();
      this.petService.addPetDoc(data).subscribe(res => {
        this.petService.petDocsTemplateData[5]['icon'] = './assets/icons/pet-history/birth.svg';
        this.loader.hideLoader();
        this.dialogRef.close();
        console.log(res);
      });
    }
  }
  onNoClick() {
    this.dialogRef.close();
  }
  delete() {
    const dialogRef = this.dialog.open(app_components_controllers_confirmation_dialog_confirmation_dialog_component__WEBPACK_IMPORTED_MODULE_0__.ConfirmationDialogComponent, {
      width: '400px',
      data: {
        message: 'Are you sure you want to Delete?'
      }
    });
    dialogRef.afterClosed().subscribe(result => {
      if (result) {
        this.loader.showLoader();
        this.petService.deletePetDoc(sessionStorage.getItem('petParentId'), this.certificateData['id']).subscribe(res => {
          this.petService.petDocsTemplateData[5]['icon'] = './assets/icons/grey-pet-history/birth.svg';
          console.log(res);
          this.createForm();
          this.loader.hideLoader();
          this.dialogRef.close();
        }, error => {
          this.loader.hideLoader();
          this.dialogRef.close();
        });
      } else {
        console.log("");
      }
    });
  }
  static #_ = this.ɵfac = function BirthCertificateComponent_Factory(t) {
    return new (t || BirthCertificateComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](_angular_forms__WEBPACK_IMPORTED_MODULE_6__.FormBuilder), _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](app_services_pet_service__WEBPACK_IMPORTED_MODULE_1__.PetService), _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](_angular_material_dialog__WEBPACK_IMPORTED_MODULE_7__.MatDialogRef), _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](_angular_material_dialog__WEBPACK_IMPORTED_MODULE_7__.MatDialog), _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](app_services_loader_service__WEBPACK_IMPORTED_MODULE_2__.LoaderService));
  };
  static #_2 = this.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdefineComponent"]({
    type: BirthCertificateComponent,
    selectors: [["app-birth-certificate"]],
    inputs: {
      petId: "petId",
      petParentId: "petParentId"
    },
    decls: 13,
    vars: 5,
    consts: [[1, "header"], ["mat-dialog-title", "", 2, "align-items", "center"], ["mat-mini-fab", "", "color", "warn", 3, "click", 4, "ngIf"], ["mat-dialog-content", ""], [1, "row"], [2, "width", "100%", 3, "form", "controller"], [3, "form", "onSelect"], [1, "btn-wrapper"], ["mat-stroked-button", "", "color", "primary", 3, "click"], ["mat-stroked-button", "", "color", "primary", 3, "disabled", "click"], ["mat-mini-fab", "", "color", "warn", 3, "click"]],
    template: function BirthCertificateComponent_Template(rf, ctx) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "div", 0)(1, "h1", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](2, "Birth Certificate");
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](3, BirthCertificateComponent_button_3_Template, 3, 0, "button", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](4, "div", 3)(5, "div", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelement"](6, "app-input", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](7, "app-upload-document", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵlistener"]("onSelect", function BirthCertificateComponent_Template_app_upload_document_onSelect_7_listener($event) {
          return ctx.onUpload($event);
        });
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](8, "div", 7)(9, "button", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵlistener"]("click", function BirthCertificateComponent_Template_button_click_9_listener() {
          return ctx.onNoClick();
        });
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](10, "Cancel");
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](11, "button", 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵlistener"]("click", function BirthCertificateComponent_Template_button_click_11_listener() {
          return ctx.add();
        });
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](12, "Save");
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]()()();
      }
      if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("ngIf", ctx.certificateData);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("form", ctx.form)("controller", ctx.controlls["documentName"]);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("form", ctx.form);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("disabled", ctx.form.invalid);
      }
    },
    dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_8__.NgIf, _components_controllers_input_input_component__WEBPACK_IMPORTED_MODULE_3__.InputComponent, _components_controllers_upload_document_upload_document_component__WEBPACK_IMPORTED_MODULE_4__.UploadDocumentComponent, _angular_material_button__WEBPACK_IMPORTED_MODULE_9__.MatButton, _angular_material_button__WEBPACK_IMPORTED_MODULE_9__.MatMiniFabButton, _angular_material_icon__WEBPACK_IMPORTED_MODULE_10__.MatIcon],
    styles: [".btn-wrapper[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: row;\n  justify-content: right;\n}\n.btn-wrapper[_ngcontent-%COMP%]   button[_ngcontent-%COMP%] {\n  margin: 10px;\n}\n\n.container[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: column;\n  justify-content: space-between;\n  width: 100%;\n  height: 100%;\n}\n.container[_ngcontent-%COMP%]   .row[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: row;\n  width: 100%;\n  height: 25%;\n  padding: 1% 0;\n  padding-left: 4%;\n}\n\n.header[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: row;\n  justify-content: space-between;\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImJpcnRoLWNlcnRpZmljYXRlLmNvbXBvbmVudC5zY3NzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBO0VBQ0ksYUFBQTtFQUNBLG1CQUFBO0VBQ0Esc0JBQUE7QUFDSjtBQUFJO0VBQ0ksWUFBQTtBQUVSOztBQUNBO0VBQ0ksYUFBQTtFQUNBLHNCQUFBO0VBQ0EsOEJBQUE7RUFDQSxXQUFBO0VBQ0EsWUFBQTtBQUVKO0FBREk7RUFDSSxhQUFBO0VBQ0EsbUJBQUE7RUFDQSxXQUFBO0VBQ0EsV0FBQTtFQUNBLGFBQUE7RUFDQSxnQkFBQTtBQUdSOztBQUNBO0VBQ0ksYUFBQTtFQUNBLG1CQUFBO0VBQ0EsOEJBQUE7QUFFSiIsImZpbGUiOiJiaXJ0aC1jZXJ0aWZpY2F0ZS5jb21wb25lbnQuc2NzcyIsInNvdXJjZXNDb250ZW50IjpbIi5idG4td3JhcHBlcntcbiAgICBkaXNwbGF5OiBmbGV4O1xuICAgIGZsZXgtZGlyZWN0aW9uOiByb3c7XG4gICAganVzdGlmeS1jb250ZW50OiByaWdodDtcbiAgICBidXR0b257XG4gICAgICAgIG1hcmdpbjogMTBweDtcbiAgICB9XG59IFxuLmNvbnRhaW5lcntcbiAgICBkaXNwbGF5OiBmbGV4O1xuICAgIGZsZXgtZGlyZWN0aW9uOiBjb2x1bW47XG4gICAganVzdGlmeS1jb250ZW50OiBzcGFjZS1iZXR3ZWVuO1xuICAgIHdpZHRoOiAxMDAlO1xuICAgIGhlaWdodDogMTAwJTtcbiAgICAucm93e1xuICAgICAgICBkaXNwbGF5OiBmbGV4O1xuICAgICAgICBmbGV4LWRpcmVjdGlvbjogcm93O1xuICAgICAgICB3aWR0aDogMTAwJTtcbiAgICAgICAgaGVpZ2h0OiAyNSU7XG4gICAgICAgIHBhZGRpbmc6IDElIDA7XG4gICAgICAgIHBhZGRpbmctbGVmdDogNCU7XG4gICAgfVxufVxuXG4uaGVhZGVye1xuICAgIGRpc3BsYXk6IGZsZXg7XG4gICAgZmxleC1kaXJlY3Rpb246IHJvdztcbiAgICBqdXN0aWZ5LWNvbnRlbnQ6IHNwYWNlLWJldHdlZW47XG59Il19 */\n/*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8uL3NyYy9hcHAvbW9kdWxlcy91c2VyLW1hbmFlbWVudC9kb2NzL2JpcnRoLWNlcnRpZmljYXRlL2JpcnRoLWNlcnRpZmljYXRlLmNvbXBvbmVudC5zY3NzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBO0VBQ0ksYUFBQTtFQUNBLG1CQUFBO0VBQ0Esc0JBQUE7QUFDSjtBQUFJO0VBQ0ksWUFBQTtBQUVSOztBQUNBO0VBQ0ksYUFBQTtFQUNBLHNCQUFBO0VBQ0EsOEJBQUE7RUFDQSxXQUFBO0VBQ0EsWUFBQTtBQUVKO0FBREk7RUFDSSxhQUFBO0VBQ0EsbUJBQUE7RUFDQSxXQUFBO0VBQ0EsV0FBQTtFQUNBLGFBQUE7RUFDQSxnQkFBQTtBQUdSOztBQUNBO0VBQ0ksYUFBQTtFQUNBLG1CQUFBO0VBQ0EsOEJBQUE7QUFFSjtBQUNBLHd3Q0FBd3dDIiwic291cmNlc0NvbnRlbnQiOlsiLmJ0bi13cmFwcGVye1xuICAgIGRpc3BsYXk6IGZsZXg7XG4gICAgZmxleC1kaXJlY3Rpb246IHJvdztcbiAgICBqdXN0aWZ5LWNvbnRlbnQ6IHJpZ2h0O1xuICAgIGJ1dHRvbntcbiAgICAgICAgbWFyZ2luOiAxMHB4O1xuICAgIH1cbn0gXG4uY29udGFpbmVye1xuICAgIGRpc3BsYXk6IGZsZXg7XG4gICAgZmxleC1kaXJlY3Rpb246IGNvbHVtbjtcbiAgICBqdXN0aWZ5LWNvbnRlbnQ6IHNwYWNlLWJldHdlZW47XG4gICAgd2lkdGg6IDEwMCU7XG4gICAgaGVpZ2h0OiAxMDAlO1xuICAgIC5yb3d7XG4gICAgICAgIGRpc3BsYXk6IGZsZXg7XG4gICAgICAgIGZsZXgtZGlyZWN0aW9uOiByb3c7XG4gICAgICAgIHdpZHRoOiAxMDAlO1xuICAgICAgICBoZWlnaHQ6IDI1JTtcbiAgICAgICAgcGFkZGluZzogMSUgMDtcbiAgICAgICAgcGFkZGluZy1sZWZ0OiA0JTtcbiAgICB9XG59XG5cbi5oZWFkZXJ7XG4gICAgZGlzcGxheTogZmxleDtcbiAgICBmbGV4LWRpcmVjdGlvbjogcm93O1xuICAgIGp1c3RpZnktY29udGVudDogc3BhY2UtYmV0d2Vlbjtcbn0iXSwic291cmNlUm9vdCI6IiJ9 */"]
  });
}


/***/ }),

/***/ 76144:
/*!******************************************************************************************!*\
  !*** ./src/app/modules/user-manaement/docs/kci-certificate/kci-certificate.component.ts ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "KciCertificateComponent": () => (/* binding */ KciCertificateComponent)
/* harmony export */ });
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/forms */ 69542);
/* harmony import */ var app_components_controllers_confirmation_dialog_confirmation_dialog_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! app/components/controllers/confirmation-dialog/confirmation-dialog.component */ 81500);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/core */ 86839);
/* harmony import */ var app_services_pet_service__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! app/services/pet.service */ 59976);
/* harmony import */ var _angular_material_dialog__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/material/dialog */ 67486);
/* harmony import */ var app_services_loader_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! app/services/loader.service */ 38555);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @angular/common */ 86477);
/* harmony import */ var _components_controllers_input_input_component__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../../components/controllers/input/input.component */ 30867);
/* harmony import */ var _components_controllers_upload_document_upload_document_component__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../../components/controllers/upload-document/upload-document.component */ 15698);
/* harmony import */ var _angular_material_button__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @angular/material/button */ 83677);
/* harmony import */ var _angular_material_icon__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @angular/material/icon */ 69941);












function KciCertificateComponent_button_3_Template(rf, ctx) {
  if (rf & 1) {
    const _r2 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "button", 10);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵlistener"]("click", function KciCertificateComponent_button_3_Template_button_click_0_listener() {
      _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵrestoreView"](_r2);
      const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵresetView"](ctx_r1.delete());
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](1, "mat-icon");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](2, "delete");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]()();
  }
}
class KciCertificateComponent {
  constructor(fb, petService, dialogRef, dialog, loader) {
    this.fb = fb;
    this.petService = petService;
    this.dialogRef = dialogRef;
    this.dialog = dialog;
    this.loader = loader;
    this.createForm();
    this.createControlls();
    this.get();
  }
  get() {
    let data = {
      petId: sessionStorage.getItem('petId'),
      type: 'KCI_Certificate',
      userId: sessionStorage.getItem('petParentId')
    };
    this.petService.getPetDoc(data).subscribe(res => {
      if (res.length > 0) {
        this.kciData = res[0];
        // let formDta = new FormData();
        // formDta.append('files', this.microChipData['docPath']);        
        this.form.get('registrationNo').setValue(this.kciData['docNumber']);
        if (this.kciData['docPath']) {
          this.form.get('document').setValue(this.kciData['docPath']);
        }
      }
      console.log(this.form);
    });
  }
  add() {
    // this.petParentId = sessionStorage.getItem('petParentId');
    // this.petId = sessionStorage.getItem('petId')
    let json = this.form.value;
    console.log(json);
    // sessionStorage.getItem('petParentId');
    // sessionStorage.getItem('petId')
    let data = {
      petId: sessionStorage.getItem('petId'),
      type: 'KCI_Certificate',
      docNumber: json['registrationNo'],
      userId: sessionStorage.getItem('petParentId'),
      docName: 0,
      validTill: 0,
      document: json['document']
    };
    // PetService
    if (this.kciData) {
      data['docId'] = this.kciData['id'];
      if (json['document']) {
        data['fileDelete'] = false;
      } else {
        data['fileDelete'] = true;
      }
      this.loader.showLoader();
      this.petService.editPetDoc(data).subscribe(res => {
        console.log(res);
        this.loader.hideLoader();
        this.dialogRef.close();
      });
    } else {
      this.loader.showLoader();
      this.petService.addPetDoc(data).subscribe(res => {
        this.petService.petDocsTemplateData[9]['icon'] = './assets/icons/pet-history/KCI.svg';
        this.loader.hideLoader();
        this.dialogRef.close();
        console.log(res);
      });
    }
  }
  onUpload(event) {
    this.form.get('document').setValue(event);
  }
  createForm() {
    this.form = this.fb.group({
      registrationNo: ['', [_angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.required]],
      // idNumber : ['',[Validators.required]],
      document: ['']
    });
  }
  createControlls() {
    this.controlls = {
      registrationNo: {
        id: "registrationNo",
        name: 'registrationNo',
        label: "Registration No",
        required: true,
        type: "text"
      },
      document: {
        id: "document",
        name: 'document',
        label: "Document",
        placeholder: "Document",
        required: true,
        type: "text"
      }
    };
  }
  onNoClick() {
    this.dialogRef.close();
  }
  delete() {
    const dialogRef = this.dialog.open(app_components_controllers_confirmation_dialog_confirmation_dialog_component__WEBPACK_IMPORTED_MODULE_0__.ConfirmationDialogComponent, {
      width: '400px',
      data: {
        message: 'Are you sure you want to Delete?'
      }
    });
    dialogRef.afterClosed().subscribe(result => {
      if (result) {
        this.loader.showLoader();
        this.petService.deletePetDoc(sessionStorage.getItem('petParentId'), this.kciData['id']).subscribe(res => {
          this.petService.petDocsTemplateData[9]['icon'] = './assets/icons/grey-pet-history/KCI.svg';
          console.log(res);
          this.createForm();
          this.loader.hideLoader();
          this.dialogRef.close();
        }, error => {
          this.loader.hideLoader();
          this.dialogRef.close();
        });
      } else {
        console.log("");
      }
    });
  }
  static #_ = this.ɵfac = function KciCertificateComponent_Factory(t) {
    return new (t || KciCertificateComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](_angular_forms__WEBPACK_IMPORTED_MODULE_6__.FormBuilder), _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](app_services_pet_service__WEBPACK_IMPORTED_MODULE_1__.PetService), _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](_angular_material_dialog__WEBPACK_IMPORTED_MODULE_7__.MatDialogRef), _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](_angular_material_dialog__WEBPACK_IMPORTED_MODULE_7__.MatDialog), _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](app_services_loader_service__WEBPACK_IMPORTED_MODULE_2__.LoaderService));
  };
  static #_2 = this.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdefineComponent"]({
    type: KciCertificateComponent,
    selectors: [["app-kci-certificate"]],
    inputs: {
      petId: "petId",
      petParentId: "petParentId"
    },
    decls: 13,
    vars: 5,
    consts: [[1, "header"], ["mat-dialog-title", "", 2, "align-items", "center"], ["mat-mini-fab", "", "color", "warn", 3, "click", 4, "ngIf"], ["mat-dialog-content", ""], [1, "row"], [2, "width", "100%", 3, "form", "controller"], [3, "form", "onSelect"], [1, "btn-wrapper"], ["mat-stroked-button", "", "color", "primary", 3, "click"], ["mat-stroked-button", "", "color", "primary", 3, "disabled", "click"], ["mat-mini-fab", "", "color", "warn", 3, "click"]],
    template: function KciCertificateComponent_Template(rf, ctx) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "div", 0)(1, "h1", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](2, "KCI Certificate");
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](3, KciCertificateComponent_button_3_Template, 3, 0, "button", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](4, "div", 3)(5, "div", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelement"](6, "app-input", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](7, "app-upload-document", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵlistener"]("onSelect", function KciCertificateComponent_Template_app_upload_document_onSelect_7_listener($event) {
          return ctx.onUpload($event);
        });
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](8, "div", 7)(9, "button", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵlistener"]("click", function KciCertificateComponent_Template_button_click_9_listener() {
          return ctx.onNoClick();
        });
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](10, "Cancel");
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](11, "button", 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵlistener"]("click", function KciCertificateComponent_Template_button_click_11_listener() {
          return ctx.add();
        });
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](12, "Save");
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]()()();
      }
      if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("ngIf", ctx.kciData);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("form", ctx.form)("controller", ctx.controlls["registrationNo"]);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("form", ctx.form);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("disabled", ctx.form.invalid);
      }
    },
    dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_8__.NgIf, _components_controllers_input_input_component__WEBPACK_IMPORTED_MODULE_3__.InputComponent, _components_controllers_upload_document_upload_document_component__WEBPACK_IMPORTED_MODULE_4__.UploadDocumentComponent, _angular_material_button__WEBPACK_IMPORTED_MODULE_9__.MatButton, _angular_material_button__WEBPACK_IMPORTED_MODULE_9__.MatMiniFabButton, _angular_material_icon__WEBPACK_IMPORTED_MODULE_10__.MatIcon],
    styles: [".btn-wrapper[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: row;\n  justify-content: right;\n}\n.btn-wrapper[_ngcontent-%COMP%]   button[_ngcontent-%COMP%] {\n  margin: 10px;\n}\n\n.container[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: column;\n  justify-content: space-between;\n  width: 100%;\n  height: 100%;\n}\n.container[_ngcontent-%COMP%]   .row[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: row;\n  width: 100%;\n  height: 25%;\n  padding: 1% 0;\n  padding-left: 4%;\n}\n\n.header[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: row;\n  justify-content: space-between;\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImtjaS1jZXJ0aWZpY2F0ZS5jb21wb25lbnQuc2NzcyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTtFQUNJLGFBQUE7RUFDQSxtQkFBQTtFQUNBLHNCQUFBO0FBQ0o7QUFBSTtFQUNJLFlBQUE7QUFFUjs7QUFDQTtFQUNJLGFBQUE7RUFDQSxzQkFBQTtFQUNBLDhCQUFBO0VBQ0EsV0FBQTtFQUNBLFlBQUE7QUFFSjtBQURJO0VBQ0ksYUFBQTtFQUNBLG1CQUFBO0VBQ0EsV0FBQTtFQUNBLFdBQUE7RUFDQSxhQUFBO0VBQ0EsZ0JBQUE7QUFHUjs7QUFDQTtFQUNJLGFBQUE7RUFDQSxtQkFBQTtFQUNBLDhCQUFBO0FBRUoiLCJmaWxlIjoia2NpLWNlcnRpZmljYXRlLmNvbXBvbmVudC5zY3NzIiwic291cmNlc0NvbnRlbnQiOlsiLmJ0bi13cmFwcGVye1xuICAgIGRpc3BsYXk6IGZsZXg7XG4gICAgZmxleC1kaXJlY3Rpb246IHJvdztcbiAgICBqdXN0aWZ5LWNvbnRlbnQ6IHJpZ2h0O1xuICAgIGJ1dHRvbntcbiAgICAgICAgbWFyZ2luOiAxMHB4O1xuICAgIH1cbn0gXG4uY29udGFpbmVye1xuICAgIGRpc3BsYXk6IGZsZXg7XG4gICAgZmxleC1kaXJlY3Rpb246IGNvbHVtbjtcbiAgICBqdXN0aWZ5LWNvbnRlbnQ6IHNwYWNlLWJldHdlZW47XG4gICAgd2lkdGg6IDEwMCU7XG4gICAgaGVpZ2h0OiAxMDAlO1xuICAgIC5yb3d7XG4gICAgICAgIGRpc3BsYXk6IGZsZXg7XG4gICAgICAgIGZsZXgtZGlyZWN0aW9uOiByb3c7XG4gICAgICAgIHdpZHRoOiAxMDAlO1xuICAgICAgICBoZWlnaHQ6IDI1JTtcbiAgICAgICAgcGFkZGluZzogMSUgMDtcbiAgICAgICAgcGFkZGluZy1sZWZ0OiA0JTtcbiAgICB9XG59XG5cbi5oZWFkZXJ7XG4gICAgZGlzcGxheTogZmxleDtcbiAgICBmbGV4LWRpcmVjdGlvbjogcm93O1xuICAgIGp1c3RpZnktY29udGVudDogc3BhY2UtYmV0d2Vlbjtcbn0iXX0= */\n/*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8uL3NyYy9hcHAvbW9kdWxlcy91c2VyLW1hbmFlbWVudC9kb2NzL2tjaS1jZXJ0aWZpY2F0ZS9rY2ktY2VydGlmaWNhdGUuY29tcG9uZW50LnNjc3MiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7RUFDSSxhQUFBO0VBQ0EsbUJBQUE7RUFDQSxzQkFBQTtBQUNKO0FBQUk7RUFDSSxZQUFBO0FBRVI7O0FBQ0E7RUFDSSxhQUFBO0VBQ0Esc0JBQUE7RUFDQSw4QkFBQTtFQUNBLFdBQUE7RUFDQSxZQUFBO0FBRUo7QUFESTtFQUNJLGFBQUE7RUFDQSxtQkFBQTtFQUNBLFdBQUE7RUFDQSxXQUFBO0VBQ0EsYUFBQTtFQUNBLGdCQUFBO0FBR1I7O0FBQ0E7RUFDSSxhQUFBO0VBQ0EsbUJBQUE7RUFDQSw4QkFBQTtBQUVKO0FBQ0Esb3dDQUFvd0MiLCJzb3VyY2VzQ29udGVudCI6WyIuYnRuLXdyYXBwZXJ7XG4gICAgZGlzcGxheTogZmxleDtcbiAgICBmbGV4LWRpcmVjdGlvbjogcm93O1xuICAgIGp1c3RpZnktY29udGVudDogcmlnaHQ7XG4gICAgYnV0dG9ue1xuICAgICAgICBtYXJnaW46IDEwcHg7XG4gICAgfVxufSBcbi5jb250YWluZXJ7XG4gICAgZGlzcGxheTogZmxleDtcbiAgICBmbGV4LWRpcmVjdGlvbjogY29sdW1uO1xuICAgIGp1c3RpZnktY29udGVudDogc3BhY2UtYmV0d2VlbjtcbiAgICB3aWR0aDogMTAwJTtcbiAgICBoZWlnaHQ6IDEwMCU7XG4gICAgLnJvd3tcbiAgICAgICAgZGlzcGxheTogZmxleDtcbiAgICAgICAgZmxleC1kaXJlY3Rpb246IHJvdztcbiAgICAgICAgd2lkdGg6IDEwMCU7XG4gICAgICAgIGhlaWdodDogMjUlO1xuICAgICAgICBwYWRkaW5nOiAxJSAwO1xuICAgICAgICBwYWRkaW5nLWxlZnQ6IDQlO1xuICAgIH1cbn1cblxuLmhlYWRlcntcbiAgICBkaXNwbGF5OiBmbGV4O1xuICAgIGZsZXgtZGlyZWN0aW9uOiByb3c7XG4gICAganVzdGlmeS1jb250ZW50OiBzcGFjZS1iZXR3ZWVuO1xufSJdLCJzb3VyY2VSb290IjoiIn0= */"]
  });
}


/***/ }),

/***/ 79546:
/*!************************************************************************************!*\
  !*** ./src/app/modules/user-manaement/docs/microchip-id/microchip-id.component.ts ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "MicrochipIdComponent": () => (/* binding */ MicrochipIdComponent)
/* harmony export */ });
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/core */ 86839);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/forms */ 69542);
/* harmony import */ var app_components_controllers_confirmation_dialog_confirmation_dialog_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! app/components/controllers/confirmation-dialog/confirmation-dialog.component */ 81500);
/* harmony import */ var app_services_pet_service__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! app/services/pet.service */ 59976);
/* harmony import */ var _angular_material_dialog__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/material/dialog */ 67486);
/* harmony import */ var app_services_loader_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! app/services/loader.service */ 38555);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @angular/common */ 86477);
/* harmony import */ var _components_controllers_input_input_component__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../../components/controllers/input/input.component */ 30867);
/* harmony import */ var _components_controllers_upload_document_upload_document_component__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../../components/controllers/upload-document/upload-document.component */ 15698);
/* harmony import */ var _angular_material_button__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @angular/material/button */ 83677);
/* harmony import */ var _angular_material_icon__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @angular/material/icon */ 69941);













function MicrochipIdComponent_button_3_Template(rf, ctx) {
  if (rf & 1) {
    const _r2 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "button", 10);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵlistener"]("click", function MicrochipIdComponent_button_3_Template_button_click_0_listener() {
      _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵrestoreView"](_r2);
      const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵresetView"](ctx_r1.delete());
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](1, "mat-icon");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](2, "delete");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]()();
  }
}
class MicrochipIdComponent {
  constructor(fb, petService, dialogRef, dialog, loader) {
    this.fb = fb;
    this.petService = petService;
    this.dialogRef = dialogRef;
    this.dialog = dialog;
    this.loader = loader;
    this.deleteDoc = new _angular_core__WEBPACK_IMPORTED_MODULE_5__.EventEmitter();
    this.createForm();
    this.createControlls();
    this.get();
  }
  onUpload(event) {
    console.log(event);
    this.form.get('document').setValue(event);
  }
  get() {
    let data = {
      petId: sessionStorage.getItem('petId'),
      type: 'MicrochipID',
      userId: sessionStorage.getItem('petParentId')
    };
    this.petService.getPetDoc(data).subscribe(res => {
      console.log(res);
      if (res.length > 0) {
        this.microChipData = res[0];
        // let formDta = new FormData();
        // formDta.append('files', this.microChipData['docPath']);
        this.form.get('microChipId').setValue(this.microChipData['docNumber']);
        if (this.microChipData['docPath']) {
          this.form.get('document').setValue(this.microChipData['docPath']);
        }
      }
    });
  }
  createForm() {
    this.form = this.fb.group({
      microChipId: ['', [_angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.required]],
      // idNumber : ['',[Validators.required]],
      document: ['']
    });
  }
  filename(event) {
    this.fileName = event;
  }
  createControlls() {
    this.controlls = {
      microChipId: {
        id: "microChipId",
        name: 'microChipId',
        label: "MicroChip Id",
        placeholder: "Enter MicroChip Id",
        required: true,
        type: "text"
      },
      document: {
        id: "document",
        name: 'document',
        label: "Document",
        placeholder: "Document",
        required: true,
        type: "text"
      }
    };
  }
  add() {
    // this.petParentId = sessionStorage.getItem('petParentId');
    // this.petId = sessionStorage.getItem('petId')
    let json = this.form.value;
    console.log(json);
    // sessionStorage.getItem('petParentId');
    // sessionStorage.getItem('petId')
    let data = {
      petId: sessionStorage.getItem('petId'),
      type: 'MicrochipID',
      docNumber: json['microChipId'],
      userId: sessionStorage.getItem('petParentId'),
      docName: 0,
      validTill: 0,
      document: json['document']
    };
    // PetService
    if (this.microChipData) {
      data['docId'] = this.microChipData['id'];
      if (json['document']) {
        data['fileDelete'] = false;
      } else {
        data['fileDelete'] = true;
      }
      this.loader.showLoader();
      this.petService.editPetDoc(data).subscribe(res => {
        console.log(res);
        this.dialogRef.close();
        this.loader.hideLoader();
      });
    } else {
      this.loader.showLoader();
      this.petService.addPetDoc(data).subscribe(res => {
        this.petService.petDocsTemplateData[0]['icon'] = './assets/icons/pet-history/Microchip.svg';
        this.loader.hideLoader();
        this.dialogRef.close();
        console.log(res);
      });
    }
  }
  onNoClick() {
    this.dialogRef.close();
  }
  delete() {
    const dialogRef = this.dialog.open(app_components_controllers_confirmation_dialog_confirmation_dialog_component__WEBPACK_IMPORTED_MODULE_0__.ConfirmationDialogComponent, {
      width: '400px',
      data: {
        message: 'Are you sure you want to Delete?'
      }
    });
    dialogRef.afterClosed().subscribe(result => {
      if (result) {
        this.loader.showLoader();
        this.petService.deletePetDoc(sessionStorage.getItem('petParentId'), this.microChipData['id']).subscribe(res => {
          console.log(res);
          this.petService.petDocsTemplateData[0]['icon'] = './assets/icons/grey-pet-history/Microchip.svg';
          // this.createForm();
          this.get();
          this.loader.hideLoader();
          this.dialogRef.close();
        }, error => {
          console.log(error);
          this.dialogRef.close();
          this.loader.hideLoader();
        });
      } else {
        console.log("");
      }
    });
  }
  static #_ = this.ɵfac = function MicrochipIdComponent_Factory(t) {
    return new (t || MicrochipIdComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](_angular_forms__WEBPACK_IMPORTED_MODULE_6__.FormBuilder), _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](app_services_pet_service__WEBPACK_IMPORTED_MODULE_1__.PetService), _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](_angular_material_dialog__WEBPACK_IMPORTED_MODULE_7__.MatDialogRef), _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](_angular_material_dialog__WEBPACK_IMPORTED_MODULE_7__.MatDialog), _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](app_services_loader_service__WEBPACK_IMPORTED_MODULE_2__.LoaderService));
  };
  static #_2 = this.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdefineComponent"]({
    type: MicrochipIdComponent,
    selectors: [["app-microchip-id"]],
    inputs: {
      petId: "petId",
      petParentId: "petParentId"
    },
    outputs: {
      deleteDoc: "deleteDoc"
    },
    decls: 14,
    vars: 5,
    consts: [[1, "header"], ["mat-dialog-title", "", 2, "align-items", "center"], ["mat-mini-fab", "", "color", "warn", 3, "click", 4, "ngIf"], ["mat-dialog-content", ""], [1, "row"], [2, "width", "100%", 3, "form", "controller"], [2, "padding-top", "2%", 3, "form", "onSelect", "fileName"], [1, "btn-wrapper"], ["mat-stroked-button", "", "color", "primary", 3, "click"], ["mat-stroked-button", "", "color", "primary", 3, "disabled", "click"], ["mat-mini-fab", "", "color", "warn", 3, "click"]],
    template: function MicrochipIdComponent_Template(rf, ctx) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "div", 0)(1, "h1", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](2, "MicrochipID");
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](3, MicrochipIdComponent_button_3_Template, 3, 0, "button", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](4, "div", 3)(5, "div", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelement"](6, "app-input", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](7, "div", 4)(8, "app-upload-document", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵlistener"]("onSelect", function MicrochipIdComponent_Template_app_upload_document_onSelect_8_listener($event) {
          return ctx.onUpload($event);
        })("fileName", function MicrochipIdComponent_Template_app_upload_document_fileName_8_listener($event) {
          return ctx.filename($event);
        });
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]()();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](9, "div", 7)(10, "button", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵlistener"]("click", function MicrochipIdComponent_Template_button_click_10_listener() {
          return ctx.onNoClick();
        });
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](11, "Cancel");
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](12, "button", 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵlistener"]("click", function MicrochipIdComponent_Template_button_click_12_listener() {
          return ctx.add();
        });
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](13, "Save");
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]()()();
      }
      if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("ngIf", ctx.microChipData);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("form", ctx.form)("controller", ctx.controlls["microChipId"]);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("form", ctx.form);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("disabled", ctx.form.invalid);
      }
    },
    dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_8__.NgIf, _components_controllers_input_input_component__WEBPACK_IMPORTED_MODULE_3__.InputComponent, _components_controllers_upload_document_upload_document_component__WEBPACK_IMPORTED_MODULE_4__.UploadDocumentComponent, _angular_material_button__WEBPACK_IMPORTED_MODULE_9__.MatButton, _angular_material_button__WEBPACK_IMPORTED_MODULE_9__.MatMiniFabButton, _angular_material_icon__WEBPACK_IMPORTED_MODULE_10__.MatIcon],
    styles: [".btn-wrapper[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: row;\n  justify-content: right;\n}\n.btn-wrapper[_ngcontent-%COMP%]   button[_ngcontent-%COMP%] {\n  margin: 10px;\n}\n\n.container[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: column;\n  justify-content: space-between;\n  width: 100%;\n  height: 100%;\n}\n.container[_ngcontent-%COMP%]   .row[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: row;\n  width: 100%;\n  height: 25%;\n  padding: 1% 0;\n  padding-left: 4%;\n}\n\n.header[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: row;\n  justify-content: space-between;\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIm1pY3JvY2hpcC1pZC5jb21wb25lbnQuc2NzcyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTtFQUNJLGFBQUE7RUFDQSxtQkFBQTtFQUNBLHNCQUFBO0FBQ0o7QUFBSTtFQUNJLFlBQUE7QUFFUjs7QUFDQTtFQUNJLGFBQUE7RUFDQSxzQkFBQTtFQUNBLDhCQUFBO0VBQ0EsV0FBQTtFQUNBLFlBQUE7QUFFSjtBQURJO0VBQ0ksYUFBQTtFQUNBLG1CQUFBO0VBQ0EsV0FBQTtFQUNBLFdBQUE7RUFDQSxhQUFBO0VBQ0EsZ0JBQUE7QUFHUjs7QUFDQTtFQUNJLGFBQUE7RUFDQSxtQkFBQTtFQUNBLDhCQUFBO0FBRUoiLCJmaWxlIjoibWljcm9jaGlwLWlkLmNvbXBvbmVudC5zY3NzIiwic291cmNlc0NvbnRlbnQiOlsiLmJ0bi13cmFwcGVye1xuICAgIGRpc3BsYXk6IGZsZXg7XG4gICAgZmxleC1kaXJlY3Rpb246IHJvdztcbiAgICBqdXN0aWZ5LWNvbnRlbnQ6IHJpZ2h0O1xuICAgIGJ1dHRvbntcbiAgICAgICAgbWFyZ2luOiAxMHB4O1xuICAgIH1cbn0gXG4uY29udGFpbmVye1xuICAgIGRpc3BsYXk6IGZsZXg7XG4gICAgZmxleC1kaXJlY3Rpb246IGNvbHVtbjtcbiAgICBqdXN0aWZ5LWNvbnRlbnQ6IHNwYWNlLWJldHdlZW47XG4gICAgd2lkdGg6IDEwMCU7XG4gICAgaGVpZ2h0OiAxMDAlO1xuICAgIC5yb3d7XG4gICAgICAgIGRpc3BsYXk6IGZsZXg7XG4gICAgICAgIGZsZXgtZGlyZWN0aW9uOiByb3c7XG4gICAgICAgIHdpZHRoOiAxMDAlO1xuICAgICAgICBoZWlnaHQ6IDI1JTtcbiAgICAgICAgcGFkZGluZzogMSUgMDtcbiAgICAgICAgcGFkZGluZy1sZWZ0OiA0JTtcbiAgICB9XG59XG5cbi5oZWFkZXJ7XG4gICAgZGlzcGxheTogZmxleDtcbiAgICBmbGV4LWRpcmVjdGlvbjogcm93O1xuICAgIGp1c3RpZnktY29udGVudDogc3BhY2UtYmV0d2Vlbjtcbn0iXX0= */\n/*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8uL3NyYy9hcHAvbW9kdWxlcy91c2VyLW1hbmFlbWVudC9kb2NzL21pY3JvY2hpcC1pZC9taWNyb2NoaXAtaWQuY29tcG9uZW50LnNjc3MiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7RUFDSSxhQUFBO0VBQ0EsbUJBQUE7RUFDQSxzQkFBQTtBQUNKO0FBQUk7RUFDSSxZQUFBO0FBRVI7O0FBQ0E7RUFDSSxhQUFBO0VBQ0Esc0JBQUE7RUFDQSw4QkFBQTtFQUNBLFdBQUE7RUFDQSxZQUFBO0FBRUo7QUFESTtFQUNJLGFBQUE7RUFDQSxtQkFBQTtFQUNBLFdBQUE7RUFDQSxXQUFBO0VBQ0EsYUFBQTtFQUNBLGdCQUFBO0FBR1I7O0FBQ0E7RUFDSSxhQUFBO0VBQ0EsbUJBQUE7RUFDQSw4QkFBQTtBQUVKO0FBQ0EsNHZDQUE0dkMiLCJzb3VyY2VzQ29udGVudCI6WyIuYnRuLXdyYXBwZXJ7XG4gICAgZGlzcGxheTogZmxleDtcbiAgICBmbGV4LWRpcmVjdGlvbjogcm93O1xuICAgIGp1c3RpZnktY29udGVudDogcmlnaHQ7XG4gICAgYnV0dG9ue1xuICAgICAgICBtYXJnaW46IDEwcHg7XG4gICAgfVxufSBcbi5jb250YWluZXJ7XG4gICAgZGlzcGxheTogZmxleDtcbiAgICBmbGV4LWRpcmVjdGlvbjogY29sdW1uO1xuICAgIGp1c3RpZnktY29udGVudDogc3BhY2UtYmV0d2VlbjtcbiAgICB3aWR0aDogMTAwJTtcbiAgICBoZWlnaHQ6IDEwMCU7XG4gICAgLnJvd3tcbiAgICAgICAgZGlzcGxheTogZmxleDtcbiAgICAgICAgZmxleC1kaXJlY3Rpb246IHJvdztcbiAgICAgICAgd2lkdGg6IDEwMCU7XG4gICAgICAgIGhlaWdodDogMjUlO1xuICAgICAgICBwYWRkaW5nOiAxJSAwO1xuICAgICAgICBwYWRkaW5nLWxlZnQ6IDQlO1xuICAgIH1cbn1cblxuLmhlYWRlcntcbiAgICBkaXNwbGF5OiBmbGV4O1xuICAgIGZsZXgtZGlyZWN0aW9uOiByb3c7XG4gICAganVzdGlmeS1jb250ZW50OiBzcGFjZS1iZXR3ZWVuO1xufSJdLCJzb3VyY2VSb290IjoiIn0= */"]
  });
}


/***/ }),

/***/ 42752:
/*!**************************************************************************************!*\
  !*** ./src/app/modules/user-manaement/docs/neuter-record/neuter-record.component.ts ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "NeuterRecordComponent": () => (/* binding */ NeuterRecordComponent)
/* harmony export */ });
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/forms */ 69542);
/* harmony import */ var app_components_controllers_confirmation_dialog_confirmation_dialog_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! app/components/controllers/confirmation-dialog/confirmation-dialog.component */ 81500);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/core */ 86839);
/* harmony import */ var app_services_pet_service__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! app/services/pet.service */ 59976);
/* harmony import */ var _angular_material_dialog__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/material/dialog */ 67486);
/* harmony import */ var app_services_loader_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! app/services/loader.service */ 38555);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @angular/common */ 86477);
/* harmony import */ var _components_controllers_input_input_component__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../../components/controllers/input/input.component */ 30867);
/* harmony import */ var _components_controllers_upload_document_upload_document_component__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../../components/controllers/upload-document/upload-document.component */ 15698);
/* harmony import */ var _angular_material_button__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @angular/material/button */ 83677);
/* harmony import */ var _angular_material_icon__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @angular/material/icon */ 69941);












function NeuterRecordComponent_button_3_Template(rf, ctx) {
  if (rf & 1) {
    const _r2 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "button", 10);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵlistener"]("click", function NeuterRecordComponent_button_3_Template_button_click_0_listener() {
      _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵrestoreView"](_r2);
      const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵresetView"](ctx_r1.delete());
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](1, "mat-icon");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](2, "delete");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]()();
  }
}
class NeuterRecordComponent {
  constructor(fb, petService, dialogRef, dialog, loader) {
    this.fb = fb;
    this.petService = petService;
    this.dialogRef = dialogRef;
    this.dialog = dialog;
    this.loader = loader;
    this.createForm();
    this.createControlls();
    this.get();
  }
  onUpload(event) {
    this.form.get('document').setValue(event);
  }
  get() {
    let data = {
      petId: sessionStorage.getItem('petId'),
      type: 'NeuterRecord',
      userId: sessionStorage.getItem('petParentId')
    };
    this.petService.getPetDoc(data).subscribe(res => {
      if (res.length > 0) {
        this.neutarData = res[0];
        // let formDta = new FormData();
        // formDta.append('files', this.microChipData['docPath']);
        this.form.get('documentName').setValue(this.neutarData['docName']);
        if (this.neutarData['docPath']) {
          this.form.get('document').setValue(this.neutarData['docPath']);
        }
      }
    });
  }
  createForm() {
    this.form = this.fb.group({
      documentName: ['', [_angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.required]],
      // idNumber : ['',[Validators.required]],
      document: ['']
    });
  }
  createControlls() {
    this.controlls = {
      documentName: {
        id: "documentName",
        name: 'documentName',
        label: "Document Name",
        required: true,
        type: "text"
      },
      document: {
        id: "document",
        name: 'document',
        label: "Document",
        placeholder: "Document",
        required: true,
        type: "text"
      }
    };
  }
  filename(event) {
    this.fileName = event;
  }
  add() {
    // this.petParentId = sessionStorage.getItem('petParentId');
    // this.petId = sessionStorage.getItem('petId')
    let json = this.form.value;
    console.log(json);
    // sessionStorage.getItem('petParentId');
    // sessionStorage.getItem('petId')
    let data = {
      petId: sessionStorage.getItem('petId'),
      type: 'NeuterRecord',
      docNumber: 0,
      userId: sessionStorage.getItem('petParentId'),
      docName: json['documentName'],
      validTill: 0,
      document: json['document']
    };
    // PetService
    if (this.neutarData) {
      data['docId'] = this.neutarData['id'];
      if (json['document']) {
        data['fileDelete'] = false;
      } else {
        data['fileDelete'] = true;
      }
      this.loader.showLoader();
      this.petService.editPetDoc(data).subscribe(res => {
        console.log(res);
        this.loader.hideLoader();
        this.dialogRef.close();
      });
    } else {
      this.loader.showLoader();
      this.petService.addPetDoc(data).subscribe(res => {
        this.petService.petDocsTemplateData[3]['icon'] = './assets/icons/pet-history/Neuter.svg';
        console.log(res);
        this.loader.hideLoader();
        this.dialogRef.close();
      });
    }
  }
  onNoClick() {
    this.dialogRef.close();
  }
  delete() {
    const dialogRef = this.dialog.open(app_components_controllers_confirmation_dialog_confirmation_dialog_component__WEBPACK_IMPORTED_MODULE_0__.ConfirmationDialogComponent, {
      width: '400px',
      data: {
        message: 'Are you sure you want to Delete?'
      }
    });
    dialogRef.afterClosed().subscribe(result => {
      if (result) {
        this.loader.showLoader();
        this.petService.deletePetDoc(sessionStorage.getItem('petParentId'), this.neutarData['id']).subscribe(res => {
          this.petService.petDocsTemplateData[3]['icon'] = './assets/icons/grey-pet-history/Neuter.svg';
          console.log(res);
          this.createForm();
          this.loader.hideLoader();
          this.dialogRef.close();
        }, error => {
          this.loader.hideLoader();
          this.dialogRef.close();
        });
      } else {
        console.log("");
      }
    });
  }
  static #_ = this.ɵfac = function NeuterRecordComponent_Factory(t) {
    return new (t || NeuterRecordComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](_angular_forms__WEBPACK_IMPORTED_MODULE_6__.FormBuilder), _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](app_services_pet_service__WEBPACK_IMPORTED_MODULE_1__.PetService), _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](_angular_material_dialog__WEBPACK_IMPORTED_MODULE_7__.MatDialogRef), _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](_angular_material_dialog__WEBPACK_IMPORTED_MODULE_7__.MatDialog), _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](app_services_loader_service__WEBPACK_IMPORTED_MODULE_2__.LoaderService));
  };
  static #_2 = this.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdefineComponent"]({
    type: NeuterRecordComponent,
    selectors: [["app-neuter-record"]],
    inputs: {
      petId: "petId",
      petParentId: "petParentId"
    },
    decls: 13,
    vars: 5,
    consts: [[1, "header"], ["mat-dialog-title", "", 2, "align-items", "center"], ["mat-mini-fab", "", "color", "warn", 3, "click", 4, "ngIf"], ["mat-dialog-content", ""], [1, "row"], [2, "width", "100%", 3, "form", "controller"], [3, "form", "onSelect"], [1, "btn-wrapper"], ["mat-stroked-button", "", "color", "primary", 3, "click"], ["mat-stroked-button", "", "color", "primary", 3, "disabled", "click"], ["mat-mini-fab", "", "color", "warn", 3, "click"]],
    template: function NeuterRecordComponent_Template(rf, ctx) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "div", 0)(1, "h1", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](2, "Neuter Record");
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](3, NeuterRecordComponent_button_3_Template, 3, 0, "button", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](4, "div", 3)(5, "div", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelement"](6, "app-input", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](7, "app-upload-document", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵlistener"]("onSelect", function NeuterRecordComponent_Template_app_upload_document_onSelect_7_listener($event) {
          return ctx.onUpload($event);
        });
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](8, "div", 7)(9, "button", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵlistener"]("click", function NeuterRecordComponent_Template_button_click_9_listener() {
          return ctx.onNoClick();
        });
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](10, "Cancel");
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](11, "button", 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵlistener"]("click", function NeuterRecordComponent_Template_button_click_11_listener() {
          return ctx.add();
        });
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](12, "Save");
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]()()();
      }
      if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("ngIf", ctx.neutarData);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("form", ctx.form)("controller", ctx.controlls["documentName"]);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("form", ctx.form);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("disabled", ctx.form.invalid);
      }
    },
    dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_8__.NgIf, _components_controllers_input_input_component__WEBPACK_IMPORTED_MODULE_3__.InputComponent, _components_controllers_upload_document_upload_document_component__WEBPACK_IMPORTED_MODULE_4__.UploadDocumentComponent, _angular_material_button__WEBPACK_IMPORTED_MODULE_9__.MatButton, _angular_material_button__WEBPACK_IMPORTED_MODULE_9__.MatMiniFabButton, _angular_material_icon__WEBPACK_IMPORTED_MODULE_10__.MatIcon],
    styles: [".btn-wrapper[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: row;\n  justify-content: right;\n}\n.btn-wrapper[_ngcontent-%COMP%]   button[_ngcontent-%COMP%] {\n  margin: 10px;\n}\n\n.container[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: column;\n  justify-content: space-between;\n  width: 100%;\n  height: 100%;\n}\n.container[_ngcontent-%COMP%]   .row[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: row;\n  width: 100%;\n  height: 25%;\n  padding: 1% 0;\n  padding-left: 4%;\n}\n\n.header[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: row;\n  justify-content: space-between;\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIm5ldXRlci1yZWNvcmQuY29tcG9uZW50LnNjc3MiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7RUFDSSxhQUFBO0VBQ0EsbUJBQUE7RUFDQSxzQkFBQTtBQUNKO0FBQUk7RUFDSSxZQUFBO0FBRVI7O0FBQ0E7RUFDSSxhQUFBO0VBQ0Esc0JBQUE7RUFDQSw4QkFBQTtFQUNBLFdBQUE7RUFDQSxZQUFBO0FBRUo7QUFESTtFQUNJLGFBQUE7RUFDQSxtQkFBQTtFQUNBLFdBQUE7RUFDQSxXQUFBO0VBQ0EsYUFBQTtFQUNBLGdCQUFBO0FBR1I7O0FBQ0E7RUFDSSxhQUFBO0VBQ0EsbUJBQUE7RUFDQSw4QkFBQTtBQUVKIiwiZmlsZSI6Im5ldXRlci1yZWNvcmQuY29tcG9uZW50LnNjc3MiLCJzb3VyY2VzQ29udGVudCI6WyIuYnRuLXdyYXBwZXJ7XG4gICAgZGlzcGxheTogZmxleDtcbiAgICBmbGV4LWRpcmVjdGlvbjogcm93O1xuICAgIGp1c3RpZnktY29udGVudDogcmlnaHQ7XG4gICAgYnV0dG9ue1xuICAgICAgICBtYXJnaW46IDEwcHg7XG4gICAgfVxufSBcbi5jb250YWluZXJ7XG4gICAgZGlzcGxheTogZmxleDtcbiAgICBmbGV4LWRpcmVjdGlvbjogY29sdW1uO1xuICAgIGp1c3RpZnktY29udGVudDogc3BhY2UtYmV0d2VlbjtcbiAgICB3aWR0aDogMTAwJTtcbiAgICBoZWlnaHQ6IDEwMCU7XG4gICAgLnJvd3tcbiAgICAgICAgZGlzcGxheTogZmxleDtcbiAgICAgICAgZmxleC1kaXJlY3Rpb246IHJvdztcbiAgICAgICAgd2lkdGg6IDEwMCU7XG4gICAgICAgIGhlaWdodDogMjUlO1xuICAgICAgICBwYWRkaW5nOiAxJSAwO1xuICAgICAgICBwYWRkaW5nLWxlZnQ6IDQlO1xuICAgIH1cbn1cblxuLmhlYWRlcntcbiAgICBkaXNwbGF5OiBmbGV4O1xuICAgIGZsZXgtZGlyZWN0aW9uOiByb3c7XG4gICAganVzdGlmeS1jb250ZW50OiBzcGFjZS1iZXR3ZWVuO1xufSJdfQ== */\n/*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8uL3NyYy9hcHAvbW9kdWxlcy91c2VyLW1hbmFlbWVudC9kb2NzL25ldXRlci1yZWNvcmQvbmV1dGVyLXJlY29yZC5jb21wb25lbnQuc2NzcyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTtFQUNJLGFBQUE7RUFDQSxtQkFBQTtFQUNBLHNCQUFBO0FBQ0o7QUFBSTtFQUNJLFlBQUE7QUFFUjs7QUFDQTtFQUNJLGFBQUE7RUFDQSxzQkFBQTtFQUNBLDhCQUFBO0VBQ0EsV0FBQTtFQUNBLFlBQUE7QUFFSjtBQURJO0VBQ0ksYUFBQTtFQUNBLG1CQUFBO0VBQ0EsV0FBQTtFQUNBLFdBQUE7RUFDQSxhQUFBO0VBQ0EsZ0JBQUE7QUFHUjs7QUFDQTtFQUNJLGFBQUE7RUFDQSxtQkFBQTtFQUNBLDhCQUFBO0FBRUo7QUFDQSxnd0NBQWd3QyIsInNvdXJjZXNDb250ZW50IjpbIi5idG4td3JhcHBlcntcbiAgICBkaXNwbGF5OiBmbGV4O1xuICAgIGZsZXgtZGlyZWN0aW9uOiByb3c7XG4gICAganVzdGlmeS1jb250ZW50OiByaWdodDtcbiAgICBidXR0b257XG4gICAgICAgIG1hcmdpbjogMTBweDtcbiAgICB9XG59IFxuLmNvbnRhaW5lcntcbiAgICBkaXNwbGF5OiBmbGV4O1xuICAgIGZsZXgtZGlyZWN0aW9uOiBjb2x1bW47XG4gICAganVzdGlmeS1jb250ZW50OiBzcGFjZS1iZXR3ZWVuO1xuICAgIHdpZHRoOiAxMDAlO1xuICAgIGhlaWdodDogMTAwJTtcbiAgICAucm93e1xuICAgICAgICBkaXNwbGF5OiBmbGV4O1xuICAgICAgICBmbGV4LWRpcmVjdGlvbjogcm93O1xuICAgICAgICB3aWR0aDogMTAwJTtcbiAgICAgICAgaGVpZ2h0OiAyNSU7XG4gICAgICAgIHBhZGRpbmc6IDElIDA7XG4gICAgICAgIHBhZGRpbmctbGVmdDogNCU7XG4gICAgfVxufVxuXG4uaGVhZGVye1xuICAgIGRpc3BsYXk6IGZsZXg7XG4gICAgZmxleC1kaXJlY3Rpb246IHJvdztcbiAgICBqdXN0aWZ5LWNvbnRlbnQ6IHNwYWNlLWJldHdlZW47XG59Il0sInNvdXJjZVJvb3QiOiIifQ== */"]
  });
}


/***/ }),

/***/ 84594:
/*!**************************************************************************************************!*\
  !*** ./src/app/modules/user-manaement/docs/other-document-list/other-document-list.component.ts ***!
  \**************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "OtherDocumentListComponent": () => (/* binding */ OtherDocumentListComponent)
/* harmony export */ });
/* harmony import */ var _other_documents_other_documents_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../other-documents/other-documents.component */ 13416);
/* harmony import */ var app_components_controllers_confirmation_dialog_confirmation_dialog_component__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! app/components/controllers/confirmation-dialog/confirmation-dialog.component */ 81500);
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! moment */ 56908);
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(moment__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/forms */ 69542);
/* harmony import */ var _angular_material_dialog__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @angular/material/dialog */ 67486);
/* harmony import */ var _angular_material_paginator__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @angular/material/paginator */ 86907);
/* harmony import */ var _angular_material_sort__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @angular/material/sort */ 95096);
/* harmony import */ var _angular_material_table__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/material/table */ 83348);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/core */ 86839);
/* harmony import */ var app_services_pet_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! app/services/pet.service */ 59976);
/* harmony import */ var app_services_loader_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! app/services/loader.service */ 38555);
/* harmony import */ var _angular_material_button__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @angular/material/button */ 83677);
/* harmony import */ var _angular_material_menu__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @angular/material/menu */ 89314);
/* harmony import */ var _angular_material_icon__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @angular/material/icon */ 69941);


















function OtherDocumentListComponent_th_10_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "th", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](1, " ID. ");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
  }
}
function OtherDocumentListComponent_td_11_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "td", 19);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const element_r12 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtextInterpolate1"](" ", element_r12.id.substring(0, 6), " ");
  }
}
function OtherDocumentListComponent_th_13_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "th", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](1, " Document Name ");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
  }
}
function OtherDocumentListComponent_td_14_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "td", 19);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const element_r13 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtextInterpolate1"](" ", element_r13.docName, " ");
  }
}
function OtherDocumentListComponent_th_16_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "th", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](1, " uploaded On");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
  }
}
function OtherDocumentListComponent_td_17_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "td", 19);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const element_r14 = ctx.$implicit;
    const ctx_r5 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtextInterpolate1"](" ", ctx_r5.currentUTCDate(element_r14.createdAt), " ");
  }
}
function OtherDocumentListComponent_th_19_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "th", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](1, " Valid Till ");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
  }
}
function OtherDocumentListComponent_td_20_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "td", 19);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const element_r15 = ctx.$implicit;
    const ctx_r7 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtextInterpolate1"](" ", element_r15.validTill ? ctx_r7.currentUTCDate(element_r15.validTill) : "", " ");
  }
}
function OtherDocumentListComponent_th_22_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "th", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](1, " Action ");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
  }
}
function OtherDocumentListComponent_td_23_Template(rf, ctx) {
  if (rf & 1) {
    const _r20 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "td", 19)(1, "button", 20);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵlistener"]("click", function OtherDocumentListComponent_td_23_Template_button_click_1_listener() {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵrestoreView"](_r20);
      const i_r17 = restoredCtx.index;
      const element_r16 = restoredCtx.$implicit;
      const ctx_r19 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵresetView"](ctx_r19.toggle(i_r17, element_r16));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](2, "mat-icon");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](3, "more_vert");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]()();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](4, "mat-menu", null, 21)(6, "button", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵlistener"]("click", function OtherDocumentListComponent_td_23_Template_button_click_6_listener() {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵrestoreView"](_r20);
      const element_r16 = restoredCtx.$implicit;
      const i_r17 = restoredCtx.index;
      const ctx_r21 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵresetView"](ctx_r21.edit(element_r16, i_r17));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](7, "span", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](8, "Edit");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](9, "mat-icon", 24);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](10, "edit");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]()();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](11, "button", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵlistener"]("click", function OtherDocumentListComponent_td_23_Template_button_click_11_listener() {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵrestoreView"](_r20);
      const element_r16 = restoredCtx.$implicit;
      const i_r17 = restoredCtx.index;
      const ctx_r22 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵresetView"](ctx_r22.delete(element_r16, i_r17));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](12, "span", 25);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](13, "Delete");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](14, "mat-icon", 26);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](15, "delete");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]()()()();
  }
  if (rf & 2) {
    const _r18 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵreference"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("matMenuTriggerFor", _r18);
  }
}
function OtherDocumentListComponent_tr_24_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelement"](0, "tr", 27);
  }
}
function OtherDocumentListComponent_tr_25_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelement"](0, "tr", 28);
  }
}
const _c0 = function () {
  return [5, 10, 25, 100];
};
class OtherDocumentListComponent {
  constructor(fb, petService, dialogRef, data, dialog, loader) {
    this.fb = fb;
    this.petService = petService;
    this.dialogRef = dialogRef;
    this.data = data;
    this.dialog = dialog;
    this.loader = loader;
    this.displayedColumns = ['id', 'documentName', 'uploadedOn', 'documentValidTill', 'action'];
    this.createForm();
  }
  ngOnInit() {
    this.getInnsuranceList();
  }
  ngAfterViewInit() {
    this.recordData.paginator = this.paginator;
  }
  getInnsuranceList() {
    let data = {
      petId: sessionStorage.getItem('petId'),
      type: 'OtherDocuments',
      userId: sessionStorage.getItem('petParentId')
    };
    this.petService.getPetDoc(data).subscribe(res => {
      if (res.length == 0) {
        this.petService.petDocsTemplateData[10]['icon'] = './assets/icons/grey-pet-history/Others.svg';
      }
      const petParentsArray = Object.values(res);
      this.recordData = new _angular_material_table__WEBPACK_IMPORTED_MODULE_6__.MatTableDataSource(petParentsArray.map(item => ({
        ...item
      })));
      this.recordData.paginator = this.paginator;
      this.recordData.sort = this.sort;
    });
  }
  toggle(i, record) {}
  createForm() {
    this.form = this.fb.group({
      documentName: ['', [_angular_forms__WEBPACK_IMPORTED_MODULE_7__.Validators.required]],
      documentValidTill: [''],
      // idNumber : ['',[Validators.required]],
      document: ['']
    });
  }
  currentUTCDate(date) {
    if (date) {
      return moment__WEBPACK_IMPORTED_MODULE_2___default().utc(date).local().format("DD-MMM-YYYY");
    } else {
      return 0;
    }
  }
  delete(el, i) {
    const dialogRef = this.dialog.open(app_components_controllers_confirmation_dialog_confirmation_dialog_component__WEBPACK_IMPORTED_MODULE_1__.ConfirmationDialogComponent, {
      width: '400px',
      data: {
        message: 'Are you sure you want to Delete?'
      }
    });
    dialogRef.afterClosed().subscribe(result => {
      if (result) {
        this.loader.showLoader();
        this.petService.deletePetDoc(sessionStorage.getItem('petParentId'), el['id']).subscribe(res => {
          console.log(res);
          this.getInnsuranceList();
          this.loader.hideLoader();
        }, error => {
          this.loader.hideLoader();
        });
      } else {
        console.log("");
      }
    });
  }
  edit(el, i) {
    const dialogRef = this.dialog.open(_other_documents_other_documents_component__WEBPACK_IMPORTED_MODULE_0__.OtherDocumentsComponent, {
      data: {
        type: this.data['title'],
        record: el
      }
    });
    dialogRef.afterClosed().subscribe(result => {
      console.log('The dialog was closed');
      console.log(result);
      this.getInnsuranceList();
      // this.getVaccinationRecords()
    });
  }
  addRecord() {
    const dialogRef = this.dialog.open(_other_documents_other_documents_component__WEBPACK_IMPORTED_MODULE_0__.OtherDocumentsComponent, {
      data: {
        type: this.data['title']
      }
    });
    dialogRef.afterClosed().subscribe(result => {
      console.log('The dialog was closed');
      console.log(result);
      this.getInnsuranceList();
    });
  }
  onNoClick() {
    this.dialogRef.close();
  }
  static #_ = this.ɵfac = function OtherDocumentListComponent_Factory(t) {
    return new (t || OtherDocumentListComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](_angular_forms__WEBPACK_IMPORTED_MODULE_7__.FormBuilder), _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](app_services_pet_service__WEBPACK_IMPORTED_MODULE_3__.PetService), _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](_angular_material_dialog__WEBPACK_IMPORTED_MODULE_8__.MatDialogRef), _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](_angular_material_dialog__WEBPACK_IMPORTED_MODULE_8__.MAT_DIALOG_DATA), _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](_angular_material_dialog__WEBPACK_IMPORTED_MODULE_8__.MatDialog), _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](app_services_loader_service__WEBPACK_IMPORTED_MODULE_4__.LoaderService));
  };
  static #_2 = this.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdefineComponent"]({
    type: OtherDocumentListComponent,
    selectors: [["app-other-document-list"]],
    viewQuery: function OtherDocumentListComponent_Query(rf, ctx) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵviewQuery"](_angular_material_paginator__WEBPACK_IMPORTED_MODULE_9__.MatPaginator, 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵviewQuery"](_angular_material_sort__WEBPACK_IMPORTED_MODULE_10__.MatSort, 5);
      }
      if (rf & 2) {
        let _t;
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵloadQuery"]()) && (ctx.paginator = _t.first);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵloadQuery"]()) && (ctx.sort = _t.first);
      }
    },
    decls: 31,
    vars: 7,
    consts: [[1, "header"], ["mat-dialog-title", "", 2, "align-items", "center"], ["mat-mini-fab", "", "color", "warn", 3, "click"], ["mat-dialog-content", "", 1, "record-grid", 2, "min-height", "150px", "height", "400px", "overflow-y", "auto"], [1, "table-wrapper"], ["mat-table", "", 1, "mat-elevation-z8", "mt-2", 3, "dataSource"], ["matColumnDef", "id"], ["mat-header-cell", "", 4, "matHeaderCellDef"], ["mat-cell", "", 4, "matCellDef"], ["matColumnDef", "documentName"], ["matColumnDef", "uploadedOn"], ["matColumnDef", "documentValidTill"], ["matColumnDef", "action"], ["mat-header-row", "", 4, "matHeaderRowDef"], ["mat-row", "", 4, "matRowDef", "matRowDefColumns"], [3, "pageSize", "pageSizeOptions"], [1, "btn"], ["mat-mini-fab", "", "color", "primary", 3, "click"], ["mat-header-cell", ""], ["mat-cell", ""], ["mat-icon-button", "", 3, "matMenuTriggerFor", "click"], ["actionMenu", "matMenu"], ["mat-menu-item", "", 3, "click"], [2, "color", "blue !important"], ["color", "primary"], [2, "color", "hsl(0, 94%, 42%) !important"], ["color", "warn"], ["mat-header-row", ""], ["mat-row", ""]],
    template: function OtherDocumentListComponent_Template(rf, ctx) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "div", 0)(1, "h1", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](3, "button", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵlistener"]("click", function OtherDocumentListComponent_Template_button_click_3_listener() {
          return ctx.onNoClick();
        });
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](4, "mat-icon");
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](5, "close");
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]()()();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](6, "div", 3)(7, "div", 4)(8, "table", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementContainerStart"](9, 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](10, OtherDocumentListComponent_th_10_Template, 2, 0, "th", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](11, OtherDocumentListComponent_td_11_Template, 2, 1, "td", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementContainerStart"](12, 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](13, OtherDocumentListComponent_th_13_Template, 2, 0, "th", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](14, OtherDocumentListComponent_td_14_Template, 2, 1, "td", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementContainerStart"](15, 10);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](16, OtherDocumentListComponent_th_16_Template, 2, 0, "th", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](17, OtherDocumentListComponent_td_17_Template, 2, 1, "td", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementContainerStart"](18, 11);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](19, OtherDocumentListComponent_th_19_Template, 2, 0, "th", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](20, OtherDocumentListComponent_td_20_Template, 2, 1, "td", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementContainerStart"](21, 12);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](22, OtherDocumentListComponent_th_22_Template, 2, 0, "th", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](23, OtherDocumentListComponent_td_23_Template, 16, 1, "td", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](24, OtherDocumentListComponent_tr_24_Template, 1, 0, "tr", 13);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](25, OtherDocumentListComponent_tr_25_Template, 1, 0, "tr", 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelement"](26, "mat-paginator", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]()();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](27, "div", 16)(28, "button", 17);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵlistener"]("click", function OtherDocumentListComponent_Template_button_click_28_listener() {
          return ctx.addRecord();
        });
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](29, "mat-icon");
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](30, "add");
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]()()();
      }
      if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtextInterpolate1"]("", ctx.data["title"], " List");
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](6);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("dataSource", ctx.recordData);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](16);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("matHeaderRowDef", ctx.displayedColumns);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("matRowDefColumns", ctx.displayedColumns);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("pageSize", 10)("pageSizeOptions", _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpureFunction0"](6, _c0));
      }
    },
    dependencies: [_angular_material_table__WEBPACK_IMPORTED_MODULE_6__.MatTable, _angular_material_table__WEBPACK_IMPORTED_MODULE_6__.MatHeaderCellDef, _angular_material_table__WEBPACK_IMPORTED_MODULE_6__.MatHeaderRowDef, _angular_material_table__WEBPACK_IMPORTED_MODULE_6__.MatColumnDef, _angular_material_table__WEBPACK_IMPORTED_MODULE_6__.MatCellDef, _angular_material_table__WEBPACK_IMPORTED_MODULE_6__.MatRowDef, _angular_material_table__WEBPACK_IMPORTED_MODULE_6__.MatHeaderCell, _angular_material_table__WEBPACK_IMPORTED_MODULE_6__.MatCell, _angular_material_table__WEBPACK_IMPORTED_MODULE_6__.MatHeaderRow, _angular_material_table__WEBPACK_IMPORTED_MODULE_6__.MatRow, _angular_material_button__WEBPACK_IMPORTED_MODULE_11__.MatIconButton, _angular_material_button__WEBPACK_IMPORTED_MODULE_11__.MatMiniFabButton, _angular_material_menu__WEBPACK_IMPORTED_MODULE_12__.MatMenu, _angular_material_menu__WEBPACK_IMPORTED_MODULE_12__.MatMenuItem, _angular_material_menu__WEBPACK_IMPORTED_MODULE_12__.MatMenuTrigger, _angular_material_icon__WEBPACK_IMPORTED_MODULE_13__.MatIcon, _angular_material_paginator__WEBPACK_IMPORTED_MODULE_9__.MatPaginator],
    styles: [".btn[_ngcontent-%COMP%] {\n  display: flex;\n  justify-content: end;\n}\n\n.card[_ngcontent-%COMP%] {\n  padding: 2px;\n}\n\nmat-card-content[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: column;\n  justify-content: center;\n}\n\n.record-grid[_ngcontent-%COMP%] {\n  min-height: 80%;\n  max-height: -moz-fit-content;\n  max-height: fit-content;\n}\n\nmat-form-field[_ngcontent-%COMP%] {\n  display: block;\n  margin: 10px 0;\n}\n\n.header[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: row;\n  justify-content: space-between;\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIm90aGVyLWRvY3VtZW50LWxpc3QuY29tcG9uZW50LnNjc3MiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7RUFDSSxhQUFBO0VBQ0Esb0JBQUE7QUFDSjs7QUFFQTtFQUNJLFlBQUE7QUFDSjs7QUFHQTtFQUNJLGFBQUE7RUFDQSxzQkFBQTtFQUNBLHVCQUFBO0FBQUo7O0FBSUE7RUFDSSxlQUFBO0VBQ0EsNEJBQUE7RUFBQSx1QkFBQTtBQURKOztBQUtBO0VBQ0ksY0FBQTtFQUNBLGNBQUE7QUFGSjs7QUFLQTtFQUNJLGFBQUE7RUFDQSxtQkFBQTtFQUNBLDhCQUFBO0FBRkoiLCJmaWxlIjoib3RoZXItZG9jdW1lbnQtbGlzdC5jb21wb25lbnQuc2NzcyIsInNvdXJjZXNDb250ZW50IjpbIi5idG4ge1xuICAgIGRpc3BsYXk6IGZsZXg7XG4gICAganVzdGlmeS1jb250ZW50OiBlbmQ7XG59XG5cbi5jYXJkIHtcbiAgICBwYWRkaW5nOiAycHg7XG4gXG59XG5cbm1hdC1jYXJkLWNvbnRlbnQge1xuICAgIGRpc3BsYXk6IGZsZXg7XG4gICAgZmxleC1kaXJlY3Rpb246IGNvbHVtbjtcbiAgICBqdXN0aWZ5LWNvbnRlbnQ6IGNlbnRlcjtcbiAgICAvLyBhbGlnbi1pdGVtczogY2VudGVyO1xuXG59XG4ucmVjb3JkLWdyaWR7XG4gICAgbWluLWhlaWdodDogODAlO1xuICAgIG1heC1oZWlnaHQ6IGZpdC1jb250ZW50O1xufVxuXG5cbm1hdC1mb3JtLWZpZWxkIHtcbiAgICBkaXNwbGF5OiBibG9jaztcbiAgICBtYXJnaW46IDEwcHggMDtcbn1cblxuLmhlYWRlciB7XG4gICAgZGlzcGxheTogZmxleDtcbiAgICBmbGV4LWRpcmVjdGlvbjogcm93O1xuICAgIGp1c3RpZnktY29udGVudDogc3BhY2UtYmV0d2Vlbjtcbn0iXX0= */\n/*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8uL3NyYy9hcHAvbW9kdWxlcy91c2VyLW1hbmFlbWVudC9kb2NzL290aGVyLWRvY3VtZW50LWxpc3Qvb3RoZXItZG9jdW1lbnQtbGlzdC5jb21wb25lbnQuc2NzcyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTtFQUNJLGFBQUE7RUFDQSxvQkFBQTtBQUNKOztBQUVBO0VBQ0ksWUFBQTtBQUNKOztBQUdBO0VBQ0ksYUFBQTtFQUNBLHNCQUFBO0VBQ0EsdUJBQUE7QUFBSjs7QUFJQTtFQUNJLGVBQUE7RUFDQSw0QkFBQTtFQUFBLHVCQUFBO0FBREo7O0FBS0E7RUFDSSxjQUFBO0VBQ0EsY0FBQTtBQUZKOztBQUtBO0VBQ0ksYUFBQTtFQUNBLG1CQUFBO0VBQ0EsOEJBQUE7QUFGSjtBQUVBLG9vQ0FBb29DIiwic291cmNlc0NvbnRlbnQiOlsiLmJ0biB7XG4gICAgZGlzcGxheTogZmxleDtcbiAgICBqdXN0aWZ5LWNvbnRlbnQ6IGVuZDtcbn1cblxuLmNhcmQge1xuICAgIHBhZGRpbmc6IDJweDtcbiBcbn1cblxubWF0LWNhcmQtY29udGVudCB7XG4gICAgZGlzcGxheTogZmxleDtcbiAgICBmbGV4LWRpcmVjdGlvbjogY29sdW1uO1xuICAgIGp1c3RpZnktY29udGVudDogY2VudGVyO1xuICAgIC8vIGFsaWduLWl0ZW1zOiBjZW50ZXI7XG5cbn1cbi5yZWNvcmQtZ3JpZHtcbiAgICBtaW4taGVpZ2h0OiA4MCU7XG4gICAgbWF4LWhlaWdodDogZml0LWNvbnRlbnQ7XG59XG5cblxubWF0LWZvcm0tZmllbGQge1xuICAgIGRpc3BsYXk6IGJsb2NrO1xuICAgIG1hcmdpbjogMTBweCAwO1xufVxuXG4uaGVhZGVyIHtcbiAgICBkaXNwbGF5OiBmbGV4O1xuICAgIGZsZXgtZGlyZWN0aW9uOiByb3c7XG4gICAganVzdGlmeS1jb250ZW50OiBzcGFjZS1iZXR3ZWVuO1xufSJdLCJzb3VyY2VSb290IjoiIn0= */"]
  });
}


/***/ }),

/***/ 13416:
/*!******************************************************************************************!*\
  !*** ./src/app/modules/user-manaement/docs/other-documents/other-documents.component.ts ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "OtherDocumentsComponent": () => (/* binding */ OtherDocumentsComponent)
/* harmony export */ });
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/forms */ 69542);
/* harmony import */ var _angular_material_dialog__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @angular/material/dialog */ 67486);
/* harmony import */ var app_components_controllers_confirmation_dialog_confirmation_dialog_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! app/components/controllers/confirmation-dialog/confirmation-dialog.component */ 81500);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/core */ 86839);
/* harmony import */ var app_services_pet_service__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! app/services/pet.service */ 59976);
/* harmony import */ var app_services_loader_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! app/services/loader.service */ 38555);
/* harmony import */ var _components_controllers_input_input_component__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../../components/controllers/input/input.component */ 30867);
/* harmony import */ var _components_controllers_date_picker_date_picker_component__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../../components/controllers/date-picker/date-picker.component */ 49582);
/* harmony import */ var _components_controllers_upload_document_upload_document_component__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../../components/controllers/upload-document/upload-document.component */ 15698);
/* harmony import */ var _angular_material_button__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @angular/material/button */ 83677);
/* harmony import */ var _angular_material_icon__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @angular/material/icon */ 69941);













class OtherDocumentsComponent {
  constructor(fb, petService, dialogRef, data, dialog, loader) {
    this.fb = fb;
    this.petService = petService;
    this.dialogRef = dialogRef;
    this.data = data;
    this.dialog = dialog;
    this.loader = loader;
    this.createForm();
    this.createControlls();
    // this.get();
  }
  ngOnInit() {
    if (this.data['record']) {
      this.edit();
    }
  }
  edit() {
    let el = this.data['record'];
    this.form = this.fb.group({
      id: [el['id']],
      uploadedOn: [el['createdAt'] ? new Date(el['createdAt']) : ''],
      documentName: [el['docName'], _angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.required],
      documentValidTill: [el['validTill'] ? new Date(el['validTill']) : ''],
      document: [el['docPath'] ? el['docPath'] : null]
    });
  }
  onUpload(event) {
    this.form.get('document').setValue(event);
  }
  // get() {
  //   let data = {
  //     petId: sessionStorage.getItem('petId'),
  //     type: 'OtherDocuments',
  //     userId: sessionStorage.getItem('petParentId'),
  //   }
  //   this.petService.getPetDoc(data).subscribe((res: Array<any>) => {
  //     if (res.length > 0) {
  //       this.data = res[0];
  //       // let formDta = new FormData();
  //       // formDta.append('files', this.microChipData['docPath']);
  //       console.log(this.data['validTill']);
  //       this.form.get('documentName').setValue(this.data['docName']);
  //       this.form.get('documentValidTill').setValue(this.data['validTill'] ? new Date(this.data['validTill']):'');
  //       if(this.data['docPath']){
  //         this.form.get('document').setValue(this.data['docPath'])
  //       }
  //     }
  //     console.log(this.form);
  //   })
  // }
  add() {
    // this.petParentId = sessionStorage.getItem('petParentId');
    // this.petId = sessionStorage.getItem('petId')
    let json = this.form.value;
    console.log(json);
    // sessionStorage.getItem('petParentId');
    // sessionStorage.getItem('petId')
    let data = {
      petId: sessionStorage.getItem('petId'),
      type: 'OtherDocuments',
      docNumber: 0,
      userId: sessionStorage.getItem('petParentId'),
      docName: json['documentName'],
      validTill: json['documentValidTill'] ? new Date(json['documentValidTill']).getTime() : 0,
      document: json['document']
    };
    // PetService
    if (this.data['record']) {
      data['docId'] = this.data['record']['id'];
      if (json['document']) {
        data['fileDelete'] = false;
      } else {
        data['fileDelete'] = true;
      }
      this.loader.showLoader();
      this.petService.editPetDoc(data).subscribe(res => {
        console.log(res);
        this.loader.hideLoader();
        this.dialogRef.close();
      });
    } else {
      this.loader.showLoader();
      this.petService.addPetDoc(data).subscribe(res => {
        this.petService.petDocsTemplateData[10]['icon'] = './assets/icons/pet-history/Others.svg';
        this.loader.hideLoader();
        this.dialogRef.close();
        console.log(res);
      });
    }
  }
  createForm() {
    this.form = this.fb.group({
      documentName: ['', [_angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.required]],
      documentValidTill: [''],
      // idNumber : ['',[Validators.required]],
      document: ['']
    });
  }
  createControlls() {
    this.controlls = {
      documentName: {
        id: "documentName",
        name: 'documentName',
        label: "Document Name",
        required: true,
        type: "text"
      },
      documentValidTill: {
        id: "documentValidTill",
        name: 'documentValidTill',
        label: "Document Valid Till",
        placeholder: "Document Valid Till",
        required: true,
        type: "text"
      }
    };
  }
  onNoClick() {
    this.dialogRef.close();
  }
  delete() {
    const dialogRef = this.dialog.open(app_components_controllers_confirmation_dialog_confirmation_dialog_component__WEBPACK_IMPORTED_MODULE_0__.ConfirmationDialogComponent, {
      width: '400px',
      data: {
        message: 'Are you sure you want to Delete?'
      }
    });
    dialogRef.afterClosed().subscribe(result => {
      if (result) {
        this.loader.showLoader();
        this.petService.deletePetDoc(sessionStorage.getItem('petParentId'), this.data['id']).subscribe(res => {
          console.log(res);
          this.createForm();
          this.loader.hideLoader();
          this.dialogRef.close();
        }, error => {
          this.loader.hideLoader();
          this.dialogRef.close();
        });
      } else {
        console.log("");
      }
    });
  }
  static #_ = this.ɵfac = function OtherDocumentsComponent_Factory(t) {
    return new (t || OtherDocumentsComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵdirectiveInject"](_angular_forms__WEBPACK_IMPORTED_MODULE_6__.FormBuilder), _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵdirectiveInject"](app_services_pet_service__WEBPACK_IMPORTED_MODULE_1__.PetService), _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵdirectiveInject"](_angular_material_dialog__WEBPACK_IMPORTED_MODULE_8__.MatDialogRef), _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵdirectiveInject"](_angular_material_dialog__WEBPACK_IMPORTED_MODULE_8__.MAT_DIALOG_DATA), _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵdirectiveInject"](_angular_material_dialog__WEBPACK_IMPORTED_MODULE_8__.MatDialog), _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵdirectiveInject"](app_services_loader_service__WEBPACK_IMPORTED_MODULE_2__.LoaderService));
  };
  static #_2 = this.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵdefineComponent"]({
    type: OtherDocumentsComponent,
    selectors: [["app-other-documents"]],
    inputs: {
      petId: "petId",
      petParentId: "petParentId"
    },
    decls: 16,
    vars: 6,
    consts: [[1, "header"], ["mat-dialog-title", "", 2, "align-items", "center"], ["mat-dialog-content", ""], [1, "row"], [2, "width", "100%", 3, "form", "controller"], [1, "row", 2, "height", "20%"], [3, "form", "onSelect"], [1, "btn-wrapper"], ["mat-stroked-button", "", "color", "primary", 3, "click"], ["mat-stroked-button", "", "color", "primary", 3, "disabled", "click"]],
    template: function OtherDocumentsComponent_Template(rf, ctx) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementStart"](0, "div", 0)(1, "h1", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵtext"](2, "Other Documents");
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementStart"](3, "mat-icon");
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵtext"](4, "close");
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementEnd"]()();
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementStart"](5, "div", 2)(6, "div", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelement"](7, "app-input", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementStart"](8, "div", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelement"](9, "app-date-picker", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementStart"](10, "app-upload-document", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵlistener"]("onSelect", function OtherDocumentsComponent_Template_app_upload_document_onSelect_10_listener($event) {
          return ctx.onUpload($event);
        });
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementStart"](11, "div", 7)(12, "button", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵlistener"]("click", function OtherDocumentsComponent_Template_button_click_12_listener() {
          return ctx.onNoClick();
        });
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵtext"](13, "Cancel");
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementStart"](14, "button", 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵlistener"]("click", function OtherDocumentsComponent_Template_button_click_14_listener() {
          return ctx.add();
        });
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵtext"](15, "Save");
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementEnd"]()()();
      }
      if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵadvance"](7);
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵproperty"]("form", ctx.form)("controller", ctx.controlls["documentName"]);
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵproperty"]("form", ctx.form)("controller", ctx.controlls["documentValidTill"]);
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵproperty"]("form", ctx.form);
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵproperty"]("disabled", ctx.form.invalid);
      }
    },
    dependencies: [_components_controllers_input_input_component__WEBPACK_IMPORTED_MODULE_3__.InputComponent, _components_controllers_date_picker_date_picker_component__WEBPACK_IMPORTED_MODULE_4__.DatePickerComponent, _components_controllers_upload_document_upload_document_component__WEBPACK_IMPORTED_MODULE_5__.UploadDocumentComponent, _angular_material_button__WEBPACK_IMPORTED_MODULE_9__.MatButton, _angular_material_icon__WEBPACK_IMPORTED_MODULE_10__.MatIcon],
    styles: [".btn-wrapper[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: row;\n  justify-content: right;\n}\n.btn-wrapper[_ngcontent-%COMP%]   button[_ngcontent-%COMP%] {\n  margin: 10px;\n}\n\n.container[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: column;\n  justify-content: space-between;\n  width: 100%;\n  height: 100%;\n}\n.container[_ngcontent-%COMP%]   .row[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: row;\n  width: 100%;\n  height: 25%;\n  padding: 1% 0;\n  padding-left: 4%;\n}\n\n.header[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: row;\n  justify-content: space-between;\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIm90aGVyLWRvY3VtZW50cy5jb21wb25lbnQuc2NzcyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTtFQUNJLGFBQUE7RUFDQSxtQkFBQTtFQUNBLHNCQUFBO0FBQ0o7QUFBSTtFQUNJLFlBQUE7QUFFUjs7QUFDQTtFQUNJLGFBQUE7RUFDQSxzQkFBQTtFQUNBLDhCQUFBO0VBQ0EsV0FBQTtFQUNBLFlBQUE7QUFFSjtBQURJO0VBQ0ksYUFBQTtFQUNBLG1CQUFBO0VBQ0EsV0FBQTtFQUNBLFdBQUE7RUFDQSxhQUFBO0VBQ0EsZ0JBQUE7QUFHUjs7QUFDQTtFQUNJLGFBQUE7RUFDQSxtQkFBQTtFQUNBLDhCQUFBO0FBRUoiLCJmaWxlIjoib3RoZXItZG9jdW1lbnRzLmNvbXBvbmVudC5zY3NzIiwic291cmNlc0NvbnRlbnQiOlsiLmJ0bi13cmFwcGVye1xuICAgIGRpc3BsYXk6IGZsZXg7XG4gICAgZmxleC1kaXJlY3Rpb246IHJvdztcbiAgICBqdXN0aWZ5LWNvbnRlbnQ6IHJpZ2h0O1xuICAgIGJ1dHRvbntcbiAgICAgICAgbWFyZ2luOiAxMHB4O1xuICAgIH1cbn0gXG4uY29udGFpbmVye1xuICAgIGRpc3BsYXk6IGZsZXg7XG4gICAgZmxleC1kaXJlY3Rpb246IGNvbHVtbjtcbiAgICBqdXN0aWZ5LWNvbnRlbnQ6IHNwYWNlLWJldHdlZW47XG4gICAgd2lkdGg6IDEwMCU7XG4gICAgaGVpZ2h0OiAxMDAlO1xuICAgIC5yb3d7XG4gICAgICAgIGRpc3BsYXk6IGZsZXg7XG4gICAgICAgIGZsZXgtZGlyZWN0aW9uOiByb3c7XG4gICAgICAgIHdpZHRoOiAxMDAlO1xuICAgICAgICBoZWlnaHQ6IDI1JTtcbiAgICAgICAgcGFkZGluZzogMSUgMDtcbiAgICAgICAgcGFkZGluZy1sZWZ0OiA0JTtcbiAgICB9XG59XG5cbi5oZWFkZXJ7XG4gICAgZGlzcGxheTogZmxleDtcbiAgICBmbGV4LWRpcmVjdGlvbjogcm93O1xuICAgIGp1c3RpZnktY29udGVudDogc3BhY2UtYmV0d2Vlbjtcbn0iXX0= */\n/*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8uL3NyYy9hcHAvbW9kdWxlcy91c2VyLW1hbmFlbWVudC9kb2NzL290aGVyLWRvY3VtZW50cy9vdGhlci1kb2N1bWVudHMuY29tcG9uZW50LnNjc3MiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7RUFDSSxhQUFBO0VBQ0EsbUJBQUE7RUFDQSxzQkFBQTtBQUNKO0FBQUk7RUFDSSxZQUFBO0FBRVI7O0FBQ0E7RUFDSSxhQUFBO0VBQ0Esc0JBQUE7RUFDQSw4QkFBQTtFQUNBLFdBQUE7RUFDQSxZQUFBO0FBRUo7QUFESTtFQUNJLGFBQUE7RUFDQSxtQkFBQTtFQUNBLFdBQUE7RUFDQSxXQUFBO0VBQ0EsYUFBQTtFQUNBLGdCQUFBO0FBR1I7O0FBQ0E7RUFDSSxhQUFBO0VBQ0EsbUJBQUE7RUFDQSw4QkFBQTtBQUVKO0FBQ0Esb3dDQUFvd0MiLCJzb3VyY2VzQ29udGVudCI6WyIuYnRuLXdyYXBwZXJ7XG4gICAgZGlzcGxheTogZmxleDtcbiAgICBmbGV4LWRpcmVjdGlvbjogcm93O1xuICAgIGp1c3RpZnktY29udGVudDogcmlnaHQ7XG4gICAgYnV0dG9ue1xuICAgICAgICBtYXJnaW46IDEwcHg7XG4gICAgfVxufSBcbi5jb250YWluZXJ7XG4gICAgZGlzcGxheTogZmxleDtcbiAgICBmbGV4LWRpcmVjdGlvbjogY29sdW1uO1xuICAgIGp1c3RpZnktY29udGVudDogc3BhY2UtYmV0d2VlbjtcbiAgICB3aWR0aDogMTAwJTtcbiAgICBoZWlnaHQ6IDEwMCU7XG4gICAgLnJvd3tcbiAgICAgICAgZGlzcGxheTogZmxleDtcbiAgICAgICAgZmxleC1kaXJlY3Rpb246IHJvdztcbiAgICAgICAgd2lkdGg6IDEwMCU7XG4gICAgICAgIGhlaWdodDogMjUlO1xuICAgICAgICBwYWRkaW5nOiAxJSAwO1xuICAgICAgICBwYWRkaW5nLWxlZnQ6IDQlO1xuICAgIH1cbn1cblxuLmhlYWRlcntcbiAgICBkaXNwbGF5OiBmbGV4O1xuICAgIGZsZXgtZGlyZWN0aW9uOiByb3c7XG4gICAganVzdGlmeS1jb250ZW50OiBzcGFjZS1iZXR3ZWVuO1xufSJdLCJzb3VyY2VSb290IjoiIn0= */"]
  });
}


/***/ }),

/***/ 1319:
/*!**************************************************************************************************!*\
  !*** ./src/app/modules/user-manaement/docs/pet-innsurance-list/pet-innsurance-list.component.ts ***!
  \**************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "PetInnsuranceListComponent": () => (/* binding */ PetInnsuranceListComponent)
/* harmony export */ });
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/forms */ 69542);
/* harmony import */ var _angular_material_dialog__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @angular/material/dialog */ 67486);
/* harmony import */ var app_components_controllers_confirmation_dialog_confirmation_dialog_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! app/components/controllers/confirmation-dialog/confirmation-dialog.component */ 81500);
/* harmony import */ var _pet_insurance_pet_insurance_component__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../pet-insurance/pet-insurance.component */ 34512);
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! moment */ 56908);
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(moment__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _angular_material_paginator__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @angular/material/paginator */ 86907);
/* harmony import */ var _angular_material_sort__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @angular/material/sort */ 95096);
/* harmony import */ var _angular_material_table__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/material/table */ 83348);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/core */ 86839);
/* harmony import */ var app_services_pet_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! app/services/pet.service */ 59976);
/* harmony import */ var app_services_loader_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! app/services/loader.service */ 38555);
/* harmony import */ var _angular_material_button__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @angular/material/button */ 83677);
/* harmony import */ var _angular_material_menu__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @angular/material/menu */ 89314);
/* harmony import */ var _angular_material_icon__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @angular/material/icon */ 69941);


















function PetInnsuranceListComponent_th_10_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "th", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](1, " ID. ");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
  }
}
function PetInnsuranceListComponent_td_11_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "td", 19);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const element_r12 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtextInterpolate1"](" ", element_r12.id.substring(0, 6), " ");
  }
}
function PetInnsuranceListComponent_th_13_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "th", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](1, " Document Name ");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
  }
}
function PetInnsuranceListComponent_td_14_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "td", 19);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const element_r13 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtextInterpolate1"](" ", element_r13.docName, " ");
  }
}
function PetInnsuranceListComponent_th_16_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "th", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](1, " uploaded On");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
  }
}
function PetInnsuranceListComponent_td_17_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "td", 19);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const element_r14 = ctx.$implicit;
    const ctx_r5 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtextInterpolate1"](" ", ctx_r5.currentUTCDate(element_r14.createdAt), " ");
  }
}
function PetInnsuranceListComponent_th_19_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "th", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](1, " Valid Till");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
  }
}
function PetInnsuranceListComponent_td_20_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "td", 19);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const element_r15 = ctx.$implicit;
    const ctx_r7 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtextInterpolate1"](" ", element_r15.validTill ? ctx_r7.currentUTCDate(element_r15.validTill) : "", " ");
  }
}
function PetInnsuranceListComponent_th_22_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "th", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](1, " Action ");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
  }
}
function PetInnsuranceListComponent_td_23_Template(rf, ctx) {
  if (rf & 1) {
    const _r20 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "td", 19)(1, "button", 20);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵlistener"]("click", function PetInnsuranceListComponent_td_23_Template_button_click_1_listener() {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵrestoreView"](_r20);
      const i_r17 = restoredCtx.index;
      const element_r16 = restoredCtx.$implicit;
      const ctx_r19 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵresetView"](ctx_r19.toggle(i_r17, element_r16));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](2, "mat-icon");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](3, "more_vert");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]()();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](4, "mat-menu", null, 21)(6, "button", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵlistener"]("click", function PetInnsuranceListComponent_td_23_Template_button_click_6_listener() {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵrestoreView"](_r20);
      const element_r16 = restoredCtx.$implicit;
      const i_r17 = restoredCtx.index;
      const ctx_r21 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵresetView"](ctx_r21.edit(element_r16, i_r17));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](7, "span", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](8, "Edit");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](9, "mat-icon", 24);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](10, "edit");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]()();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](11, "button", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵlistener"]("click", function PetInnsuranceListComponent_td_23_Template_button_click_11_listener() {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵrestoreView"](_r20);
      const element_r16 = restoredCtx.$implicit;
      const i_r17 = restoredCtx.index;
      const ctx_r22 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵresetView"](ctx_r22.delete(element_r16, i_r17));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](12, "span", 25);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](13, "Delete");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](14, "mat-icon", 26);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](15, "delete");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]()()()();
  }
  if (rf & 2) {
    const _r18 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵreference"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("matMenuTriggerFor", _r18);
  }
}
function PetInnsuranceListComponent_tr_24_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelement"](0, "tr", 27);
  }
}
function PetInnsuranceListComponent_tr_25_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelement"](0, "tr", 28);
  }
}
const _c0 = function () {
  return [5, 10, 25, 100];
};
class PetInnsuranceListComponent {
  constructor(fb, petService, dialogRef, data, dialog, loader) {
    this.fb = fb;
    this.petService = petService;
    this.dialogRef = dialogRef;
    this.data = data;
    this.dialog = dialog;
    this.loader = loader;
    this.displayedColumns = ['id', 'documentName', 'uploadedOn', 'documentValidTill', 'action'];
    this.createForm();
  }
  ngOnInit() {
    this.getInnsuranceList();
  }
  ngAfterViewInit() {
    this.recordData.paginator = this.paginator;
  }
  getInnsuranceList() {
    let data = {
      petId: sessionStorage.getItem('petId'),
      type: 'PetInsurance',
      userId: sessionStorage.getItem('petParentId')
    };
    this.petService.getPetDoc(data).subscribe(res => {
      if (res.length == 0) {
        this.petService.petDocsTemplateData[2]['icon'] = './assets/icons/grey-pet-history/Insurance.svg';
      }
      const petParentsArray = Object.values(res);
      this.recordData = new _angular_material_table__WEBPACK_IMPORTED_MODULE_6__.MatTableDataSource(petParentsArray.map(item => ({
        ...item
      })));
      this.recordData.paginator = this.paginator;
      this.recordData.sort = this.sort;
    });
  }
  toggle(i, record) {}
  createForm() {
    this.form = this.fb.group({
      documentName: ['', [_angular_forms__WEBPACK_IMPORTED_MODULE_7__.Validators.required]],
      documentValidTill: [''],
      // idNumber : ['',[Validators.required]],
      document: ['']
    });
  }
  currentUTCDate(date) {
    if (date) {
      return moment__WEBPACK_IMPORTED_MODULE_2___default().utc(date).local().format("DD-MMM-YYYY");
    } else {
      return 0;
    }
  }
  delete(el, i) {
    const dialogRef = this.dialog.open(app_components_controllers_confirmation_dialog_confirmation_dialog_component__WEBPACK_IMPORTED_MODULE_0__.ConfirmationDialogComponent, {
      width: '400px',
      data: {
        message: 'Are you sure you want to Delete?'
      }
    });
    dialogRef.afterClosed().subscribe(result => {
      if (result) {
        this.loader.showLoader();
        this.petService.deletePetDoc(sessionStorage.getItem('petParentId'), el['id']).subscribe(res => {
          console.log(res);
          this.loader.hideLoader();
          this.getInnsuranceList();
        }, error => {
          this.loader.hideLoader();
        });
      } else {
        console.log("");
      }
    });
  }
  edit(el, i) {
    const dialogRef = this.dialog.open(_pet_insurance_pet_insurance_component__WEBPACK_IMPORTED_MODULE_1__.PetInsuranceComponent, {
      data: {
        type: this.data['title'],
        record: el
      }
    });
    dialogRef.afterClosed().subscribe(result => {
      console.log('The dialog was closed');
      console.log(result);
      this.getInnsuranceList();
    });
  }
  addRecord() {
    const dialogRef = this.dialog.open(_pet_insurance_pet_insurance_component__WEBPACK_IMPORTED_MODULE_1__.PetInsuranceComponent, {
      data: {
        type: this.data['title']
      }
    });
    dialogRef.afterClosed().subscribe(result => {
      console.log('The dialog was closed');
      this.getInnsuranceList();
      console.log(result);
    });
  }
  onNoClick() {
    this.dialogRef.close();
  }
  static #_ = this.ɵfac = function PetInnsuranceListComponent_Factory(t) {
    return new (t || PetInnsuranceListComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](_angular_forms__WEBPACK_IMPORTED_MODULE_7__.FormBuilder), _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](app_services_pet_service__WEBPACK_IMPORTED_MODULE_3__.PetService), _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](_angular_material_dialog__WEBPACK_IMPORTED_MODULE_8__.MatDialogRef), _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](_angular_material_dialog__WEBPACK_IMPORTED_MODULE_8__.MAT_DIALOG_DATA), _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](_angular_material_dialog__WEBPACK_IMPORTED_MODULE_8__.MatDialog), _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](app_services_loader_service__WEBPACK_IMPORTED_MODULE_4__.LoaderService));
  };
  static #_2 = this.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdefineComponent"]({
    type: PetInnsuranceListComponent,
    selectors: [["app-pet-innsurance-list"]],
    viewQuery: function PetInnsuranceListComponent_Query(rf, ctx) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵviewQuery"](_angular_material_paginator__WEBPACK_IMPORTED_MODULE_9__.MatPaginator, 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵviewQuery"](_angular_material_sort__WEBPACK_IMPORTED_MODULE_10__.MatSort, 5);
      }
      if (rf & 2) {
        let _t;
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵloadQuery"]()) && (ctx.paginator = _t.first);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵloadQuery"]()) && (ctx.sort = _t.first);
      }
    },
    decls: 31,
    vars: 7,
    consts: [[1, "header"], ["mat-dialog-title", "", 2, "align-items", "center"], ["mat-mini-fab", "", "color", "warn", 3, "click"], ["mat-dialog-content", "", 1, "record-grid", 2, "min-height", "150px", "height", "400px", "overflow-y", "auto"], [1, "table-wrapper"], ["mat-table", "", 1, "mat-elevation-z8", "mt-2", 3, "dataSource"], ["matColumnDef", "id"], ["mat-header-cell", "", 4, "matHeaderCellDef"], ["mat-cell", "", 4, "matCellDef"], ["matColumnDef", "documentName"], ["matColumnDef", "uploadedOn"], ["matColumnDef", "documentValidTill"], ["matColumnDef", "action"], ["mat-header-row", "", 4, "matHeaderRowDef"], ["mat-row", "", 4, "matRowDef", "matRowDefColumns"], [3, "pageSize", "pageSizeOptions"], [1, "btn"], ["mat-mini-fab", "", "color", "primary", 3, "click"], ["mat-header-cell", ""], ["mat-cell", ""], ["mat-icon-button", "", 3, "matMenuTriggerFor", "click"], ["actionMenu", "matMenu"], ["mat-menu-item", "", 3, "click"], [2, "color", "blue !important"], ["color", "primary"], [2, "color", "hsl(0, 94%, 42%) !important"], ["color", "warn"], ["mat-header-row", ""], ["mat-row", ""]],
    template: function PetInnsuranceListComponent_Template(rf, ctx) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "div", 0)(1, "h1", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](3, "button", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵlistener"]("click", function PetInnsuranceListComponent_Template_button_click_3_listener() {
          return ctx.onNoClick();
        });
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](4, "mat-icon");
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](5, "close");
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]()()();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](6, "div", 3)(7, "div", 4)(8, "table", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementContainerStart"](9, 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](10, PetInnsuranceListComponent_th_10_Template, 2, 0, "th", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](11, PetInnsuranceListComponent_td_11_Template, 2, 1, "td", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementContainerStart"](12, 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](13, PetInnsuranceListComponent_th_13_Template, 2, 0, "th", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](14, PetInnsuranceListComponent_td_14_Template, 2, 1, "td", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementContainerStart"](15, 10);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](16, PetInnsuranceListComponent_th_16_Template, 2, 0, "th", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](17, PetInnsuranceListComponent_td_17_Template, 2, 1, "td", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementContainerStart"](18, 11);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](19, PetInnsuranceListComponent_th_19_Template, 2, 0, "th", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](20, PetInnsuranceListComponent_td_20_Template, 2, 1, "td", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementContainerStart"](21, 12);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](22, PetInnsuranceListComponent_th_22_Template, 2, 0, "th", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](23, PetInnsuranceListComponent_td_23_Template, 16, 1, "td", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](24, PetInnsuranceListComponent_tr_24_Template, 1, 0, "tr", 13);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](25, PetInnsuranceListComponent_tr_25_Template, 1, 0, "tr", 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelement"](26, "mat-paginator", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]()();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](27, "div", 16)(28, "button", 17);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵlistener"]("click", function PetInnsuranceListComponent_Template_button_click_28_listener() {
          return ctx.addRecord();
        });
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](29, "mat-icon");
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](30, "add");
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]()()();
      }
      if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtextInterpolate1"]("", ctx.data["title"], " List");
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](6);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("dataSource", ctx.recordData);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](16);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("matHeaderRowDef", ctx.displayedColumns);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("matRowDefColumns", ctx.displayedColumns);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("pageSize", 10)("pageSizeOptions", _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpureFunction0"](6, _c0));
      }
    },
    dependencies: [_angular_material_table__WEBPACK_IMPORTED_MODULE_6__.MatTable, _angular_material_table__WEBPACK_IMPORTED_MODULE_6__.MatHeaderCellDef, _angular_material_table__WEBPACK_IMPORTED_MODULE_6__.MatHeaderRowDef, _angular_material_table__WEBPACK_IMPORTED_MODULE_6__.MatColumnDef, _angular_material_table__WEBPACK_IMPORTED_MODULE_6__.MatCellDef, _angular_material_table__WEBPACK_IMPORTED_MODULE_6__.MatRowDef, _angular_material_table__WEBPACK_IMPORTED_MODULE_6__.MatHeaderCell, _angular_material_table__WEBPACK_IMPORTED_MODULE_6__.MatCell, _angular_material_table__WEBPACK_IMPORTED_MODULE_6__.MatHeaderRow, _angular_material_table__WEBPACK_IMPORTED_MODULE_6__.MatRow, _angular_material_button__WEBPACK_IMPORTED_MODULE_11__.MatIconButton, _angular_material_button__WEBPACK_IMPORTED_MODULE_11__.MatMiniFabButton, _angular_material_menu__WEBPACK_IMPORTED_MODULE_12__.MatMenu, _angular_material_menu__WEBPACK_IMPORTED_MODULE_12__.MatMenuItem, _angular_material_menu__WEBPACK_IMPORTED_MODULE_12__.MatMenuTrigger, _angular_material_icon__WEBPACK_IMPORTED_MODULE_13__.MatIcon, _angular_material_paginator__WEBPACK_IMPORTED_MODULE_9__.MatPaginator],
    styles: [".btn[_ngcontent-%COMP%] {\n  display: flex;\n  justify-content: end;\n}\n\n.card[_ngcontent-%COMP%] {\n  padding: 2px;\n}\n\nmat-card-content[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: column;\n  justify-content: center;\n}\n\n.record-grid[_ngcontent-%COMP%] {\n  min-height: 80%;\n  max-height: -moz-fit-content;\n  max-height: fit-content;\n}\n\nmat-form-field[_ngcontent-%COMP%] {\n  display: block;\n  margin: 10px 0;\n}\n\n.header[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: row;\n  justify-content: space-between;\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInBldC1pbm5zdXJhbmNlLWxpc3QuY29tcG9uZW50LnNjc3MiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7RUFDSSxhQUFBO0VBQ0Esb0JBQUE7QUFDSjs7QUFFQTtFQUNJLFlBQUE7QUFDSjs7QUFHQTtFQUNJLGFBQUE7RUFDQSxzQkFBQTtFQUNBLHVCQUFBO0FBQUo7O0FBSUE7RUFDSSxlQUFBO0VBQ0EsNEJBQUE7RUFBQSx1QkFBQTtBQURKOztBQUtBO0VBQ0ksY0FBQTtFQUNBLGNBQUE7QUFGSjs7QUFLQTtFQUNJLGFBQUE7RUFDQSxtQkFBQTtFQUNBLDhCQUFBO0FBRkoiLCJmaWxlIjoicGV0LWlubnN1cmFuY2UtbGlzdC5jb21wb25lbnQuc2NzcyIsInNvdXJjZXNDb250ZW50IjpbIi5idG4ge1xuICAgIGRpc3BsYXk6IGZsZXg7XG4gICAganVzdGlmeS1jb250ZW50OiBlbmQ7XG59XG5cbi5jYXJkIHtcbiAgICBwYWRkaW5nOiAycHg7XG4gXG59XG5cbm1hdC1jYXJkLWNvbnRlbnQge1xuICAgIGRpc3BsYXk6IGZsZXg7XG4gICAgZmxleC1kaXJlY3Rpb246IGNvbHVtbjtcbiAgICBqdXN0aWZ5LWNvbnRlbnQ6IGNlbnRlcjtcbiAgICAvLyBhbGlnbi1pdGVtczogY2VudGVyO1xuXG59XG4ucmVjb3JkLWdyaWR7XG4gICAgbWluLWhlaWdodDogODAlO1xuICAgIG1heC1oZWlnaHQ6IGZpdC1jb250ZW50O1xufVxuXG5cbm1hdC1mb3JtLWZpZWxkIHtcbiAgICBkaXNwbGF5OiBibG9jaztcbiAgICBtYXJnaW46IDEwcHggMDtcbn1cblxuLmhlYWRlciB7XG4gICAgZGlzcGxheTogZmxleDtcbiAgICBmbGV4LWRpcmVjdGlvbjogcm93O1xuICAgIGp1c3RpZnktY29udGVudDogc3BhY2UtYmV0d2Vlbjtcbn0iXX0= */\n/*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8uL3NyYy9hcHAvbW9kdWxlcy91c2VyLW1hbmFlbWVudC9kb2NzL3BldC1pbm5zdXJhbmNlLWxpc3QvcGV0LWlubnN1cmFuY2UtbGlzdC5jb21wb25lbnQuc2NzcyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTtFQUNJLGFBQUE7RUFDQSxvQkFBQTtBQUNKOztBQUVBO0VBQ0ksWUFBQTtBQUNKOztBQUdBO0VBQ0ksYUFBQTtFQUNBLHNCQUFBO0VBQ0EsdUJBQUE7QUFBSjs7QUFJQTtFQUNJLGVBQUE7RUFDQSw0QkFBQTtFQUFBLHVCQUFBO0FBREo7O0FBS0E7RUFDSSxjQUFBO0VBQ0EsY0FBQTtBQUZKOztBQUtBO0VBQ0ksYUFBQTtFQUNBLG1CQUFBO0VBQ0EsOEJBQUE7QUFGSjtBQUVBLG9vQ0FBb29DIiwic291cmNlc0NvbnRlbnQiOlsiLmJ0biB7XG4gICAgZGlzcGxheTogZmxleDtcbiAgICBqdXN0aWZ5LWNvbnRlbnQ6IGVuZDtcbn1cblxuLmNhcmQge1xuICAgIHBhZGRpbmc6IDJweDtcbiBcbn1cblxubWF0LWNhcmQtY29udGVudCB7XG4gICAgZGlzcGxheTogZmxleDtcbiAgICBmbGV4LWRpcmVjdGlvbjogY29sdW1uO1xuICAgIGp1c3RpZnktY29udGVudDogY2VudGVyO1xuICAgIC8vIGFsaWduLWl0ZW1zOiBjZW50ZXI7XG5cbn1cbi5yZWNvcmQtZ3JpZHtcbiAgICBtaW4taGVpZ2h0OiA4MCU7XG4gICAgbWF4LWhlaWdodDogZml0LWNvbnRlbnQ7XG59XG5cblxubWF0LWZvcm0tZmllbGQge1xuICAgIGRpc3BsYXk6IGJsb2NrO1xuICAgIG1hcmdpbjogMTBweCAwO1xufVxuXG4uaGVhZGVyIHtcbiAgICBkaXNwbGF5OiBmbGV4O1xuICAgIGZsZXgtZGlyZWN0aW9uOiByb3c7XG4gICAganVzdGlmeS1jb250ZW50OiBzcGFjZS1iZXR3ZWVuO1xufSJdLCJzb3VyY2VSb290IjoiIn0= */"]
  });
}


/***/ }),

/***/ 34512:
/*!**************************************************************************************!*\
  !*** ./src/app/modules/user-manaement/docs/pet-insurance/pet-insurance.component.ts ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "PetInsuranceComponent": () => (/* binding */ PetInsuranceComponent)
/* harmony export */ });
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/forms */ 69542);
/* harmony import */ var _angular_material_dialog__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @angular/material/dialog */ 67486);
/* harmony import */ var app_components_controllers_confirmation_dialog_confirmation_dialog_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! app/components/controllers/confirmation-dialog/confirmation-dialog.component */ 81500);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/core */ 86839);
/* harmony import */ var app_services_pet_service__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! app/services/pet.service */ 59976);
/* harmony import */ var app_services_loader_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! app/services/loader.service */ 38555);
/* harmony import */ var _components_controllers_input_input_component__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../../components/controllers/input/input.component */ 30867);
/* harmony import */ var _components_controllers_date_picker_date_picker_component__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../../components/controllers/date-picker/date-picker.component */ 49582);
/* harmony import */ var _components_controllers_upload_document_upload_document_component__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../../components/controllers/upload-document/upload-document.component */ 15698);
/* harmony import */ var _angular_material_button__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @angular/material/button */ 83677);
/* harmony import */ var _angular_material_icon__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @angular/material/icon */ 69941);













class PetInsuranceComponent {
  constructor(fb, petService, dialogRef, data, dialog, loader) {
    this.fb = fb;
    this.petService = petService;
    this.dialogRef = dialogRef;
    this.data = data;
    this.dialog = dialog;
    this.loader = loader;
    this.createForm();
    this.createControlls();
    // this.get();
  }
  ngOnInit() {
    if (this.data['record']) {
      this.edit();
    }
  }
  edit() {
    let el = this.data['record'];
    this.form = this.fb.group({
      id: [el['id']],
      uploadedOn: [el['createdAt'] ? new Date(el['createdAt']) : ''],
      documentName: [el['docName'], _angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.required],
      documentValidTill: [el['validTill'] ? new Date(el['validTill']) : ''],
      document: [el['docPath'] ? el['docPath'] : null]
    });
  }
  onUpload(event) {
    this.form.get('document').setValue(event);
  }
  // get() {
  //   let data = {
  //     petId: sessionStorage.getItem('petId'),
  //     type: 'PetInsurance',
  //     userId: sessionStorage.getItem('petParentId'),
  //   }
  //   this.petService.getPetDoc(data).subscribe((res: Array<any>) => {
  //     if (res.length > 0) {
  //       this.data = res[0];
  //       // let formDta = new FormData();
  //       // formDta.append('files', this.microChipData['docPath']);
  //       console.log(this.data['validTill']);
  //       this.form.get('documentName').setValue(this.data['docName']);
  //       this.form.get('documentValidTill').setValue(this.data['validTill'] ? new Date(this.data['validTill']):'')
  //       if(this.data['docPath']){
  //         this.form.get('document').setValue(this.data['docPath'])
  //       }
  //     }
  //     console.log(this.form);
  //   })
  // }
  createForm() {
    this.form = this.fb.group({
      documentName: ['', [_angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.required]],
      documentValidTill: [''],
      // idNumber : ['',[Validators.required]],
      document: ['']
    });
  }
  createControlls() {
    this.controlls = {
      documentName: {
        id: "documentName",
        name: 'documentName',
        label: "Document Name",
        placeholder: "Enter Document Name",
        required: true,
        type: "text"
      },
      documentValidTill: {
        id: "documentValidTill",
        name: 'documentValidTill',
        label: "Document Valid Till",
        placeholder: "Document Valid Till",
        required: true,
        type: "text"
      }
    };
  }
  filename(event) {
    this.fileName = event;
  }
  add() {
    // this.petParentId = sessionStorage.getItem('petParentId');
    // this.petId = sessionStorage.getItem('petId')
    let json = this.form.value;
    console.log(json);
    // sessionStorage.getItem('petParentId');
    // sessionStorage.getItem('petId')
    let data = {
      petId: sessionStorage.getItem('petId'),
      type: 'PetInsurance',
      docNumber: 0,
      userId: sessionStorage.getItem('petParentId'),
      docName: json['documentName'],
      validTill: json['documentValidTill'] ? new Date(json['documentValidTill']).getTime() : 0,
      document: json['document'] ? json['document'] : null
    };
    // PetService
    if (this.data['record']) {
      data['docId'] = this.data['record']['id'];
      if (json['document']) {
        data['fileDelete'] = false;
      } else {
        data['fileDelete'] = true;
      }
      this.loader.showLoader();
      this.petService.editPetDoc(data).subscribe(res => {
        console.log(res);
        this.loader.hideLoader();
        this.dialogRef.close();
      }, error => {
        this.loader.hideLoader();
      });
    } else {
      this.loader.showLoader();
      this.petService.addPetDoc(data).subscribe(res => {
        this.petService.petDocsTemplateData[2]['icon'] = './assets/icons/pet-history/Insurance.svg';
        console.log(res);
        let data = {
          petId: sessionStorage.getItem('petId'),
          type: 'PetInsurance',
          userId: sessionStorage.getItem('petParentId')
        };
        this.petService.getPetDoc(data).subscribe(res => {
          console.log(res);
          // res.forEach(element => {
          //   if(element['id'])
          // });
        });
        this.loader.hideLoader();
        this.dialogRef.close();
      }, error => {
        this.loader.hideLoader();
      });
    }
  }
  onNoClick() {
    this.dialogRef.close();
  }
  delete() {
    const dialogRef = this.dialog.open(app_components_controllers_confirmation_dialog_confirmation_dialog_component__WEBPACK_IMPORTED_MODULE_0__.ConfirmationDialogComponent, {
      width: '400px',
      data: {
        message: 'Are you sure you want to Delete?'
      }
    });
    dialogRef.afterClosed().subscribe(result => {
      if (result) {
        this.loader.showLoader();
        this.petService.deletePetDoc(sessionStorage.getItem('petParentId'), this.data['id']).subscribe(res => {
          console.log(res);
          this.createForm();
          this.loader.hideLoader();
        }, error => {
          this.loader.hideLoader();
        });
      } else {
        console.log("");
      }
    });
  }
  static #_ = this.ɵfac = function PetInsuranceComponent_Factory(t) {
    return new (t || PetInsuranceComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵdirectiveInject"](_angular_forms__WEBPACK_IMPORTED_MODULE_6__.FormBuilder), _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵdirectiveInject"](app_services_pet_service__WEBPACK_IMPORTED_MODULE_1__.PetService), _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵdirectiveInject"](_angular_material_dialog__WEBPACK_IMPORTED_MODULE_8__.MatDialogRef), _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵdirectiveInject"](_angular_material_dialog__WEBPACK_IMPORTED_MODULE_8__.MAT_DIALOG_DATA), _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵdirectiveInject"](_angular_material_dialog__WEBPACK_IMPORTED_MODULE_8__.MatDialog), _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵdirectiveInject"](app_services_loader_service__WEBPACK_IMPORTED_MODULE_2__.LoaderService));
  };
  static #_2 = this.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵdefineComponent"]({
    type: PetInsuranceComponent,
    selectors: [["app-pet-insurance"]],
    inputs: {
      petId: "petId",
      petParentId: "petParentId"
    },
    decls: 16,
    vars: 6,
    consts: [[1, "header"], ["mat-dialog-title", "", 2, "align-items", "center"], [3, "click"], ["mat-dialog-content", ""], [1, "row"], [2, "width", "100%", 3, "form", "controller"], [1, "row", 2, "height", "20%"], [3, "form", "onSelect", "fileName"], [1, "btn-wrapper"], ["mat-stroked-button", "", "color", "primary", 3, "click"], ["mat-stroked-button", "", "color", "primary", 3, "disabled", "click"]],
    template: function PetInsuranceComponent_Template(rf, ctx) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementStart"](0, "div", 0)(1, "h1", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵtext"](2, "Pet Insurance");
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementStart"](3, "mat-icon", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵlistener"]("click", function PetInsuranceComponent_Template_mat_icon_click_3_listener() {
          return ctx.onNoClick();
        });
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵtext"](4, "close");
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementEnd"]()();
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementStart"](5, "div", 3)(6, "div", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelement"](7, "app-input", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementStart"](8, "div", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelement"](9, "app-date-picker", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementStart"](10, "app-upload-document", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵlistener"]("onSelect", function PetInsuranceComponent_Template_app_upload_document_onSelect_10_listener($event) {
          return ctx.onUpload($event);
        })("onSelect", function PetInsuranceComponent_Template_app_upload_document_onSelect_10_listener($event) {
          return ctx.onUpload($event);
        })("fileName", function PetInsuranceComponent_Template_app_upload_document_fileName_10_listener($event) {
          return ctx.filename($event);
        });
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementStart"](11, "div", 8)(12, "button", 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵlistener"]("click", function PetInsuranceComponent_Template_button_click_12_listener() {
          return ctx.onNoClick();
        });
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵtext"](13, "Cancel");
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementStart"](14, "button", 10);
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵlistener"]("click", function PetInsuranceComponent_Template_button_click_14_listener() {
          return ctx.add();
        });
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵtext"](15, "Save");
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementEnd"]()()();
      }
      if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵadvance"](7);
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵproperty"]("form", ctx.form)("controller", ctx.controlls["documentName"]);
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵproperty"]("form", ctx.form)("controller", ctx.controlls["documentValidTill"]);
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵproperty"]("form", ctx.form);
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵproperty"]("disabled", ctx.form.invalid);
      }
    },
    dependencies: [_components_controllers_input_input_component__WEBPACK_IMPORTED_MODULE_3__.InputComponent, _components_controllers_date_picker_date_picker_component__WEBPACK_IMPORTED_MODULE_4__.DatePickerComponent, _components_controllers_upload_document_upload_document_component__WEBPACK_IMPORTED_MODULE_5__.UploadDocumentComponent, _angular_material_button__WEBPACK_IMPORTED_MODULE_9__.MatButton, _angular_material_icon__WEBPACK_IMPORTED_MODULE_10__.MatIcon],
    styles: [".btn-wrapper[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: row;\n  justify-content: right;\n}\n.btn-wrapper[_ngcontent-%COMP%]   button[_ngcontent-%COMP%] {\n  margin: 10px;\n}\n\n.container[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: column;\n  justify-content: space-between;\n  width: 100%;\n  height: 100%;\n}\n.container[_ngcontent-%COMP%]   .row[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: row;\n  width: 100%;\n  height: 25%;\n  padding: 1% 0;\n  padding-left: 4%;\n}\n\n.header[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: row;\n  justify-content: space-between;\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInBldC1pbnN1cmFuY2UuY29tcG9uZW50LnNjc3MiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7RUFDSSxhQUFBO0VBQ0EsbUJBQUE7RUFDQSxzQkFBQTtBQUNKO0FBQUk7RUFDSSxZQUFBO0FBRVI7O0FBQ0E7RUFDSSxhQUFBO0VBQ0Esc0JBQUE7RUFDQSw4QkFBQTtFQUNBLFdBQUE7RUFDQSxZQUFBO0FBRUo7QUFESTtFQUNJLGFBQUE7RUFDQSxtQkFBQTtFQUNBLFdBQUE7RUFDQSxXQUFBO0VBQ0EsYUFBQTtFQUNBLGdCQUFBO0FBR1I7O0FBQ0E7RUFDSSxhQUFBO0VBQ0EsbUJBQUE7RUFDQSw4QkFBQTtBQUVKIiwiZmlsZSI6InBldC1pbnN1cmFuY2UuY29tcG9uZW50LnNjc3MiLCJzb3VyY2VzQ29udGVudCI6WyIuYnRuLXdyYXBwZXJ7XG4gICAgZGlzcGxheTogZmxleDtcbiAgICBmbGV4LWRpcmVjdGlvbjogcm93O1xuICAgIGp1c3RpZnktY29udGVudDogcmlnaHQ7XG4gICAgYnV0dG9ue1xuICAgICAgICBtYXJnaW46IDEwcHg7XG4gICAgfVxufSBcbi5jb250YWluZXJ7XG4gICAgZGlzcGxheTogZmxleDtcbiAgICBmbGV4LWRpcmVjdGlvbjogY29sdW1uO1xuICAgIGp1c3RpZnktY29udGVudDogc3BhY2UtYmV0d2VlbjtcbiAgICB3aWR0aDogMTAwJTtcbiAgICBoZWlnaHQ6IDEwMCU7XG4gICAgLnJvd3tcbiAgICAgICAgZGlzcGxheTogZmxleDtcbiAgICAgICAgZmxleC1kaXJlY3Rpb246IHJvdztcbiAgICAgICAgd2lkdGg6IDEwMCU7XG4gICAgICAgIGhlaWdodDogMjUlO1xuICAgICAgICBwYWRkaW5nOiAxJSAwO1xuICAgICAgICBwYWRkaW5nLWxlZnQ6IDQlO1xuICAgIH1cbn1cblxuLmhlYWRlcntcbiAgICBkaXNwbGF5OiBmbGV4O1xuICAgIGZsZXgtZGlyZWN0aW9uOiByb3c7XG4gICAganVzdGlmeS1jb250ZW50OiBzcGFjZS1iZXR3ZWVuO1xufSJdfQ== */\n/*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8uL3NyYy9hcHAvbW9kdWxlcy91c2VyLW1hbmFlbWVudC9kb2NzL3BldC1pbnN1cmFuY2UvcGV0LWluc3VyYW5jZS5jb21wb25lbnQuc2NzcyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTtFQUNJLGFBQUE7RUFDQSxtQkFBQTtFQUNBLHNCQUFBO0FBQ0o7QUFBSTtFQUNJLFlBQUE7QUFFUjs7QUFDQTtFQUNJLGFBQUE7RUFDQSxzQkFBQTtFQUNBLDhCQUFBO0VBQ0EsV0FBQTtFQUNBLFlBQUE7QUFFSjtBQURJO0VBQ0ksYUFBQTtFQUNBLG1CQUFBO0VBQ0EsV0FBQTtFQUNBLFdBQUE7RUFDQSxhQUFBO0VBQ0EsZ0JBQUE7QUFHUjs7QUFDQTtFQUNJLGFBQUE7RUFDQSxtQkFBQTtFQUNBLDhCQUFBO0FBRUo7QUFDQSxnd0NBQWd3QyIsInNvdXJjZXNDb250ZW50IjpbIi5idG4td3JhcHBlcntcbiAgICBkaXNwbGF5OiBmbGV4O1xuICAgIGZsZXgtZGlyZWN0aW9uOiByb3c7XG4gICAganVzdGlmeS1jb250ZW50OiByaWdodDtcbiAgICBidXR0b257XG4gICAgICAgIG1hcmdpbjogMTBweDtcbiAgICB9XG59IFxuLmNvbnRhaW5lcntcbiAgICBkaXNwbGF5OiBmbGV4O1xuICAgIGZsZXgtZGlyZWN0aW9uOiBjb2x1bW47XG4gICAganVzdGlmeS1jb250ZW50OiBzcGFjZS1iZXR3ZWVuO1xuICAgIHdpZHRoOiAxMDAlO1xuICAgIGhlaWdodDogMTAwJTtcbiAgICAucm93e1xuICAgICAgICBkaXNwbGF5OiBmbGV4O1xuICAgICAgICBmbGV4LWRpcmVjdGlvbjogcm93O1xuICAgICAgICB3aWR0aDogMTAwJTtcbiAgICAgICAgaGVpZ2h0OiAyNSU7XG4gICAgICAgIHBhZGRpbmc6IDElIDA7XG4gICAgICAgIHBhZGRpbmctbGVmdDogNCU7XG4gICAgfVxufVxuXG4uaGVhZGVye1xuICAgIGRpc3BsYXk6IGZsZXg7XG4gICAgZmxleC1kaXJlY3Rpb246IHJvdztcbiAgICBqdXN0aWZ5LWNvbnRlbnQ6IHNwYWNlLWJldHdlZW47XG59Il0sInNvdXJjZVJvb3QiOiIifQ== */"]
  });
}


/***/ }),

/***/ 19486:
/*!************************************************************************************!*\
  !*** ./src/app/modules/user-manaement/docs/pet-passport/pet-passport.component.ts ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "PetPassportComponent": () => (/* binding */ PetPassportComponent)
/* harmony export */ });
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/forms */ 69542);
/* harmony import */ var app_components_controllers_confirmation_dialog_confirmation_dialog_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! app/components/controllers/confirmation-dialog/confirmation-dialog.component */ 81500);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/core */ 86839);
/* harmony import */ var app_services_pet_service__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! app/services/pet.service */ 59976);
/* harmony import */ var _angular_material_dialog__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/material/dialog */ 67486);
/* harmony import */ var app_services_loader_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! app/services/loader.service */ 38555);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @angular/common */ 86477);
/* harmony import */ var _components_controllers_input_input_component__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../../components/controllers/input/input.component */ 30867);
/* harmony import */ var _components_controllers_upload_document_upload_document_component__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../../components/controllers/upload-document/upload-document.component */ 15698);
/* harmony import */ var _angular_material_button__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @angular/material/button */ 83677);
/* harmony import */ var _angular_material_icon__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @angular/material/icon */ 69941);












function PetPassportComponent_button_3_Template(rf, ctx) {
  if (rf & 1) {
    const _r2 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "button", 10);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵlistener"]("click", function PetPassportComponent_button_3_Template_button_click_0_listener() {
      _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵrestoreView"](_r2);
      const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵresetView"](ctx_r1.delete());
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](1, "mat-icon");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](2, "delete");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]()();
  }
}
class PetPassportComponent {
  constructor(fb, petService, dialogRef, dialog, loader) {
    this.fb = fb;
    this.petService = petService;
    this.dialogRef = dialogRef;
    this.dialog = dialog;
    this.loader = loader;
    this.createForm();
    this.createControlls();
    this.get();
  }
  onUpload(event) {
    this.form.get('document').setValue(event);
  }
  get() {
    let data = {
      petId: sessionStorage.getItem('petId'),
      type: 'PetPassport',
      userId: sessionStorage.getItem('petParentId')
    };
    this.petService.getPetDoc(data).subscribe(res => {
      if (res) {
        this.passportData = res[0];
        // let formDta = new FormData();
        // formDta.append('files', this.microChipData['docPath']);
        this.form.get('passportId').setValue(this.passportData['docNumber']);
        if (this.passportData['docPath']) {
          this.form.get('document').setValue(this.passportData['docPath']);
        }
      }
    });
  }
  createForm() {
    this.form = this.fb.group({
      passportId: ['', [_angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.required]],
      // idNumber : ['',[Validators.required]],
      document: ['']
    });
  }
  createControlls() {
    this.controlls = {
      passportId: {
        id: "passportId",
        name: 'passportId',
        label: "Passport ID Number",
        placeholder: "Enter Passport ID Number",
        required: true,
        type: "text"
      },
      document: {
        id: "document",
        name: 'document',
        label: "Document",
        placeholder: "Document",
        required: true,
        type: "text"
      }
    };
  }
  filename(event) {
    this.fileName = event;
  }
  add() {
    // this.petParentId = sessionStorage.getItem('petParentId');
    // this.petId = sessionStorage.getItem('petId')
    let json = this.form.value;
    console.log(json);
    // sessionStorage.getItem('petParentId');
    // sessionStorage.getItem('petId')
    let data = {
      petId: sessionStorage.getItem('petId'),
      type: 'PetPassport',
      docNumber: json['passportId'],
      userId: sessionStorage.getItem('petParentId'),
      docName: 0,
      validTill: 0,
      document: json['document']
    };
    // PetService
    if (this.passportData) {
      data['docId'] = this.passportData['id'];
      if (json['document']) {
        data['fileDelete'] = false;
      } else {
        data['fileDelete'] = true;
      }
      this.loader.showLoader();
      this.petService.editPetDoc(data).subscribe(res => {
        this.loader.hideLoader();
        this.dialogRef.close();
        console.log(res);
      });
    } else {
      this.loader.showLoader();
      this.petService.addPetDoc(data).subscribe(res => {
        this.petService.petDocsTemplateData[1]['icon'] = './assets/icons/pet-history/Passport.svg';
        this.loader.hideLoader();
        this.dialogRef.close();
        console.log(res);
      });
    }
  }
  onNoClick() {
    this.dialogRef.close();
  }
  delete() {
    const dialogRef = this.dialog.open(app_components_controllers_confirmation_dialog_confirmation_dialog_component__WEBPACK_IMPORTED_MODULE_0__.ConfirmationDialogComponent, {
      width: '400px',
      data: {
        message: 'Are you sure you want to Delete?'
      }
    });
    dialogRef.afterClosed().subscribe(result => {
      if (result) {
        this.loader.showLoader();
        this.petService.deletePetDoc(sessionStorage.getItem('petParentId'), this.passportData['id']).subscribe(res => {
          console.log(res);
          this.petService.petDocsTemplateData[1]['icon'] = './assets/icons/grey-pet-history/Passport.svg';
          this.createForm();
          this.dialogRef.close();
          this.loader.hideLoader();
        }, error => {
          this.loader.hideLoader();
          this.dialogRef.close();
        });
      } else {
        console.log("");
      }
    });
  }
  static #_ = this.ɵfac = function PetPassportComponent_Factory(t) {
    return new (t || PetPassportComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](_angular_forms__WEBPACK_IMPORTED_MODULE_6__.FormBuilder), _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](app_services_pet_service__WEBPACK_IMPORTED_MODULE_1__.PetService), _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](_angular_material_dialog__WEBPACK_IMPORTED_MODULE_7__.MatDialogRef), _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](_angular_material_dialog__WEBPACK_IMPORTED_MODULE_7__.MatDialog), _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](app_services_loader_service__WEBPACK_IMPORTED_MODULE_2__.LoaderService));
  };
  static #_2 = this.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdefineComponent"]({
    type: PetPassportComponent,
    selectors: [["app-pet-passport"]],
    inputs: {
      petId: "petId",
      petParentId: "petParentId"
    },
    decls: 13,
    vars: 5,
    consts: [[1, "header"], ["mat-dialog-title", "", 2, "align-items", "center"], ["mat-mini-fab", "", "color", "warn", 3, "click", 4, "ngIf"], ["mat-dialog-content", ""], [1, "row"], [2, "width", "100%", 3, "form", "controller"], [3, "form", "onSelect", "fileName"], [1, "btn-wrapper"], ["mat-stroked-button", "", "color", "primary", 3, "click"], ["mat-stroked-button", "", "color", "primary", 3, "disabled", "click"], ["mat-mini-fab", "", "color", "warn", 3, "click"]],
    template: function PetPassportComponent_Template(rf, ctx) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "div", 0)(1, "h1", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](2, "Pet Passport");
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](3, PetPassportComponent_button_3_Template, 3, 0, "button", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](4, "div", 3)(5, "div", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelement"](6, "app-input", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](7, "app-upload-document", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵlistener"]("onSelect", function PetPassportComponent_Template_app_upload_document_onSelect_7_listener($event) {
          return ctx.onUpload($event);
        })("fileName", function PetPassportComponent_Template_app_upload_document_fileName_7_listener($event) {
          return ctx.filename($event);
        });
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](8, "div", 7)(9, "button", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵlistener"]("click", function PetPassportComponent_Template_button_click_9_listener() {
          return ctx.onNoClick();
        });
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](10, "Cancel");
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](11, "button", 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵlistener"]("click", function PetPassportComponent_Template_button_click_11_listener() {
          return ctx.add();
        });
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](12, "Save ");
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]()()();
      }
      if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("ngIf", ctx.passportData);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("form", ctx.form)("controller", ctx.controlls["passportId"]);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("form", ctx.form);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("disabled", ctx.form.invalid);
      }
    },
    dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_8__.NgIf, _components_controllers_input_input_component__WEBPACK_IMPORTED_MODULE_3__.InputComponent, _components_controllers_upload_document_upload_document_component__WEBPACK_IMPORTED_MODULE_4__.UploadDocumentComponent, _angular_material_button__WEBPACK_IMPORTED_MODULE_9__.MatButton, _angular_material_button__WEBPACK_IMPORTED_MODULE_9__.MatMiniFabButton, _angular_material_icon__WEBPACK_IMPORTED_MODULE_10__.MatIcon],
    styles: [".btn-wrapper[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: row;\n  justify-content: right;\n}\n.btn-wrapper[_ngcontent-%COMP%]   button[_ngcontent-%COMP%] {\n  margin: 10px;\n}\n\n.container[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: column;\n  justify-content: space-between;\n  width: 100%;\n  height: 100%;\n}\n.container[_ngcontent-%COMP%]   .row[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: row;\n  width: 100%;\n  height: 25%;\n  padding: 1% 0;\n  padding-left: 4%;\n}\n\n.header[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: row;\n  justify-content: space-between;\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInBldC1wYXNzcG9ydC5jb21wb25lbnQuc2NzcyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTtFQUNJLGFBQUE7RUFDQSxtQkFBQTtFQUNBLHNCQUFBO0FBQ0o7QUFBSTtFQUNJLFlBQUE7QUFFUjs7QUFDQTtFQUNJLGFBQUE7RUFDQSxzQkFBQTtFQUNBLDhCQUFBO0VBQ0EsV0FBQTtFQUNBLFlBQUE7QUFFSjtBQURJO0VBQ0ksYUFBQTtFQUNBLG1CQUFBO0VBQ0EsV0FBQTtFQUNBLFdBQUE7RUFDQSxhQUFBO0VBQ0EsZ0JBQUE7QUFHUjs7QUFBQTtFQUNJLGFBQUE7RUFDQSxtQkFBQTtFQUNBLDhCQUFBO0FBR0oiLCJmaWxlIjoicGV0LXBhc3Nwb3J0LmNvbXBvbmVudC5zY3NzIiwic291cmNlc0NvbnRlbnQiOlsiLmJ0bi13cmFwcGVye1xuICAgIGRpc3BsYXk6IGZsZXg7XG4gICAgZmxleC1kaXJlY3Rpb246IHJvdztcbiAgICBqdXN0aWZ5LWNvbnRlbnQ6IHJpZ2h0O1xuICAgIGJ1dHRvbntcbiAgICAgICAgbWFyZ2luOiAxMHB4O1xuICAgIH1cbn0gXG4uY29udGFpbmVye1xuICAgIGRpc3BsYXk6IGZsZXg7XG4gICAgZmxleC1kaXJlY3Rpb246IGNvbHVtbjtcbiAgICBqdXN0aWZ5LWNvbnRlbnQ6IHNwYWNlLWJldHdlZW47XG4gICAgd2lkdGg6IDEwMCU7XG4gICAgaGVpZ2h0OiAxMDAlO1xuICAgIC5yb3d7XG4gICAgICAgIGRpc3BsYXk6IGZsZXg7XG4gICAgICAgIGZsZXgtZGlyZWN0aW9uOiByb3c7XG4gICAgICAgIHdpZHRoOiAxMDAlO1xuICAgICAgICBoZWlnaHQ6IDI1JTtcbiAgICAgICAgcGFkZGluZzogMSUgMDtcbiAgICAgICAgcGFkZGluZy1sZWZ0OiA0JTtcbiAgICB9XG59XG4uaGVhZGVye1xuICAgIGRpc3BsYXk6IGZsZXg7XG4gICAgZmxleC1kaXJlY3Rpb246IHJvdztcbiAgICBqdXN0aWZ5LWNvbnRlbnQ6IHNwYWNlLWJldHdlZW47XG59Il19 */\n/*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8uL3NyYy9hcHAvbW9kdWxlcy91c2VyLW1hbmFlbWVudC9kb2NzL3BldC1wYXNzcG9ydC9wZXQtcGFzc3BvcnQuY29tcG9uZW50LnNjc3MiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7RUFDSSxhQUFBO0VBQ0EsbUJBQUE7RUFDQSxzQkFBQTtBQUNKO0FBQUk7RUFDSSxZQUFBO0FBRVI7O0FBQ0E7RUFDSSxhQUFBO0VBQ0Esc0JBQUE7RUFDQSw4QkFBQTtFQUNBLFdBQUE7RUFDQSxZQUFBO0FBRUo7QUFESTtFQUNJLGFBQUE7RUFDQSxtQkFBQTtFQUNBLFdBQUE7RUFDQSxXQUFBO0VBQ0EsYUFBQTtFQUNBLGdCQUFBO0FBR1I7O0FBQUE7RUFDSSxhQUFBO0VBQ0EsbUJBQUE7RUFDQSw4QkFBQTtBQUdKO0FBQ0Esd3ZDQUF3dkMiLCJzb3VyY2VzQ29udGVudCI6WyIuYnRuLXdyYXBwZXJ7XG4gICAgZGlzcGxheTogZmxleDtcbiAgICBmbGV4LWRpcmVjdGlvbjogcm93O1xuICAgIGp1c3RpZnktY29udGVudDogcmlnaHQ7XG4gICAgYnV0dG9ue1xuICAgICAgICBtYXJnaW46IDEwcHg7XG4gICAgfVxufSBcbi5jb250YWluZXJ7XG4gICAgZGlzcGxheTogZmxleDtcbiAgICBmbGV4LWRpcmVjdGlvbjogY29sdW1uO1xuICAgIGp1c3RpZnktY29udGVudDogc3BhY2UtYmV0d2VlbjtcbiAgICB3aWR0aDogMTAwJTtcbiAgICBoZWlnaHQ6IDEwMCU7XG4gICAgLnJvd3tcbiAgICAgICAgZGlzcGxheTogZmxleDtcbiAgICAgICAgZmxleC1kaXJlY3Rpb246IHJvdztcbiAgICAgICAgd2lkdGg6IDEwMCU7XG4gICAgICAgIGhlaWdodDogMjUlO1xuICAgICAgICBwYWRkaW5nOiAxJSAwO1xuICAgICAgICBwYWRkaW5nLWxlZnQ6IDQlO1xuICAgIH1cbn1cbi5oZWFkZXJ7XG4gICAgZGlzcGxheTogZmxleDtcbiAgICBmbGV4LWRpcmVjdGlvbjogcm93O1xuICAgIGp1c3RpZnktY29udGVudDogc3BhY2UtYmV0d2Vlbjtcbn0iXSwic291cmNlUm9vdCI6IiJ9 */"]
  });
}


/***/ }),

/***/ 7522:
/*!********************************************************************************************!*\
  !*** ./src/app/modules/user-manaement/docs/pet-registration/pet-registration.component.ts ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "PetRegistrationComponent": () => (/* binding */ PetRegistrationComponent)
/* harmony export */ });
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/forms */ 69542);
/* harmony import */ var app_components_controllers_confirmation_dialog_confirmation_dialog_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! app/components/controllers/confirmation-dialog/confirmation-dialog.component */ 81500);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/core */ 86839);
/* harmony import */ var app_services_pet_service__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! app/services/pet.service */ 59976);
/* harmony import */ var _angular_material_dialog__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/material/dialog */ 67486);
/* harmony import */ var app_services_loader_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! app/services/loader.service */ 38555);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @angular/common */ 86477);
/* harmony import */ var _components_controllers_input_input_component__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../../components/controllers/input/input.component */ 30867);
/* harmony import */ var _components_controllers_upload_document_upload_document_component__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../../components/controllers/upload-document/upload-document.component */ 15698);
/* harmony import */ var _angular_material_button__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @angular/material/button */ 83677);
/* harmony import */ var _angular_material_icon__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @angular/material/icon */ 69941);












function PetRegistrationComponent_button_3_Template(rf, ctx) {
  if (rf & 1) {
    const _r2 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "button", 10);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵlistener"]("click", function PetRegistrationComponent_button_3_Template_button_click_0_listener() {
      _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵrestoreView"](_r2);
      const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵresetView"](ctx_r1.delete());
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](1, "mat-icon");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](2, "delete");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]()();
  }
}
class PetRegistrationComponent {
  constructor(fb, petService, dialogRef, dialog, loader) {
    this.fb = fb;
    this.petService = petService;
    this.dialogRef = dialogRef;
    this.dialog = dialog;
    this.loader = loader;
    this.createForm();
    this.createControlls();
    this.get();
  }
  get() {
    let data = {
      petId: sessionStorage.getItem('petId'),
      type: 'PetRegistration',
      userId: sessionStorage.getItem('petParentId')
    };
    this.petService.getPetDoc(data).subscribe(res => {
      if (res.length > 0) {
        this.registratonData = res[0];
        // let formDta = new FormData();
        // formDta.append('files', this.microChipData['docPath']);
        this.form.get('documentName').setValue(this.registratonData['docName']);
        if (this.registratonData['docPath']) {
          this.form.get('document').setValue(this.registratonData['docPath']);
        }
      }
    });
  }
  onUpload(event) {
    this.form.get('document').setValue(event);
  }
  createForm() {
    this.form = this.fb.group({
      documentName: ['', [_angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.required]],
      // idNumber : ['',[Validators.required]],
      document: ['']
    });
  }
  createControlls() {
    this.controlls = {
      documentName: {
        id: "documentName",
        name: 'documentName',
        label: "Document Name",
        required: true,
        type: "text"
      },
      document: {
        id: "document",
        name: 'document',
        label: "Document",
        placeholder: "Document",
        required: true,
        type: "text"
      }
    };
  }
  add() {
    // this.petParentId = sessionStorage.getItem('petParentId');
    // this.petId = sessionStorage.getItem('petId')
    let json = this.form.value;
    console.log(json);
    // sessionStorage.getItem('petParentId');
    // sessionStorage.getItem('petId')
    let data = {
      petId: sessionStorage.getItem('petId'),
      type: 'PetRegistration',
      docNumber: 0,
      userId: sessionStorage.getItem('petParentId'),
      docName: json['documentName'],
      validTill: 0,
      document: json['document']
    };
    // PetService
    if (this.registratonData) {
      if (json['document']) {
        data['fileDelete'] = false;
      } else {
        data['fileDelete'] = true;
      }
      data['docId'] = this.registratonData['id'];
      this.loader.showLoader();
      this.petService.editPetDoc(data).subscribe(res => {
        console.log(res);
        this.loader.hideLoader();
        this.dialogRef.close();
      });
    } else {
      this.loader.showLoader();
      this.petService.addPetDoc(data).subscribe(res => {
        this.petService.petDocsTemplateData[4]['icon'] = './assets/icons/pet-history/registration.svg';
        this.loader.hideLoader();
        this.dialogRef.close();
        console.log(res);
      });
    }
  }
  onNoClick() {
    this.dialogRef.close();
  }
  delete() {
    const dialogRef = this.dialog.open(app_components_controllers_confirmation_dialog_confirmation_dialog_component__WEBPACK_IMPORTED_MODULE_0__.ConfirmationDialogComponent, {
      width: '400px',
      data: {
        message: 'Are you sure you want to Delete?'
      }
    });
    dialogRef.afterClosed().subscribe(result => {
      if (result) {
        this.loader.showLoader();
        this.petService.deletePetDoc(sessionStorage.getItem('petParentId'), this.registratonData['id']).subscribe(res => {
          this.petService.petDocsTemplateData[4]['icon'] = './assets/icons/grey-pet-history/registration.svg';
          console.log(res);
          this.createForm();
          this.loader.hideLoader();
          this.dialogRef.close();
        }, error => {
          this.loader.hideLoader();
          this.dialogRef.close();
        });
      } else {
        console.log("");
      }
    });
  }
  static #_ = this.ɵfac = function PetRegistrationComponent_Factory(t) {
    return new (t || PetRegistrationComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](_angular_forms__WEBPACK_IMPORTED_MODULE_6__.FormBuilder), _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](app_services_pet_service__WEBPACK_IMPORTED_MODULE_1__.PetService), _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](_angular_material_dialog__WEBPACK_IMPORTED_MODULE_7__.MatDialogRef), _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](_angular_material_dialog__WEBPACK_IMPORTED_MODULE_7__.MatDialog), _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](app_services_loader_service__WEBPACK_IMPORTED_MODULE_2__.LoaderService));
  };
  static #_2 = this.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdefineComponent"]({
    type: PetRegistrationComponent,
    selectors: [["app-pet-registration"]],
    inputs: {
      petId: "petId",
      petParentId: "petParentId"
    },
    decls: 13,
    vars: 5,
    consts: [[1, "header"], ["mat-dialog-title", "", 2, "align-items", "center"], ["mat-mini-fab", "", "color", "warn", 3, "click", 4, "ngIf"], ["mat-dialog-content", ""], [1, "row"], [2, "width", "100%", 3, "form", "controller"], [3, "form", "onSelect"], [1, "btn-wrapper"], ["mat-stroked-button", "", "color", "primary", 3, "click"], ["mat-stroked-button", "", "color", "primary", 3, "disabled", "click"], ["mat-mini-fab", "", "color", "warn", 3, "click"]],
    template: function PetRegistrationComponent_Template(rf, ctx) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "div", 0)(1, "h1", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](2, "Pet Registration");
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](3, PetRegistrationComponent_button_3_Template, 3, 0, "button", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](4, "div", 3)(5, "div", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelement"](6, "app-input", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](7, "app-upload-document", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵlistener"]("onSelect", function PetRegistrationComponent_Template_app_upload_document_onSelect_7_listener($event) {
          return ctx.onUpload($event);
        });
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](8, "div", 7)(9, "button", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵlistener"]("click", function PetRegistrationComponent_Template_button_click_9_listener() {
          return ctx.onNoClick();
        });
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](10, "Cancel");
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](11, "button", 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵlistener"]("click", function PetRegistrationComponent_Template_button_click_11_listener() {
          return ctx.add();
        });
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](12, "Save");
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]()()();
      }
      if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("ngIf", ctx.registratonData);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("form", ctx.form)("controller", ctx.controlls["documentName"]);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("form", ctx.form);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("disabled", ctx.form.invalid);
      }
    },
    dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_8__.NgIf, _components_controllers_input_input_component__WEBPACK_IMPORTED_MODULE_3__.InputComponent, _components_controllers_upload_document_upload_document_component__WEBPACK_IMPORTED_MODULE_4__.UploadDocumentComponent, _angular_material_button__WEBPACK_IMPORTED_MODULE_9__.MatButton, _angular_material_button__WEBPACK_IMPORTED_MODULE_9__.MatMiniFabButton, _angular_material_icon__WEBPACK_IMPORTED_MODULE_10__.MatIcon],
    styles: [".btn-wrapper[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: row;\n  justify-content: right;\n}\n.btn-wrapper[_ngcontent-%COMP%]   button[_ngcontent-%COMP%] {\n  margin: 10px;\n}\n\n.container[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: column;\n  justify-content: space-between;\n  width: 100%;\n  height: 100%;\n}\n.container[_ngcontent-%COMP%]   .row[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: row;\n  width: 100%;\n  height: 25%;\n  padding: 1% 0;\n  padding-left: 4%;\n}\n\n.header[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: row;\n  justify-content: space-between;\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInBldC1yZWdpc3RyYXRpb24uY29tcG9uZW50LnNjc3MiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7RUFDSSxhQUFBO0VBQ0EsbUJBQUE7RUFDQSxzQkFBQTtBQUNKO0FBQUk7RUFDSSxZQUFBO0FBRVI7O0FBQ0E7RUFDSSxhQUFBO0VBQ0Esc0JBQUE7RUFDQSw4QkFBQTtFQUNBLFdBQUE7RUFDQSxZQUFBO0FBRUo7QUFESTtFQUNJLGFBQUE7RUFDQSxtQkFBQTtFQUNBLFdBQUE7RUFDQSxXQUFBO0VBQ0EsYUFBQTtFQUNBLGdCQUFBO0FBR1I7O0FBQ0E7RUFDSSxhQUFBO0VBQ0EsbUJBQUE7RUFDQSw4QkFBQTtBQUVKIiwiZmlsZSI6InBldC1yZWdpc3RyYXRpb24uY29tcG9uZW50LnNjc3MiLCJzb3VyY2VzQ29udGVudCI6WyIuYnRuLXdyYXBwZXJ7XG4gICAgZGlzcGxheTogZmxleDtcbiAgICBmbGV4LWRpcmVjdGlvbjogcm93O1xuICAgIGp1c3RpZnktY29udGVudDogcmlnaHQ7XG4gICAgYnV0dG9ue1xuICAgICAgICBtYXJnaW46IDEwcHg7XG4gICAgfVxufSBcbi5jb250YWluZXJ7XG4gICAgZGlzcGxheTogZmxleDtcbiAgICBmbGV4LWRpcmVjdGlvbjogY29sdW1uO1xuICAgIGp1c3RpZnktY29udGVudDogc3BhY2UtYmV0d2VlbjtcbiAgICB3aWR0aDogMTAwJTtcbiAgICBoZWlnaHQ6IDEwMCU7XG4gICAgLnJvd3tcbiAgICAgICAgZGlzcGxheTogZmxleDtcbiAgICAgICAgZmxleC1kaXJlY3Rpb246IHJvdztcbiAgICAgICAgd2lkdGg6IDEwMCU7XG4gICAgICAgIGhlaWdodDogMjUlO1xuICAgICAgICBwYWRkaW5nOiAxJSAwO1xuICAgICAgICBwYWRkaW5nLWxlZnQ6IDQlO1xuICAgIH1cbn1cblxuLmhlYWRlcntcbiAgICBkaXNwbGF5OiBmbGV4O1xuICAgIGZsZXgtZGlyZWN0aW9uOiByb3c7XG4gICAganVzdGlmeS1jb250ZW50OiBzcGFjZS1iZXR3ZWVuO1xufSJdfQ== */\n/*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8uL3NyYy9hcHAvbW9kdWxlcy91c2VyLW1hbmFlbWVudC9kb2NzL3BldC1yZWdpc3RyYXRpb24vcGV0LXJlZ2lzdHJhdGlvbi5jb21wb25lbnQuc2NzcyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTtFQUNJLGFBQUE7RUFDQSxtQkFBQTtFQUNBLHNCQUFBO0FBQ0o7QUFBSTtFQUNJLFlBQUE7QUFFUjs7QUFDQTtFQUNJLGFBQUE7RUFDQSxzQkFBQTtFQUNBLDhCQUFBO0VBQ0EsV0FBQTtFQUNBLFlBQUE7QUFFSjtBQURJO0VBQ0ksYUFBQTtFQUNBLG1CQUFBO0VBQ0EsV0FBQTtFQUNBLFdBQUE7RUFDQSxhQUFBO0VBQ0EsZ0JBQUE7QUFHUjs7QUFDQTtFQUNJLGFBQUE7RUFDQSxtQkFBQTtFQUNBLDhCQUFBO0FBRUo7QUFDQSx3d0NBQXd3QyIsInNvdXJjZXNDb250ZW50IjpbIi5idG4td3JhcHBlcntcbiAgICBkaXNwbGF5OiBmbGV4O1xuICAgIGZsZXgtZGlyZWN0aW9uOiByb3c7XG4gICAganVzdGlmeS1jb250ZW50OiByaWdodDtcbiAgICBidXR0b257XG4gICAgICAgIG1hcmdpbjogMTBweDtcbiAgICB9XG59IFxuLmNvbnRhaW5lcntcbiAgICBkaXNwbGF5OiBmbGV4O1xuICAgIGZsZXgtZGlyZWN0aW9uOiBjb2x1bW47XG4gICAganVzdGlmeS1jb250ZW50OiBzcGFjZS1iZXR3ZWVuO1xuICAgIHdpZHRoOiAxMDAlO1xuICAgIGhlaWdodDogMTAwJTtcbiAgICAucm93e1xuICAgICAgICBkaXNwbGF5OiBmbGV4O1xuICAgICAgICBmbGV4LWRpcmVjdGlvbjogcm93O1xuICAgICAgICB3aWR0aDogMTAwJTtcbiAgICAgICAgaGVpZ2h0OiAyNSU7XG4gICAgICAgIHBhZGRpbmc6IDElIDA7XG4gICAgICAgIHBhZGRpbmctbGVmdDogNCU7XG4gICAgfVxufVxuXG4uaGVhZGVye1xuICAgIGRpc3BsYXk6IGZsZXg7XG4gICAgZmxleC1kaXJlY3Rpb246IHJvdztcbiAgICBqdXN0aWZ5LWNvbnRlbnQ6IHNwYWNlLWJldHdlZW47XG59Il0sInNvdXJjZVJvb3QiOiIifQ== */"]
  });
}


/***/ }),

/***/ 85808:
/*!********************************************************************************************************!*\
  !*** ./src/app/modules/user-manaement/docs/recolation-certificate/recolation-certificate.component.ts ***!
  \********************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "RecolationCertificateComponent": () => (/* binding */ RecolationCertificateComponent)
/* harmony export */ });
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/forms */ 69542);
/* harmony import */ var _angular_material_dialog__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/material/dialog */ 67486);
/* harmony import */ var app_components_controllers_confirmation_dialog_confirmation_dialog_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! app/components/controllers/confirmation-dialog/confirmation-dialog.component */ 81500);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/core */ 86839);
/* harmony import */ var app_services_pet_service__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! app/services/pet.service */ 59976);
/* harmony import */ var app_services_loader_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! app/services/loader.service */ 38555);
/* harmony import */ var _components_controllers_input_input_component__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../../components/controllers/input/input.component */ 30867);
/* harmony import */ var _components_controllers_upload_document_upload_document_component__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../../components/controllers/upload-document/upload-document.component */ 15698);
/* harmony import */ var _angular_material_button__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @angular/material/button */ 83677);
/* harmony import */ var _angular_material_icon__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @angular/material/icon */ 69941);












class RecolationCertificateComponent {
  constructor(fb, dialogRef, data, petService, dialog, loader) {
    this.fb = fb;
    this.dialogRef = dialogRef;
    this.data = data;
    this.petService = petService;
    this.dialog = dialog;
    this.loader = loader;
    this.createForm();
    this.createControlls();
  }
  ngOnInit() {
    if (this.data['record']) {
      this.edit();
    }
  }
  edit() {
    let el = this.data['record'];
    this.form = this.fb.group({
      id: [el['id']],
      uploadedOn: [el['createdAt'] ? new Date(el['createdAt']) : ''],
      documentName: [el['docName'], _angular_forms__WEBPACK_IMPORTED_MODULE_5__.Validators.required],
      document: [el['docPath'] ? el['docPath'] : null]
    });
  }
  onUpload(event) {
    this.form.get('document').setValue(event);
  }
  createForm() {
    this.form = this.fb.group({
      documentName: ['', [_angular_forms__WEBPACK_IMPORTED_MODULE_5__.Validators.required]],
      // idNumber : ['',[Validators.required]],
      document: ['']
    });
  }
  createControlls() {
    this.controlls = {
      documentName: {
        id: "documentName",
        name: 'documentName',
        label: "Document Name",
        required: true,
        type: "text"
      },
      document: {
        id: "document",
        name: 'document',
        label: "Document",
        placeholder: "Document",
        required: true,
        type: "text"
      }
    };
  }
  add() {
    // this.petParentId = sessionStorage.getItem('petParentId');
    // this.petId = sessionStorage.getItem('petId')
    let json = this.form.value;
    console.log(json);
    // sessionStorage.getItem('petParentId');
    // sessionStorage.getItem('petId')
    let data = {
      petId: sessionStorage.getItem('petId'),
      type: 'RelocationCertificate-Details',
      docNumber: 0,
      userId: sessionStorage.getItem('petParentId'),
      docName: json['documentName'],
      validTill: 0,
      document: json['document']
    };
    // PetService
    if (this.data['record']) {
      data['docId'] = this.data['record']['id'];
      if (json['document']) {
        data['fileDelete'] = false;
      } else {
        data['fileDelete'] = true;
      }
      this.loader.showLoader();
      this.petService.editPetDoc(data).subscribe(res => {
        this.loader.hideLoader();
        this.dialogRef.close();
        console.log(res);
      });
    } else {
      this.loader.showLoader();
      this.petService.addPetDoc(data).subscribe(res => {
        this.petService.petDocsTemplateData[7]['icon'] = './assets/icons/pet-history/relocation.svg';
        let data1 = {
          petId: sessionStorage.getItem('petId'),
          type: 'Relocation_Certificate',
          userId: sessionStorage.getItem('petParentId')
        };
        this.petService.getPetDoc(data1).subscribe(res => {
          if (res.length > 0) {
            res.forEach(el => {
              // let form = this.fb.group({
              //   id : [el['id']],
              //   uploadedOn : [el['createdAt']?new Date(el['createdAt']):''],
              //   documentName : [el['docName'],Validators.required],
              //   document : [el['docPath'] ? el['docPath']:null]
              // })
              // this.data['records'] = this.fb.array([]);
            });
          }
        });
        this.loader.hideLoader();
        this.dialogRef.close();
        console.log(res);
      });
    }
  }
  onNoClick() {
    this.dialogRef.close();
  }
  delete() {
    const dialogRef = this.dialog.open(app_components_controllers_confirmation_dialog_confirmation_dialog_component__WEBPACK_IMPORTED_MODULE_0__.ConfirmationDialogComponent, {
      width: '400px',
      data: {
        message: 'Are you sure you want to Delete?'
      }
    });
    dialogRef.afterClosed().subscribe(result => {
      if (result) {
        this.loader.showLoader();
        this.petService.deletePetDoc(sessionStorage.getItem('petParentId'), this.relocationData['id']).subscribe(res => {
          console.log(res);
          this.createForm();
          this.loader.hideLoader();
        }, error => {
          this.loader.hideLoader();
        });
      } else {
        console.log("");
      }
    });
  }
  static #_ = this.ɵfac = function RecolationCertificateComponent_Factory(t) {
    return new (t || RecolationCertificateComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵdirectiveInject"](_angular_forms__WEBPACK_IMPORTED_MODULE_5__.FormBuilder), _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵdirectiveInject"](_angular_material_dialog__WEBPACK_IMPORTED_MODULE_7__.MatDialogRef), _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵdirectiveInject"](_angular_material_dialog__WEBPACK_IMPORTED_MODULE_7__.MAT_DIALOG_DATA), _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵdirectiveInject"](app_services_pet_service__WEBPACK_IMPORTED_MODULE_1__.PetService), _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵdirectiveInject"](_angular_material_dialog__WEBPACK_IMPORTED_MODULE_7__.MatDialog), _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵdirectiveInject"](app_services_loader_service__WEBPACK_IMPORTED_MODULE_2__.LoaderService));
  };
  static #_2 = this.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵdefineComponent"]({
    type: RecolationCertificateComponent,
    selectors: [["app-recolation-certificate"]],
    inputs: {
      petId: "petId",
      petParentId: "petParentId"
    },
    decls: 14,
    vars: 4,
    consts: [[1, "header"], ["mat-dialog-title", "", 2, "align-items", "center"], [3, "click"], ["mat-dialog-content", ""], [1, "row"], [2, "width", "100%", 3, "form", "controller"], [3, "form", "onSelect"], [1, "btn-wrapper"], ["mat-stroked-button", "", "color", "primary", 3, "click"], ["mat-stroked-button", "", "color", "primary", 3, "disabled", "click"]],
    template: function RecolationCertificateComponent_Template(rf, ctx) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementStart"](0, "div", 0)(1, "h1", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵtext"](2, "Relocation Certificate");
        _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementStart"](3, "mat-icon", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵlistener"]("click", function RecolationCertificateComponent_Template_mat_icon_click_3_listener() {
          return ctx.onNoClick();
        });
        _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵtext"](4, "close");
        _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementEnd"]()();
        _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementStart"](5, "div", 3)(6, "div", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelement"](7, "app-input", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementStart"](8, "app-upload-document", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵlistener"]("onSelect", function RecolationCertificateComponent_Template_app_upload_document_onSelect_8_listener($event) {
          return ctx.onUpload($event);
        });
        _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementStart"](9, "div", 7)(10, "button", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵlistener"]("click", function RecolationCertificateComponent_Template_button_click_10_listener() {
          return ctx.onNoClick();
        });
        _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵtext"](11, "Cancel");
        _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementStart"](12, "button", 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵlistener"]("click", function RecolationCertificateComponent_Template_button_click_12_listener() {
          return ctx.add();
        });
        _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵtext"](13, "Save");
        _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵelementEnd"]()()();
      }
      if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵadvance"](7);
        _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵproperty"]("form", ctx.form)("controller", ctx.controlls["documentName"]);
        _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵproperty"]("form", ctx.form);
        _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_6__["ɵɵproperty"]("disabled", ctx.form.invalid);
      }
    },
    dependencies: [_components_controllers_input_input_component__WEBPACK_IMPORTED_MODULE_3__.InputComponent, _components_controllers_upload_document_upload_document_component__WEBPACK_IMPORTED_MODULE_4__.UploadDocumentComponent, _angular_material_button__WEBPACK_IMPORTED_MODULE_8__.MatButton, _angular_material_icon__WEBPACK_IMPORTED_MODULE_9__.MatIcon],
    styles: [".btn-wrapper[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: row;\n  justify-content: right;\n}\n.btn-wrapper[_ngcontent-%COMP%]   button[_ngcontent-%COMP%] {\n  margin: 10px;\n}\n\n.container[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: column;\n  justify-content: space-between;\n  width: 100%;\n  height: 100%;\n}\n.container[_ngcontent-%COMP%]   .row[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: row;\n  width: 100%;\n  height: 25%;\n  padding: 1% 0;\n  padding-left: 4%;\n}\n\n.header[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: row;\n  justify-content: space-between;\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInJlY29sYXRpb24tY2VydGlmaWNhdGUuY29tcG9uZW50LnNjc3MiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7RUFDSSxhQUFBO0VBQ0EsbUJBQUE7RUFDQSxzQkFBQTtBQUNKO0FBQUk7RUFDSSxZQUFBO0FBRVI7O0FBQ0E7RUFDSSxhQUFBO0VBQ0Esc0JBQUE7RUFDQSw4QkFBQTtFQUNBLFdBQUE7RUFDQSxZQUFBO0FBRUo7QUFESTtFQUNJLGFBQUE7RUFDQSxtQkFBQTtFQUNBLFdBQUE7RUFDQSxXQUFBO0VBQ0EsYUFBQTtFQUNBLGdCQUFBO0FBR1I7O0FBQ0E7RUFDSSxhQUFBO0VBQ0EsbUJBQUE7RUFDQSw4QkFBQTtBQUVKIiwiZmlsZSI6InJlY29sYXRpb24tY2VydGlmaWNhdGUuY29tcG9uZW50LnNjc3MiLCJzb3VyY2VzQ29udGVudCI6WyIuYnRuLXdyYXBwZXJ7XG4gICAgZGlzcGxheTogZmxleDtcbiAgICBmbGV4LWRpcmVjdGlvbjogcm93O1xuICAgIGp1c3RpZnktY29udGVudDogcmlnaHQ7XG4gICAgYnV0dG9ue1xuICAgICAgICBtYXJnaW46IDEwcHg7XG4gICAgfVxufSBcbi5jb250YWluZXJ7XG4gICAgZGlzcGxheTogZmxleDtcbiAgICBmbGV4LWRpcmVjdGlvbjogY29sdW1uO1xuICAgIGp1c3RpZnktY29udGVudDogc3BhY2UtYmV0d2VlbjtcbiAgICB3aWR0aDogMTAwJTtcbiAgICBoZWlnaHQ6IDEwMCU7XG4gICAgLnJvd3tcbiAgICAgICAgZGlzcGxheTogZmxleDtcbiAgICAgICAgZmxleC1kaXJlY3Rpb246IHJvdztcbiAgICAgICAgd2lkdGg6IDEwMCU7XG4gICAgICAgIGhlaWdodDogMjUlO1xuICAgICAgICBwYWRkaW5nOiAxJSAwO1xuICAgICAgICBwYWRkaW5nLWxlZnQ6IDQlO1xuICAgIH1cbn1cblxuLmhlYWRlcntcbiAgICBkaXNwbGF5OiBmbGV4O1xuICAgIGZsZXgtZGlyZWN0aW9uOiByb3c7XG4gICAganVzdGlmeS1jb250ZW50OiBzcGFjZS1iZXR3ZWVuO1xufSJdfQ== */\n/*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8uL3NyYy9hcHAvbW9kdWxlcy91c2VyLW1hbmFlbWVudC9kb2NzL3JlY29sYXRpb24tY2VydGlmaWNhdGUvcmVjb2xhdGlvbi1jZXJ0aWZpY2F0ZS5jb21wb25lbnQuc2NzcyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTtFQUNJLGFBQUE7RUFDQSxtQkFBQTtFQUNBLHNCQUFBO0FBQ0o7QUFBSTtFQUNJLFlBQUE7QUFFUjs7QUFDQTtFQUNJLGFBQUE7RUFDQSxzQkFBQTtFQUNBLDhCQUFBO0VBQ0EsV0FBQTtFQUNBLFlBQUE7QUFFSjtBQURJO0VBQ0ksYUFBQTtFQUNBLG1CQUFBO0VBQ0EsV0FBQTtFQUNBLFdBQUE7RUFDQSxhQUFBO0VBQ0EsZ0JBQUE7QUFHUjs7QUFDQTtFQUNJLGFBQUE7RUFDQSxtQkFBQTtFQUNBLDhCQUFBO0FBRUo7QUFDQSx3eENBQXd4QyIsInNvdXJjZXNDb250ZW50IjpbIi5idG4td3JhcHBlcntcbiAgICBkaXNwbGF5OiBmbGV4O1xuICAgIGZsZXgtZGlyZWN0aW9uOiByb3c7XG4gICAganVzdGlmeS1jb250ZW50OiByaWdodDtcbiAgICBidXR0b257XG4gICAgICAgIG1hcmdpbjogMTBweDtcbiAgICB9XG59IFxuLmNvbnRhaW5lcntcbiAgICBkaXNwbGF5OiBmbGV4O1xuICAgIGZsZXgtZGlyZWN0aW9uOiBjb2x1bW47XG4gICAganVzdGlmeS1jb250ZW50OiBzcGFjZS1iZXR3ZWVuO1xuICAgIHdpZHRoOiAxMDAlO1xuICAgIGhlaWdodDogMTAwJTtcbiAgICAucm93e1xuICAgICAgICBkaXNwbGF5OiBmbGV4O1xuICAgICAgICBmbGV4LWRpcmVjdGlvbjogcm93O1xuICAgICAgICB3aWR0aDogMTAwJTtcbiAgICAgICAgaGVpZ2h0OiAyNSU7XG4gICAgICAgIHBhZGRpbmc6IDElIDA7XG4gICAgICAgIHBhZGRpbmctbGVmdDogNCU7XG4gICAgfVxufVxuXG4uaGVhZGVye1xuICAgIGRpc3BsYXk6IGZsZXg7XG4gICAgZmxleC1kaXJlY3Rpb246IHJvdztcbiAgICBqdXN0aWZ5LWNvbnRlbnQ6IHNwYWNlLWJldHdlZW47XG59Il0sInNvdXJjZVJvb3QiOiIifQ== */"]
  });
}


/***/ }),

/***/ 74668:
/*!******************************************************************************************************************!*\
  !*** ./src/app/modules/user-manaement/docs/relocation-certificate-list/relocation-certificate-list.component.ts ***!
  \******************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "RelocationCertificateListComponent": () => (/* binding */ RelocationCertificateListComponent)
/* harmony export */ });
/* harmony import */ var _recolation_certificate_recolation_certificate_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../recolation-certificate/recolation-certificate.component */ 85808);
/* harmony import */ var app_components_controllers_confirmation_dialog_confirmation_dialog_component__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! app/components/controllers/confirmation-dialog/confirmation-dialog.component */ 81500);
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! moment */ 56908);
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(moment__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/forms */ 69542);
/* harmony import */ var _angular_material_dialog__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @angular/material/dialog */ 67486);
/* harmony import */ var _angular_material_paginator__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @angular/material/paginator */ 86907);
/* harmony import */ var _angular_material_sort__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @angular/material/sort */ 95096);
/* harmony import */ var _angular_material_table__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/material/table */ 83348);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/core */ 86839);
/* harmony import */ var app_services_pet_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! app/services/pet.service */ 59976);
/* harmony import */ var app_services_loader_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! app/services/loader.service */ 38555);
/* harmony import */ var _angular_material_button__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @angular/material/button */ 83677);
/* harmony import */ var _angular_material_menu__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @angular/material/menu */ 89314);
/* harmony import */ var _angular_material_icon__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @angular/material/icon */ 69941);


















function RelocationCertificateListComponent_th_10_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "th", 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](1, " ID. ");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
  }
}
function RelocationCertificateListComponent_td_11_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "td", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const element_r10 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtextInterpolate1"](" ", element_r10.id.substring(0, 6), " ");
  }
}
function RelocationCertificateListComponent_th_13_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "th", 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](1, " Document Name ");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
  }
}
function RelocationCertificateListComponent_td_14_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "td", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const element_r11 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtextInterpolate1"](" ", element_r11.docName, " ");
  }
}
function RelocationCertificateListComponent_th_16_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "th", 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](1, " uploaded On");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
  }
}
function RelocationCertificateListComponent_td_17_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "td", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const element_r12 = ctx.$implicit;
    const ctx_r5 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtextInterpolate1"](" ", ctx_r5.currentUTCDate(element_r12.createdAt), " ");
  }
}
function RelocationCertificateListComponent_th_19_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "th", 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](1, " Action ");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
  }
}
function RelocationCertificateListComponent_td_20_Template(rf, ctx) {
  if (rf & 1) {
    const _r17 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "td", 18)(1, "button", 19);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵlistener"]("click", function RelocationCertificateListComponent_td_20_Template_button_click_1_listener() {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵrestoreView"](_r17);
      const i_r14 = restoredCtx.index;
      const element_r13 = restoredCtx.$implicit;
      const ctx_r16 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵresetView"](ctx_r16.toggle(i_r14, element_r13));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](2, "mat-icon");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](3, "more_vert");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]()();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](4, "mat-menu", null, 20)(6, "button", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵlistener"]("click", function RelocationCertificateListComponent_td_20_Template_button_click_6_listener() {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵrestoreView"](_r17);
      const element_r13 = restoredCtx.$implicit;
      const i_r14 = restoredCtx.index;
      const ctx_r18 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵresetView"](ctx_r18.edit(element_r13, i_r14));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](7, "span", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](8, "Edit");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](9, "mat-icon", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](10, "edit");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]()();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](11, "button", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵlistener"]("click", function RelocationCertificateListComponent_td_20_Template_button_click_11_listener() {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵrestoreView"](_r17);
      const element_r13 = restoredCtx.$implicit;
      const i_r14 = restoredCtx.index;
      const ctx_r19 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵresetView"](ctx_r19.delete(element_r13, i_r14));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](12, "span", 24);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](13, "Delete");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](14, "mat-icon", 25);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](15, "delete");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]()()()();
  }
  if (rf & 2) {
    const _r15 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵreference"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("matMenuTriggerFor", _r15);
  }
}
function RelocationCertificateListComponent_tr_21_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelement"](0, "tr", 26);
  }
}
function RelocationCertificateListComponent_tr_22_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelement"](0, "tr", 27);
  }
}
const _c0 = function () {
  return [5, 10, 25, 100];
};
class RelocationCertificateListComponent {
  constructor(fb, petService, dialogRef, data, dialog, loader) {
    this.fb = fb;
    this.petService = petService;
    this.dialogRef = dialogRef;
    this.data = data;
    this.dialog = dialog;
    this.loader = loader;
    this.displayedColumns = ['id', 'documentName', 'uploadedOn', 'action'];
    this.createForm();
  }
  ngOnInit() {
    this.getrelocaionList();
  }
  ngAfterViewInit() {
    this.recordData.paginator = this.paginator;
  }
  getrelocaionList() {
    let data = {
      petId: sessionStorage.getItem('petId'),
      type: 'RelocationCertificate-Details',
      userId: sessionStorage.getItem('petParentId')
    };
    this.petService.getPetDoc(data).subscribe(res => {
      if (res.length == 0) {
        this.petService.petDocsTemplateData[7]['icon'] = './assets/icons/grey-pet-history/relocation.svg';
      }
      const petParentsArray = Object.values(res);
      this.recordData = new _angular_material_table__WEBPACK_IMPORTED_MODULE_6__.MatTableDataSource(petParentsArray.map(item => ({
        ...item
      })));
      this.recordData.paginator = this.paginator;
      this.recordData.sort = this.sort;
    });
  }
  // get() {
  //   let data = {
  //     petId: sessionStorage.getItem('petId'),
  //     type: 'Relocation_Certificate',
  //     userId: sessionStorage.getItem('petParentId'),
  //   }
  //   this.petService.getPetDoc(data).subscribe((res: Array<any>) => {
  //     if (res.length > 0) {
  //       this.relocationData = res[0];
  //       // let formDta = new FormData();
  //       // formDta.append('files', this.microChipData['docPath']);
  //       this.form.get('documentName').setValue(this.relocationData['docName']);
  //       if(this.relocationData['docPath']){
  //         this.form.get('document').setValue(this.relocationData['docPath'])
  //       }
  //     }
  //   })
  // }
  toggle(i, record) {}
  createForm() {
    this.form = this.fb.group({
      documentName: ['', [_angular_forms__WEBPACK_IMPORTED_MODULE_7__.Validators.required]],
      // documentValidTill : [''],
      // idNumber : ['',[Validators.required]],
      document: ['']
    });
  }
  currentUTCDate(date) {
    if (date) {
      return moment__WEBPACK_IMPORTED_MODULE_2___default().utc(date).local().format("DD-MMM-YYYY");
    } else {
      return 0;
    }
  }
  delete(el, i) {
    const dialogRef = this.dialog.open(app_components_controllers_confirmation_dialog_confirmation_dialog_component__WEBPACK_IMPORTED_MODULE_1__.ConfirmationDialogComponent, {
      width: '400px',
      data: {
        message: 'Are you sure you want to Delete?'
      }
    });
    dialogRef.afterClosed().subscribe(result => {
      if (result) {
        this.loader.showLoader();
        this.petService.deletePetDoc(sessionStorage.getItem('petParentId'), el['id']).subscribe(res => {
          console.log(res);
          this.getrelocaionList();
          this.loader.hideLoader();
        }, error => {
          this.loader.hideLoader();
        });
      } else {
        console.log("");
      }
    });
  }
  edit(el, i) {
    const dialogRef = this.dialog.open(_recolation_certificate_recolation_certificate_component__WEBPACK_IMPORTED_MODULE_0__.RecolationCertificateComponent, {
      data: {
        type: this.data['title'],
        record: el
      }
    });
    dialogRef.afterClosed().subscribe(result => {
      console.log('The dialog was closed');
      console.log(result);
      this.getrelocaionList();
    });
  }
  addRecord() {
    const dialogRef = this.dialog.open(_recolation_certificate_recolation_certificate_component__WEBPACK_IMPORTED_MODULE_0__.RecolationCertificateComponent, {
      data: {
        type: this.data['title']
      }
    });
    dialogRef.afterClosed().subscribe(result => {
      console.log('The dialog was closed');
      this.getrelocaionList();
      console.log(result);
    });
  }
  onNoClick() {
    this.dialogRef.close();
  }
  static #_ = this.ɵfac = function RelocationCertificateListComponent_Factory(t) {
    return new (t || RelocationCertificateListComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](_angular_forms__WEBPACK_IMPORTED_MODULE_7__.FormBuilder), _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](app_services_pet_service__WEBPACK_IMPORTED_MODULE_3__.PetService), _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](_angular_material_dialog__WEBPACK_IMPORTED_MODULE_8__.MatDialogRef), _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](_angular_material_dialog__WEBPACK_IMPORTED_MODULE_8__.MAT_DIALOG_DATA), _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](_angular_material_dialog__WEBPACK_IMPORTED_MODULE_8__.MatDialog), _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](app_services_loader_service__WEBPACK_IMPORTED_MODULE_4__.LoaderService));
  };
  static #_2 = this.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdefineComponent"]({
    type: RelocationCertificateListComponent,
    selectors: [["app-relocation-certificate-list"]],
    viewQuery: function RelocationCertificateListComponent_Query(rf, ctx) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵviewQuery"](_angular_material_paginator__WEBPACK_IMPORTED_MODULE_9__.MatPaginator, 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵviewQuery"](_angular_material_sort__WEBPACK_IMPORTED_MODULE_10__.MatSort, 5);
      }
      if (rf & 2) {
        let _t;
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵloadQuery"]()) && (ctx.paginator = _t.first);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵloadQuery"]()) && (ctx.sort = _t.first);
      }
    },
    decls: 28,
    vars: 7,
    consts: [[1, "header"], ["mat-dialog-title", "", 2, "align-items", "center"], ["mat-mini-fab", "", "color", "warn", 3, "click"], ["mat-dialog-content", "", 1, "record-grid", 2, "min-height", "150px", "height", "400px", "overflow-y", "auto"], [1, "table-wrapper"], ["mat-table", "", 1, "mat-elevation-z8", "mt-2", 3, "dataSource"], ["matColumnDef", "id"], ["mat-header-cell", "", 4, "matHeaderCellDef"], ["mat-cell", "", 4, "matCellDef"], ["matColumnDef", "documentName"], ["matColumnDef", "uploadedOn"], ["matColumnDef", "action"], ["mat-header-row", "", 4, "matHeaderRowDef"], ["mat-row", "", 4, "matRowDef", "matRowDefColumns"], [3, "pageSize", "pageSizeOptions"], [1, "btn"], ["mat-mini-fab", "", "color", "primary", 3, "click"], ["mat-header-cell", ""], ["mat-cell", ""], ["mat-icon-button", "", 3, "matMenuTriggerFor", "click"], ["actionMenu", "matMenu"], ["mat-menu-item", "", 3, "click"], [2, "color", "blue !important"], ["color", "primary"], [2, "color", "hsl(0, 94%, 42%) !important"], ["color", "warn"], ["mat-header-row", ""], ["mat-row", ""]],
    template: function RelocationCertificateListComponent_Template(rf, ctx) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "div", 0)(1, "h1", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](3, "button", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵlistener"]("click", function RelocationCertificateListComponent_Template_button_click_3_listener() {
          return ctx.onNoClick();
        });
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](4, "mat-icon");
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](5, "close");
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]()()();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](6, "div", 3)(7, "div", 4)(8, "table", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementContainerStart"](9, 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](10, RelocationCertificateListComponent_th_10_Template, 2, 0, "th", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](11, RelocationCertificateListComponent_td_11_Template, 2, 1, "td", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementContainerStart"](12, 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](13, RelocationCertificateListComponent_th_13_Template, 2, 0, "th", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](14, RelocationCertificateListComponent_td_14_Template, 2, 1, "td", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementContainerStart"](15, 10);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](16, RelocationCertificateListComponent_th_16_Template, 2, 0, "th", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](17, RelocationCertificateListComponent_td_17_Template, 2, 1, "td", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementContainerStart"](18, 11);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](19, RelocationCertificateListComponent_th_19_Template, 2, 0, "th", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](20, RelocationCertificateListComponent_td_20_Template, 16, 1, "td", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](21, RelocationCertificateListComponent_tr_21_Template, 1, 0, "tr", 12);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](22, RelocationCertificateListComponent_tr_22_Template, 1, 0, "tr", 13);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelement"](23, "mat-paginator", 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]()();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](24, "div", 15)(25, "button", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵlistener"]("click", function RelocationCertificateListComponent_Template_button_click_25_listener() {
          return ctx.addRecord();
        });
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](26, "mat-icon");
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](27, "add");
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]()()();
      }
      if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtextInterpolate1"]("", ctx.data["title"], " List");
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](6);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("dataSource", ctx.recordData);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](13);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("matHeaderRowDef", ctx.displayedColumns);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("matRowDefColumns", ctx.displayedColumns);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("pageSize", 10)("pageSizeOptions", _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpureFunction0"](6, _c0));
      }
    },
    dependencies: [_angular_material_table__WEBPACK_IMPORTED_MODULE_6__.MatTable, _angular_material_table__WEBPACK_IMPORTED_MODULE_6__.MatHeaderCellDef, _angular_material_table__WEBPACK_IMPORTED_MODULE_6__.MatHeaderRowDef, _angular_material_table__WEBPACK_IMPORTED_MODULE_6__.MatColumnDef, _angular_material_table__WEBPACK_IMPORTED_MODULE_6__.MatCellDef, _angular_material_table__WEBPACK_IMPORTED_MODULE_6__.MatRowDef, _angular_material_table__WEBPACK_IMPORTED_MODULE_6__.MatHeaderCell, _angular_material_table__WEBPACK_IMPORTED_MODULE_6__.MatCell, _angular_material_table__WEBPACK_IMPORTED_MODULE_6__.MatHeaderRow, _angular_material_table__WEBPACK_IMPORTED_MODULE_6__.MatRow, _angular_material_button__WEBPACK_IMPORTED_MODULE_11__.MatIconButton, _angular_material_button__WEBPACK_IMPORTED_MODULE_11__.MatMiniFabButton, _angular_material_menu__WEBPACK_IMPORTED_MODULE_12__.MatMenu, _angular_material_menu__WEBPACK_IMPORTED_MODULE_12__.MatMenuItem, _angular_material_menu__WEBPACK_IMPORTED_MODULE_12__.MatMenuTrigger, _angular_material_icon__WEBPACK_IMPORTED_MODULE_13__.MatIcon, _angular_material_paginator__WEBPACK_IMPORTED_MODULE_9__.MatPaginator],
    styles: [".btn[_ngcontent-%COMP%] {\n  display: flex;\n  justify-content: end;\n}\n\n.card[_ngcontent-%COMP%] {\n  padding: 2px;\n}\n\nmat-card-content[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: column;\n  justify-content: center;\n}\n\n.record-grid[_ngcontent-%COMP%] {\n  min-height: 80%;\n  max-height: -moz-fit-content;\n  max-height: fit-content;\n}\n\nmat-form-field[_ngcontent-%COMP%] {\n  display: block;\n  margin: 10px 0;\n}\n\n.header[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: row;\n  justify-content: space-between;\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInJlbG9jYXRpb24tY2VydGlmaWNhdGUtbGlzdC5jb21wb25lbnQuc2NzcyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTtFQUNJLGFBQUE7RUFDQSxvQkFBQTtBQUNKOztBQUVBO0VBQ0ksWUFBQTtBQUNKOztBQUdBO0VBQ0ksYUFBQTtFQUNBLHNCQUFBO0VBQ0EsdUJBQUE7QUFBSjs7QUFJQTtFQUNJLGVBQUE7RUFDQSw0QkFBQTtFQUFBLHVCQUFBO0FBREo7O0FBS0E7RUFDSSxjQUFBO0VBQ0EsY0FBQTtBQUZKOztBQUtBO0VBQ0ksYUFBQTtFQUNBLG1CQUFBO0VBQ0EsOEJBQUE7QUFGSiIsImZpbGUiOiJyZWxvY2F0aW9uLWNlcnRpZmljYXRlLWxpc3QuY29tcG9uZW50LnNjc3MiLCJzb3VyY2VzQ29udGVudCI6WyIuYnRuIHtcbiAgICBkaXNwbGF5OiBmbGV4O1xuICAgIGp1c3RpZnktY29udGVudDogZW5kO1xufVxuXG4uY2FyZCB7XG4gICAgcGFkZGluZzogMnB4O1xuIFxufVxuXG5tYXQtY2FyZC1jb250ZW50IHtcbiAgICBkaXNwbGF5OiBmbGV4O1xuICAgIGZsZXgtZGlyZWN0aW9uOiBjb2x1bW47XG4gICAganVzdGlmeS1jb250ZW50OiBjZW50ZXI7XG4gICAgLy8gYWxpZ24taXRlbXM6IGNlbnRlcjtcblxufVxuLnJlY29yZC1ncmlke1xuICAgIG1pbi1oZWlnaHQ6IDgwJTtcbiAgICBtYXgtaGVpZ2h0OiBmaXQtY29udGVudDtcbn1cblxuXG5tYXQtZm9ybS1maWVsZCB7XG4gICAgZGlzcGxheTogYmxvY2s7XG4gICAgbWFyZ2luOiAxMHB4IDA7XG59XG5cbi5oZWFkZXIge1xuICAgIGRpc3BsYXk6IGZsZXg7XG4gICAgZmxleC1kaXJlY3Rpb246IHJvdztcbiAgICBqdXN0aWZ5LWNvbnRlbnQ6IHNwYWNlLWJldHdlZW47XG59Il19 */\n/*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8uL3NyYy9hcHAvbW9kdWxlcy91c2VyLW1hbmFlbWVudC9kb2NzL3JlbG9jYXRpb24tY2VydGlmaWNhdGUtbGlzdC9yZWxvY2F0aW9uLWNlcnRpZmljYXRlLWxpc3QuY29tcG9uZW50LnNjc3MiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7RUFDSSxhQUFBO0VBQ0Esb0JBQUE7QUFDSjs7QUFFQTtFQUNJLFlBQUE7QUFDSjs7QUFHQTtFQUNJLGFBQUE7RUFDQSxzQkFBQTtFQUNBLHVCQUFBO0FBQUo7O0FBSUE7RUFDSSxlQUFBO0VBQ0EsNEJBQUE7RUFBQSx1QkFBQTtBQURKOztBQUtBO0VBQ0ksY0FBQTtFQUNBLGNBQUE7QUFGSjs7QUFLQTtFQUNJLGFBQUE7RUFDQSxtQkFBQTtFQUNBLDhCQUFBO0FBRko7QUFFQSx3cENBQXdwQyIsInNvdXJjZXNDb250ZW50IjpbIi5idG4ge1xuICAgIGRpc3BsYXk6IGZsZXg7XG4gICAganVzdGlmeS1jb250ZW50OiBlbmQ7XG59XG5cbi5jYXJkIHtcbiAgICBwYWRkaW5nOiAycHg7XG4gXG59XG5cbm1hdC1jYXJkLWNvbnRlbnQge1xuICAgIGRpc3BsYXk6IGZsZXg7XG4gICAgZmxleC1kaXJlY3Rpb246IGNvbHVtbjtcbiAgICBqdXN0aWZ5LWNvbnRlbnQ6IGNlbnRlcjtcbiAgICAvLyBhbGlnbi1pdGVtczogY2VudGVyO1xuXG59XG4ucmVjb3JkLWdyaWR7XG4gICAgbWluLWhlaWdodDogODAlO1xuICAgIG1heC1oZWlnaHQ6IGZpdC1jb250ZW50O1xufVxuXG5cbm1hdC1mb3JtLWZpZWxkIHtcbiAgICBkaXNwbGF5OiBibG9jaztcbiAgICBtYXJnaW46IDEwcHggMDtcbn1cblxuLmhlYWRlciB7XG4gICAgZGlzcGxheTogZmxleDtcbiAgICBmbGV4LWRpcmVjdGlvbjogcm93O1xuICAgIGp1c3RpZnktY29udGVudDogc3BhY2UtYmV0d2Vlbjtcbn0iXSwic291cmNlUm9vdCI6IiJ9 */"]
  });
}


/***/ }),

/***/ 50437:
/*!****************************************************************************************************!*\
  !*** ./src/app/modules/user-manaement/docs/travel-document-list/travel-document-list.component.ts ***!
  \****************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "TravelDocumentListComponent": () => (/* binding */ TravelDocumentListComponent)
/* harmony export */ });
/* harmony import */ var _travel_documents_travel_documents_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../travel-documents/travel-documents.component */ 13157);
/* harmony import */ var app_components_controllers_confirmation_dialog_confirmation_dialog_component__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! app/components/controllers/confirmation-dialog/confirmation-dialog.component */ 81500);
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! moment */ 56908);
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(moment__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/forms */ 69542);
/* harmony import */ var _angular_material_dialog__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @angular/material/dialog */ 67486);
/* harmony import */ var _angular_material_paginator__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @angular/material/paginator */ 86907);
/* harmony import */ var _angular_material_sort__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @angular/material/sort */ 95096);
/* harmony import */ var _angular_material_table__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/material/table */ 83348);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/core */ 86839);
/* harmony import */ var app_services_pet_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! app/services/pet.service */ 59976);
/* harmony import */ var app_services_loader_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! app/services/loader.service */ 38555);
/* harmony import */ var _angular_material_button__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @angular/material/button */ 83677);
/* harmony import */ var _angular_material_menu__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @angular/material/menu */ 89314);
/* harmony import */ var _angular_material_icon__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @angular/material/icon */ 69941);


















function TravelDocumentListComponent_th_10_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "th", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](1, " ID. ");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
  }
}
function TravelDocumentListComponent_td_11_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "td", 19);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const element_r12 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtextInterpolate1"](" ", element_r12.id.substring(0, 6), " ");
  }
}
function TravelDocumentListComponent_th_13_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "th", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](1, " Document Name ");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
  }
}
function TravelDocumentListComponent_td_14_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "td", 19);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const element_r13 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtextInterpolate1"](" ", element_r13.docName, " ");
  }
}
function TravelDocumentListComponent_th_16_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "th", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](1, " uploaded On");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
  }
}
function TravelDocumentListComponent_td_17_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "td", 19);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const element_r14 = ctx.$implicit;
    const ctx_r5 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtextInterpolate1"](" ", ctx_r5.currentUTCDate(element_r14.createdAt), " ");
  }
}
function TravelDocumentListComponent_th_19_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "th", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](1, " Valid Till ");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
  }
}
function TravelDocumentListComponent_td_20_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "td", 19);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const element_r15 = ctx.$implicit;
    const ctx_r7 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtextInterpolate1"](" ", element_r15.validTill ? ctx_r7.currentUTCDate(element_r15.validTill) : "", " ");
  }
}
function TravelDocumentListComponent_th_22_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "th", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](1, " Action ");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
  }
}
function TravelDocumentListComponent_td_23_Template(rf, ctx) {
  if (rf & 1) {
    const _r20 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "td", 19)(1, "button", 20);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵlistener"]("click", function TravelDocumentListComponent_td_23_Template_button_click_1_listener() {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵrestoreView"](_r20);
      const i_r17 = restoredCtx.index;
      const element_r16 = restoredCtx.$implicit;
      const ctx_r19 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵresetView"](ctx_r19.toggle(i_r17, element_r16));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](2, "mat-icon");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](3, "more_vert");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]()();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](4, "mat-menu", null, 21)(6, "button", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵlistener"]("click", function TravelDocumentListComponent_td_23_Template_button_click_6_listener() {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵrestoreView"](_r20);
      const element_r16 = restoredCtx.$implicit;
      const i_r17 = restoredCtx.index;
      const ctx_r21 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵresetView"](ctx_r21.edit(element_r16, i_r17));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](7, "span", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](8, "Edit");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](9, "mat-icon", 24);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](10, "edit");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]()();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](11, "button", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵlistener"]("click", function TravelDocumentListComponent_td_23_Template_button_click_11_listener() {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵrestoreView"](_r20);
      const element_r16 = restoredCtx.$implicit;
      const i_r17 = restoredCtx.index;
      const ctx_r22 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵresetView"](ctx_r22.delete(element_r16, i_r17));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](12, "span", 25);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](13, "Delete");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](14, "mat-icon", 26);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](15, "delete");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]()()()();
  }
  if (rf & 2) {
    const _r18 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵreference"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("matMenuTriggerFor", _r18);
  }
}
function TravelDocumentListComponent_tr_24_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelement"](0, "tr", 27);
  }
}
function TravelDocumentListComponent_tr_25_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelement"](0, "tr", 28);
  }
}
const _c0 = function () {
  return [5, 10, 25, 100];
};
class TravelDocumentListComponent {
  constructor(fb, petService, dialogRef, data, dialog, loader) {
    this.fb = fb;
    this.petService = petService;
    this.dialogRef = dialogRef;
    this.data = data;
    this.dialog = dialog;
    this.loader = loader;
    this.displayedColumns = ['id', 'documentName', 'uploadedOn', 'documentValidTill', 'action'];
    this.createForm();
  }
  ngOnInit() {
    this.gettravelDocumentList();
  }
  ngAfterViewInit() {
    this.recordData.paginator = this.paginator;
  }
  gettravelDocumentList() {
    let data = {
      petId: sessionStorage.getItem('petId'),
      type: 'TravelDocument',
      userId: sessionStorage.getItem('petParentId')
    };
    this.petService.getPetDoc(data).subscribe(res => {
      if (res.length == 0) {
        this.petService.petDocsTemplateData[8]['icon'] = './assets/icons/grey-pet-history/travel docs.svg';
      }
      const petParentsArray = Object.values(res);
      this.recordData = new _angular_material_table__WEBPACK_IMPORTED_MODULE_6__.MatTableDataSource(petParentsArray.map(item => ({
        ...item
      })));
      this.recordData.paginator = this.paginator;
      this.recordData.sort = this.sort;
    });
  }
  toggle(i, record) {}
  createForm() {
    this.form = this.fb.group({
      documentName: ['', [_angular_forms__WEBPACK_IMPORTED_MODULE_7__.Validators.required]],
      documentValidTill: [''],
      // idNumber : ['',[Validators.required]],
      document: ['']
    });
  }
  currentUTCDate(date) {
    if (date) {
      return moment__WEBPACK_IMPORTED_MODULE_2___default().utc(date).local().format("DD-MMM-YYYY");
    } else {
      return 0;
    }
  }
  delete(el, i) {
    const dialogRef = this.dialog.open(app_components_controllers_confirmation_dialog_confirmation_dialog_component__WEBPACK_IMPORTED_MODULE_1__.ConfirmationDialogComponent, {
      width: '400px',
      data: {
        message: 'Are you sure you want to Delete?'
      }
    });
    dialogRef.afterClosed().subscribe(result => {
      if (result) {
        this.loader.showLoader();
        this.petService.deletePetDoc(sessionStorage.getItem('petParentId'), el['id']).subscribe(res => {
          console.log(res);
          this.gettravelDocumentList();
          this.loader.hideLoader();
        }, error => {
          this.loader.hideLoader();
        });
      } else {
        console.log("");
      }
    });
  }
  edit(el, i) {
    const dialogRef = this.dialog.open(_travel_documents_travel_documents_component__WEBPACK_IMPORTED_MODULE_0__.TravelDocumentsComponent, {
      data: {
        type: this.data['title'],
        record: el
      }
    });
    dialogRef.afterClosed().subscribe(result => {
      console.log('The dialog was closed');
      console.log(result);
      this.gettravelDocumentList();
    });
  }
  addRecord() {
    const dialogRef = this.dialog.open(_travel_documents_travel_documents_component__WEBPACK_IMPORTED_MODULE_0__.TravelDocumentsComponent, {
      data: {
        type: this.data['title']
      }
    });
    dialogRef.afterClosed().subscribe(result => {
      console.log('The dialog was closed');
      console.log(result);
      this.gettravelDocumentList();
    });
  }
  onNoClick() {
    this.dialogRef.close();
  }
  static #_ = this.ɵfac = function TravelDocumentListComponent_Factory(t) {
    return new (t || TravelDocumentListComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](_angular_forms__WEBPACK_IMPORTED_MODULE_7__.FormBuilder), _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](app_services_pet_service__WEBPACK_IMPORTED_MODULE_3__.PetService), _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](_angular_material_dialog__WEBPACK_IMPORTED_MODULE_8__.MatDialogRef), _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](_angular_material_dialog__WEBPACK_IMPORTED_MODULE_8__.MAT_DIALOG_DATA), _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](_angular_material_dialog__WEBPACK_IMPORTED_MODULE_8__.MatDialog), _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](app_services_loader_service__WEBPACK_IMPORTED_MODULE_4__.LoaderService));
  };
  static #_2 = this.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdefineComponent"]({
    type: TravelDocumentListComponent,
    selectors: [["app-travel-document-list"]],
    viewQuery: function TravelDocumentListComponent_Query(rf, ctx) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵviewQuery"](_angular_material_paginator__WEBPACK_IMPORTED_MODULE_9__.MatPaginator, 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵviewQuery"](_angular_material_sort__WEBPACK_IMPORTED_MODULE_10__.MatSort, 5);
      }
      if (rf & 2) {
        let _t;
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵloadQuery"]()) && (ctx.paginator = _t.first);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵloadQuery"]()) && (ctx.sort = _t.first);
      }
    },
    decls: 31,
    vars: 7,
    consts: [[1, "header"], ["mat-dialog-title", "", 2, "align-items", "center"], ["mat-mini-fab", "", "color", "warn", 3, "click"], ["mat-dialog-content", "", 1, "record-grid", 2, "min-height", "150px", "height", "400px", "overflow-y", "auto"], [1, "table-wrapper"], ["mat-table", "", 1, "mat-elevation-z8", "mt-2", 3, "dataSource"], ["matColumnDef", "id"], ["mat-header-cell", "", 4, "matHeaderCellDef"], ["mat-cell", "", 4, "matCellDef"], ["matColumnDef", "documentName"], ["matColumnDef", "uploadedOn"], ["matColumnDef", "documentValidTill"], ["matColumnDef", "action"], ["mat-header-row", "", 4, "matHeaderRowDef"], ["mat-row", "", 4, "matRowDef", "matRowDefColumns"], [3, "pageSize", "pageSizeOptions"], [1, "btn"], ["mat-mini-fab", "", "color", "primary", 3, "click"], ["mat-header-cell", ""], ["mat-cell", ""], ["mat-icon-button", "", 3, "matMenuTriggerFor", "click"], ["actionMenu", "matMenu"], ["mat-menu-item", "", 3, "click"], [2, "color", "blue !important"], ["color", "primary"], [2, "color", "hsl(0, 94%, 42%) !important"], ["color", "warn"], ["mat-header-row", ""], ["mat-row", ""]],
    template: function TravelDocumentListComponent_Template(rf, ctx) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "div", 0)(1, "h1", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](3, "button", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵlistener"]("click", function TravelDocumentListComponent_Template_button_click_3_listener() {
          return ctx.onNoClick();
        });
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](4, "mat-icon");
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](5, "close");
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]()()();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](6, "div", 3)(7, "div", 4)(8, "table", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementContainerStart"](9, 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](10, TravelDocumentListComponent_th_10_Template, 2, 0, "th", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](11, TravelDocumentListComponent_td_11_Template, 2, 1, "td", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementContainerStart"](12, 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](13, TravelDocumentListComponent_th_13_Template, 2, 0, "th", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](14, TravelDocumentListComponent_td_14_Template, 2, 1, "td", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementContainerStart"](15, 10);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](16, TravelDocumentListComponent_th_16_Template, 2, 0, "th", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](17, TravelDocumentListComponent_td_17_Template, 2, 1, "td", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementContainerStart"](18, 11);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](19, TravelDocumentListComponent_th_19_Template, 2, 0, "th", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](20, TravelDocumentListComponent_td_20_Template, 2, 1, "td", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementContainerStart"](21, 12);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](22, TravelDocumentListComponent_th_22_Template, 2, 0, "th", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](23, TravelDocumentListComponent_td_23_Template, 16, 1, "td", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](24, TravelDocumentListComponent_tr_24_Template, 1, 0, "tr", 13);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](25, TravelDocumentListComponent_tr_25_Template, 1, 0, "tr", 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelement"](26, "mat-paginator", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]()();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](27, "div", 16)(28, "button", 17);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵlistener"]("click", function TravelDocumentListComponent_Template_button_click_28_listener() {
          return ctx.addRecord();
        });
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](29, "mat-icon");
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](30, "add");
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]()()();
      }
      if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtextInterpolate1"]("", ctx.data["title"], " List");
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](6);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("dataSource", ctx.recordData);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](16);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("matHeaderRowDef", ctx.displayedColumns);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("matRowDefColumns", ctx.displayedColumns);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("pageSize", 10)("pageSizeOptions", _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpureFunction0"](6, _c0));
      }
    },
    dependencies: [_angular_material_table__WEBPACK_IMPORTED_MODULE_6__.MatTable, _angular_material_table__WEBPACK_IMPORTED_MODULE_6__.MatHeaderCellDef, _angular_material_table__WEBPACK_IMPORTED_MODULE_6__.MatHeaderRowDef, _angular_material_table__WEBPACK_IMPORTED_MODULE_6__.MatColumnDef, _angular_material_table__WEBPACK_IMPORTED_MODULE_6__.MatCellDef, _angular_material_table__WEBPACK_IMPORTED_MODULE_6__.MatRowDef, _angular_material_table__WEBPACK_IMPORTED_MODULE_6__.MatHeaderCell, _angular_material_table__WEBPACK_IMPORTED_MODULE_6__.MatCell, _angular_material_table__WEBPACK_IMPORTED_MODULE_6__.MatHeaderRow, _angular_material_table__WEBPACK_IMPORTED_MODULE_6__.MatRow, _angular_material_button__WEBPACK_IMPORTED_MODULE_11__.MatIconButton, _angular_material_button__WEBPACK_IMPORTED_MODULE_11__.MatMiniFabButton, _angular_material_menu__WEBPACK_IMPORTED_MODULE_12__.MatMenu, _angular_material_menu__WEBPACK_IMPORTED_MODULE_12__.MatMenuItem, _angular_material_menu__WEBPACK_IMPORTED_MODULE_12__.MatMenuTrigger, _angular_material_icon__WEBPACK_IMPORTED_MODULE_13__.MatIcon, _angular_material_paginator__WEBPACK_IMPORTED_MODULE_9__.MatPaginator],
    styles: [".btn[_ngcontent-%COMP%] {\n  display: flex;\n  justify-content: end;\n}\n\n.card[_ngcontent-%COMP%] {\n  padding: 2px;\n}\n\nmat-card-content[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: column;\n  justify-content: center;\n}\n\n.record-grid[_ngcontent-%COMP%] {\n  min-height: 80%;\n  max-height: -moz-fit-content;\n  max-height: fit-content;\n}\n\nmat-form-field[_ngcontent-%COMP%] {\n  display: block;\n  margin: 10px 0;\n}\n\n.header[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: row;\n  justify-content: space-between;\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInRyYXZlbC1kb2N1bWVudC1saXN0LmNvbXBvbmVudC5zY3NzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBO0VBQ0ksYUFBQTtFQUNBLG9CQUFBO0FBQ0o7O0FBRUE7RUFDSSxZQUFBO0FBQ0o7O0FBR0E7RUFDSSxhQUFBO0VBQ0Esc0JBQUE7RUFDQSx1QkFBQTtBQUFKOztBQUlBO0VBQ0ksZUFBQTtFQUNBLDRCQUFBO0VBQUEsdUJBQUE7QUFESjs7QUFLQTtFQUNJLGNBQUE7RUFDQSxjQUFBO0FBRko7O0FBS0E7RUFDSSxhQUFBO0VBQ0EsbUJBQUE7RUFDQSw4QkFBQTtBQUZKIiwiZmlsZSI6InRyYXZlbC1kb2N1bWVudC1saXN0LmNvbXBvbmVudC5zY3NzIiwic291cmNlc0NvbnRlbnQiOlsiLmJ0biB7XG4gICAgZGlzcGxheTogZmxleDtcbiAgICBqdXN0aWZ5LWNvbnRlbnQ6IGVuZDtcbn1cblxuLmNhcmQge1xuICAgIHBhZGRpbmc6IDJweDtcbiBcbn1cblxubWF0LWNhcmQtY29udGVudCB7XG4gICAgZGlzcGxheTogZmxleDtcbiAgICBmbGV4LWRpcmVjdGlvbjogY29sdW1uO1xuICAgIGp1c3RpZnktY29udGVudDogY2VudGVyO1xuICAgIC8vIGFsaWduLWl0ZW1zOiBjZW50ZXI7XG5cbn1cbi5yZWNvcmQtZ3JpZHtcbiAgICBtaW4taGVpZ2h0OiA4MCU7XG4gICAgbWF4LWhlaWdodDogZml0LWNvbnRlbnQ7XG59XG5cblxubWF0LWZvcm0tZmllbGQge1xuICAgIGRpc3BsYXk6IGJsb2NrO1xuICAgIG1hcmdpbjogMTBweCAwO1xufVxuXG4uaGVhZGVyIHtcbiAgICBkaXNwbGF5OiBmbGV4O1xuICAgIGZsZXgtZGlyZWN0aW9uOiByb3c7XG4gICAganVzdGlmeS1jb250ZW50OiBzcGFjZS1iZXR3ZWVuO1xufSJdfQ== */\n/*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8uL3NyYy9hcHAvbW9kdWxlcy91c2VyLW1hbmFlbWVudC9kb2NzL3RyYXZlbC1kb2N1bWVudC1saXN0L3RyYXZlbC1kb2N1bWVudC1saXN0LmNvbXBvbmVudC5zY3NzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBO0VBQ0ksYUFBQTtFQUNBLG9CQUFBO0FBQ0o7O0FBRUE7RUFDSSxZQUFBO0FBQ0o7O0FBR0E7RUFDSSxhQUFBO0VBQ0Esc0JBQUE7RUFDQSx1QkFBQTtBQUFKOztBQUlBO0VBQ0ksZUFBQTtFQUNBLDRCQUFBO0VBQUEsdUJBQUE7QUFESjs7QUFLQTtFQUNJLGNBQUE7RUFDQSxjQUFBO0FBRko7O0FBS0E7RUFDSSxhQUFBO0VBQ0EsbUJBQUE7RUFDQSw4QkFBQTtBQUZKO0FBRUEsd29DQUF3b0MiLCJzb3VyY2VzQ29udGVudCI6WyIuYnRuIHtcbiAgICBkaXNwbGF5OiBmbGV4O1xuICAgIGp1c3RpZnktY29udGVudDogZW5kO1xufVxuXG4uY2FyZCB7XG4gICAgcGFkZGluZzogMnB4O1xuIFxufVxuXG5tYXQtY2FyZC1jb250ZW50IHtcbiAgICBkaXNwbGF5OiBmbGV4O1xuICAgIGZsZXgtZGlyZWN0aW9uOiBjb2x1bW47XG4gICAganVzdGlmeS1jb250ZW50OiBjZW50ZXI7XG4gICAgLy8gYWxpZ24taXRlbXM6IGNlbnRlcjtcblxufVxuLnJlY29yZC1ncmlke1xuICAgIG1pbi1oZWlnaHQ6IDgwJTtcbiAgICBtYXgtaGVpZ2h0OiBmaXQtY29udGVudDtcbn1cblxuXG5tYXQtZm9ybS1maWVsZCB7XG4gICAgZGlzcGxheTogYmxvY2s7XG4gICAgbWFyZ2luOiAxMHB4IDA7XG59XG5cbi5oZWFkZXIge1xuICAgIGRpc3BsYXk6IGZsZXg7XG4gICAgZmxleC1kaXJlY3Rpb246IHJvdztcbiAgICBqdXN0aWZ5LWNvbnRlbnQ6IHNwYWNlLWJldHdlZW47XG59Il0sInNvdXJjZVJvb3QiOiIifQ== */"]
  });
}


/***/ }),

/***/ 13157:
/*!********************************************************************************************!*\
  !*** ./src/app/modules/user-manaement/docs/travel-documents/travel-documents.component.ts ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "TravelDocumentsComponent": () => (/* binding */ TravelDocumentsComponent)
/* harmony export */ });
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/forms */ 69542);
/* harmony import */ var _angular_material_dialog__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @angular/material/dialog */ 67486);
/* harmony import */ var app_components_controllers_confirmation_dialog_confirmation_dialog_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! app/components/controllers/confirmation-dialog/confirmation-dialog.component */ 81500);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/core */ 86839);
/* harmony import */ var app_services_pet_service__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! app/services/pet.service */ 59976);
/* harmony import */ var app_services_loader_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! app/services/loader.service */ 38555);
/* harmony import */ var _components_controllers_input_input_component__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../../components/controllers/input/input.component */ 30867);
/* harmony import */ var _components_controllers_date_picker_date_picker_component__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../../components/controllers/date-picker/date-picker.component */ 49582);
/* harmony import */ var _components_controllers_upload_document_upload_document_component__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../../components/controllers/upload-document/upload-document.component */ 15698);
/* harmony import */ var _angular_material_button__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @angular/material/button */ 83677);
/* harmony import */ var _angular_material_icon__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @angular/material/icon */ 69941);













class TravelDocumentsComponent {
  constructor(fb, petService, dialogRef, data, dialog, loader) {
    this.fb = fb;
    this.petService = petService;
    this.dialogRef = dialogRef;
    this.data = data;
    this.dialog = dialog;
    this.loader = loader;
    this.createForm();
    this.createControlls();
  }
  ngOnInit() {
    if (this.data['record']) {
      this.edit();
    }
  }
  edit() {
    let el = this.data['record'];
    this.form = this.fb.group({
      id: [el['id']],
      uploadedOn: [el['createdAt'] ? new Date(el['createdAt']) : ''],
      documentName: [el['docName'], _angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.required],
      documentValidTill: [el['validTill'] ? new Date(el['validTill']) : ''],
      document: [el['docPath'] ? el['docPath'] : null]
    });
  }
  add() {
    // this.petParentId = sessionStorage.getItem('petParentId');
    // this.petId = sessionStorage.getItem('petId')
    let json = this.form.value;
    console.log(json);
    // sessionStorage.getItem('petParentId');
    // sessionStorage.getItem('petId')
    let data = {
      petId: sessionStorage.getItem('petId'),
      type: 'TravelDocument',
      docNumber: 0,
      userId: sessionStorage.getItem('petParentId'),
      docName: json['documentName'],
      validTill: json['documentValidTill'] ? new Date(json['documentValidTill']).getTime() : 0,
      document: json['document']
    };
    // PetService
    if (this.data['record']) {
      data['docId'] = this.data['record']['id'];
      if (json['document']) {
        data['fileDelete'] = false;
      } else {
        data['fileDelete'] = true;
      }
      this.loader.showLoader();
      this.petService.editPetDoc(data).subscribe(res => {
        this.loader.hideLoader();
        this.dialogRef.close();
        console.log(res);
      });
    } else {
      this.loader.showLoader();
      this.petService.addPetDoc(data).subscribe(res => {
        this.petService.petDocsTemplateData[8]['icon'] = './assets/icons/pet-history/travel docs.svg';
        this.loader.hideLoader();
        this.dialogRef.close();
        console.log(res);
      });
    }
  }
  onUpload(event) {
    this.form.get('document').setValue(event);
  }
  createForm() {
    this.form = this.fb.group({
      documentName: ['', [_angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.required]],
      documentValidTill: [''],
      // idNumber : ['',[Validators.required]],
      document: ['']
    });
  }
  createControlls() {
    this.controlls = {
      documentName: {
        id: "documentName",
        name: 'documentName',
        label: "Document Name",
        required: true,
        type: "text"
      },
      documentValidTill: {
        id: "documentValidTill",
        name: 'documentValidTill',
        label: "Document Valid Till",
        placeholder: "Document Valid Till",
        required: true,
        type: "text"
      }
    };
  }
  onNoClick() {
    this.dialogRef.close();
  }
  delete() {
    const dialogRef = this.dialog.open(app_components_controllers_confirmation_dialog_confirmation_dialog_component__WEBPACK_IMPORTED_MODULE_0__.ConfirmationDialogComponent, {
      width: '400px',
      data: {
        message: 'Are you sure you want to Delete?'
      }
    });
    dialogRef.afterClosed().subscribe(result => {
      if (result) {
        this.loader.showLoader();
        this.petService.deletePetDoc(sessionStorage.getItem('petParentId'), this.travelData['id']).subscribe(res => {
          console.log(res);
          this.createForm();
          this.loader.hideLoader();
        }, error => {
          this.loader.hideLoader();
        });
      } else {
        console.log("");
      }
    });
  }
  static #_ = this.ɵfac = function TravelDocumentsComponent_Factory(t) {
    return new (t || TravelDocumentsComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵdirectiveInject"](_angular_forms__WEBPACK_IMPORTED_MODULE_6__.FormBuilder), _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵdirectiveInject"](app_services_pet_service__WEBPACK_IMPORTED_MODULE_1__.PetService), _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵdirectiveInject"](_angular_material_dialog__WEBPACK_IMPORTED_MODULE_8__.MatDialogRef), _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵdirectiveInject"](_angular_material_dialog__WEBPACK_IMPORTED_MODULE_8__.MAT_DIALOG_DATA), _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵdirectiveInject"](_angular_material_dialog__WEBPACK_IMPORTED_MODULE_8__.MatDialog), _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵdirectiveInject"](app_services_loader_service__WEBPACK_IMPORTED_MODULE_2__.LoaderService));
  };
  static #_2 = this.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵdefineComponent"]({
    type: TravelDocumentsComponent,
    selectors: [["app-travel-documents"]],
    inputs: {
      petId: "petId",
      petParentId: "petParentId"
    },
    decls: 16,
    vars: 6,
    consts: [[1, "header"], ["mat-dialog-title", "", 2, "align-items", "center"], ["mat-dialog-content", ""], [1, "row"], [2, "width", "100%", 3, "form", "controller"], [1, "row", 2, "height", "20%"], [3, "form", "onSelect"], [1, "btn-wrapper"], ["mat-stroked-button", "", "color", "primary", 3, "click"], ["mat-stroked-button", "", "color", "primary", 3, "disabled", "click"]],
    template: function TravelDocumentsComponent_Template(rf, ctx) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementStart"](0, "div", 0)(1, "h1", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵtext"](2, "Travel Document");
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementStart"](3, "mat-icon");
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵtext"](4, "close");
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementEnd"]()();
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementStart"](5, "div", 2)(6, "div", 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelement"](7, "app-input", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementStart"](8, "div", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelement"](9, "app-date-picker", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementStart"](10, "app-upload-document", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵlistener"]("onSelect", function TravelDocumentsComponent_Template_app_upload_document_onSelect_10_listener($event) {
          return ctx.onUpload($event);
        });
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementStart"](11, "div", 7)(12, "button", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵlistener"]("click", function TravelDocumentsComponent_Template_button_click_12_listener() {
          return ctx.onNoClick();
        });
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵtext"](13, "Cancel");
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementStart"](14, "button", 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵlistener"]("click", function TravelDocumentsComponent_Template_button_click_14_listener() {
          return ctx.add();
        });
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵtext"](15, "Save");
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementEnd"]()()();
      }
      if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵadvance"](7);
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵproperty"]("form", ctx.form)("controller", ctx.controlls["documentName"]);
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵproperty"]("form", ctx.form)("controller", ctx.controlls["documentValidTill"]);
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵproperty"]("form", ctx.form);
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵadvance"](4);
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵproperty"]("disabled", ctx.form.invalid);
      }
    },
    dependencies: [_components_controllers_input_input_component__WEBPACK_IMPORTED_MODULE_3__.InputComponent, _components_controllers_date_picker_date_picker_component__WEBPACK_IMPORTED_MODULE_4__.DatePickerComponent, _components_controllers_upload_document_upload_document_component__WEBPACK_IMPORTED_MODULE_5__.UploadDocumentComponent, _angular_material_button__WEBPACK_IMPORTED_MODULE_9__.MatButton, _angular_material_icon__WEBPACK_IMPORTED_MODULE_10__.MatIcon],
    styles: [".btn-wrapper[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: row;\n  justify-content: right;\n}\n.btn-wrapper[_ngcontent-%COMP%]   button[_ngcontent-%COMP%] {\n  margin: 10px;\n}\n\n.container[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: column;\n  justify-content: space-between;\n  width: 100%;\n  height: 100%;\n}\n.container[_ngcontent-%COMP%]   .row[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: row;\n  width: 100%;\n  height: 25%;\n  padding: 1% 0;\n  padding-left: 4%;\n}\n\n.header[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: row;\n  justify-content: space-between;\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInRyYXZlbC1kb2N1bWVudHMuY29tcG9uZW50LnNjc3MiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7RUFDSSxhQUFBO0VBQ0EsbUJBQUE7RUFDQSxzQkFBQTtBQUNKO0FBQUk7RUFDSSxZQUFBO0FBRVI7O0FBQ0E7RUFDSSxhQUFBO0VBQ0Esc0JBQUE7RUFDQSw4QkFBQTtFQUNBLFdBQUE7RUFDQSxZQUFBO0FBRUo7QUFESTtFQUNJLGFBQUE7RUFDQSxtQkFBQTtFQUNBLFdBQUE7RUFDQSxXQUFBO0VBQ0EsYUFBQTtFQUNBLGdCQUFBO0FBR1I7O0FBQ0E7RUFDSSxhQUFBO0VBQ0EsbUJBQUE7RUFDQSw4QkFBQTtBQUVKIiwiZmlsZSI6InRyYXZlbC1kb2N1bWVudHMuY29tcG9uZW50LnNjc3MiLCJzb3VyY2VzQ29udGVudCI6WyIuYnRuLXdyYXBwZXJ7XG4gICAgZGlzcGxheTogZmxleDtcbiAgICBmbGV4LWRpcmVjdGlvbjogcm93O1xuICAgIGp1c3RpZnktY29udGVudDogcmlnaHQ7XG4gICAgYnV0dG9ue1xuICAgICAgICBtYXJnaW46IDEwcHg7XG4gICAgfVxufSBcbi5jb250YWluZXJ7XG4gICAgZGlzcGxheTogZmxleDtcbiAgICBmbGV4LWRpcmVjdGlvbjogY29sdW1uO1xuICAgIGp1c3RpZnktY29udGVudDogc3BhY2UtYmV0d2VlbjtcbiAgICB3aWR0aDogMTAwJTtcbiAgICBoZWlnaHQ6IDEwMCU7XG4gICAgLnJvd3tcbiAgICAgICAgZGlzcGxheTogZmxleDtcbiAgICAgICAgZmxleC1kaXJlY3Rpb246IHJvdztcbiAgICAgICAgd2lkdGg6IDEwMCU7XG4gICAgICAgIGhlaWdodDogMjUlO1xuICAgICAgICBwYWRkaW5nOiAxJSAwO1xuICAgICAgICBwYWRkaW5nLWxlZnQ6IDQlO1xuICAgIH1cbn1cblxuLmhlYWRlcntcbiAgICBkaXNwbGF5OiBmbGV4O1xuICAgIGZsZXgtZGlyZWN0aW9uOiByb3c7XG4gICAganVzdGlmeS1jb250ZW50OiBzcGFjZS1iZXR3ZWVuO1xufSJdfQ== */\n/*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8uL3NyYy9hcHAvbW9kdWxlcy91c2VyLW1hbmFlbWVudC9kb2NzL3RyYXZlbC1kb2N1bWVudHMvdHJhdmVsLWRvY3VtZW50cy5jb21wb25lbnQuc2NzcyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTtFQUNJLGFBQUE7RUFDQSxtQkFBQTtFQUNBLHNCQUFBO0FBQ0o7QUFBSTtFQUNJLFlBQUE7QUFFUjs7QUFDQTtFQUNJLGFBQUE7RUFDQSxzQkFBQTtFQUNBLDhCQUFBO0VBQ0EsV0FBQTtFQUNBLFlBQUE7QUFFSjtBQURJO0VBQ0ksYUFBQTtFQUNBLG1CQUFBO0VBQ0EsV0FBQTtFQUNBLFdBQUE7RUFDQSxhQUFBO0VBQ0EsZ0JBQUE7QUFHUjs7QUFDQTtFQUNJLGFBQUE7RUFDQSxtQkFBQTtFQUNBLDhCQUFBO0FBRUo7QUFDQSx3d0NBQXd3QyIsInNvdXJjZXNDb250ZW50IjpbIi5idG4td3JhcHBlcntcbiAgICBkaXNwbGF5OiBmbGV4O1xuICAgIGZsZXgtZGlyZWN0aW9uOiByb3c7XG4gICAganVzdGlmeS1jb250ZW50OiByaWdodDtcbiAgICBidXR0b257XG4gICAgICAgIG1hcmdpbjogMTBweDtcbiAgICB9XG59IFxuLmNvbnRhaW5lcntcbiAgICBkaXNwbGF5OiBmbGV4O1xuICAgIGZsZXgtZGlyZWN0aW9uOiBjb2x1bW47XG4gICAganVzdGlmeS1jb250ZW50OiBzcGFjZS1iZXR3ZWVuO1xuICAgIHdpZHRoOiAxMDAlO1xuICAgIGhlaWdodDogMTAwJTtcbiAgICAucm93e1xuICAgICAgICBkaXNwbGF5OiBmbGV4O1xuICAgICAgICBmbGV4LWRpcmVjdGlvbjogcm93O1xuICAgICAgICB3aWR0aDogMTAwJTtcbiAgICAgICAgaGVpZ2h0OiAyNSU7XG4gICAgICAgIHBhZGRpbmc6IDElIDA7XG4gICAgICAgIHBhZGRpbmctbGVmdDogNCU7XG4gICAgfVxufVxuXG4uaGVhZGVye1xuICAgIGRpc3BsYXk6IGZsZXg7XG4gICAgZmxleC1kaXJlY3Rpb246IHJvdztcbiAgICBqdXN0aWZ5LWNvbnRlbnQ6IHNwYWNlLWJldHdlZW47XG59Il0sInNvdXJjZVJvb3QiOiIifQ== */"]
  });
}


/***/ }),

/***/ 56861:
/*!***************************************************************************************!*\
  !*** ./src/app/modules/user-manaement/document-details/document-details.component.ts ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "DocumentDetailsComponent": () => (/* binding */ DocumentDetailsComponent)
/* harmony export */ });
/* harmony import */ var _angular_material_dialog__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @angular/material/dialog */ 67486);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @angular/core */ 86839);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @angular/forms */ 69542);
/* harmony import */ var app_services_pet_service__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! app/services/pet.service */ 59976);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! @angular/common */ 86477);
/* harmony import */ var _docs_microchip_id_microchip_id_component__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../docs/microchip-id/microchip-id.component */ 79546);
/* harmony import */ var _docs_pet_passport_pet_passport_component__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../docs/pet-passport/pet-passport.component */ 19486);
/* harmony import */ var _docs_neuter_record_neuter_record_component__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../docs/neuter-record/neuter-record.component */ 42752);
/* harmony import */ var _docs_pet_registration_pet_registration_component__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../docs/pet-registration/pet-registration.component */ 7522);
/* harmony import */ var _docs_birth_certificate_birth_certificate_component__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../docs/birth-certificate/birth-certificate.component */ 65921);
/* harmony import */ var _docs_adoption_certificate_adoption_certificate_component__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../docs/adoption-certificate/adoption-certificate.component */ 13285);
/* harmony import */ var _docs_kci_certificate_kci_certificate_component__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../docs/kci-certificate/kci-certificate.component */ 76144);
/* harmony import */ var _docs_pet_innsurance_list_pet_innsurance_list_component__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../docs/pet-innsurance-list/pet-innsurance-list.component */ 1319);
/* harmony import */ var _docs_relocation_certificate_list_relocation_certificate_list_component__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../docs/relocation-certificate-list/relocation-certificate-list.component */ 74668);
/* harmony import */ var _docs_travel_document_list_travel_document_list_component__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../docs/travel-document-list/travel-document-list.component */ 50437);
/* harmony import */ var _docs_other_document_list_other_document_list_component__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../docs/other-document-list/other-document-list.component */ 84594);

















function DocumentDetailsComponent_div_0_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementStart"](0, "div");
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelement"](1, "app-microchip-id", 1);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵproperty"]("petId", ctx_r0.data["petId"])("petParentId", ctx_r0.data["petParentId"]);
  }
}
function DocumentDetailsComponent_div_1_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementStart"](0, "div");
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelement"](1, "app-pet-passport", 1);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵproperty"]("petId", ctx_r1.data["petId"])("petParentId", ctx_r1.data["petParentId"]);
  }
}
function DocumentDetailsComponent_div_2_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementStart"](0, "div");
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelement"](1, "app-pet-innsurance-list");
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementEnd"]();
  }
}
function DocumentDetailsComponent_div_3_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementStart"](0, "div");
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelement"](1, "app-neuter-record", 1);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const ctx_r3 = _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵproperty"]("petId", ctx_r3.data["petId"])("petParentId", ctx_r3.data["petParentId"]);
  }
}
function DocumentDetailsComponent_div_4_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementStart"](0, "div");
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelement"](1, "app-pet-registration", 1);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const ctx_r4 = _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵproperty"]("petId", ctx_r4.data["petId"])("petParentId", ctx_r4.data["petParentId"]);
  }
}
function DocumentDetailsComponent_div_5_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementStart"](0, "div");
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelement"](1, "app-birth-certificate", 1);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const ctx_r5 = _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵproperty"]("petId", ctx_r5.data["petId"])("petParentId", ctx_r5.data["petParentId"]);
  }
}
function DocumentDetailsComponent_div_6_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementStart"](0, "div");
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelement"](1, "app-adoption-certificate", 1);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const ctx_r6 = _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵproperty"]("petId", ctx_r6.data["petId"])("petParentId", ctx_r6.data["petParentId"]);
  }
}
function DocumentDetailsComponent_div_7_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementStart"](0, "div");
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelement"](1, "app-relocation-certificate-list");
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementEnd"]();
  }
}
function DocumentDetailsComponent_div_8_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementStart"](0, "div");
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelement"](1, "app-travel-document-list");
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementEnd"]();
  }
}
function DocumentDetailsComponent_div_9_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementStart"](0, "div");
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelement"](1, "app-kci-certificate", 1);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const ctx_r9 = _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵproperty"]("petId", ctx_r9.data["petId"])("petParentId", ctx_r9.data["petParentId"]);
  }
}
function DocumentDetailsComponent_div_10_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementStart"](0, "div");
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelement"](1, "app-other-document-list");
    _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵelementEnd"]();
  }
}
class DocumentDetailsComponent {
  constructor(dialogRef, fb, petService, data) {
    this.dialogRef = dialogRef;
    this.fb = fb;
    this.petService = petService;
    this.data = data;
  }
  ngOnInit() {
    console.log(this.data);
  }
  onNoClick() {
    this.dialogRef.close();
  }
  static #_ = this.ɵfac = function DocumentDetailsComponent_Factory(t) {
    return new (t || DocumentDetailsComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵdirectiveInject"](_angular_material_dialog__WEBPACK_IMPORTED_MODULE_13__.MatDialogRef), _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵdirectiveInject"](_angular_forms__WEBPACK_IMPORTED_MODULE_14__.FormBuilder), _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵdirectiveInject"](app_services_pet_service__WEBPACK_IMPORTED_MODULE_0__.PetService), _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵdirectiveInject"](_angular_material_dialog__WEBPACK_IMPORTED_MODULE_13__.MAT_DIALOG_DATA));
  };
  static #_2 = this.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵdefineComponent"]({
    type: DocumentDetailsComponent,
    selectors: [["app-document-details"]],
    decls: 11,
    vars: 11,
    consts: [[4, "ngIf"], [3, "petId", "petParentId"]],
    template: function DocumentDetailsComponent_Template(rf, ctx) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtemplate"](0, DocumentDetailsComponent_div_0_Template, 2, 2, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtemplate"](1, DocumentDetailsComponent_div_1_Template, 2, 2, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtemplate"](2, DocumentDetailsComponent_div_2_Template, 2, 0, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtemplate"](3, DocumentDetailsComponent_div_3_Template, 2, 2, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtemplate"](4, DocumentDetailsComponent_div_4_Template, 2, 2, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtemplate"](5, DocumentDetailsComponent_div_5_Template, 2, 2, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtemplate"](6, DocumentDetailsComponent_div_6_Template, 2, 2, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtemplate"](7, DocumentDetailsComponent_div_7_Template, 2, 0, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtemplate"](8, DocumentDetailsComponent_div_8_Template, 2, 0, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtemplate"](9, DocumentDetailsComponent_div_9_Template, 2, 2, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵtemplate"](10, DocumentDetailsComponent_div_10_Template, 2, 0, "div", 0);
      }
      if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵproperty"]("ngIf", ctx.data["title"] == "Microchip ID");
        _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵproperty"]("ngIf", ctx.data["title"] == "Pet Passport");
        _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵproperty"]("ngIf", ctx.data["title"] == "Pet Insurance");
        _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵproperty"]("ngIf", ctx.data["title"] == "Neuter Record");
        _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵproperty"]("ngIf", ctx.data["title"] == "Pet Registration");
        _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵproperty"]("ngIf", ctx.data["title"] == "Birth Certificate");
        _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵproperty"]("ngIf", ctx.data["title"] == "Adoption Certificate");
        _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵproperty"]("ngIf", ctx.data["title"] == "Relocation Certificate");
        _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵproperty"]("ngIf", ctx.data["title"] == "Travel Documents");
        _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵproperty"]("ngIf", ctx.data["title"] == "KCI Certificate");
        _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_12__["ɵɵproperty"]("ngIf", ctx.data["title"] == "Other Documents");
      }
    },
    dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_15__.NgIf, _docs_microchip_id_microchip_id_component__WEBPACK_IMPORTED_MODULE_1__.MicrochipIdComponent, _docs_pet_passport_pet_passport_component__WEBPACK_IMPORTED_MODULE_2__.PetPassportComponent, _docs_neuter_record_neuter_record_component__WEBPACK_IMPORTED_MODULE_3__.NeuterRecordComponent, _docs_pet_registration_pet_registration_component__WEBPACK_IMPORTED_MODULE_4__.PetRegistrationComponent, _docs_birth_certificate_birth_certificate_component__WEBPACK_IMPORTED_MODULE_5__.BirthCertificateComponent, _docs_adoption_certificate_adoption_certificate_component__WEBPACK_IMPORTED_MODULE_6__.AdoptionCertificateComponent, _docs_kci_certificate_kci_certificate_component__WEBPACK_IMPORTED_MODULE_7__.KciCertificateComponent, _docs_pet_innsurance_list_pet_innsurance_list_component__WEBPACK_IMPORTED_MODULE_8__.PetInnsuranceListComponent, _docs_relocation_certificate_list_relocation_certificate_list_component__WEBPACK_IMPORTED_MODULE_9__.RelocationCertificateListComponent, _docs_travel_document_list_travel_document_list_component__WEBPACK_IMPORTED_MODULE_10__.TravelDocumentListComponent, _docs_other_document_list_other_document_list_component__WEBPACK_IMPORTED_MODULE_11__.OtherDocumentListComponent],
    styles: [".header[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: row;\n  justify-content: space-between;\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImRvY3VtZW50LWRldGFpbHMuY29tcG9uZW50LnNjc3MiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7RUFDSSxhQUFBO0VBQ0EsbUJBQUE7RUFDQSw4QkFBQTtBQUNKIiwiZmlsZSI6ImRvY3VtZW50LWRldGFpbHMuY29tcG9uZW50LnNjc3MiLCJzb3VyY2VzQ29udGVudCI6WyIuaGVhZGVye1xuICAgIGRpc3BsYXk6IGZsZXg7XG4gICAgZmxleC1kaXJlY3Rpb246IHJvdztcbiAgICBqdXN0aWZ5LWNvbnRlbnQ6IHNwYWNlLWJldHdlZW47XG59Il19 */\n/*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8uL3NyYy9hcHAvbW9kdWxlcy91c2VyLW1hbmFlbWVudC9kb2N1bWVudC1kZXRhaWxzL2RvY3VtZW50LWRldGFpbHMuY29tcG9uZW50LnNjc3MiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7RUFDSSxhQUFBO0VBQ0EsbUJBQUE7RUFDQSw4QkFBQTtBQUNKO0FBQ0EsNGFBQTRhIiwic291cmNlc0NvbnRlbnQiOlsiLmhlYWRlcntcbiAgICBkaXNwbGF5OiBmbGV4O1xuICAgIGZsZXgtZGlyZWN0aW9uOiByb3c7XG4gICAganVzdGlmeS1jb250ZW50OiBzcGFjZS1iZXR3ZWVuO1xufSJdLCJzb3VyY2VSb290IjoiIn0= */"]
  });
}


/***/ }),

/***/ 96272:
/*!***********************************************************************!*\
  !*** ./src/app/modules/user-manaement/edit-pet/edit-pet.component.ts ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "EditPetComponent": () => (/* binding */ EditPetComponent)
/* harmony export */ });
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @angular/forms */ 69542);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @angular/core */ 86839);
/* harmony import */ var app_services_loader_service__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! app/services/loader.service */ 38555);
/* harmony import */ var app_services_user_management_service__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! app/services/user-management.service */ 32555);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @angular/router */ 86679);
/* harmony import */ var app_services_validations_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! app/services/validations.service */ 27681);
/* harmony import */ var app_services_adoption_management_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! app/services/adoption-management.service */ 54384);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @angular/common */ 86477);
/* harmony import */ var _angular_material_tabs__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @angular/material/tabs */ 12128);
/* harmony import */ var _components_controllers_view_input_view_input_component__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../components/controllers/view-input/view-input.component */ 41951);
/* harmony import */ var _angular_material_button__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! @angular/material/button */ 83677);
/* harmony import */ var _angular_material_icon__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! @angular/material/icon */ 69941);
/* harmony import */ var _angular_material_expansion__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! @angular/material/expansion */ 61884);
/* harmony import */ var _add_pet_add_pet_component__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../add-pet/add-pet.component */ 59932);
/* harmony import */ var _pet_docs_pet_docs_component__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../pet-docs/pet-docs.component */ 42075);
/* harmony import */ var _medicle_records_medicle_records_component__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../medicle-records/medicle-records.component */ 91290);
/* harmony import */ var _reminders_reminders_component__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../reminders/reminders.component */ 80883);
/* harmony import */ var _appointments_appointments_component__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../appointments/appointments.component */ 23705);



















function EditPetComponent_div_0_Template(rf, ctx) {
  if (rf & 1) {
    const _r3 = _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](0, "div", 2)(1, "app-add-pet", 3);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵlistener"]("cancelEvent", function EditPetComponent_div_0_Template_app_add_pet_cancelEvent_1_listener() {
      _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵrestoreView"](_r3);
      const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵresetView"](ctx_r2.cancel());
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]()();
  }
  if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("editData", ctx_r0.data)("petParentId", ctx_r0.petParentId);
  }
}
function EditPetComponent_div_1_div_2_Template(rf, ctx) {
  if (rf & 1) {
    const _r6 = _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](0, "div", 7)(1, "div", 8)(2, "div", 9);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelement"](3, "div", 10);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](4, "div", 11)(5, "button", 12);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵlistener"]("click", function EditPetComponent_div_1_div_2_Template_button_click_5_listener() {
      _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵrestoreView"](_r6);
      const ctx_r5 = _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵnextContext"](2);
      return _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵresetView"](ctx_r5.edit());
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](6, "mat-icon");
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtext"](7, "edit");
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]()();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](8, "button", 13);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵlistener"]("click", function EditPetComponent_div_1_div_2_Template_button_click_8_listener() {
      _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵrestoreView"](_r6);
      const ctx_r7 = _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵnextContext"](2);
      return _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵresetView"](ctx_r7.cancel());
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](9, "mat-icon");
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtext"](10, "close");
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]()()()();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](11, "form", 14)(12, "div", 15);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelement"](13, "img", 16);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](14, "div", 17)(15, "mat-accordion")(16, "mat-expansion-panel", 18)(17, "mat-expansion-panel-header")(18, "mat-panel-title");
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtext"](19, " Pet Details ");
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]()();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](20, "div", 19)(21, "div", 20);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelement"](22, "app-view-input", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](23, "div", 20);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelement"](24, "app-view-input", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](25, "div", 20);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelement"](26, "app-view-input", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](27, "div", 20);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelement"](28, "app-view-input", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]()();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](29, "div", 19)(30, "div", 20);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelement"](31, "app-view-input", 24);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](32, "div", 20);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelement"](33, "app-view-input", 25);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](34, "div", 20);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelement"](35, "app-view-input", 26);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelement"](36, "div", 20);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]()();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](37, "mat-expansion-panel")(38, "mat-expansion-panel-header")(39, "mat-panel-title");
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtext"](40, " Additional Details ");
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]()();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](41, "div", 17)(42, "div", 19)(43, "div", 20);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelement"](44, "app-view-input", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](45, "div", 20);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelement"](46, "app-view-input", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](47, "div", 20);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelement"](48, "app-view-input", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]()();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](49, "div", 19)(50, "div", 20);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelement"](51, "app-view-input", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](52, "div", 20);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelement"](53, "app-view-input", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](54, "div", 20);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelement"](55, "app-view-input", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]()();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](56, "div", 19)(57, "div", 20);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelement"](58, "app-view-input", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]()();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](59, "div", 19)(60, "div", 20);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelement"](61, "app-view-input", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]()()()()()()()();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](62, "div", 27)(63, "mat-tab-group")(64, "mat-tab", 28);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelement"](65, "app-pet-docs", 29);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](66, "mat-tab", 30);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelement"](67, "app-medicle-records");
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](68, "mat-tab", 31);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelement"](69, "app-reminders");
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](70, "mat-tab", 32);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelement"](71, "app-appointments", 33);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]()()()();
  }
  if (rf & 2) {
    const ctx_r4 = _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](11);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("formGroup", ctx_r4.form);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("src", ctx_r4.form.get("image").value, _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵsanitizeUrl"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](9);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("isVertical", false)("label", ctx_r4.controllers["name"] == null ? null : ctx_r4.controllers["name"].label)("value", ctx_r4.form.get("name").value);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("isVertical", false)("label", ctx_r4.controllers["gender"] == null ? null : ctx_r4.controllers["gender"].label)("value", ctx_r4.form.get("gender").value);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("isVertical", false)("value", ctx_r4.form.get("species").value);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("isVertical", false)("value", ctx_r4.form.get("breed").value);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("isVertical", false)("value", ctx_r4.form.get("month").value);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("isVertical", false)("value", ctx_r4.form.get("year").value);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("isVertical", false)("value", ctx_r4.form.get("weight").value);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](9);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("isVertical", false)("label", ctx_r4.controllers["neutered"] == null ? null : ctx_r4.controllers["neutered"].label)("value", ctx_r4.form.get("neutered").value);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("isVertical", false)("label", ctx_r4.controllers["bloodType"] == null ? null : ctx_r4.controllers["bloodType"].label)("value", ctx_r4.form.get("bloodType").value);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("isVertical", false)("label", ctx_r4.controllers["trainingLevel"] == null ? null : ctx_r4.controllers["trainingLevel"].label)("value", ctx_r4.form.get("trainingLevel").value);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("isVertical", false)("label", ctx_r4.controllers["color"] == null ? null : ctx_r4.controllers["color"].label)("value", ctx_r4.form.get("color").value);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("isVertical", false)("label", ctx_r4.controllers["coatLength"] == null ? null : ctx_r4.controllers["coatLength"].label)("value", ctx_r4.form.get("coatLength").value);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("isVertical", false)("label", ctx_r4.controllers["marks"] == null ? null : ctx_r4.controllers["marks"].label)("value", ctx_r4.form.get("marks").value);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("isVertical", false)("label", ctx_r4.controllers["allergies"] == null ? null : ctx_r4.controllers["allergies"].label)("value", ctx_r4.form.get("allergies").value);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("isVertical", false)("label", ctx_r4.controllers["temperament"] == null ? null : ctx_r4.controllers["temperament"].label)("value", ctx_r4.form.get("temperament").value);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("petId", ctx_r4.petId)("petParentId", ctx_r4.petParentId);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](6);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("petId", ctx_r4.petId);
  }
}
function EditPetComponent_div_1_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementStart"](0, "div", 4)(1, "div", 5);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtemplate"](2, EditPetComponent_div_1_div_2_Template, 72, 45, "div", 6);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵelementEnd"]()();
  }
  if (rf & 2) {
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("ngIf", ctx_r1.data);
  }
}
class EditPetComponent {
  constructor(
  // public dialogRef: MatDialogRef<EditPetComponent>,
  loader, userManagementService, router, validationsService, fb, adoptionManagementService, location
  // @Inject(MAT_DIALOG_DATA) public data: any,
  ) {
    this.loader = loader;
    this.userManagementService = userManagementService;
    this.router = router;
    this.validationsService = validationsService;
    this.fb = fb;
    this.adoptionManagementService = adoptionManagementService;
    this.location = location;
    this.isEditable = false;
    this.craeteFormControllers();
    this.createForm();
  }
  ngOnInit() {
    this.petParentId = sessionStorage.getItem('petParentId');
    this.petId = sessionStorage.getItem('petId');
    console.log(this.petId);
    this.getPets();
  }
  edit() {
    this.isEditable = true;
  }
  editForm() {
    console.log(this.data);
    this.form = this.fb.group({
      name: [this.data['petName'], [_angular_forms__WEBPACK_IMPORTED_MODULE_11__.Validators.required, this.validationsService.isOnlyStringValidator()]],
      species: [this.data['type'], _angular_forms__WEBPACK_IMPORTED_MODULE_11__.Validators.required],
      breed: [this.data['breed'], _angular_forms__WEBPACK_IMPORTED_MODULE_11__.Validators.required],
      month: [this.data['month'], [_angular_forms__WEBPACK_IMPORTED_MODULE_11__.Validators.required, _angular_forms__WEBPACK_IMPORTED_MODULE_11__.Validators.min(0), _angular_forms__WEBPACK_IMPORTED_MODULE_11__.Validators.max(12)]],
      year: [this.data['year'], [_angular_forms__WEBPACK_IMPORTED_MODULE_11__.Validators.required, _angular_forms__WEBPACK_IMPORTED_MODULE_11__.Validators.min(0)]],
      age: [''],
      gender: [this.data['gender'], _angular_forms__WEBPACK_IMPORTED_MODULE_11__.Validators.required],
      image: [this.data['profileImage'], _angular_forms__WEBPACK_IMPORTED_MODULE_11__.Validators.required],
      weight: [this.data['weight'] ? this.data['weight'] : ''],
      color: [null],
      coatLength: [null],
      neutered: [null],
      bloodType: [null],
      temperament: [null],
      trainingLevel: [null],
      allergies: [null],
      marks: [null]
    });
    let type;
    if (this.data['gender'] == 'female') {
      this.form.get('gender').setValue('Female');
    } else if (this.data['gender'] == 'male') {
      this.form.get('gender').setValue('Male');
    }
    if (this.form.get('species').value == "cat") {
      type = "Cat";
    } else if (this.form.get('species').value == "dog") {
      type = "Dog";
    } else if (this.form.get('species').value == "bird") {
      type = "Bird";
    } else if (this.form.get('species').value == "exotic") {
      type = "Exotic";
    }
    console.log(type);
    this.adoptionManagementService.getBreeds(type).subscribe(res => {
      res.forEach(el => {
        this.controllers['breed']['options'].push({
          name: el,
          value: el
        });
      });
      this.form.get('breed').setValue(this.data['breed']);
    });
    if (this.data['metadata']) {
      this.data['metadata'].forEach(el => {
        if (el['key'] == 'petColor') {
          this.form.get('color').setValue(el['value']);
        }
        if (el['key'] == 'trainingLevel') {
          this.form.get('trainingLevel').setValue(el['value']);
        }
        if (el['key'] == 'allergy') {
          this.form.get('allergies').setValue(el['value']);
        }
        if (el['key'] == 'neutered') {
          this.form.get('neutered').setValue(el['value']);
        }
        if (el['key'] == 'bloodType') {
          this.form.get('bloodType').setValue(el['value']);
        }
        if (el['key'] == 'temperament') {
          this.form.get('temperament').setValue(el['value']);
        }
        if (el['key'] == 'coatLength') {
          this.form.get('coatLength').setValue(el['value']);
        }
        if (el['key'] == 'distintive') {
          this.form.get('marks').setValue(el['value']);
        }
      });
    }
    console.log('form', this.form);
  }
  createForm() {
    this.form = this.fb.group({
      name: [null, [_angular_forms__WEBPACK_IMPORTED_MODULE_11__.Validators.required, this.validationsService.isOnlyStringValidator()]],
      species: [null, _angular_forms__WEBPACK_IMPORTED_MODULE_11__.Validators.required],
      breed: [null, _angular_forms__WEBPACK_IMPORTED_MODULE_11__.Validators.required],
      month: [null, [_angular_forms__WEBPACK_IMPORTED_MODULE_11__.Validators.required, _angular_forms__WEBPACK_IMPORTED_MODULE_11__.Validators.min(0), _angular_forms__WEBPACK_IMPORTED_MODULE_11__.Validators.max(12)]],
      year: [null, [_angular_forms__WEBPACK_IMPORTED_MODULE_11__.Validators.required, _angular_forms__WEBPACK_IMPORTED_MODULE_11__.Validators.min(0)]],
      age: [''],
      gender: [null, _angular_forms__WEBPACK_IMPORTED_MODULE_11__.Validators.required],
      image: [null, _angular_forms__WEBPACK_IMPORTED_MODULE_11__.Validators.required],
      weight: [null],
      color: [null],
      coatLength: [null],
      neutered: [null],
      bloodType: [null],
      temperament: [null],
      trainingLevel: [null],
      allergies: [null],
      marks: [null]
    });
  }
  getPets() {
    this.loader.showLoader();
    this.userManagementService.getAllPetsByPetParent(this.petParentId).subscribe(res => {
      console.log(res);
      this.loader.hideLoader();
      res.forEach(el => {
        if (el['id'] == this.petId) {
          this.data = el;
        }
      });
      this.editForm();
      console.log(this.data);
    });
  }
  craeteFormControllers() {
    this.controllers = {
      name: {
        id: "name",
        name: 'name',
        label: "Pet Name",
        required: true,
        placeholder: "Enter Pet Name",
        type: "text"
      },
      species: {
        id: "species",
        name: 'species',
        label: "Pet Species*",
        required: true,
        placeholder: "Enter Pet Species",
        options: [{
          name: "Dog",
          value: "dog"
        }, {
          name: "Cat",
          value: "cat"
        }, {
          name: "Bird",
          value: "bird"
        }, {
          name: "Exotic",
          value: "exotic"
        }],
        type: "text"
      },
      breed: {
        id: "breed",
        name: 'breed',
        label: "Pet Breed*",
        required: true,
        placeholder: "Enter Pet Breed",
        options: [],
        type: "text"
      },
      age: {
        id: "age",
        name: 'age',
        label: "Pet Age",
        required: true,
        placeholder: "Enter Age In Months",
        type: "text"
      },
      gender: {
        id: "gender",
        name: 'gender',
        label: "Gender",
        required: true,
        placeholder: "Enter Gender",
        options: [{
          name: "Male",
          value: "Male"
        }, {
          name: "Female",
          value: "Female"
        }],
        type: "radio"
      },
      image: {
        id: "image",
        name: 'image',
        label: "Upload Pet Image",
        required: true,
        placeholder: "",
        type: "image"
      },
      internalNotes: {
        id: "internalNotes",
        name: "internalNotes",
        label: "Internal Notes",
        placeholder: "Enter Internal Notes",
        required: true
      },
      weight: {
        id: "weight",
        name: "weight",
        label: "Weight",
        placeholder: "Enter Weight",
        required: true
      },
      color: {
        id: "color",
        name: "color",
        label: "Color",
        placeholder: "Enter Color",
        required: true,
        options: [{
          name: 'Black',
          value: 'Black'
        }, {
          name: 'Brown',
          value: 'Brown'
        }, {
          name: 'White',
          value: 'White'
        }, {
          name: 'Golden',
          value: 'Golden'
        }, {
          name: 'Grey',
          value: 'Grey'
        }, {
          name: 'White and black ',
          value: 'White and black '
        }, {
          name: 'White and brown',
          value: 'White and brown '
        }, {
          name: 'Black and brown',
          value: 'Black and brown'
        }, {
          name: 'Black, white and brown',
          value: 'Black, white and brown'
        }]
      },
      coatLength: {
        id: "coatLength",
        name: "coatLength",
        label: "Coat Length",
        placeholder: "Enter Color",
        required: true,
        options: [{
          name: 'Small',
          value: 'Small'
        }, {
          name: 'Medium',
          value: 'Medium'
        }, {
          name: 'Large',
          value: 'Large'
        }]
      },
      neutered: {
        id: "neutered",
        name: "neutered",
        label: "Neutered/Spayed",
        placeholder: "Enter Color",
        required: true,
        options: [{
          name: 'Yes',
          value: 'Yes'
        }, {
          name: 'No',
          value: 'No'
        }]
      },
      bloodType: {
        id: "bloodType",
        name: "bloodType",
        label: "Blood Type",
        placeholder: "Enter bloodType",
        required: true,
        options: [{
          name: 'DEA 1.1',
          value: 'DEA 1.1'
        }, {
          name: 'DEA 1.2',
          value: 'DEA 1.2'
        }, {
          name: 'DEA 3',
          value: 'DEA 3'
        }, {
          name: 'DEA 4',
          value: 'DEA 4'
        }, {
          name: 'DEA 5',
          value: 'DEA 5'
        }, {
          name: 'DEA 6',
          value: 'DEA 6'
        }, {
          name: 'DEA 7',
          value: 'DEA 7'
        }, {
          name: 'DEA 8',
          value: 'DEA 8'
        }]
      },
      temperament: {
        id: "temperament",
        name: "temperament",
        label: "Temperament",
        placeholder: "Enter Temperament",
        required: true,
        options: [{
          name: 'Friendly ',
          value: 'Friendly '
        }, {
          name: 'Not friendly',
          value: 'Not friendly'
        }, {
          name: 'Reserved',
          value: 'Reserved'
        }, {
          name: 'Anxious',
          value: 'Anxious'
        }, {
          name: 'Fearful',
          value: 'Fearful'
        }, {
          name: 'Reactive',
          value: 'Reactive'
        }, {
          name: 'Aggressive',
          value: 'Aggressive'
        }]
      },
      trainingLevel: {
        id: "trainingLevel",
        name: "trainingLevel",
        label: "Training Level",
        placeholder: "Enter Training Level",
        required: true,
        options: [{
          name: 'House Training',
          value: 'House Training'
        }, {
          name: 'Basic Obedience',
          value: 'Basic Obedience'
        }, {
          name: 'Socialization',
          value: 'Socialization'
        }, {
          name: 'Advanced obedience',
          value: 'Advanced obedience'
        }, {
          name: 'Impulse control',
          value: 'Impulse control'
        }, {
          name: 'Leash Training',
          value: 'Leash Training'
        }, {
          name: 'Off-leash training',
          value: 'Off-leash training'
        }, {
          name: 'Trick training',
          value: 'Trick training'
        }, {
          name: 'Agility training',
          value: 'Agility training'
        }, {
          name: 'Therapy Dog Training',
          value: 'Therapy Dog Training'
        }, {
          name: 'Service Dog Training',
          value: 'Service Dog Training'
        }, {
          name: 'Search and Rescue Training',
          value: 'Search and Rescue Training'
        }, {
          name: 'Scent Detection Training',
          value: 'Scent Detection Training'
        }, {
          name: 'Protection Training',
          value: 'Protection Training'
        }]
      },
      allergies: {
        id: "allergies",
        name: "allergies",
        label: "Allergies",
        placeholder: "Enter Allergies",
        required: true
      },
      marks: {
        id: "marks",
        name: "marks",
        label: "Distinctive Marks",
        placeholder: "Enter Allergies",
        required: true
      }
    };
  }
  uploadProfile(event) {
    // if (this.editData) {
    this.loader.showLoader();
    this.userManagementService.addPetProfileImage(this.petParentId, this.petId, this.form.get('image').value).subscribe(res => {
      console.log(res);
      this.loader.hideLoader();
    });
    // }
  }
  cancel() {
    // this.dialogRef.close();
    this.router.navigate(['/user/pet/']); //pet/addUser
    // this.location.back();
    // this.petParentComponent.sidenav.toggle()
    // this.userManagementService.closeSidenav();
  }
  static #_ = this.ɵfac = function EditPetComponent_Factory(t) {
    return new (t || EditPetComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵdirectiveInject"](app_services_loader_service__WEBPACK_IMPORTED_MODULE_0__.LoaderService), _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵdirectiveInject"](app_services_user_management_service__WEBPACK_IMPORTED_MODULE_1__.UserManagementService), _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵdirectiveInject"](_angular_router__WEBPACK_IMPORTED_MODULE_12__.Router), _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵdirectiveInject"](app_services_validations_service__WEBPACK_IMPORTED_MODULE_2__.ValidationsService), _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵdirectiveInject"](_angular_forms__WEBPACK_IMPORTED_MODULE_11__.FormBuilder), _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵdirectiveInject"](app_services_adoption_management_service__WEBPACK_IMPORTED_MODULE_3__.AdoptionManagementService), _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵdirectiveInject"](_angular_common__WEBPACK_IMPORTED_MODULE_13__.Location));
  };
  static #_2 = this.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵdefineComponent"]({
    type: EditPetComponent,
    selectors: [["app-edit-pet"]],
    decls: 2,
    vars: 2,
    consts: [["class", "wrapper", 4, "ngIf"], ["class", "flex flex-col flex-auto min-w-0", "style", "width: 100%;overflow-y: auto;height: calc(100vh - 70px);", 4, "ngIf"], [1, "wrapper"], [3, "editData", "petParentId", "cancelEvent"], [1, "flex", "flex-col", "flex-auto", "min-w-0", 2, "width", "100%", "overflow-y", "auto", "height", "calc(100vh - 70px)"], [1, "flex-auto", "p-1"], ["class", "container", 4, "ngIf"], [1, "container"], [1, "form-container"], [1, "header"], [1, "header-1", 2, "color", "black", "padding-bottom", "1%", "font-weight", "500", "font-size", "16px"], [1, "actions"], ["mat-mini-fab", "", "color", "primary", 3, "click"], ["mat-mini-fab", "", "color", "warn", 3, "click"], [3, "formGroup"], [1, "profile-image-container"], ["alt", "Profile Image", 1, "profile-image", 3, "src"], [1, "form-fields"], ["expanded", "true"], [1, "row"], [1, "col"], [3, "isVertical", "label", "value"], ["label", "Pet Species", 3, "isVertical", "value"], ["label", "Pet Breed", 3, "isVertical", "value"], ["label", "Month", 3, "isVertical", "value"], ["label", "Year", 3, "isVertical", "value"], ["label", "Weight", 3, "isVertical", "value"], [1, "history-container"], ["label", "Pet Docs"], [3, "petId", "petParentId"], ["label", "Medical Records"], ["label", "Reminders"], ["label", "Appointments"], [3, "petId"]],
    template: function EditPetComponent_Template(rf, ctx) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtemplate"](0, EditPetComponent_div_0_Template, 2, 2, "div", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵtemplate"](1, EditPetComponent_div_1_Template, 3, 1, "div", 1);
      }
      if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("ngIf", ctx.isEditable);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_10__["ɵɵproperty"]("ngIf", !ctx.isEditable);
      }
    },
    dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_13__.NgIf, _angular_material_tabs__WEBPACK_IMPORTED_MODULE_14__.MatTab, _angular_material_tabs__WEBPACK_IMPORTED_MODULE_14__.MatTabGroup, _components_controllers_view_input_view_input_component__WEBPACK_IMPORTED_MODULE_4__.ViewInputComponent, _angular_material_button__WEBPACK_IMPORTED_MODULE_15__.MatMiniFabButton, _angular_forms__WEBPACK_IMPORTED_MODULE_11__["ɵNgNoValidate"], _angular_forms__WEBPACK_IMPORTED_MODULE_11__.NgControlStatusGroup, _angular_forms__WEBPACK_IMPORTED_MODULE_11__.FormGroupDirective, _angular_material_icon__WEBPACK_IMPORTED_MODULE_16__.MatIcon, _angular_material_expansion__WEBPACK_IMPORTED_MODULE_17__.MatAccordion, _angular_material_expansion__WEBPACK_IMPORTED_MODULE_17__.MatExpansionPanel, _angular_material_expansion__WEBPACK_IMPORTED_MODULE_17__.MatExpansionPanelHeader, _angular_material_expansion__WEBPACK_IMPORTED_MODULE_17__.MatExpansionPanelTitle, _add_pet_add_pet_component__WEBPACK_IMPORTED_MODULE_5__.AddPetComponent, _pet_docs_pet_docs_component__WEBPACK_IMPORTED_MODULE_6__.PetDocsComponent, _medicle_records_medicle_records_component__WEBPACK_IMPORTED_MODULE_7__.MedicleRecordsComponent, _reminders_reminders_component__WEBPACK_IMPORTED_MODULE_8__.RemindersComponent, _appointments_appointments_component__WEBPACK_IMPORTED_MODULE_9__.AppointmentsComponent],
    styles: [".container[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: column;\n  justify-content: space-between;\n  height: 100vh;\n  max-height: auto;\n  text-align: center;\n  align-items: center;\n  width: 100%;\n}\n\n.form-container[_ngcontent-%COMP%] {\n  width: 90%;\n  box-sizing: border-box;\n  text-align: center;\n}\n.form-container[_ngcontent-%COMP%]   .header[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: row;\n  justify-content: space-between;\n  height: -moz-fit-content;\n  height: fit-content;\n  width: 100%;\n  padding: 1%;\n}\n.form-container[_ngcontent-%COMP%]   .header[_ngcontent-%COMP%]   .header-1[_ngcontent-%COMP%] {\n  display: flex;\n  justify-content: center;\n  align-items: center;\n}\n.form-container[_ngcontent-%COMP%]   .header[_ngcontent-%COMP%]   .actions[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: row;\n  width: 10%;\n  justify-content: space-between;\n}\n.form-container[_ngcontent-%COMP%]   form[_ngcontent-%COMP%] {\n  width: 100%;\n  height: 80%;\n  display: flex;\n  flex-direction: row;\n  justify-content: space-between;\n}\n.form-container[_ngcontent-%COMP%]   form[_ngcontent-%COMP%]   .profile-image-container[_ngcontent-%COMP%] {\n  width: 20%;\n  height: 90%;\n  display: flex;\n  justify-content: center;\n}\n.form-container[_ngcontent-%COMP%]   form[_ngcontent-%COMP%]   .form-fields[_ngcontent-%COMP%] {\n  width: 100%;\n  height: 95%;\n  display: flex;\n  flex-direction: column;\n  justify-content: space-between;\n}\n.form-container[_ngcontent-%COMP%]   form[_ngcontent-%COMP%]   .form-fields[_ngcontent-%COMP%]   .row[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: row;\n  justify-content: space-between;\n  height: 15%;\n  width: 100%;\n}\n.form-container[_ngcontent-%COMP%]   form[_ngcontent-%COMP%]   .form-fields[_ngcontent-%COMP%]   .row[_ngcontent-%COMP%]   .col[_ngcontent-%COMP%] {\n  width: 24%;\n  display: flex;\n  flex-direction: column;\n  height: 100%;\n}\n\n.history-container[_ngcontent-%COMP%] {\n  height: 64%;\n  width: 95%;\n  padding: 10px;\n  box-sizing: border-box;\n}\n\n.profile-image[_ngcontent-%COMP%] {\n  width: 100px;\n  height: 100px;\n  border-radius: 50%;\n}\n\nbutton[_ngcontent-%COMP%] {\n  margin-top: 10px;\n}\n\n.wrapper[_ngcontent-%COMP%] {\n  width: 100%;\n  height: 100%;\n}\n\n.form-field[_ngcontent-%COMP%]   input[_ngcontent-%COMP%] {\n  width: 100%;\n  padding: 8px;\n  border: 1px solid #ccc;\n  border-radius: 4px;\n  background-color: #e9e9e9;\n}\n/*# sourceMappingURL=data:application/json;base64,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 */\n/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */"]
  });
}


/***/ }),

/***/ 26701:
/*!***********************************************************************************************************!*\
  !*** ./src/app/modules/user-manaement/medical-records/add-allergy-record/add-allergy-record.component.ts ***!
  \***********************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AddAllergyRecordComponent": () => (/* binding */ AddAllergyRecordComponent)
/* harmony export */ });
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/forms */ 69542);
/* harmony import */ var _angular_material_dialog__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/material/dialog */ 67486);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/core */ 86839);
/* harmony import */ var app_services_pet_service__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! app/services/pet.service */ 59976);
/* harmony import */ var app_services_loader_service__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! app/services/loader.service */ 38555);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/common */ 86477);
/* harmony import */ var _components_controllers_input_input_component__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../../components/controllers/input/input.component */ 30867);
/* harmony import */ var _components_controllers_text_area_text_area_component__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../../components/controllers/text-area/text-area.component */ 17311);
/* harmony import */ var _angular_material_button__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @angular/material/button */ 83677);
/* harmony import */ var _angular_material_icon__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @angular/material/icon */ 69941);












function AddAllergyRecordComponent_div_0_Template(rf, ctx) {
  if (rf & 1) {
    const _r2 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "div", 1)(1, "div", 2)(2, "h1");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](4, "button", 3);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵlistener"]("click", function AddAllergyRecordComponent_div_0_Template_button_click_4_listener() {
      _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵrestoreView"](_r2);
      const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵresetView"](ctx_r1.onNoClick());
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](5, "mat-icon");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](6, "close");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]()()();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](7, "div", 4);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelement"](8, "app-input", 5);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](9, "div", 4);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelement"](10, "app-text-area", 6);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](11, "div", 7)(12, "button", 8);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵlistener"]("click", function AddAllergyRecordComponent_div_0_Template_button_click_12_listener() {
      _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵrestoreView"](_r2);
      const ctx_r3 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵresetView"](ctx_r3.onNoClick());
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](13, "Cancel");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](14, "button", 9);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵlistener"]("click", function AddAllergyRecordComponent_div_0_Template_button_click_14_listener() {
      _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵrestoreView"](_r2);
      const ctx_r4 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵresetView"](ctx_r4.add());
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](15, "Save");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]()()();
  }
  if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate"](ctx_r0.data["type"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("form", ctx_r0.form)("controller", ctx_r0.controlls["title"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("form", ctx_r0.form)("controller", ctx_r0.controlls["description"])("maxlength", 140);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("disabled", ctx_r0.form.invalid);
  }
}
class AddAllergyRecordComponent {
  constructor(dialogRef, data, fb, petService, loader) {
    this.dialogRef = dialogRef;
    this.data = data;
    this.fb = fb;
    this.petService = petService;
    this.loader = loader;
    this.createControlls();
    this.createForm();
  }
  ngOnInit() {
    if (this.data['record']) {
      this.edit();
    }
  }
  edit() {
    let el = this.data['record'];
    this.form = this.fb.group({
      id: [el['id']],
      title: [el['docName'], _angular_forms__WEBPACK_IMPORTED_MODULE_5__.Validators.required],
      description: [el['plan']['discription'], _angular_forms__WEBPACK_IMPORTED_MODULE_5__.Validators.required]
    });
  }
  createForm() {
    this.form = this.fb.group({
      title: ['', _angular_forms__WEBPACK_IMPORTED_MODULE_5__.Validators.required],
      description: ['', _angular_forms__WEBPACK_IMPORTED_MODULE_5__.Validators.required]
    });
  }
  createControlls() {
    this.controlls = {
      title: {
        id: "title",
        name: 'title',
        label: "Allergy Record ",
        placeholder: "Enter Allergy Record",
        required: true,
        type: "text"
      },
      description: {
        id: "description",
        name: 'description',
        label: "Description",
        placeholder: "Enter Description",
        required: true,
        type: "text"
      }
    };
  }
  onNoClick() {
    this.dialogRef.close();
  }
  add() {
    console.log(this.data['records']);
    let json = this.form.value;
    const date = new Date(json['nextDate']);
    let data = {
      docName: json['title'],
      docDate: '',
      nextDate: '',
      period: '',
      reminder: '',
      reminderDate: '',
      type: 'allergyRecord',
      subType: '',
      plan: {
        discription: json['description']
      },
      petId: sessionStorage.getItem('petId'),
      path: ''
    };
    if (this.data['record']) {
      data['id'] = this.data['record']['id'];
      data['fileDelete'] = false;
      this.loader.showLoader();
      this.petService.updateMedicalRecord(data, sessionStorage.getItem('petParentId'), this.data['record']['id'], data['fileDelete']).subscribe(res => {
        this.petService.getMedicalRecord(sessionStorage.getItem('petId'), 'allergyRecord').subscribe(res => {
          console.log(res);
          this.loader.hideLoader();
          this.dialogRef.close();
        });
      });
    } else {
      this.loader.showLoader();
      this.petService.addMedicalRecord(data, sessionStorage.getItem('petParentId')).subscribe(res => {
        this.petService.medicalRecordData[4]['icon'] = './assets/icons/pet-history/allergy.svg';
        this.petService.getMedicalRecord(sessionStorage.getItem('petId'), 'allergyRecord').subscribe(res => {
          console.log(res);
        });
        this.loader.hideLoader();
        this.dialogRef.close();
      });
    }
  }
  onUpload(event) {
    this.form.get('document').setValue(event);
  }
  static #_ = this.ɵfac = function AddAllergyRecordComponent_Factory(t) {
    return new (t || AddAllergyRecordComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](_angular_material_dialog__WEBPACK_IMPORTED_MODULE_6__.MatDialogRef), _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](_angular_material_dialog__WEBPACK_IMPORTED_MODULE_6__.MAT_DIALOG_DATA), _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](_angular_forms__WEBPACK_IMPORTED_MODULE_5__.FormBuilder), _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](app_services_pet_service__WEBPACK_IMPORTED_MODULE_0__.PetService), _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](app_services_loader_service__WEBPACK_IMPORTED_MODULE_1__.LoaderService));
  };
  static #_2 = this.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdefineComponent"]({
    type: AddAllergyRecordComponent,
    selectors: [["app-add-allergy-record"]],
    decls: 1,
    vars: 1,
    consts: [["mat-dialog-content", "", "class", "wrapper", 4, "ngIf"], ["mat-dialog-content", "", 1, "wrapper"], [1, "header"], ["mat-icon-button", "", "color", "primary", 3, "click"], [1, "row"], [2, "width", "100%", 3, "form", "controller"], [2, "width", "100%", 3, "form", "controller", "maxlength"], [1, "btn-wrapper"], ["mat-stroked-button", "", "color", "primary", 3, "click"], ["mat-stroked-button", "", "color", "primary", 3, "disabled", "click"]],
    template: function AddAllergyRecordComponent_Template(rf, ctx) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](0, AddAllergyRecordComponent_div_0_Template, 16, 7, "div", 0);
      }
      if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("ngIf", ctx.data);
      }
    },
    dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_7__.NgIf, _components_controllers_input_input_component__WEBPACK_IMPORTED_MODULE_2__.InputComponent, _components_controllers_text_area_text_area_component__WEBPACK_IMPORTED_MODULE_3__.TextAreaComponent, _angular_material_button__WEBPACK_IMPORTED_MODULE_8__.MatButton, _angular_material_button__WEBPACK_IMPORTED_MODULE_8__.MatIconButton, _angular_material_icon__WEBPACK_IMPORTED_MODULE_9__.MatIcon],
    styles: [".header[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: row;\n  justify-content: space-between;\n}\n\n.row[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: column;\n  width: 90%;\n  height: 20%;\n  margin: 1%;\n}\n\n.btn-wrapper[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: row;\n  justify-content: right;\n}\n.btn-wrapper[_ngcontent-%COMP%]   button[_ngcontent-%COMP%] {\n  margin: 10px;\n}\n\n.wrapper[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: column;\n}\n\n.header[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: row;\n  justify-content: space-between;\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImFkZC1hbGxlcmd5LXJlY29yZC5jb21wb25lbnQuc2NzcyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTtFQUNJLGFBQUE7RUFDQSxtQkFBQTtFQUNBLDhCQUFBO0FBQ0o7O0FBRUE7RUFDSSxhQUFBO0VBQ0Esc0JBQUE7RUFDQSxVQUFBO0VBQ0EsV0FBQTtFQUNBLFVBQUE7QUFDSjs7QUFDQTtFQUNJLGFBQUE7RUFDQSxtQkFBQTtFQUNBLHNCQUFBO0FBRUo7QUFESTtFQUNJLFlBQUE7QUFHUjs7QUFBQTtFQUNJLGFBQUE7RUFDQSxzQkFBQTtBQUdKOztBQUFBO0VBQ0ksYUFBQTtFQUNBLG1CQUFBO0VBQ0EsOEJBQUE7QUFHSiIsImZpbGUiOiJhZGQtYWxsZXJneS1yZWNvcmQuY29tcG9uZW50LnNjc3MiLCJzb3VyY2VzQ29udGVudCI6WyIuaGVhZGVye1xuICAgIGRpc3BsYXk6IGZsZXg7XG4gICAgZmxleC1kaXJlY3Rpb246IHJvdztcbiAgICBqdXN0aWZ5LWNvbnRlbnQ6IHNwYWNlLWJldHdlZW47XG59XG5cbi5yb3d7XG4gICAgZGlzcGxheTogZmxleDtcbiAgICBmbGV4LWRpcmVjdGlvbjogY29sdW1uO1xuICAgIHdpZHRoOiA5MCU7XG4gICAgaGVpZ2h0OiAyMCU7XG4gICAgbWFyZ2luOiAxJTtcbn1cbi5idG4td3JhcHBlcntcbiAgICBkaXNwbGF5OiBmbGV4O1xuICAgIGZsZXgtZGlyZWN0aW9uOiByb3c7XG4gICAganVzdGlmeS1jb250ZW50OiByaWdodDtcbiAgICBidXR0b257XG4gICAgICAgIG1hcmdpbjogMTBweDtcbiAgICB9XG59IFxuLndyYXBwZXJ7XG4gICAgZGlzcGxheTogZmxleDtcbiAgICBmbGV4LWRpcmVjdGlvbjogY29sdW1uO1xuXG59XG4uaGVhZGVye1xuICAgIGRpc3BsYXk6IGZsZXg7XG4gICAgZmxleC1kaXJlY3Rpb246IHJvdztcbiAgICBqdXN0aWZ5LWNvbnRlbnQ6IHNwYWNlLWJldHdlZW47XG59XG4iXX0= */\n/*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8uL3NyYy9hcHAvbW9kdWxlcy91c2VyLW1hbmFlbWVudC9tZWRpY2FsLXJlY29yZHMvYWRkLWFsbGVyZ3ktcmVjb3JkL2FkZC1hbGxlcmd5LXJlY29yZC5jb21wb25lbnQuc2NzcyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTtFQUNJLGFBQUE7RUFDQSxtQkFBQTtFQUNBLDhCQUFBO0FBQ0o7O0FBRUE7RUFDSSxhQUFBO0VBQ0Esc0JBQUE7RUFDQSxVQUFBO0VBQ0EsV0FBQTtFQUNBLFVBQUE7QUFDSjs7QUFDQTtFQUNJLGFBQUE7RUFDQSxtQkFBQTtFQUNBLHNCQUFBO0FBRUo7QUFESTtFQUNJLFlBQUE7QUFHUjs7QUFBQTtFQUNJLGFBQUE7RUFDQSxzQkFBQTtBQUdKOztBQUFBO0VBQ0ksYUFBQTtFQUNBLG1CQUFBO0VBQ0EsOEJBQUE7QUFHSjtBQUNBLG91Q0FBb3VDIiwic291cmNlc0NvbnRlbnQiOlsiLmhlYWRlcntcbiAgICBkaXNwbGF5OiBmbGV4O1xuICAgIGZsZXgtZGlyZWN0aW9uOiByb3c7XG4gICAganVzdGlmeS1jb250ZW50OiBzcGFjZS1iZXR3ZWVuO1xufVxuXG4ucm93e1xuICAgIGRpc3BsYXk6IGZsZXg7XG4gICAgZmxleC1kaXJlY3Rpb246IGNvbHVtbjtcbiAgICB3aWR0aDogOTAlO1xuICAgIGhlaWdodDogMjAlO1xuICAgIG1hcmdpbjogMSU7XG59XG4uYnRuLXdyYXBwZXJ7XG4gICAgZGlzcGxheTogZmxleDtcbiAgICBmbGV4LWRpcmVjdGlvbjogcm93O1xuICAgIGp1c3RpZnktY29udGVudDogcmlnaHQ7XG4gICAgYnV0dG9ue1xuICAgICAgICBtYXJnaW46IDEwcHg7XG4gICAgfVxufSBcbi53cmFwcGVye1xuICAgIGRpc3BsYXk6IGZsZXg7XG4gICAgZmxleC1kaXJlY3Rpb246IGNvbHVtbjtcblxufVxuLmhlYWRlcntcbiAgICBkaXNwbGF5OiBmbGV4O1xuICAgIGZsZXgtZGlyZWN0aW9uOiByb3c7XG4gICAganVzdGlmeS1jb250ZW50OiBzcGFjZS1iZXR3ZWVuO1xufVxuIl0sInNvdXJjZVJvb3QiOiIifQ== */"]
  });
}


/***/ }),

/***/ 626:
/*!*************************************************************************************************!*\
  !*** ./src/app/modules/user-manaement/medical-records/add-deworming/add-deworming.component.ts ***!
  \*************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AddDewormingComponent": () => (/* binding */ AddDewormingComponent)
/* harmony export */ });
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/forms */ 69542);
/* harmony import */ var _angular_material_dialog__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/material/dialog */ 67486);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/core */ 86839);
/* harmony import */ var app_services_pet_service__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! app/services/pet.service */ 59976);
/* harmony import */ var app_services_loader_service__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! app/services/loader.service */ 38555);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @angular/common */ 86477);
/* harmony import */ var _components_controllers_date_picker_date_picker_component__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../../components/controllers/date-picker/date-picker.component */ 49582);
/* harmony import */ var _components_controllers_single_checkbox_single_checkbox_component__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../../components/controllers/single-checkbox/single-checkbox.component */ 59037);
/* harmony import */ var _components_controllers_toggle_btn_toggle_btn_component__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../../components/controllers/toggle-btn/toggle-btn.component */ 67212);
/* harmony import */ var _angular_material_button__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @angular/material/button */ 83677);
/* harmony import */ var _angular_material_icon__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @angular/material/icon */ 69941);













function AddDewormingComponent_div_0_div_13_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "div", 14);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelement"](1, "app-single-checkbox", 15);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("form", ctx_r1.form)("controller", ctx_r1.controlls["reminder"]);
  }
}
function AddDewormingComponent_div_0_Template(rf, ctx) {
  if (rf & 1) {
    const _r3 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "div", 1)(1, "div", 2)(2, "h1");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](4, "button", 3);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵlistener"]("click", function AddDewormingComponent_div_0_Template_button_click_4_listener() {
      _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵrestoreView"](_r3);
      const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵresetView"](ctx_r2.onNoClick());
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](5, "mat-icon");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](6, "close");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]()()();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](7, "div", 4);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelement"](8, "app-date-picker", 5);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](9, "div", 4)(10, "app-date-picker", 6);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵlistener"]("DateChange", function AddDewormingComponent_div_0_Template_app_date_picker_DateChange_10_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵrestoreView"](_r3);
      const ctx_r4 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵresetView"](ctx_r4.onDateChange($event));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]()();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](11, "div", 7);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelement"](12, "app-toggle-btn", 8);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](13, AddDewormingComponent_div_0_div_13_Template, 2, 2, "div", 9);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](14, "div", 10);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](15, " Note: ");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelement"](16, "br");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](17, " 2 weeks - pet age upto 3 months ");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelement"](18, "br");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](19, " 1 month - pet age 3 to 6 months ");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelement"](20, "br");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](21, " 3 months - pet age above 6 months ");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelement"](22, "br");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](23, "div", 11)(24, "button", 12);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵlistener"]("click", function AddDewormingComponent_div_0_Template_button_click_24_listener() {
      _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵrestoreView"](_r3);
      const ctx_r5 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵresetView"](ctx_r5.onNoClick());
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](25, "Cancel");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](26, "button", 13);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵlistener"]("click", function AddDewormingComponent_div_0_Template_button_click_26_listener() {
      _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵrestoreView"](_r3);
      const ctx_r6 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵresetView"](ctx_r6.add());
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](27, "Save");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]()()();
  }
  if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtextInterpolate"](ctx_r0.data["type"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("form", ctx_r0.form)("controller", ctx_r0.controlls["lastDewormingDate"])("max", ctx_r0.form.get("nextDewormingDate").value);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("form", ctx_r0.form)("controller", ctx_r0.controlls["nextDewormingDate"])("min", ctx_r0.form.get("lastDewormingDate").value);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("form", ctx_r0.form)("controller", ctx_r0.controlls["selectSlot"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("ngIf", ctx_r0.form.get("nextDewormingDate").value);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](13);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("disabled", ctx_r0.form.invalid);
  }
}
class AddDewormingComponent {
  constructor(dialogRef, data, petService, loader, fb) {
    this.dialogRef = dialogRef;
    this.data = data;
    this.petService = petService;
    this.loader = loader;
    this.fb = fb;
    this.createControlls();
    this.createForm();
  }
  ngOnInit() {
    if (this.data['record']) {
      this.edit();
    }
    this.form.get('selectSlot').valueChanges.subscribe(change => {
      if (change == '1 Month') {
        // nextDate
        this.form.get('nextDewormingDate').setValue(this.addNextDate(4, 0));
      } else if (change == '2 Weeks') {
        this.form.get('nextDewormingDate').setValue(this.addNextDate(2, 0));
      } else if (change == '3 Months') {
        this.form.get('nextDewormingDate').setValue(this.addNextDate(8, 0));
      }
    });
  }
  onDateChange(event) {
    this.form.get('selectSlot').reset();
  }
  addNextDate(weeks = 0, years = 0) {
    const result = new Date(this.form.get('lastDewormingDate').value);
    if (weeks) {
      result.setDate(result.getDate() + weeks * 7);
    }
    if (years) {
      result.setFullYear(result.getFullYear() + years);
    }
    return result;
  }
  edit() {
    let el = this.data['record'];
    this.form = this.fb.group({
      id: [el['id']],
      lastDewormingDate: [el['docDate'] ? new Date(el['docDate']) : '', _angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.required],
      nextDewormingDate: [el['nextDate'] ? new Date(el['nextDate']) : ''],
      selectSlot: [el['period']],
      reminder: [el['reminder']]
    });
  }
  createForm() {
    this.form = this.fb.group({
      lastDewormingDate: ['', _angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.required],
      nextDewormingDate: [''],
      selectSlot: [''],
      reminder: [false, _angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.required]
    });
  }
  createControlls() {
    this.controlls = {
      lastDewormingDate: {
        id: "lastDewormingDate",
        name: 'lastDewormingDate',
        label: "Last Deworming Done On",
        placeholder: "Select Date",
        required: true,
        type: "text"
      },
      reminder: {
        id: "reminder",
        name: 'reminder',
        label: "Remind 1 day prior to Date",
        placeholder: "Remind 1 day prior to Date",
        required: true,
        type: "text"
      },
      nextDewormingDate: {
        id: "nextDewormingDate",
        name: 'nextDewormingDate',
        label: "Next Deworming Due(Optional)",
        placeholder: "Select Date",
        required: true,
        type: "Date"
      },
      selectSlot: {
        id: "selectSlot",
        name: 'selectSlot',
        label: "",
        placeholder: "Select Slot",
        required: true,
        options: [{
          name: '2 Weeks',
          value: '2 Weeks'
        }, {
          name: '1 Month',
          value: '1 Month'
        }, {
          name: '3 Months',
          value: '3 Months'
        }],
        type: "toggle"
      }
    };
  }
  onNoClick() {
    this.dialogRef.close();
  }
  add() {
    let json = this.form.value;
    const date = new Date(json['nextDate']);
    let data = {
      docName: '',
      docDate: new Date(json['lastDewormingDate']).getTime(),
      nextDate: json['nextDewormingDate'] ? new Date(json['nextDewormingDate']).getTime() : 0,
      period: json['selectSlot'],
      reminder: json['reminder'],
      reminderDate: date.setDate(date.getDate() - 1),
      type: 'deworming',
      subType: null,
      plan: {},
      petId: sessionStorage.getItem('petId'),
      path: ''
    };
    if (this.data['record']) {
      data['id'] = this.data['record']['id'];
      data['fileDelete'] = false;
      this.loader.showLoader();
      this.petService.updateMedicalRecord(data, sessionStorage.getItem('petParentId'), this.data['record']['id'], data['fileDelete']).subscribe(res => {
        this.petService.getMedicalRecord(sessionStorage.getItem('petId'), 'deworming').subscribe(res => {
          console.log(res);
          this.dialogRef.close();
          this.loader.hideLoader();
        });
      });
    } else {
      this.loader.showLoader();
      this.petService.addMedicalRecord(data, sessionStorage.getItem('petParentId')).subscribe(res => {
        this.petService.medicalRecordData[2]['icon'] = './assets/icons/pet-history/deworming.svg';
        this.petService.getMedicalRecord(sessionStorage.getItem('petId'), 'deworming').subscribe(res => {
          console.log(res);
          this.loader.hideLoader();
          this.dialogRef.close();
        });
      });
    }
  }
  onUpload(event) {
    this.form.get('document').setValue(event);
  }
  static #_ = this.ɵfac = function AddDewormingComponent_Factory(t) {
    return new (t || AddDewormingComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](_angular_material_dialog__WEBPACK_IMPORTED_MODULE_7__.MatDialogRef), _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](_angular_material_dialog__WEBPACK_IMPORTED_MODULE_7__.MAT_DIALOG_DATA), _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](app_services_pet_service__WEBPACK_IMPORTED_MODULE_0__.PetService), _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](app_services_loader_service__WEBPACK_IMPORTED_MODULE_1__.LoaderService), _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](_angular_forms__WEBPACK_IMPORTED_MODULE_6__.FormBuilder));
  };
  static #_2 = this.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdefineComponent"]({
    type: AddDewormingComponent,
    selectors: [["app-add-deworming"]],
    decls: 1,
    vars: 1,
    consts: [["mat-dialog-content", "", "class", "wrapper", 4, "ngIf"], ["mat-dialog-content", "", 1, "wrapper"], [1, "header"], ["mat-icon-button", "", "color", "primary", 3, "click"], [1, "row", 2, "height", "20%"], [2, "width", "100%", 3, "form", "controller", "max"], [2, "width", "100%", 3, "form", "controller", "min", "DateChange"], [1, "row"], ["multiple", "false", 3, "form", "controller"], ["class", "row", "style", "height: 15%;", 4, "ngIf"], [2, "padding-left", "2%"], [1, "btn-wrapper"], ["mat-stroked-button", "", "color", "primary", 3, "click"], ["mat-stroked-button", "", "color", "primary", 3, "disabled", "click"], [1, "row", 2, "height", "15%"], [2, "width", "100%", 3, "form", "controller"]],
    template: function AddDewormingComponent_Template(rf, ctx) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](0, AddDewormingComponent_div_0_Template, 28, 11, "div", 0);
      }
      if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("ngIf", ctx.data);
      }
    },
    dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_8__.NgIf, _components_controllers_date_picker_date_picker_component__WEBPACK_IMPORTED_MODULE_2__.DatePickerComponent, _components_controllers_single_checkbox_single_checkbox_component__WEBPACK_IMPORTED_MODULE_3__.SingleCheckboxComponent, _components_controllers_toggle_btn_toggle_btn_component__WEBPACK_IMPORTED_MODULE_4__.ToggleBtnComponent, _angular_material_button__WEBPACK_IMPORTED_MODULE_9__.MatButton, _angular_material_button__WEBPACK_IMPORTED_MODULE_9__.MatIconButton, _angular_material_icon__WEBPACK_IMPORTED_MODULE_10__.MatIcon],
    styles: [".header[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: row;\n  justify-content: space-between;\n}\n\n.row[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: column;\n  width: 90%;\n  height: 20%;\n  margin: 1%;\n}\n\n.btn-wrapper[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: row;\n  justify-content: right;\n}\n.btn-wrapper[_ngcontent-%COMP%]   button[_ngcontent-%COMP%] {\n  margin: 10px;\n}\n\n.wrapper[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: column;\n}\n\n.header[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: row;\n  justify-content: space-between;\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImFkZC1kZXdvcm1pbmcuY29tcG9uZW50LnNjc3MiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7RUFDSSxhQUFBO0VBQ0EsbUJBQUE7RUFDQSw4QkFBQTtBQUNKOztBQUVBO0VBQ0ksYUFBQTtFQUNBLHNCQUFBO0VBQ0EsVUFBQTtFQUNBLFdBQUE7RUFDQSxVQUFBO0FBQ0o7O0FBQ0E7RUFDSSxhQUFBO0VBQ0EsbUJBQUE7RUFDQSxzQkFBQTtBQUVKO0FBREk7RUFDSSxZQUFBO0FBR1I7O0FBQUE7RUFDSSxhQUFBO0VBQ0Esc0JBQUE7QUFHSjs7QUFBQTtFQUNJLGFBQUE7RUFDQSxtQkFBQTtFQUNBLDhCQUFBO0FBR0oiLCJmaWxlIjoiYWRkLWRld29ybWluZy5jb21wb25lbnQuc2NzcyIsInNvdXJjZXNDb250ZW50IjpbIi5oZWFkZXJ7XG4gICAgZGlzcGxheTogZmxleDtcbiAgICBmbGV4LWRpcmVjdGlvbjogcm93O1xuICAgIGp1c3RpZnktY29udGVudDogc3BhY2UtYmV0d2Vlbjtcbn1cblxuLnJvd3tcbiAgICBkaXNwbGF5OiBmbGV4O1xuICAgIGZsZXgtZGlyZWN0aW9uOiBjb2x1bW47XG4gICAgd2lkdGg6IDkwJTtcbiAgICBoZWlnaHQ6IDIwJTtcbiAgICBtYXJnaW46IDElO1xufVxuLmJ0bi13cmFwcGVye1xuICAgIGRpc3BsYXk6IGZsZXg7XG4gICAgZmxleC1kaXJlY3Rpb246IHJvdztcbiAgICBqdXN0aWZ5LWNvbnRlbnQ6IHJpZ2h0O1xuICAgIGJ1dHRvbntcbiAgICAgICAgbWFyZ2luOiAxMHB4O1xuICAgIH1cbn0gXG4ud3JhcHBlcntcbiAgICBkaXNwbGF5OiBmbGV4O1xuICAgIGZsZXgtZGlyZWN0aW9uOiBjb2x1bW47XG5cbn1cbi5oZWFkZXJ7XG4gICAgZGlzcGxheTogZmxleDtcbiAgICBmbGV4LWRpcmVjdGlvbjogcm93O1xuICAgIGp1c3RpZnktY29udGVudDogc3BhY2UtYmV0d2Vlbjtcbn1cbiJdfQ== */\n/*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8uL3NyYy9hcHAvbW9kdWxlcy91c2VyLW1hbmFlbWVudC9tZWRpY2FsLXJlY29yZHMvYWRkLWRld29ybWluZy9hZGQtZGV3b3JtaW5nLmNvbXBvbmVudC5zY3NzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBO0VBQ0ksYUFBQTtFQUNBLG1CQUFBO0VBQ0EsOEJBQUE7QUFDSjs7QUFFQTtFQUNJLGFBQUE7RUFDQSxzQkFBQTtFQUNBLFVBQUE7RUFDQSxXQUFBO0VBQ0EsVUFBQTtBQUNKOztBQUNBO0VBQ0ksYUFBQTtFQUNBLG1CQUFBO0VBQ0Esc0JBQUE7QUFFSjtBQURJO0VBQ0ksWUFBQTtBQUdSOztBQUFBO0VBQ0ksYUFBQTtFQUNBLHNCQUFBO0FBR0o7O0FBQUE7RUFDSSxhQUFBO0VBQ0EsbUJBQUE7RUFDQSw4QkFBQTtBQUdKO0FBQ0Esd3RDQUF3dEMiLCJzb3VyY2VzQ29udGVudCI6WyIuaGVhZGVye1xuICAgIGRpc3BsYXk6IGZsZXg7XG4gICAgZmxleC1kaXJlY3Rpb246IHJvdztcbiAgICBqdXN0aWZ5LWNvbnRlbnQ6IHNwYWNlLWJldHdlZW47XG59XG5cbi5yb3d7XG4gICAgZGlzcGxheTogZmxleDtcbiAgICBmbGV4LWRpcmVjdGlvbjogY29sdW1uO1xuICAgIHdpZHRoOiA5MCU7XG4gICAgaGVpZ2h0OiAyMCU7XG4gICAgbWFyZ2luOiAxJTtcbn1cbi5idG4td3JhcHBlcntcbiAgICBkaXNwbGF5OiBmbGV4O1xuICAgIGZsZXgtZGlyZWN0aW9uOiByb3c7XG4gICAganVzdGlmeS1jb250ZW50OiByaWdodDtcbiAgICBidXR0b257XG4gICAgICAgIG1hcmdpbjogMTBweDtcbiAgICB9XG59IFxuLndyYXBwZXJ7XG4gICAgZGlzcGxheTogZmxleDtcbiAgICBmbGV4LWRpcmVjdGlvbjogY29sdW1uO1xuXG59XG4uaGVhZGVye1xuICAgIGRpc3BsYXk6IGZsZXg7XG4gICAgZmxleC1kaXJlY3Rpb246IHJvdztcbiAgICBqdXN0aWZ5LWNvbnRlbnQ6IHNwYWNlLWJldHdlZW47XG59XG4iXSwic291cmNlUm9vdCI6IiJ9 */"]
  });
}


/***/ }),

/***/ 79800:
/*!*****************************************************************************************************!*\
  !*** ./src/app/modules/user-manaement/medical-records/add-diatry-plan/add-diatry-plan.component.ts ***!
  \*****************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AddDiatryPlanComponent": () => (/* binding */ AddDiatryPlanComponent)
/* harmony export */ });
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @angular/forms */ 69542);
/* harmony import */ var _angular_material_dialog__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @angular/material/dialog */ 67486);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/core */ 86839);
/* harmony import */ var app_services_validations_service__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! app/services/validations.service */ 27681);
/* harmony import */ var app_services_pet_service__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! app/services/pet.service */ 59976);
/* harmony import */ var app_services_loader_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! app/services/loader.service */ 38555);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @angular/common */ 86477);
/* harmony import */ var _components_controllers_input_input_component__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../../components/controllers/input/input.component */ 30867);
/* harmony import */ var _components_controllers_checkbox_checkbox_component__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../../components/controllers/checkbox/checkbox.component */ 51008);
/* harmony import */ var _components_controllers_time_picker_time_picker_component__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../../components/controllers/time-picker/time-picker.component */ 59858);
/* harmony import */ var _components_controllers_toggle_btn_toggle_btn_component__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../../components/controllers/toggle-btn/toggle-btn.component */ 67212);
/* harmony import */ var _angular_material_button__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @angular/material/button */ 83677);
/* harmony import */ var _angular_material_icon__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @angular/material/icon */ 69941);
/* harmony import */ var _angular_material_form_field__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @angular/material/form-field */ 98750);
















function AddDiatryPlanComponent_div_0_div_10_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementStart"](0, "div")(1, "p");
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵtext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementEnd"]()();
  }
  if (rf & 2) {
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵtextInterpolate1"]("Time : ", ctx_r1.form.get("time").value, "");
  }
}
function AddDiatryPlanComponent_div_0_div_18_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementStart"](0, "div", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelement"](1, "app-checkbox", 11);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const day_r4 = ctx.$implicit;
    const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵproperty"]("form", ctx_r2.form.get("workSpaceTimings"))("controller", ctx_r2.controlls["workSpaceTimings"][day_r4]);
  }
}
function AddDiatryPlanComponent_div_0_div_19_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementStart"](0, "div", 19);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵtext"](1, " At least one day must be selected. ");
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementEnd"]();
  }
}
function AddDiatryPlanComponent_div_0_Template(rf, ctx) {
  if (rf & 1) {
    const _r6 = _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementStart"](0, "div", 1)(1, "div", 2)(2, "h1");
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵtext"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementStart"](4, "button", 3);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵlistener"]("click", function AddDiatryPlanComponent_div_0_Template_button_click_4_listener() {
      _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵrestoreView"](_r6);
      const ctx_r5 = _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵresetView"](ctx_r5.onNoClick());
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementStart"](5, "mat-icon");
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵtext"](6, "close");
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementEnd"]()()();
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementStart"](7, "div", 4);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelement"](8, "app-toggle-btn", 5);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementStart"](9, "div", 6);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵtemplate"](10, AddDiatryPlanComponent_div_0_div_10_Template, 3, 1, "div", 7);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementStart"](11, "div", 4);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelement"](12, "app-time-picker", 8);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementStart"](13, "div", 9)(14, "mat-label", 10);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵtext"](15, "Feeding Days*");
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelement"](16, "app-checkbox", 11);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementStart"](17, "div", 6);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵtemplate"](18, AddDiatryPlanComponent_div_0_div_18_Template, 2, 2, "div", 12);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵtemplate"](19, AddDiatryPlanComponent_div_0_div_19_Template, 2, 0, "div", 13);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementStart"](20, "div", 6);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelement"](21, "app-input", 14);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementStart"](22, "div", 15)(23, "button", 16);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵlistener"]("click", function AddDiatryPlanComponent_div_0_Template_button_click_23_listener() {
      _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵrestoreView"](_r6);
      const ctx_r7 = _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵresetView"](ctx_r7.onNoClick());
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵtext"](24, "Cancel");
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementStart"](25, "button", 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵlistener"]("click", function AddDiatryPlanComponent_div_0_Template_button_click_25_listener() {
      _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵrestoreView"](_r6);
      const ctx_r8 = _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵresetView"](ctx_r8.add());
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵtext"](26, "Save");
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementEnd"]()()();
  }
  if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵtextInterpolate"](ctx_r0.data["type"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵadvance"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵproperty"]("form", ctx_r0.form)("controller", ctx_r0.controlls["feedingTime"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵproperty"]("ngIf", ctx_r0.data["record"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵproperty"]("form", ctx_r0.form)("controller", ctx_r0.controlls["time"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵadvance"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵproperty"]("form", ctx_r0.form)("controller", ctx_r0.controlls["addDays"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵproperty"]("ngForOf", ctx_r0.weekdays);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵproperty"]("ngIf", ctx_r0.form.get("addDays").hasError("atLeastOneSelected"));
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵproperty"]("form", ctx_r0.form)("controller", ctx_r0.controlls["foodName"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵadvance"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵproperty"]("disabled", ctx_r0.form.invalid);
  }
}
class AddDiatryPlanComponent {
  constructor(dialogRef, data, validationsService, fb, petService, loader) {
    this.dialogRef = dialogRef;
    this.data = data;
    this.validationsService = validationsService;
    this.fb = fb;
    this.petService = petService;
    this.loader = loader;
    this.weekdays = ['Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat', 'Sun'];
    this.createControlls();
    this.createForm();
  }
  ngOnInit() {
    if (this.data['record']) {
      this.edit();
    }
    this.form.get('addDays').valueChanges.subscribe(chnage => {
      this.allDaysValuechanges(chnage);
    });
    const daysGroup = this.form.get('workSpaceTimings');
    Object.keys(daysGroup.controls).forEach(key => {
      daysGroup.get(key).valueChanges.subscribe(() => {
        const allChecked = Object.values(daysGroup.controls).every(control => control.value);
        if (this.form.get('addDays').value !== allChecked) {
          this.form.get('addDays').setValue(allChecked, {
            emitEvent: false
          });
        }
        // if(this.form.get('workSpaceTimings').get('Mon').value && this.form.get('workSpaceTimings').get('Tue').value && this.form.get('workSpaceTimings').get('Wed').value && this.form.get('workSpaceTimings').get('Thu').value && this.form.get('workSpaceTimings').get('Sat').value && this.form.get('workSpaceTimings').get('Sun').value && this.form.get('workSpaceTimings').get('Fri').value ){
        //   this.form.get()
        // }
      });
    });
  }
  edit() {
    let el = this.data['record'];
    console.log(el['plan']['time'].replace("am", "AM").replace("pm", "PM"));
    this.form = this.fb.group({
      id: [el['id']],
      feedingTime: [el['plan']['feedingTime'], _angular_forms__WEBPACK_IMPORTED_MODULE_8__.Validators.required],
      time: [el['plan']['time'].replace("am", "AM").replace("pm", "PM"), _angular_forms__WEBPACK_IMPORTED_MODULE_8__.Validators.required],
      reminder: [el['plan']['reminder']],
      addDays: [el['plan']['days'] == 'Daily' || el['plan']['days'] == 'daily' ? true : false],
      workSpaceTimings: this.fb.group({
        Mon: [''],
        Tue: [''],
        Wed: [''],
        Thu: [''],
        Fri: [''],
        Sat: [''],
        Sun: ['']
        // all : ['']
      }, {
        validator: this.validationsService.atLeastOneSelectedValidator()
      }),
      foodName: [el['plan']['foodName'], _angular_forms__WEBPACK_IMPORTED_MODULE_8__.Validators.required]
    });
    console.log(this.form.get('time').value);
    if (el['plan']['feedingDays']) {
      el['plan']['feedingDays'].forEach(day => {
        if (day == "Mon" || day == "monday") {
          this.form.get('workSpaceTimings').get('Mon').setValue(true);
        }
        if (day == "Tue" || day == "tuesday") {
          this.form.get('workSpaceTimings').get('Tue').setValue(true);
        }
        if (day == "Wed" || day == "wednesday") {
          this.form.get('workSpaceTimings').get('Wed').setValue(true);
        }
        if (day == "Thu" || day == "thursday") {
          this.form.get('workSpaceTimings').get('Thu').setValue(true);
        }
        if (day == "Fri" || day == "friday" || day == "fri") {
          this.form.get('workSpaceTimings').get('Fri').setValue(true);
        }
        if (day == "Sat" || day == "saturday") {
          this.form.get('workSpaceTimings').get('Sat').setValue(true);
        }
        if (day == "Sun" || day == "sunday") {
          this.form.get('workSpaceTimings').get('Sun').setValue(true);
        }
      });
    }
  }
  createForm() {
    this.form = this.fb.group({
      feedingTime: ['', _angular_forms__WEBPACK_IMPORTED_MODULE_8__.Validators.required],
      time: ['', _angular_forms__WEBPACK_IMPORTED_MODULE_8__.Validators.required],
      reminder: [false],
      addDays: [],
      workSpaceTimings: this.fb.group({
        Mon: [''],
        Tue: [''],
        Wed: [''],
        Thu: [''],
        Fri: [''],
        Sat: [''],
        Sun: ['']
        // all : ['']
      }, {
        validator: this.validationsService.atLeastOneSelectedValidator()
      }),
      foodName: ['', _angular_forms__WEBPACK_IMPORTED_MODULE_8__.Validators.required]
    });
  }
  allDaysValuechanges(chnage) {
    // this.formGroup.get('addDays').valueChanges.subscribe((chnage)=>{
    if (chnage == true) {
      this.weekdays.forEach(day => {
        this.form.get('workSpaceTimings').get(day).setValue(true);
      });
    } else {
      this.weekdays.forEach(day => {
        this.form.get('workSpaceTimings').get(day).setValue(false);
      });
    }
    // })
  }
  createControlls() {
    this.controlls = {
      feedingTime: {
        id: "feedingTime",
        name: 'feedingTime',
        label: "Feeding Time",
        placeholder: "Select Slot",
        required: true,
        options: [{
          name: 'Breakfast',
          value: 'Breakfast'
        }, {
          name: 'Lunch',
          value: 'Lunch'
        }, {
          name: 'Snacks',
          value: 'Snacks'
        }, {
          name: 'Dinner',
          value: 'Dinner'
        }],
        type: "toggle"
      },
      time: {
        id: "time",
        name: 'time',
        label: "",
        placeholder: "Select time",
        required: true,
        type: "text"
      },
      reminder: {
        id: "reminder",
        name: 'reminder',
        label: "Remind 15 minutes before the set time",
        placeholder: "",
        required: true,
        type: "Date"
      },
      foodName: {
        id: "foodName",
        name: 'foodName',
        label: "Food Name",
        placeholder: "Enter Food Name",
        required: true,
        type: "Date"
      },
      addDays: {
        id: "addDays",
        name: "addDays",
        label: "All Days"
      },
      workSpaceTimings: {
        Mon: {
          id: "Mon",
          name: 'Mon',
          label: "Mon",
          required: true,
          type: "checkbox"
        },
        Tue: {
          id: "Tue",
          name: 'Tue',
          label: "Tue",
          required: true,
          type: "checkbox"
        },
        Wed: {
          id: "Wed",
          name: 'Wed',
          label: "Wed",
          required: true,
          type: "checkbox"
        },
        Thu: {
          id: "Thu",
          name: 'Thu',
          label: "Thu",
          required: true,
          type: "checkbox"
        },
        Fri: {
          id: "Fri",
          name: 'Fri',
          label: "Fri",
          required: true,
          type: "checkbox"
        },
        Sat: {
          id: "Sat",
          name: 'Sat',
          label: "Sat",
          required: true,
          type: "checkbox"
        },
        Sun: {
          id: "Sun",
          name: 'Sun',
          label: "Sun",
          required: true,
          type: "checkbox"
        }
        // all: {
        //   id: "all",
        //   name: 'all',
        //   label: "All Days",
        //   required: true,
        //   type: "checkbox"
        // }
      }
    };
  }
  onNoClick() {
    this.dialogRef.close();
  }
  add() {
    let json = this.form.value;
    let data = {
      "docName": json['type'],
      "docDate": new Date(json['labTasteDate']).getTime(),
      "nextDate": new Date(json['nextDate']).getTime(),
      "period": null,
      "reminder": json['reminder'],
      "reminderDate": null,
      "type": 'DietPlan',
      "subType": json['title'],
      "plan": {
        "feedingTime": json['feedingTime'],
        "time": json['time'],
        "reminder": json['reminder'],
        "feedingDays": [],
        "foodName": json['foodName'],
        "days": json['addDays'] ? 'daily' : 'custom'
      },
      "petId": sessionStorage.getItem('petId'),
      "path": ''
    };
    // if (json['addDays'] == true) {
    //   data['plan']['feedingDays'].push('All');
    // }
    Object.keys(json['workSpaceTimings']).forEach(key => {
      if (key == "Mon" && json['workSpaceTimings']['Mon'] == true) {
        data['plan']['feedingDays'].push('monday');
      }
      if (key == "Tue" && json['workSpaceTimings']['Tue'] == true) {
        data['plan']['feedingDays'].push('tuesday');
      }
      if (key == "Wed" && json['workSpaceTimings']['Wed'] == true) {
        data['plan']['feedingDays'].push('wednesday');
      }
      if (key == "Thu" && json['workSpaceTimings']['Thu'] == true) {
        data['plan']['feedingDays'].push('thursday');
      }
      if (key == "Fri" && json['workSpaceTimings']['Fri'] == true) {
        data['plan']['feedingDays'].push('friday');
      }
      if (key == "Sat" && json['workSpaceTimings']['Sat'] == true) {
        data['plan']['feedingDays'].push('saturday');
      }
      if (key == "Sun" && json['workSpaceTimings']['Sun'] == true) {
        data['plan']['feedingDays'].push('sunday');
      }
      // if (json['workSpaceTimings'][key] == true) {
      //   data['plan']['feedingDays'].push(key);
      // }
    });
    if (this.data['record']) {
      data['id'] = this.data['record']['id'];
      data['fileDelete'] = false;
      this.loader.showLoader();
      this.petService.updateMedicalRecord(data, sessionStorage.getItem('petParentId'), this.data['record']['id'], data['fileDelete']).subscribe(res => {
        // this.petService.updateMedicalRecordImage(sessionStorage.getItem('petParentId'), sessionStorage.getItem('petId'), res['id'], json['document']).subscribe((res) => {
        this.petService.getMedicalRecord(sessionStorage.getItem('petId'), 'DietPlan').subscribe(res => {
          console.log(res);
          this.loader.hideLoader();
          this.dialogRef.close();
        });
        console.log(res);
        this.loader.hideLoader();
        this.dialogRef.close();
        // })
      });
    } else {
      this.loader.showLoader();
      this.petService.addMedicalRecord(data, sessionStorage.getItem('petParentId')).subscribe(res => {
        this.petService.medicalRecordData[5]['icon'] = './assets/icons/pet-history/diets.svg';
        this.loader.hideLoader();
        // this.petService.updateMedicalRecordImage(sessionStorage.getItem('petParentId'), sessionStorage.getItem('petId'), res['id'], json['document']).subscribe((res) => {
        console.log(res);
        this.petService.getMedicalRecord(sessionStorage.getItem('petId'), 'DietPlan').subscribe(res => {
          console.log(res);
          this.loader.hideLoader();
        });
        // })
        this.dialogRef.close();
      });
    }
  }
  onUpload(event) {
    this.form.get('document').setValue(event);
  }
  static #_ = this.ɵfac = function AddDiatryPlanComponent_Factory(t) {
    return new (t || AddDiatryPlanComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵdirectiveInject"](_angular_material_dialog__WEBPACK_IMPORTED_MODULE_9__.MatDialogRef), _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵdirectiveInject"](_angular_material_dialog__WEBPACK_IMPORTED_MODULE_9__.MAT_DIALOG_DATA), _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵdirectiveInject"](app_services_validations_service__WEBPACK_IMPORTED_MODULE_0__.ValidationsService), _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵdirectiveInject"](_angular_forms__WEBPACK_IMPORTED_MODULE_8__.FormBuilder), _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵdirectiveInject"](app_services_pet_service__WEBPACK_IMPORTED_MODULE_1__.PetService), _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵdirectiveInject"](app_services_loader_service__WEBPACK_IMPORTED_MODULE_2__.LoaderService));
  };
  static #_2 = this.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵdefineComponent"]({
    type: AddDiatryPlanComponent,
    selectors: [["app-add-diatry-plan"]],
    decls: 1,
    vars: 1,
    consts: [["mat-dialog-content", "", "class", "wrapper", 4, "ngIf"], ["mat-dialog-content", "", 1, "wrapper"], [1, "header"], ["mat-icon-button", "", "color", "primary", 3, "click"], [1, "row", 2, "padding-left", "1%"], ["multiple", "false", 3, "form", "controller"], [1, "row"], [4, "ngIf"], [2, "width", "50%", 3, "form", "controller"], [1, "row", 2, "width", "70%"], [2, "font-weight", "500", "padding-left", "10px"], [3, "form", "controller"], ["weekdays", "", 4, "ngFor", "ngForOf"], ["style", "color: red;", 4, "ngIf"], [2, "width", "100%", 3, "form", "controller"], [1, "btn-wrapper"], ["mat-stroked-button", "", "color", "primary", 3, "click"], ["mat-stroked-button", "", "color", "primary", 3, "disabled", "click"], ["weekdays", ""], [2, "color", "red"]],
    template: function AddDiatryPlanComponent_Template(rf, ctx) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵtemplate"](0, AddDiatryPlanComponent_div_0_Template, 27, 13, "div", 0);
      }
      if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵproperty"]("ngIf", ctx.data);
      }
    },
    dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_10__.NgForOf, _angular_common__WEBPACK_IMPORTED_MODULE_10__.NgIf, _components_controllers_input_input_component__WEBPACK_IMPORTED_MODULE_3__.InputComponent, _components_controllers_checkbox_checkbox_component__WEBPACK_IMPORTED_MODULE_4__.CheckboxComponent, _components_controllers_time_picker_time_picker_component__WEBPACK_IMPORTED_MODULE_5__.TimePickerComponent, _components_controllers_toggle_btn_toggle_btn_component__WEBPACK_IMPORTED_MODULE_6__.ToggleBtnComponent, _angular_material_button__WEBPACK_IMPORTED_MODULE_11__.MatButton, _angular_material_button__WEBPACK_IMPORTED_MODULE_11__.MatIconButton, _angular_material_icon__WEBPACK_IMPORTED_MODULE_12__.MatIcon, _angular_material_form_field__WEBPACK_IMPORTED_MODULE_13__.MatLabel],
    styles: [".header[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: row;\n  justify-content: space-between;\n}\n\n.row[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: row;\n  justify-content: space-between;\n  align-items: center;\n  width: 90%;\n  height: 20%;\n  margin: 1%;\n}\n\n.btn-wrapper[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: row;\n  justify-content: right;\n}\n.btn-wrapper[_ngcontent-%COMP%]   button[_ngcontent-%COMP%] {\n  margin: 10px;\n}\n\n.wrapper[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: column;\n}\n\n.header[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: row;\n  justify-content: space-between;\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImFkZC1kaWF0cnktcGxhbi5jb21wb25lbnQuc2NzcyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTtFQUNJLGFBQUE7RUFDQSxtQkFBQTtFQUNBLDhCQUFBO0FBQ0o7O0FBRUE7RUFDSSxhQUFBO0VBQ0EsbUJBQUE7RUFDQSw4QkFBQTtFQUNBLG1CQUFBO0VBQ0EsVUFBQTtFQUNBLFdBQUE7RUFDQSxVQUFBO0FBQ0o7O0FBQ0E7RUFDSSxhQUFBO0VBQ0EsbUJBQUE7RUFDQSxzQkFBQTtBQUVKO0FBREk7RUFDSSxZQUFBO0FBR1I7O0FBQUE7RUFDSSxhQUFBO0VBQ0Esc0JBQUE7QUFHSjs7QUFBQTtFQUNJLGFBQUE7RUFDQSxtQkFBQTtFQUNBLDhCQUFBO0FBR0oiLCJmaWxlIjoiYWRkLWRpYXRyeS1wbGFuLmNvbXBvbmVudC5zY3NzIiwic291cmNlc0NvbnRlbnQiOlsiLmhlYWRlcntcbiAgICBkaXNwbGF5OiBmbGV4O1xuICAgIGZsZXgtZGlyZWN0aW9uOiByb3c7XG4gICAganVzdGlmeS1jb250ZW50OiBzcGFjZS1iZXR3ZWVuO1xufVxuXG4ucm93e1xuICAgIGRpc3BsYXk6IGZsZXg7XG4gICAgZmxleC1kaXJlY3Rpb246IHJvdztcbiAgICBqdXN0aWZ5LWNvbnRlbnQ6IHNwYWNlLWJldHdlZW47XG4gICAgYWxpZ24taXRlbXM6IGNlbnRlcjtcbiAgICB3aWR0aDogOTAlO1xuICAgIGhlaWdodDogMjAlO1xuICAgIG1hcmdpbjogMSU7XG59XG4uYnRuLXdyYXBwZXJ7XG4gICAgZGlzcGxheTogZmxleDtcbiAgICBmbGV4LWRpcmVjdGlvbjogcm93O1xuICAgIGp1c3RpZnktY29udGVudDogcmlnaHQ7XG4gICAgYnV0dG9ue1xuICAgICAgICBtYXJnaW46IDEwcHg7XG4gICAgfVxufSBcbi53cmFwcGVye1xuICAgIGRpc3BsYXk6IGZsZXg7XG4gICAgZmxleC1kaXJlY3Rpb246IGNvbHVtbjtcblxufVxuLmhlYWRlcntcbiAgICBkaXNwbGF5OiBmbGV4O1xuICAgIGZsZXgtZGlyZWN0aW9uOiByb3c7XG4gICAganVzdGlmeS1jb250ZW50OiBzcGFjZS1iZXR3ZWVuO1xufVxuIl19 */\n/*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8uL3NyYy9hcHAvbW9kdWxlcy91c2VyLW1hbmFlbWVudC9tZWRpY2FsLXJlY29yZHMvYWRkLWRpYXRyeS1wbGFuL2FkZC1kaWF0cnktcGxhbi5jb21wb25lbnQuc2NzcyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTtFQUNJLGFBQUE7RUFDQSxtQkFBQTtFQUNBLDhCQUFBO0FBQ0o7O0FBRUE7RUFDSSxhQUFBO0VBQ0EsbUJBQUE7RUFDQSw4QkFBQTtFQUNBLG1CQUFBO0VBQ0EsVUFBQTtFQUNBLFdBQUE7RUFDQSxVQUFBO0FBQ0o7O0FBQ0E7RUFDSSxhQUFBO0VBQ0EsbUJBQUE7RUFDQSxzQkFBQTtBQUVKO0FBREk7RUFDSSxZQUFBO0FBR1I7O0FBQUE7RUFDSSxhQUFBO0VBQ0Esc0JBQUE7QUFHSjs7QUFBQTtFQUNJLGFBQUE7RUFDQSxtQkFBQTtFQUNBLDhCQUFBO0FBR0o7QUFDQSx3MENBQXcwQyIsInNvdXJjZXNDb250ZW50IjpbIi5oZWFkZXJ7XG4gICAgZGlzcGxheTogZmxleDtcbiAgICBmbGV4LWRpcmVjdGlvbjogcm93O1xuICAgIGp1c3RpZnktY29udGVudDogc3BhY2UtYmV0d2Vlbjtcbn1cblxuLnJvd3tcbiAgICBkaXNwbGF5OiBmbGV4O1xuICAgIGZsZXgtZGlyZWN0aW9uOiByb3c7XG4gICAganVzdGlmeS1jb250ZW50OiBzcGFjZS1iZXR3ZWVuO1xuICAgIGFsaWduLWl0ZW1zOiBjZW50ZXI7XG4gICAgd2lkdGg6IDkwJTtcbiAgICBoZWlnaHQ6IDIwJTtcbiAgICBtYXJnaW46IDElO1xufVxuLmJ0bi13cmFwcGVye1xuICAgIGRpc3BsYXk6IGZsZXg7XG4gICAgZmxleC1kaXJlY3Rpb246IHJvdztcbiAgICBqdXN0aWZ5LWNvbnRlbnQ6IHJpZ2h0O1xuICAgIGJ1dHRvbntcbiAgICAgICAgbWFyZ2luOiAxMHB4O1xuICAgIH1cbn0gXG4ud3JhcHBlcntcbiAgICBkaXNwbGF5OiBmbGV4O1xuICAgIGZsZXgtZGlyZWN0aW9uOiBjb2x1bW47XG5cbn1cbi5oZWFkZXJ7XG4gICAgZGlzcGxheTogZmxleDtcbiAgICBmbGV4LWRpcmVjdGlvbjogcm93O1xuICAgIGp1c3RpZnktY29udGVudDogc3BhY2UtYmV0d2Vlbjtcbn1cbiJdLCJzb3VyY2VSb290IjoiIn0= */"]
  });
}


/***/ }),

/***/ 56732:
/*!***************************************************************************************************!*\
  !*** ./src/app/modules/user-manaement/medical-records/add-lab-record/add-lab-record.component.ts ***!
  \***************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AddLabRecordComponent": () => (/* binding */ AddLabRecordComponent)
/* harmony export */ });
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @angular/forms */ 69542);
/* harmony import */ var _angular_material_dialog__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @angular/material/dialog */ 67486);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/core */ 86839);
/* harmony import */ var app_services_pet_service__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! app/services/pet.service */ 59976);
/* harmony import */ var app_services_loader_service__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! app/services/loader.service */ 38555);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @angular/common */ 86477);
/* harmony import */ var _components_controllers_input_input_component__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../../components/controllers/input/input.component */ 30867);
/* harmony import */ var _components_controllers_dropdown_dropdown_component__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../../components/controllers/dropdown/dropdown.component */ 29069);
/* harmony import */ var _components_controllers_date_picker_date_picker_component__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../../components/controllers/date-picker/date-picker.component */ 49582);
/* harmony import */ var _components_controllers_single_checkbox_single_checkbox_component__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../../components/controllers/single-checkbox/single-checkbox.component */ 59037);
/* harmony import */ var _components_controllers_upload_document_upload_document_component__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../../components/controllers/upload-document/upload-document.component */ 15698);
/* harmony import */ var _angular_material_button__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @angular/material/button */ 83677);
/* harmony import */ var _angular_material_icon__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @angular/material/icon */ 69941);















function AddLabRecordComponent_div_0_app_input_10_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelement"](0, "app-input", 5);
  }
  if (rf & 2) {
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵproperty"]("form", ctx_r1.form)("controller", ctx_r1.controlls["title"]);
  }
}
function AddLabRecordComponent_div_0_div_15_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementStart"](0, "div", 4)(1, "div", 13);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelement"](2, "app-single-checkbox", 5);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementEnd"]()();
  }
  if (rf & 2) {
    const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵproperty"]("form", ctx_r2.form)("controller", ctx_r2.controlls["reminder"]);
  }
}
function AddLabRecordComponent_div_0_Template(rf, ctx) {
  if (rf & 1) {
    const _r4 = _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementStart"](0, "div", 1)(1, "div", 2)(2, "h1");
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵtext"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementStart"](4, "button", 3);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵlistener"]("click", function AddLabRecordComponent_div_0_Template_button_click_4_listener() {
      _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵrestoreView"](_r4);
      const ctx_r3 = _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵresetView"](ctx_r3.onNoClick());
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementStart"](5, "mat-icon");
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵtext"](6, "close");
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementEnd"]()()();
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementStart"](7, "div", 4);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelement"](8, "app-dropdown", 5);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementStart"](9, "div", 4);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵtemplate"](10, AddLabRecordComponent_div_0_app_input_10_Template, 1, 2, "app-input", 6);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementStart"](11, "div", 7);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelement"](12, "app-date-picker", 5);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementStart"](13, "div", 7);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelement"](14, "app-date-picker", 5);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵtemplate"](15, AddLabRecordComponent_div_0_div_15_Template, 3, 2, "div", 8);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementStart"](16, "app-upload-document", 9);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵlistener"]("onSelect", function AddLabRecordComponent_div_0_Template_app_upload_document_onSelect_16_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵrestoreView"](_r4);
      const ctx_r5 = _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵresetView"](ctx_r5.onUpload($event));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementStart"](17, "div", 10)(18, "button", 11);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵlistener"]("click", function AddLabRecordComponent_div_0_Template_button_click_18_listener() {
      _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵrestoreView"](_r4);
      const ctx_r6 = _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵresetView"](ctx_r6.onNoClick());
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵtext"](19, "Cancel");
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementStart"](20, "button", 12);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵlistener"]("click", function AddLabRecordComponent_div_0_Template_button_click_20_listener() {
      _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵrestoreView"](_r4);
      const ctx_r7 = _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵresetView"](ctx_r7.add());
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵtext"](21, "Save");
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementEnd"]()()();
  }
  if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵtextInterpolate"](ctx_r0.data["type"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵadvance"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵproperty"]("form", ctx_r0.form)("controller", ctx_r0.controlls["type"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵproperty"]("ngIf", ctx_r0.form.get("type").value == "Others");
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵproperty"]("form", ctx_r0.form)("controller", ctx_r0.controlls["labTasteDate"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵproperty"]("form", ctx_r0.form)("controller", ctx_r0.controlls["nextDate"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵproperty"]("ngIf", ctx_r0.form.get("nextDate").value);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵproperty"]("form", ctx_r0.form);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵadvance"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵproperty"]("disabled", ctx_r0.form.invalid);
  }
}
class AddLabRecordComponent {
  constructor(dialogRef, data, fb, petService, loader) {
    this.dialogRef = dialogRef;
    this.data = data;
    this.fb = fb;
    this.petService = petService;
    this.loader = loader;
    this.isDocumentChanged = false;
    this.createControlls();
    this.createForm();
  }
  ngOnInit() {
    if (this.data['record']) {
      this.edit();
    }
    this.form.get('type').valueChanges.subscribe(change => {
      this.form.get('title').reset();
      if (change == 'Others') {
        this.form.get('title').setValidators(_angular_forms__WEBPACK_IMPORTED_MODULE_8__.Validators.required);
        this.form.get('title').updateValueAndValidity();
      } else {
        this.form.get('title').clearValidators();
        this.form.get('title').updateValueAndValidity();
      }
    });
  }
  edit() {
    let el = this.data['record'];
    this.form = this.fb.group({
      id: [el['id']],
      type: [el['docName'], _angular_forms__WEBPACK_IMPORTED_MODULE_8__.Validators.required],
      title: [el['subType']],
      labTasteDate: [el['docDate'] ? new Date(el['docDate']) : '', _angular_forms__WEBPACK_IMPORTED_MODULE_8__.Validators.required],
      nextDate: [el['nextDate'] ? new Date(el['nextDate']) : ''],
      reminder: [el['reminder'], _angular_forms__WEBPACK_IMPORTED_MODULE_8__.Validators.required],
      document: [el['path'] ? el['path'] : '']
    });
    if (el['docName'] == 'Others') {
      this.form.get('type').setValue('Others');
    }
  }
  createForm() {
    this.form = this.fb.group({
      type: ['', _angular_forms__WEBPACK_IMPORTED_MODULE_8__.Validators.required],
      title: ['', _angular_forms__WEBPACK_IMPORTED_MODULE_8__.Validators.required],
      labTasteDate: ['', _angular_forms__WEBPACK_IMPORTED_MODULE_8__.Validators.required],
      nextDate: [''],
      reminder: [false, _angular_forms__WEBPACK_IMPORTED_MODULE_8__.Validators.required],
      document: ['']
    });
  }
  createControlls() {
    this.controlls = {
      type: {
        id: "type",
        name: 'type',
        label: "Report Type*",
        required: true,
        options: [{
          name: 'Blood Test',
          value: 'Blood Test'
        }, {
          name: 'Urinalysis',
          value: 'Urinalysis'
        }, {
          name: 'Fecal Testing',
          value: 'Fecal Testing'
        }, {
          name: 'Heartworm Tests',
          value: 'Heartworm Tests'
        }, {
          name: 'X-Ray',
          value: 'X-Ray'
        }, {
          name: 'Ultrasound',
          value: 'Ultrasound'
        }, {
          name: 'Endoscopy',
          value: 'Endoscopy'
        }, {
          name: 'Biopsy',
          value: 'Biopsy'
        }, {
          name: 'Electrocardiogram (ECG)',
          value: 'Electrocardiogram (ECG)'
        }, {
          name: 'Magnetic Resonance Imaging (MRI)',
          value: 'Magnetic Resonance Imaging (MRI)'
        }, {
          name: 'Others',
          value: 'Others'
        }],
        type: "dropdown"
      },
      title: {
        id: "title",
        name: 'title',
        label: "Report Title",
        placeholder: "Enter Title",
        required: true,
        type: "text"
      },
      labTasteDate: {
        id: "labTasteDate",
        name: 'labTasteDate',
        label: "lab Test Done On",
        placeholder: "Select Date",
        required: true,
        type: "text"
      },
      nextDate: {
        id: "nextDate",
        name: 'nextDate',
        label: "Next test Due(Optional)",
        placeholder: "Enter Next Date",
        required: true,
        type: "text"
      },
      reminder: {
        id: "reminder",
        name: 'reminder',
        label: "Remind 1 day prior to due date",
        placeholder: "",
        required: true,
        type: "Date"
      }
    };
  }
  onNoClick() {
    this.dialogRef.close();
  }
  add() {
    console.log(this.data['record']);
    let json = this.form.value;
    const date = new Date(json['nextDate']);
    let data = {
      docName: json['type'],
      docDate: new Date(json['labTasteDate']).getTime(),
      nextDate: new Date(json['nextDate']).getTime(),
      period: '',
      reminder: json['reminder'],
      reminderDate: '',
      type: 'labRecord',
      subType: json['title'],
      plan: {},
      petId: sessionStorage.getItem('petId'),
      path: ''
    };
    if (this.data['record']) {
      data['id'] = this.data['record']['id'];
      if (json['document']) {
        data['fileDelete'] = false;
      } else {
        data['fileDelete'] = true;
      }
      this.loader.showLoader();
      this.petService.updateMedicalRecord(data, sessionStorage.getItem('petParentId'), this.data['record']['id'], data['fileDelete']).subscribe(res => {
        if (json['document']) {
          if (this.isDocumentChanged) {
            this.petService.updateMedicalRecordImage(sessionStorage.getItem('petParentId'), sessionStorage.getItem('petId'), res['id'], json['document']).subscribe(res => {
              this.petService.getMedicalRecord(sessionStorage.getItem('petId'), 'labRecord').subscribe(res => {
                console.log(res);
                this.loader.hideLoader();
                this.dialogRef.close();
              });
              console.log(res);
              this.loader.hideLoader();
            });
          } else {
            this.petService.getMedicalRecord(sessionStorage.getItem('petId'), 'labRecord').subscribe(res => {
              console.log(res);
              this.loader.hideLoader();
              this.dialogRef.close();
            });
          }
        } else {
          this.petService.getMedicalRecord(sessionStorage.getItem('petId'), 'labRecord').subscribe(res => {
            console.log(res);
            this.loader.hideLoader();
            this.dialogRef.close();
          });
        }
      }, error => {
        console.log(error);
        this.dialogRef.close();
      });
    } else {
      this.loader.showLoader();
      this.petService.addMedicalRecord(data, sessionStorage.getItem('petParentId')).subscribe(res => {
        this.petService.medicalRecordData[1]['icon'] = './assets/icons/pet-history/lab rec.svg';
        if (json['document']) {
          this.petService.updateMedicalRecordImage(sessionStorage.getItem('petParentId'), sessionStorage.getItem('petId'), res['id'], json['document']).subscribe(res => {
            console.log(res);
            this.dialogRef.close();
          });
        } else {
          this.petService.getMedicalRecord(sessionStorage.getItem('petId'), 'labRecord').subscribe(res => {
            console.log(res);
            this.dialogRef.close();
          });
        }
        this.loader.hideLoader();
        this.dialogRef.close();
      });
    }
  }
  onUpload(event) {
    console.log("change", event);
    this.form.get('document').setValue(event);
    this.isDocumentChanged = true;
    // if(this.data['record']){
    //   console.log(this.data['record']);
    //   console.log(this.form.get('document').value);
    //   this.petService.updateMedicalRecordImage(sessionStorage.getItem('petParentId'), sessionStorage.getItem('petId'), this.data['record']['id'], this.form.get('document').value).subscribe((res) => {
    //     console.log(res);
    //   })
    // }
  }
  static #_ = this.ɵfac = function AddLabRecordComponent_Factory(t) {
    return new (t || AddLabRecordComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵdirectiveInject"](_angular_material_dialog__WEBPACK_IMPORTED_MODULE_9__.MatDialogRef), _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵdirectiveInject"](_angular_material_dialog__WEBPACK_IMPORTED_MODULE_9__.MAT_DIALOG_DATA), _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵdirectiveInject"](_angular_forms__WEBPACK_IMPORTED_MODULE_8__.FormBuilder), _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵdirectiveInject"](app_services_pet_service__WEBPACK_IMPORTED_MODULE_0__.PetService), _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵdirectiveInject"](app_services_loader_service__WEBPACK_IMPORTED_MODULE_1__.LoaderService));
  };
  static #_2 = this.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵdefineComponent"]({
    type: AddLabRecordComponent,
    selectors: [["app-add-lab-record"]],
    decls: 1,
    vars: 1,
    consts: [["mat-dialog-content", "", "class", "wrapper", 4, "ngIf"], ["mat-dialog-content", "", 1, "wrapper"], [1, "header"], ["mat-icon-button", "", "color", "primary", 3, "click"], [1, "row"], [2, "width", "100%", 3, "form", "controller"], ["style", "width: 100%;", 3, "form", "controller", 4, "ngIf"], [1, "row", 2, "height", "20%"], ["class", "row", 4, "ngIf"], [3, "form", "onSelect"], [1, "btn-wrapper"], ["mat-stroked-button", "", "color", "primary", 3, "click"], ["mat-stroked-button", "", "color", "primary", 3, "disabled", "click"], [1, "row", 2, "height", "15%", "padding-left", "1%"]],
    template: function AddLabRecordComponent_Template(rf, ctx) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵtemplate"](0, AddLabRecordComponent_div_0_Template, 22, 11, "div", 0);
      }
      if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵproperty"]("ngIf", ctx.data);
      }
    },
    dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_10__.NgIf, _components_controllers_input_input_component__WEBPACK_IMPORTED_MODULE_2__.InputComponent, _components_controllers_dropdown_dropdown_component__WEBPACK_IMPORTED_MODULE_3__.DropdownComponent, _components_controllers_date_picker_date_picker_component__WEBPACK_IMPORTED_MODULE_4__.DatePickerComponent, _components_controllers_single_checkbox_single_checkbox_component__WEBPACK_IMPORTED_MODULE_5__.SingleCheckboxComponent, _components_controllers_upload_document_upload_document_component__WEBPACK_IMPORTED_MODULE_6__.UploadDocumentComponent, _angular_material_button__WEBPACK_IMPORTED_MODULE_11__.MatButton, _angular_material_button__WEBPACK_IMPORTED_MODULE_11__.MatIconButton, _angular_material_icon__WEBPACK_IMPORTED_MODULE_12__.MatIcon],
    styles: [".header[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: row;\n  justify-content: space-between;\n}\n\n.row[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: column;\n  width: 90%;\n  height: 20%;\n  margin: 1%;\n}\n\n.btn-wrapper[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: row;\n  justify-content: right;\n}\n.btn-wrapper[_ngcontent-%COMP%]   button[_ngcontent-%COMP%] {\n  margin: 10px;\n}\n\n.wrapper[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: column;\n}\n\n.header[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: row;\n  justify-content: space-between;\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImFkZC1sYWItcmVjb3JkLmNvbXBvbmVudC5zY3NzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBO0VBQ0ksYUFBQTtFQUNBLG1CQUFBO0VBQ0EsOEJBQUE7QUFDSjs7QUFFQTtFQUNJLGFBQUE7RUFDQSxzQkFBQTtFQUNBLFVBQUE7RUFDQSxXQUFBO0VBQ0EsVUFBQTtBQUNKOztBQUNBO0VBQ0ksYUFBQTtFQUNBLG1CQUFBO0VBQ0Esc0JBQUE7QUFFSjtBQURJO0VBQ0ksWUFBQTtBQUdSOztBQUFBO0VBQ0ksYUFBQTtFQUNBLHNCQUFBO0FBR0o7O0FBQUE7RUFDSSxhQUFBO0VBQ0EsbUJBQUE7RUFDQSw4QkFBQTtBQUdKIiwiZmlsZSI6ImFkZC1sYWItcmVjb3JkLmNvbXBvbmVudC5zY3NzIiwic291cmNlc0NvbnRlbnQiOlsiLmhlYWRlcntcbiAgICBkaXNwbGF5OiBmbGV4O1xuICAgIGZsZXgtZGlyZWN0aW9uOiByb3c7XG4gICAganVzdGlmeS1jb250ZW50OiBzcGFjZS1iZXR3ZWVuO1xufVxuXG4ucm93e1xuICAgIGRpc3BsYXk6IGZsZXg7XG4gICAgZmxleC1kaXJlY3Rpb246IGNvbHVtbjtcbiAgICB3aWR0aDogOTAlO1xuICAgIGhlaWdodDogMjAlO1xuICAgIG1hcmdpbjogMSU7XG59XG4uYnRuLXdyYXBwZXJ7XG4gICAgZGlzcGxheTogZmxleDtcbiAgICBmbGV4LWRpcmVjdGlvbjogcm93O1xuICAgIGp1c3RpZnktY29udGVudDogcmlnaHQ7XG4gICAgYnV0dG9ue1xuICAgICAgICBtYXJnaW46IDEwcHg7XG4gICAgfVxufSBcbi53cmFwcGVye1xuICAgIGRpc3BsYXk6IGZsZXg7XG4gICAgZmxleC1kaXJlY3Rpb246IGNvbHVtbjtcblxufVxuLmhlYWRlcntcbiAgICBkaXNwbGF5OiBmbGV4O1xuICAgIGZsZXgtZGlyZWN0aW9uOiByb3c7XG4gICAganVzdGlmeS1jb250ZW50OiBzcGFjZS1iZXR3ZWVuO1xufVxuIl19 */\n/*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8uL3NyYy9hcHAvbW9kdWxlcy91c2VyLW1hbmFlbWVudC9tZWRpY2FsLXJlY29yZHMvYWRkLWxhYi1yZWNvcmQvYWRkLWxhYi1yZWNvcmQuY29tcG9uZW50LnNjc3MiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7RUFDSSxhQUFBO0VBQ0EsbUJBQUE7RUFDQSw4QkFBQTtBQUNKOztBQUVBO0VBQ0ksYUFBQTtFQUNBLHNCQUFBO0VBQ0EsVUFBQTtFQUNBLFdBQUE7RUFDQSxVQUFBO0FBQ0o7O0FBQ0E7RUFDSSxhQUFBO0VBQ0EsbUJBQUE7RUFDQSxzQkFBQTtBQUVKO0FBREk7RUFDSSxZQUFBO0FBR1I7O0FBQUE7RUFDSSxhQUFBO0VBQ0Esc0JBQUE7QUFHSjs7QUFBQTtFQUNJLGFBQUE7RUFDQSxtQkFBQTtFQUNBLDhCQUFBO0FBR0o7QUFDQSx3dENBQXd0QyIsInNvdXJjZXNDb250ZW50IjpbIi5oZWFkZXJ7XG4gICAgZGlzcGxheTogZmxleDtcbiAgICBmbGV4LWRpcmVjdGlvbjogcm93O1xuICAgIGp1c3RpZnktY29udGVudDogc3BhY2UtYmV0d2Vlbjtcbn1cblxuLnJvd3tcbiAgICBkaXNwbGF5OiBmbGV4O1xuICAgIGZsZXgtZGlyZWN0aW9uOiBjb2x1bW47XG4gICAgd2lkdGg6IDkwJTtcbiAgICBoZWlnaHQ6IDIwJTtcbiAgICBtYXJnaW46IDElO1xufVxuLmJ0bi13cmFwcGVye1xuICAgIGRpc3BsYXk6IGZsZXg7XG4gICAgZmxleC1kaXJlY3Rpb246IHJvdztcbiAgICBqdXN0aWZ5LWNvbnRlbnQ6IHJpZ2h0O1xuICAgIGJ1dHRvbntcbiAgICAgICAgbWFyZ2luOiAxMHB4O1xuICAgIH1cbn0gXG4ud3JhcHBlcntcbiAgICBkaXNwbGF5OiBmbGV4O1xuICAgIGZsZXgtZGlyZWN0aW9uOiBjb2x1bW47XG5cbn1cbi5oZWFkZXJ7XG4gICAgZGlzcGxheTogZmxleDtcbiAgICBmbGV4LWRpcmVjdGlvbjogcm93O1xuICAgIGp1c3RpZnktY29udGVudDogc3BhY2UtYmV0d2Vlbjtcbn1cbiJdLCJzb3VyY2VSb290IjoiIn0= */"]
  });
}


/***/ }),

/***/ 3882:
/*!*********************************************************************************************************!*\
  !*** ./src/app/modules/user-manaement/medical-records/add-prescriptions/add-prescriptions.component.ts ***!
  \*********************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AddPrescriptionsComponent": () => (/* binding */ AddPrescriptionsComponent)
/* harmony export */ });
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/forms */ 69542);
/* harmony import */ var _angular_material_dialog__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/material/dialog */ 67486);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/core */ 86839);
/* harmony import */ var app_services_pet_service__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! app/services/pet.service */ 59976);
/* harmony import */ var app_services_loader_service__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! app/services/loader.service */ 38555);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @angular/common */ 86477);
/* harmony import */ var _components_controllers_input_input_component__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../../components/controllers/input/input.component */ 30867);
/* harmony import */ var _components_controllers_date_picker_date_picker_component__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../../components/controllers/date-picker/date-picker.component */ 49582);
/* harmony import */ var _components_controllers_upload_document_upload_document_component__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../../components/controllers/upload-document/upload-document.component */ 15698);
/* harmony import */ var _angular_material_button__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @angular/material/button */ 83677);
/* harmony import */ var _angular_material_icon__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @angular/material/icon */ 69941);













function AddPrescriptionsComponent_div_0_Template(rf, ctx) {
  if (rf & 1) {
    const _r2 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "div", 1)(1, "div", 2)(2, "h1");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](4, "button", 3);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵlistener"]("click", function AddPrescriptionsComponent_div_0_Template_button_click_4_listener() {
      _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵrestoreView"](_r2);
      const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵresetView"](ctx_r1.onNoClick());
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](5, "mat-icon");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](6, "close");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]()()();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](7, "div", 4);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelement"](8, "app-input", 5);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](9, "div", 6);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelement"](10, "app-date-picker", 5);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](11, "app-upload-document", 7);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵlistener"]("onSelect", function AddPrescriptionsComponent_div_0_Template_app_upload_document_onSelect_11_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵrestoreView"](_r2);
      const ctx_r3 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵresetView"](ctx_r3.onUpload($event));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](12, "div", 8)(13, "button", 9);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵlistener"]("click", function AddPrescriptionsComponent_div_0_Template_button_click_13_listener() {
      _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵrestoreView"](_r2);
      const ctx_r4 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵresetView"](ctx_r4.onNoClick());
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](14, "Cancel");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](15, "button", 10);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵlistener"]("click", function AddPrescriptionsComponent_div_0_Template_button_click_15_listener() {
      _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵrestoreView"](_r2);
      const ctx_r5 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵresetView"](ctx_r5.add());
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](16, "Save");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]()()();
  }
  if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtextInterpolate"](ctx_r0.data["type"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("form", ctx_r0.form)("controller", ctx_r0.controlls["title"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("form", ctx_r0.form)("controller", ctx_r0.controlls["receivedDate"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("form", ctx_r0.form);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("disabled", ctx_r0.form.invalid);
  }
}
class AddPrescriptionsComponent {
  constructor(dialogRef, data, fb, petService, loader) {
    this.dialogRef = dialogRef;
    this.data = data;
    this.fb = fb;
    this.petService = petService;
    this.loader = loader;
    this.isDocumentChange = false;
    this.createControlls();
    this.createForm();
  }
  ngOnInit() {
    if (this.data['record']) {
      this.edit();
    }
  }
  edit() {
    let el = this.data['record'];
    this.form = this.fb.group({
      id: [el['id']],
      title: [el['docName'], _angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.required],
      receivedDate: [new Date(el['docDate']), _angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.required],
      document: [el['path'] ? el['path'] : '']
    });
  }
  createForm() {
    this.form = this.fb.group({
      title: ['', _angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.required],
      receivedDate: ['', _angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.required],
      document: ['']
    });
  }
  createControlls() {
    this.controlls = {
      title: {
        id: "title",
        name: 'title',
        label: "Prescription  Title",
        placeholder: "Enter Prescription  Title",
        required: true,
        type: "text"
      },
      receivedDate: {
        id: "receivedDate",
        name: 'receivedDate',
        label: "Received On",
        placeholder: "Select Date",
        required: true,
        type: "text"
      }
    };
  }
  onNoClick() {
    this.dialogRef.close();
  }
  add() {
    let json = this.form.value;
    const date = new Date(json['nextDate']);
    let data = {
      docName: json['title'],
      docDate: new Date(json['receivedDate']).getTime(),
      nextDate: '',
      period: '',
      reminder: '',
      reminderDate: '',
      type: 'priscription',
      subType: json['otherVal'],
      plan: {},
      petId: sessionStorage.getItem('petId'),
      path: ''
    };
    if (this.data['record']) {
      data['id'] = this.data['record']['id'];
      if (json['document']) {
        data['fileDelete'] = false;
      } else {
        data['fileDelete'] = true;
      }
      this.loader.showLoader();
      this.petService.updateMedicalRecord(data, sessionStorage.getItem('petParentId'), this.data['record']['id'], data['fileDelete']).subscribe(res => {
        if (json['document']) {
          this.petService.updateMedicalRecordImage(sessionStorage.getItem('petParentId'), sessionStorage.getItem('petId'), res['id'], json['document']).subscribe(res => {
            this.petService.getMedicalRecord(sessionStorage.getItem('petId'), 'priscription').subscribe(res => {
              console.log(res);
              this.loader.hideLoader();
              this.dialogRef.close();
            });
            console.log(res);
          });
        } else {
          this.petService.getMedicalRecord(sessionStorage.getItem('petId'), 'priscription').subscribe(res => {
            this.petService.medicalRecordData[3]['icon'] = './assets/icons/pet-history/prescriptions.svg';
            console.log(res);
            this.loader.hideLoader();
            this.dialogRef.close();
          });
        }
      });
    } else {
      this.loader.showLoader();
      this.petService.addMedicalRecord(data, sessionStorage.getItem('petParentId')).subscribe(res => {
        if (json['document']) {
          if (this.isDocumentChange) {
            this.petService.updateMedicalRecordImage(sessionStorage.getItem('petParentId'), sessionStorage.getItem('petId'), res['id'], json['document']).subscribe(res => {
              console.log(res);
              this.petService.getMedicalRecord(sessionStorage.getItem('petId'), 'priscription').subscribe(res => {
                console.log(res);
                this.loader.hideLoader();
                this.dialogRef.close();
              });
            });
          } else {
            this.petService.getMedicalRecord(sessionStorage.getItem('petId'), 'priscription').subscribe(res => {
              console.log(res);
              this.loader.hideLoader();
              this.dialogRef.close();
            });
          }
        } else {
          this.petService.getMedicalRecord(sessionStorage.getItem('petId'), 'priscription').subscribe(res => {
            console.log(res);
            this.loader.hideLoader();
            this.dialogRef.close();
          });
        }
      });
    }
  }
  onUpload(event) {
    this.form.get('document').setValue(event);
    this.isDocumentChange = true;
  }
  static #_ = this.ɵfac = function AddPrescriptionsComponent_Factory(t) {
    return new (t || AddPrescriptionsComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](_angular_material_dialog__WEBPACK_IMPORTED_MODULE_7__.MatDialogRef), _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](_angular_material_dialog__WEBPACK_IMPORTED_MODULE_7__.MAT_DIALOG_DATA), _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](_angular_forms__WEBPACK_IMPORTED_MODULE_6__.FormBuilder), _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](app_services_pet_service__WEBPACK_IMPORTED_MODULE_0__.PetService), _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](app_services_loader_service__WEBPACK_IMPORTED_MODULE_1__.LoaderService));
  };
  static #_2 = this.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdefineComponent"]({
    type: AddPrescriptionsComponent,
    selectors: [["app-add-prescriptions"]],
    decls: 1,
    vars: 1,
    consts: [["mat-dialog-content", "", "class", "wrapper", 4, "ngIf"], ["mat-dialog-content", "", 1, "wrapper"], [1, "header"], ["mat-icon-button", "", "color", "primary", 3, "click"], [1, "row"], [2, "width", "100%", 3, "form", "controller"], [1, "row", 2, "height", "20%"], [3, "form", "onSelect"], [1, "btn-wrapper"], ["mat-stroked-button", "", "color", "primary", 3, "click"], ["mat-stroked-button", "", "color", "primary", 3, "disabled", "click"]],
    template: function AddPrescriptionsComponent_Template(rf, ctx) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](0, AddPrescriptionsComponent_div_0_Template, 17, 7, "div", 0);
      }
      if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("ngIf", ctx.data);
      }
    },
    dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_8__.NgIf, _components_controllers_input_input_component__WEBPACK_IMPORTED_MODULE_2__.InputComponent, _components_controllers_date_picker_date_picker_component__WEBPACK_IMPORTED_MODULE_3__.DatePickerComponent, _components_controllers_upload_document_upload_document_component__WEBPACK_IMPORTED_MODULE_4__.UploadDocumentComponent, _angular_material_button__WEBPACK_IMPORTED_MODULE_9__.MatButton, _angular_material_button__WEBPACK_IMPORTED_MODULE_9__.MatIconButton, _angular_material_icon__WEBPACK_IMPORTED_MODULE_10__.MatIcon],
    styles: [".header[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: row;\n  justify-content: space-between;\n}\n\n.row[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: column;\n  width: 90%;\n  height: 20%;\n  margin: 1%;\n}\n\n.btn-wrapper[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: row;\n  justify-content: right;\n}\n.btn-wrapper[_ngcontent-%COMP%]   button[_ngcontent-%COMP%] {\n  margin: 10px;\n}\n\n.wrapper[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: column;\n}\n\n.header[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: row;\n  justify-content: space-between;\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImFkZC1wcmVzY3JpcHRpb25zLmNvbXBvbmVudC5zY3NzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBO0VBQ0ksYUFBQTtFQUNBLG1CQUFBO0VBQ0EsOEJBQUE7QUFDSjs7QUFFQTtFQUNJLGFBQUE7RUFDQSxzQkFBQTtFQUNBLFVBQUE7RUFDQSxXQUFBO0VBQ0EsVUFBQTtBQUNKOztBQUNBO0VBQ0ksYUFBQTtFQUNBLG1CQUFBO0VBQ0Esc0JBQUE7QUFFSjtBQURJO0VBQ0ksWUFBQTtBQUdSOztBQUFBO0VBQ0ksYUFBQTtFQUNBLHNCQUFBO0FBR0o7O0FBQUE7RUFDSSxhQUFBO0VBQ0EsbUJBQUE7RUFDQSw4QkFBQTtBQUdKIiwiZmlsZSI6ImFkZC1wcmVzY3JpcHRpb25zLmNvbXBvbmVudC5zY3NzIiwic291cmNlc0NvbnRlbnQiOlsiLmhlYWRlcntcbiAgICBkaXNwbGF5OiBmbGV4O1xuICAgIGZsZXgtZGlyZWN0aW9uOiByb3c7XG4gICAganVzdGlmeS1jb250ZW50OiBzcGFjZS1iZXR3ZWVuO1xufVxuXG4ucm93e1xuICAgIGRpc3BsYXk6IGZsZXg7XG4gICAgZmxleC1kaXJlY3Rpb246IGNvbHVtbjtcbiAgICB3aWR0aDogOTAlO1xuICAgIGhlaWdodDogMjAlO1xuICAgIG1hcmdpbjogMSU7XG59XG4uYnRuLXdyYXBwZXJ7XG4gICAgZGlzcGxheTogZmxleDtcbiAgICBmbGV4LWRpcmVjdGlvbjogcm93O1xuICAgIGp1c3RpZnktY29udGVudDogcmlnaHQ7XG4gICAgYnV0dG9ue1xuICAgICAgICBtYXJnaW46IDEwcHg7XG4gICAgfVxufSBcbi53cmFwcGVye1xuICAgIGRpc3BsYXk6IGZsZXg7XG4gICAgZmxleC1kaXJlY3Rpb246IGNvbHVtbjtcblxufVxuLmhlYWRlcntcbiAgICBkaXNwbGF5OiBmbGV4O1xuICAgIGZsZXgtZGlyZWN0aW9uOiByb3c7XG4gICAganVzdGlmeS1jb250ZW50OiBzcGFjZS1iZXR3ZWVuO1xufVxuIl19 */\n/*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8uL3NyYy9hcHAvbW9kdWxlcy91c2VyLW1hbmFlbWVudC9tZWRpY2FsLXJlY29yZHMvYWRkLXByZXNjcmlwdGlvbnMvYWRkLXByZXNjcmlwdGlvbnMuY29tcG9uZW50LnNjc3MiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7RUFDSSxhQUFBO0VBQ0EsbUJBQUE7RUFDQSw4QkFBQTtBQUNKOztBQUVBO0VBQ0ksYUFBQTtFQUNBLHNCQUFBO0VBQ0EsVUFBQTtFQUNBLFdBQUE7RUFDQSxVQUFBO0FBQ0o7O0FBQ0E7RUFDSSxhQUFBO0VBQ0EsbUJBQUE7RUFDQSxzQkFBQTtBQUVKO0FBREk7RUFDSSxZQUFBO0FBR1I7O0FBQUE7RUFDSSxhQUFBO0VBQ0Esc0JBQUE7QUFHSjs7QUFBQTtFQUNJLGFBQUE7RUFDQSxtQkFBQTtFQUNBLDhCQUFBO0FBR0o7QUFDQSxndUNBQWd1QyIsInNvdXJjZXNDb250ZW50IjpbIi5oZWFkZXJ7XG4gICAgZGlzcGxheTogZmxleDtcbiAgICBmbGV4LWRpcmVjdGlvbjogcm93O1xuICAgIGp1c3RpZnktY29udGVudDogc3BhY2UtYmV0d2Vlbjtcbn1cblxuLnJvd3tcbiAgICBkaXNwbGF5OiBmbGV4O1xuICAgIGZsZXgtZGlyZWN0aW9uOiBjb2x1bW47XG4gICAgd2lkdGg6IDkwJTtcbiAgICBoZWlnaHQ6IDIwJTtcbiAgICBtYXJnaW46IDElO1xufVxuLmJ0bi13cmFwcGVye1xuICAgIGRpc3BsYXk6IGZsZXg7XG4gICAgZmxleC1kaXJlY3Rpb246IHJvdztcbiAgICBqdXN0aWZ5LWNvbnRlbnQ6IHJpZ2h0O1xuICAgIGJ1dHRvbntcbiAgICAgICAgbWFyZ2luOiAxMHB4O1xuICAgIH1cbn0gXG4ud3JhcHBlcntcbiAgICBkaXNwbGF5OiBmbGV4O1xuICAgIGZsZXgtZGlyZWN0aW9uOiBjb2x1bW47XG5cbn1cbi5oZWFkZXJ7XG4gICAgZGlzcGxheTogZmxleDtcbiAgICBmbGV4LWRpcmVjdGlvbjogcm93O1xuICAgIGp1c3RpZnktY29udGVudDogc3BhY2UtYmV0d2Vlbjtcbn1cbiJdLCJzb3VyY2VSb290IjoiIn0= */"]
  });
}


/***/ }),

/***/ 71516:
/*!*******************************************************************************************************************!*\
  !*** ./src/app/modules/user-manaement/medical-records/add-vaccination-record/add-vaccination-record.component.ts ***!
  \*******************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AddVaccinationRecordComponent": () => (/* binding */ AddVaccinationRecordComponent)
/* harmony export */ });
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @angular/forms */ 69542);
/* harmony import */ var _angular_material_dialog__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @angular/material/dialog */ 67486);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @angular/core */ 86839);
/* harmony import */ var app_services_pet_service__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! app/services/pet.service */ 59976);
/* harmony import */ var app_services_loader_service__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! app/services/loader.service */ 38555);
/* harmony import */ var app_services_user_management_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! app/services/user-management.service */ 32555);
/* harmony import */ var _angular_material_snack_bar__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @angular/material/snack-bar */ 88511);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @angular/common */ 86477);
/* harmony import */ var _components_controllers_input_input_component__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../../components/controllers/input/input.component */ 30867);
/* harmony import */ var _components_controllers_dropdown_dropdown_component__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../../components/controllers/dropdown/dropdown.component */ 29069);
/* harmony import */ var _components_controllers_date_picker_date_picker_component__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../../components/controllers/date-picker/date-picker.component */ 49582);
/* harmony import */ var _components_controllers_single_checkbox_single_checkbox_component__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../../components/controllers/single-checkbox/single-checkbox.component */ 59037);
/* harmony import */ var _components_controllers_toggle_btn_toggle_btn_component__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../../../components/controllers/toggle-btn/toggle-btn.component */ 67212);
/* harmony import */ var _components_controllers_upload_document_upload_document_component__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../../../components/controllers/upload-document/upload-document.component */ 15698);
/* harmony import */ var _angular_material_button__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @angular/material/button */ 83677);
/* harmony import */ var _angular_material_icon__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! @angular/material/icon */ 69941);
/* harmony import */ var _angular_material_tooltip__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! @angular/material/tooltip */ 52423);



















function AddVaccinationRecordComponent_div_0_div_7_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementStart"](0, "div", 14);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelement"](1, "app-dropdown", 15);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const ctx_r1 = _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵproperty"]("form", ctx_r1.form)("controller", ctx_r1.controlls["type"]);
  }
}
function AddVaccinationRecordComponent_div_0_div_8_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementStart"](0, "div", 14);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelement"](1, "app-input", 15);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵproperty"]("form", ctx_r2.form)("controller", ctx_r2.controlls["otherVal"]);
  }
}
function AddVaccinationRecordComponent_div_0_div_13_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementStart"](0, "div", 16);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelement"](1, "app-toggle-btn", 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const ctx_r3 = _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵproperty"]("form", ctx_r3.form)("controller", ctx_r3.controlls["selectSlot"]);
  }
}
function AddVaccinationRecordComponent_div_0_div_14_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementStart"](0, "div", 14)(1, "mat-icon", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵtext"](2, " info ");
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementEnd"]()();
  }
  if (rf & 2) {
    const ctx_r4 = _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵproperty"]("matTooltip", ctx_r4.vaccinationSchedule);
  }
}
function AddVaccinationRecordComponent_div_0_div_15_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementStart"](0, "div", 19);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelement"](1, "app-single-checkbox", 15);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const ctx_r5 = _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵnextContext"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵproperty"]("form", ctx_r5.form)("controller", ctx_r5.controlls["reminder"]);
  }
}
function AddVaccinationRecordComponent_div_0_Template(rf, ctx) {
  if (rf & 1) {
    const _r7 = _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementStart"](0, "div", 1)(1, "div", 2)(2, "h1");
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵtext"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementStart"](4, "button", 3);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵlistener"]("click", function AddVaccinationRecordComponent_div_0_Template_button_click_4_listener() {
      _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵrestoreView"](_r7);
      const ctx_r6 = _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵresetView"](ctx_r6.onNoClick());
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementStart"](5, "mat-icon");
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵtext"](6, "close");
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementEnd"]()()();
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵtemplate"](7, AddVaccinationRecordComponent_div_0_div_7_Template, 2, 2, "div", 4);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵtemplate"](8, AddVaccinationRecordComponent_div_0_div_8_Template, 2, 2, "div", 4);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementStart"](9, "div", 5);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelement"](10, "app-date-picker", 6);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementStart"](11, "div", 5)(12, "app-date-picker", 7);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵlistener"]("DateChange", function AddVaccinationRecordComponent_div_0_Template_app_date_picker_DateChange_12_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵrestoreView"](_r7);
      const ctx_r8 = _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵresetView"](ctx_r8.onDateChange($event));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementEnd"]()();
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵtemplate"](13, AddVaccinationRecordComponent_div_0_div_13_Template, 2, 2, "div", 8);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵtemplate"](14, AddVaccinationRecordComponent_div_0_div_14_Template, 3, 1, "div", 4);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵtemplate"](15, AddVaccinationRecordComponent_div_0_div_15_Template, 2, 2, "div", 9);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementStart"](16, "app-upload-document", 10);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵlistener"]("onSelect", function AddVaccinationRecordComponent_div_0_Template_app_upload_document_onSelect_16_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵrestoreView"](_r7);
      const ctx_r9 = _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵresetView"](ctx_r9.onUpload($event));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementStart"](17, "div", 11)(18, "button", 12);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵlistener"]("click", function AddVaccinationRecordComponent_div_0_Template_button_click_18_listener() {
      _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵrestoreView"](_r7);
      const ctx_r10 = _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵresetView"](ctx_r10.onNoClick());
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵtext"](19, "Cancel");
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementStart"](20, "button", 13);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵlistener"]("click", function AddVaccinationRecordComponent_div_0_Template_button_click_20_listener() {
      _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵrestoreView"](_r7);
      const ctx_r11 = _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵresetView"](ctx_r11.add());
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵtext"](21, "Save");
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementEnd"]()()();
  }
  if (rf & 2) {
    const ctx_r0 = _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵadvance"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵtextInterpolate"](ctx_r0.data["type"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵadvance"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵproperty"]("ngIf", ctx_r0.controlls["type"]["options"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵproperty"]("ngIf", ctx_r0.form.get("type").value == "Others");
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵproperty"]("form", ctx_r0.form)("controller", ctx_r0.controlls["vaccinationDate"])("max", ctx_r0.form.get("nextDate").value);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵproperty"]("form", ctx_r0.form)("controller", ctx_r0.controlls["nextDate"])("min", ctx_r0.form.get("vaccinationDate").value);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵproperty"]("ngIf", !ctx_r0.data["record"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵproperty"]("ngIf", ctx_r0.petType != "bird");
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵproperty"]("ngIf", ctx_r0.form.get("nextDate").value);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵproperty"]("form", ctx_r0.form);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵadvance"](4);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵproperty"]("disabled", ctx_r0.form.invalid);
  }
}
class AddVaccinationRecordComponent {
  constructor(dialogRef, data, fb, petService, loader, userManagementService, snackBar) {
    this.dialogRef = dialogRef;
    this.data = data;
    this.fb = fb;
    this.petService = petService;
    this.loader = loader;
    this.userManagementService = userManagementService;
    this.snackBar = snackBar;
    this.isDocumentChanged = false;
    this.getPets();
    this.createControlls();
    this.createForm();
    console.log(this.petType);
  }
  ngOnInit() {
    this.form.get('type').valueChanges.subscribe(change => {
      this.form.get('otherVal').reset();
      if (change == 'Others') {
        this.form.get('otherVal').setValidators(_angular_forms__WEBPACK_IMPORTED_MODULE_10__.Validators.required);
        this.form.get('otherVal').updateValueAndValidity();
      } else {
        this.form.get('otherVal').clearValidators();
        this.form.get('otherVal').updateValueAndValidity();
      }
    });
    this.form.get('selectSlot').valueChanges.subscribe(change => {
      if (change == '1 Year') {
        // nextDate
        this.form.get('nextDate').setValue(this.addNextDate(0, 1));
      } else if (change == '3 Weeks') {
        this.form.get('nextDate').setValue(this.addNextDate(3, 0));
      } else if (change == '4 Weeks') {
        this.form.get('nextDate').setValue(this.addNextDate(4, 0));
      }
    });
    if (this.data['record']) {
      this.edit();
      // console.log(this.data['form']);
      // this.form = this.data['form']
    }
  }
  openVaccinationSnackbar() {
    this.snackBar.open(`
      Vaccination Schedule

      First Vaccination
      The first round of vaccination begins when the puppy is 6-8 weeks old.

      Second Vaccination
      The second round of vaccination begins 3-4 weeks after the first round.

      Third Vaccination
      The third round of vaccination begins when the puppy is 3 months old. This round consists of booster and anti-rabies shots.

      Annual Vaccination
      1 year after the first series of vaccinations, your pet will require an annual vaccination.
    `, 'Close', {
      duration: 1000,
      panelClass: ['custom-snackbar'],
      verticalPosition: 'bottom' // Positioning the snackbar
    });
  }
  onDateChange(event) {
    this.form.get('selectSlot').reset();
  }
  addNextDate(weeks = 0, years = 0) {
    const result = new Date(this.form.get('vaccinationDate').value);
    if (weeks) {
      result.setDate(result.getDate() + weeks * 7);
    }
    if (years) {
      result.setFullYear(result.getFullYear() + years);
    }
    return result;
  }
  edit() {
    let el = this.data['record'];
    this.form = this.fb.group({
      id: [el['id']],
      type: [el['docName'], _angular_forms__WEBPACK_IMPORTED_MODULE_10__.Validators.required],
      vaccinationDate: [new Date(el['docDate']), _angular_forms__WEBPACK_IMPORTED_MODULE_10__.Validators.required],
      nextDate: [el['nextDate'] ? new Date(el['nextDate']) : ''],
      reminder: [el['reminder']],
      document: [el['path'] ? el['path'] : ''],
      otherVal: [el['subType']],
      selectSlot: [el['period']]
    });
  }
  createForm() {
    this.form = this.fb.group({
      type: ['', _angular_forms__WEBPACK_IMPORTED_MODULE_10__.Validators.required],
      vaccinationDate: ['', _angular_forms__WEBPACK_IMPORTED_MODULE_10__.Validators.required],
      nextDate: [''],
      reminder: [false, _angular_forms__WEBPACK_IMPORTED_MODULE_10__.Validators.required],
      document: [''],
      otherVal: [''],
      selectSlot: ['']
    });
  }
  getPets() {
    this.loader.showLoader();
    this.userManagementService.getAllPetsByPetParent(sessionStorage.getItem('petParentId')).subscribe(res => {
      console.log(res);
      this.loader.hideLoader();
      res.forEach(el => {
        if (el['id'] == sessionStorage.getItem('petId')) {
          // debugger
          console.log(el);
          this.petType = el['type'];
          this.setBloodType();
        }
      });
      console.log(this.data);
    });
  }
  setBloodType() {
    this.controlls['type']['options'] = [];
    if (this.petType == 'dog') {
      this.controlls['type']['options'] = [{
        name: 'Puppy DP',
        value: 'Puppy DP'
      }, {
        name: 'DHPPi + LEPTO',
        value: 'DHPPi + LEPTO'
      }, {
        name: 'Corona + Kennel Cough',
        value: 'Corona + Kennel Cough'
      }, {
        name: 'DHPPi + Rabies + LEPTO',
        value: 'DHPPi + Rabies + LEPTO'
      }, {
        name: 'Others',
        value: 'Others'
      }];
      this.vaccinationSchedule = `
      Vaccination Schedule
  
      First Vaccination
      The first round of vaccination begins when the puppy is 6-8 weeks old.
  
      Second Vaccination
      The second round of vaccination begins 3-4 weeks after the first round.
  
      Third Vaccination
      The third round of vaccination begins when the puppy is 3 months old. This round consists of booster and anti-rabies shots.
  
      Annual Vaccination
      1 year after the first series of vaccinations, your pet will require an annual vaccination.
    `;
    } else if (this.petType == 'cat') {
      this.controlls['type']['options'] = [{
        name: 'TriCat (3 viruses)',
        value: 'TriCat (3 viruses)'
      }, {
        name: 'Anti-Rabies',
        value: 'Anti-Rabies'
      }, {
        name: 'Others',
        value: 'Others'
      }];
      this.vaccinationSchedule = `
       Vaccination Schedule

    First Vaccination: 
    The first round of vaccination begins when the kitten is 6-8 weeks old.

    Booster Vaccination:
     The first vaccination will be followed by a booster shot when the kitten is 9-11 weeks old.

    Second Vaccination: 
    The second round of vaccination begins when the kitten is 12-14 weeks old.

    2nd Booster Vaccination:
     The second vaccination will be followed by a booster shot when the kitten is 15-18 weeks old.

    Annual Vaccination:
     1 year after the first series of vaccinations, your pet will require both vaccines on an annual basis.
  `;
    } else if (this.petType == 'exotic') {
      this.controlls['type']['options'] = [{
        name: 'Rabies',
        value: 'Rabies'
      }, {
        name: 'Others',
        value: 'Others'
      }];
      this.vaccinationSchedule = `
       Vaccination Schedule

    First Vaccination: 
    After the bird hatches, they will require one dose of the Marek Disease vaccine and one dose of the Newcastle vaccine.

    Annual Vaccination:
     One year after the first round of vaccinations, your bird will require an annual shot of the Newcastle vaccine
  `;
    } else if (this.petType == 'bird') {
      this.controlls['type']['options'] = [{
        name: 'Marek Disease Vaccine',
        value: 'Marek Disease Vaccine'
      }, {
        name: 'Newcastle Vaccine',
        value: 'Newcastle Vaccine'
      }, {
        name: 'Others',
        value: 'Others'
      }];
    }
    this.controlls['type'] = JSON.parse(JSON.stringify(this.controlls['type']));
  }
  createControlls() {
    this.controlls = {
      type: {
        id: "type",
        name: 'type',
        label: "Select Vaccination",
        required: true,
        options: [
          // {
          //   name: 'Puppy Dp',
          //   value: 'Puppy Dp'
          // },
          // {
          //   name: 'DHPPi + LEPTO',
          //   value: 'DHPPi + LEPTO'
          // },
          // {
          //   name: 'Carona + Kennel Cough',
          //   value: 'Carona + Kennel Cough'
          // },
          // {
          //   name: 'DHPPi + Rabies + LEPTO',
          //   value: 'DHPPi + Rabies + LEPTO'
          // },
          // {
          //   name: 'TriCat (3 viruses)',
          //   value: 'TriCat (3 viruses)'
          // },
          // {
          //   name: 'Anti-Rabies ',
          //   value: 'Anti-Rabies '
          // },
          // {
          //   name: 'Others',
          //   value: 'Others'
          // }
        ],
        type: "dropdown"
      },
      selectSlot: {
        id: "selectSlot",
        name: 'selectSlot',
        label: "",
        placeholder: "Select Slot",
        required: true,
        options: [{
          name: '3 Weeks',
          value: '3 Weeks'
        }, {
          name: '4 Weeks',
          value: '4 Weeks'
        }, {
          name: '1 Year',
          value: '1 Year'
        }],
        type: "toggle"
      },
      vaccinationDate: {
        id: "vaccinationDate",
        name: 'vaccinationDate',
        label: "Vaccination Done On",
        placeholder: "Enter vaccination Date",
        required: true,
        type: "text"
      },
      nextDate: {
        id: "nextDate",
        name: 'nextDate',
        label: "Next vaccination Due(Optional)",
        placeholder: "Enter Next vaccination Due",
        required: true,
        type: "text"
      },
      reminder: {
        id: "reminder",
        name: 'reminder',
        label: "Remind 1 day prior to Date",
        placeholder: "Remind 1 day prior to Date",
        required: true,
        type: "text"
      },
      otherVal: {
        id: "otherVal",
        name: 'otherVal',
        label: "Vaccination name",
        placeholder: "Enter Vaccination name",
        required: true,
        type: "text"
      }
    };
  }
  onNoClick() {
    this.dialogRef.close();
  }
  add() {
    console.log(this.data['records']);
    let json = this.form.value;
    const date = new Date(json['nextDate']);
    let data = {
      docName: json['type'],
      docDate: new Date(json['vaccinationDate']).getTime(),
      nextDate: json['nextDate'] ? new Date(json['nextDate']).getTime() : 0,
      period: json['selectSlot'],
      reminder: json['reminder'],
      reminderDate: date.setDate(date.getDate() - 1),
      type: 'vaccinationRecord',
      subType: json['otherVal'],
      plan: {},
      petId: sessionStorage.getItem('petId'),
      path: ''
    };
    if (this.data['record']) {
      data['id'] = this.data['record']['id'];
      if (json['document']) {
        data['fileDelete'] = false;
      } else {
        data['fileDelete'] = true;
      }
      this.loader.showLoader();
      this.petService.updateMedicalRecord(data, sessionStorage.getItem('petParentId'), this.data['record']['id'], data['fileDelete']).subscribe(res => {
        if (json['document']) {
          if (this.isDocumentChanged) {
            this.petService.updateMedicalRecordImage(sessionStorage.getItem('petParentId'), sessionStorage.getItem('petId'), res['id'], json['document']).subscribe(res => {
              this.petService.getMedicalRecord(sessionStorage.getItem('petId'), 'vaccinationRecord').subscribe(res => {
                this.loader.hideLoader();
                this.dialogRef.close();
                console.log(res);
              });
              console.log(res);
            }, error => {
              this.loader.hideLoader();
            });
          } else {
            this.petService.getMedicalRecord(sessionStorage.getItem('petId'), 'vaccinationRecord').subscribe(res => {
              this.loader.hideLoader();
              this.dialogRef.close();
              console.log(res);
            });
          }
        } else {
          this.petService.getMedicalRecord(sessionStorage.getItem('petId'), 'vaccinationRecord').subscribe(res => {
            this.petService.medicalRecordData[0]['icon'] = './assets/icons/pet-history/vaccination rec.svg';
            this.loader.hideLoader();
            this.dialogRef.close();
            console.log(res);
          }, error => {
            this.loader.hideLoader();
          });
        }
      });
    } else {
      this.loader.showLoader();
      this.petService.addMedicalRecord(data, sessionStorage.getItem('petParentId')).subscribe(res => {
        if (json['document']) {
          this.petService.updateMedicalRecordImage(sessionStorage.getItem('petParentId'), sessionStorage.getItem('petId'), res['id'], json['document']).subscribe(res => {
            console.log(res);
            this.petService.getMedicalRecord(sessionStorage.getItem('petId'), 'vaccinationRecord').subscribe(res => {
              this.loader.hideLoader();
              this.dialogRef.close();
              console.log(res);
            });
          });
        } else {
          this.petService.getMedicalRecord(sessionStorage.getItem('petId'), 'vaccinationRecord').subscribe(res => {
            this.loader.hideLoader();
            this.dialogRef.close();
            console.log(res);
          });
        }
        // this.data['records'].push(this.form);
        this.dialogRef.close();
      });
    }
  }
  onUpload(event) {
    this.form.get('document').setValue(event);
    this.isDocumentChanged = true;
  }
  static #_ = this.ɵfac = function AddVaccinationRecordComponent_Factory(t) {
    return new (t || AddVaccinationRecordComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵdirectiveInject"](_angular_material_dialog__WEBPACK_IMPORTED_MODULE_11__.MatDialogRef), _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵdirectiveInject"](_angular_material_dialog__WEBPACK_IMPORTED_MODULE_11__.MAT_DIALOG_DATA), _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵdirectiveInject"](_angular_forms__WEBPACK_IMPORTED_MODULE_10__.FormBuilder), _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵdirectiveInject"](app_services_pet_service__WEBPACK_IMPORTED_MODULE_0__.PetService), _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵdirectiveInject"](app_services_loader_service__WEBPACK_IMPORTED_MODULE_1__.LoaderService), _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵdirectiveInject"](app_services_user_management_service__WEBPACK_IMPORTED_MODULE_2__.UserManagementService), _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵdirectiveInject"](_angular_material_snack_bar__WEBPACK_IMPORTED_MODULE_12__.MatSnackBar));
  };
  static #_2 = this.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵdefineComponent"]({
    type: AddVaccinationRecordComponent,
    selectors: [["app-add-vaccination-record"]],
    decls: 1,
    vars: 1,
    consts: [["mat-dialog-content", "", "class", "wrapper", 4, "ngIf"], ["mat-dialog-content", "", 1, "wrapper"], [1, "header"], ["mat-icon-button", "", "color", "primary", 3, "click"], ["class", "row", 4, "ngIf"], [1, "row", 2, "height", "20%"], [2, "width", "100%", 3, "form", "controller", "max"], [2, "width", "100%", 3, "form", "controller", "min", "DateChange"], ["class", "row", "style", "padding-left: 1%;", 4, "ngIf"], ["class", "row", "style", "height: 15%;", 4, "ngIf"], [3, "form", "onSelect"], [1, "btn-wrapper"], ["mat-stroked-button", "", "color", "primary", 3, "click"], ["mat-stroked-button", "", "color", "primary", 3, "disabled", "click"], [1, "row"], [2, "width", "100%", 3, "form", "controller"], [1, "row", 2, "padding-left", "1%"], ["multiple", "false", 3, "form", "controller"], ["matTooltipClass", "custom-tooltip", "matTooltipPosition", "below", "aria-label", "Vaccination Schedule Info", 3, "matTooltip"], [1, "row", 2, "height", "15%"]],
    template: function AddVaccinationRecordComponent_Template(rf, ctx) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵtemplate"](0, AddVaccinationRecordComponent_div_0_Template, 22, 14, "div", 0);
      }
      if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵproperty"]("ngIf", ctx.data);
      }
    },
    dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_13__.NgIf, _components_controllers_input_input_component__WEBPACK_IMPORTED_MODULE_3__.InputComponent, _components_controllers_dropdown_dropdown_component__WEBPACK_IMPORTED_MODULE_4__.DropdownComponent, _components_controllers_date_picker_date_picker_component__WEBPACK_IMPORTED_MODULE_5__.DatePickerComponent, _components_controllers_single_checkbox_single_checkbox_component__WEBPACK_IMPORTED_MODULE_6__.SingleCheckboxComponent, _components_controllers_toggle_btn_toggle_btn_component__WEBPACK_IMPORTED_MODULE_7__.ToggleBtnComponent, _components_controllers_upload_document_upload_document_component__WEBPACK_IMPORTED_MODULE_8__.UploadDocumentComponent, _angular_material_button__WEBPACK_IMPORTED_MODULE_14__.MatButton, _angular_material_button__WEBPACK_IMPORTED_MODULE_14__.MatIconButton, _angular_material_icon__WEBPACK_IMPORTED_MODULE_15__.MatIcon, _angular_material_tooltip__WEBPACK_IMPORTED_MODULE_16__.MatTooltip],
    styles: [".header[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: row;\n  justify-content: space-between;\n}\n\n.row[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: column;\n  width: 90%;\n  height: 20%;\n  margin: 1%;\n}\n\n.btn-wrapper[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: row;\n  justify-content: right;\n}\n.btn-wrapper[_ngcontent-%COMP%]   button[_ngcontent-%COMP%] {\n  margin: 10px;\n}\n\n.wrapper[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: column;\n}\n\n.header[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: row;\n  justify-content: space-between;\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImFkZC12YWNjaW5hdGlvbi1yZWNvcmQuY29tcG9uZW50LnNjc3MiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7RUFDSSxhQUFBO0VBQ0EsbUJBQUE7RUFDQSw4QkFBQTtBQUNKOztBQUVBO0VBQ0ksYUFBQTtFQUNBLHNCQUFBO0VBQ0EsVUFBQTtFQUNBLFdBQUE7RUFDQSxVQUFBO0FBQ0o7O0FBRUE7RUFDSSxhQUFBO0VBQ0EsbUJBQUE7RUFDQSxzQkFBQTtBQUNKO0FBQ0k7RUFDSSxZQUFBO0FBQ1I7O0FBR0E7RUFDSSxhQUFBO0VBQ0Esc0JBQUE7QUFBSjs7QUFJQTtFQUNJLGFBQUE7RUFDQSxtQkFBQTtFQUNBLDhCQUFBO0FBREoiLCJmaWxlIjoiYWRkLXZhY2NpbmF0aW9uLXJlY29yZC5jb21wb25lbnQuc2NzcyIsInNvdXJjZXNDb250ZW50IjpbIi5oZWFkZXIge1xuICAgIGRpc3BsYXk6IGZsZXg7XG4gICAgZmxleC1kaXJlY3Rpb246IHJvdztcbiAgICBqdXN0aWZ5LWNvbnRlbnQ6IHNwYWNlLWJldHdlZW47XG59XG5cbi5yb3cge1xuICAgIGRpc3BsYXk6IGZsZXg7XG4gICAgZmxleC1kaXJlY3Rpb246IGNvbHVtbjtcbiAgICB3aWR0aDogOTAlO1xuICAgIGhlaWdodDogMjAlO1xuICAgIG1hcmdpbjogMSU7XG59XG5cbi5idG4td3JhcHBlciB7XG4gICAgZGlzcGxheTogZmxleDtcbiAgICBmbGV4LWRpcmVjdGlvbjogcm93O1xuICAgIGp1c3RpZnktY29udGVudDogcmlnaHQ7XG5cbiAgICBidXR0b24ge1xuICAgICAgICBtYXJnaW46IDEwcHg7XG4gICAgfVxufVxuXG4ud3JhcHBlciB7XG4gICAgZGlzcGxheTogZmxleDtcbiAgICBmbGV4LWRpcmVjdGlvbjogY29sdW1uO1xuXG59XG5cbi5oZWFkZXIge1xuICAgIGRpc3BsYXk6IGZsZXg7XG4gICAgZmxleC1kaXJlY3Rpb246IHJvdztcbiAgICBqdXN0aWZ5LWNvbnRlbnQ6IHNwYWNlLWJldHdlZW47XG59XG5cbiJdfQ== */\n/*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8uL3NyYy9hcHAvbW9kdWxlcy91c2VyLW1hbmFlbWVudC9tZWRpY2FsLXJlY29yZHMvYWRkLXZhY2NpbmF0aW9uLXJlY29yZC9hZGQtdmFjY2luYXRpb24tcmVjb3JkLmNvbXBvbmVudC5zY3NzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBO0VBQ0ksYUFBQTtFQUNBLG1CQUFBO0VBQ0EsOEJBQUE7QUFDSjs7QUFFQTtFQUNJLGFBQUE7RUFDQSxzQkFBQTtFQUNBLFVBQUE7RUFDQSxXQUFBO0VBQ0EsVUFBQTtBQUNKOztBQUVBO0VBQ0ksYUFBQTtFQUNBLG1CQUFBO0VBQ0Esc0JBQUE7QUFDSjtBQUNJO0VBQ0ksWUFBQTtBQUNSOztBQUdBO0VBQ0ksYUFBQTtFQUNBLHNCQUFBO0FBQUo7O0FBSUE7RUFDSSxhQUFBO0VBQ0EsbUJBQUE7RUFDQSw4QkFBQTtBQURKO0FBQ0Esb3dDQUFvd0MiLCJzb3VyY2VzQ29udGVudCI6WyIuaGVhZGVyIHtcbiAgICBkaXNwbGF5OiBmbGV4O1xuICAgIGZsZXgtZGlyZWN0aW9uOiByb3c7XG4gICAganVzdGlmeS1jb250ZW50OiBzcGFjZS1iZXR3ZWVuO1xufVxuXG4ucm93IHtcbiAgICBkaXNwbGF5OiBmbGV4O1xuICAgIGZsZXgtZGlyZWN0aW9uOiBjb2x1bW47XG4gICAgd2lkdGg6IDkwJTtcbiAgICBoZWlnaHQ6IDIwJTtcbiAgICBtYXJnaW46IDElO1xufVxuXG4uYnRuLXdyYXBwZXIge1xuICAgIGRpc3BsYXk6IGZsZXg7XG4gICAgZmxleC1kaXJlY3Rpb246IHJvdztcbiAgICBqdXN0aWZ5LWNvbnRlbnQ6IHJpZ2h0O1xuXG4gICAgYnV0dG9uIHtcbiAgICAgICAgbWFyZ2luOiAxMHB4O1xuICAgIH1cbn1cblxuLndyYXBwZXIge1xuICAgIGRpc3BsYXk6IGZsZXg7XG4gICAgZmxleC1kaXJlY3Rpb246IGNvbHVtbjtcblxufVxuXG4uaGVhZGVyIHtcbiAgICBkaXNwbGF5OiBmbGV4O1xuICAgIGZsZXgtZGlyZWN0aW9uOiByb3c7XG4gICAganVzdGlmeS1jb250ZW50OiBzcGFjZS1iZXR3ZWVuO1xufVxuXG4iXSwic291cmNlUm9vdCI6IiJ9 */"]
  });
}


/***/ }),

/***/ 78606:
/*!***************************************************************************************************************!*\
  !*** ./src/app/modules/user-manaement/medical-records/allergy-records-list/allergy-records-list.component.ts ***!
  \***************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AllergyRecordsListComponent": () => (/* binding */ AllergyRecordsListComponent)
/* harmony export */ });
/* harmony import */ var _add_allergy_record_add_allergy_record_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../add-allergy-record/add-allergy-record.component */ 26701);
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! moment */ 56908);
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(moment__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _angular_material_dialog__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/material/dialog */ 67486);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/forms */ 69542);
/* harmony import */ var _angular_material_paginator__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @angular/material/paginator */ 86907);
/* harmony import */ var _angular_material_sort__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @angular/material/sort */ 95096);
/* harmony import */ var _angular_material_table__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/material/table */ 83348);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/core */ 86839);
/* harmony import */ var app_services_pet_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! app/services/pet.service */ 59976);
/* harmony import */ var app_services_loader_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! app/services/loader.service */ 38555);
/* harmony import */ var _angular_material_button__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @angular/material/button */ 83677);
/* harmony import */ var _angular_material_menu__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @angular/material/menu */ 89314);
/* harmony import */ var _angular_material_icon__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @angular/material/icon */ 69941);

















function AllergyRecordsListComponent_th_10_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "th", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](1, " ID. ");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
  }
}
function AllergyRecordsListComponent_td_11_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "td", 19);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const element_r12 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate1"](" ", element_r12.id.substring(0, 6), " ");
  }
}
function AllergyRecordsListComponent_th_13_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "th", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](1, " Title ");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
  }
}
function AllergyRecordsListComponent_td_14_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "td", 19);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const element_r13 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate1"](" ", element_r13.docName == "Other" ? element_r13.subType : element_r13.docName, " ");
  }
}
function AllergyRecordsListComponent_th_16_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "th", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](1, " Uploaded Date ");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
  }
}
function AllergyRecordsListComponent_td_17_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "td", 19);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const element_r14 = ctx.$implicit;
    const ctx_r5 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate1"](" ", ctx_r5.currentUTCDate(element_r14.createdAt), " ");
  }
}
function AllergyRecordsListComponent_th_19_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "th", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](1, " Description ");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
  }
}
function AllergyRecordsListComponent_td_20_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "td", 19);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const element_r15 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate1"](" ", element_r15.plan.discription, " ");
  }
}
function AllergyRecordsListComponent_th_22_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "th", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](1, " Action ");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
  }
}
function AllergyRecordsListComponent_td_23_Template(rf, ctx) {
  if (rf & 1) {
    const _r20 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "td", 19)(1, "button", 20);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵlistener"]("click", function AllergyRecordsListComponent_td_23_Template_button_click_1_listener() {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵrestoreView"](_r20);
      const i_r17 = restoredCtx.index;
      const element_r16 = restoredCtx.$implicit;
      const ctx_r19 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵresetView"](ctx_r19.toggle(i_r17, element_r16));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](2, "mat-icon");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](3, "more_vert");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]()();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](4, "mat-menu", null, 21)(6, "button", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵlistener"]("click", function AllergyRecordsListComponent_td_23_Template_button_click_6_listener() {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵrestoreView"](_r20);
      const element_r16 = restoredCtx.$implicit;
      const i_r17 = restoredCtx.index;
      const ctx_r21 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵresetView"](ctx_r21.edit(element_r16, i_r17));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](7, "span", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](8, "Edit");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](9, "mat-icon", 24);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](10, "edit");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]()();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](11, "button", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵlistener"]("click", function AllergyRecordsListComponent_td_23_Template_button_click_11_listener() {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵrestoreView"](_r20);
      const element_r16 = restoredCtx.$implicit;
      const i_r17 = restoredCtx.index;
      const ctx_r22 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵresetView"](ctx_r22.delete(element_r16, i_r17));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](12, "span", 25);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](13, "Delete");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](14, "mat-icon", 26);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](15, "delete");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]()()()();
  }
  if (rf & 2) {
    const _r18 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵreference"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("matMenuTriggerFor", _r18);
  }
}
function AllergyRecordsListComponent_tr_24_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelement"](0, "tr", 27);
  }
}
function AllergyRecordsListComponent_tr_25_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelement"](0, "tr", 28);
  }
}
const _c0 = function () {
  return [5, 10, 25, 100];
};
class AllergyRecordsListComponent {
  constructor(dialogRef, data, fb, dialog, petService, loader) {
    this.dialogRef = dialogRef;
    this.data = data;
    this.fb = fb;
    this.dialog = dialog;
    this.petService = petService;
    this.loader = loader;
    this.displayedColumns = ['id', 'title', 'vaccinationDate', 'description', 'action'];
    this.createForm();
    this.getallergyRecords();
  }
  createForm() {
    this.form = this.fb.group({
      title: ['', _angular_forms__WEBPACK_IMPORTED_MODULE_5__.Validators.required],
      description: ['', _angular_forms__WEBPACK_IMPORTED_MODULE_5__.Validators.required]
    });
  }
  getallergyRecords() {
    this.petService.getMedicalRecord(sessionStorage.getItem('petId'), 'allergyRecord').subscribe(res => {
      console.log(res);
      if (res.length == 0) {
        this.petService.medicalRecordData[4]['icon'] = './assets/icons/grey-pet-history/allergy.svg';
      }
      const petParentsArray = Object.values(res);
      this.recordData = new _angular_material_table__WEBPACK_IMPORTED_MODULE_6__.MatTableDataSource(petParentsArray.map(item => ({
        ...item
      })));
      this.recordData.paginator = this.paginator;
      this.recordData.sort = this.sort;
    });
  }
  toggle(i, record) {}
  currentUTCDate(date) {
    return moment__WEBPACK_IMPORTED_MODULE_1___default().utc(date).local().format("DD-MMM-YYYY");
  }
  delete(record, i) {
    this.loader.showLoader();
    this.petService.deleteMedicalRecord(sessionStorage.getItem('petParentId'), record['id']).subscribe(res => {
      this.loader.hideLoader();
      this.getallergyRecords();
      console.log(res);
    }, error => {
      this.loader.hideLoader();
    });
  }
  edit(record, i) {
    this.recordData[i];
    const dialogRef = this.dialog.open(_add_allergy_record_add_allergy_record_component__WEBPACK_IMPORTED_MODULE_0__.AddAllergyRecordComponent, {
      data: {
        type: this.data['title'],
        record: record
      }
    });
    dialogRef.afterClosed().subscribe(result => {
      console.log('The dialog was closed');
      console.log(result);
      this.getallergyRecords();
    });
  }
  addRecord() {
    const dialogRef = this.dialog.open(_add_allergy_record_add_allergy_record_component__WEBPACK_IMPORTED_MODULE_0__.AddAllergyRecordComponent, {
      width: '300px',
      data: {
        type: this.data['title']
      }
    });
    dialogRef.afterClosed().subscribe(result => {
      console.log('The dialog was closed');
      console.log(result);
      this.getallergyRecords();
    });
  }
  onNoClick() {
    this.dialogRef.close();
  }
  static #_ = this.ɵfac = function AllergyRecordsListComponent_Factory(t) {
    return new (t || AllergyRecordsListComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](_angular_material_dialog__WEBPACK_IMPORTED_MODULE_7__.MatDialogRef), _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](_angular_material_dialog__WEBPACK_IMPORTED_MODULE_7__.MAT_DIALOG_DATA), _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](_angular_forms__WEBPACK_IMPORTED_MODULE_5__.FormBuilder), _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](_angular_material_dialog__WEBPACK_IMPORTED_MODULE_7__.MatDialog), _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](app_services_pet_service__WEBPACK_IMPORTED_MODULE_2__.PetService), _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](app_services_loader_service__WEBPACK_IMPORTED_MODULE_3__.LoaderService));
  };
  static #_2 = this.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdefineComponent"]({
    type: AllergyRecordsListComponent,
    selectors: [["app-allergy-records-list"]],
    viewQuery: function AllergyRecordsListComponent_Query(rf, ctx) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵviewQuery"](_angular_material_paginator__WEBPACK_IMPORTED_MODULE_8__.MatPaginator, 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵviewQuery"](_angular_material_sort__WEBPACK_IMPORTED_MODULE_9__.MatSort, 5);
      }
      if (rf & 2) {
        let _t;
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵloadQuery"]()) && (ctx.paginator = _t.first);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵloadQuery"]()) && (ctx.sort = _t.first);
      }
    },
    decls: 31,
    vars: 7,
    consts: [[1, "header"], ["mat-dialog-title", "", 2, "align-items", "center"], ["mat-mini-fab", "", "color", "warn", 3, "click"], ["mat-dialog-content", "", 1, "record-grid", 2, "min-height", "150px"], [1, "table-wrapper"], ["mat-table", "", 1, "mat-elevation-z8", "mt-2", 3, "dataSource"], ["matColumnDef", "id"], ["mat-header-cell", "", 4, "matHeaderCellDef"], ["mat-cell", "", 4, "matCellDef"], ["matColumnDef", "title"], ["matColumnDef", "vaccinationDate"], ["matColumnDef", "description"], ["matColumnDef", "action"], ["mat-header-row", "", 4, "matHeaderRowDef"], ["mat-row", "", 4, "matRowDef", "matRowDefColumns"], [3, "pageSize", "pageSizeOptions"], [1, "btn"], ["mat-mini-fab", "", "color", "primary", 3, "click"], ["mat-header-cell", ""], ["mat-cell", ""], ["mat-icon-button", "", 3, "matMenuTriggerFor", "click"], ["actionMenu", "matMenu"], ["mat-menu-item", "", 3, "click"], [2, "color", "blue !important"], ["color", "primary"], [2, "color", "hsl(0, 94%, 42%) !important"], ["color", "warn"], ["mat-header-row", ""], ["mat-row", ""]],
    template: function AllergyRecordsListComponent_Template(rf, ctx) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "div", 0)(1, "h1", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](3, "button", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵlistener"]("click", function AllergyRecordsListComponent_Template_button_click_3_listener() {
          return ctx.onNoClick();
        });
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](4, "mat-icon");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](5, "close");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]()()();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](6, "div", 3)(7, "div", 4)(8, "table", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementContainerStart"](9, 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](10, AllergyRecordsListComponent_th_10_Template, 2, 0, "th", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](11, AllergyRecordsListComponent_td_11_Template, 2, 1, "td", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementContainerStart"](12, 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](13, AllergyRecordsListComponent_th_13_Template, 2, 0, "th", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](14, AllergyRecordsListComponent_td_14_Template, 2, 1, "td", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementContainerStart"](15, 10);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](16, AllergyRecordsListComponent_th_16_Template, 2, 0, "th", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](17, AllergyRecordsListComponent_td_17_Template, 2, 1, "td", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementContainerStart"](18, 11);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](19, AllergyRecordsListComponent_th_19_Template, 2, 0, "th", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](20, AllergyRecordsListComponent_td_20_Template, 2, 1, "td", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementContainerStart"](21, 12);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](22, AllergyRecordsListComponent_th_22_Template, 2, 0, "th", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](23, AllergyRecordsListComponent_td_23_Template, 16, 1, "td", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](24, AllergyRecordsListComponent_tr_24_Template, 1, 0, "tr", 13);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](25, AllergyRecordsListComponent_tr_25_Template, 1, 0, "tr", 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelement"](26, "mat-paginator", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]()();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](27, "div", 16)(28, "button", 17);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵlistener"]("click", function AllergyRecordsListComponent_Template_button_click_28_listener() {
          return ctx.addRecord();
        });
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](29, "mat-icon");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](30, "add");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]()()();
      }
      if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate1"]("", ctx.data["title"], " List");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](6);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("dataSource", ctx.recordData);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](16);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("matHeaderRowDef", ctx.displayedColumns);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("matRowDefColumns", ctx.displayedColumns);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("pageSize", 10)("pageSizeOptions", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpureFunction0"](6, _c0));
      }
    },
    dependencies: [_angular_material_table__WEBPACK_IMPORTED_MODULE_6__.MatTable, _angular_material_table__WEBPACK_IMPORTED_MODULE_6__.MatHeaderCellDef, _angular_material_table__WEBPACK_IMPORTED_MODULE_6__.MatHeaderRowDef, _angular_material_table__WEBPACK_IMPORTED_MODULE_6__.MatColumnDef, _angular_material_table__WEBPACK_IMPORTED_MODULE_6__.MatCellDef, _angular_material_table__WEBPACK_IMPORTED_MODULE_6__.MatRowDef, _angular_material_table__WEBPACK_IMPORTED_MODULE_6__.MatHeaderCell, _angular_material_table__WEBPACK_IMPORTED_MODULE_6__.MatCell, _angular_material_table__WEBPACK_IMPORTED_MODULE_6__.MatHeaderRow, _angular_material_table__WEBPACK_IMPORTED_MODULE_6__.MatRow, _angular_material_button__WEBPACK_IMPORTED_MODULE_10__.MatIconButton, _angular_material_button__WEBPACK_IMPORTED_MODULE_10__.MatMiniFabButton, _angular_material_menu__WEBPACK_IMPORTED_MODULE_11__.MatMenu, _angular_material_menu__WEBPACK_IMPORTED_MODULE_11__.MatMenuItem, _angular_material_menu__WEBPACK_IMPORTED_MODULE_11__.MatMenuTrigger, _angular_material_icon__WEBPACK_IMPORTED_MODULE_12__.MatIcon, _angular_material_paginator__WEBPACK_IMPORTED_MODULE_8__.MatPaginator],
    styles: [".btn[_ngcontent-%COMP%] {\n  display: flex;\n  justify-content: end;\n}\n\n.card[_ngcontent-%COMP%] {\n  padding: 2px;\n}\n\nmat-card-content[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: column;\n  justify-content: center;\n}\n\n.record-grid[_ngcontent-%COMP%] {\n  min-height: 80%;\n  max-height: -moz-fit-content;\n  max-height: fit-content;\n}\n\nmat-form-field[_ngcontent-%COMP%] {\n  display: block;\n  margin: 10px 0;\n}\n\n.header[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: row;\n  justify-content: space-between;\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImFsbGVyZ3ktcmVjb3Jkcy1saXN0LmNvbXBvbmVudC5zY3NzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBO0VBQ0ksYUFBQTtFQUNBLG9CQUFBO0FBQ0o7O0FBRUE7RUFDSSxZQUFBO0FBQ0o7O0FBR0E7RUFDSSxhQUFBO0VBQ0Esc0JBQUE7RUFDQSx1QkFBQTtBQUFKOztBQUlBO0VBQ0ksZUFBQTtFQUNBLDRCQUFBO0VBQUEsdUJBQUE7QUFESjs7QUFLQTtFQUNJLGNBQUE7RUFDQSxjQUFBO0FBRko7O0FBS0E7RUFDSSxhQUFBO0VBQ0EsbUJBQUE7RUFDQSw4QkFBQTtBQUZKIiwiZmlsZSI6ImFsbGVyZ3ktcmVjb3Jkcy1saXN0LmNvbXBvbmVudC5zY3NzIiwic291cmNlc0NvbnRlbnQiOlsiLmJ0biB7XG4gICAgZGlzcGxheTogZmxleDtcbiAgICBqdXN0aWZ5LWNvbnRlbnQ6IGVuZDtcbn1cblxuLmNhcmQge1xuICAgIHBhZGRpbmc6IDJweDtcbiBcbn1cblxubWF0LWNhcmQtY29udGVudCB7XG4gICAgZGlzcGxheTogZmxleDtcbiAgICBmbGV4LWRpcmVjdGlvbjogY29sdW1uO1xuICAgIGp1c3RpZnktY29udGVudDogY2VudGVyO1xuICAgIC8vIGFsaWduLWl0ZW1zOiBjZW50ZXI7XG5cbn1cbi5yZWNvcmQtZ3JpZHtcbiAgICBtaW4taGVpZ2h0OiA4MCU7XG4gICAgbWF4LWhlaWdodDogZml0LWNvbnRlbnQ7XG59XG5cblxubWF0LWZvcm0tZmllbGQge1xuICAgIGRpc3BsYXk6IGJsb2NrO1xuICAgIG1hcmdpbjogMTBweCAwO1xufVxuXG4uaGVhZGVyIHtcbiAgICBkaXNwbGF5OiBmbGV4O1xuICAgIGZsZXgtZGlyZWN0aW9uOiByb3c7XG4gICAganVzdGlmeS1jb250ZW50OiBzcGFjZS1iZXR3ZWVuO1xufSJdfQ== */\n/*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8uL3NyYy9hcHAvbW9kdWxlcy91c2VyLW1hbmFlbWVudC9tZWRpY2FsLXJlY29yZHMvYWxsZXJneS1yZWNvcmRzLWxpc3QvYWxsZXJneS1yZWNvcmRzLWxpc3QuY29tcG9uZW50LnNjc3MiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7RUFDSSxhQUFBO0VBQ0Esb0JBQUE7QUFDSjs7QUFFQTtFQUNJLFlBQUE7QUFDSjs7QUFHQTtFQUNJLGFBQUE7RUFDQSxzQkFBQTtFQUNBLHVCQUFBO0FBQUo7O0FBSUE7RUFDSSxlQUFBO0VBQ0EsNEJBQUE7RUFBQSx1QkFBQTtBQURKOztBQUtBO0VBQ0ksY0FBQTtFQUNBLGNBQUE7QUFGSjs7QUFLQTtFQUNJLGFBQUE7RUFDQSxtQkFBQTtFQUNBLDhCQUFBO0FBRko7QUFFQSx3b0NBQXdvQyIsInNvdXJjZXNDb250ZW50IjpbIi5idG4ge1xuICAgIGRpc3BsYXk6IGZsZXg7XG4gICAganVzdGlmeS1jb250ZW50OiBlbmQ7XG59XG5cbi5jYXJkIHtcbiAgICBwYWRkaW5nOiAycHg7XG4gXG59XG5cbm1hdC1jYXJkLWNvbnRlbnQge1xuICAgIGRpc3BsYXk6IGZsZXg7XG4gICAgZmxleC1kaXJlY3Rpb246IGNvbHVtbjtcbiAgICBqdXN0aWZ5LWNvbnRlbnQ6IGNlbnRlcjtcbiAgICAvLyBhbGlnbi1pdGVtczogY2VudGVyO1xuXG59XG4ucmVjb3JkLWdyaWR7XG4gICAgbWluLWhlaWdodDogODAlO1xuICAgIG1heC1oZWlnaHQ6IGZpdC1jb250ZW50O1xufVxuXG5cbm1hdC1mb3JtLWZpZWxkIHtcbiAgICBkaXNwbGF5OiBibG9jaztcbiAgICBtYXJnaW46IDEwcHggMDtcbn1cblxuLmhlYWRlciB7XG4gICAgZGlzcGxheTogZmxleDtcbiAgICBmbGV4LWRpcmVjdGlvbjogcm93O1xuICAgIGp1c3RpZnktY29udGVudDogc3BhY2UtYmV0d2Vlbjtcbn0iXSwic291cmNlUm9vdCI6IiJ9 */"]
  });
}


/***/ }),

/***/ 97477:
/*!***************************************************************************************************!*\
  !*** ./src/app/modules/user-manaement/medical-records/deworming-list/deworming-list.component.ts ***!
  \***************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "DewormingListComponent": () => (/* binding */ DewormingListComponent)
/* harmony export */ });
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! moment */ 56908);
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(moment__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _add_deworming_add_deworming_component__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../add-deworming/add-deworming.component */ 626);
/* harmony import */ var _angular_material_dialog__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/material/dialog */ 67486);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/forms */ 69542);
/* harmony import */ var _angular_material_paginator__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @angular/material/paginator */ 86907);
/* harmony import */ var _angular_material_sort__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @angular/material/sort */ 95096);
/* harmony import */ var _angular_material_table__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/material/table */ 83348);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/core */ 86839);
/* harmony import */ var app_services_pet_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! app/services/pet.service */ 59976);
/* harmony import */ var app_services_loader_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! app/services/loader.service */ 38555);
/* harmony import */ var _angular_material_button__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @angular/material/button */ 83677);
/* harmony import */ var _angular_material_menu__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @angular/material/menu */ 89314);
/* harmony import */ var _angular_material_icon__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @angular/material/icon */ 69941);

















function DewormingListComponent_th_10_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "th", 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](1, " ID. ");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
  }
}
function DewormingListComponent_td_11_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "td", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const element_r10 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate1"](" ", element_r10.id.substring(0, 6), " ");
  }
}
function DewormingListComponent_th_13_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "th", 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](1, " vaccination Date ");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
  }
}
function DewormingListComponent_td_14_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "td", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const element_r11 = ctx.$implicit;
    const ctx_r3 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate1"](" ", ctx_r3.currentUTCDate(element_r11.docDate), " ");
  }
}
function DewormingListComponent_th_16_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "th", 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](1, " Next Date ");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
  }
}
function DewormingListComponent_td_17_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "td", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const element_r12 = ctx.$implicit;
    const ctx_r5 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate1"](" ", ctx_r5.currentUTCDate(element_r12.nextDate), " ");
  }
}
function DewormingListComponent_th_19_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "th", 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](1, " Action ");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
  }
}
function DewormingListComponent_td_20_Template(rf, ctx) {
  if (rf & 1) {
    const _r17 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "td", 18)(1, "button", 19);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵlistener"]("click", function DewormingListComponent_td_20_Template_button_click_1_listener() {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵrestoreView"](_r17);
      const i_r14 = restoredCtx.index;
      const element_r13 = restoredCtx.$implicit;
      const ctx_r16 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵresetView"](ctx_r16.toggle(i_r14, element_r13));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](2, "mat-icon");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](3, "more_vert");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]()();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](4, "mat-menu", null, 20)(6, "button", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵlistener"]("click", function DewormingListComponent_td_20_Template_button_click_6_listener() {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵrestoreView"](_r17);
      const element_r13 = restoredCtx.$implicit;
      const i_r14 = restoredCtx.index;
      const ctx_r18 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵresetView"](ctx_r18.edit(element_r13, i_r14));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](7, "span", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](8, "Edit");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](9, "mat-icon", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](10, "edit");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]()();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](11, "button", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵlistener"]("click", function DewormingListComponent_td_20_Template_button_click_11_listener() {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵrestoreView"](_r17);
      const element_r13 = restoredCtx.$implicit;
      const i_r14 = restoredCtx.index;
      const ctx_r19 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵresetView"](ctx_r19.delete(element_r13, i_r14));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](12, "span", 24);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](13, "Delete");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](14, "mat-icon", 25);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](15, "delete");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]()()()();
  }
  if (rf & 2) {
    const _r15 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵreference"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("matMenuTriggerFor", _r15);
  }
}
function DewormingListComponent_tr_21_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelement"](0, "tr", 26);
  }
}
function DewormingListComponent_tr_22_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelement"](0, "tr", 27);
  }
}
const _c0 = function () {
  return [5, 10, 25, 100];
};
class DewormingListComponent {
  constructor(dialogRef, data, fb, dialog, petService, loader) {
    this.dialogRef = dialogRef;
    this.data = data;
    this.fb = fb;
    this.dialog = dialog;
    this.petService = petService;
    this.loader = loader;
    this.displayedColumns = ['id', 'vaccinationDate', 'nextDate', 'action'];
    this.createForm();
  }
  ngOnInit() {
    this.getDewormingRecords();
  }
  ngAfterViewInit() {
    this.recordData.paginator = this.paginator;
  }
  getDewormingRecords() {
    this.petService.getMedicalRecord(sessionStorage.getItem('petId'), 'deworming').subscribe(res => {
      console.log(res);
      if (res.length == 0) {
        this.petService.medicalRecordData[2]['icon'] = './assets/icons/grey-pet-history/deworming.svg';
      }
      const petParentsArray = Object.values(res);
      this.recordData = new _angular_material_table__WEBPACK_IMPORTED_MODULE_5__.MatTableDataSource(petParentsArray.map(item => ({
        ...item
      })));
      this.recordData.paginator = this.paginator;
      this.recordData.sort = this.sort;
    });
  }
  createForm() {
    this.form = this.fb.group({
      lastDewormingDate: ['', _angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.required],
      nextDewormingDate: [''],
      selectSlot: ['']
    });
  }
  currentUTCDate(date) {
    if (date) {
      return moment__WEBPACK_IMPORTED_MODULE_0___default().utc(date).local().format("DD-MMM-YYYY");
    } else {
      return 0;
    }
  }
  toggle(i, record) {}
  delete(record, i) {
    this.loader.showLoader();
    this.petService.deleteMedicalRecord(sessionStorage.getItem('petParentId'), record['id']).subscribe(res => {
      this.loader.hideLoader();
      this.getDewormingRecords();
      console.log(res);
    }, error => {
      this.loader.hideLoader();
    });
  }
  edit(record, i) {
    this.recordData[i];
    const dialogRef = this.dialog.open(_add_deworming_add_deworming_component__WEBPACK_IMPORTED_MODULE_1__.AddDewormingComponent, {
      height: '500px',
      data: {
        type: this.data['title'],
        record: record
      }
    });
    dialogRef.afterClosed().subscribe(result => {
      console.log('The dialog was closed');
      console.log(result);
      this.getDewormingRecords();
    });
  }
  addRecord() {
    const dialogRef = this.dialog.open(_add_deworming_add_deworming_component__WEBPACK_IMPORTED_MODULE_1__.AddDewormingComponent, {
      // width: '650px',
      data: {
        type: this.data['title']
      }
    });
    dialogRef.afterClosed().subscribe(result => {
      console.log('The dialog was closed');
      console.log(result);
      this.getDewormingRecords();
    });
  }
  onNoClick() {
    this.dialogRef.close();
  }
  static #_ = this.ɵfac = function DewormingListComponent_Factory(t) {
    return new (t || DewormingListComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](_angular_material_dialog__WEBPACK_IMPORTED_MODULE_7__.MatDialogRef), _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](_angular_material_dialog__WEBPACK_IMPORTED_MODULE_7__.MAT_DIALOG_DATA), _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](_angular_forms__WEBPACK_IMPORTED_MODULE_6__.FormBuilder), _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](_angular_material_dialog__WEBPACK_IMPORTED_MODULE_7__.MatDialog), _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](app_services_pet_service__WEBPACK_IMPORTED_MODULE_2__.PetService), _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](app_services_loader_service__WEBPACK_IMPORTED_MODULE_3__.LoaderService));
  };
  static #_2 = this.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdefineComponent"]({
    type: DewormingListComponent,
    selectors: [["app-deworming-list"]],
    viewQuery: function DewormingListComponent_Query(rf, ctx) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵviewQuery"](_angular_material_paginator__WEBPACK_IMPORTED_MODULE_8__.MatPaginator, 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵviewQuery"](_angular_material_sort__WEBPACK_IMPORTED_MODULE_9__.MatSort, 5);
      }
      if (rf & 2) {
        let _t;
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵloadQuery"]()) && (ctx.paginator = _t.first);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵloadQuery"]()) && (ctx.sort = _t.first);
      }
    },
    decls: 28,
    vars: 7,
    consts: [[1, "header"], ["mat-dialog-title", "", 2, "align-items", "center"], ["mat-mini-fab", "", "color", "warn", 3, "click"], ["mat-dialog-content", "", 1, "record-grid", 2, "min-height", "150px"], [1, "table-wrapper"], ["mat-table", "", 1, "mat-elevation-z8", "mt-2", 3, "dataSource"], ["matColumnDef", "id"], ["mat-header-cell", "", 4, "matHeaderCellDef"], ["mat-cell", "", 4, "matCellDef"], ["matColumnDef", "vaccinationDate"], ["matColumnDef", "nextDate"], ["matColumnDef", "action"], ["mat-header-row", "", 4, "matHeaderRowDef"], ["mat-row", "", 4, "matRowDef", "matRowDefColumns"], [3, "pageSize", "pageSizeOptions"], [1, "btn"], ["mat-mini-fab", "", "color", "primary", 3, "click"], ["mat-header-cell", ""], ["mat-cell", ""], ["mat-icon-button", "", 3, "matMenuTriggerFor", "click"], ["actionMenu", "matMenu"], ["mat-menu-item", "", 3, "click"], [2, "color", "blue !important"], ["color", "primary"], [2, "color", "hsl(0, 94%, 42%) !important"], ["color", "warn"], ["mat-header-row", ""], ["mat-row", ""]],
    template: function DewormingListComponent_Template(rf, ctx) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "div", 0)(1, "h1", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](3, "button", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵlistener"]("click", function DewormingListComponent_Template_button_click_3_listener() {
          return ctx.onNoClick();
        });
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](4, "mat-icon");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](5, "close");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]()()();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](6, "div", 3)(7, "div", 4)(8, "table", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementContainerStart"](9, 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](10, DewormingListComponent_th_10_Template, 2, 0, "th", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](11, DewormingListComponent_td_11_Template, 2, 1, "td", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementContainerStart"](12, 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](13, DewormingListComponent_th_13_Template, 2, 0, "th", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](14, DewormingListComponent_td_14_Template, 2, 1, "td", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementContainerStart"](15, 10);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](16, DewormingListComponent_th_16_Template, 2, 0, "th", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](17, DewormingListComponent_td_17_Template, 2, 1, "td", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementContainerStart"](18, 11);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](19, DewormingListComponent_th_19_Template, 2, 0, "th", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](20, DewormingListComponent_td_20_Template, 16, 1, "td", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](21, DewormingListComponent_tr_21_Template, 1, 0, "tr", 12);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](22, DewormingListComponent_tr_22_Template, 1, 0, "tr", 13);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelement"](23, "mat-paginator", 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]()();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](24, "div", 15)(25, "button", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵlistener"]("click", function DewormingListComponent_Template_button_click_25_listener() {
          return ctx.addRecord();
        });
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](26, "mat-icon");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](27, "add");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]()()();
      }
      if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate1"]("", ctx.data["title"], " Records List");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](6);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("dataSource", ctx.recordData);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](13);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("matHeaderRowDef", ctx.displayedColumns);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("matRowDefColumns", ctx.displayedColumns);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("pageSize", 10)("pageSizeOptions", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpureFunction0"](6, _c0));
      }
    },
    dependencies: [_angular_material_table__WEBPACK_IMPORTED_MODULE_5__.MatTable, _angular_material_table__WEBPACK_IMPORTED_MODULE_5__.MatHeaderCellDef, _angular_material_table__WEBPACK_IMPORTED_MODULE_5__.MatHeaderRowDef, _angular_material_table__WEBPACK_IMPORTED_MODULE_5__.MatColumnDef, _angular_material_table__WEBPACK_IMPORTED_MODULE_5__.MatCellDef, _angular_material_table__WEBPACK_IMPORTED_MODULE_5__.MatRowDef, _angular_material_table__WEBPACK_IMPORTED_MODULE_5__.MatHeaderCell, _angular_material_table__WEBPACK_IMPORTED_MODULE_5__.MatCell, _angular_material_table__WEBPACK_IMPORTED_MODULE_5__.MatHeaderRow, _angular_material_table__WEBPACK_IMPORTED_MODULE_5__.MatRow, _angular_material_button__WEBPACK_IMPORTED_MODULE_10__.MatIconButton, _angular_material_button__WEBPACK_IMPORTED_MODULE_10__.MatMiniFabButton, _angular_material_menu__WEBPACK_IMPORTED_MODULE_11__.MatMenu, _angular_material_menu__WEBPACK_IMPORTED_MODULE_11__.MatMenuItem, _angular_material_menu__WEBPACK_IMPORTED_MODULE_11__.MatMenuTrigger, _angular_material_icon__WEBPACK_IMPORTED_MODULE_12__.MatIcon, _angular_material_paginator__WEBPACK_IMPORTED_MODULE_8__.MatPaginator],
    styles: [".btn[_ngcontent-%COMP%] {\n  display: flex;\n  justify-content: end;\n}\n\n.card[_ngcontent-%COMP%] {\n  padding: 2px;\n}\n\nmat-card-content[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: column;\n  justify-content: center;\n}\n\n.record-grid[_ngcontent-%COMP%] {\n  min-height: 80%;\n  max-height: -moz-fit-content;\n  max-height: fit-content;\n}\n\nmat-form-field[_ngcontent-%COMP%] {\n  display: block;\n  margin: 10px 0;\n}\n\n.header[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: row;\n  justify-content: space-between;\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImRld29ybWluZy1saXN0LmNvbXBvbmVudC5zY3NzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBO0VBQ0ksYUFBQTtFQUNBLG9CQUFBO0FBQ0o7O0FBRUE7RUFDSSxZQUFBO0FBQ0o7O0FBR0E7RUFDSSxhQUFBO0VBQ0Esc0JBQUE7RUFDQSx1QkFBQTtBQUFKOztBQUlBO0VBQ0ksZUFBQTtFQUNBLDRCQUFBO0VBQUEsdUJBQUE7QUFESjs7QUFLQTtFQUNJLGNBQUE7RUFDQSxjQUFBO0FBRko7O0FBS0E7RUFDSSxhQUFBO0VBQ0EsbUJBQUE7RUFDQSw4QkFBQTtBQUZKIiwiZmlsZSI6ImRld29ybWluZy1saXN0LmNvbXBvbmVudC5zY3NzIiwic291cmNlc0NvbnRlbnQiOlsiLmJ0biB7XG4gICAgZGlzcGxheTogZmxleDtcbiAgICBqdXN0aWZ5LWNvbnRlbnQ6IGVuZDtcbn1cblxuLmNhcmQge1xuICAgIHBhZGRpbmc6IDJweDtcbiBcbn1cblxubWF0LWNhcmQtY29udGVudCB7XG4gICAgZGlzcGxheTogZmxleDtcbiAgICBmbGV4LWRpcmVjdGlvbjogY29sdW1uO1xuICAgIGp1c3RpZnktY29udGVudDogY2VudGVyO1xuICAgIC8vIGFsaWduLWl0ZW1zOiBjZW50ZXI7XG5cbn1cbi5yZWNvcmQtZ3JpZHtcbiAgICBtaW4taGVpZ2h0OiA4MCU7XG4gICAgbWF4LWhlaWdodDogZml0LWNvbnRlbnQ7XG59XG5cblxubWF0LWZvcm0tZmllbGQge1xuICAgIGRpc3BsYXk6IGJsb2NrO1xuICAgIG1hcmdpbjogMTBweCAwO1xufVxuXG4uaGVhZGVyIHtcbiAgICBkaXNwbGF5OiBmbGV4O1xuICAgIGZsZXgtZGlyZWN0aW9uOiByb3c7XG4gICAganVzdGlmeS1jb250ZW50OiBzcGFjZS1iZXR3ZWVuO1xufSJdfQ== */\n/*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8uL3NyYy9hcHAvbW9kdWxlcy91c2VyLW1hbmFlbWVudC9tZWRpY2FsLXJlY29yZHMvZGV3b3JtaW5nLWxpc3QvZGV3b3JtaW5nLWxpc3QuY29tcG9uZW50LnNjc3MiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7RUFDSSxhQUFBO0VBQ0Esb0JBQUE7QUFDSjs7QUFFQTtFQUNJLFlBQUE7QUFDSjs7QUFHQTtFQUNJLGFBQUE7RUFDQSxzQkFBQTtFQUNBLHVCQUFBO0FBQUo7O0FBSUE7RUFDSSxlQUFBO0VBQ0EsNEJBQUE7RUFBQSx1QkFBQTtBQURKOztBQUtBO0VBQ0ksY0FBQTtFQUNBLGNBQUE7QUFGSjs7QUFLQTtFQUNJLGFBQUE7RUFDQSxtQkFBQTtFQUNBLDhCQUFBO0FBRko7QUFFQSx3bkNBQXduQyIsInNvdXJjZXNDb250ZW50IjpbIi5idG4ge1xuICAgIGRpc3BsYXk6IGZsZXg7XG4gICAganVzdGlmeS1jb250ZW50OiBlbmQ7XG59XG5cbi5jYXJkIHtcbiAgICBwYWRkaW5nOiAycHg7XG4gXG59XG5cbm1hdC1jYXJkLWNvbnRlbnQge1xuICAgIGRpc3BsYXk6IGZsZXg7XG4gICAgZmxleC1kaXJlY3Rpb246IGNvbHVtbjtcbiAgICBqdXN0aWZ5LWNvbnRlbnQ6IGNlbnRlcjtcbiAgICAvLyBhbGlnbi1pdGVtczogY2VudGVyO1xuXG59XG4ucmVjb3JkLWdyaWR7XG4gICAgbWluLWhlaWdodDogODAlO1xuICAgIG1heC1oZWlnaHQ6IGZpdC1jb250ZW50O1xufVxuXG5cbm1hdC1mb3JtLWZpZWxkIHtcbiAgICBkaXNwbGF5OiBibG9jaztcbiAgICBtYXJnaW46IDEwcHggMDtcbn1cblxuLmhlYWRlciB7XG4gICAgZGlzcGxheTogZmxleDtcbiAgICBmbGV4LWRpcmVjdGlvbjogcm93O1xuICAgIGp1c3RpZnktY29udGVudDogc3BhY2UtYmV0d2Vlbjtcbn0iXSwic291cmNlUm9vdCI6IiJ9 */"]
  });
}


/***/ }),

/***/ 20336:
/*!*******************************************************************************************************!*\
  !*** ./src/app/modules/user-manaement/medical-records/diatry-plan-list/diatry-plan-list.component.ts ***!
  \*******************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "DiatryPlanListComponent": () => (/* binding */ DiatryPlanListComponent)
/* harmony export */ });
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! moment */ 56908);
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(moment__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _add_diatry_plan_add_diatry_plan_component__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../add-diatry-plan/add-diatry-plan.component */ 79800);
/* harmony import */ var _angular_material_dialog__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @angular/material/dialog */ 67486);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/forms */ 69542);
/* harmony import */ var _angular_material_paginator__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @angular/material/paginator */ 86907);
/* harmony import */ var _angular_material_sort__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @angular/material/sort */ 95096);
/* harmony import */ var _angular_material_table__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/material/table */ 83348);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/core */ 86839);
/* harmony import */ var app_services_validations_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! app/services/validations.service */ 27681);
/* harmony import */ var app_services_pet_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! app/services/pet.service */ 59976);
/* harmony import */ var app_services_loader_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! app/services/loader.service */ 38555);
/* harmony import */ var _angular_material_button__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @angular/material/button */ 83677);
/* harmony import */ var _angular_material_menu__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @angular/material/menu */ 89314);
/* harmony import */ var _angular_material_icon__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @angular/material/icon */ 69941);


















function DiatryPlanListComponent_th_10_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "th", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](1, " ID. ");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
  }
}
function DiatryPlanListComponent_td_11_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "td", 19);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const element_r12 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtextInterpolate1"](" ", element_r12.id.substring(0, 6), " ");
  }
}
function DiatryPlanListComponent_th_13_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "th", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](1, " Feeding Slot ");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
  }
}
function DiatryPlanListComponent_td_14_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "td", 19);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const element_r13 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtextInterpolate1"](" ", element_r13.plan.feedingTime, " ");
  }
}
function DiatryPlanListComponent_th_16_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "th", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](1, " Feeding Time ");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
  }
}
function DiatryPlanListComponent_td_17_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "td", 19);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const element_r14 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtextInterpolate1"](" ", element_r14.plan.time, " ");
  }
}
function DiatryPlanListComponent_th_19_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "th", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](1, " Days ");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
  }
}
function DiatryPlanListComponent_td_20_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "td", 19);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const element_r15 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtextInterpolate1"](" ", element_r15.plan.feedingDays, " ");
  }
}
function DiatryPlanListComponent_th_22_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "th", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](1, " Action ");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
  }
}
function DiatryPlanListComponent_td_23_Template(rf, ctx) {
  if (rf & 1) {
    const _r20 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "td", 19)(1, "button", 20);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵlistener"]("click", function DiatryPlanListComponent_td_23_Template_button_click_1_listener() {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵrestoreView"](_r20);
      const i_r17 = restoredCtx.index;
      const element_r16 = restoredCtx.$implicit;
      const ctx_r19 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵresetView"](ctx_r19.toggle(i_r17, element_r16));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](2, "mat-icon");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](3, "more_vert");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]()();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](4, "mat-menu", null, 21)(6, "button", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵlistener"]("click", function DiatryPlanListComponent_td_23_Template_button_click_6_listener() {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵrestoreView"](_r20);
      const element_r16 = restoredCtx.$implicit;
      const i_r17 = restoredCtx.index;
      const ctx_r21 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵresetView"](ctx_r21.edit(element_r16, i_r17));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](7, "span", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](8, "Edit");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](9, "mat-icon", 24);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](10, "edit");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]()();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](11, "button", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵlistener"]("click", function DiatryPlanListComponent_td_23_Template_button_click_11_listener() {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵrestoreView"](_r20);
      const element_r16 = restoredCtx.$implicit;
      const i_r17 = restoredCtx.index;
      const ctx_r22 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵresetView"](ctx_r22.delete(element_r16, i_r17));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](12, "span", 25);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](13, "Delete");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](14, "mat-icon", 26);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](15, "delete");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]()()()();
  }
  if (rf & 2) {
    const _r18 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵreference"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("matMenuTriggerFor", _r18);
  }
}
function DiatryPlanListComponent_tr_24_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelement"](0, "tr", 27);
  }
}
function DiatryPlanListComponent_tr_25_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelement"](0, "tr", 28);
  }
}
const _c0 = function () {
  return [5, 10, 25, 100];
};
class DiatryPlanListComponent {
  constructor(dialogRef, data, fb, dialog, validationsService, petService, loader) {
    this.dialogRef = dialogRef;
    this.data = data;
    this.fb = fb;
    this.dialog = dialog;
    this.validationsService = validationsService;
    this.petService = petService;
    this.loader = loader;
    this.displayedColumns = ['id', 'feedingslot', 'feedingTime', 'days', 'action'];
    this.getDietryPlane();
  }
  ngOnInit() {
    this.getDietryPlane();
  }
  ngAfterViewInit() {
    this.recordData.paginator = this.paginator;
  }
  getKeys(obj) {
    return Object.keys(obj).filter(key => obj[key] === true);
  }
  getDietryPlane() {
    this.petService.getMedicalRecord(sessionStorage.getItem('petId'), 'DietPlan').subscribe(res => {
      console.log(res);
      if (res.length == 0) {
        this.petService.medicalRecordData[5]['icon'] = './assets/icons/grey-pet-history/diets.svg';
      }
      const petParentsArray = Object.values(res);
      this.recordData = new _angular_material_table__WEBPACK_IMPORTED_MODULE_6__.MatTableDataSource(petParentsArray.map(item => ({
        ...item
      })));
      this.recordData.paginator = this.paginator;
      this.recordData.sort = this.sort;
    });
  }
  createForm() {
    this.form = this.fb.group({
      feedingTime: ['', _angular_forms__WEBPACK_IMPORTED_MODULE_7__.Validators.required],
      time: ['', _angular_forms__WEBPACK_IMPORTED_MODULE_7__.Validators.required],
      reminder: ['', _angular_forms__WEBPACK_IMPORTED_MODULE_7__.Validators.required],
      addDays: [],
      workSpaceTimings: this.fb.group({
        Mon: [''],
        Tue: [''],
        Wed: [''],
        Thu: [''],
        Fri: [''],
        Sat: [''],
        Sun: ['']
        // all : ['']
      }, {
        validator: this.validationsService.atLeastOneSelectedValidator()
      }),
      foodName: ['', _angular_forms__WEBPACK_IMPORTED_MODULE_7__.Validators.required]
    });
  }
  currentUTCDate(date) {
    return moment__WEBPACK_IMPORTED_MODULE_0___default().utc(date).local().format("DD-MMM-YYYY");
  }
  toggle(i, record) {}
  delete(record, i) {
    this.loader.showLoader();
    this.petService.deleteMedicalRecord(sessionStorage.getItem('petParentId'), record['id']).subscribe(res => {
      this.loader.hideLoader();
      this.getDietryPlane();
      console.log(res);
    }, error => {
      this.loader.hideLoader();
    });
  }
  edit(record, i) {
    this.recordData[i];
    const dialogRef = this.dialog.open(_add_diatry_plan_add_diatry_plan_component__WEBPACK_IMPORTED_MODULE_1__.AddDiatryPlanComponent, {
      height: '500px',
      data: {
        type: this.data['title'],
        form: record,
        record: record
      }
    });
    dialogRef.afterClosed().subscribe(result => {
      console.log('The dialog was closed');
      console.log(result);
      this.getDietryPlane();
    });
  }
  addRecord() {
    const dialogRef = this.dialog.open(_add_diatry_plan_add_diatry_plan_component__WEBPACK_IMPORTED_MODULE_1__.AddDiatryPlanComponent, {
      // width: '300px',
      data: {
        type: this.data['title']
      }
    });
    dialogRef.afterClosed().subscribe(result => {
      console.log('The dialog was closed');
      console.log(result);
      this.getDietryPlane();
    });
  }
  onNoClick() {
    this.dialogRef.close();
  }
  static #_ = this.ɵfac = function DiatryPlanListComponent_Factory(t) {
    return new (t || DiatryPlanListComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](_angular_material_dialog__WEBPACK_IMPORTED_MODULE_8__.MatDialogRef), _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](_angular_material_dialog__WEBPACK_IMPORTED_MODULE_8__.MAT_DIALOG_DATA), _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](_angular_forms__WEBPACK_IMPORTED_MODULE_7__.FormBuilder), _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](_angular_material_dialog__WEBPACK_IMPORTED_MODULE_8__.MatDialog), _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](app_services_validations_service__WEBPACK_IMPORTED_MODULE_2__.ValidationsService), _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](app_services_pet_service__WEBPACK_IMPORTED_MODULE_3__.PetService), _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](app_services_loader_service__WEBPACK_IMPORTED_MODULE_4__.LoaderService));
  };
  static #_2 = this.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdefineComponent"]({
    type: DiatryPlanListComponent,
    selectors: [["app-diatry-plan-list"]],
    viewQuery: function DiatryPlanListComponent_Query(rf, ctx) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵviewQuery"](_angular_material_paginator__WEBPACK_IMPORTED_MODULE_9__.MatPaginator, 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵviewQuery"](_angular_material_sort__WEBPACK_IMPORTED_MODULE_10__.MatSort, 5);
      }
      if (rf & 2) {
        let _t;
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵloadQuery"]()) && (ctx.paginator = _t.first);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵloadQuery"]()) && (ctx.sort = _t.first);
      }
    },
    decls: 31,
    vars: 7,
    consts: [[1, "header"], ["mat-dialog-title", "", 2, "align-items", "center"], ["mat-mini-fab", "", "color", "warn", 3, "click"], ["mat-dialog-content", "", 1, "record-grid", 2, "min-height", "200px", "height", "400px", "overflow-y", "auto"], [1, "table-wrapper"], ["mat-table", "", 1, "mat-elevation-z8", "mt-2", 3, "dataSource"], ["matColumnDef", "id"], ["mat-header-cell", "", 4, "matHeaderCellDef"], ["mat-cell", "", 4, "matCellDef"], ["matColumnDef", "feedingslot"], ["matColumnDef", "feedingTime"], ["matColumnDef", "days"], ["matColumnDef", "action"], ["mat-header-row", "", 4, "matHeaderRowDef"], ["mat-row", "", 4, "matRowDef", "matRowDefColumns"], [3, "pageSize", "pageSizeOptions"], [1, "btn"], ["mat-mini-fab", "", "color", "primary", 3, "click"], ["mat-header-cell", ""], ["mat-cell", ""], ["mat-icon-button", "", 3, "matMenuTriggerFor", "click"], ["actionMenu", "matMenu"], ["mat-menu-item", "", 3, "click"], [2, "color", "blue !important"], ["color", "primary"], [2, "color", "hsl(0, 94%, 42%) !important"], ["color", "warn"], ["mat-header-row", ""], ["mat-row", ""]],
    template: function DiatryPlanListComponent_Template(rf, ctx) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "div", 0)(1, "h1", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](3, "button", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵlistener"]("click", function DiatryPlanListComponent_Template_button_click_3_listener() {
          return ctx.onNoClick();
        });
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](4, "mat-icon");
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](5, "close");
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]()()();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](6, "div", 3)(7, "div", 4)(8, "table", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementContainerStart"](9, 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](10, DiatryPlanListComponent_th_10_Template, 2, 0, "th", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](11, DiatryPlanListComponent_td_11_Template, 2, 1, "td", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementContainerStart"](12, 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](13, DiatryPlanListComponent_th_13_Template, 2, 0, "th", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](14, DiatryPlanListComponent_td_14_Template, 2, 1, "td", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementContainerStart"](15, 10);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](16, DiatryPlanListComponent_th_16_Template, 2, 0, "th", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](17, DiatryPlanListComponent_td_17_Template, 2, 1, "td", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementContainerStart"](18, 11);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](19, DiatryPlanListComponent_th_19_Template, 2, 0, "th", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](20, DiatryPlanListComponent_td_20_Template, 2, 1, "td", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementContainerStart"](21, 12);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](22, DiatryPlanListComponent_th_22_Template, 2, 0, "th", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](23, DiatryPlanListComponent_td_23_Template, 16, 1, "td", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](24, DiatryPlanListComponent_tr_24_Template, 1, 0, "tr", 13);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](25, DiatryPlanListComponent_tr_25_Template, 1, 0, "tr", 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelement"](26, "mat-paginator", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]()();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](27, "div", 16)(28, "button", 17);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵlistener"]("click", function DiatryPlanListComponent_Template_button_click_28_listener() {
          return ctx.addRecord();
        });
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](29, "mat-icon");
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](30, "add");
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]()()();
      }
      if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtextInterpolate1"]("", ctx.data["title"], " Records List");
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](6);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("dataSource", ctx.recordData);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](16);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("matHeaderRowDef", ctx.displayedColumns);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("matRowDefColumns", ctx.displayedColumns);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("pageSize", 10)("pageSizeOptions", _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpureFunction0"](6, _c0));
      }
    },
    dependencies: [_angular_material_table__WEBPACK_IMPORTED_MODULE_6__.MatTable, _angular_material_table__WEBPACK_IMPORTED_MODULE_6__.MatHeaderCellDef, _angular_material_table__WEBPACK_IMPORTED_MODULE_6__.MatHeaderRowDef, _angular_material_table__WEBPACK_IMPORTED_MODULE_6__.MatColumnDef, _angular_material_table__WEBPACK_IMPORTED_MODULE_6__.MatCellDef, _angular_material_table__WEBPACK_IMPORTED_MODULE_6__.MatRowDef, _angular_material_table__WEBPACK_IMPORTED_MODULE_6__.MatHeaderCell, _angular_material_table__WEBPACK_IMPORTED_MODULE_6__.MatCell, _angular_material_table__WEBPACK_IMPORTED_MODULE_6__.MatHeaderRow, _angular_material_table__WEBPACK_IMPORTED_MODULE_6__.MatRow, _angular_material_button__WEBPACK_IMPORTED_MODULE_11__.MatIconButton, _angular_material_button__WEBPACK_IMPORTED_MODULE_11__.MatMiniFabButton, _angular_material_menu__WEBPACK_IMPORTED_MODULE_12__.MatMenu, _angular_material_menu__WEBPACK_IMPORTED_MODULE_12__.MatMenuItem, _angular_material_menu__WEBPACK_IMPORTED_MODULE_12__.MatMenuTrigger, _angular_material_icon__WEBPACK_IMPORTED_MODULE_13__.MatIcon, _angular_material_paginator__WEBPACK_IMPORTED_MODULE_9__.MatPaginator],
    styles: [".btn[_ngcontent-%COMP%] {\n  display: flex;\n  justify-content: end;\n}\n\n.card[_ngcontent-%COMP%] {\n  padding: 2px;\n}\n\nmat-card-content[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: column;\n  justify-content: center;\n}\n\n.record-grid[_ngcontent-%COMP%] {\n  min-height: 80%;\n  max-height: -moz-fit-content;\n  max-height: fit-content;\n}\n\nmat-form-field[_ngcontent-%COMP%] {\n  display: block;\n  margin: 10px 0;\n}\n\n.header[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: row;\n  justify-content: space-between;\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImRpYXRyeS1wbGFuLWxpc3QuY29tcG9uZW50LnNjc3MiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7RUFDSSxhQUFBO0VBQ0Esb0JBQUE7QUFDSjs7QUFFQTtFQUNJLFlBQUE7QUFDSjs7QUFHQTtFQUNJLGFBQUE7RUFDQSxzQkFBQTtFQUNBLHVCQUFBO0FBQUo7O0FBSUE7RUFDSSxlQUFBO0VBQ0EsNEJBQUE7RUFBQSx1QkFBQTtBQURKOztBQUtBO0VBQ0ksY0FBQTtFQUNBLGNBQUE7QUFGSjs7QUFLQTtFQUNJLGFBQUE7RUFDQSxtQkFBQTtFQUNBLDhCQUFBO0FBRkoiLCJmaWxlIjoiZGlhdHJ5LXBsYW4tbGlzdC5jb21wb25lbnQuc2NzcyIsInNvdXJjZXNDb250ZW50IjpbIi5idG4ge1xuICAgIGRpc3BsYXk6IGZsZXg7XG4gICAganVzdGlmeS1jb250ZW50OiBlbmQ7XG59XG5cbi5jYXJkIHtcbiAgICBwYWRkaW5nOiAycHg7XG4gXG59XG5cbm1hdC1jYXJkLWNvbnRlbnQge1xuICAgIGRpc3BsYXk6IGZsZXg7XG4gICAgZmxleC1kaXJlY3Rpb246IGNvbHVtbjtcbiAgICBqdXN0aWZ5LWNvbnRlbnQ6IGNlbnRlcjtcbiAgICAvLyBhbGlnbi1pdGVtczogY2VudGVyO1xuXG59XG4ucmVjb3JkLWdyaWR7XG4gICAgbWluLWhlaWdodDogODAlO1xuICAgIG1heC1oZWlnaHQ6IGZpdC1jb250ZW50O1xufVxuXG5cbm1hdC1mb3JtLWZpZWxkIHtcbiAgICBkaXNwbGF5OiBibG9jaztcbiAgICBtYXJnaW46IDEwcHggMDtcbn1cblxuLmhlYWRlciB7XG4gICAgZGlzcGxheTogZmxleDtcbiAgICBmbGV4LWRpcmVjdGlvbjogcm93O1xuICAgIGp1c3RpZnktY29udGVudDogc3BhY2UtYmV0d2Vlbjtcbn0iXX0= */\n/*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8uL3NyYy9hcHAvbW9kdWxlcy91c2VyLW1hbmFlbWVudC9tZWRpY2FsLXJlY29yZHMvZGlhdHJ5LXBsYW4tbGlzdC9kaWF0cnktcGxhbi1saXN0LmNvbXBvbmVudC5zY3NzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBO0VBQ0ksYUFBQTtFQUNBLG9CQUFBO0FBQ0o7O0FBRUE7RUFDSSxZQUFBO0FBQ0o7O0FBR0E7RUFDSSxhQUFBO0VBQ0Esc0JBQUE7RUFDQSx1QkFBQTtBQUFKOztBQUlBO0VBQ0ksZUFBQTtFQUNBLDRCQUFBO0VBQUEsdUJBQUE7QUFESjs7QUFLQTtFQUNJLGNBQUE7RUFDQSxjQUFBO0FBRko7O0FBS0E7RUFDSSxhQUFBO0VBQ0EsbUJBQUE7RUFDQSw4QkFBQTtBQUZKO0FBRUEsNG5DQUE0bkMiLCJzb3VyY2VzQ29udGVudCI6WyIuYnRuIHtcbiAgICBkaXNwbGF5OiBmbGV4O1xuICAgIGp1c3RpZnktY29udGVudDogZW5kO1xufVxuXG4uY2FyZCB7XG4gICAgcGFkZGluZzogMnB4O1xuIFxufVxuXG5tYXQtY2FyZC1jb250ZW50IHtcbiAgICBkaXNwbGF5OiBmbGV4O1xuICAgIGZsZXgtZGlyZWN0aW9uOiBjb2x1bW47XG4gICAganVzdGlmeS1jb250ZW50OiBjZW50ZXI7XG4gICAgLy8gYWxpZ24taXRlbXM6IGNlbnRlcjtcblxufVxuLnJlY29yZC1ncmlke1xuICAgIG1pbi1oZWlnaHQ6IDgwJTtcbiAgICBtYXgtaGVpZ2h0OiBmaXQtY29udGVudDtcbn1cblxuXG5tYXQtZm9ybS1maWVsZCB7XG4gICAgZGlzcGxheTogYmxvY2s7XG4gICAgbWFyZ2luOiAxMHB4IDA7XG59XG5cbi5oZWFkZXIge1xuICAgIGRpc3BsYXk6IGZsZXg7XG4gICAgZmxleC1kaXJlY3Rpb246IHJvdztcbiAgICBqdXN0aWZ5LWNvbnRlbnQ6IHNwYWNlLWJldHdlZW47XG59Il0sInNvdXJjZVJvb3QiOiIifQ== */"]
  });
}


/***/ }),

/***/ 7129:
/*!*******************************************************************************************************!*\
  !*** ./src/app/modules/user-manaement/medical-records/lab-records-list/lab-records-list.component.ts ***!
  \*******************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "LabRecordsListComponent": () => (/* binding */ LabRecordsListComponent)
/* harmony export */ });
/* harmony import */ var _add_lab_record_add_lab_record_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../add-lab-record/add-lab-record.component */ 56732);
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! moment */ 56908);
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(moment__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _angular_material_dialog__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/material/dialog */ 67486);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/forms */ 69542);
/* harmony import */ var _angular_material_paginator__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @angular/material/paginator */ 86907);
/* harmony import */ var _angular_material_sort__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @angular/material/sort */ 95096);
/* harmony import */ var _angular_material_table__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/material/table */ 83348);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/core */ 86839);
/* harmony import */ var app_services_pet_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! app/services/pet.service */ 59976);
/* harmony import */ var app_services_loader_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! app/services/loader.service */ 38555);
/* harmony import */ var _angular_material_button__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @angular/material/button */ 83677);
/* harmony import */ var _angular_material_menu__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @angular/material/menu */ 89314);
/* harmony import */ var _angular_material_icon__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @angular/material/icon */ 69941);

















function LabRecordsListComponent_th_10_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "th", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](1, " ID. ");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
  }
}
function LabRecordsListComponent_td_11_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "td", 19);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const element_r12 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate1"](" ", element_r12.id.substring(0, 6), " ");
  }
}
function LabRecordsListComponent_th_13_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "th", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](1, " Type ");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
  }
}
function LabRecordsListComponent_td_14_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "td", 19);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const element_r13 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate1"](" ", element_r13.docName == "Others" ? element_r13.subType : element_r13.docName, " ");
  }
}
function LabRecordsListComponent_th_16_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "th", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](1, " vaccination Date ");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
  }
}
function LabRecordsListComponent_td_17_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "td", 19);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const element_r14 = ctx.$implicit;
    const ctx_r5 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate1"](" ", ctx_r5.currentUTCDate(element_r14.docDate), " ");
  }
}
function LabRecordsListComponent_th_19_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "th", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](1, " Next Date ");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
  }
}
function LabRecordsListComponent_td_20_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "td", 19);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const element_r15 = ctx.$implicit;
    const ctx_r7 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate1"](" ", element_r15.nextDate ? ctx_r7.currentUTCDate(element_r15.nextDate) : "", " ");
  }
}
function LabRecordsListComponent_th_22_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "th", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](1, " Action ");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
  }
}
function LabRecordsListComponent_td_23_Template(rf, ctx) {
  if (rf & 1) {
    const _r20 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "td", 19)(1, "button", 20);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵlistener"]("click", function LabRecordsListComponent_td_23_Template_button_click_1_listener() {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵrestoreView"](_r20);
      const i_r17 = restoredCtx.index;
      const element_r16 = restoredCtx.$implicit;
      const ctx_r19 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵresetView"](ctx_r19.toggle(i_r17, element_r16));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](2, "mat-icon");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](3, "more_vert");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]()();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](4, "mat-menu", null, 21)(6, "button", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵlistener"]("click", function LabRecordsListComponent_td_23_Template_button_click_6_listener() {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵrestoreView"](_r20);
      const element_r16 = restoredCtx.$implicit;
      const i_r17 = restoredCtx.index;
      const ctx_r21 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵresetView"](ctx_r21.edit(element_r16, i_r17));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](7, "span", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](8, "Edit");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](9, "mat-icon", 24);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](10, "edit");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]()();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](11, "button", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵlistener"]("click", function LabRecordsListComponent_td_23_Template_button_click_11_listener() {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵrestoreView"](_r20);
      const element_r16 = restoredCtx.$implicit;
      const i_r17 = restoredCtx.index;
      const ctx_r22 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵresetView"](ctx_r22.delete(element_r16, i_r17));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](12, "span", 25);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](13, "Delete");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](14, "mat-icon", 26);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](15, "delete");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]()()()();
  }
  if (rf & 2) {
    const _r18 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵreference"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("matMenuTriggerFor", _r18);
  }
}
function LabRecordsListComponent_tr_24_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelement"](0, "tr", 27);
  }
}
function LabRecordsListComponent_tr_25_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelement"](0, "tr", 28);
  }
}
const _c0 = function () {
  return [5, 10, 25, 100];
};
class LabRecordsListComponent {
  constructor(dialogRef, data, fb, dialog, petService, loader) {
    this.dialogRef = dialogRef;
    this.data = data;
    this.fb = fb;
    this.dialog = dialog;
    this.petService = petService;
    this.loader = loader;
    this.displayedColumns = ['id', 'type', 'vaccinationDate', 'nextDate', 'action'];
    this.createForm();
    this.getLabRecords();
  }
  getLabRecords() {
    this.petService.getMedicalRecord(sessionStorage.getItem('petId'), 'labRecord').subscribe(res => {
      if (res.length == 0) {
        this.petService.medicalRecordData[1]['icon'] = './assets/icons/grey-pet-history/lab rec.svg';
      }
      const petParentsArray = Object.values(res);
      this.recordData = new _angular_material_table__WEBPACK_IMPORTED_MODULE_5__.MatTableDataSource(petParentsArray.map(item => ({
        ...item
      })));
      this.recordData.paginator = this.paginator;
      this.recordData.sort = this.sort;
    });
  }
  toggle(i, record) {}
  createForm() {
    this.form = this.fb.group({
      type: ['', _angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.required],
      title: ['', _angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.required],
      labTasteDate: ['', _angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.required],
      nextDate: [''],
      document: ['']
    });
  }
  currentUTCDate(date) {
    if (date) {
      return moment__WEBPACK_IMPORTED_MODULE_1___default().utc(date).local().format("DD-MMM-YYYY");
    } else {
      return 0;
    }
  }
  delete(record, i) {
    this.loader.showLoader();
    this.petService.deleteMedicalRecord(sessionStorage.getItem('petParentId'), record['id']).subscribe(res => {
      this.loader.hideLoader();
      this.getLabRecords();
      console.log(res);
    }, error => {
      console.log(error);
      this.loader.hideLoader();
    });
  }
  edit(record, i) {
    const dialogRef = this.dialog.open(_add_lab_record_add_lab_record_component__WEBPACK_IMPORTED_MODULE_0__.AddLabRecordComponent, {
      width: '400px',
      data: {
        type: this.data['title'],
        record: record
      }
    });
    dialogRef.afterClosed().subscribe(result => {
      console.log('The dialog was closed');
      console.log(result);
      this.getLabRecords();
    });
  }
  addRecord() {
    const dialogRef = this.dialog.open(_add_lab_record_add_lab_record_component__WEBPACK_IMPORTED_MODULE_0__.AddLabRecordComponent, {
      width: '400px',
      data: {
        type: this.data['title']
      }
    });
    dialogRef.afterClosed().subscribe(result => {
      console.log('The dialog was closed');
      console.log(result);
      this.getLabRecords();
    });
  }
  onNoClick() {
    this.dialogRef.close();
  }
  static #_ = this.ɵfac = function LabRecordsListComponent_Factory(t) {
    return new (t || LabRecordsListComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](_angular_material_dialog__WEBPACK_IMPORTED_MODULE_7__.MatDialogRef), _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](_angular_material_dialog__WEBPACK_IMPORTED_MODULE_7__.MAT_DIALOG_DATA), _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](_angular_forms__WEBPACK_IMPORTED_MODULE_6__.FormBuilder), _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](_angular_material_dialog__WEBPACK_IMPORTED_MODULE_7__.MatDialog), _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](app_services_pet_service__WEBPACK_IMPORTED_MODULE_2__.PetService), _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](app_services_loader_service__WEBPACK_IMPORTED_MODULE_3__.LoaderService));
  };
  static #_2 = this.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdefineComponent"]({
    type: LabRecordsListComponent,
    selectors: [["app-lab-records-list"]],
    viewQuery: function LabRecordsListComponent_Query(rf, ctx) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵviewQuery"](_angular_material_paginator__WEBPACK_IMPORTED_MODULE_8__.MatPaginator, 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵviewQuery"](_angular_material_sort__WEBPACK_IMPORTED_MODULE_9__.MatSort, 5);
      }
      if (rf & 2) {
        let _t;
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵloadQuery"]()) && (ctx.paginator = _t.first);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵloadQuery"]()) && (ctx.sort = _t.first);
      }
    },
    decls: 31,
    vars: 7,
    consts: [[1, "header"], ["mat-dialog-title", "", 2, "align-items", "center"], ["mat-mini-fab", "", "color", "warn", 3, "click"], ["mat-dialog-content", "", 1, "record-grid", 2, "min-height", "150px", "height", "400px", "overflow-y", "auto"], [1, "table-wrapper"], ["mat-table", "", 1, "mat-elevation-z8", "mt-2", 3, "dataSource"], ["matColumnDef", "id"], ["mat-header-cell", "", 4, "matHeaderCellDef"], ["mat-cell", "", 4, "matCellDef"], ["matColumnDef", "type"], ["matColumnDef", "vaccinationDate"], ["matColumnDef", "nextDate"], ["matColumnDef", "action"], ["mat-header-row", "", 4, "matHeaderRowDef"], ["mat-row", "", 4, "matRowDef", "matRowDefColumns"], [3, "pageSize", "pageSizeOptions"], [1, "btn"], ["mat-mini-fab", "", "color", "primary", 3, "click"], ["mat-header-cell", ""], ["mat-cell", ""], ["mat-icon-button", "", 3, "matMenuTriggerFor", "click"], ["actionMenu", "matMenu"], ["mat-menu-item", "", 3, "click"], [2, "color", "blue !important"], ["color", "primary"], [2, "color", "hsl(0, 94%, 42%) !important"], ["color", "warn"], ["mat-header-row", ""], ["mat-row", ""]],
    template: function LabRecordsListComponent_Template(rf, ctx) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "div", 0)(1, "h1", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](3, "button", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵlistener"]("click", function LabRecordsListComponent_Template_button_click_3_listener() {
          return ctx.onNoClick();
        });
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](4, "mat-icon");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](5, "close");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]()()();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](6, "div", 3)(7, "div", 4)(8, "table", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementContainerStart"](9, 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](10, LabRecordsListComponent_th_10_Template, 2, 0, "th", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](11, LabRecordsListComponent_td_11_Template, 2, 1, "td", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementContainerStart"](12, 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](13, LabRecordsListComponent_th_13_Template, 2, 0, "th", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](14, LabRecordsListComponent_td_14_Template, 2, 1, "td", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementContainerStart"](15, 10);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](16, LabRecordsListComponent_th_16_Template, 2, 0, "th", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](17, LabRecordsListComponent_td_17_Template, 2, 1, "td", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementContainerStart"](18, 11);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](19, LabRecordsListComponent_th_19_Template, 2, 0, "th", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](20, LabRecordsListComponent_td_20_Template, 2, 1, "td", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementContainerStart"](21, 12);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](22, LabRecordsListComponent_th_22_Template, 2, 0, "th", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](23, LabRecordsListComponent_td_23_Template, 16, 1, "td", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](24, LabRecordsListComponent_tr_24_Template, 1, 0, "tr", 13);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](25, LabRecordsListComponent_tr_25_Template, 1, 0, "tr", 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelement"](26, "mat-paginator", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]()();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](27, "div", 16)(28, "button", 17);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵlistener"]("click", function LabRecordsListComponent_Template_button_click_28_listener() {
          return ctx.addRecord();
        });
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](29, "mat-icon");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](30, "add");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]()()();
      }
      if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate1"]("", ctx.data["title"], " List");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](6);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("dataSource", ctx.recordData);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](16);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("matHeaderRowDef", ctx.displayedColumns);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("matRowDefColumns", ctx.displayedColumns);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("pageSize", 10)("pageSizeOptions", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpureFunction0"](6, _c0));
      }
    },
    dependencies: [_angular_material_table__WEBPACK_IMPORTED_MODULE_5__.MatTable, _angular_material_table__WEBPACK_IMPORTED_MODULE_5__.MatHeaderCellDef, _angular_material_table__WEBPACK_IMPORTED_MODULE_5__.MatHeaderRowDef, _angular_material_table__WEBPACK_IMPORTED_MODULE_5__.MatColumnDef, _angular_material_table__WEBPACK_IMPORTED_MODULE_5__.MatCellDef, _angular_material_table__WEBPACK_IMPORTED_MODULE_5__.MatRowDef, _angular_material_table__WEBPACK_IMPORTED_MODULE_5__.MatHeaderCell, _angular_material_table__WEBPACK_IMPORTED_MODULE_5__.MatCell, _angular_material_table__WEBPACK_IMPORTED_MODULE_5__.MatHeaderRow, _angular_material_table__WEBPACK_IMPORTED_MODULE_5__.MatRow, _angular_material_button__WEBPACK_IMPORTED_MODULE_10__.MatIconButton, _angular_material_button__WEBPACK_IMPORTED_MODULE_10__.MatMiniFabButton, _angular_material_menu__WEBPACK_IMPORTED_MODULE_11__.MatMenu, _angular_material_menu__WEBPACK_IMPORTED_MODULE_11__.MatMenuItem, _angular_material_menu__WEBPACK_IMPORTED_MODULE_11__.MatMenuTrigger, _angular_material_icon__WEBPACK_IMPORTED_MODULE_12__.MatIcon, _angular_material_paginator__WEBPACK_IMPORTED_MODULE_8__.MatPaginator],
    styles: [".btn[_ngcontent-%COMP%] {\n  display: flex;\n  justify-content: end;\n}\n\n.card[_ngcontent-%COMP%] {\n  padding: 2px;\n}\n\nmat-card-content[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: column;\n  justify-content: center;\n}\n\n.record-grid[_ngcontent-%COMP%] {\n  min-height: 80%;\n  max-height: -moz-fit-content;\n  max-height: fit-content;\n}\n\nmat-form-field[_ngcontent-%COMP%] {\n  display: block;\n  margin: 10px 0;\n}\n\n.header[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: row;\n  justify-content: space-between;\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImxhYi1yZWNvcmRzLWxpc3QuY29tcG9uZW50LnNjc3MiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7RUFDSSxhQUFBO0VBQ0Esb0JBQUE7QUFDSjs7QUFFQTtFQUNJLFlBQUE7QUFDSjs7QUFHQTtFQUNJLGFBQUE7RUFDQSxzQkFBQTtFQUNBLHVCQUFBO0FBQUo7O0FBSUE7RUFDSSxlQUFBO0VBQ0EsNEJBQUE7RUFBQSx1QkFBQTtBQURKOztBQUtBO0VBQ0ksY0FBQTtFQUNBLGNBQUE7QUFGSjs7QUFLQTtFQUNJLGFBQUE7RUFDQSxtQkFBQTtFQUNBLDhCQUFBO0FBRkoiLCJmaWxlIjoibGFiLXJlY29yZHMtbGlzdC5jb21wb25lbnQuc2NzcyIsInNvdXJjZXNDb250ZW50IjpbIi5idG4ge1xuICAgIGRpc3BsYXk6IGZsZXg7XG4gICAganVzdGlmeS1jb250ZW50OiBlbmQ7XG59XG5cbi5jYXJkIHtcbiAgICBwYWRkaW5nOiAycHg7XG4gXG59XG5cbm1hdC1jYXJkLWNvbnRlbnQge1xuICAgIGRpc3BsYXk6IGZsZXg7XG4gICAgZmxleC1kaXJlY3Rpb246IGNvbHVtbjtcbiAgICBqdXN0aWZ5LWNvbnRlbnQ6IGNlbnRlcjtcbiAgICAvLyBhbGlnbi1pdGVtczogY2VudGVyO1xuXG59XG4ucmVjb3JkLWdyaWR7XG4gICAgbWluLWhlaWdodDogODAlO1xuICAgIG1heC1oZWlnaHQ6IGZpdC1jb250ZW50O1xufVxuXG5cbm1hdC1mb3JtLWZpZWxkIHtcbiAgICBkaXNwbGF5OiBibG9jaztcbiAgICBtYXJnaW46IDEwcHggMDtcbn1cblxuLmhlYWRlciB7XG4gICAgZGlzcGxheTogZmxleDtcbiAgICBmbGV4LWRpcmVjdGlvbjogcm93O1xuICAgIGp1c3RpZnktY29udGVudDogc3BhY2UtYmV0d2Vlbjtcbn0iXX0= */\n/*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8uL3NyYy9hcHAvbW9kdWxlcy91c2VyLW1hbmFlbWVudC9tZWRpY2FsLXJlY29yZHMvbGFiLXJlY29yZHMtbGlzdC9sYWItcmVjb3Jkcy1saXN0LmNvbXBvbmVudC5zY3NzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBO0VBQ0ksYUFBQTtFQUNBLG9CQUFBO0FBQ0o7O0FBRUE7RUFDSSxZQUFBO0FBQ0o7O0FBR0E7RUFDSSxhQUFBO0VBQ0Esc0JBQUE7RUFDQSx1QkFBQTtBQUFKOztBQUlBO0VBQ0ksZUFBQTtFQUNBLDRCQUFBO0VBQUEsdUJBQUE7QUFESjs7QUFLQTtFQUNJLGNBQUE7RUFDQSxjQUFBO0FBRko7O0FBS0E7RUFDSSxhQUFBO0VBQ0EsbUJBQUE7RUFDQSw4QkFBQTtBQUZKO0FBRUEsNG5DQUE0bkMiLCJzb3VyY2VzQ29udGVudCI6WyIuYnRuIHtcbiAgICBkaXNwbGF5OiBmbGV4O1xuICAgIGp1c3RpZnktY29udGVudDogZW5kO1xufVxuXG4uY2FyZCB7XG4gICAgcGFkZGluZzogMnB4O1xuIFxufVxuXG5tYXQtY2FyZC1jb250ZW50IHtcbiAgICBkaXNwbGF5OiBmbGV4O1xuICAgIGZsZXgtZGlyZWN0aW9uOiBjb2x1bW47XG4gICAganVzdGlmeS1jb250ZW50OiBjZW50ZXI7XG4gICAgLy8gYWxpZ24taXRlbXM6IGNlbnRlcjtcblxufVxuLnJlY29yZC1ncmlke1xuICAgIG1pbi1oZWlnaHQ6IDgwJTtcbiAgICBtYXgtaGVpZ2h0OiBmaXQtY29udGVudDtcbn1cblxuXG5tYXQtZm9ybS1maWVsZCB7XG4gICAgZGlzcGxheTogYmxvY2s7XG4gICAgbWFyZ2luOiAxMHB4IDA7XG59XG5cbi5oZWFkZXIge1xuICAgIGRpc3BsYXk6IGZsZXg7XG4gICAgZmxleC1kaXJlY3Rpb246IHJvdztcbiAgICBqdXN0aWZ5LWNvbnRlbnQ6IHNwYWNlLWJldHdlZW47XG59Il0sInNvdXJjZVJvb3QiOiIifQ== */"]
  });
}


/***/ }),

/***/ 82881:
/*!***********************************************************************************************************!*\
  !*** ./src/app/modules/user-manaement/medical-records/prescriptions-list/prescriptions-list.component.ts ***!
  \***********************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "PrescriptionsListComponent": () => (/* binding */ PrescriptionsListComponent)
/* harmony export */ });
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/forms */ 69542);
/* harmony import */ var _angular_material_dialog__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/material/dialog */ 67486);
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! moment */ 56908);
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(moment__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _add_prescriptions_add_prescriptions_component__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../add-prescriptions/add-prescriptions.component */ 3882);
/* harmony import */ var _angular_material_paginator__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @angular/material/paginator */ 86907);
/* harmony import */ var _angular_material_sort__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @angular/material/sort */ 95096);
/* harmony import */ var _angular_material_table__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/material/table */ 83348);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/core */ 86839);
/* harmony import */ var app_services_pet_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! app/services/pet.service */ 59976);
/* harmony import */ var app_services_loader_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! app/services/loader.service */ 38555);
/* harmony import */ var _angular_material_button__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @angular/material/button */ 83677);
/* harmony import */ var _angular_material_menu__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @angular/material/menu */ 89314);
/* harmony import */ var _angular_material_icon__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @angular/material/icon */ 69941);

















function PrescriptionsListComponent_th_10_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "th", 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](1, " ID. ");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
  }
}
function PrescriptionsListComponent_td_11_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "td", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const element_r10 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate1"](" ", element_r10.id.substring(0, 6), " ");
  }
}
function PrescriptionsListComponent_th_13_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "th", 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](1, " Type ");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
  }
}
function PrescriptionsListComponent_td_14_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "td", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const element_r11 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate1"](" ", element_r11.docName, " ");
  }
}
function PrescriptionsListComponent_th_16_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "th", 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](1, " Received On ");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
  }
}
function PrescriptionsListComponent_td_17_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "td", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const element_r12 = ctx.$implicit;
    const ctx_r5 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate1"](" ", ctx_r5.currentUTCDate(element_r12.docDate), " ");
  }
}
function PrescriptionsListComponent_th_19_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "th", 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](1, " Action ");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
  }
}
function PrescriptionsListComponent_td_20_Template(rf, ctx) {
  if (rf & 1) {
    const _r17 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "td", 18)(1, "button", 19);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵlistener"]("click", function PrescriptionsListComponent_td_20_Template_button_click_1_listener() {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵrestoreView"](_r17);
      const i_r14 = restoredCtx.index;
      const element_r13 = restoredCtx.$implicit;
      const ctx_r16 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵresetView"](ctx_r16.toggle(i_r14, element_r13));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](2, "mat-icon");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](3, "more_vert");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]()();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](4, "mat-menu", null, 20)(6, "button", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵlistener"]("click", function PrescriptionsListComponent_td_20_Template_button_click_6_listener() {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵrestoreView"](_r17);
      const element_r13 = restoredCtx.$implicit;
      const i_r14 = restoredCtx.index;
      const ctx_r18 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵresetView"](ctx_r18.edit(element_r13, i_r14));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](7, "span", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](8, "Edit");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](9, "mat-icon", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](10, "edit");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]()();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](11, "button", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵlistener"]("click", function PrescriptionsListComponent_td_20_Template_button_click_11_listener() {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵrestoreView"](_r17);
      const element_r13 = restoredCtx.$implicit;
      const i_r14 = restoredCtx.index;
      const ctx_r19 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵresetView"](ctx_r19.delete(element_r13, i_r14));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](12, "span", 24);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](13, "Delete");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](14, "mat-icon", 25);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](15, "delete");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]()()()();
  }
  if (rf & 2) {
    const _r15 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵreference"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("matMenuTriggerFor", _r15);
  }
}
function PrescriptionsListComponent_tr_21_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelement"](0, "tr", 26);
  }
}
function PrescriptionsListComponent_tr_22_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelement"](0, "tr", 27);
  }
}
const _c0 = function () {
  return [5, 10, 25, 100];
};
class PrescriptionsListComponent {
  constructor(dialogRef, data, fb, dialog, petService, loader) {
    this.dialogRef = dialogRef;
    this.data = data;
    this.fb = fb;
    this.dialog = dialog;
    this.petService = petService;
    this.loader = loader;
    this.displayedColumns = ['id', 'type', 'vaccinationDate', 'action'];
    this.createForm();
    this.getPrescriptionRecords();
  }
  getPrescriptionRecords() {
    this.petService.getMedicalRecord(sessionStorage.getItem('petId'), 'priscription').subscribe(res => {
      if (res.length == 0) {
        this.petService.medicalRecordData[3]['icon'] = './assets/icons/grey-pet-history/prescriptions.svg';
      }
      console.log(res);
      const petParentsArray = Object.values(res);
      this.recordData = new _angular_material_table__WEBPACK_IMPORTED_MODULE_5__.MatTableDataSource(petParentsArray.map(item => ({
        ...item
      })));
      this.recordData.paginator = this.paginator;
      this.recordData.sort = this.sort;
    });
  }
  toggle(i, record) {}
  createForm() {
    this.form = this.fb.group({
      title: ['', _angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.required],
      receivedDate: ['', _angular_forms__WEBPACK_IMPORTED_MODULE_6__.Validators.required],
      document: ['']
    });
  }
  currentUTCDate(date) {
    return moment__WEBPACK_IMPORTED_MODULE_0___default().utc(date).local().format("DD-MMM-YYYY");
  }
  delete(record, i) {
    this.loader.showLoader();
    this.petService.deleteMedicalRecord(sessionStorage.getItem('petParentId'), record['id']).subscribe(res => {
      this.loader.hideLoader();
      this.getPrescriptionRecords();
      console.log(res);
    }, error => {
      this.loader.hideLoader();
    });
  }
  edit(record, i) {
    this.recordData[i];
    const dialogRef = this.dialog.open(_add_prescriptions_add_prescriptions_component__WEBPACK_IMPORTED_MODULE_1__.AddPrescriptionsComponent, {
      data: {
        type: this.data['title'],
        record: record
      }
    });
    dialogRef.afterClosed().subscribe(result => {
      console.log('The dialog was closed');
      console.log(result);
      this.getPrescriptionRecords();
    });
  }
  addRecord() {
    const dialogRef = this.dialog.open(_add_prescriptions_add_prescriptions_component__WEBPACK_IMPORTED_MODULE_1__.AddPrescriptionsComponent, {
      data: {
        type: this.data['title']
      }
    });
    dialogRef.afterClosed().subscribe(result => {
      console.log('The dialog was closed');
      console.log(result);
      this.getPrescriptionRecords();
    });
  }
  onNoClick() {
    this.dialogRef.close();
  }
  static #_ = this.ɵfac = function PrescriptionsListComponent_Factory(t) {
    return new (t || PrescriptionsListComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](_angular_material_dialog__WEBPACK_IMPORTED_MODULE_7__.MatDialogRef), _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](_angular_material_dialog__WEBPACK_IMPORTED_MODULE_7__.MAT_DIALOG_DATA), _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](_angular_forms__WEBPACK_IMPORTED_MODULE_6__.FormBuilder), _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](_angular_material_dialog__WEBPACK_IMPORTED_MODULE_7__.MatDialog), _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](app_services_pet_service__WEBPACK_IMPORTED_MODULE_2__.PetService), _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](app_services_loader_service__WEBPACK_IMPORTED_MODULE_3__.LoaderService));
  };
  static #_2 = this.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdefineComponent"]({
    type: PrescriptionsListComponent,
    selectors: [["app-prescriptions-list"]],
    viewQuery: function PrescriptionsListComponent_Query(rf, ctx) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵviewQuery"](_angular_material_paginator__WEBPACK_IMPORTED_MODULE_8__.MatPaginator, 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵviewQuery"](_angular_material_sort__WEBPACK_IMPORTED_MODULE_9__.MatSort, 5);
      }
      if (rf & 2) {
        let _t;
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵloadQuery"]()) && (ctx.paginator = _t.first);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵloadQuery"]()) && (ctx.sort = _t.first);
      }
    },
    decls: 28,
    vars: 7,
    consts: [[1, "header"], ["mat-dialog-title", "", 2, "align-items", "center"], ["mat-mini-fab", "", "color", "warn", 3, "click"], ["mat-dialog-content", "", 1, "record-grid", 2, "min-height", "150px"], [1, "table-wrapper"], ["mat-table", "", 1, "mat-elevation-z8", "mt-2", 3, "dataSource"], ["matColumnDef", "id"], ["mat-header-cell", "", 4, "matHeaderCellDef"], ["mat-cell", "", 4, "matCellDef"], ["matColumnDef", "type"], ["matColumnDef", "vaccinationDate"], ["matColumnDef", "action"], ["mat-header-row", "", 4, "matHeaderRowDef"], ["mat-row", "", 4, "matRowDef", "matRowDefColumns"], [3, "pageSize", "pageSizeOptions"], [1, "btn"], ["mat-mini-fab", "", "color", "primary", 3, "click"], ["mat-header-cell", ""], ["mat-cell", ""], ["mat-icon-button", "", 3, "matMenuTriggerFor", "click"], ["actionMenu", "matMenu"], ["mat-menu-item", "", 3, "click"], [2, "color", "blue !important"], ["color", "primary"], [2, "color", "hsl(0, 94%, 42%) !important"], ["color", "warn"], ["mat-header-row", ""], ["mat-row", ""]],
    template: function PrescriptionsListComponent_Template(rf, ctx) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "div", 0)(1, "h1", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](3, "button", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵlistener"]("click", function PrescriptionsListComponent_Template_button_click_3_listener() {
          return ctx.onNoClick();
        });
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](4, "mat-icon");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](5, "close");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]()()();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](6, "div", 3)(7, "div", 4)(8, "table", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementContainerStart"](9, 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](10, PrescriptionsListComponent_th_10_Template, 2, 0, "th", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](11, PrescriptionsListComponent_td_11_Template, 2, 1, "td", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementContainerStart"](12, 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](13, PrescriptionsListComponent_th_13_Template, 2, 0, "th", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](14, PrescriptionsListComponent_td_14_Template, 2, 1, "td", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementContainerStart"](15, 10);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](16, PrescriptionsListComponent_th_16_Template, 2, 0, "th", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](17, PrescriptionsListComponent_td_17_Template, 2, 1, "td", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementContainerStart"](18, 11);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](19, PrescriptionsListComponent_th_19_Template, 2, 0, "th", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](20, PrescriptionsListComponent_td_20_Template, 16, 1, "td", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](21, PrescriptionsListComponent_tr_21_Template, 1, 0, "tr", 12);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](22, PrescriptionsListComponent_tr_22_Template, 1, 0, "tr", 13);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelement"](23, "mat-paginator", 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]()();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](24, "div", 15)(25, "button", 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵlistener"]("click", function PrescriptionsListComponent_Template_button_click_25_listener() {
          return ctx.addRecord();
        });
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](26, "mat-icon");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](27, "add");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]()()();
      }
      if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate1"]("", ctx.data["title"], " Records List");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](6);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("dataSource", ctx.recordData);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](13);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("matHeaderRowDef", ctx.displayedColumns);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("matRowDefColumns", ctx.displayedColumns);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("pageSize", 10)("pageSizeOptions", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpureFunction0"](6, _c0));
      }
    },
    dependencies: [_angular_material_table__WEBPACK_IMPORTED_MODULE_5__.MatTable, _angular_material_table__WEBPACK_IMPORTED_MODULE_5__.MatHeaderCellDef, _angular_material_table__WEBPACK_IMPORTED_MODULE_5__.MatHeaderRowDef, _angular_material_table__WEBPACK_IMPORTED_MODULE_5__.MatColumnDef, _angular_material_table__WEBPACK_IMPORTED_MODULE_5__.MatCellDef, _angular_material_table__WEBPACK_IMPORTED_MODULE_5__.MatRowDef, _angular_material_table__WEBPACK_IMPORTED_MODULE_5__.MatHeaderCell, _angular_material_table__WEBPACK_IMPORTED_MODULE_5__.MatCell, _angular_material_table__WEBPACK_IMPORTED_MODULE_5__.MatHeaderRow, _angular_material_table__WEBPACK_IMPORTED_MODULE_5__.MatRow, _angular_material_button__WEBPACK_IMPORTED_MODULE_10__.MatIconButton, _angular_material_button__WEBPACK_IMPORTED_MODULE_10__.MatMiniFabButton, _angular_material_menu__WEBPACK_IMPORTED_MODULE_11__.MatMenu, _angular_material_menu__WEBPACK_IMPORTED_MODULE_11__.MatMenuItem, _angular_material_menu__WEBPACK_IMPORTED_MODULE_11__.MatMenuTrigger, _angular_material_icon__WEBPACK_IMPORTED_MODULE_12__.MatIcon, _angular_material_paginator__WEBPACK_IMPORTED_MODULE_8__.MatPaginator],
    styles: [".btn[_ngcontent-%COMP%] {\n  display: flex;\n  justify-content: end;\n}\n\n.card[_ngcontent-%COMP%] {\n  padding: 2px;\n}\n\nmat-card-content[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: column;\n  justify-content: center;\n}\n\n.record-grid[_ngcontent-%COMP%] {\n  min-height: 80%;\n  max-height: -moz-fit-content;\n  max-height: fit-content;\n}\n\nmat-form-field[_ngcontent-%COMP%] {\n  display: block;\n  margin: 10px 0;\n}\n\n.header[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: row;\n  justify-content: space-between;\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInByZXNjcmlwdGlvbnMtbGlzdC5jb21wb25lbnQuc2NzcyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTtFQUNJLGFBQUE7RUFDQSxvQkFBQTtBQUNKOztBQUVBO0VBQ0ksWUFBQTtBQUNKOztBQUdBO0VBQ0ksYUFBQTtFQUNBLHNCQUFBO0VBQ0EsdUJBQUE7QUFBSjs7QUFJQTtFQUNJLGVBQUE7RUFDQSw0QkFBQTtFQUFBLHVCQUFBO0FBREo7O0FBS0E7RUFDSSxjQUFBO0VBQ0EsY0FBQTtBQUZKOztBQUtBO0VBQ0ksYUFBQTtFQUNBLG1CQUFBO0VBQ0EsOEJBQUE7QUFGSiIsImZpbGUiOiJwcmVzY3JpcHRpb25zLWxpc3QuY29tcG9uZW50LnNjc3MiLCJzb3VyY2VzQ29udGVudCI6WyIuYnRuIHtcbiAgICBkaXNwbGF5OiBmbGV4O1xuICAgIGp1c3RpZnktY29udGVudDogZW5kO1xufVxuXG4uY2FyZCB7XG4gICAgcGFkZGluZzogMnB4O1xuIFxufVxuXG5tYXQtY2FyZC1jb250ZW50IHtcbiAgICBkaXNwbGF5OiBmbGV4O1xuICAgIGZsZXgtZGlyZWN0aW9uOiBjb2x1bW47XG4gICAganVzdGlmeS1jb250ZW50OiBjZW50ZXI7XG4gICAgLy8gYWxpZ24taXRlbXM6IGNlbnRlcjtcblxufVxuLnJlY29yZC1ncmlke1xuICAgIG1pbi1oZWlnaHQ6IDgwJTtcbiAgICBtYXgtaGVpZ2h0OiBmaXQtY29udGVudDtcbn1cblxuXG5tYXQtZm9ybS1maWVsZCB7XG4gICAgZGlzcGxheTogYmxvY2s7XG4gICAgbWFyZ2luOiAxMHB4IDA7XG59XG5cbi5oZWFkZXIge1xuICAgIGRpc3BsYXk6IGZsZXg7XG4gICAgZmxleC1kaXJlY3Rpb246IHJvdztcbiAgICBqdXN0aWZ5LWNvbnRlbnQ6IHNwYWNlLWJldHdlZW47XG59Il19 */\n/*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8uL3NyYy9hcHAvbW9kdWxlcy91c2VyLW1hbmFlbWVudC9tZWRpY2FsLXJlY29yZHMvcHJlc2NyaXB0aW9ucy1saXN0L3ByZXNjcmlwdGlvbnMtbGlzdC5jb21wb25lbnQuc2NzcyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTtFQUNJLGFBQUE7RUFDQSxvQkFBQTtBQUNKOztBQUVBO0VBQ0ksWUFBQTtBQUNKOztBQUdBO0VBQ0ksYUFBQTtFQUNBLHNCQUFBO0VBQ0EsdUJBQUE7QUFBSjs7QUFJQTtFQUNJLGVBQUE7RUFDQSw0QkFBQTtFQUFBLHVCQUFBO0FBREo7O0FBS0E7RUFDSSxjQUFBO0VBQ0EsY0FBQTtBQUZKOztBQUtBO0VBQ0ksYUFBQTtFQUNBLG1CQUFBO0VBQ0EsOEJBQUE7QUFGSjtBQUVBLGdvQ0FBZ29DIiwic291cmNlc0NvbnRlbnQiOlsiLmJ0biB7XG4gICAgZGlzcGxheTogZmxleDtcbiAgICBqdXN0aWZ5LWNvbnRlbnQ6IGVuZDtcbn1cblxuLmNhcmQge1xuICAgIHBhZGRpbmc6IDJweDtcbiBcbn1cblxubWF0LWNhcmQtY29udGVudCB7XG4gICAgZGlzcGxheTogZmxleDtcbiAgICBmbGV4LWRpcmVjdGlvbjogY29sdW1uO1xuICAgIGp1c3RpZnktY29udGVudDogY2VudGVyO1xuICAgIC8vIGFsaWduLWl0ZW1zOiBjZW50ZXI7XG5cbn1cbi5yZWNvcmQtZ3JpZHtcbiAgICBtaW4taGVpZ2h0OiA4MCU7XG4gICAgbWF4LWhlaWdodDogZml0LWNvbnRlbnQ7XG59XG5cblxubWF0LWZvcm0tZmllbGQge1xuICAgIGRpc3BsYXk6IGJsb2NrO1xuICAgIG1hcmdpbjogMTBweCAwO1xufVxuXG4uaGVhZGVyIHtcbiAgICBkaXNwbGF5OiBmbGV4O1xuICAgIGZsZXgtZGlyZWN0aW9uOiByb3c7XG4gICAganVzdGlmeS1jb250ZW50OiBzcGFjZS1iZXR3ZWVuO1xufSJdLCJzb3VyY2VSb290IjoiIn0= */"]
  });
}


/***/ }),

/***/ 74966:
/*!***********************************************************************************************************************!*\
  !*** ./src/app/modules/user-manaement/medical-records/vaccination-records-list/vaccination-records-list.component.ts ***!
  \***********************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "VaccinationRecordsListComponent": () => (/* binding */ VaccinationRecordsListComponent)
/* harmony export */ });
/* harmony import */ var _angular_material_dialog__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/material/dialog */ 67486);
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! moment */ 56908);
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(moment__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _add_vaccination_record_add_vaccination_record_component__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../add-vaccination-record/add-vaccination-record.component */ 71516);
/* harmony import */ var _angular_material_paginator__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @angular/material/paginator */ 86907);
/* harmony import */ var _angular_material_sort__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @angular/material/sort */ 95096);
/* harmony import */ var _angular_material_table__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/material/table */ 83348);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/core */ 86839);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/forms */ 69542);
/* harmony import */ var app_services_pet_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! app/services/pet.service */ 59976);
/* harmony import */ var app_services_loader_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! app/services/loader.service */ 38555);
/* harmony import */ var _angular_material_button__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @angular/material/button */ 83677);
/* harmony import */ var _angular_material_menu__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @angular/material/menu */ 89314);
/* harmony import */ var _angular_material_icon__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @angular/material/icon */ 69941);
















function VaccinationRecordsListComponent_th_10_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "th", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](1, " ID. ");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
  }
}
function VaccinationRecordsListComponent_td_11_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "td", 19);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const element_r12 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate1"](" ", element_r12.id.substring(0, 6), " ");
  }
}
function VaccinationRecordsListComponent_th_13_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "th", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](1, " Type ");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
  }
}
function VaccinationRecordsListComponent_td_14_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "td", 19);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const element_r13 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate1"](" ", element_r13.docName == "Others" ? element_r13.subType : element_r13.docName, " ");
  }
}
function VaccinationRecordsListComponent_th_16_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "th", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](1, " vaccination Date ");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
  }
}
function VaccinationRecordsListComponent_td_17_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "td", 19);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const element_r14 = ctx.$implicit;
    const ctx_r5 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate1"](" ", ctx_r5.currentUTCDate(element_r14.docDate), " ");
  }
}
function VaccinationRecordsListComponent_th_19_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "th", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](1, " Next Date ");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
  }
}
function VaccinationRecordsListComponent_td_20_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "td", 19);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const element_r15 = ctx.$implicit;
    const ctx_r7 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate1"](" ", element_r15.nextDate ? ctx_r7.currentUTCDate(element_r15.nextDate) : "", " ");
  }
}
function VaccinationRecordsListComponent_th_22_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "th", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](1, " Action ");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
  }
}
function VaccinationRecordsListComponent_td_23_Template(rf, ctx) {
  if (rf & 1) {
    const _r20 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "td", 19)(1, "button", 20);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵlistener"]("click", function VaccinationRecordsListComponent_td_23_Template_button_click_1_listener() {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵrestoreView"](_r20);
      const i_r17 = restoredCtx.index;
      const element_r16 = restoredCtx.$implicit;
      const ctx_r19 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵresetView"](ctx_r19.toggle(i_r17, element_r16));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](2, "mat-icon");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](3, "more_vert");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]()();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](4, "mat-menu", null, 21)(6, "button", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵlistener"]("click", function VaccinationRecordsListComponent_td_23_Template_button_click_6_listener() {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵrestoreView"](_r20);
      const element_r16 = restoredCtx.$implicit;
      const i_r17 = restoredCtx.index;
      const ctx_r21 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵresetView"](ctx_r21.edit(element_r16, i_r17));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](7, "span", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](8, "Edit");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](9, "mat-icon", 24);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](10, "edit");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]()();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](11, "button", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵlistener"]("click", function VaccinationRecordsListComponent_td_23_Template_button_click_11_listener() {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵrestoreView"](_r20);
      const element_r16 = restoredCtx.$implicit;
      const i_r17 = restoredCtx.index;
      const ctx_r22 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵresetView"](ctx_r22.delete(element_r16, i_r17));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](12, "span", 25);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](13, "Delete");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](14, "mat-icon", 26);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](15, "delete");
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]()()()();
  }
  if (rf & 2) {
    const _r18 = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵreference"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("matMenuTriggerFor", _r18);
  }
}
function VaccinationRecordsListComponent_tr_24_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelement"](0, "tr", 27);
  }
}
function VaccinationRecordsListComponent_tr_25_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelement"](0, "tr", 28);
  }
}
const _c0 = function () {
  return [5, 10, 25, 100];
};
class VaccinationRecordsListComponent {
  constructor(dialogRef, data, fb, dialog, petService, loader) {
    // this.records = this.fb.array([])
    // this.createForm();
    this.dialogRef = dialogRef;
    this.data = data;
    this.fb = fb;
    this.dialog = dialog;
    this.petService = petService;
    this.loader = loader;
    this.displayedColumns = ['id', 'type', 'vaccinationDate', 'nextDate', 'action'];
  }
  ngOnInit() {
    this.getVaccinationRecords();
  }
  ngAfterViewInit() {
    this.recordData.paginator = this.paginator;
  }
  getVaccinationRecords() {
    this.petService.getMedicalRecord(sessionStorage.getItem('petId'), 'vaccinationRecord').subscribe(res => {
      console.log(res);
      if (res.length == 0) {
        this.petService.medicalRecordData[0]['icon'] = './assets/icons/grey-pet-history/vaccination rec.svg';
      }
      const petParentsArray = Object.values(res);
      this.recordData = new _angular_material_table__WEBPACK_IMPORTED_MODULE_5__.MatTableDataSource(petParentsArray.map(item => ({
        ...item
      })));
      this.recordData.paginator = this.paginator;
      this.recordData.sort = this.sort;
    }, error => {
      console.log(error);
    });
  }
  toggle(i, record) {}
  currentUTCDate(date) {
    if (date) {
      return moment__WEBPACK_IMPORTED_MODULE_0___default().utc(date).local().format("DD-MMM-YYYY");
    } else {
      return 0;
    }
  }
  getRecord() {
    this.petService.getMedicalRecord(sessionStorage.getItem('petId'), 'vaccinationRecord').subscribe(res => {
      console.log(res);
    });
  }
  delete(record, i) {
    this.loader.showLoader();
    this.petService.deleteMedicalRecord(sessionStorage.getItem('petParentId'), record['id']).subscribe(res => {
      this.loader.hideLoader();
      this.getVaccinationRecords();
      console.log(res);
    }, error => {
      this.loader.hideLoader();
    });
  }
  edit(record, i) {
    const dialogRef = this.dialog.open(_add_vaccination_record_add_vaccination_record_component__WEBPACK_IMPORTED_MODULE_1__.AddVaccinationRecordComponent, {
      height: '500px',
      data: {
        type: this.data['title'],
        record: record
      }
    });
    dialogRef.afterClosed().subscribe(result => {
      console.log('The dialog was closed');
      console.log(result);
      this.getVaccinationRecords();
      // this.getVaccinationRecords()
    });
  }
  addRecord() {
    const dialogRef = this.dialog.open(_add_vaccination_record_add_vaccination_record_component__WEBPACK_IMPORTED_MODULE_1__.AddVaccinationRecordComponent, {
      height: '500px',
      data: {
        type: this.data['title']
      }
    });
    dialogRef.afterClosed().subscribe(result => {
      console.log('The dialog was closed');
      console.log(result);
      this.getVaccinationRecords();
    });
  }
  onNoClick() {
    this.dialogRef.close();
  }
  static #_ = this.ɵfac = function VaccinationRecordsListComponent_Factory(t) {
    return new (t || VaccinationRecordsListComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](_angular_material_dialog__WEBPACK_IMPORTED_MODULE_6__.MatDialogRef), _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](_angular_material_dialog__WEBPACK_IMPORTED_MODULE_6__.MAT_DIALOG_DATA), _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](_angular_forms__WEBPACK_IMPORTED_MODULE_7__.FormBuilder), _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](_angular_material_dialog__WEBPACK_IMPORTED_MODULE_6__.MatDialog), _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](app_services_pet_service__WEBPACK_IMPORTED_MODULE_2__.PetService), _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdirectiveInject"](app_services_loader_service__WEBPACK_IMPORTED_MODULE_3__.LoaderService));
  };
  static #_2 = this.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵdefineComponent"]({
    type: VaccinationRecordsListComponent,
    selectors: [["app-vaccination-records-list"]],
    viewQuery: function VaccinationRecordsListComponent_Query(rf, ctx) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵviewQuery"](_angular_material_paginator__WEBPACK_IMPORTED_MODULE_8__.MatPaginator, 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵviewQuery"](_angular_material_sort__WEBPACK_IMPORTED_MODULE_9__.MatSort, 5);
      }
      if (rf & 2) {
        let _t;
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵloadQuery"]()) && (ctx.paginator = _t.first);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵloadQuery"]()) && (ctx.sort = _t.first);
      }
    },
    decls: 31,
    vars: 7,
    consts: [[1, "header"], ["mat-dialog-title", "", 2, "align-items", "center"], ["mat-mini-fab", "", "color", "warn", 3, "click"], ["mat-dialog-content", "", 1, "record-grid", 2, "min-height", "150px", "height", "400px", "overflow-y", "auto"], [1, "table-wrapper"], ["mat-table", "", 1, "mat-elevation-z8", "mt-2", 3, "dataSource"], ["matColumnDef", "id"], ["mat-header-cell", "", 4, "matHeaderCellDef"], ["mat-cell", "", 4, "matCellDef"], ["matColumnDef", "type"], ["matColumnDef", "vaccinationDate"], ["matColumnDef", "nextDate"], ["matColumnDef", "action"], ["mat-header-row", "", 4, "matHeaderRowDef"], ["mat-row", "", 4, "matRowDef", "matRowDefColumns"], [3, "pageSize", "pageSizeOptions"], [1, "btn"], ["mat-mini-fab", "", "color", "primary", 3, "click"], ["mat-header-cell", ""], ["mat-cell", ""], ["mat-icon-button", "", 3, "matMenuTriggerFor", "click"], ["actionMenu", "matMenu"], ["mat-menu-item", "", 3, "click"], [2, "color", "blue !important"], ["color", "primary"], [2, "color", "hsl(0, 94%, 42%) !important"], ["color", "warn"], ["mat-header-row", ""], ["mat-row", ""]],
    template: function VaccinationRecordsListComponent_Template(rf, ctx) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](0, "div", 0)(1, "h1", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](3, "button", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵlistener"]("click", function VaccinationRecordsListComponent_Template_button_click_3_listener() {
          return ctx.onNoClick();
        });
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](4, "mat-icon");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](5, "close");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]()()();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](6, "div", 3)(7, "div", 4)(8, "table", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementContainerStart"](9, 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](10, VaccinationRecordsListComponent_th_10_Template, 2, 0, "th", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](11, VaccinationRecordsListComponent_td_11_Template, 2, 1, "td", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementContainerStart"](12, 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](13, VaccinationRecordsListComponent_th_13_Template, 2, 0, "th", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](14, VaccinationRecordsListComponent_td_14_Template, 2, 1, "td", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementContainerStart"](15, 10);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](16, VaccinationRecordsListComponent_th_16_Template, 2, 0, "th", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](17, VaccinationRecordsListComponent_td_17_Template, 2, 1, "td", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementContainerStart"](18, 11);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](19, VaccinationRecordsListComponent_th_19_Template, 2, 0, "th", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](20, VaccinationRecordsListComponent_td_20_Template, 2, 1, "td", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementContainerStart"](21, 12);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](22, VaccinationRecordsListComponent_th_22_Template, 2, 0, "th", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](23, VaccinationRecordsListComponent_td_23_Template, 16, 1, "td", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](24, VaccinationRecordsListComponent_tr_24_Template, 1, 0, "tr", 13);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtemplate"](25, VaccinationRecordsListComponent_tr_25_Template, 1, 0, "tr", 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelement"](26, "mat-paginator", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]()();
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](27, "div", 16)(28, "button", 17);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵlistener"]("click", function VaccinationRecordsListComponent_Template_button_click_28_listener() {
          return ctx.addRecord();
        });
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementStart"](29, "mat-icon");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtext"](30, "add");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵelementEnd"]()()();
      }
      if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵtextInterpolate1"]("", ctx.data["title"], " Records List");
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](6);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("dataSource", ctx.recordData);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](16);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("matHeaderRowDef", ctx.displayedColumns);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("matRowDefColumns", ctx.displayedColumns);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵproperty"]("pageSize", 10)("pageSizeOptions", _angular_core__WEBPACK_IMPORTED_MODULE_4__["ɵɵpureFunction0"](6, _c0));
      }
    },
    dependencies: [_angular_material_table__WEBPACK_IMPORTED_MODULE_5__.MatTable, _angular_material_table__WEBPACK_IMPORTED_MODULE_5__.MatHeaderCellDef, _angular_material_table__WEBPACK_IMPORTED_MODULE_5__.MatHeaderRowDef, _angular_material_table__WEBPACK_IMPORTED_MODULE_5__.MatColumnDef, _angular_material_table__WEBPACK_IMPORTED_MODULE_5__.MatCellDef, _angular_material_table__WEBPACK_IMPORTED_MODULE_5__.MatRowDef, _angular_material_table__WEBPACK_IMPORTED_MODULE_5__.MatHeaderCell, _angular_material_table__WEBPACK_IMPORTED_MODULE_5__.MatCell, _angular_material_table__WEBPACK_IMPORTED_MODULE_5__.MatHeaderRow, _angular_material_table__WEBPACK_IMPORTED_MODULE_5__.MatRow, _angular_material_button__WEBPACK_IMPORTED_MODULE_10__.MatIconButton, _angular_material_button__WEBPACK_IMPORTED_MODULE_10__.MatMiniFabButton, _angular_material_menu__WEBPACK_IMPORTED_MODULE_11__.MatMenu, _angular_material_menu__WEBPACK_IMPORTED_MODULE_11__.MatMenuItem, _angular_material_menu__WEBPACK_IMPORTED_MODULE_11__.MatMenuTrigger, _angular_material_icon__WEBPACK_IMPORTED_MODULE_12__.MatIcon, _angular_material_paginator__WEBPACK_IMPORTED_MODULE_8__.MatPaginator],
    styles: [".btn[_ngcontent-%COMP%] {\n  display: flex;\n  justify-content: end;\n}\n\n.card[_ngcontent-%COMP%] {\n  padding: 2px;\n}\n\nmat-card-content[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: column;\n  justify-content: center;\n}\n\n.record-grid[_ngcontent-%COMP%] {\n  min-height: 80%;\n  max-height: -moz-fit-content;\n  max-height: fit-content;\n}\n\nmat-form-field[_ngcontent-%COMP%] {\n  display: block;\n  margin: 10px 0;\n}\n\n.header[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: row;\n  justify-content: space-between;\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInZhY2NpbmF0aW9uLXJlY29yZHMtbGlzdC5jb21wb25lbnQuc2NzcyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTtFQUNJLGFBQUE7RUFDQSxvQkFBQTtBQUNKOztBQUVBO0VBQ0ksWUFBQTtBQUNKOztBQUdBO0VBQ0ksYUFBQTtFQUNBLHNCQUFBO0VBQ0EsdUJBQUE7QUFBSjs7QUFJQTtFQUNJLGVBQUE7RUFDQSw0QkFBQTtFQUFBLHVCQUFBO0FBREo7O0FBS0E7RUFDSSxjQUFBO0VBQ0EsY0FBQTtBQUZKOztBQUtBO0VBQ0ksYUFBQTtFQUNBLG1CQUFBO0VBQ0EsOEJBQUE7QUFGSiIsImZpbGUiOiJ2YWNjaW5hdGlvbi1yZWNvcmRzLWxpc3QuY29tcG9uZW50LnNjc3MiLCJzb3VyY2VzQ29udGVudCI6WyIuYnRuIHtcbiAgICBkaXNwbGF5OiBmbGV4O1xuICAgIGp1c3RpZnktY29udGVudDogZW5kO1xufVxuXG4uY2FyZCB7XG4gICAgcGFkZGluZzogMnB4O1xuIFxufVxuXG5tYXQtY2FyZC1jb250ZW50IHtcbiAgICBkaXNwbGF5OiBmbGV4O1xuICAgIGZsZXgtZGlyZWN0aW9uOiBjb2x1bW47XG4gICAganVzdGlmeS1jb250ZW50OiBjZW50ZXI7XG4gICAgLy8gYWxpZ24taXRlbXM6IGNlbnRlcjtcblxufVxuLnJlY29yZC1ncmlke1xuICAgIG1pbi1oZWlnaHQ6IDgwJTtcbiAgICBtYXgtaGVpZ2h0OiBmaXQtY29udGVudDtcbn1cblxuXG5tYXQtZm9ybS1maWVsZCB7XG4gICAgZGlzcGxheTogYmxvY2s7XG4gICAgbWFyZ2luOiAxMHB4IDA7XG59XG5cbi5oZWFkZXIge1xuICAgIGRpc3BsYXk6IGZsZXg7XG4gICAgZmxleC1kaXJlY3Rpb246IHJvdztcbiAgICBqdXN0aWZ5LWNvbnRlbnQ6IHNwYWNlLWJldHdlZW47XG59Il19 */\n/*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8uL3NyYy9hcHAvbW9kdWxlcy91c2VyLW1hbmFlbWVudC9tZWRpY2FsLXJlY29yZHMvdmFjY2luYXRpb24tcmVjb3Jkcy1saXN0L3ZhY2NpbmF0aW9uLXJlY29yZHMtbGlzdC5jb21wb25lbnQuc2NzcyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTtFQUNJLGFBQUE7RUFDQSxvQkFBQTtBQUNKOztBQUVBO0VBQ0ksWUFBQTtBQUNKOztBQUdBO0VBQ0ksYUFBQTtFQUNBLHNCQUFBO0VBQ0EsdUJBQUE7QUFBSjs7QUFJQTtFQUNJLGVBQUE7RUFDQSw0QkFBQTtFQUFBLHVCQUFBO0FBREo7O0FBS0E7RUFDSSxjQUFBO0VBQ0EsY0FBQTtBQUZKOztBQUtBO0VBQ0ksYUFBQTtFQUNBLG1CQUFBO0VBQ0EsOEJBQUE7QUFGSjtBQUVBLGdwQ0FBZ3BDIiwic291cmNlc0NvbnRlbnQiOlsiLmJ0biB7XG4gICAgZGlzcGxheTogZmxleDtcbiAgICBqdXN0aWZ5LWNvbnRlbnQ6IGVuZDtcbn1cblxuLmNhcmQge1xuICAgIHBhZGRpbmc6IDJweDtcbiBcbn1cblxubWF0LWNhcmQtY29udGVudCB7XG4gICAgZGlzcGxheTogZmxleDtcbiAgICBmbGV4LWRpcmVjdGlvbjogY29sdW1uO1xuICAgIGp1c3RpZnktY29udGVudDogY2VudGVyO1xuICAgIC8vIGFsaWduLWl0ZW1zOiBjZW50ZXI7XG5cbn1cbi5yZWNvcmQtZ3JpZHtcbiAgICBtaW4taGVpZ2h0OiA4MCU7XG4gICAgbWF4LWhlaWdodDogZml0LWNvbnRlbnQ7XG59XG5cblxubWF0LWZvcm0tZmllbGQge1xuICAgIGRpc3BsYXk6IGJsb2NrO1xuICAgIG1hcmdpbjogMTBweCAwO1xufVxuXG4uaGVhZGVyIHtcbiAgICBkaXNwbGF5OiBmbGV4O1xuICAgIGZsZXgtZGlyZWN0aW9uOiByb3c7XG4gICAganVzdGlmeS1jb250ZW50OiBzcGFjZS1iZXR3ZWVuO1xufSJdLCJzb3VyY2VSb290IjoiIn0= */"]
  });
}


/***/ }),

/***/ 91290:
/*!*************************************************************************************!*\
  !*** ./src/app/modules/user-manaement/medicle-records/medicle-records.component.ts ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "MedicleRecordsComponent": () => (/* binding */ MedicleRecordsComponent)
/* harmony export */ });
/* harmony import */ var _medical_records_vaccination_records_list_vaccination_records_list_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../medical-records/vaccination-records-list/vaccination-records-list.component */ 74966);
/* harmony import */ var _medical_records_allergy_records_list_allergy_records_list_component__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../medical-records/allergy-records-list/allergy-records-list.component */ 78606);
/* harmony import */ var _medical_records_deworming_list_deworming_list_component__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../medical-records/deworming-list/deworming-list.component */ 97477);
/* harmony import */ var _medical_records_prescriptions_list_prescriptions_list_component__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../medical-records/prescriptions-list/prescriptions-list.component */ 82881);
/* harmony import */ var _medical_records_lab_records_list_lab_records_list_component__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../medical-records/lab-records-list/lab-records-list.component */ 7129);
/* harmony import */ var _medical_records_diatry_plan_list_diatry_plan_list_component__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../medical-records/diatry-plan-list/diatry-plan-list.component */ 20336);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/core */ 86839);
/* harmony import */ var _angular_material_dialog__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @angular/material/dialog */ 67486);
/* harmony import */ var app_services_pet_service__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! app/services/pet.service */ 59976);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @angular/common */ 86477);
/* harmony import */ var _angular_material_grid_list__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @angular/material/grid-list */ 93574);











function MedicleRecordsComponent_mat_grid_tile_1_Template(rf, ctx) {
  if (rf & 1) {
    const _r3 = _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementStart"](0, "mat-grid-tile")(1, "mat-button", 2);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵlistener"]("click", function MedicleRecordsComponent_mat_grid_tile_1_Template_mat_button_click_1_listener() {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵrestoreView"](_r3);
      const item_r1 = restoredCtx.$implicit;
      const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵresetView"](ctx_r2.addRecord(item_r1));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelement"](2, "img", 3);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵtext"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementEnd"]()();
  }
  if (rf & 2) {
    const item_r1 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵproperty"]("src", item_r1.icon, _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵsanitizeUrl"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵtextInterpolate1"](" ", item_r1.title, " ");
  }
}
class MedicleRecordsComponent {
  constructor(dialog, petService) {
    this.dialog = dialog;
    this.petService = petService;
    this.items = petService.medicalRecordData;
  }
  ngOnInit() {
    this.petService.isViewed(sessionStorage.getItem('petId'), 'MEDICAL_RECORD').subscribe(res => {
      console.log(res);
      if (res['vaccinationRecord']) {
        this.items[0]['icon'] = './assets/icons/pet-history/vaccination rec.svg';
      }
      if (res["priscription"]) {
        this.items[3]['icon'] = './assets/icons/pet-history/prescriptions.svg';
      }
      if (res["labRecord"]) {
        this.items[1]['icon'] = './assets/icons/pet-history/lab rec.svg';
      }
      if (res["DietPlan"]) {
        this.items[5]['icon'] = './assets/icons/pet-history/diets.svg';
      }
      if (res["deworming"]) {
        this.items[2]['icon'] = './assets/icons/pet-history/deworming.svg';
      }
      if (res["allergyRecord"]) {
        this.items[4]['icon'] = './assets/icons/pet-history/allergy.svg';
      }
    });
  }
  // AddRecordsComponent
  addRecord(item) {
    let component;
    let width = '700px';
    if (item.title == 'Vaccination') {
      component = _medical_records_vaccination_records_list_vaccination_records_list_component__WEBPACK_IMPORTED_MODULE_0__.VaccinationRecordsListComponent;
    } else if (item.title == 'Lab Records') {
      width = '700px';
      component = _medical_records_lab_records_list_lab_records_list_component__WEBPACK_IMPORTED_MODULE_4__.LabRecordsListComponent;
    } else if (item.title == 'Deworming') {
      component = _medical_records_deworming_list_deworming_list_component__WEBPACK_IMPORTED_MODULE_2__.DewormingListComponent;
    } else if (item.title == 'Prescriptions') {
      component = _medical_records_prescriptions_list_prescriptions_list_component__WEBPACK_IMPORTED_MODULE_3__.PrescriptionsListComponent;
    } else if (item.title == 'Allergy Records') {
      component = _medical_records_allergy_records_list_allergy_records_list_component__WEBPACK_IMPORTED_MODULE_1__.AllergyRecordsListComponent;
    } else if (item.title == 'Dietary Plan') {
      width = '700px';
      component = _medical_records_diatry_plan_list_diatry_plan_list_component__WEBPACK_IMPORTED_MODULE_5__.DiatryPlanListComponent;
    }
    // item.title == 'Vaccination' ? VaccinationRecordsListComponent :
    //   item.title == 'Lab Records' ? LabRecordsListComponent :
    //     item.title == 'Deworming' ? DewormingListComponent :
    //       item.title == 'Prescriptions' ? PrescriptionsListComponent :
    //         item.title == 'Allergy Records' ? AllergyRecordsListComponent :
    //           item.title == 'Dietary Plan' ? DiatryPlanListComponent : VaccinationRecordsListComponent
    const dialogRef = this.dialog.open(component, {
      width: width,
      height: 'fit-content',
      data: item
    });
    dialogRef.afterClosed().subscribe(result => {
      console.log('The dialog was closed');
      console.log(result);
    });
  }
  static #_ = this.ɵfac = function MedicleRecordsComponent_Factory(t) {
    return new (t || MedicleRecordsComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵdirectiveInject"](_angular_material_dialog__WEBPACK_IMPORTED_MODULE_8__.MatDialog), _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵdirectiveInject"](app_services_pet_service__WEBPACK_IMPORTED_MODULE_6__.PetService));
  };
  static #_2 = this.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵdefineComponent"]({
    type: MedicleRecordsComponent,
    selectors: [["app-medicle-records"]],
    decls: 2,
    vars: 1,
    consts: [["cols", "4", "rowHeight", "2:1", "gutterSize", "8px"], [4, "ngFor", "ngForOf"], [3, "click"], ["alt", "Logo image", 2, "width", "50px", "height", "50px", 3, "src"]],
    template: function MedicleRecordsComponent_Template(rf, ctx) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementStart"](0, "mat-grid-list", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵtemplate"](1, MedicleRecordsComponent_mat_grid_tile_1_Template, 4, 2, "mat-grid-tile", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵelementEnd"]();
      }
      if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_7__["ɵɵproperty"]("ngForOf", ctx.items);
      }
    },
    dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_9__.NgForOf, _angular_material_grid_list__WEBPACK_IMPORTED_MODULE_10__.MatGridList, _angular_material_grid_list__WEBPACK_IMPORTED_MODULE_10__.MatGridTile],
    styles: [".card[_ngcontent-%COMP%] {\n  text-align: center;\n  padding: 20px;\n}\n\nmat-icon[_ngcontent-%COMP%] {\n  font-size: 48px;\n  display: block;\n  margin-bottom: 10px;\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIm1lZGljbGUtcmVjb3Jkcy5jb21wb25lbnQuc2NzcyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTtFQUNJLGtCQUFBO0VBQ0EsYUFBQTtBQUNKOztBQUVFO0VBQ0UsZUFBQTtFQUNBLGNBQUE7RUFDQSxtQkFBQTtBQUNKIiwiZmlsZSI6Im1lZGljbGUtcmVjb3Jkcy5jb21wb25lbnQuc2NzcyIsInNvdXJjZXNDb250ZW50IjpbIi5jYXJkIHtcbiAgICB0ZXh0LWFsaWduOiBjZW50ZXI7XG4gICAgcGFkZGluZzogMjBweDtcbiAgfVxuICBcbiAgbWF0LWljb24ge1xuICAgIGZvbnQtc2l6ZTogNDhweDtcbiAgICBkaXNwbGF5OiBibG9jaztcbiAgICBtYXJnaW4tYm90dG9tOiAxMHB4O1xuICB9XG4gICJdfQ== */\n/*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8uL3NyYy9hcHAvbW9kdWxlcy91c2VyLW1hbmFlbWVudC9tZWRpY2xlLXJlY29yZHMvbWVkaWNsZS1yZWNvcmRzLmNvbXBvbmVudC5zY3NzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBO0VBQ0ksa0JBQUE7RUFDQSxhQUFBO0FBQ0o7O0FBRUU7RUFDRSxlQUFBO0VBQ0EsY0FBQTtFQUNBLG1CQUFBO0FBQ0o7QUFDQSxvaUJBQW9pQiIsInNvdXJjZXNDb250ZW50IjpbIi5jYXJkIHtcbiAgICB0ZXh0LWFsaWduOiBjZW50ZXI7XG4gICAgcGFkZGluZzogMjBweDtcbiAgfVxuICBcbiAgbWF0LWljb24ge1xuICAgIGZvbnQtc2l6ZTogNDhweDtcbiAgICBkaXNwbGF5OiBibG9jaztcbiAgICBtYXJnaW4tYm90dG9tOiAxMHB4O1xuICB9XG4gICJdLCJzb3VyY2VSb290IjoiIn0= */"]
  });
}


/***/ }),

/***/ 42075:
/*!***********************************************************************!*\
  !*** ./src/app/modules/user-manaement/pet-docs/pet-docs.component.ts ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "PetDocsComponent": () => (/* binding */ PetDocsComponent)
/* harmony export */ });
/* harmony import */ var _document_details_document_details_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../document-details/document-details.component */ 56861);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 86839);
/* harmony import */ var _angular_material_dialog__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/material/dialog */ 67486);
/* harmony import */ var app_services_pet_service__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! app/services/pet.service */ 59976);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/common */ 86477);
/* harmony import */ var _angular_material_grid_list__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/material/grid-list */ 93574);






function PetDocsComponent_mat_grid_tile_1_Template(rf, ctx) {
  if (rf & 1) {
    const _r3 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](0, "mat-grid-tile")(1, "mat-button", 2);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵlistener"]("click", function PetDocsComponent_mat_grid_tile_1_Template_mat_button_click_1_listener() {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵrestoreView"](_r3);
      const item_r1 = restoredCtx.$implicit;
      const ctx_r2 = _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵresetView"](ctx_r2.documentView(item_r1));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelement"](2, "img", 3);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtext"](3);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]()();
  }
  if (rf & 2) {
    const item_r1 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](2);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("src", item_r1.icon, _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵsanitizeUrl"]);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtextInterpolate1"](" ", item_r1.title, " ");
  }
}
class PetDocsComponent {
  // [
  //   { title: 'Microchip ID', icon: './assets/icons/pet-history/MicrochipID.svg' },
  //   { title: 'Pet Passport', icon: './assets/icons/pet-history/passport.svg' },
  //   { title: 'Pet Insurance', icon: './assets/icons/pet-history/insurance.svg' },//insurance
  //   { title: 'Neuter Record', icon: './assets/icons/pet-history/insurance.svg' },
  //   { title: 'Pet Registration', icon: './assets/icons/pet-history/insurance.svg' },
  //   { title: 'Birth Certificate', icon: './assets/icons/pet-history/insurance.svg' },
  //   { title: 'Adoption Certificate', icon: './assets/icons/pet-history/insurance.svg' },
  //   { title: 'Relocation Certificate', icon: './assets/icons/pet-history/insurance.svg' },
  //   { title: 'Travel Documents', icon: './assets/icons/pet-history/insurance.svg' },
  //   { title: 'KCI Certificate', icon: './assets/icons/pet-history/insurance.svg' },
  //   { title: 'Other Documents', icon: './assets/icons/pet-history/insurance.svg' }
  // ];
  constructor(dialog, petService) {
    this.dialog = dialog;
    this.petService = petService;
    this.items = petService.petDocsTemplateData;
  }
  ngOnInit() {
    this.petService.isViewed(sessionStorage.getItem('petId'), 'DOCUMENT').subscribe(res => {
      console.log(res);
      if (res['MicrochipID']) {
        this.items[0]['icon'] = './assets/icons/pet-history/Microchip.svg';
      }
      if (res["PetInsurance"]) {
        this.items[2]['icon'] = './assets/icons/pet-history/Insurance.svg';
      }
      if (res["NeuterRecord"]) {
        this.items[3]['icon'] = './assets/icons/pet-history/Neuter.svg';
      }
      if (res["PetRegistration"]) {
        this.items[4]['icon'] = './assets/icons/pet-history/registration.svg';
      }
      if (res["KCI_Certificate"]) {
        this.items[9]['icon'] = './assets/icons/pet-history/KCI.svg';
      }
      if (res["BirthCertificate"]) {
        this.items[5]['icon'] = './assets/icons/pet-history/birth.svg';
      }
      if (res["TravelDocument"]) {
        this.items[8]['icon'] = './assets/icons/pet-history/travel docs.svg';
      }
      if (res["OtherDocuments"]) {
        this.items[10]['icon'] = './assets/icons/pet-history/Others.svg';
      }
      if (res["AdoptionCertificate"]) {
        this.items[6]['icon'] = './assets/icons/pet-history/adoption.svg';
      }
      if (res["Relocation_Certificate"] || res['RelocationCertificate-Details']) {
        this.items[7]['icon'] = './assets/icons/pet-history/relocation.svg';
      }
      if (res['PetPassport']) {
        this.items[1]['icon'] = './assets/icons/pet-history/Passport.svg';
      }
    });
  }
  documentView(item) {
    const dialogRef = this.dialog.open(_document_details_document_details_component__WEBPACK_IMPORTED_MODULE_0__.DocumentDetailsComponent, {
      data: item
    });
    dialogRef.afterClosed().subscribe(result => {
      console.log('The dialog was closed');
      console.log(result);
    });
  }
  static #_ = this.ɵfac = function PetDocsComponent_Factory(t) {
    return new (t || PetDocsComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdirectiveInject"](_angular_material_dialog__WEBPACK_IMPORTED_MODULE_3__.MatDialog), _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdirectiveInject"](app_services_pet_service__WEBPACK_IMPORTED_MODULE_1__.PetService));
  };
  static #_2 = this.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdefineComponent"]({
    type: PetDocsComponent,
    selectors: [["app-pet-docs"]],
    inputs: {
      petId: "petId",
      petParentId: "petParentId"
    },
    decls: 2,
    vars: 1,
    consts: [["cols", "5", "rowHeight", "2:1.5", "gutterSize", "16px"], [4, "ngFor", "ngForOf"], [3, "click"], ["alt", "Logo image", 2, "width", "50px", "height", "50px", 3, "src"]],
    template: function PetDocsComponent_Template(rf, ctx) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementStart"](0, "mat-grid-list", 0);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵtemplate"](1, PetDocsComponent_mat_grid_tile_1_Template, 4, 2, "mat-grid-tile", 1);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵelementEnd"]();
      }
      if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵproperty"]("ngForOf", ctx.items);
      }
    },
    dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_4__.NgForOf, _angular_material_grid_list__WEBPACK_IMPORTED_MODULE_5__.MatGridList, _angular_material_grid_list__WEBPACK_IMPORTED_MODULE_5__.MatGridTile],
    styles: [".card[_ngcontent-%COMP%] {\n  text-align: center;\n  padding: 20px;\n}\n\nmat-icon[_ngcontent-%COMP%] {\n  font-size: 48px;\n  display: block;\n  margin-bottom: 10px;\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInBldC1kb2NzLmNvbXBvbmVudC5zY3NzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBO0VBQ0ksa0JBQUE7RUFDQSxhQUFBO0FBQ0o7O0FBRUU7RUFDRSxlQUFBO0VBQ0EsY0FBQTtFQUNBLG1CQUFBO0FBQ0oiLCJmaWxlIjoicGV0LWRvY3MuY29tcG9uZW50LnNjc3MiLCJzb3VyY2VzQ29udGVudCI6WyIuY2FyZCB7XG4gICAgdGV4dC1hbGlnbjogY2VudGVyO1xuICAgIHBhZGRpbmc6IDIwcHg7XG4gIH1cbiAgXG4gIG1hdC1pY29uIHtcbiAgICBmb250LXNpemU6IDQ4cHg7XG4gICAgZGlzcGxheTogYmxvY2s7XG4gICAgbWFyZ2luLWJvdHRvbTogMTBweDtcbiAgfVxuICAiXX0= */\n/*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8uL3NyYy9hcHAvbW9kdWxlcy91c2VyLW1hbmFlbWVudC9wZXQtZG9jcy9wZXQtZG9jcy5jb21wb25lbnQuc2NzcyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTtFQUNJLGtCQUFBO0VBQ0EsYUFBQTtBQUNKOztBQUVFO0VBQ0UsZUFBQTtFQUNBLGNBQUE7RUFDQSxtQkFBQTtBQUNKO0FBQ0EsZ2hCQUFnaEIiLCJzb3VyY2VzQ29udGVudCI6WyIuY2FyZCB7XG4gICAgdGV4dC1hbGlnbjogY2VudGVyO1xuICAgIHBhZGRpbmc6IDIwcHg7XG4gIH1cbiAgXG4gIG1hdC1pY29uIHtcbiAgICBmb250LXNpemU6IDQ4cHg7XG4gICAgZGlzcGxheTogYmxvY2s7XG4gICAgbWFyZ2luLWJvdHRvbTogMTBweDtcbiAgfVxuICAiXSwic291cmNlUm9vdCI6IiJ9 */"]
  });
}


/***/ }),

/***/ 30994:
/*!***************************************************************************!*\
  !*** ./src/app/modules/user-manaement/pet-parent/pet-parent.component.ts ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "PetParentComponent": () => (/* binding */ PetParentComponent)
/* harmony export */ });
/* harmony import */ var _angular_material_menu__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! @angular/material/menu */ 89314);
/* harmony import */ var _angular_material_table__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @angular/material/table */ 83348);
/* harmony import */ var _angular_material_paginator__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! @angular/material/paginator */ 86907);
/* harmony import */ var _angular_material_sort__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! @angular/material/sort */ 95096);
/* harmony import */ var file_saver__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! file-saver */ 65226);
/* harmony import */ var file_saver__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(file_saver__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! moment */ 56908);
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(moment__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var app_components_controllers_success_dialog_success_dialog_component__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! app/components/controllers/success-dialog/success-dialog.component */ 92814);
/* harmony import */ var app_components_controllers_confirmation_dialog_confirmation_dialog_component__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! app/components/controllers/confirmation-dialog/confirmation-dialog.component */ 81500);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @angular/core */ 86839);
/* harmony import */ var app_services_user_management_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! app/services/user-management.service */ 32555);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @angular/router */ 86679);
/* harmony import */ var _angular_material_snack_bar__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @angular/material/snack-bar */ 88511);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @angular/forms */ 69542);
/* harmony import */ var _angular_material_dialog__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @angular/material/dialog */ 67486);
/* harmony import */ var app_services_loader_service__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! app/services/loader.service */ 38555);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! @angular/common */ 86477);
/* harmony import */ var _components_common_components_generic_actions_generic_actions_component__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../components/common-components/generic-actions/generic-actions.component */ 90823);
/* harmony import */ var _angular_material_button__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! @angular/material/button */ 83677);
/* harmony import */ var _angular_material_icon__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! @angular/material/icon */ 69941);
/* harmony import */ var _angular_material_sidenav__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! @angular/material/sidenav */ 79101);
/* harmony import */ var _angular_material_slide_toggle__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! @angular/material/slide-toggle */ 4291);
/* harmony import */ var _angular_material_checkbox__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! @angular/material/checkbox */ 7672);
/* harmony import */ var _add_user_add_user_component__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../add-user/add-user.component */ 47820);
/* harmony import */ var _add_pet_add_pet_component__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../add-pet/add-pet.component */ 59932);



























const _c0 = ["sidenav"];
function PetParentComponent_th_25_Template(rf, ctx) {
  if (rf & 1) {
    const _r25 = _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementStart"](0, "th", 33)(1, "mat-checkbox", 34);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵlistener"]("change", function PetParentComponent_th_25_Template_mat_checkbox_change_1_listener($event) {
      _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵrestoreView"](_r25);
      const ctx_r24 = _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵresetView"](ctx_r24.selectAll($event));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementEnd"]()();
  }
}
function PetParentComponent_td_26_Template(rf, ctx) {
  if (rf & 1) {
    const _r28 = _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementStart"](0, "td", 35)(1, "mat-checkbox", 36);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵlistener"]("ngModelChange", function PetParentComponent_td_26_Template_mat_checkbox_ngModelChange_1_listener($event) {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵrestoreView"](_r28);
      const element_r26 = restoredCtx.$implicit;
      return _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵresetView"](element_r26.selected = $event);
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementEnd"]()();
  }
  if (rf & 2) {
    const element_r26 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵproperty"]("ngModel", element_r26.selected);
  }
}
function PetParentComponent_th_28_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementStart"](0, "th", 33);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵtext"](1, " ID. ");
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementEnd"]();
  }
}
function PetParentComponent_td_29_Template(rf, ctx) {
  if (rf & 1) {
    const _r31 = _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementStart"](0, "td", 37);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵlistener"]("click", function PetParentComponent_td_29_Template_td_click_0_listener() {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵrestoreView"](_r31);
      const element_r29 = restoredCtx.$implicit;
      const ctx_r30 = _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵresetView"](ctx_r30.copyToClipboard(element_r29.id));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const element_r29 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵtextInterpolate1"](" ", element_r29.id.substring(0, 6), " ");
  }
}
function PetParentComponent_th_31_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementStart"](0, "th", 33);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵtext"](1, " Name ");
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementEnd"]();
  }
}
function PetParentComponent_td_32_Template(rf, ctx) {
  if (rf & 1) {
    const _r34 = _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementStart"](0, "td", 37);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵlistener"]("click", function PetParentComponent_td_32_Template_td_click_0_listener() {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵrestoreView"](_r34);
      const element_r32 = restoredCtx.$implicit;
      const ctx_r33 = _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵresetView"](ctx_r33.clickName(element_r32));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const element_r32 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵtextInterpolate1"](" ", element_r32.name, " ");
  }
}
function PetParentComponent_th_34_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementStart"](0, "th", 33);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵtext"](1, " Mobile ");
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementEnd"]();
  }
}
function PetParentComponent_td_35_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementStart"](0, "td", 35);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const element_r35 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵtextInterpolate1"](" ", element_r35.mobile, " ");
  }
}
function PetParentComponent_th_37_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementStart"](0, "th", 33);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵtext"](1, " City ");
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementEnd"]();
  }
}
function PetParentComponent_td_38_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementStart"](0, "td", 35);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const element_r36 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵtextInterpolate1"](" ", element_r36.city, " ");
  }
}
function PetParentComponent_th_40_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementStart"](0, "th", 33);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵtext"](1, " Created ");
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementEnd"]();
  }
}
function PetParentComponent_td_41_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementStart"](0, "td", 35);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const element_r37 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵtextInterpolate1"](" ", element_r37.joinedDate, " ");
  }
}
function PetParentComponent_th_43_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementStart"](0, "th", 33);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵtext"](1, " Email ");
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementEnd"]();
  }
}
function PetParentComponent_td_44_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementStart"](0, "td", 35);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const element_r38 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵtextInterpolate1"](" ", element_r38.email, " ");
  }
}
function PetParentComponent_th_46_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementStart"](0, "th", 33);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵtext"](1, "Test");
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementEnd"]();
  }
}
function PetParentComponent_td_47_Template(rf, ctx) {
  if (rf & 1) {
    const _r41 = _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementStart"](0, "td", 35)(1, "mat-slide-toggle", 38);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵlistener"]("change", function PetParentComponent_td_47_Template_mat_slide_toggle_change_1_listener($event) {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵrestoreView"](_r41);
      const element_r39 = restoredCtx.$implicit;
      const ctx_r40 = _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵresetView"](ctx_r40.testChange($event, element_r39));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementEnd"]()();
  }
  if (rf & 2) {
    const element_r39 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵproperty"]("checked", element_r39.test === true);
  }
}
function PetParentComponent_th_49_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementStart"](0, "th", 33);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵtext"](1, " Action ");
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementEnd"]();
  }
}
function PetParentComponent_td_50_Template(rf, ctx) {
  if (rf & 1) {
    const _r45 = _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementStart"](0, "td", 35)(1, "button", 39);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵlistener"]("click", function PetParentComponent_td_50_Template_button_click_1_listener() {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵrestoreView"](_r45);
      const i_r43 = restoredCtx.index;
      const element_r42 = restoredCtx.$implicit;
      const ctx_r44 = _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵresetView"](ctx_r44.toggle(i_r43, element_r42));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementStart"](2, "mat-icon");
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵtext"](3, "more_vert");
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementEnd"]()()();
  }
  if (rf & 2) {
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵnextContext"]();
    const _r0 = _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵreference"](6);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵproperty"]("matMenuTriggerFor", _r0);
  }
}
function PetParentComponent_tr_51_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelement"](0, "tr", 40);
  }
}
function PetParentComponent_tr_52_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelement"](0, "tr", 41);
  }
}
function PetParentComponent_app_add_user_56_Template(rf, ctx) {
  if (rf & 1) {
    const _r49 = _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementStart"](0, "app-add-user", 42);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵlistener"]("cancelEvent", function PetParentComponent_app_add_user_56_Template_app_add_user_cancelEvent_0_listener() {
      _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵrestoreView"](_r49);
      const ctx_r48 = _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵresetView"](ctx_r48.cancel());
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const ctx_r22 = _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵproperty"]("editData", ctx_r22.row);
  }
}
function PetParentComponent_app_add_pet_57_Template(rf, ctx) {
  if (rf & 1) {
    const _r51 = _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementStart"](0, "app-add-pet", 43);
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵlistener"]("cancelEvent", function PetParentComponent_app_add_pet_57_Template_app_add_pet_cancelEvent_0_listener() {
      _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵrestoreView"](_r51);
      const ctx_r50 = _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵresetView"](ctx_r50.cancel());
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const ctx_r23 = _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵproperty"]("petParentId", ctx_r23.petParentId);
  }
}
const _c1 = function () {
  return [5, 10, 25, 100];
};
class PetParentComponent {
  applyFilter() {
    this.petParents.filter = this.searchTerm.trim().toLowerCase();
  }
  constructor(userManagementService, route, router, snackBar, fb, dialog, loader, _snackBar) {
    this.userManagementService = userManagementService;
    this.route = route;
    this.router = router;
    this.snackBar = snackBar;
    this.fb = fb;
    this.dialog = dialog;
    this.loader = loader;
    this._snackBar = _snackBar;
    this.selectedRows = [];
    this.showFiller = false;
    this.isaddPet = false;
    this.petParentId = "";
    this.resultsLength = 0;
    this.isLoadingResults = true;
    this.isRateLimitReached = false;
    this.displayedColumns = ['selector', 'id', 'name', 'mobile', 'city', 'joinedDate', 'email', 'test', 'action'];
    this.searchTerm = '';
    this.isViewMode = false;
    this.getPetParent();
  }
  ngOnInit() {
    this.userManagementService.closeSidenav$.subscribe(() => {
      this.sidenav.toggle();
    });
  }
  ngAfterViewInit() {
    this.petParents.paginator = this.paginator;
  }
  exportToCSV() {
    const selectedData = this.petParents.data.filter(item => item.selected); // Get only selected rows
    if (selectedData.length === 0) {
      this.showErrorToast('No rows selected!');
      return;
    }
    const csvData = selectedData.map(item => ({
      id: item.id,
      name: item.name,
      mobile: item.mobile,
      city: item.city,
      joinedDate: item.joinedDate,
      email: item.email
    }));
    const csvContent = this.convertToCSV(csvData);
    const blob = new Blob([csvContent], {
      type: 'text/csv;charset=utf-8'
    });
    (0,file_saver__WEBPACK_IMPORTED_MODULE_0__.saveAs)(blob, 'petParents.csv');
  }
  convertToCSV(data) {
    const header = Object.keys(data[0]).join(',');
    const rows = data.map(item => Object.values(item).join(','));
    return `${header}\n${rows.join('\n')}`;
  }
  selectAll(event) {
    const checked = event.checked;
    this.petParents.data.forEach(item => {
      item.selected = checked;
    });
  }
  toggle(row, element) {
    // drawer.toggle()
    this.selectedRow = element;
    this.index = row;
  }
  openSnackBar(message) {
    this._snackBar.open(message, 'Close', {
      duration: 2000
    });
  }
  copyToClipboard(text) {
    navigator.clipboard.writeText(text).then(() => {
      this.openSnackBar('Copied!');
    }).catch(err => {
      console.error('Failed to copy text: ', err);
    });
  }
  testChange(event, element) {
    this.loader.showLoader();
    this.userManagementService.testChange(event['checked'] ? 'Active' : 'InActive', event['checked'], element['id']).subscribe(res => {
      this.loader.hideLoader();
      this.showSuccessToast('Successfully Done');
    }, error => {
      this.loader.hideLoader();
      this.showErrorToast('Failed ...');
    });
  }
  getPetParent() {
    console.log("##");
    this.loader.showLoader();
    this.userManagementService.getPetParents(1).subscribe(res => {
      this.loader.hideLoader();
      res.forEach(el => {
        el['joinedDate'] = moment__WEBPACK_IMPORTED_MODULE_1___default().utc(el['joinedDate']).local().format("DD-MMM-YYYY");
        // console.log(el['name']);
        el['name'] = el['name'] ? el['name'].split(' ').map(word => word.charAt(0).toUpperCase() + word.slice(1).toLowerCase()).join(' ') : '';
        el['city'] = el['city'] ? el['city'][0].toUpperCase() + el['city'].slice(1).toLowerCase() : '';
        // .capitalize()
      });
      this.data = res;
      const petParentsArray = Object.values(res);
      this.petParents = new _angular_material_table__WEBPACK_IMPORTED_MODULE_10__.MatTableDataSource(petParentsArray.map(item => ({
        ...item
      })));
      this.petParents.paginator = this.paginator;
      this.petParents.sort = this.sort;
      this.petParents.filterPredicate = this.createFilter();
    });
  }
  createFilter() {
    let filterFunction = function (data, filter) {
      const searchTerms = filter.split(' ').map(term => term.toLowerCase());
      for (const searchTerm of searchTerms) {
        if (data.name.toLowerCase().indexOf(searchTerm) !== -1 || data.id.toLowerCase().indexOf(searchTerm) !== -1 || data.mobile.toLowerCase().indexOf(searchTerm) !== -1) {
          return true;
        }
      }
      return false;
    };
    return filterFunction;
  }
  view() {
    this.viewData = this.selectedRow;
    this.showFiller = false;
    this.isViewMode = true;
    this.sidenav.toggle();
  }
  addUser() {
    // 'petParent/addUser'
    this.router.navigate(['/user/pet/addUser']);
  }
  editUser() {
    // console.log(element);
    this.row = this.selectedRow;
    this.showFiller = true;
    this.isaddPet = false;
    this.sidenav.toggle();
  }
  clickName(element) {
    console.log(element);
    this.row = this.selectedRow;
    this.row = element;
    this.showFiller = true;
    this.isaddPet = false;
    this.sidenav.toggle();
  }
  deleteUser() {
    const dialogRef = this.dialog.open(app_components_controllers_confirmation_dialog_confirmation_dialog_component__WEBPACK_IMPORTED_MODULE_3__.ConfirmationDialogComponent, {
      width: '400px',
      data: {
        message: 'Are you sure you want to Delete?'
      }
    });
    dialogRef.afterClosed().subscribe(result => {
      if (result) {
        // User confirmed action
        this.loader.showLoader();
        this.userManagementService.deletePetParent(this.selectedRow['id']).subscribe(res => {
          this.loader.hideLoader();
          this.getPetParent();
          const dialogRef = this.dialog.open(app_components_controllers_success_dialog_success_dialog_component__WEBPACK_IMPORTED_MODULE_2__.SuccessDialogComponent, {
            width: '300px',
            data: {
              message: 'Pet parent deleted successfully',
              success: true
            },
            panelClass: 'success-dialog-container'
          });
          this.menuTrigger.closeMenu();
        }, error => {
          this.loader.hideLoader();
          const dialogRef = this.dialog.open(app_components_controllers_success_dialog_success_dialog_component__WEBPACK_IMPORTED_MODULE_2__.SuccessDialogComponent, {
            width: '300px',
            data: {
              message: 'Something Went Wrong!',
              success: false
            }
          });
        });
      } else {
        // User cancelled action
        console.log('Cancelled');
        dialogRef.close();
      }
    });
  }
  addPet(evnet) {
    this.isaddPet = true;
    this.showFiller = false;
    this.petParentId = this.selectedRow['id'];
    this.sidenav.toggle();
  }
  getPets() {
    // if (this.editData) {
    this.loader.showLoader();
    this.userManagementService.getAllPetsByPetParent(this.petParentId).subscribe(res => {
      console.log(res);
      this.loader.hideLoader();
    });
    // }
  }
  cancel() {
    this.getPetParent();
    // this.getPets();
    this.sidenav.toggle();
  }
  filter(searchTerm) {
    this.searchTerm = searchTerm;
    this.applyFilter();
  }
  showSuccessToast(message) {
    this.snackBar.open(message, 'Close', {
      duration: 3000,
      panelClass: ['success-toast']
    });
  }
  showErrorToast(message) {
    this.snackBar.open(message, 'Close', {
      duration: 3000,
      panelClass: ['error-toast']
    });
  }
  static #_ = this.ɵfac = function PetParentComponent_Factory(t) {
    return new (t || PetParentComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵdirectiveInject"](app_services_user_management_service__WEBPACK_IMPORTED_MODULE_4__.UserManagementService), _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵdirectiveInject"](_angular_router__WEBPACK_IMPORTED_MODULE_11__.ActivatedRoute), _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵdirectiveInject"](_angular_router__WEBPACK_IMPORTED_MODULE_11__.Router), _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵdirectiveInject"](_angular_material_snack_bar__WEBPACK_IMPORTED_MODULE_12__.MatSnackBar), _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵdirectiveInject"](_angular_forms__WEBPACK_IMPORTED_MODULE_13__.FormBuilder), _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵdirectiveInject"](_angular_material_dialog__WEBPACK_IMPORTED_MODULE_14__.MatDialog), _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵdirectiveInject"](app_services_loader_service__WEBPACK_IMPORTED_MODULE_5__.LoaderService), _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵdirectiveInject"](_angular_material_snack_bar__WEBPACK_IMPORTED_MODULE_12__.MatSnackBar));
  };
  static #_2 = this.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵdefineComponent"]({
    type: PetParentComponent,
    selectors: [["app-pet-parent"]],
    viewQuery: function PetParentComponent_Query(rf, ctx) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵviewQuery"](_c0, 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵviewQuery"](_angular_material_paginator__WEBPACK_IMPORTED_MODULE_15__.MatPaginator, 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵviewQuery"](_angular_material_sort__WEBPACK_IMPORTED_MODULE_16__.MatSort, 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵviewQuery"](_angular_material_menu__WEBPACK_IMPORTED_MODULE_17__.MatMenuTrigger, 5);
      }
      if (rf & 2) {
        let _t;
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵloadQuery"]()) && (ctx.sidenav = _t.first);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵloadQuery"]()) && (ctx.paginator = _t.first);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵloadQuery"]()) && (ctx.sort = _t.first);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵloadQuery"]()) && (ctx.menuTrigger = _t.first);
      }
    },
    decls: 58,
    vars: 8,
    consts: [[1, "flex", "flex-col", "flex-auto", "min-w-0", "px-5", 2, "width", "100%", "overflow-y", "auto", "height", "calc(100vh - 70px)"], [1, "flex-auto"], ["autosize", "", 2, "width", "100%", "height", "100%"], [1, "action-wrapper"], ["actionName", "Pet Parent", 3, "filterEvent", "addEvent", "exportEvent"], ["actionMenu", "matMenu"], ["mat-menu-item", "", 3, "click"], [2, "color", "blue !important"], ["color", "primary"], [2, "color", "hsl(0, 94%, 42%) !important"], ["color", "warn"], [1, "table-wrapper"], ["mat-table", "", 1, "mat-elevation-z8", "mt-2", 3, "dataSource"], ["matColumnDef", "selector"], ["mat-header-cell", "", 4, "matHeaderCellDef"], ["mat-cell", "", 4, "matCellDef"], ["matColumnDef", "id"], ["mat-cell", "", "style", "cursor: pointer;", 3, "click", 4, "matCellDef"], ["matColumnDef", "name"], ["mat-cell", "", "style", "cursor:pointer", 3, "click", 4, "matCellDef"], ["matColumnDef", "mobile"], ["matColumnDef", "city"], ["matColumnDef", "joinedDate"], ["matColumnDef", "email"], ["matColumnDef", "test"], ["matColumnDef", "action"], ["mat-header-row", "", 4, "matHeaderRowDef"], ["mat-row", "", 4, "matRowDef", "matRowDefColumns"], [3, "pageSize", "pageSizeOptions"], ["mode", "over", "position", "end", 2, "width", "100%"], ["sidenav", ""], [3, "editData", "cancelEvent", 4, "ngIf"], [3, "petParentId", "cancelEvent", 4, "ngIf"], ["mat-header-cell", ""], [3, "change"], ["mat-cell", ""], [3, "ngModel", "ngModelChange"], ["mat-cell", "", 2, "cursor", "pointer", 3, "click"], [3, "checked", "change"], ["mat-icon-button", "", 3, "matMenuTriggerFor", "click"], ["mat-header-row", ""], ["mat-row", ""], [3, "editData", "cancelEvent"], [3, "petParentId", "cancelEvent"]],
    template: function PetParentComponent_Template(rf, ctx) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementStart"](0, "div", 0)(1, "div", 1)(2, "mat-drawer-container", 2)(3, "div", 3)(4, "app-generic-actions", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵlistener"]("filterEvent", function PetParentComponent_Template_app_generic_actions_filterEvent_4_listener($event) {
          return ctx.filter($event);
        })("addEvent", function PetParentComponent_Template_app_generic_actions_addEvent_4_listener() {
          return ctx.addUser();
        })("exportEvent", function PetParentComponent_Template_app_generic_actions_exportEvent_4_listener() {
          return ctx.exportToCSV();
        });
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementEnd"]()();
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementStart"](5, "mat-menu", null, 5)(7, "button", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵlistener"]("click", function PetParentComponent_Template_button_click_7_listener() {
          return ctx.addPet();
        });
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementStart"](8, "span", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵtext"](9, "Add Pet");
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementStart"](10, "mat-icon", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵtext"](11, "add");
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementEnd"]()();
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementStart"](12, "button", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵlistener"]("click", function PetParentComponent_Template_button_click_12_listener() {
          return ctx.editUser();
        });
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementStart"](13, "span", 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵtext"](14, "Edit");
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementStart"](15, "mat-icon", 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵtext"](16, "edit");
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementEnd"]()();
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementStart"](17, "button", 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵlistener"]("click", function PetParentComponent_Template_button_click_17_listener() {
          return ctx.deleteUser();
        });
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementStart"](18, "span", 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵtext"](19, "Delete");
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementStart"](20, "mat-icon", 10);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵtext"](21, "delete");
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementEnd"]()()();
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementStart"](22, "div", 11)(23, "table", 12);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementContainerStart"](24, 13);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵtemplate"](25, PetParentComponent_th_25_Template, 2, 0, "th", 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵtemplate"](26, PetParentComponent_td_26_Template, 2, 1, "td", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementContainerStart"](27, 16);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵtemplate"](28, PetParentComponent_th_28_Template, 2, 0, "th", 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵtemplate"](29, PetParentComponent_td_29_Template, 2, 1, "td", 17);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementContainerStart"](30, 18);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵtemplate"](31, PetParentComponent_th_31_Template, 2, 0, "th", 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵtemplate"](32, PetParentComponent_td_32_Template, 2, 1, "td", 19);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementContainerStart"](33, 20);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵtemplate"](34, PetParentComponent_th_34_Template, 2, 0, "th", 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵtemplate"](35, PetParentComponent_td_35_Template, 2, 1, "td", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementContainerStart"](36, 21);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵtemplate"](37, PetParentComponent_th_37_Template, 2, 0, "th", 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵtemplate"](38, PetParentComponent_td_38_Template, 2, 1, "td", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementContainerStart"](39, 22);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵtemplate"](40, PetParentComponent_th_40_Template, 2, 0, "th", 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵtemplate"](41, PetParentComponent_td_41_Template, 2, 1, "td", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementContainerStart"](42, 23);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵtemplate"](43, PetParentComponent_th_43_Template, 2, 0, "th", 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵtemplate"](44, PetParentComponent_td_44_Template, 2, 1, "td", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementContainerStart"](45, 24);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵtemplate"](46, PetParentComponent_th_46_Template, 2, 0, "th", 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵtemplate"](47, PetParentComponent_td_47_Template, 2, 1, "td", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementContainerStart"](48, 25);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵtemplate"](49, PetParentComponent_th_49_Template, 2, 0, "th", 14);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵtemplate"](50, PetParentComponent_td_50_Template, 4, 1, "td", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵtemplate"](51, PetParentComponent_tr_51_Template, 1, 0, "tr", 26);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵtemplate"](52, PetParentComponent_tr_52_Template, 1, 0, "tr", 27);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelement"](53, "mat-paginator", 28);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementEnd"]()()()();
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementStart"](54, "mat-drawer", 29, 30);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵtemplate"](56, PetParentComponent_app_add_user_56_Template, 1, 1, "app-add-user", 31);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵtemplate"](57, PetParentComponent_app_add_pet_57_Template, 1, 1, "app-add-pet", 32);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵelementEnd"]();
      }
      if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵadvance"](23);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵproperty"]("dataSource", ctx.petParents);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵadvance"](28);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵproperty"]("matHeaderRowDef", ctx.displayedColumns);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵproperty"]("matRowDefColumns", ctx.displayedColumns);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵproperty"]("pageSize", 10)("pageSizeOptions", _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵpureFunction0"](7, _c1));
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵadvance"](3);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵproperty"]("ngIf", ctx.showFiller);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_9__["ɵɵproperty"]("ngIf", ctx.isaddPet);
      }
    },
    dependencies: [_angular_common__WEBPACK_IMPORTED_MODULE_18__.NgIf, _angular_material_table__WEBPACK_IMPORTED_MODULE_10__.MatTable, _angular_material_table__WEBPACK_IMPORTED_MODULE_10__.MatHeaderCellDef, _angular_material_table__WEBPACK_IMPORTED_MODULE_10__.MatHeaderRowDef, _angular_material_table__WEBPACK_IMPORTED_MODULE_10__.MatColumnDef, _angular_material_table__WEBPACK_IMPORTED_MODULE_10__.MatCellDef, _angular_material_table__WEBPACK_IMPORTED_MODULE_10__.MatRowDef, _angular_material_table__WEBPACK_IMPORTED_MODULE_10__.MatHeaderCell, _angular_material_table__WEBPACK_IMPORTED_MODULE_10__.MatCell, _angular_material_table__WEBPACK_IMPORTED_MODULE_10__.MatHeaderRow, _angular_material_table__WEBPACK_IMPORTED_MODULE_10__.MatRow, _components_common_components_generic_actions_generic_actions_component__WEBPACK_IMPORTED_MODULE_6__.GenericActionsComponent, _angular_material_button__WEBPACK_IMPORTED_MODULE_19__.MatIconButton, _angular_forms__WEBPACK_IMPORTED_MODULE_13__.NgControlStatus, _angular_forms__WEBPACK_IMPORTED_MODULE_13__.NgModel, _angular_material_menu__WEBPACK_IMPORTED_MODULE_17__.MatMenu, _angular_material_menu__WEBPACK_IMPORTED_MODULE_17__.MatMenuItem, _angular_material_menu__WEBPACK_IMPORTED_MODULE_17__.MatMenuTrigger, _angular_material_icon__WEBPACK_IMPORTED_MODULE_20__.MatIcon, _angular_material_sidenav__WEBPACK_IMPORTED_MODULE_21__.MatDrawer, _angular_material_sidenav__WEBPACK_IMPORTED_MODULE_21__.MatDrawerContainer, _angular_material_slide_toggle__WEBPACK_IMPORTED_MODULE_22__.MatSlideToggle, _angular_material_paginator__WEBPACK_IMPORTED_MODULE_15__.MatPaginator, _angular_material_checkbox__WEBPACK_IMPORTED_MODULE_23__.MatCheckbox, _add_user_add_user_component__WEBPACK_IMPORTED_MODULE_7__.AddUserComponent, _add_pet_add_pet_component__WEBPACK_IMPORTED_MODULE_8__.AddPetComponent],
    styles: [".btn-wrapper[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: row;\n  justify-content: right;\n}\n\ntable[_ngcontent-%COMP%] {\n  width: 100%;\n}\n\n.action-wrapper[_ngcontent-%COMP%] {\n  width: 100%;\n}\n\n.table-wrapper[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: column;\n  width: 100%;\n  height: 90%;\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInBldC1wYXJlbnQuY29tcG9uZW50LnNjc3MiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7RUFDRSxhQUFBO0VBQ0EsbUJBQUE7RUFDQSxzQkFBQTtBQUNGOztBQUtBO0VBQ0UsV0FBQTtBQUZGOztBQUlBO0VBRUUsV0FBQTtBQUZGOztBQUtBO0VBQ0UsYUFBQTtFQUNBLHNCQUFBO0VBQ0EsV0FBQTtFQUNBLFdBQUE7QUFGRiIsImZpbGUiOiJwZXQtcGFyZW50LmNvbXBvbmVudC5zY3NzIiwic291cmNlc0NvbnRlbnQiOlsiLmJ0bi13cmFwcGVyIHtcbiAgZGlzcGxheTogZmxleDtcbiAgZmxleC1kaXJlY3Rpb246IHJvdztcbiAganVzdGlmeS1jb250ZW50OiByaWdodDtcbiAgLy8gYnV0dG9ue1xuICAvLyAgIG1hcmdpbjogMTBweDtcbiAgLy8gfVxufVxuXG50YWJsZSB7XG4gIHdpZHRoOiAxMDAlO1xufVxuLmFjdGlvbi13cmFwcGVye1xuICAvLyBkaXNwbGF5OiBmbGV4O1xuICB3aWR0aDogMTAwJTtcbiAgLy8gaGVpZ2h0OiA0LjUlO1xufVxuLnRhYmxlLXdyYXBwZXJ7XG4gIGRpc3BsYXk6IGZsZXg7XG4gIGZsZXgtZGlyZWN0aW9uOiBjb2x1bW47XG4gIHdpZHRoOiAxMDAlO1xuICBoZWlnaHQ6IDkwJTtcbn1cbiJdfQ== */\n/*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8uL3NyYy9hcHAvbW9kdWxlcy91c2VyLW1hbmFlbWVudC9wZXQtcGFyZW50L3BldC1wYXJlbnQuY29tcG9uZW50LnNjc3MiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7RUFDRSxhQUFBO0VBQ0EsbUJBQUE7RUFDQSxzQkFBQTtBQUNGOztBQUtBO0VBQ0UsV0FBQTtBQUZGOztBQUlBO0VBRUUsV0FBQTtBQUZGOztBQUtBO0VBQ0UsYUFBQTtFQUNBLHNCQUFBO0VBQ0EsV0FBQTtFQUNBLFdBQUE7QUFGRjtBQUNBLGcyQkFBZzJCIiwic291cmNlc0NvbnRlbnQiOlsiLmJ0bi13cmFwcGVyIHtcbiAgZGlzcGxheTogZmxleDtcbiAgZmxleC1kaXJlY3Rpb246IHJvdztcbiAganVzdGlmeS1jb250ZW50OiByaWdodDtcbiAgLy8gYnV0dG9ue1xuICAvLyAgIG1hcmdpbjogMTBweDtcbiAgLy8gfVxufVxuXG50YWJsZSB7XG4gIHdpZHRoOiAxMDAlO1xufVxuLmFjdGlvbi13cmFwcGVye1xuICAvLyBkaXNwbGF5OiBmbGV4O1xuICB3aWR0aDogMTAwJTtcbiAgLy8gaGVpZ2h0OiA0LjUlO1xufVxuLnRhYmxlLXdyYXBwZXJ7XG4gIGRpc3BsYXk6IGZsZXg7XG4gIGZsZXgtZGlyZWN0aW9uOiBjb2x1bW47XG4gIHdpZHRoOiAxMDAlO1xuICBoZWlnaHQ6IDkwJTtcbn1cbiJdLCJzb3VyY2VSb290IjoiIn0= */"]
  });
}


/***/ }),

/***/ 80883:
/*!*************************************************************************!*\
  !*** ./src/app/modules/user-manaement/reminders/reminders.component.ts ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "RemindersComponent": () => (/* binding */ RemindersComponent)
/* harmony export */ });
/* harmony import */ var _add_reminder_add_reminder_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../add-reminder/add-reminder.component */ 19061);
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! moment */ 56908);
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(moment__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _angular_material_paginator__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @angular/material/paginator */ 86907);
/* harmony import */ var _angular_material_sort__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @angular/material/sort */ 95096);
/* harmony import */ var _angular_material_table__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/material/table */ 83348);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/core */ 86839);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/forms */ 69542);
/* harmony import */ var _angular_material_dialog__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @angular/material/dialog */ 67486);
/* harmony import */ var app_services_pet_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! app/services/pet.service */ 59976);
/* harmony import */ var app_services_validations_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! app/services/validations.service */ 27681);
/* harmony import */ var app_services_loader_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! app/services/loader.service */ 38555);
/* harmony import */ var _angular_material_button__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @angular/material/button */ 83677);
/* harmony import */ var _angular_material_menu__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @angular/material/menu */ 89314);
/* harmony import */ var _angular_material_icon__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @angular/material/icon */ 69941);
















function RemindersComponent_th_4_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "th", 16);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](1, " ID. ");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
  }
}
function RemindersComponent_td_5_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "td", 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const element_r14 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtextInterpolate1"](" ", element_r14.id.substring(0, 6), " ");
  }
}
function RemindersComponent_th_7_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "th", 16);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](1, "Title ");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
  }
}
function RemindersComponent_td_8_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "td", 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const element_r15 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtextInterpolate1"](" ", element_r15.title, "");
  }
}
function RemindersComponent_th_10_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "th", 16);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](1, "Start Date ");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
  }
}
function RemindersComponent_td_11_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "td", 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const element_r16 = ctx.$implicit;
    const ctx_r5 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtextInterpolate1"]("", element_r16.reminderTime ? ctx_r5.currentUTCDate(element_r16.reminderTime) : "", " ");
  }
}
function RemindersComponent_th_13_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "th", 16);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](1, " End Date ");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
  }
}
function RemindersComponent_td_14_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "td", 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const element_r17 = ctx.$implicit;
    const ctx_r7 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵnextContext"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtextInterpolate1"]("", element_r17.endDate ? ctx_r7.currentUTCDate(element_r17.endDate) : "", " ");
  }
}
function RemindersComponent_th_16_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "th", 16);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](1, " Days ");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
  }
}
function RemindersComponent_td_17_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "td", 17);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
  }
  if (rf & 2) {
    const element_r18 = ctx.$implicit;
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtextInterpolate1"](" ", element_r18.data.days, " ");
  }
}
function RemindersComponent_th_19_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "th", 16);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](1, " Action ");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
  }
}
function RemindersComponent_td_20_Template(rf, ctx) {
  if (rf & 1) {
    const _r23 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵgetCurrentView"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "td", 17)(1, "button", 18);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵlistener"]("click", function RemindersComponent_td_20_Template_button_click_1_listener() {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵrestoreView"](_r23);
      const i_r20 = restoredCtx.index;
      const element_r19 = restoredCtx.$implicit;
      const ctx_r22 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵresetView"](ctx_r22.toggle(i_r20, element_r19));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](2, "mat-icon");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](3, "more_vert");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]()();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](4, "mat-menu", null, 19)(6, "button", 20);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵlistener"]("click", function RemindersComponent_td_20_Template_button_click_6_listener() {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵrestoreView"](_r23);
      const element_r19 = restoredCtx.$implicit;
      const i_r20 = restoredCtx.index;
      const ctx_r24 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵresetView"](ctx_r24.edit(element_r19, i_r20));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](7, "span", 21);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](8, "Edit");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](9, "mat-icon", 22);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](10, "edit");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]()();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](11, "button", 20);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵlistener"]("click", function RemindersComponent_td_20_Template_button_click_11_listener() {
      const restoredCtx = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵrestoreView"](_r23);
      const element_r19 = restoredCtx.$implicit;
      const i_r20 = restoredCtx.index;
      const ctx_r25 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵnextContext"]();
      return _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵresetView"](ctx_r25.delete(element_r19, i_r20));
    });
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](12, "span", 23);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](13, "Delete");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](14, "mat-icon", 24);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](15, "delete");
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]()()()();
  }
  if (rf & 2) {
    const _r21 = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵreference"](5);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](1);
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("matMenuTriggerFor", _r21);
  }
}
function RemindersComponent_tr_21_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelement"](0, "tr", 25);
  }
}
function RemindersComponent_tr_22_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelement"](0, "tr", 26);
  }
}
const _c0 = function () {
  return [5, 10, 25, 100];
};
class RemindersComponent {
  constructor(fb, dialog, petService, validationsService, loader) {
    this.fb = fb;
    this.dialog = dialog;
    this.petService = petService;
    this.validationsService = validationsService;
    this.loader = loader;
    this.displayedColumns = ['id', 'reminderTitle', 'Date', 'endDate', 'days', 'action'];
  }
  ngOnInit() {
    this.getReminders();
  }
  ngAfterViewInit() {
    this.recordData.paginator = this.paginator;
  }
  getReminders() {
    this.petService.getReminders(sessionStorage.getItem('petParentId'), sessionStorage.getItem('petId')).subscribe(res => {
      console.log(res);
      const petParentsArray = Object.values(res);
      this.recordData = new _angular_material_table__WEBPACK_IMPORTED_MODULE_6__.MatTableDataSource(petParentsArray.map(item => ({
        ...item
      })));
      this.recordData.paginator = this.paginator;
      this.recordData.sort = this.sort;
    });
  }
  formatTime(date) {
    date = new Date(date);
    let hours = date.getHours();
    let minutes = date.getMinutes();
    const ampm = hours >= 12 ? 'PM' : 'AM';
    hours = hours % 12;
    hours = hours ? hours : 12; // the hour '0' should be '12'
    minutes = minutes < 10 ? '0' + minutes : minutes;
    const timeString = `${hours}:${minutes} ${ampm}`;
    return timeString;
  }
  toggle(i, record) {}
  delete(record, i) {
    this.loader.showLoader();
    this.petService.deleteReminder(record['id']).subscribe(res => {
      this.loader.hideLoader();
      this.getReminders();
      console.log(res);
    }, error => {
      this.loader.hideLoader();
    });
  }
  edit(record, i) {
    const dialogRef = this.dialog.open(_add_reminder_add_reminder_component__WEBPACK_IMPORTED_MODULE_0__.AddReminderComponent, {
      height: '500px',
      data: {
        record: record
      }
    });
    dialogRef.afterClosed().subscribe(result => {
      console.log('The dialog was closed');
      console.log(result);
      this.getReminders();
    });
  }
  addRemainder() {
    const dialogRef = this.dialog.open(_add_reminder_add_reminder_component__WEBPACK_IMPORTED_MODULE_0__.AddReminderComponent, {
      height: '600px',
      data: {}
    });
    dialogRef.afterClosed().subscribe(result => {
      console.log('The dialog was closed');
      this.getReminders();
    });
  }
  currentUTCDate(date) {
    return moment__WEBPACK_IMPORTED_MODULE_1___default().utc(date).local().format("DD-MMM-YYYY");
  }
  static #_ = this.ɵfac = function RemindersComponent_Factory(t) {
    return new (t || RemindersComponent)(_angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](_angular_forms__WEBPACK_IMPORTED_MODULE_7__.FormBuilder), _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](_angular_material_dialog__WEBPACK_IMPORTED_MODULE_8__.MatDialog), _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](app_services_pet_service__WEBPACK_IMPORTED_MODULE_2__.PetService), _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](app_services_validations_service__WEBPACK_IMPORTED_MODULE_3__.ValidationsService), _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdirectiveInject"](app_services_loader_service__WEBPACK_IMPORTED_MODULE_4__.LoaderService));
  };
  static #_2 = this.ɵcmp = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdefineComponent"]({
    type: RemindersComponent,
    selectors: [["app-reminders"]],
    viewQuery: function RemindersComponent_Query(rf, ctx) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵviewQuery"](_angular_material_paginator__WEBPACK_IMPORTED_MODULE_9__.MatPaginator, 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵviewQuery"](_angular_material_sort__WEBPACK_IMPORTED_MODULE_10__.MatSort, 5);
      }
      if (rf & 2) {
        let _t;
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵloadQuery"]()) && (ctx.paginator = _t.first);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵqueryRefresh"](_t = _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵloadQuery"]()) && (ctx.sort = _t.first);
      }
    },
    decls: 28,
    vars: 6,
    consts: [[1, "container"], [1, "table-wrapper"], ["mat-table", "", 1, "mat-elevation-z8", "mt-2", 3, "dataSource"], ["matColumnDef", "id"], ["mat-header-cell", "", 4, "matHeaderCellDef"], ["mat-cell", "", 4, "matCellDef"], ["matColumnDef", "reminderTitle"], ["matColumnDef", "Date"], ["matColumnDef", "endDate"], ["matColumnDef", "days"], ["matColumnDef", "action"], ["mat-header-row", "", 4, "matHeaderRowDef"], ["mat-row", "", 4, "matRowDef", "matRowDefColumns"], [3, "pageSize", "pageSizeOptions"], [1, "btn"], ["mat-mini-fab", "", "color", "primary", 3, "click"], ["mat-header-cell", ""], ["mat-cell", ""], ["mat-icon-button", "", 3, "matMenuTriggerFor", "click"], ["actionMenu", "matMenu"], ["mat-menu-item", "", 3, "click"], [2, "color", "blue !important"], ["color", "primary"], [2, "color", "hsl(0, 94%, 42%) !important"], ["color", "warn"], ["mat-header-row", ""], ["mat-row", ""]],
    template: function RemindersComponent_Template(rf, ctx) {
      if (rf & 1) {
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](0, "div", 0)(1, "div", 1)(2, "table", 2);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementContainerStart"](3, 3);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](4, RemindersComponent_th_4_Template, 2, 0, "th", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](5, RemindersComponent_td_5_Template, 2, 1, "td", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementContainerStart"](6, 6);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](7, RemindersComponent_th_7_Template, 2, 0, "th", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](8, RemindersComponent_td_8_Template, 2, 1, "td", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementContainerStart"](9, 7);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](10, RemindersComponent_th_10_Template, 2, 0, "th", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](11, RemindersComponent_td_11_Template, 2, 1, "td", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementContainerStart"](12, 8);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](13, RemindersComponent_th_13_Template, 2, 0, "th", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](14, RemindersComponent_td_14_Template, 2, 1, "td", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementContainerStart"](15, 9);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](16, RemindersComponent_th_16_Template, 2, 0, "th", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](17, RemindersComponent_td_17_Template, 2, 1, "td", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementContainerStart"](18, 10);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](19, RemindersComponent_th_19_Template, 2, 0, "th", 4);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](20, RemindersComponent_td_20_Template, 16, 1, "td", 5);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementContainerEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](21, RemindersComponent_tr_21_Template, 1, 0, "tr", 11);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtemplate"](22, RemindersComponent_tr_22_Template, 1, 0, "tr", 12);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelement"](23, "mat-paginator", 13);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]();
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](24, "div", 14)(25, "button", 15);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵlistener"]("click", function RemindersComponent_Template_button_click_25_listener() {
          return ctx.addRemainder();
        });
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementStart"](26, "mat-icon");
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵtext"](27, "add");
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵelementEnd"]()()()();
      }
      if (rf & 2) {
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](2);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("dataSource", ctx.recordData);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](19);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("matHeaderRowDef", ctx.displayedColumns);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("matRowDefColumns", ctx.displayedColumns);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵadvance"](1);
        _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵproperty"]("pageSize", 10)("pageSizeOptions", _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵpureFunction0"](5, _c0));
      }
    },
    dependencies: [_angular_material_table__WEBPACK_IMPORTED_MODULE_6__.MatTable, _angular_material_table__WEBPACK_IMPORTED_MODULE_6__.MatHeaderCellDef, _angular_material_table__WEBPACK_IMPORTED_MODULE_6__.MatHeaderRowDef, _angular_material_table__WEBPACK_IMPORTED_MODULE_6__.MatColumnDef, _angular_material_table__WEBPACK_IMPORTED_MODULE_6__.MatCellDef, _angular_material_table__WEBPACK_IMPORTED_MODULE_6__.MatRowDef, _angular_material_table__WEBPACK_IMPORTED_MODULE_6__.MatHeaderCell, _angular_material_table__WEBPACK_IMPORTED_MODULE_6__.MatCell, _angular_material_table__WEBPACK_IMPORTED_MODULE_6__.MatHeaderRow, _angular_material_table__WEBPACK_IMPORTED_MODULE_6__.MatRow, _angular_material_button__WEBPACK_IMPORTED_MODULE_11__.MatIconButton, _angular_material_button__WEBPACK_IMPORTED_MODULE_11__.MatMiniFabButton, _angular_material_menu__WEBPACK_IMPORTED_MODULE_12__.MatMenu, _angular_material_menu__WEBPACK_IMPORTED_MODULE_12__.MatMenuItem, _angular_material_menu__WEBPACK_IMPORTED_MODULE_12__.MatMenuTrigger, _angular_material_icon__WEBPACK_IMPORTED_MODULE_13__.MatIcon, _angular_material_paginator__WEBPACK_IMPORTED_MODULE_9__.MatPaginator],
    styles: [".btn[_ngcontent-%COMP%] {\n  display: flex;\n  justify-content: end;\n}\n\n.card[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: column;\n  justify-content: space-between;\n  text-align: center;\n  padding: 20px;\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInJlbWluZGVycy5jb21wb25lbnQuc2NzcyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTtFQUNJLGFBQUE7RUFDQSxvQkFBQTtBQUNKOztBQUdBO0VBQ0ksYUFBQTtFQUNBLHNCQUFBO0VBQ0EsOEJBQUE7RUFDQSxrQkFBQTtFQUNBLGFBQUE7QUFBSiIsImZpbGUiOiJyZW1pbmRlcnMuY29tcG9uZW50LnNjc3MiLCJzb3VyY2VzQ29udGVudCI6WyIuYnRuIHtcbiAgICBkaXNwbGF5OiBmbGV4O1xuICAgIGp1c3RpZnktY29udGVudDogZW5kO1xufVxuXG5cbi5jYXJkIHtcbiAgICBkaXNwbGF5OiBmbGV4O1xuICAgIGZsZXgtZGlyZWN0aW9uOiBjb2x1bW47XG4gICAganVzdGlmeS1jb250ZW50OiBzcGFjZS1iZXR3ZWVuO1xuICAgIHRleHQtYWxpZ246IGNlbnRlcjtcbiAgICBwYWRkaW5nOiAyMHB4O1xufVxuXG4vLyBtYXQtaWNvbiB7XG4vLyAgICAgZm9udC1zaXplOiA0OHB4O1xuLy8gICAgIGRpc3BsYXk6IGJsb2NrO1xuLy8gICAgIG1hcmdpbi1ib3R0b206IDEwcHg7XG4vLyB9Il19 */\n/*# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8uL3NyYy9hcHAvbW9kdWxlcy91c2VyLW1hbmFlbWVudC9yZW1pbmRlcnMvcmVtaW5kZXJzLmNvbXBvbmVudC5zY3NzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBO0VBQ0ksYUFBQTtFQUNBLG9CQUFBO0FBQ0o7O0FBR0E7RUFDSSxhQUFBO0VBQ0Esc0JBQUE7RUFDQSw4QkFBQTtFQUNBLGtCQUFBO0VBQ0EsYUFBQTtBQUFKO0FBQ0Esd3ZCQUF3dkIiLCJzb3VyY2VzQ29udGVudCI6WyIuYnRuIHtcbiAgICBkaXNwbGF5OiBmbGV4O1xuICAgIGp1c3RpZnktY29udGVudDogZW5kO1xufVxuXG5cbi5jYXJkIHtcbiAgICBkaXNwbGF5OiBmbGV4O1xuICAgIGZsZXgtZGlyZWN0aW9uOiBjb2x1bW47XG4gICAganVzdGlmeS1jb250ZW50OiBzcGFjZS1iZXR3ZWVuO1xuICAgIHRleHQtYWxpZ246IGNlbnRlcjtcbiAgICBwYWRkaW5nOiAyMHB4O1xufVxuXG4vLyBtYXQtaWNvbiB7XG4vLyAgICAgZm9udC1zaXplOiA0OHB4O1xuLy8gICAgIGRpc3BsYXk6IGJsb2NrO1xuLy8gICAgIG1hcmdpbi1ib3R0b206IDEwcHg7XG4vLyB9Il0sInNvdXJjZVJvb3QiOiIifQ== */"]
  });
}


/***/ }),

/***/ 17496:
/*!*************************************************************************************************!*\
  !*** ./src/app/modules/user-manaement/user-activity-history/user-activity-history.component.ts ***!
  \*************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "UserActivityHistoryComponent": () => (/* binding */ UserActivityHistoryComponent)
/* harmony export */ });
/* harmony import */ var _angular_material_dialog__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/material/dialog */ 67486);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @angular/core */ 86839);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/common */ 86477);
/* harmony import */ var _angular_material_tabs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/material/tabs */ 12128);
/* harmony import */ var _angular_material_stepper__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/material/stepper */ 96247);
/* harmony import */ var _angular_material_button__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/material/button */ 83677);







function UserActivityHistoryComponent_mat_tab_1_ng_template_4_Template(rf, ctx) {
  if (rf & 1) {
    _angular_core__WEBPACK_IMPORTED_MODULE_0__["ɵɵtext"](0, "Details");
  }
}
function UserActivityHistoryComponent_mat_tab_1_