(self["webpackChunkadmin_panel"] = self["webpackChunkadmin_panel"] || []).push([["default-src_app_services_workspace-management_service_ts-node_modules_file-saver_dist_FileSav-adba87"],{

/***/ 67254:
/*!**********************************************************!*\
  !*** ./src/app/services/workspace-management.service.ts ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "WorkspaceManagementService": () => (/* binding */ WorkspaceManagementService)
/* harmony export */ });
/* harmony import */ var environments_environment__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! environments/environment */ 92340);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 86839);
/* harmony import */ var _angular_common_http__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/common/http */ 33765);
/* harmony import */ var app_core_auth_auth_service__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! app/core/auth/auth.service */ 88951);




// import { environment } from '';
// function checkImageDimensions(file: File, width: number, height: number): Promise<boolean> {
//   const requiredWidth = 1920; // Example required width
//   const requiredHeight = 1080; // Example required height
//   return new Promise((resolve, reject) => {
//     const img = new Image();
//     const objectUrl = URL.createObjectURL(file);
//     img.onload = () => {
//       URL.revokeObjectURL(objectUrl);
//       if (img.width === width && img.height === height) {
//         resolve(true);
//       } else {
//         resolve(false);
//       }
//     };
//     img.onerror = () => {
//       URL.revokeObjectURL(objectUrl);
//       reject(new Error('Image load error'));
//     };
//     img.src = objectUrl;
//   });
// }
class WorkspaceManagementService {
  constructor(http, authService) {
    this.http = http;
    this.authService = authService;
    this.configUrl = environments_environment__WEBPACK_IMPORTED_MODULE_0__.environment.apiUrl + 'admin/v1/super/admin/';
    this.adminId = sessionStorage.getItem('adminId');
  }
  getWorkSpaces(serviceId) {
    // serviceId = "5e4c6b60-c48e-11ed-abc1-02817ef0919c" //gromming
    let url = this.configUrl + this.adminId + '/workspace/' + serviceId + '/details';
    return this.http.get(url);
  }
  createWorkSpace(body) {
    let url = this.configUrl + 'workspace/' + this.adminId + '/create?adminId=' + this.adminId;
    return this.http.post(url, body);
  }
  updateWorkSpace(workspaceId, body) {
    let url = this.configUrl + 'workspace/' + workspaceId + '/modify?adminId=' + this.adminId;
    return this.http.put(url, body);
  }
  uploadWorkspaceImage(workspaceId, collaboratorId, imageFilesArray) {
    let url = this.configUrl + 'workspace/' + workspaceId + "/images/update?collaboratorId=" + collaboratorId;
    // const imageFile = new File([imageFilePath], "profile.jpg", { type: "image/jpeg" });
    const formData = new FormData();
    imageFilesArray.forEach((imageFile, i) => {
      console.log(imageFile, i);
      // for (const key in imageFiles) {
      // if (imageFiles.hasOwnProperty(i)) {
      formData.append('files', imageFile);
      // }
      // }
    });
    console.log("🚀 ~ WorkspaceManagementService ~ uploadWorkspaceImage ~ formData:", formData);
    return this.http.put(url, formData);
  }
  deletWorkSpaceImageById(workspaceId, imageId) {
    // https://api-dev.furrcrew.com/admin/v1/super/admin/image/c948ed7d-f047-45a4-8873-42269990a208/delete
    let url = this.configUrl + 'image/' + workspaceId + '/delete';
    return this.http.delete(url, {
      body: imageId
    });
  }
  uploadCoverImage(type, workspaceId, imagePath) {
    const url = `${this.configUrl}cover/image/upload?type=${type}&refId=${workspaceId}`;
    const fileExtension = imagePath.name.split('.').pop();
    const timestamp = Date.now();
    const newFileName = `${timestamp}.${fileExtension}`;
    const newFile = new File([imagePath], newFileName, {
      type: imagePath.type
    });
    const formData = new FormData();
    formData.append('file', newFile);
    return this.http.put(url, formData);
  }
  uploadWorkSpaceDocuments(type, collaboratorId, workSpaceId, document) {
    // type = "PAN"
    console.log(workSpaceId);
    // docNumber = "AMCPP2908C"
    // collaboratorId = "64fe4ab2-34cb-4cf1-9272-3b95a801dcaf";
    // workSpaceId = "295a595b-6238-41ce-baac-139de187744e"
    // const imageFile = new File([document], "profile.jpg", { type: "image/jpeg" });
    let formDta = new FormData();
    formDta.append('files', document);
    // const headers = new HttpHeaders();
    // headers.set('Content-Type', 'multipart/form-data');
    let url = this.configUrl + 'workspace/{workspaceId}' + '/collaborator/documents/images?collaboratorId=' + collaboratorId + '&type=' + type;
    return this.http.post(url, formDta);
  }
  addBankDetails(workSpaceId, body) {
    let url = this.configUrl + 'workspace/' + workSpaceId + '/bank/detail';
    return this.http.post(url, body);
  }
  updateBankDetails(workSpaceId, body) {
    let url = this.configUrl + 'workspace/' + workSpaceId + '/bank/detail';
    return this.http.put(url, body);
  }
  getBankDetails(workspaceId, collaboratorId) {
    //ot working
    let url = this.configUrl + 'workspace/' + workspaceId + '/bank/detail?collaboratorId=' + collaboratorId;
    return this.http.get(url);
  }
  getWorkspaceDocuments(workspaceId) {
    let url = this.configUrl + 'workspace/collaborator/' + workspaceId + '/documents';
    return this.http.get(url);
  }
  createNgo(collaboratorId, body) {
    let url = this.configUrl + 'NGO?collaboratorId=' + collaboratorId;
    return this.http.post(url, body);
  }
  updateNgo(collaboratorId, body) {
    // https://api-dev.furrcrew.com/admin/v1/super/admin/workspace/15cbad7a-beec-400a-9e61-9accd2de1f44/modify?adminId=1
    let url = this.configUrl + 'NGO?collaboratorId=' + collaboratorId + '&adminId=' + this.adminId + '&workspaceId=' + body['workspaceId'];
    return this.http.put(url, body);
  }
  deleteWorkspace(workspaceId) {
    // https://api-dev.furrcrew.com/admin/v1/super/admin/workspace/100e13af-6336-4f63-aae5-ce20dce6096d/modify?adminId=1
    let url = this.configUrl + 'workspace/' + workspaceId + '/modify?adminId=' + this.adminId;
    return this.http.delete(url);
  }
  listOnlyWorkspace(workspaceId, body) {
    let url = this.configUrl + 'workspace/' + workspaceId + '/modify?adminId=' + this.adminId;
    return this.http.put(url, body);
  }
  locked(workspaceId) {
    // https://api-dev.furrcrew.com/admin/v1/super/admin/workspace/version?workspaceId=c3c6446e-f95a-449a-a973-93b47647ca1a
    let url = this.configUrl + 'workspace/version?workspaceId=' + workspaceId;
    return this.http.get(url);
  }
  versionLock(versionId, body) {
    let url = this.configUrl + 'workspace/version?adminId=' + this.adminId + '&versionId=' + versionId;
    return this.http.put(url, body);
  }
  editLockData(versionId, body) {
    let url = this.configUrl + 'workspace/version?adminId=' + this.adminId + '&versionId=' + versionId;
    return this.http.put(url, body);
  }
  testChange(type, id, isTest) {
    // https://api-dev.furrcrew.com/admin/v1/super/admin/update/test/data/?type=WORKSPACE&dataId=36f36154-ddee-4821-b559-5a8e8af94617&isTest=true
    let url = this.configUrl + 'update/test/data/?type=' + type + '&dataId=' + id + '&isTest=' + isTest;
    return this.http.put(url, {});
  }
  getMatrics(startDate, endDate, type, refId) {
    let url = this.configUrl + 'analytics/metrics?startDate=' + startDate + '&endDate=' + endDate + '&type=' + type + '&refId=' + refId;
    return this.http.get(url);
  }
  static #_ = this.ɵfac = function WorkspaceManagementService_Factory(t) {
    return new (t || WorkspaceManagementService)(_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵinject"](_angular_common_http__WEBPACK_IMPORTED_MODULE_3__.HttpClient), _angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵinject"](app_core_auth_auth_service__WEBPACK_IMPORTED_MODULE_1__.AuthService));
  };
  static #_2 = this.ɵprov = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdefineInjectable"]({
    token: WorkspaceManagementService,
    factory: WorkspaceManagementService.ɵfac,
    providedIn: 'root'
  });
}


/***/ }),

/***/ 65226:
/*!*******************************************************!*\
  !*** ./node_modules/file-saver/dist/FileSaver.min.js ***!
  \*******************************************************/
/***/ (function(module, exports) {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;(function (a, b) {
  if (true) !(__WEBPACK_AMD_DEFINE_ARRAY__ = [], __WEBPACK_AMD_DEFINE_FACTORY__ = (b),
		__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
		(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));else {}
})(this, function () {
  "use strict";

  function b(a, b) {
    return "undefined" == typeof b ? b = {
      autoBom: !1
    } : "object" != typeof b && (console.warn("Deprecated: Expected third argument to be a object"), b = {
      autoBom: !b
    }), b.autoBom && /^\s*(?:text\/\S*|application\/xml|\S*\/\S*\+xml)\s*;.*charset\s*=\s*utf-8/i.test(a.type) ? new Blob(["\uFEFF", a], {
      type: a.type
    }) : a;
  }
  function c(a, b, c) {
    var d = new XMLHttpRequest();
    d.open("GET", a), d.responseType = "blob", d.onload = function () {
      g(d.response, b, c);
    }, d.onerror = function () {
      console.error("could not download file");
    }, d.send();
  }
  function d(a) {
    var b = new XMLHttpRequest();
    b.open("HEAD", a, !1);
    try {
      b.send();
    } catch (a) {}
    return 200 <= b.status && 299 >= b.status;
  }
  function e(a) {
    try {
      a.dispatchEvent(new MouseEvent("click"));
    } catch (c) {
      var b = document.createEvent("MouseEvents");
      b.initMouseEvent("click", !0, !0, window, 0, 0, 0, 80, 20, !1, !1, !1, !1, 0, null), a.dispatchEvent(b);
    }
  }
  var f = "object" == typeof window && window.window === window ? window : "object" == typeof self && self.self === self ? self : "object" == typeof global && global.global === global ? global : void 0,
    a = f.navigator && /Macintosh/.test(navigator.userAgent) && /AppleWebKit/.test(navigator.userAgent) && !/Safari/.test(navigator.userAgent),
    g = f.saveAs || ("object" != typeof window || window !== f ? function () {} : "download" in HTMLAnchorElement.prototype && !a ? function (b, g, h) {
      var i = f.URL || f.webkitURL,
        j = document.createElement("a");
      g = g || b.name || "download", j.download = g, j.rel = "noopener", "string" == typeof b ? (j.href = b, j.origin === location.origin ? e(j) : d(j.href) ? c(b, g, h) : e(j, j.target = "_blank")) : (j.href = i.createObjectURL(b), setTimeout(function () {
        i.revokeObjectURL(j.href);
      }, 4E4), setTimeout(function () {
        e(j);
      }, 0));
    } : "msSaveOrOpenBlob" in navigator ? function (f, g, h) {
      if (g = g || f.name || "download", "string" != typeof f) navigator.msSaveOrOpenBlob(b(f, h), g);else if (d(f)) c(f, g, h);else {
        var i = document.createElement("a");
        i.href = f, i.target = "_blank", setTimeout(function () {
          e(i);
        });
      }
    } : function (b, d, e, g) {
      if (g = g || open("", "_blank"), g && (g.document.title = g.document.body.innerText = "downloading..."), "string" == typeof b) return c(b, d, e);
      var h = "application/octet-stream" === b.type,
        i = /constructor/i.test(f.HTMLElement) || f.safari,
        j = /CriOS\/[\d]+/.test(navigator.userAgent);
      if ((j || h && i || a) && "undefined" != typeof FileReader) {
        var k = new FileReader();
        k.onloadend = function () {
          var a = k.result;
          a = j ? a : a.replace(/^data:[^;]*;/, "data:attachment/file;"), g ? g.location.href = a : location = a, g = null;
        }, k.readAsDataURL(b);
      } else {
        var l = f.URL || f.webkitURL,
          m = l.createObjectURL(b);
        g ? g.location = m : location.href = m, g = null, setTimeout(function () {
          l.revokeObjectURL(m);
        }, 4E4);
      }
    });
  f.saveAs = g.saveAs = g,  true && (module.exports = g);
});

/***/ })

}]);
//# sourceMappingURL=default-src_app_services_workspace-management_service_ts-node_modules_file-saver_dist_FileSav-adba87.js.map