"use strict";
(self["webpackChunkadmin_panel"] = self["webpackChunkadmin_panel"] || []).push([["default-src_app_services_coupon-management_service_ts-src_app_services_education_service_ts-s-4b971f"],{

/***/ 52503:
/*!*******************************************************!*\
  !*** ./src/app/services/coupon-management.service.ts ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "CouponManagementService": () => (/* binding */ CouponManagementService)
/* harmony export */ });
/* harmony import */ var environments_environment__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! environments/environment */ 92340);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ 86839);
/* harmony import */ var _angular_common_http__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/common/http */ 33765);



class CouponManagementService {
  constructor(http) {
    this.http = http;
    this.configUrl = environments_environment__WEBPACK_IMPORTED_MODULE_0__.environment.apiUrl + 'admin/v1/super/admin/';
    this.adminId = sessionStorage.getItem('adminId');
    this.editWorkspace = false;
  }
  createCoupan(body, collaboratorId) {
    collaboratorId = "64fe4ab2-34cb-4cf1-9272-3b95a801dcaf";
    let url = this.configUrl + this.adminId + '/coupon?collaboratorId=' + collaboratorId;
    return this.http.post(url, body);
  }
  updateCoupon(userId, body, collaboratorId) {
    // ../1/coupon?collaboratorId=355fa882-e356-4ced-9b4d-217547751fa8
    let url = this.configUrl + userId + '/coupon?collaboratorId=' + collaboratorId;
    return this.http.put(url, body);
  }
  getAllCoupans(collaboratorId) {
    let url = this.configUrl + this.adminId + '/coupon?collaboratorId=' + collaboratorId;
    return this.http.get(url);
  }
  deleteCoupan(id, userId) {
    let url = this.configUrl + userId + '/coupon?couponId=' + id;
    return this.http.delete(url);
  }
  couponUsage(couponId, type) {
    // https://api-dev.furrcrew.com/admin/v1/super/admin/stats/data?refId=019b2d11-f425-4ac2-8f19-101b9071b768&type=COUPON
    let url = this.configUrl + 'stats/data?refId=' + couponId + '&type=' + type;
    return this.http.get(url);
  }
  static #_ = this.ɵfac = function CouponManagementService_Factory(t) {
    return new (t || CouponManagementService)(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵinject"](_angular_common_http__WEBPACK_IMPORTED_MODULE_2__.HttpClient));
  };
  static #_2 = this.ɵprov = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineInjectable"]({
    token: CouponManagementService,
    factory: CouponManagementService.ɵfac,
    providedIn: 'root'
  });
}


/***/ }),

/***/ 89228:
/*!***********************************************!*\
  !*** ./src/app/services/education.service.ts ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "EducationService": () => (/* binding */ EducationService)
/* harmony export */ });
/* harmony import */ var environments_environment__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! environments/environment */ 92340);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ 86839);
/* harmony import */ var _angular_common_http__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/common/http */ 33765);



class EducationService {
  constructor(http) {
    this.http = http;
    this.configUrl = environments_environment__WEBPACK_IMPORTED_MODULE_0__.environment.apiUrl + 'admin/v1/super/admin/';
    this.adminId = sessionStorage.getItem('adminId');
  }
  addEducatioCategory(body) {
    let url = this.configUrl + 'edu/category';
    body = {
      "id": "1",
      "name": "Classess",
      "createdBy": "42",
      "active": true
    };
    return this.http.post(url, body);
  }
  updateEducatioCategory(body) {
    let url = this.configUrl + 'edu/category';
    body = {
      "id": "dd0574d4-aa1a-426b-b718-d18595e96381",
      "name": "Web1",
      "createdBy": "12",
      "active": true
    };
    return this.http.put(url, body);
  }
  createWebiar(body) {
    let url = this.configUrl + 'edu/webinar';
    return this.http.post(url, body);
  }
  updateWebinar(body) {
    let url = this.configUrl + 'edu/webinar';
    return this.http.put(url, body);
  }
  deleteCourse(id) {
    // "https://api-dev.furrcrew.com/admin/v1/super/admin/edu/category?educationId=0910b311-aee1-4a90-b4fe-352a0b29dd6c";
    let url = this.configUrl + 'edu/category?educationId=' + id;
    return this.http.delete(url);
  }
  getWebinar(id) {
    id = "056b7aa4-ef04-4106-ac12-4ff3f84c304d";
    let url = this.configUrl + 'edu/webinar?id=' + id;
    return this.http.get(url);
  }
  getAllWebiars() {
    let url = this.configUrl + 'edu/webinar';
    return this.http.get(url);
  }
  getCources() {
    let url = this.configUrl + 'edu/course';
    return this.http.get(url);
  }
  uploadPoster(webinarId, imageFilePath) {
    const fileExtension = imageFilePath.name.split('.').pop();
    const timestamp = Date.now();
    const newFileName = `${timestamp}.${fileExtension}`;
    const newFile = new File([imageFilePath], newFileName, {
      type: imageFilePath.type
    });
    const formData = new FormData();
    formData.append('file', newFile);
    let url = this.configUrl + 'edu/webinar/poster?webinarId=' + webinarId;
    return this.http.post(url, formData);
  }
  uploadEpisode(webinarId, title, description, videoDuration, episodeNo, file) {
    let url = this.configUrl + 'edu/webinar/files?webinarId=' + webinarId + '&title=' + title + '&description=' + description + '&videoDuration=' + videoDuration + '&episodeNo=' + episodeNo;
    let formDta = new FormData();
    formDta.append('files', file);
    // const headers = new HttpHeaders();
    // headers.set('Content-Type', 'multipart/form-data');
    return this.http.post(url, formDta);
  }
  updateEpisode(educationId, videoId, title, description, videoDuration, episodeNo) {
    // https://api-dev.furrcrew.com/admin/v1/super/admin/edu/webinar/files?eduId=ec7d46ab-0d46-4a33-8bf7-7606c9865450&videoId=c49410f6-65dc-4730-a97c-8010dcfed172&title=Angulaee%201&description=%3Cp%3EYeeeyy!!%3C/p%3E&videoDuration=38&episodeNo=1
    let url = this.configUrl + 'edu/webinar/files?eduId=' + educationId + '&videoId=' + videoId + '&title=' + title + '&description=' + description + "&videoDuration=" + videoDuration + '&episodeNo=' + episodeNo;
    return this.http.put(url, {});
  }
  updateWebinarVideo(educationId, videoId, file) {
    // https://api-dev.furrcrew.com/admin/v1/super/admin/edu/course/?eduId=066a03cf-263f-43f2-86e6-3c73c21b6781&videoId=1cb82dd9-db38-4893-b5b7-bfceb7fdfdf4
    let url = this.configUrl + 'edu/course/?eduId=' + educationId + '&videoId=' + videoId;
    let formData = new FormData();
    formData.append('file', file);
    return this.http.put(url, formData);
  }
  stats(refId, type) {
    // https://api-dev.furrcrew.com/admin/v1/super/admin/stats/data?refId=7ba9fca2-7fd4-4bca-9eb5-5de91857affb&type=EDU
    let url = this.configUrl + 'stats/data?refId=' + refId + '&type=' + type;
    return this.http.get(url);
  }
  featuresSponsoredTollge(eduId, key, state) {
    // https://api-dev.furrcrew.com/admin/v1/super/admin/edu/update/featured/sponsored?eduId=ff14a25a-c845-4dab-be60-b4e6e1145a86&key=featured&value=true
    let url = this.configUrl + 'edu/update/featured/sponsored?eduId=' + eduId + '&key=' + key + '&value=' + state;
    return this.http.put(url, {});
  }
  testChange(type, id, isTest) {
    //WEBINAR_COURSE
    let url = this.configUrl + 'update/test/data/?type=' + type + '&dataId=' + id + '&isTest=' + isTest;
    return this.http.put(url, {});
  }
  static #_ = this.ɵfac = function EducationService_Factory(t) {
    return new (t || EducationService)(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵinject"](_angular_common_http__WEBPACK_IMPORTED_MODULE_2__.HttpClient));
  };
  static #_2 = this.ɵprov = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineInjectable"]({
    token: EducationService,
    factory: EducationService.ɵfac,
    providedIn: 'root'
  });
}


/***/ }),

/***/ 28055:
/*!***************************************************!*\
  !*** ./src/app/services/miscellaneous.service.ts ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "MiscellaneousService": () => (/* binding */ MiscellaneousService)
/* harmony export */ });
/* harmony import */ var environments_environment__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! environments/environment */ 92340);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ 86839);
/* harmony import */ var _angular_common_http__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/common/http */ 33765);



class MiscellaneousService {
  constructor(http) {
    this.http = http;
    this.configUrl = environments_environment__WEBPACK_IMPORTED_MODULE_0__.environment.apiUrl + 'admin/v1/super/admin/';
    this.adminId = sessionStorage.getItem('adminId');
  }
  addBlog(body) {
    let url = this.configUrl + this.adminId + '/blogs';
    return this.http.post(url, body);
  }
  deleteBlog(blogId) {
    let url = this.configUrl + this.adminId + '/blogs?blogId=' + blogId;
    return this.http.delete(url);
  }
  upddateBlog(body, userId) {
    let url = this.configUrl + userId + '/blogs';
    return this.http.put(url, body);
  }
  // updateStatus(body: any, userId) {
  //   let url = this.configUrl + userId + '/update';
  //   return this.http.put(url, body)
  // }
  getBlogs(status, category) {
    status = false;
    let url = this.configUrl + this.adminId + '/blogs?status=' + status + '&category=' + category;
    return this.http.get(url);
  }
  createEvent(body) {
    // https://api-dev.furrcrew.com/events/v1/event/create
    let url = environments_environment__WEBPACK_IMPORTED_MODULE_0__.environment.apiUrl + 'events/v1/event/create';
    // let url = 'https://api-dev.furrcrew.com/events/v1/event/create';
    return this.http.post(url, body);
  }
  addEventImage(coverImage, eventId) {
    let url = environments_environment__WEBPACK_IMPORTED_MODULE_0__.environment.apiUrl + 'events/v1/event/thumbImage?eventId=' + eventId;
    const fileExtension = coverImage.name.split('.').pop();
    const timestamp = Date.now();
    const newFileName = `${timestamp}.${fileExtension}`;
    const newFile = new File([coverImage], newFileName, {
      type: coverImage.type
    });
    const formData = new FormData();
    formData.append('file', newFile);
    return this.http.post(url, formData);
  }
  addBlogImages(blogId, coverImage) {
    let url = this.configUrl + this.adminId + '/blogs/images?blogId=' + blogId;
    const fileExtension = coverImage.name.split('.').pop();
    const timestamp = Date.now();
    const newFileName = `${timestamp}.${fileExtension}`;
    const newFile = new File([coverImage], newFileName, {
      type: coverImage.type
    });
    const formData = new FormData();
    formData.append('files', newFile);
    return this.http.post(url, formData);
  }
  addCoverImage(blogId, coverImage) {
    debugger;
    // https://api-dev.furrcrew.com/admin/v1/super/admin/blogs/cover/image?blogId=e8357773-e6c1-46da-b640-5135ebecf790
    let url = this.configUrl + 'blogs/cover/image?blogId=' + blogId;
    const fileExtension = coverImage.name.split('.').pop();
    const timestamp = Date.now();
    const newFileName = `${timestamp}.${fileExtension}`;
    const newFile = new File([coverImage], newFileName, {
      type: coverImage.type
    });
    const formData = new FormData();
    formData.append('file', newFile);
    return this.http.post(url, formData);
  }
  addEventCoverImage(eventId, coverImage) {
    // https://api-dev.furrcrew.com/events/v1/event/cover/image?eventId=dbc0d7f8-5734-414d-a259-962527f81d04
    let url = environments_environment__WEBPACK_IMPORTED_MODULE_0__.environment.apiUrl + 'events/v1/event/' + 'coverImage?eventId=' + eventId;
    const fileExtension = coverImage.name.split('.').pop();
    const timestamp = Date.now();
    const newFileName = `${timestamp}.${fileExtension}`;
    const newFile = new File([coverImage], newFileName, {
      type: coverImage.type
    });
    const formData = new FormData();
    formData.append('files', newFile);
    return this.http.post(url, formData);
  }
  getEvent() {
    let url = environments_environment__WEBPACK_IMPORTED_MODULE_0__.environment.apiUrl + 'events/v1/event?deviceType=All';
    return this.http.get(url);
  }
  updateEvent(eventId, body) {
    let url = environments_environment__WEBPACK_IMPORTED_MODULE_0__.environment.apiUrl + 'events/v1/event/' + eventId + '/update';
    return this.http.put(url, body);
  }
  updateEventAddress(body) {
    let url = environments_environment__WEBPACK_IMPORTED_MODULE_0__.environment.apiUrl + 'events/v1/event/update?modifiedBy=' + this.adminId;
    return this.http.put(url, body);
  }
  deleteEvent(eventId) {
    let url = environments_environment__WEBPACK_IMPORTED_MODULE_0__.environment.apiUrl + 'events/v1/event/' + eventId + '/delete';
    return this.http.delete(url);
  }
  deleteTicket(id) {
    // https://api-dev.furrcrew.com/events/v1/event/price/update?id=ea019034-9fd8-4b1a-9322-b0390f13d319
    let url = environments_environment__WEBPACK_IMPORTED_MODULE_0__.environment.apiUrl + 'events/v1/event/price/update?id=' + this.adminId;
    return this.http.delete(url);
  }
  addTicket(body) {
    let url = environments_environment__WEBPACK_IMPORTED_MODULE_0__.environment.apiUrl + 'events/v1/event/' + 'price/update?createdBy=' + this.adminId;
    return this.http.post(url, body);
  }
  updateTicket(body) {
    let url = environments_environment__WEBPACK_IMPORTED_MODULE_0__.environment.apiUrl + 'events/v1/event/price/update?modifiedBy=' + this.adminId;
    return this.http.put(url, body);
  }
  getAdvertisement() {
    let url = environments_environment__WEBPACK_IMPORTED_MODULE_0__.environment.apiUrl + 'events/v1/advertisement';
    return this.http.get(url);
  }
  editAdvertisement(id, data) {
    let url = environments_environment__WEBPACK_IMPORTED_MODULE_0__.environment.apiUrl + 'events/v1/advertisement/?advertisementId=' + id;
    data = {
      "id": "572c2594-83cf-4668-93a3-648fc08bad46",
      "title": "DDD",
      "description": "ABCD",
      "status": "Active",
      "startDate": 1708281000000,
      "endDate": 1709058600000,
      "advertiserName": "aac",
      "rawData": "axcfde",
      "filePath": "bhn",
      "type": "ROLL",
      "externalLink": null,
      "internalLink": "google.com",
      "viewedCount": 2,
      "subType": "List",
      "refId": ""
    };
    return this.http.put(url, data);
  }
  uploadImage(id, file) {
    let url = environments_environment__WEBPACK_IMPORTED_MODULE_0__.environment.apiUrl + 'events/v1/advertisement/image?advertisementId=' + id;
    const fileExtension = file.name.split('.').pop();
    const timestamp = Date.now();
    const newFileName = `${timestamp}.${fileExtension}`;
    const newFile = new File([file], newFileName, {
      type: file.type
    });
    const formData = new FormData();
    formData.append('file', newFile);
    this.http.post(url, formData);
  }
  createAdvertisement(data) {
    let url = environments_environment__WEBPACK_IMPORTED_MODULE_0__.environment.apiUrl + 'events/v1/advertisement';
    return this.http.post(url, data);
  }
  getAdminList() {
    let url = environments_environment__WEBPACK_IMPORTED_MODULE_0__.environment.apiUrl + 'admin/v1/super/admin/' + this.adminId + '/general/users';
    return this.http.get(url);
  }
  getFaqsByType(type) {
    //https://api-dev.furrcrew.com/admin/v1/super/admin/faq?type=user
    // https://api-dev.furrcrew.com/admin/v1/super/admin/faq?type=collaborator
    let url = environments_environment__WEBPACK_IMPORTED_MODULE_0__.environment.apiUrl + 'admin/v1/super/admin/faq?type=' + type;
    return this.http.get(url);
  }
  chnageFaqStatus(body) {
    let url = environments_environment__WEBPACK_IMPORTED_MODULE_0__.environment.apiUrl + 'admin/v1/super/admin/faq';
    return this.http.put(url, body);
  }
  testChange(type, id, isTest) {
    //BLOGS_ARTICLES
    let url = environments_environment__WEBPACK_IMPORTED_MODULE_0__.environment.apiUrl + 'events/v1/update/test/data/?type=' + type + '&dataId=' + id + '&isTest=' + isTest;
    // https://api-dev.furrcrew.com/events/v1/update/test/data/?type=EVENTS&dataId=019069c8-82a4-47d2-a377-6ed38f4d117c&isTest=true
    // let url = this.configUrl + 'update/test/data/?type=' + type + '&dataId=' + id + '&isTest=' + isTest;
    return this.http.put(url, {});
  }
  addFaq(body) {
    // https://api-dev.furrcrew.com/admin/v1/super/admin/faq
    let url = this.configUrl + 'faq';
    return this.http.post(url, body);
  }
  editFaq(body) {
    let url = this.configUrl + 'faq';
    return this.http.put(url, body);
  }
  deleteFaq(faqId) {
    // localhost:8090/api/v1/super/admin/faq?faqId=73afc8ac-cfc2-11ee-a684-020fe9714ff8;
    let url = this.configUrl + 'faq?faqId=' + faqId;
    return this.http.delete(url);
  }
  exportData(data) {
    const csvContent = this.convertToCSV(data); // Convert data to CSV format
    const blob = new Blob([csvContent], {
      type: 'text/csv;charset=utf-8;'
    });
    const url = window.URL.createObjectURL(blob);
    const a = document.createElement('a');
    a.href = url;
    a.download = 'selected_events.csv'; // Filename
    a.click();
    window.URL.revokeObjectURL(url);
  }
  convertToCSV(data) {
    const headers = Object.keys(data[0]).join(',');
    const rows = data.map(row => Object.values(row).join(','));
    return [headers, ...rows].join('\n');
  }
  static #_ = this.ɵfac = function MiscellaneousService_Factory(t) {
    return new (t || MiscellaneousService)(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵinject"](_angular_common_http__WEBPACK_IMPORTED_MODULE_2__.HttpClient));
  };
  static #_2 = this.ɵprov = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineInjectable"]({
    token: MiscellaneousService,
    factory: MiscellaneousService.ɵfac,
    providedIn: 'root'
  });
}


/***/ })

}]);
//# sourceMappingURL=default-src_app_services_coupon-management_service_ts-src_app_services_education_service_ts-s-4b971f.js.map