"use strict";
(self["webpackChunkadmin_panel"] = self["webpackChunkadmin_panel"] || []).push([["default-src_app_services_adoption-management_service_ts-src_app_services_user-management_service_ts"],{

/***/ 54384:
/*!*********************************************************!*\
  !*** ./src/app/services/adoption-management.service.ts ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AdoptionManagementService": () => (/* binding */ AdoptionManagementService)
/* harmony export */ });
/* harmony import */ var _angular_common_http__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/common/http */ 33765);
/* harmony import */ var environments_environment__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! environments/environment */ 92340);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 86839);




class AdoptionManagementService {
  constructor(http) {
    this.http = http;
    this.configUrl = environments_environment__WEBPACK_IMPORTED_MODULE_0__.environment.apiUrl + 'admin/v1/super/admin/';
    this.adminId = sessionStorage.getItem('adminId');
  }
  addPetAdoption(body) {
    // userId = this.adminId;
    let url = this.configUrl + 'pet/adoption?userId=' + this.adminId;
    return this.http.post(url, body);
  }
  updatePetAdoption(body) {
    let url = this.configUrl + 'pet/adoption?userId=' + this.adminId;
    return this.http.put(url, body);
  }
  deletePetAdoption(id) {
    // userId = this.adminId;
    let url = this.configUrl + 'pet/adoption?adoptionId=' + id;
    return this.http.delete(url);
  }
  getPetAdoptons(userId) {
    userId = this.adminId;
    let url = this.configUrl + "pet/adoption?userId=" + userId;
    return this.http.get(url);
  }
  addPetAdoptionImages(petId, userId, file) {
    let url = this.configUrl + "pet/adoption/" + petId + "/images/" + userId;
    let imageFilePath = "./assets/images/angular.jpg";
    const imageFile = new File([imageFilePath], "profile.jpg", {
      type: "image/jpeg"
    });
    let formDta = new FormData();
    formDta.append('files', imageFile);
    const headers = new _angular_common_http__WEBPACK_IMPORTED_MODULE_1__.HttpHeaders();
    headers.set('Content-Type', 'multipart/form-data');
    return this.http.post(url, formDta, {
      headers
    });
  }
  getBreeds(type) {
    // https://api-dev.furrcrew.com/admin/v1/super/admin/pet/category?type=dog
    let url = this.configUrl + 'pet/category?type=' + type;
    return this.http.get(url);
  }
  uploadImages(adoptionId, images) {
    console.log(images);
    // https://api-dev.furrcrew.com/admin/v1/super/admin/pet/adoption/fc717c06-5cb5-4a78-bfc8-91c60119f7b8/images/1
    let url = this.configUrl + 'pet/adoption/' + adoptionId + '/images/' + this.adminId;
    // return this.http.post(url,)
    let formDta = new FormData();
    images.forEach(image => {
      formDta.append('files', image);
    });
    return this.http.post(url, formDta);
  }
  uploadCoverImage(refId, image) {
    // https://api-dev.furrcrew.com/admin/v1/super/admin/cover/image/upload?type=ADOPTION&refId=ffaa2a38-9c14-4b11-b4b4-d71ca407a6cf
    let formData = new FormData();
    formData.append('file', image);
    let url = this.configUrl + 'cover/image/upload?type=ADOPTION&refId=' + refId;
    return this.http.put(url, formData);
  }
  testChange(type, id, isTest) {
    let url = this.configUrl + 'update/test/data/?type=' + type + '&dataId=' + id + '&isTest=' + isTest;
    return this.http.put(url, {});
  }
  static #_ = this.ɵfac = function AdoptionManagementService_Factory(t) {
    return new (t || AdoptionManagementService)(_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵinject"](_angular_common_http__WEBPACK_IMPORTED_MODULE_1__.HttpClient));
  };
  static #_2 = this.ɵprov = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_2__["ɵɵdefineInjectable"]({
    token: AdoptionManagementService,
    factory: AdoptionManagementService.ɵfac,
    providedIn: 'root'
  });
}


/***/ }),

/***/ 32555:
/*!*****************************************************!*\
  !*** ./src/app/services/user-management.service.ts ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "UserManagementService": () => (/* binding */ UserManagementService)
/* harmony export */ });
/* harmony import */ var _angular_common_http__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/common/http */ 33765);
/* harmony import */ var _environments_environment__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../environments/environment */ 92340);
/* harmony import */ var rxjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! rxjs */ 80228);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/core */ 86839);
/* harmony import */ var _loader_service__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./loader.service */ 38555);
/* harmony import */ var app_core_auth_auth_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! app/core/auth/auth.service */ 88951);







class UserManagementService {
  constructor(http, loaderService, authService) {
    this.http = http;
    this.loaderService = loaderService;
    this.authService = authService;
    this.closeSidenavSource = new rxjs__WEBPACK_IMPORTED_MODULE_3__.Subject();
    this.closeSidenav$ = this.closeSidenavSource.asObservable();
    this.configUrl = _environments_environment__WEBPACK_IMPORTED_MODULE_0__.environment.apiUrl + 'admin/v1/super/admin/';
    this.adminId = sessionStorage.getItem('adminId');
    this.headers = {
      headers: new _angular_common_http__WEBPACK_IMPORTED_MODULE_4__.HttpHeaders({
        'Content-Type': 'multipart/form-data'
      })
    };
    // this.adminId = this.authService.adminId;
  }
  closeSidenav() {
    this.closeSidenavSource.next();
  }
  getPetParents(page) {
    // debugger
    let resultSize = 25;
    console.log(this.adminId);
    let url = `${this.configUrl}${this.adminId}/pet/parent/user?status&pageNumber=${page}&resultSize=${resultSize}`;
    return this.http.get(url);
    // this.configUrl + this.adminId + '/pet/parent/user?status&pageNumber=0&resultSize=25'
  }
  addPetParent(data) {
    let url = this.configUrl + this.adminId + '/pet/parent/user';
    return this.http.post(url, data);
  }
  deletePetParent(id) {
    let url = this.configUrl + this.adminId + '/pet/parent/user?petParentId=' + id;
    return this.http.delete(url);
  }
  updatePetParentById(data) {
    data = {
      "id": "34131c8a-374f-45c5-88e1-6e4e54bae299",
      "joinedDate": "10-Oct-2023 11:44:38 UTC",
      "mobile": "9545445550",
      "countryCode": "+91",
      "sos": false,
      "profileImage": "https://ap-south-1-bvur-dev-furrcrew.s3.ap-south-1.amazonaws.com/static/images/dog_image.png?X-Amz-Algorithm=AWS4-HMAC-SHA256&X-Amz-Date=20231026T050000Z&X-Amz-SignedHeaders=host&X-Amz-Expires=1799&X-Amz-Credential=AKIAQQBFJX7DRRSV7EVT%2F20231026%2Fap-south-1%2Fs3%2Faws4_request&X-Amz-Signature=1de002374baab2c130316d79172c27a4894982884a191a7a1230835f32713cb3",
      "verified": false,
      "emailVerified": false
    };
    let url = this.configUrl + this.adminId + '/pet/parent/user?petParentId=' + data['id'];
    return this.http.put(url, data);
  }
  addPetParentProfileImage(petParentId, image) {
    let url = this.configUrl + petParentId + '/pet/parent/user/image';
    let formData = new FormData();
    formData.append('file', image);
    return this.http.post(url, formData);
  }
  addPetProfileImage(userId, petId, image) {
    // https://api-dev.furrcrew.com/admin/v1/super/admin/e9a15e29-0a2a-45d1-9eb8-ec7757578e30/pet/b5469244-27ea-4adb-9a61-3f875e7f11a8/profile/image
    let url = this.configUrl + userId + '/pet/' + petId + '/profile/image';
    let formData = new FormData();
    formData.append('file', image);
    return this.http.post(url, formData);
  }
  addPet(petParentId, data) {
    let url = this.configUrl + 'user/' + petParentId + '/pets';
    // https://api-dev.furrcrew.com/admin/v1/super/admin/user/3dee4a35-7811-4a11-be35-03a6e76c8685/pets
    return this.http.post(url, data);
  }
  updatePet(petParentId, data) {
    let url = this.configUrl + 'user/' + petParentId + '/pets';
    return this.http.put(url, data);
  }
  deletePet(petId) {
    console.log(petId);
    // "/parent/pets/{petId}/details"
    let url = this.configUrl + '/parent/pets/' + petId + '/details';
    return this.http.delete(url);
  }
  getAllPetsByPetParent(petparentId) {
    // petparentId = '34131c8a-374f-45c5-88e1-6e4e54bae299';
    let url = this.configUrl + 'user/' + petparentId + '/pets';
    return this.http.get(url);
  }
  registerCollaborators(data, adminId) {
    adminId = this.adminId;
    let url = this.configUrl + adminId + '/collaborator/register';
    return this.http.post(url, data);
  }
  getCollaboratorsByType(type) {
    // https://api.furrcrew.com/admin/v1/super/admin/1/collaborators?type=Grooming
    let url = this.configUrl + this.adminId + '/collaborators?type=' + type;
    return this.http.get(url);
  }
  getCollaboratorsById(adminId, collaboratorId) {
    adminId = this.adminId;
    let url = this.configUrl + adminId + "/collaborator/" + collaboratorId + "/profile";
    return this.http.get(url);
  }
  updateCollaboratorById(adminId, data) {
    let collaboratorId = data["id"];
    let url = this.configUrl + this.adminId + '/collaborator/' + collaboratorId + '/profile';
    return this.http.put(url, data);
  }
  deleteCollaborator(partnerId) {
    let url = this.configUrl + this.adminId + '/collaborators?collaboratorId=' + partnerId;
    return this.http.delete(url);
  }
  addCollaboratorProfile(collaboratorId, image) {
    let url = this.configUrl + "collaborator/" + collaboratorId + "/profile/image";
    let formDta = new FormData();
    formDta.append('file', image);
    return this.http.post(url, formDta);
  }
  updatePetParent(data) {
    // let url = this.configUrl + this.adminId + '/pet/parent/user?petParentId=' + data['id'] ;
    let url = `${this.configUrl}${this.adminId}/pet/parent/user?petParentId=${data['id']}`;
    return this.http.put(url, data);
  }
  getPetPArents() {
    return new Promise((resolve, reject) => {
      this.getPetParents(1).subscribe(res => {
        resolve(res);
      });
    });
  }
  getAppointmentsHistoryByPetParentId(petId) {
    // https://api-dev.furrcrew.com/admin/v1/super/admin/pet/parents/appointments?petId=1367972f-8fe3-40a4-b526-fd9a52cf7f44
    let url = this.configUrl + 'pet/parents/appointments?petId=' + petId;
    return this.http.get(url);
  }
  testChange(status, active, userId) {
    let url = this.configUrl + 'test/user?createdBy=' + this.adminId;
    let body = {
      'status': status,
      'active': active,
      'userId': userId
    };
    return this.http.put(url, body);
  }
  getAddressesOfPet(petParentId) {
    let url = this.configUrl + this.adminId + '/pet/parent/' + petParentId + '/address';
    return this.http.get(url);
  }
  deleteAddress(petParentId, addressId) {
    let url = this.configUrl + this.adminId + '/pet/parent/' + petParentId + '/address?addressId=' + addressId;
    return this.http.delete(url);
  }
  updateAddress(petParentId, addressId, body) {
    let url = this.configUrl + this.adminId + '/pet/parent/' + petParentId + '/address?addressId=' + addressId;
    return this.http.put(url, body);
  }
  addAddress(petParentId, body) {
    let url = this.configUrl + this.adminId + '/pet/parent/' + petParentId + '/address';
    return this.http.post(url, body);
  }
  static #_ = this.ɵfac = function UserManagementService_Factory(t) {
    return new (t || UserManagementService)(_angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵinject"](_angular_common_http__WEBPACK_IMPORTED_MODULE_4__.HttpClient), _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵinject"](_loader_service__WEBPACK_IMPORTED_MODULE_1__.LoaderService), _angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵinject"](app_core_auth_auth_service__WEBPACK_IMPORTED_MODULE_2__.AuthService));
  };
  static #_2 = this.ɵprov = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_5__["ɵɵdefineInjectable"]({
    token: UserManagementService,
    factory: UserManagementService.ɵfac,
    providedIn: 'root'
  });
}


/***/ })

}]);
//# sourceMappingURL=default-src_app_services_adoption-management_service_ts-src_app_services_user-management_service_ts.js.map