"use strict";
(self["webpackChunkadmin_panel"] = self["webpackChunkadmin_panel"] || []).push([["common"],{

/***/ 75129:
/*!************************************************************!*\
  !*** ./src/app/services/appointment-management.service.ts ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AppointmentManagementService": () => (/* binding */ AppointmentManagementService)
/* harmony export */ });
/* harmony import */ var environments_environment__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! environments/environment */ 92340);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ 86839);
/* harmony import */ var _angular_common_http__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/common/http */ 33765);



class AppointmentManagementService {
  constructor(http) {
    this.http = http;
    this.configUrl = environments_environment__WEBPACK_IMPORTED_MODULE_0__.environment.apiUrl + 'admin/v1/super/admin/';
    this.adminId = sessionStorage.getItem('adminId');
  }
  createAppointment(data, collaboratorId) {
    // collaboratorId = "64fe4ab2-34cb-4cf1-9272-3b95a801dcaf";
    console.log(data['workspaceId']);
    let url = this.configUrl + 'create/appointment?workspaceId=' + data['workspaceId'] + '&collaboratorId=' + collaboratorId;
    return this.http.post(url, data);
  }
  updateAppointment(data, collaboratorId) {
    let url = this.configUrl + 'create/appointment?workspaceId=' + data['workspaceId'] + '&collaboratorId=' + collaboratorId;
    ;
    return this.http.put(url, data);
  }
  getAppointment() {
    // petParentId = '8db18ed7-d0db-4775-8175-075067d1147a';
    // petId = 'fc57116b-bcec-4a51-82e7-4469abf15e28';
    // status = 'Created/Processing/Cancelled/Active/Completed';
    let url = this.configUrl + 'pet/parents/appointments/'; //?petParentId=' + petParentId + '&petId=' + petId + '&status=' + status
    return this.http.get(url);
  }
  deleteAppointment(id) {
    // https://api-dev.furrcrew.com/admin/v1/super/admin/pet/parents/appointments?appointmentId=3a9bc15a-825a-4565-9f10-14589f69d842
    let url = this.configUrl + 'pet/parents/appointments?appointmentId=' + id;
    return this.http.delete(url);
  }
  getAddress(userId, petParentId) {
    let url = this.configUrl + userId + "/pet/parent/" + petParentId + "/address";
    return this.http.get(url);
  }
  editAddress(id, petParentId, body) {
    let url = this.configUrl + id + "/pet/parent/" + petParentId + "/address?addressId=" + body['id'];
    return this.http.put(url, body);
  }
  addAddress(id, petParentId, body) {
    let url = this.configUrl + id + '/pet/parent/' + petParentId + '/address';
    return this.http.post(url, body);
  }
  getBookedAppointment(workspaceId, petParentId) {
    let url = this.configUrl + "booked/appointments?workplaceId=" + workspaceId + "&userId=" + petParentId;
    return this.http.get(url);
  }
  getAppointmentByPetId(petId) {
    // https://api-dev.furrcrew.com/admin/v1/super/admin/pet/parents/appointments?petId=e195dfbc-869a-4133-b034-8f7ccc09e34c
    let url = this.configUrl + 'pet/parents/appointments?petId=' + petId;
    return this.http.get(url);
  }
  static #_ = this.ɵfac = function AppointmentManagementService_Factory(t) {
    return new (t || AppointmentManagementService)(_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵinject"](_angular_common_http__WEBPACK_IMPORTED_MODULE_2__.HttpClient));
  };
  static #_2 = this.ɵprov = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineInjectable"]({
    token: AppointmentManagementService,
    factory: AppointmentManagementService.ɵfac,
    providedIn: 'root'
  });
}


/***/ }),

/***/ 45064:
/*!***********************************************!*\
  !*** ./src/app/services/time-date.service.ts ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "TimeDateService": () => (/* binding */ TimeDateService)
/* harmony export */ });
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! moment */ 56908);
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(moment__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ 86839);


class TimeDateService {
  constructor() {}
  getNext5WorkingDays(workingDaysList) {
    const workingDays = [];
    const today = new Date();
    let count = 0; // Start from tomorrow
    while (workingDays.length < 5) {
      const nextDay = new Date(today);
      nextDay.setDate(today.getDate() + count);
      const dayOfWeek = nextDay.toLocaleString('en-US', {
        weekday: 'short'
      });
      const isWorkingDay = workingDaysList.includes(dayOfWeek);
      if (isWorkingDay) {
        const dayOfMonth = nextDay.getDate();
        const formattedDate = `${dayOfMonth < 10 ? '0' + dayOfMonth : dayOfMonth}`;
        workingDays.push({
          name: `${formattedDate} ${dayOfWeek}`,
          value: this.removeTimeFromDate(nextDay).toDateString()
        });
      }
      count++;
    }
    return workingDays;
  }
  getDayOfWeekFromString(dayString) {
    const daysOfWeek = {
      'Sun': 0,
      'Mon': 1,
      'Tue': 2,
      'Wed': 3,
      'Thu': 4,
      'Fri': 5,
      'Sat': 6
    };
    return daysOfWeek[dayString] !== undefined ? daysOfWeek[dayString] : null;
  }
  getTimeSlots(startTime, endTime, breakStartTime, breakEndTime) {
    const timeSlots = [];
    const start = new Date(`2024-01-01 ${startTime}`);
    const end = new Date(`2024-01-01 ${endTime}`);
    const breakStart = new Date(`2024-01-01 ${breakStartTime}`);
    const breakEnd = new Date(`2024-01-01 ${breakEndTime}`);
    const thirtyMinutes = 30 * 60 * 1000; // 30 minutes in milliseconds
    let currentTime = start.getTime();
    while (currentTime < end.getTime()) {
      const slotTime = new Date(currentTime);
      // Check if the slot falls within the break time range
      if (!(slotTime >= breakStart && slotTime < breakEnd)) {
        const hours = (slotTime.getHours() % 12 || 12).toString().padStart(2, '0'); // 12-hour format
        const period = slotTime.getHours() >= 12 ? 'PM' : 'AM'; // Get period (AM or PM)
        const minutes = slotTime.getMinutes().toString().padStart(2, '0');
        timeSlots.push({
          name: `${hours}:${minutes} ${period}`,
          value: `${hours}:${minutes} ${period}`
        });
      }
      currentTime += thirtyMinutes;
    }
    return timeSlots;
  }
  dateTimeToMilliseconds(date, startTime) {
    // Assuming time is in format 'h:mm A'
    const startDateTime = moment__WEBPACK_IMPORTED_MODULE_0___default()(date).set({
      hour: moment__WEBPACK_IMPORTED_MODULE_0___default()(startTime, 'h:mm A').hours(),
      minute: moment__WEBPACK_IMPORTED_MODULE_0___default()(startTime, 'h:mm A').minutes()
    });
    const endDateTime = startDateTime.clone().add(30, 'minutes'); // Adding 30 minutes to start time
    const startTimeMillis = startDateTime.valueOf();
    const endTimeMillis = endDateTime.valueOf();
    return {
      startTime: startTimeMillis,
      endTime: endTimeMillis
    };
  }
  millisecondsToDateTime(milliseconds) {
    const dateTime = new Date(milliseconds);
    // const date = new Date(dateTime.format('YYYY-MM-DD'));
    const date = this.removeTimeFromDate(moment__WEBPACK_IMPORTED_MODULE_0___default()(dateTime).toDate());
    const time = moment__WEBPACK_IMPORTED_MODULE_0___default()(dateTime).format('hh:mm A');
    const formattedDate = date.toLocaleDateString('en-US', {
      weekday: 'short',
      day: '2-digit'
    });
    return {
      date,
      time
    };
  }
  dateToMilliseconds(date) {
    return moment__WEBPACK_IMPORTED_MODULE_0___default()(date).valueOf();
  }
  removeTimeFromDate(date) {
    const newDate = new Date(date);
    newDate.setHours(0, 0, 0, 0); // Set hours, minutes, seconds, and milliseconds to zero
    return newDate;
  }
  convertUTCToIST(utcMilliseconds) {
    const utcDate = new Date(utcMilliseconds);
    // Get UTC offset in minutes
    const utcOffset = utcDate.getTimezoneOffset();
    // IST offset is 5 hours and 30 minutes ahead of UTC
    const istOffset = -330; // -5 hours * 60 minutes + -30 minutes
    // Convert UTC milliseconds to IST milliseconds
    const istMilliseconds = utcMilliseconds + (utcOffset + istOffset) * 60000;
    return istMilliseconds;
  }
  static #_ = this.ɵfac = function TimeDateService_Factory(t) {
    return new (t || TimeDateService)();
  };
  static #_2 = this.ɵprov = /*@__PURE__*/_angular_core__WEBPACK_IMPORTED_MODULE_1__["ɵɵdefineInjectable"]({
    token: TimeDateService,
    factory: TimeDateService.ɵfac,
    providedIn: 'root'
  });
}


/***/ })

}]);
//# sourceMappingURL=common.js.map